<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:str="http://exslt.org/strings"
    xmlns:func="http://exslt.org/functions"
    xmlns:gsa="http://openvas.org"
    xmlns:gsa-i18n="http://openvas.org/i18n"
    xmlns:vuln="http://scap.nist.gov/schema/vulnerability/0.4"
    xmlns:cpe-lang="http://cpe.mitre.org/language/2.0"
    xmlns:scap-core="http://scap.nist.gov/schema/scap-core/0.1"
    xmlns:cve="http://scap.nist.gov/schema/feed/vulnerability/2.0"
    xmlns:cvss="http://scap.nist.gov/schema/cvss-v2/0.2"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:patch="http://scap.nist.gov/schema/patch/0.1"
    xmlns:meta="http://scap.nist.gov/schema/cpe-dictionary-metadata/0.2"
    xmlns:ns6="http://scap.nist.gov/schema/scap-core/0.1"
    xmlns:config="http://scap.nist.gov/schema/configuration/0.1"
    xmlns:cpe="http://cpe.mitre.org/dictionary/2.0"
    xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5"
    xmlns:oval_definitions="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:dfncert="http://www.dfn-cert.de/dfncert.dtd"
    xmlns:atom="http://www.w3.org/2005/Atom"
    xsi:schemaLocation="http://scap.nist.gov/schema/configuration/0.1 http://nvd.nist.gov/schema/configuration_0.1.xsd http://scap.nist.gov/schema/scap-core/0.3 http://nvd.nist.gov/schema/scap-core_0.3.xsd http://cpe.mitre.org/dictionary/2.0 http://cpe.mitre.org/files/cpe-dictionary_2.2.xsd http://scap.nist.gov/schema/scap-core/0.1 http://nvd.nist.gov/schema/scap-core_0.1.xsd http://scap.nist.gov/schema/cpe-dictionary-metadata/0.2 http://nvd.nist.gov/schema/cpe-dictionary-metadata_0.2.xsd"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:exslt="http://exslt.org/common"
    extension-element-prefixes="str func date exslt gsa gsa-i18n">
    <xsl:output
      method="html"
      doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
      doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
      encoding="UTF-8"/>

<!--
Greenbone Security Assistant
$Id$
Description: OpenVAS Manager Protocol (OMP) stylesheet

Authors:
Matthew Mundell <matthew.mundell@greenbone.net>
Jan-Oliver Wagner <jan-oliver.wagner@greenbone.net>
Michael Wiegand <michael.wiegand@greenbone.net>
Timo Pollmeier <timo.pollmeier@greenbone.net>

Copyright:
Copyright (C) 2009-2014 Greenbone Networks GmbH

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
-->


<!-- BEGIN GLOBAL VARIABLES -->

<xsl:variable name="icon-width" select="19"/>
<xsl:variable name="trash-actions-width" select="3 + (2 * $icon-width)"/>


<!-- BEGIN XPATH FUNCTIONS -->

<func:function name="gsa:envelope-filter">
  <xsl:choose>
    <xsl:when test="string-length (/envelope/params/filter) &gt; 0 and string-length (/envelope/params/filter_extra) &gt; 0">
      <func:result select="concat (/envelope/params/filter, ' ', /envelope/params/filter_extra)"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="concat (/envelope/params/filter, /envelope/params/filter_extra)"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:may">
  <xsl:param name="name"/>
  <xsl:param name="permissions" select="permissions"/>
  <func:result select="gsa:may-op ($name) and (boolean ($permissions/permission[name='Everything']) or boolean ($permissions/permission[name=$name]))"/>
</func:function>

<xsl:variable name="capabilities" select="/envelope/capabilities/help_response/schema"/>

<func:function name="gsa:may-op">
  <xsl:param name="name"/>
  <func:result select="boolean ($capabilities/command[gsa:lower-case (name) = gsa:lower-case ($name)])"/>
</func:function>

<func:function name="gsa:may-clone">
  <xsl:param name="type"/>
  <xsl:param name="owner" select="owner"/>
  <func:result select="gsa:may-op (concat ('create_', $type))"/>
</func:function>

<func:function name="gsa:may-get-trash">
  <func:result select="boolean ($capabilities/command[substring (gsa:lower-case (name), 1, 4) = 'get_' and gsa:lower-case (name) != 'get_version' and gsa:lower-case (name) != 'get_info' and gsa:lower-case (name) != 'get_nvts' and gsa:lower-case (name) != 'get_system_reports'  and gsa:lower-case (name) != 'get_settings'])"/>
</func:function>

<func:function name="gsa:build-levels">
  <xsl:param name="filters"></xsl:param>
  <func:result>
    <xsl:for-each select="$filters/filter">
      <xsl:choose>
        <xsl:when test="text()='High'">h</xsl:when>
        <xsl:when test="text()='Medium'">m</xsl:when>
        <xsl:when test="text()='Low'">l</xsl:when>
        <xsl:when test="text()='Log'">g</xsl:when>
        <xsl:when test="text()='False Positive'">f</xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </func:result>
</func:function>

<func:function name="gsa:join">
  <xsl:param name="nodes"/>
  <func:result>
    <xsl:for-each select="$nodes">
      <xsl:value-of select="name"/>
      <xsl:text> </xsl:text>
    </xsl:for-each>
  </func:result>
</func:function>

<func:function name="gsa:actions-width">
  <xsl:param name="icon-count"/>
  <func:result select="3 + ($icon-count * $icon-width)"/>
</func:function>

<func:function name="gsa:token">
  <xsl:choose>
    <xsl:when test="string-length (/envelope/params/debug) = 0">
      <func:result select="concat ('&amp;token=', /envelope/token)"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="concat ('&amp;token=', /envelope/token, '&amp;debug=', /envelope/params/debug)"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:capitalise">
  <xsl:param name="string"/>
  <func:result select="concat (gsa:upper-case (substring ($string, 1, 1)), substring ($string, 2))"/>
</func:function>

<func:function name="gsa:lower-case">
  <xsl:param name="string"/>
  <func:result select="translate($string, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
</func:function>

<func:function name="gsa:upper-case">
  <xsl:param name="string"/>
  <func:result select="translate($string, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
</func:function>

<func:function name="gsa:escape-js">
  <xsl:param name="string"/>
  <xsl:variable name='apos'>'</xsl:variable>
  <!-- Escape as XML entities where applicable -->
  <func:result select="str:replace (str:replace (str:replace (str:replace (str:replace (str:replace (
                       $string, '&amp;', '&amp;amp;'), '\', '\x2F'), '&quot;', '&amp;quot;'), $apos, '&amp;apos;'), '&lt;', '&amp;lt;'), '&gt;', '&amp;gt;')"/>
</func:function>

<func:function name="gsa:date-tz">
  <xsl:param name="time"></xsl:param>
  <func:result>
    <!-- 2013-03-26T13:15:00-04:00 -->
    <!-- 2013-03-26T13:15:00Z -->
    <!-- 2013-03-26T13:15:00+04:00 -->
    <xsl:variable name="length" select="string-length ($time)"/>
    <xsl:if test="$length &gt; 0">
      <xsl:choose>
        <xsl:when test="substring ($time, $length) = 'Z'">
          <xsl:value-of select="'UTC'"/>
        </xsl:when>
        <xsl:when test="contains ('+-', substring ($time, $length - 5, 1)) and (substring ($time, $length - 2, 1) = ':')">
          <xsl:value-of select="substring ($time, $length - 5)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'ERROR'"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </func:result>
</func:function>

<func:function name="gsa:long-time-tz">
  <xsl:param name="time"></xsl:param>
  <func:result>
    <xsl:if test="string-length ($time) &gt; 0">
      <xsl:value-of select="concat (date:day-abbreviation ($time), ' ', date:month-abbreviation ($time), ' ', date:day-in-month ($time), ' ', format-number(date:hour-in-day($time), '00'), ':', format-number(date:minute-in-hour($time), '00'), ':', format-number(date:second-in-minute($time), '00'), ' ', date:year($time), ' ', gsa:date-tz($time))"/>
    </xsl:if>
  </func:result>
</func:function>

<func:function name="gsa:long-time">
  <xsl:param name="time"></xsl:param>
  <func:result>
    <xsl:if test="string-length ($time) &gt; 0">
      <xsl:value-of select="concat (date:day-abbreviation ($time), ' ', date:month-abbreviation ($time), ' ', date:day-in-month ($time), ' ', format-number(date:hour-in-day($time), '00'), ':', format-number(date:minute-in-hour($time), '00'), ':', format-number(date:second-in-minute($time), '00'), ' ', date:year($time))"/>
    </xsl:if>
  </func:result>
</func:function>

<func:function name="gsa:date">
  <xsl:param name="datetime"></xsl:param>
  <func:result>
    <xsl:if test="string-length ($datetime) &gt; 0">
      <xsl:value-of select="concat (date:day-abbreviation ($datetime), ' ', date:month-abbreviation ($datetime), ' ', date:day-in-month ($datetime), ' ', date:year($datetime))"/>
    </xsl:if>
  </func:result>
</func:function>

<func:function name="gsa:type-many">
  <xsl:param name="type"></xsl:param>
  <func:result>
    <xsl:choose>
      <xsl:when test="$type = 'info' or $type = 'allinfo'">
        <xsl:value-of select="$type"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$type"/><xsl:text>s</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </func:result>
</func:function>

<func:function name="gsa:html-attribute-quote">
  <xsl:param name="text"/>
  <func:result>
    <xsl:value-of select="translate ($text, '&quot;', '&amp;quot;')"/>
  </func:result>
</func:function>

<!-- This is only safe for HTML attributes. -->
<func:function name="gsa:param-or">
  <xsl:param name="name"/>
  <xsl:param name="alternative"/>
  <xsl:choose>
    <xsl:when test="/envelope/params/node()[name()=$name]">
      <func:result>
        <xsl:value-of select="gsa:html-attribute-quote (/envelope/params/node()[name()=$name])"/>
      </func:result>
    </xsl:when>
    <xsl:when test="/envelope/params/_param[name=$name]">
      <func:result>
        <xsl:value-of select="gsa:html-attribute-quote (/envelope/params/_param[name=$name]/value)"/>
      </func:result>
    </xsl:when>
    <xsl:otherwise>
      <func:result>
        <xsl:value-of select="$alternative"/>
      </func:result>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:get-nvt-tag">
    <xsl:param name="tags"/>
    <xsl:param name="name"/>
  <xsl:variable name="after">
    <xsl:value-of select="substring-after (nvt/tags, concat ($name, '='))"/>
  </xsl:variable>
  <xsl:choose>
      <xsl:when test="contains ($after, '|')">
        <func:result select="substring-before ($after, '|')"/>
      </xsl:when>
      <xsl:otherwise>
        <func:result select="$after"/>
      </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:cvss-risk-factor">
  <xsl:param name="cvss_score"/>
  <xsl:variable name="type" select="/envelope/severity"/>
  <xsl:variable name="threat">
    <xsl:choose>
      <xsl:when test="$type = 'classic'">
        <xsl:choose>
          <xsl:when test="$cvss_score = 0.0">Log</xsl:when>
          <xsl:when test="$cvss_score &gt;= 0.1 and $cvss_score &lt;= 2.0">Low</xsl:when>
          <xsl:when test="$cvss_score &gt;= 2.1 and $cvss_score &lt;= 5.0">Medium</xsl:when>
          <xsl:when test="$cvss_score &gt;= 5.1 and $cvss_score &lt;= 8.0">High</xsl:when>
          <xsl:when test="$cvss_score &gt;= 8.1 and $cvss_score &lt;= 10.0">High</xsl:when>
          <xsl:otherwise>None</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$type = 'pci-dss'">
        <xsl:choose>
          <xsl:when test="$cvss_score &gt;= 0.0 and $cvss_score &lt; 4.0">Log</xsl:when>
          <xsl:when test="$cvss_score &gt;= 4.0">High</xsl:when>
          <xsl:otherwise>None</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- Default to nist/bsi -->
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$cvss_score = 0.0">Log</xsl:when>
          <xsl:when test="$cvss_score &gt;= 0.1 and $cvss_score &lt;= 3.9">Low</xsl:when>
          <xsl:when test="$cvss_score &gt;= 4.0 and $cvss_score &lt;= 6.9">Medium</xsl:when>
          <xsl:when test="$cvss_score &gt;= 7.0 and $cvss_score &lt;= 10.0">High</xsl:when>
          <xsl:otherwise>None</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <func:result select="$threat"/>
</func:function>

<func:function name="gsa:result-cvss-risk-factor">
  <xsl:param name="cvss_score"/>
  <xsl:variable name="threat">
    <xsl:choose>
      <xsl:when test="$cvss_score &gt; 0.0">
        <xsl:value-of select="gsa:cvss-risk-factor($cvss_score)"/>
      </xsl:when>
      <xsl:when test="$cvss_score = 0.0">Log</xsl:when>
      <xsl:when test="$cvss_score = -1.0">False Positive</xsl:when>
      <xsl:when test="$cvss_score = -2.0">Debug</xsl:when>
      <xsl:when test="$cvss_score = -3.0">Error</xsl:when>
      <xsl:otherwise>N/A</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <func:result select="$threat"/>
</func:function>

<func:function name="gsa:risk-factor-max-cvss">
  <xsl:param name="threat"/>
  <xsl:param name="type"><xsl:value-of select="/envelope/severity"/></xsl:param>
  <xsl:variable name="cvss">
    <xsl:choose>
      <xsl:when test="$type = 'classic'">
        <xsl:choose>
          <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'log'">0.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'low'">2.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'medium'">5.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'high'">10.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'critical'">10.0</xsl:when>
          <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>

      <xsl:when test="$type = 'pci-dss'">
        <xsl:choose>
          <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'log'">3.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'low'">3.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'medium'">3.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'high'">10.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'critical'">10.0</xsl:when>
          <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- Default to nist/bsi -->
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'log'">0.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'low'">3.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'medium'">6.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'high'">10.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'critical'">10.0</xsl:when>
          <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <func:result select="$cvss"/>
</func:function>

<func:function name="gsa:risk-factor-min-cvss">
  <xsl:param name="threat"/>
  <xsl:param name="type"><xsl:value-of select="/envelope/severity"/></xsl:param>
  <xsl:variable name="cvss">
    <xsl:choose>
      <xsl:when test="$type = 'classic'">
        <xsl:choose>
          <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'log'">0.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'low'">0.1</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'medium'">2.1</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'high'">5.1</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'critical'">10.0</xsl:when>
          <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>

      <xsl:when test="$type = 'pci-dss'">
        <xsl:choose>
          <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'none'">0.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'low'">3.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'medium'">3.9</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'high'">4.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'critical'">10.0</xsl:when>
          <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- Default to nist/bsi -->
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'log'">0.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'low'">0.1</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'medium'">4.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'high'">7.0</xsl:when>
          <xsl:when test="gsa:lower-case($threat) = 'critical'">10.0</xsl:when>
          <xsl:otherwise>0.0</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <func:result select="$cvss"/>
</func:function>

<func:function name="gsa:threat-color">
  <xsl:param name="threat"/>
  <xsl:variable name="color">
    <xsl:choose>
      <xsl:when test="gsa:lower-case($threat) = 'high'">red</xsl:when>
      <xsl:when test="gsa:lower-case($threat) = 'medium'">orange</xsl:when>
      <xsl:when test="gsa:lower-case($threat) = 'low'">lightskyblue</xsl:when>
      <xsl:when test="gsa:lower-case($threat) = 'none' or gsa:lower-case($threat) = 'log'">silver</xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <func:result select="$color"/>
</func:function>

<func:function name="gsa:column-filter-name">
  <xsl:param name="type"/>
  <func:result select="str:replace (str:replace (gsa:lower-case ($type), '&#xa0;', '_'), ' ', '_')"/>
</func:function>

<func:function name="gsa:type-string">
  <xsl:param name="type"/>
  <func:result select="str:replace (gsa:lower-case ($type), ' ', '_')"/>
</func:function>

<func:function name="gsa:command-type-plural">
  <xsl:param name="command"/>
  <xsl:variable name="type"
                select="gsa:command-type ($command)"/>
  <xsl:choose>
    <xsl:when test="$type = 'NVT family'">
      <func:result select="'NVT families'"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="concat ($type, 's')"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:command-type">
  <xsl:param name="command"/>
  <xsl:variable name="after"
                select="substring-after (str:replace (gsa:lower-case ($command), '_', ' '), ' ')"/>
  <xsl:variable name="type">
    <xsl:choose>
      <xsl:when test="substring ($after, string-length ($after)) = 's'">
        <xsl:value-of select="substring ($after, 1, string-length ($after) - 1)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$after"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$type = 'lsc credential'">
      <func:result select="'credential'"/>
    </xsl:when>
    <xsl:when test="$type = 'config'">
      <func:result select="'scan config'"/>
    </xsl:when>
    <xsl:when test="$type = 'nvt'">
      <func:result select="'NVT'"/>
    </xsl:when>
    <xsl:when test="$type = 'nvt familie'">
      <func:result select="'NVT family'"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="$type"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:join-capital">
  <xsl:param name="nodes"/>
  <func:result>
    <xsl:for-each select="$nodes">
      <xsl:value-of select="gsa:capitalise (text ())"/>
      <xsl:if test="position() != last()">
        <xsl:text> </xsl:text>
      </xsl:if>
    </xsl:for-each>
  </func:result>
</func:function>

<func:function name="gsa:type-name">
  <xsl:param name="type"/>
  <xsl:choose>
    <xsl:when test="$type = 'nvt' or $type = 'cve' or $type = 'cpe'">
      <func:result select="gsa:upper-case ($type)"/>
    </xsl:when>
    <xsl:when test="$type = 'ovaldef'">
      <func:result select="'OVAL Definition'"/>
    </xsl:when>
    <xsl:when test="$type = 'cert_bund_adv'">
      <func:result select="'CERT-Bund Advisory'"/>
    </xsl:when>
    <xsl:when test="$type = 'dfn_cert_adv'">
      <func:result select="'DFN-CERT Advisory'"/>
    </xsl:when>
    <xsl:when test="$type = 'allinfo'">
      <func:result select="'All SecInfo'"/>
    </xsl:when>
    <xsl:when test="$type = 'lsc_credential'">
      <func:result select="'Credential'"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="gsa:join-capital (str:split ($type, '_'))"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:type-name-plural">
  <xsl:param name="type"/>
  <xsl:choose>
    <xsl:when test="$type = 'cert_bund_adv'">
      <func:result select="'CERT-Bund Advisories'"/>
    </xsl:when>
    <xsl:when test="$type = 'dfn_cert_adv'">
      <func:result select="'DFN-CERT Advisories'"/>
    </xsl:when>
    <xsl:when test="$type = 'allinfo'">
      <func:result select="'All SecInfo'"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="concat(gsa:type-name ($type), 's')"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:field-name">
  <xsl:param name="field"/>
  <xsl:choose>
    <xsl:when test="$field = 'created'">
      <func:result select="'creation time'"/>
    </xsl:when>
    <xsl:when test="$field = 'modified'">
      <func:result select="'modification time'"/>
    </xsl:when>
    <xsl:when test="$field = 'qod'">
      <func:result select="'QoD'"/>
    </xsl:when>
    <xsl:when test="$field = 'qod_type'">
      <func:result select="'QoD type'"/>
    </xsl:when>
    <xsl:otherwise>
      <func:result select="translate ($field, '_', ' ')"/>
    </xsl:otherwise>
  </xsl:choose>
</func:function>

<func:function name="gsa:alert-in-trash">
  <xsl:for-each select="alert">
    <xsl:if test="trash/text() != '0'">
      <func:result>1</func:result>
    </xsl:if>
  </xsl:for-each>
  <func:result>0</func:result>
</func:function>

<func:function name="gsa:table-row-class">
  <xsl:param name="position"/>
  <func:result>
    <xsl:choose>
      <xsl:when test="$position &lt; 0"></xsl:when>
      <xsl:when test="$position mod 2 = 0">even</xsl:when>
      <xsl:otherwise>odd</xsl:otherwise>
    </xsl:choose>
  </func:result>
</func:function>

<func:function name="gsa:date-diff">
  <xsl:param name="start"/>
  <xsl:param name="end"/>

  <xsl:variable name="difference" select="date:difference ($start, $end)"/>
  <xsl:variable name="fromepoch"
                select="date:add ('1970-01-01T00:00:00Z', $difference)"/>
  <xsl:variable name="seconds"
                select="date:second-in-minute($fromepoch)"/>
  <xsl:variable name="minutes"
                select="date:minute-in-hour($fromepoch)"/>
  <xsl:variable name="hours"
                select="date:hour-in-day($fromepoch)"/>
  <xsl:variable name="days"
                select="date:day-in-year($fromepoch) - 1"/>
  <func:result>
      <xsl:if test="$days">
          <xsl:value-of select="concat ($days, ' ', gsa:i18n ('days', 'Time'),' ')"/>
      </xsl:if>
      <xsl:if test="$hours">
          <xsl:value-of select="concat ($hours, ' ', gsa:i18n ('hours', 'Time'),' ')"/>
      </xsl:if>
      <xsl:if test="$minutes">
          <xsl:value-of select="concat ($minutes, ' ', gsa:i18n ('minutes', 'Time'),' ')"/>
      </xsl:if>
      <xsl:if test="$seconds">
          <xsl:value-of select="concat ($seconds, ' ', gsa:i18n ('seconds', 'Time'),' ')"/>
      </xsl:if>
  </func:result>
</func:function>

<func:function name="gsa:report-host-has-os">
  <xsl:param name="report"/>
  <xsl:param name="ip"/>
  <xsl:param name="os"/>
  <func:result>
    <xsl:choose>
      <xsl:when test="$report/host[ip = $ip and detail/name = 'best_os_cpe' and detail/value = $os]">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </func:result>
</func:function>

<func:function name="gsa:host-has-unknown-os">
  <xsl:param name="report"/>
  <xsl:param name="ip"/>
  <func:result>
    <xsl:choose>
      <xsl:when test="$report/host[ip = $ip and ((detail/name = 'best_os_cpe') = 0)]">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </func:result>
</func:function>

<func:function name="gsa:report-section-title">
  <xsl:param name="section"/>
  <xsl:param name="type"/>
  <func:result>
    <xsl:choose>
      <xsl:when test="$section = 'results' and $type = 'prognostic'"><xsl:value-of select="gsa:i18n ('Report: Prognostic Results', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'results' and $type = 'delta'"><xsl:value-of select="gsa:i18n ('Report: Delta Results', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'results'"><xsl:value-of select="gsa:i18n ('Report: Results', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'summary' and $type = 'prognostic'"><xsl:value-of select="gsa:i18n ('Report: Prognostic Summary and Download', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'summary' and $type = 'delta'"><xsl:value-of select="gsa:i18n ('Report: Delta Summary and Download', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'summary'"><xsl:value-of select="gsa:i18n ('Report: Summary and Download', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'hosts' and $type = 'prognostic'"><xsl:value-of select="gsa:i18n ('Report: Prognostic Hosts', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'hosts'"><xsl:value-of select="gsa:i18n ('Report: Hosts', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'ports'"><xsl:value-of select="gsa:i18n ('Report: Ports', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'os'"><xsl:value-of select="gsa:i18n ('Report: Operating Systems', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'apps' and $type = 'prognostic'"><xsl:value-of select="gsa:i18n ('Report: Prognostic Applications', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'apps'"><xsl:value-of select="gsa:i18n ('Report: Applications', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'vulns'"><xsl:value-of select="gsa:i18n ('Report: Vulnerabilities', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'cves'"><xsl:value-of select="gsa:i18n ('Report: CVEs', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'closed_cves'"><xsl:value-of select="gsa:i18n ('Report: Closed CVEs', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'topology'"><xsl:value-of select="gsa:i18n ('Report: Topology', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'ssl_certs'"><xsl:value-of select="gsa:i18n ('Report: SSL Certificates', 'Report Section')"/></xsl:when>
      <xsl:when test="$section = 'errors'"><xsl:value-of select="gsa:i18n ('Report: Error Messages', 'Report Section')"/></xsl:when>
    </xsl:choose>
  </func:result>
</func:function>

<func:function name="gsa:has-long-word">
  <xsl:param name="string"/>
  <xsl:param name="max" select="44"/>
  <func:result select="count (str:split ($string, ' ')[string-length (.) &gt; $max]) &gt; 0"/>
</func:function>

<func:function name="gsa:permission-description">
  <xsl:param name="name"/>
  <xsl:param name="resource"/>
  <xsl:variable name="lower" select="gsa:lower-case ($name)"/>
  <xsl:variable name="has-resource" select="boolean ($resource) and string-length ($resource/type) &gt; 0"/>
  <func:result>
    <xsl:choose>
      <xsl:when test="$has-resource and $lower = 'super'">
        <xsl:value-of select="gsa:i18n ('has super access to ', 'Permission Description')"/>
        <xsl:value-of select="gsa:i18n (gsa:command-type ($lower), 'Type Lower')"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$resource/type"/>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$resource/name"/>
      </xsl:when>
      <xsl:when test="$lower = 'super'">
        <xsl:value-of select="gsa:i18n ('has super access to all users', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'authenticate'">
        <xsl:value-of select="gsa:i18n ('may login', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'commands'">
        <xsl:value-of select="gsa:i18n ('may run multiple OMP commands in one', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'everything'">
        <xsl:value-of select="gsa:i18n ('has all permissions', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'empty_trashcan'">
        <xsl:value-of select="gsa:i18n ('may empty the trashcan', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'get_dependencies'">
        <xsl:value-of select="gsa:i18n ('may get the dependencies of NVTs', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'get_nvt_feed_version'">
        <xsl:value-of select="gsa:i18n ('may get NVT feed version information', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'get_version'">
        <xsl:value-of select="gsa:i18n ('may get version information', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'help'">
        <xsl:value-of select="gsa:i18n ('may get the help text', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'modify_auth'">
        <xsl:value-of select="gsa:i18n ('has write access to the authentication configuration', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'restore'">
        <xsl:value-of select="gsa:i18n ('may restore items from the trashcan', 'Permission Description')"/>
      </xsl:when>
      <!-- i18n with concat : see dynamic_strings.xsl - permission-descriptions -->
      <xsl:when test="substring-before ($lower, '_') = 'create'">
        <xsl:value-of select="gsa:i18n (concat ('may create a new ', gsa:command-type ($lower)), 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$lower = 'get_info'">
        <xsl:value-of select="gsa:i18n ('has read access to SecInfo', 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$has-resource and substring-before ($lower, '_') = 'delete'">
        <xsl:value-of select="gsa-i18n:strformat (gsa:i18n (concat ('may delete ', gsa:command-type ($lower), ' %1'), 'Permission Description'), $resource/name)"/>
      </xsl:when>
      <xsl:when test="substring-before ($lower, '_') = 'delete'">
        <xsl:value-of select="gsa:i18n (concat ('may delete an existing ', gsa:command-type ($lower)), 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$has-resource and substring-before ($lower, '_') = 'get'">
        <xsl:value-of select="gsa-i18n:strformat (gsa:i18n (concat ('has read access to ', gsa:command-type ($lower), ' %1'), 'Permission Description'), $resource/name)"/>
      </xsl:when>
      <xsl:when test="substring-before ($lower, '_') = 'get'">
        <xsl:value-of select="gsa:i18n (concat ('has read access to ', gsa:command-type-plural ($lower)), 'Permission Description')"/>
      </xsl:when>
      <xsl:when test="$has-resource and substring-before ($lower, '_') = 'modify'">
        <xsl:value-of select="gsa-i18n:strformat (gsa:i18n (concat ('has write access to ', gsa:command-type ($lower), ' %1'), 'Permission Description'), $resource/name)"/>
      </xsl:when>
      <xsl:when test="substring-before ($lower, '_') = 'modify'">
        <xsl:value-of select="gsa:i18n (concat ('has write access to ', gsa:command-type-plural ($lower)), 'Permission Description')"/>
      </xsl:when>

      <xsl:when test="substring-before ($lower, '_') = 'describe'">
        <xsl:variable name="described" select="substring-after ($lower, '_')"/>
        <xsl:variable name="text">
          <xsl:choose>
            <xsl:when test="$described = 'auth'">
              <xsl:value-of select="gsa:i18n ('may get details about the authentication configuration', 'Permission Description')"/>
            </xsl:when>
            <xsl:when test="$described = 'cert'">
              <xsl:value-of select="gsa:i18n ('may get details about the CERT feed', 'Permission Description')"/>
            </xsl:when>
            <xsl:when test="$described = 'feed'">
              <xsl:value-of select="gsa:i18n ('may get details about the NVT feed', 'Permission Description')"/>
            </xsl:when>
            <xsl:when test="$described = 'scap'">
              <xsl:value-of select="gsa:i18n ('may get details about the SCAP feed', 'Permission Description')"/>
            </xsl:when>
            <xsl:otherwise>
              <!-- This should only be a fallback for unexpected output -->
              <xsl:value-of select="gsa-i18n:strformat (gsa:i18n ('may get details about %1', 'Permission Description') , $described)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$text"/>
      </xsl:when>

      <xsl:when test="substring-before ($lower, '_') = 'sync'">
        <xsl:variable name="to_sync" select="substring-after ($lower, '_')"/>
        <xsl:variable name="text">
          <xsl:choose>
            <xsl:when test="$to_sync = 'cert'">
              <xsl:value-of select="gsa:i18n ('may sync the CERT feed', 'Permission Description')"/>
            </xsl:when>
            <xsl:when test="$to_sync = 'feed'">
              <xsl:value-of select="gsa:i18n ('may sync the NVT feed', 'Permission Description')"/>
            </xsl:when>
            <xsl:when test="$to_sync = 'scap'">
              <xsl:value-of select="gsa:i18n ('may sync the SCAP feed', 'Permission Description')"/>
            </xsl:when>
            <xsl:otherwise>
              <!-- This should only be a fallback for unexpected output -->
              <xsl:value-of select="gsa-i18n:strformat (gsa:i18n ('may sync %1', 'Permission Description'), $to_sync)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$text"/>
      </xsl:when>

      <xsl:when test="contains ($lower, '_')">
        <!-- see dynamic_strings.xsl - permission-descriptions (verify_...) -->
        <xsl:value-of select="gsa:i18n (concat ('may ', substring-before ($lower, '_'), ' ', gsa:command-type-plural ($lower)), 'Permission Description')"/>
      </xsl:when>
      <xsl:otherwise><xsl:value-of select="$lower"/></xsl:otherwise>
    </xsl:choose>
  </func:result>
</func:function>

<func:function name="gsa:view_details_title">
  <xsl:param name="type"/>
  <xsl:param name="name"/>
  <xsl:variable name="cap_type" select="gsa:type-name($type)"/>
  <func:result>
    <!-- i18n with concat : see dynamic_strings.xsl - type-details-long -->
    <xsl:value-of select="gsa-i18n:strformat (gsa:i18n (concat ('View details of ', $cap_type, ' %1'), $cap_type), $name)"/>
  </func:result>
</func:function>

<!-- BEGIN NAMED TEMPLATES -->

<xsl:template name="shy-long-rest">
  <xsl:param name="string"/>
  <xsl:param name="max" select="44"/>
  <xsl:param name="chunk" select="5"/>
  <xsl:text disable-output-escaping="yes">&amp;shy;</xsl:text>
  <xsl:value-of select="substring ($string, 1, $chunk)"/>
  <xsl:if test="string-length ($string) &gt; $chunk">
    <xsl:call-template name="shy-long-rest">
      <xsl:with-param name="string"
                      select="substring ($string, $chunk + 1)"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="shy-long-words">
  <xsl:param name="string"/>
  <xsl:param name="max" select="44"/>
  <xsl:param name="chunk" select="5"/>
  <xsl:for-each select="str:split ($string, ' ')">
    <xsl:choose>
      <xsl:when test="string-length (.) &gt; $max">
        <xsl:value-of select="substring (., 1, $chunk)"/>
        <xsl:call-template name="shy-long-rest">
          <xsl:with-param name="string"
                          select="substring (., $chunk + 1)"/>
          <xsl:with-param name="chunk" select="$chunk"/>
        </xsl:call-template>
        <xsl:text> </xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="."/>
        <xsl:text> </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template name="wbr-at-punctuation">
  <xsl:param name="string"/>
  <xsl:variable name="colon-split" select="str:tokenize ($string, ':')"/>
  <xsl:for-each select="$colon-split">
    <xsl:if test="position() != 1">
      <xsl:text>:</xsl:text>
    </xsl:if>
    <xsl:variable name="period-split" select="str:tokenize (., '.')"/>
    <xsl:for-each select="$period-split">
      <xsl:if test="position() != 1">
        <xsl:text>.</xsl:text>
      </xsl:if>
      <xsl:value-of select="."/>
      <xsl:if test="position() != last()">
        <wbr/>
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="position() != last()">
      <wbr/>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<!-- Currently only a very simple formatting method to produce
     nice HTML from a structured text:
     - create paragraphs for each text block separated with a empty line
-->
<xsl:template name="structured-text">
  <xsl:param name="string"/>

  <xsl:for-each select="str:split($string, '&#10;&#10;')">
    <p>
      <xsl:value-of select="."/>
    </p>
  </xsl:for-each>
</xsl:template>

<xsl:template name="prognostic-description">
  <xsl:param name="string"/>

  <xsl:for-each select="str:split($string, '&#10;&#10;')">
    <p>
      <xsl:for-each select="str:split(., '&#10;')">
        <xsl:value-of select="."/>
        <br/>
      </xsl:for-each>
    </p>
  </xsl:for-each>
</xsl:template>

<xsl:template name="feedback-icon">
<!-- You may fill in here to_name and to_adress and un-comment the block
     to enable a feedback button for support or similar purposes. -->
<!--
  <xsl:param name="to_name" select="'FILL IN NAME'"/>
  <xsl:param name="to_address" select="'FILL IN EMAIL ADDRESS'"/>
  <xsl:param name="subject" select="'Feedback'"/>
  <xsl:param name="body" select="'Dear%20{str:encode-uri ($to_name, true ())},&#xA;&#xA;'"/>
  <a href="mailto:{str:encode-uri ($to_name, true ())}%20%3C{str:encode-uri ($to_address, true ())}%3E?subject={str:encode-uri ($subject, true ())}&amp;body=Dear%20{str:encode-uri ($to_name, true ())},&#xA;&#xA;{str:encode-uri ($body, true ())}">
    <img src="img/feedback.png" title="{gsa:i18n ('Send feedback to', 'Feedback Icon')} {$to_name}" alt="{gsa:i18n('Feedback', 'Feedback Icon')}"/>
  </a>
-->
</xsl:template>

<xsl:template name="filter-window-pager">
  <xsl:param name="type"/>
  <xsl:param name="list"/>
  <xsl:param name="count"/>
  <xsl:param name="filtered_count"/>
  <xsl:param name="full_count"/>
  <xsl:param name="extra_params"/>
  <xsl:choose>
    <xsl:when test="$count &gt; 0">
      <xsl:variable name="last" select="$list/@start + $count - 1"/>
      <xsl:choose>
        <xsl:when test = "$list/@start &gt; 1">
          <a href="?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=first=1 rows={$list/@max} {filters/term}&amp;token={/envelope/token}"><img style="margin-left:10px;margin-right:3px;" src="/img/first.png" border="0" title="{gsa:i18n ('First', 'Pagination')}"/></a>
        </xsl:when>
        <xsl:otherwise>
          <img style="margin-left:10px;margin-right:3px;" src="/img/first_inactive.png" border="0" title="{gsa:i18n ('Already on first page', 'Pagination')}"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$list/@start > $list/@max and $list/@max &gt; 0">
          <a href="?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=first={$list/@start - $list/@max} rows={$list/@max} {filters/term}&amp;token={/envelope/token}"><img style="margin-right:3px;" src="/img/previous.png" border="0" title="{gsa:i18n ('Previous', 'Pagination')}"/></a>
        </xsl:when>
        <xsl:when test="$list/@start &gt; 1 and $list/@max &gt; 0">
          <a href="?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=first=1 rows={$list/@max} {filters/term}&amp;token={/envelope/token}"><img style="margin-right:3px;" src="/img/previous.png" border="0" title="{gsa:i18n ('Previous', 'Pagination')}"/></a>
        </xsl:when>
        <xsl:otherwise>
          <img style="margin-right:3px;" src="/img/previous_inactive.png" border="0" title="{gsa:i18n ('Already on first page', 'Pagination')}"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$list/@start"/> -
      <xsl:value-of select="$last"/>
      <xsl:value-of select="gsa:i18n (' of ', 'Pagination')"/>
      <div style="display: inline; margin-right: 0px;"><xsl:value-of select="$filtered_count"/></div>
      <xsl:if test="$full_count">
        (<xsl:value-of select="gsa:i18n ('total', 'Pagination')"/>: <xsl:value-of select="$full_count"/>)
      </xsl:if>
      <xsl:choose>
        <xsl:when test = "$last &lt; $filtered_count">
          <a href="?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=first={$list/@start + $list/@max} rows={$list/@max} {filters/term}&amp;token={/envelope/token}"><img style="margin-left:3px;" src="/img/next.png" border="0" title="{gsa:i18n ('Next', 'Pagination')}"/></a>
        </xsl:when>
        <xsl:otherwise>
          <img style="margin-left:3px;" src="/img/next_inactive.png" border="0" title="{gsa:i18n ('Already on last page', 'Pagination')}"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test = "$last &lt; $filtered_count">
          <a href="?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=first={floor(($filtered_count - 1) div $list/@max) * $list/@max + 1} rows={$list/@max} {filters/term}&amp;token={/envelope/token}"><img style="margin-left:3px;margin-right:10px;" src="/img/last.png" border="0" title="{gsa:i18n ('Last', 'Pagination')}"/></a>
        </xsl:when>
        <xsl:otherwise>
          <img style="margin-left:3px;margin-right:10px;" src="/img/last_inactive.png" border="0" title="{gsa:i18n ('Already on last page', 'Pagination')}"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <xsl:if test="$full_count">
        (<xsl:value-of select="gsa:i18n ('total', 'Pagination')"/>: <xsl:value-of select="$full_count"/>)
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="filter-criteria">
  <xsl:variable name="operator_count" select="count (filters/keywords/keyword[column='' and (value='and' or value='not' or value='or')])"/>
  <xsl:for-each select="filters/keywords/keyword[column != 'apply_overrides' and column != 'autofp' and column != 'rows' and column != 'first' and column != 'sort' and column != 'sort-reverse' and (column != 'task_id' or $operator_count != 0)]">
    <xsl:value-of select="column"/>
    <xsl:choose>
      <xsl:when test="column = ''">
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="relation"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="boolean (quoted)">"</xsl:if>
    <xsl:value-of select="value"/>
    <xsl:if test="boolean (quoted)">"</xsl:if>
    <xsl:text> </xsl:text>
  </xsl:for-each>
</xsl:template>

<xsl:template name="filter-extra">
  <xsl:variable name="operator_count" select="count (filters/keywords/keyword[column='' and (value='and' or value='not' or value='or')])"/>
  <xsl:for-each select="filters/keywords/keyword[not(column != 'apply_overrides' and column != 'autofp' and column != 'rows' and column != 'first' and column != 'sort' and column != 'sort-reverse' and (column != 'task_id' or $operator_count != 0))]">
    <xsl:value-of select="column"/>
    <xsl:choose>
      <xsl:when test="column = ''">
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="relation"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="boolean (quoted)">"</xsl:if>
    <xsl:value-of select="value"/>
    <xsl:if test="boolean (quoted)">"</xsl:if>
    <xsl:text> </xsl:text>
  </xsl:for-each>
</xsl:template>

<xsl:template name="filter-window-part">
  <xsl:param name="type"/>
  <xsl:param name="list"/>
  <xsl:param name="extra_params"/>
  <xsl:param name="columns"/>
  <div class="gb_window_part_content">
    <div style="background-color: #EEEEEE;">
      <xsl:choose>
        <xsl:when test="0"/>
        <xsl:otherwise>
          <div style="float: right">
            <xsl:if test="gsa:may-op ('create_filter')">
              <form style="display: inline; margin: 0; vertical-align:middle;" action="" method="post" enctype="multipart/form-data">
                <div style="display: inline; padding: 2px; vertical-align:middle;">
                  <input type="hidden" name="token" value="{/envelope/token}"/>
                  <input type="hidden" name="cmd" value="create_filter"/>
                  <input type="hidden" name="caller" value="{/envelope/current_page}"/>
                  <input type="hidden" name="comment" value=""/>
                  <input type="hidden" name="term" value="{filters/term}"/>
                  <input type="hidden" name="optional_resource_type" value="{$type}"/>
                  <input type="hidden" name="next" value="get_{gsa:type-many($type)}"/>
                  <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
                  <xsl:for-each select="exslt:node-set($extra_params)/param">
                    <input type="hidden" name="{name}" value="{value}"/>
                  </xsl:for-each>
                  <input type="text" name="name" value="" size="10"
                         maxlength="80" style="vertical-align:middle"/>
                  <!-- i18n with concat : see dynamic_strings.xsl - type-new-filter -->
                  <input type="image"
                         name="New Filter"
                         src="/img/new.png"
                         alt="{gsa:i18n ('New Filter', 'Filter')}"
                         title="{gsa:i18n (concat ('New ', gsa:type-name ($type), ' Filter from current term'), gsa:type-name ($type))}"
                         style="vertical-align:middle;margin-left:3px;margin-right:3px;"/>
                </div>
              </form>
            </xsl:if>
            <xsl:if test="gsa:may-op ('get_filters')">
              <form style="display: inline; margin: 0; vertical-align:middle" action="" method="get" name="switch_filter" enctype="multipart/form-data">
                <div style="display: inline; padding: 2px; vertical-align:middle;">
                  <input type="hidden" name="token" value="{/envelope/token}"/>
                  <input type="hidden" name="cmd" value="get_{gsa:type-many($type)}"/>
                  <xsl:for-each select="exslt:node-set($extra_params)/param">
                    <input type="hidden" name="{name}" value="{value}"/>
                  </xsl:for-each>
                  <select style="margin-bottom: 0px; max-width: 100px;" name="filt_id" onchange="switch_filter.submit()">
                    <option value="--">--</option>
                    <xsl:variable name="id" select="filters/@id"/>
                    <xsl:for-each select="../filters/get_filters_response/filter">
                      <xsl:choose>
                        <xsl:when test="@id = $id">
                          <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="{@id}"><xsl:value-of select="name"/></option>
                        </xsl:otherwise>
                      </xsl:choose>
                    </xsl:for-each>
                  </select>
                  <input type="image"
                         name="Switch Filter"
                         title="{gsa:i18n ('Switch Filter', 'Filter')}"
                         src="/img/refresh.png"
                         alt="{gsa:i18n ('Switch', 'Filter')}" style="vertical-align:middle;margin-left:3px;margin-right:3px;"/>
                  <a href="/omp?cmd=get_filters&amp;token={/envelope/token}"
                     title="{gsa:i18n ('Filters', 'Filter')}">
                    <img style="vertical-align:middle;margin-left:3px;margin-right:3px;"
                         src="/img/list.png" border="0" alt="{gsa:i18n ('Filters', 'Filter')}"/>
                  </a>
                </div>
              </form>
            </xsl:if>
          </div>
        </xsl:otherwise>
      </xsl:choose>
      <form action="" method="get" enctype="multipart/form-data">
        <xsl:variable name="criteria">
          <xsl:call-template name="filter-criteria"/>
        </xsl:variable>
        <xsl:variable name="extra">
          <xsl:call-template name="filter-extra"/>
        </xsl:variable>

        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="get_{gsa:type-many($type)}"/>
        <xsl:for-each select="exslt:node-set($extra_params)/param">
          <input type="hidden" name="{name}" value="{value}"/>
        </xsl:for-each>
        <div style="padding: 2px;">
          <xsl:value-of select="gsa:i18n ('Filter', 'Filter')"/>:
          <input type="text" name="filter" size="53"
                 value="{$criteria}"
                 maxlength="1000"/>
          <input type="image"
                 name="Update Filter"
                 title="{gsa:i18n ('Update Filter', 'Filter')}"
                 src="/img/refresh.png"
                 alt="{gsa:i18n ('Update', 'Action Verb')}" style="vertical-align:middle;margin-left:3px;margin-right:3px;"/>
          <a href="/help/powerfilter.html?token={/envelope/token}" title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('Powerfilter', 'Filter')}">
            <img style="vertical-align:middle;margin-left:3px;margin-right:3px;"
                 src="/img/help.png" border="0"/>
          </a>
          <xsl:variable name="fold">
            <xsl:choose>
              <xsl:when test="/envelope/params/filterbox &gt; 0">1</xsl:when>
              <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="filterbox" select="($fold - 1)*($fold - 1)"/>
          <xsl:variable name="title">
            <xsl:choose>
              <xsl:when test="$filterbox=1">
                <xsl:value-of select="gsa:i18n ('Fold filter', 'Filter')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Unfold filter', 'Filter')"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="extras">
            <xsl:for-each select="exslt:node-set($extra_params)/param">
              <xsl:value-of select="concat ('&amp;', name, '=', value)"/>
            </xsl:for-each>
          </xsl:variable>
          <a href="/omp?cmd=get_{gsa:type-many($type)}{$extras}&amp;filterbox={$filterbox}&amp;filter={str:encode-uri (filters/term, true ())}&amp;filt_id={filters/@id}&amp;token={/envelope/token}"
             title="{$title}">
             <xsl:call-template name="fold-filter-icon-img">
               <xsl:with-param name="fold" select="$fold"/>
             </xsl:call-template>
          </a>
        </div>
        <xsl:if test="not(/envelope/params/filterbox &gt; 0)">
          <div class="footnote" style="margin-left:40px;">
            <xsl:value-of select="$extra"/>
          </div>
          <input type="hidden" name="filter_extra" value="{$extra}"/>
        </xsl:if>
        <xsl:if test="/envelope/params/filterbox &gt; 0">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="get_{gsa:type-many($type)}"/>
          <input type="hidden" name="build_filter" value="1"/>
          <input type="hidden" name="filt_id" value="--"/>
          <xsl:for-each select="exslt:node-set($extra_params)/param">
            <input type="hidden" name="{name}" value="{value}"/>
          </xsl:for-each>
          <xsl:if test="filters/keywords/keyword[column='task_id']">
            <div style="padding: 2px;">
              <xsl:variable name="task_id"
                            select="filters/keywords/keyword[column='task_id']/value"/>
              <xsl:value-of select="gsa:i18n ('Task', 'Task')"/>:
              <select style="margin-bottom: 0px;" name="task_id" size="1">
                <xsl:for-each select="../get_tasks_response/task">
                  <xsl:call-template name="opt">
                    <xsl:with-param name="value" select="@id"/>
                    <xsl:with-param name="content" select="name/text()"/>
                    <xsl:with-param name="select-value" select="$task_id"/>
                  </xsl:call-template>
                </xsl:for-each>
              </select>
            </div>
          </xsl:if>
          <xsl:if test="filters/keywords/keyword[column='apply_overrides']">
            <div style="padding: 2px;">
              <xsl:variable name="apply_overrides"
                            select="filters/keywords/keyword[column='apply_overrides']/value"/>
              <label>
                <xsl:choose>
                  <xsl:when test="$apply_overrides = 0">
                    <input type="checkbox" name="overrides" value="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="overrides" value="1"
                           checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Apply overrides', 'Override Controls')"/>
              </label>
            </div>
          </xsl:if>
          <xsl:if test="filters/keywords/keyword[column='autofp_value']">
            <div style="padding: 2px;">
              <xsl:value-of select="gsa:i18n ('Auto-FP', 'Report Filter')"/>:
              <div style="margin-left: 30px">
                <label>
                  <xsl:choose>
                    <xsl:when test="filters/keywords/keyword[column='autofp']/value = 0">
                      <input type="checkbox" name="autofp" value="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="autofp" value="1" checked="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:value-of select="gsa:i18n ('Trust vendor security updates', 'Report Filter')"/>
                </label>
                <div style="margin-left: 30px">
                  <label>
                    <xsl:choose>
                      <xsl:when test="filters/keywords/keyword[column='autofp']/value = 2">
                        <input type="radio" name="autofp_value" value="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="autofp_value" value="1" checked="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:value-of select="gsa:i18n ('Full CVE match', 'Report Filter')"/>
                  </label>
                  <br/>
                  <label>
                    <xsl:choose>
                      <xsl:when test="filters/keywords/keyword[column='autofp']/value = 2">
                        <input type="radio" name="autofp_value" value="2" checked="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="autofp_value" value="2"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:value-of select="gsa:i18n ('Partial CVE match', 'Report Filter')"/>
                  </label>
                </div>
              </div>
            </div>
          </xsl:if>
          <xsl:if test="filters/keywords/keyword[column='first']">
            <div style="padding: 2px;">
              <xsl:value-of select="gsa:i18n ('First result', 'Filter')"/>:
              <input type="text" name="first" size="5"
                     value="{filters/keywords/keyword[column='first']/value}"
                     maxlength="400"/>
            </div>
          </xsl:if>
          <xsl:if test="filters/keywords/keyword[column='rows']">
            <div style="padding: 2px;">
              <xsl:value-of select="gsa:i18n ('Results per page', 'Filter')"/>:
              <input type="text" name="max" size="5"
                     value="{filters/keywords/keyword[column='rows']/value}"
                     maxlength="400"/>
            </div>
          </xsl:if>
          <xsl:if test="exslt:node-set ($columns)">
            <div style="padding: 2px;">
              <xsl:value-of select="gsa:i18n ('Sort by', 'Filter')"/>:
              <xsl:variable name="sort" select="sort/field/text ()"/>
              <select style="margin-bottom: 0px;" name="sort_field" size="1">
                <xsl:for-each select="exslt:node-set ($columns)/column">
                  <xsl:variable name="single" select="count (column) = 0"/>
                  <xsl:choose>
                    <xsl:when test="($single) and ((boolean (field) and field = $sort) or (gsa:column-filter-name (name) = $sort))">
                      <option value="{$sort}" selected="1">
                        <xsl:value-of select="name"/>
                      </option>
                    </xsl:when>
                    <xsl:when test="$single and boolean (field)">
                      <option value="{field}">
                        <xsl:value-of select="name"/>
                      </option>
                    </xsl:when>
                    <xsl:when test="$single">
                      <option value="{gsa:column-filter-name (name)}">
                        <xsl:value-of select="name"/>
                      </option>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:for-each select="column">
                        <xsl:choose>
                          <xsl:when test="(boolean (field) and (field = $sort)) or (gsa:column-filter-name (name) = $sort)">
                            <option value="{$sort}" selected="1">
                              <xsl:value-of select="concat(../name, ': ', name)"/>
                            </option>
                          </xsl:when>
                          <xsl:when test="boolean (field)">
                            <option value="{field}">
                              <xsl:value-of select="concat(../name, ': ', name)"/>
                            </option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{gsa:column-filter-name (name)}">
                              <xsl:value-of select="concat(../name, ': ', name)"/>
                            </option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
              <xsl:variable name="order" select="sort/field/order"/>
              <label>
                <xsl:choose>
                  <xsl:when test="$order = 'ascending'">
                    <input type="radio" name="sort_order" value="ascending" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="sort_order" value="ascending"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Ascending', 'Filter')"/>
              </label>
              <label>
                <xsl:choose>
                  <xsl:when test="$order = 'descending'">
                    <input type="radio" name="sort_order" value="descending" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="sort_order" value="descending"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Descending', 'Filter')"/>
              </label>
            </div>
          </xsl:if>
          <div style="float: right; margin-right: 5px; margin-top: -25px">
            <input type="submit" value="{gsa:i18n ('Apply', 'Action Verb')}" title="{gsa:i18n ('Apply', 'Action Verb')}"/>
          </div>
        </xsl:if>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template name="auto-refresh">
  <select style="margin-bottom: 0px;" name="refresh_interval" size="1" onchange="this.parentNode.submit()">
    <xsl:choose>
      <xsl:when test="/envelope/autorefresh/@interval='0'">
        <option value="0" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('No auto-refresh', 'Auto-Refresh')"/></option>
      </xsl:when>
      <xsl:otherwise>
        <option value="0"><xsl:value-of select="gsa:i18n ('No auto-refresh', 'Auto-Refresh')"/></option>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="/envelope/autorefresh/@interval='30'">
        <option value="30" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 30 <xsl:value-of select="gsa:i18n ('Sec.', 'Auto-Refresh')"/></option>
      </xsl:when>
      <xsl:otherwise>
        <option value="30"><xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 30 <xsl:value-of select="gsa:i18n ('Sec.', 'Auto-Refresh')"/></option>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="/envelope/autorefresh/@interval='60'">
        <option value="60" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 60 <xsl:value-of select="gsa:i18n ('Sec.', 'Auto-Refresh')"/></option>
      </xsl:when>
      <xsl:otherwise>
        <option value="60"><xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 60 <xsl:value-of select="gsa:i18n ('Sec.', 'Auto-Refresh')"/></option>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="/envelope/autorefresh/@interval='120'">
        <option value="120" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 2 <xsl:value-of select="gsa:i18n ('Min.', 'Auto-Refresh')"/></option>
      </xsl:when>
      <xsl:otherwise>
        <option value="120"><xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 2 <xsl:value-of select="gsa:i18n ('Min.', 'Auto-Refresh')"/></option>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="/envelope/autorefresh/@interval='300'">
        <option value="300" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 5 <xsl:value-of select="gsa:i18n ('Min.', 'Auto-Refresh')"/></option>
      </xsl:when>
      <xsl:otherwise>
        <option value="300"><xsl:value-of select="gsa:i18n ('Refresh every', 'Auto-Refresh')"/> 5 <xsl:value-of select="gsa:i18n ('Min.', 'Auto-Refresh')"/></option>
      </xsl:otherwise>
    </xsl:choose>
  </select>
</xsl:template>

<xsl:template name="edit-header-icons">
  <xsl:param name="type"/>
  <xsl:param name="cap-type"/>
  <xsl:param name="cap-type-plural" select="concat ($cap-type, 's')"/>
  <xsl:param name="id"/>
  <!-- i18n with concat : see dynamic_strings.xsl - type-edit -->
  <xsl:variable name="help_url">
    <xsl:choose>
      <xsl:when test="$type = 'config'">
        <xsl:value-of select="concat ('/help/config_editor.html?token=', /envelope/token)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat ('/help/', $type, 's.html?token=', /envelope/token, '#edit_', $type)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <a href="{$help_url}" title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n (concat ('Edit ' ,$cap-type), $cap-type)}">
    <img src="/img/help.png"/>
  </a>
  <!-- dynamic i18n : see dynamic_strings.xsl - type-name-plural -->
  <a href="/omp?cmd=get_{$type}s&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
     title="{gsa:i18n ($cap-type-plural, $cap-type)}" style="margin-left:3px;">
    <img src="/img/list.png" border="0" alt="{gsa:i18n ($cap-type-plural, $cap-type)}"/>
  </a>
  <!-- i18n with concat : see dynamic_strings.xsl - type-name-details -->
  <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
      <a href="/omp?cmd=get_{$type}&amp;{$type}_id={$id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n (concat ($cap-type, ' Details'), $cap-type)}" style="margin-left:3px;">
      <img src="/img/details.png" border="0" alt="{gsa:i18n ('Details', 'Generic Resource')}"/>
    </a>
  </div>
</xsl:template>

<xsl:template name="get-settings-resource">
  <xsl:param name="id"/>
  <xsl:param name="type"/>
  <xsl:param name="cap_type" select="gsa:capitalise ($type)"/>
  <xsl:param name="resources"/>

  <xsl:choose>
    <xsl:when test="$id">
      <!-- i18n with concat : see dynamic_strings.xsl - type-name-details -->
      <a href="/omp?cmd=get_{$type}&amp;{$type}_id={$id}&amp;token={/envelope/token}"
         title="{gsa:i18n (concat ($cap_type, ' Details'), $type)}">
        <xsl:value-of select="$resources[@id=$id]/name"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="get-settings-filter">
  <xsl:param name="filter"/>

  <xsl:choose>
    <xsl:when test="$filter">
      <a href="/omp?cmd=get_filter&amp;filter_id={$filter}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Filter Details', 'Filter')}">
        <xsl:value-of select="commands_response/get_filters_response/filter[@id=$filter]/name"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="edit-settings-resource">
  <xsl:param name="setting"/>
  <xsl:param name="resources"/>
  <xsl:param name="selected_id" select="@id"/>

  <select style="margin-bottom: 0px;" name="{$setting}">
    <option value="">--</option>
    <xsl:for-each select="$resources">
      <xsl:choose>
        <xsl:when test="@id = $selected_id">
          <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
        </xsl:when>
        <xsl:otherwise>
          <option value="{@id}"><xsl:value-of select="name"/></option>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </select>
</xsl:template>

<xsl:template name="edit-settings-filters">
  <xsl:param name="uuid"/>
  <xsl:param name="filter-type"/>
  <xsl:param name="filter"/>
  <select style="margin-bottom: 0px;" name="settings_filter:{$uuid}">
    <option value="">--</option>
    <xsl:variable name="id" select="filters/@id"/>
    <xsl:for-each select="commands_response/get_filters_response/filter[type=$filter-type]">
      <xsl:choose>
        <xsl:when test="@id = $filter">
          <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
        </xsl:when>
        <xsl:otherwise>
          <option value="{@id}"><xsl:value-of select="name"/></option>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </select>
</xsl:template>

<xsl:template name="severity-settings-list">
  <xsl:param name="default"/>
  <select style="margin-bottom: 0px;" name="severity_class">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'nist'"/>
      <xsl:with-param name="content" select="'NVD Vulnerability Severity Ratings'"/>
      <xsl:with-param name="select-value" select="$default"/>
    </xsl:call-template>
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'bsi'"/>
      <xsl:with-param name="content" select="'BSI Schwachstellenampel (Germany)'"/>
      <xsl:with-param name="select-value" select="$default"/>
    </xsl:call-template>
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'classic'"/>
      <xsl:with-param name="content" select="'OpenVAS Classic'"/>
      <xsl:with-param name="select-value" select="$default"/>
    </xsl:call-template>
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'pci-dss'"/>
      <xsl:with-param name="content" select="'PCI-DSS'"/>
      <xsl:with-param name="select-value" select="$default"/>
    </xsl:call-template>
  </select>
</xsl:template>

<xsl:template name="severity-settings-name">
  <xsl:param name="type"/>
  <xsl:choose>
    <xsl:when test="$type = 'nist'">NVD Vulnerability Severity Ratings</xsl:when>
    <xsl:when test="$type = 'bsi'">BSI Schwachstellenampel (Germany)</xsl:when>
    <xsl:when test="$type = 'classic'">OpenVAS Classic</xsl:when>
    <xsl:when test="$type = 'pci-dss'">PCI-DSS</xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="list-window-line-icons">
  <xsl:param name="type"/>
  <xsl:param name="cap-type"/>

  <xsl:param name="id"/>
  <xsl:param name="noedit"/>
  <xsl:param name="noclone"/>
  <xsl:param name="grey-clone"/>
  <xsl:param name="noexport"/>
  <xsl:param name="notrash"/>
  <xsl:param name="params" select="''"/>
  <xsl:param name="next" select="concat ('get_', $type, 's')"/>
  <xsl:param name="next_type" select="''"/>
  <xsl:param name="next_id" select="''"/>

  <xsl:variable name="next_params_string">
    <xsl:choose>
      <xsl:when test="$next_type != '' and $next_id != ''">
        <xsl:value-of select="concat ('&amp;next_type=', $next_type, '&amp;next_id=', $next_id)"/>
      </xsl:when>
      <xsl:otherwise/>
    </xsl:choose>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$notrash">
    </xsl:when>
    <xsl:when test="gsa:may (concat ('delete_', $type)) and writable!='0' and in_use='0'">
      <xsl:call-template name="trashcan-icon">
        <xsl:with-param name="type" select="$type"/>
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="params">
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <xsl:if test="$next != ''">
            <input type="hidden" name="next" value="{$next}"/>
          </xsl:if>
          <xsl:if test="$next_id != '' and $next_type != ''">
            <input type="hidden" name="{$next_type}_id" value="{$next_id}"/>
          </xsl:if>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:variable name="inactive_text">
        <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
        <xsl:choose>
          <xsl:when test="in_use != '0'">
            <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is still in use'), $cap-type)"/>
          </xsl:when>
          <xsl:when test="writable = '0'">
            <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is not writable'), $cap-type)"/>
          </xsl:when>
          <xsl:when test="not(gsa:may (concat ('delete_', $type)))">
            <xsl:value-of select="gsa:i18n (concat ('Permission to move ', $cap-type, ' to trashcan denied'), $cap-type)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('Cannot move to trashcan.', 'Trashcan')"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <img src="/img/trashcan_inactive.png"
           border="0"
           alt="{gsa:i18n ('To Trashcan', 'Action Verb')}"
           title="{$inactive_text}"
           style="margin-left:3px;"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
    <xsl:when test="$noedit">
    </xsl:when>
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="gsa:may (concat ('modify_', $type)) and writable!='0'">
          <!-- i18n with concat : see dynamic_strings.xsl - type-edit -->
          <a href="/omp?cmd=edit_{$type}&amp;{$type}_id={@id}&amp;next={$next}{$next_params_string}{$params}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
             title="{gsa:i18n (concat ('Edit ', $cap-type), $cap-type)}"
             style="margin-left:3px;">
            <img src="/img/edit.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="inactive_text">
            <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
            <xsl:choose>
              <xsl:when test="writable = '0'">
                <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is not writable'), $cap-type)"/>
              </xsl:when>
              <xsl:when test="not(gsa:may (concat ('delete_', $type)))">
                <xsl:value-of select="gsa:i18n (concat ('Permission to edit ', $cap-type, ' denied'), $cap-type)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n (concat ('Cannot modify ', $cap-type), $cap-type)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <img src="/img/edit_inactive.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"
               title="{$inactive_text}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
    <xsl:when test="$noclone">
    </xsl:when>
    <xsl:when test="$grey-clone">
      <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
      <img src="/img/clone_inactive.png"
           alt="{gsa:i18n ('Clone', 'Action Verb')}"
           value="Clone"
           title="{gsa:i18n (concat ($cap-type, ' may not be cloned'), $cap-type)}"
           style="margin-left:3px;"/>
    </xsl:when>
    <xsl:when test="gsa:may-clone ($type)">
      <div style="display: inline">
        <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp" method="post" enctype="multipart/form-data">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="caller" value="{/envelope/current_page}"/>
          <input type="hidden" name="cmd" value="clone"/>
          <input type="hidden" name="resource_type" value="{$type}"/>
          <input type="hidden" name="next" value="get_{$type}"/>
          <input type="hidden" name="id" value="{@id}"/>
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <input type="image" src="/img/clone.png" alt="{gsa:i18n ('Clone', 'Action Verb')}"
                 name="Clone" value="Clone" title="{gsa:i18n ('Clone', 'Action Verb')}"/>
        </form>
      </div>
    </xsl:when>
    <xsl:when test="owner/name = /envelope/login/text() or string-length (owner/name) = 0">
      <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
      <img src="/img/clone_inactive.png"
           alt="{gsa:i18n ('Clone', 'Action Verb')}"
           value="Clone"
           title="{gsa:i18n (concat ($cap-type, ' must be owned or global'), $cap-type)}"
           style="margin-left:3px;"/>
    </xsl:when>
    <xsl:otherwise>
      <img src="/img/clone_inactive.png"
           alt="{gsa:i18n ('Clone', 'Action Verb')}"
           value="Clone"
           title="{gsa:i18n ('Permission to clone denied', 'Action Message')}"
           style="margin-left:3px;"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
    <xsl:when test="$noexport">
    </xsl:when>
    <xsl:otherwise>
      <!-- i18n with concat : see dynamic_strings.xsl - type-export -->
      <a href="/omp?cmd=export_{$type}&amp;{$type}_id={@id}&amp;next={$next}{$params}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n (concat ('Export ', $cap-type), $cap-type)}"
         style="margin-left:3px;">
        <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export', 'Action Verb')}"/>
      </a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="trash-delete-icon">
  <xsl:param name="type"></xsl:param>
  <xsl:param name="id"></xsl:param>
  <xsl:param name="params"></xsl:param>

  <div style="display: inline">
    <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="cmd" value="delete_trash_{$type}"/>
      <input type="hidden" name="{$type}_id" value="{$id}"/>
      <input type="image" src="/img/delete.png" alt="{gsa:i18n ('Delete', 'Action Verb')}"
             name="Delete" value="Delete" title="{gsa:i18n ('Delete', 'Action Verb')}"/>
      <xsl:copy-of select="$params"/>
    </form>
  </div>
</xsl:template>

<xsl:template name="delete-icon">
  <xsl:param name="type"></xsl:param>
  <xsl:param name="id"></xsl:param>
  <xsl:param name="params"></xsl:param>

  <div style="display: inline">
    <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="cmd" value="delete_{$type}"/>
      <input type="hidden" name="{$type}_id" value="{$id}"/>
      <input type="image" src="/img/delete.png" alt="{gsa:i18n ('Delete', 'Action Verb')}"
             name="Delete" value="Delete" title="{gsa:i18n ('Delete', 'Action Verb')}"/>
      <xsl:copy-of select="$params"/>
    </form>
  </div>
</xsl:template>

<xsl:template name="restore-icon">
  <xsl:param name="id"></xsl:param>

  <xsl:if test="gsa:may-op ('restore')">
    <div style="display: inline">
      <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp"
            method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="cmd" value="restore"/>
        <input type="hidden" name="target_id" value="{$id}"/>
        <input type="image" src="/img/restore.png" alt="{gsa:i18n ('Restore', 'Action Verb')}"
               name="Restore" value="Restore" title="{gsa:i18n ('Restore', 'Action Verb')}"/>
      </form>
    </div>
  </xsl:if>
</xsl:template>

<xsl:template name="resume-icon">
  <xsl:param name="type"></xsl:param>
  <xsl:param name="id"></xsl:param>
  <xsl:param name="params"></xsl:param>
  <xsl:param name="cmd">resume_<xsl:value-of select="type"/></xsl:param>

  <div style="display: inline">
    <form style="display: inline; font-size: 0px; margin-left: 3px"
          action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="cmd" value="{$cmd}"/>
      <input type="hidden" name="{$type}_id" value="{$id}"/>
      <input type="image" src="/img/resume.png" alt="{gsa:i18n ('Resume', 'Action Verb')}"
             name="Resume" value="Resume" title="{gsa:i18n ('Resume', 'Action Verb')}"/>
      <xsl:copy-of select="$params"/>
    </form>
  </div>
</xsl:template>

<xsl:template name="start-icon">
  <xsl:param name="type"></xsl:param>
  <xsl:param name="id"></xsl:param>
  <xsl:param name="params"></xsl:param>
  <xsl:param name="cmd">start_<xsl:value-of select="$type"/></xsl:param>
  <xsl:param name="alt"><xsl:value-of select="gsa:i18n('Start', 'Action Verb')"/></xsl:param>
  <xsl:param name="name">Start</xsl:param>

  <div style="display: inline">
    <form style="display: inline; font-size: 0px; margin-left: 3px"
          action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="cmd" value="{$cmd}"/>
      <input type="hidden" name="{$type}_id" value="{$id}"/>
      <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
      <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
      <input type="image" src="/img/start.png" alt="{$alt}"
             name="{$name}" value="{$name}" title="{$alt}"/>
      <xsl:copy-of select="$params"/>
    </form>
  </div>
</xsl:template>

<xsl:template name="stop-icon">
  <xsl:param name="type"></xsl:param>
  <xsl:param name="id"></xsl:param>
  <xsl:param name="params"></xsl:param>

  <div style="display: inline">
    <form style="display: inline; font-size: 0px; margin-left: 3px"
          action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="cmd" value="stop_{$type}"/>
      <input type="hidden" name="{$type}_id" value="{$id}"/>
      <input type="image" src="/img/stop.png" alt="{gsa:i18n('Stop', 'Task')}"
             name="Stop" value="Stop" title="{gsa:i18n('Stop', 'Task')}"/>
      <xsl:copy-of select="$params"/>
    </form>
  </div>
</xsl:template>

<xsl:template name="trashcan-icon">
  <xsl:param name="type"></xsl:param>
  <xsl:param name="id"></xsl:param>
  <xsl:param name="fragment"></xsl:param>
  <xsl:param name="params"></xsl:param>

  <div style="display: inline">
    <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp{$fragment}" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="cmd" value="delete_{$type}"/>
      <input type="hidden" name="{$type}_id" value="{$id}"/>
      <input type="image" src="/img/trashcan.png" alt="{gsa:i18n ('To Trashcan', 'Action Verb')}"
             name="To Trashcan" value="To Trashcan" title="{gsa:i18n ('Move To Trashcan', 'Action Verb')}"/>
      <xsl:copy-of select="$params"/>
    </form>
  </div>
</xsl:template>

<!-- This is called within a PRE. -->
<xsl:template name="wrap">
  <xsl:param name="string"></xsl:param>
  <xsl:param name="width">90</xsl:param>
  <xsl:param name="marker">&#8629;&#10;</xsl:param>

  <xsl:for-each select="str:split($string, '&#10;&#10;')">
    <xsl:for-each select="str:tokenize(text(), '&#10;')">
      <xsl:call-template name="wrap-line">
        <xsl:with-param name="string"><xsl:value-of select="."/></xsl:with-param>
        <xsl:with-param name="width" select="$width"/>
        <xsl:with-param name="marker" select="$marker"/>
      </xsl:call-template>
      <xsl:text>
</xsl:text>
    </xsl:for-each>
    <xsl:choose>
      <xsl:when test="position() = last()">
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>
</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<!-- This is called within a PRE. -->
<xsl:template name="wrap-line">
  <xsl:param name="string"></xsl:param>
  <xsl:param name="width">90</xsl:param>
  <xsl:param name="marker">&#8629;</xsl:param>

  <xsl:variable name="to-next-newline">
    <xsl:value-of select="substring-before($string, '&#10;')"/>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="string-length($string) = 0">
      <!-- The string is empty. -->
    </xsl:when>
    <xsl:when test="(string-length($to-next-newline) = 0) and (substring($string, 1, 1) != '&#10;')">
      <!-- A single line missing a newline, output up to the edge. -->
      <xsl:value-of select="substring($string, 1, number($width))"/>
      <xsl:if test="string-length($string) &gt; number($width)"><xsl:value-of select="$marker" disable-output-escaping="yes"/>
        <xsl:call-template name="wrap-line">
          <xsl:with-param name="string"><xsl:value-of select="substring($string, number($width) + 1, string-length($string))"/></xsl:with-param>
          <xsl:with-param name="width" select="$width"/>
          <xsl:with-param name="marker" select="$marker"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:when>
    <xsl:when test="(string-length($to-next-newline) + 1 &lt; string-length($string)) and (string-length($to-next-newline) &lt; number($width))">
      <!-- There's a newline before the edge, so output the line. -->
      <xsl:value-of select="substring($string, 1, string-length($to-next-newline) + 1)"/>
      <xsl:call-template name="wrap-line">
        <xsl:with-param name="string"><xsl:value-of select="substring($string, string-length($to-next-newline) + 2, string-length($string))"/></xsl:with-param>
        <xsl:with-param name="width" select="$width"/>
        <xsl:with-param name="marker" select="$marker"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <!-- Any newline comes after the edge, so output up to the edge. -->
      <xsl:value-of select="substring($string, 1, number($width))"/>
      <xsl:if test="string-length($string) &gt; numer($width)"><xsl:value-of select="$marker" disable-output-escaping="yes"/>
        <xsl:call-template name="wrap-line">
          <xsl:with-param name="string"><xsl:value-of select="substring($string, number($width) + 1, string-length($string))"/></xsl:with-param>
          <xsl:with-param name="width" select="$width"/>
          <xsl:with-param name="marker" select="$marker"/>
        </xsl:call-template>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="highlight-diff">
  <xsl:param name="string"></xsl:param>

  <xsl:for-each select="str:tokenize($string, '&#10;')">
    <xsl:call-template name="highlight-diff-line">
      <xsl:with-param name="string"><xsl:value-of select="."/></xsl:with-param>
    </xsl:call-template>
  </xsl:for-each>
</xsl:template>

<!-- This is called within a PRE. -->
<xsl:template name="highlight-diff-line">
  <xsl:param name="string"></xsl:param>

  <xsl:variable name="to-next-newline">
    <xsl:value-of select="substring-before($string, '&#10;')"/>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="string-length($string) = 0">
      <!-- The string is empty. -->
    </xsl:when>
    <xsl:when test="(string-length($to-next-newline) = 0) and (substring($string, 1, 1) != '&#10;')">
      <!-- A single line missing a newline, output up to the edge. -->
      <xsl:choose>
        <xsl:when test="(substring($string, 1, 1) = '@')">
<div class="diff-line-hunk">
<xsl:value-of select="substring($string, 1, 90)"/>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
</div>
        </xsl:when>
        <xsl:when test="(substring($string, 1, 1) = '+')">
<div class="diff-line-plus">
<xsl:value-of select="substring($string, 1, 90)"/>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
</div>
        </xsl:when>
        <xsl:when test="(substring($string, 1, 1) = '-')">
<div class="diff-line-minus">
<xsl:value-of select="substring($string, 1, 90)"/>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
</div>
        </xsl:when>
        <xsl:otherwise>
<div class="diff-line">
<xsl:value-of select="substring($string, 1, 90)"/>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
</div>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="string-length($string) &gt; 90">
<xsl:call-template name="highlight-diff-line">
  <xsl:with-param name="string"><xsl:value-of select="substring($string, 91, string-length($string))"/></xsl:with-param>
</xsl:call-template>
      </xsl:if>
    </xsl:when>
    <xsl:when test="(string-length($to-next-newline) + 1 &lt; string-length($string)) and (string-length($to-next-newline) &lt; 90)">
      <!-- There's a newline before the edge, so output the line. -->
      <xsl:choose>
        <xsl:when test="(substring($string, 1, 1) = '@')">
<div class="diff-line-hunk">
<xsl:value-of select="substring($string, 1, string-length($to-next-newline) + 1)"/>
</div>
        </xsl:when>
        <xsl:when test="(substring($string, 1, 1) = '+')">
<div class="diff-line-plus">
<xsl:value-of select="substring($string, 1, 90)"/>
</div>
        </xsl:when>
        <xsl:when test="(substring($string, 1, 1) = '-')">
<div class="diff-line-minus">
<xsl:value-of select="substring($string, 1, 90)"/>
</div>
        </xsl:when>
        <xsl:otherwise>
<div class="diff-line">
<xsl:value-of select="substring($string, 1, string-length($to-next-newline) + 1)"/>
</div>
        </xsl:otherwise>
      </xsl:choose>
<xsl:call-template name="highlight-diff-line">
  <xsl:with-param name="string"><xsl:value-of select="substring($string, string-length($to-next-newline) + 2, string-length($string))"/></xsl:with-param>
</xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <!-- Any newline comes after the edge, so output up to the edge. -->
      <xsl:choose>
        <xsl:when test="(substring($string, 1, 1) = '@')">
<div class="diff-line-hunk">
<xsl:value-of select="substring($string, 1, 90)"/>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
</div>
        </xsl:when>
        <xsl:when test="(substring($string, 1, 1) = '+')">
<div class="diff-line-plus">
<xsl:value-of select="substring($string, 1, 90)"/>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
</div>
        </xsl:when>
        <xsl:when test="(substring($string, 1, 1) = '-')">
<div class="diff-line-minus">
<xsl:value-of select="substring($string, 1, 90)"/>
</div>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
        </xsl:when>
        <xsl:otherwise>
<div class="diff-line">
<xsl:value-of select="substring($string, 1, 90)"/>
</div>
          <xsl:if test="string-length($string) &gt; 90">
            <xsl:text>&#8629;</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="string-length($string) &gt; 90">
<xsl:call-template name="hightlight-diff-line">
  <xsl:with-param name="string"><xsl:value-of select="substring($string, 91, string-length($string))"/></xsl:with-param>
</xsl:call-template>
      </xsl:if>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>

<xsl:template name="severity-bar">
  <xsl:param name="extra_text"></xsl:param>
  <xsl:param name="notext"></xsl:param>
  <xsl:param name="cvss"></xsl:param>
  <xsl:param name="threat"><xsl:value-of select="gsa:cvss-risk-factor($cvss)"/></xsl:param>
  <xsl:param name="title"><xsl:value-of select="gsa:i18n($threat, 'Severity')"/></xsl:param>
  <xsl:param name="scale">10</xsl:param>

  <xsl:variable name="fill">
    <xsl:value-of select="number($cvss) * $scale"/>
  </xsl:variable>
  <xsl:variable name="width"><xsl:value-of select="10 * $scale"/></xsl:variable>
  <div class="progressbar_box" title="{$title}" style="width:{$width}px;">
    <xsl:choose>
      <xsl:when test="$threat = 'None'">
        <div class="progressbar_bar_done" style="width:0px;"></div>
      </xsl:when>
      <xsl:when test="$threat = 'Log'">
        <div class="progressbar_bar_gray" style="width:{$fill}px;"></div>
      </xsl:when>
      <xsl:when test="$threat = 'Low'">
        <div class="progressbar_bar_done" style="width:{$fill}px;"></div>
      </xsl:when>
      <xsl:when test="$threat = 'Medium'">
        <div class="progressbar_bar_request" style="width:{$fill}px;"></div>
      </xsl:when>
      <xsl:when test="$threat = 'High'">
        <div class="progressbar_bar_error" style="width:{$fill}px;"></div>
      </xsl:when>
    </xsl:choose>
      <div class="progressbar_text">
        <xsl:if test="not($notext)">
          <xsl:value-of select="$cvss"/>
        </xsl:if>
        <xsl:if test="$extra_text">
          <xsl:value-of select="$extra_text"/>
        </xsl:if>
      </div>
  </div>
</xsl:template>

<xsl:template name="severity-label">
  <xsl:param name="level"/>
  <xsl:param name="font-size" select="'9'"/>
  <xsl:param name="width" select="floor($font-size * 6.0)"/>
  <xsl:choose>
    <xsl:when test="$level = 'High'">
      <div class="label_high" style="font-size:{$font-size}px; min-width:{$width}px"><xsl:value-of select="gsa:i18n ('High', 'Severity')"/></div>
    </xsl:when>
    <xsl:when test="$level = 'Medium'">
      <div class="label_medium" style="font-size:{$font-size}px; min-width:{$width}px"><xsl:value-of select="gsa:i18n ('Medium', 'Severity')"/></div>
    </xsl:when>
    <xsl:when test="$level = 'Low'">
      <div class="label_low" style="font-size:{$font-size}px; min-width:{$width}px"><xsl:value-of select="gsa:i18n ('Low', 'Severity')"/></div>
    </xsl:when>
    <xsl:when test="$level = 'Log'">
      <div class="label_log" style="font-size:{$font-size}px; min-width:{$width}px"><xsl:value-of select="gsa:i18n ('Log', 'Severity')"/></div>
    </xsl:when>
    <xsl:when test="$level = 'False Positive' or $level = 'False&#xa0;Positive'">
      <div class="label_none" style="font-size:{$font-size}px; min-width:{$width}px"><xsl:value-of select="gsa:i18n ('False Pos.', 'Severity')"/></div>
    </xsl:when>
    <xsl:otherwise>
      <div class="label_none" style="font-size:{$font-size}px; min-width:{$width}px"><xsl:value-of select="$level"/></div>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="build-levels">
  <xsl:param name="filters"></xsl:param>
  <xsl:for-each select="$filters">
    <xsl:choose>
      <xsl:when test="text()='High'">h</xsl:when>
      <xsl:when test="text()='Medium'">m</xsl:when>
      <xsl:when test="text()='Low'">l</xsl:when>
      <xsl:when test="text()='Log'">g</xsl:when>
      <xsl:when test="text()='False Positive'">f</xsl:when>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template name="scanner-type-name">
  <xsl:param name="type"/>
  <xsl:choose>
    <xsl:when test="$type = '1'">OSP Scanner</xsl:when>
    <xsl:when test="$type = '2'">OpenVAS Scanner</xsl:when>
    <xsl:otherwise>Unknown type (<xsl:value-of select="type"/>)</xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="scanner-type-list">
  <xsl:param name="default"/>
  <xsl:call-template name="opt">
    <xsl:with-param name="value" select="1"/>
    <xsl:with-param name="content" select="'OSP Scanner'"/>
    <xsl:with-param name="select-value" select="$default"/>
  </xsl:call-template>
  <xsl:call-template name="opt">
    <xsl:with-param name="value" select="2"/>
    <xsl:with-param name="content" select="'OpenVAS Scanner'"/>
    <xsl:with-param name="select-value" select="$default"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="solution-icon">
  <xsl:param name="solution_type" select="''"/>
  <xsl:choose>
    <xsl:when test="$solution_type = ''">
    </xsl:when>
    <xsl:when test="$solution_type = 'Workaround'">
      <img src="/img/st_workaround.png" title="{$solution_type}" alt="{$solution_type}"/>
    </xsl:when>
    <xsl:when test="$solution_type = 'Mitigation'">
      <img src="/img/st_mitigate.png" title="{$solution_type}" alt="{$solution_type}"/>
    </xsl:when>
    <xsl:when test="$solution_type = 'VendorFix'">
      <img src="/img/st_vendorfix.png" title="{$solution_type}" alt="{$solution_type}"/>
    </xsl:when>
    <xsl:when test="$solution_type = 'NoneAvailable'">
      <img src="/img/st_nonavailable.png" title="{$solution_type}" alt="{$solution_type}"/>
    </xsl:when>
    <xsl:when test="$solution_type = 'WillNotFix'">
      <img src="/img/st_willnotfix.png" title="{$solution_type}" alt="{$solution_type}"/>
    </xsl:when>
    <xsl:otherwise>
      <img src="/img/os_unknown.png" title="{$solution_type}" alt="{$solution_type}"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- BEGIN GENERAL TAGS VIEWS -->

<xsl:template name="user-tags-window-checked">
  <xsl:param name="resource_type"/>
  <xsl:param name="resource_subtype"/>
  <xsl:param name="resource_id"/>
  <xsl:param name="next"/>
  <xsl:param name="report_section"/>
  <xsl:param name="title"/>
  <xsl:param name="user_tags"/>
  <xsl:param name="tag_names"/>
  <xsl:variable name="title_shortened">
    <xsl:choose>
      <xsl:when test="string-length($title) > 80">
        <xsl:value-of select="substring($title, 0, 80)"/>[...]<xsl:if test="substring($title, string-length($title)-1, 1) = '&quot;'">&quot;</xsl:if>:
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$title"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <br/>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="$title_shortened"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="$user_tags/count != 0">
          <xsl:value-of select="$user_tags/count"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('none', 'Tags')"/>
        </xsl:otherwise>
      </xsl:choose>
      <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
        <xsl:choose>
          <xsl:when test="not (gsa:may-op ('create_tag'))"/>
          <xsl:when test="$report_section != ''">
            <a href="/omp?cmd=new_tag&amp;resource_id={$resource_id}&amp;resource_type={$resource_type}&amp;next={$next}&amp;next_type={$resource_type}&amp;next_id={$resource_id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;report_section={$report_section}&amp;token={/envelope/token}"
            title="{gsa:i18n ('New tag', 'Tag')}"
            style="margin-left:3px;">
              <img src="/img/new.png" border="0" alt="{gsa:i18n ('Add tag', 'Tag')}"/>
            </a>
          </xsl:when>
          <xsl:when test="$resource_subtype != ''">
            <a href="/omp?cmd=new_tag&amp;resource_id={$resource_id}&amp;resource_type={$resource_subtype}&amp;next={$next}&amp;next_type={$resource_type}&amp;next_subtype={$resource_subtype}&amp;next_id={$resource_id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
            title="{gsa:i18n ('New Tag', 'Tag')}"
            style="margin-left:3px;">
              <img src="/img/new.png" border="0" alt="{gsa:i18n ('Add tag', 'Tag')}"/>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <a href="/omp?cmd=new_tag&amp;resource_id={$resource_id}&amp;resource_type={$resource_type}&amp;next={$next}&amp;next_type={$resource_type}&amp;next_id={$resource_id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
            title="{gsa:i18n ('New Tag', 'Tag')}"
            style="margin-left:3px;">
              <img src="/img/new.png" border="0" alt="{gsa:i18n ('Add tag', 'Tag')}"/>
            </a>
          </xsl:otherwise>
        </xsl:choose>
      </div>
      <a href="/help/user-tags.html?token={/envelope/token}"
         title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('User Tags list', 'Tag')}">
        <img src="/img/help.png"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <xsl:if test="count(//delete_tag_response[@status!=200]|//modify_tag_response[@status!=200]|//create_tag_response[@status!=201]) = 0">
        <a name="user_tags"/>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="count($tag_names/tag) > 0">
          <div style="margin-bottom: 10px">
            <form style="display: inline; margin-left: 3px" action="/omp#user_tags" method="post" enctype="multipart/form-data">
              <label>
                <span style="margin-right: 5px">
                  <b><xsl:value-of select="gsa:i18n ('Add Tag', 'Tag')"/>:</b>
                </span>
                <select style="margin-bottom: 0px;" name="tag_name" size="1">
                  <xsl:for-each select="$tag_names/tag">
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="name/text()"/>
                    </xsl:call-template>
                  </xsl:for-each>
                </select>
              </label>
              <label>
                <span style="margin-left: 5px;">
                  <xsl:value-of select="gsa:i18n ('with Value', 'Tag')"/>:
                </span>
                <input type="text" name="tag_value"/>
              </label>
              <input type="image" src="/img/tag.png" alt="{gsa:i18n ('Add Tag', 'Tag')}"
                    name="Add Tag" value="Add Tag" title="{gsa:i18n ('Add Tag', 'Tag')}"
                    style="margin-left: 5px" />
              <input type="hidden" name="comment"/>
              <input type="hidden" name="active" value="1"/>
              <input type="hidden" name="caller" value="{/envelope/current_page}"/>
              <input type="hidden" name="token" value="{/envelope/token}"/>
              <input type="hidden" name="cmd" value="create_tag"/>
              <input type="hidden" name="resource_id" value="{$resource_id}"/>
              <xsl:choose>
                <xsl:when test="$resource_subtype!=''">
                  <input type="hidden" name="resource_type" value="{$resource_subtype}"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="hidden" name="resource_type" value="{$resource_type}"/>
                </xsl:otherwise>
              </xsl:choose>
              <input type="hidden" name="resource_id" value="{$resource_id}"/>
              <input type="hidden" name="next" value="{$next}"/>
              <xsl:choose>
                <xsl:when test="$resource_type='nvt'">
                  <input type="hidden"
                          name="oid"
                          value="{$resource_id}"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="hidden"
                          name="{$resource_type}_id"
                          value="{$resource_id}"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:if test="$resource_type='info'">
                <input type="hidden"
                      name="details"
                      value="1"/>
              </xsl:if>
              <xsl:if test="$resource_subtype != ''">
                <input type="hidden"
                        name="{$resource_type}_type"
                        value="{$resource_subtype}"/>
              </xsl:if>
              <xsl:if test="$report_section != ''">
                <input type="hidden"
                        name="report_section"
                        value="{$report_section}"/>
              </xsl:if>
            </form>
          </div>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$user_tags/count != 0">
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Value', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/></td>
              <td width="{gsa:actions-width (4)}"><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
            </tr>
            <xsl:apply-templates select="$user_tags/tag" mode="for_resource">
              <xsl:with-param name="resource_type" select="$resource_type"/>
              <xsl:with-param name="resource_subtype" select="$resource_subtype"/>
              <xsl:with-param name="resource_id"   select="$resource_id"/>
              <xsl:with-param name="next" select="$next"/>
              <xsl:with-param name="report_section" select="$report_section"/>
            </xsl:apply-templates>
          </table>
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
    </div>
  </div>
</xsl:template>

<xsl:template name="user-tags-window">
  <xsl:param name="resource_type"/>
  <xsl:param name="resource_subtype"/>
  <xsl:param name="resource_id" select="@id"/>
  <xsl:param name="next" select="concat('get_',$resource_type)"/>
  <xsl:param name="report_section" select="''"/>
  <xsl:param name="title" select="gsa-i18n:strformat (gsa:i18n('User Tags for &quot;%1&quot;', 'Tag'), name)"/>
  <xsl:param name="user_tags" select="user_tags" />
  <xsl:param name="tag_names" select="../../get_tags_response"/>
  <xsl:if test="gsa:may-op ('get_tags')">
    <xsl:call-template name="user-tags-window-checked">
      <xsl:with-param name="resource_type" select="$resource_type"/>
      <xsl:with-param name="resource_subtype" select="$resource_subtype"/>
      <xsl:with-param name="resource_id" select="$resource_id"/>
      <xsl:with-param name="next" select="$next"/>
      <xsl:with-param name="report_section" select="$report_section"/>
      <xsl:with-param name="title" select="$title"/>
      <xsl:with-param name="user_tags" select="$user_tags"/>
      <xsl:with-param name="tag_names" select="$tag_names"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template match="tag" mode="for_resource">
  <xsl:param name="resource_type"/>
  <xsl:param name="resource_subtype"/>
  <xsl:param name="resource_id"/>
  <xsl:param name="next"/>
  <xsl:param name="report_section" select="''"/>

  <tr class="{gsa:table-row-class(position())}">
    <td><xsl:value-of select="name"/></td>
    <td><xsl:value-of select="value"/></td>
    <td><xsl:value-of select="comment"/></td>
    <td>

      <xsl:call-template name="toggle-tag-icon">
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="enable" select="0"/>
        <xsl:with-param name="params">
          <input type="hidden" name="next" value="{$next}"/>
          <xsl:choose>
            <xsl:when test="$resource_type='nvt'">
              <input type="hidden" name="oid" value="{$resource_id}"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="hidden" name="{concat($resource_type,'_id')}" value="{$resource_id}"/>
            </xsl:otherwise>
          </xsl:choose>
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <xsl:if test="$resource_subtype != ''">
            <input type="hidden"
                   name="{$resource_type}_type"
                   value="{$resource_subtype}"/>
          </xsl:if>
          <xsl:if test="$resource_type = 'info'">
            <input type="hidden"
                   name="details"
                   value="1"/>
          </xsl:if>
          <xsl:if test="$report_section != ''">
            <input type="hidden"
                    name="report_section"
                    value="{$report_section}"/>
          </xsl:if>
        </xsl:with-param>
        <xsl:with-param name="fragment" select="'#user_tags'"/>
      </xsl:call-template>

      <xsl:call-template name="trashcan-icon">
        <xsl:with-param name="type" select="'tag'"/>
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="params">
          <input type="hidden" name="next" value="{$next}"/>
          <xsl:choose>
            <xsl:when test="$resource_type='nvt'">
              <input type="hidden" name="oid" value="{$resource_id}"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="hidden" name="{concat($resource_type,'_id')}" value="{$resource_id}"/>
            </xsl:otherwise>
          </xsl:choose>
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <xsl:if test="$resource_subtype != ''">
            <input type="hidden"
                   name="{$resource_type}_type"
                   value="{$resource_subtype}"/>
          </xsl:if>
          <xsl:if test="$resource_type = 'info'">
            <input type="hidden"
                   name="details"
                   value="1"/>
          </xsl:if>
          <xsl:if test="$report_section != ''">
            <input type="hidden"
                    name="report_section"
                    value="{$report_section}"/>
          </xsl:if>
        </xsl:with-param>
        <xsl:with-param name="fragment" select="'#user_tags'"/>
      </xsl:call-template>

      <a href="/omp?cmd=get_tag&amp;tag_id={@id}&amp;token={/envelope/token}"
          title="{gsa:i18n ('Tag Details', 'Tag')}">
        <img src="/img/details.png" border="0" style="margin-left:3px;"/>
      </a>

      <xsl:choose>
        <xsl:when test="$report_section != ''">
          <a href="/omp?cmd=edit_tag&amp;tag_id={@id}&amp;next={$next}&amp;next_type={$resource_type}&amp;next_subtype={$resource_subtype}&amp;next_id={$resource_id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;report_section={$report_section}&amp;token={/envelope/token}"
          title="{gsa:i18n ('Edit Tag', 'Tag')}">
            <img src="/img/edit.png" border="0" style="margin-left:3px;"/>
          </a>
        </xsl:when>
        <xsl:when test="$resource_subtype!=''">
          <a href="/omp?cmd=edit_tag&amp;tag_id={@id}&amp;next={$next}&amp;next_type={$resource_type}&amp;next_subtype={$resource_subtype}&amp;next_id={$resource_id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
              title="{gsa:i18n ('Edit Tag', 'Tag')}">
            <img src="/img/edit.png" border="0" style="margin-left:3px;"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=edit_tag&amp;tag_id={@id}&amp;next={$next}&amp;next_type={$resource_type}&amp;next_subtype={$resource_subtype}&amp;next_id={$resource_id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
          title="{gsa:i18n ('Edit Tag', 'Tag')}">
            <img src="/img/edit.png" border="0" style="margin-left:3px;"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template name="toggle-tag-icon">
  <xsl:param name="id"></xsl:param>
  <xsl:param name="enable"></xsl:param>
  <xsl:param name="fragment"></xsl:param>
  <xsl:param name="params"></xsl:param>

  <xsl:if test="gsa:may-op ('modify_tag')">
    <div style="display: inline">
      <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp{$fragment}" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="cmd" value="toggle_tag"/>
        <input type="hidden" name="enable" value="{$enable}"/>
        <input type="hidden" name="tag_id" value="{$id}"/>
        <xsl:choose>
          <xsl:when test="$enable">
            <input type="image" src="/img/enable.png" alt="{gsa:i18n ('Enable Tag', 'Tag')}"
                   name="Enable Tag" value="Enable Tag" title="{gsa:i18n ('Enable Tag', 'Tag')}"/>
          </xsl:when>
          <xsl:otherwise>
            <input type="image" src="/img/disable.png" alt="{gsa:i18n ('Disable Tag', 'Tag')}"
                   name="Disable Tag" value="Disable Tag" title="{gsa:i18n ('Disable Tag', 'Tag')}"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:copy-of select="$params"/>
      </form>
    </div>
  </xsl:if>
</xsl:template>

<xsl:template name="user_tag_list">
  <xsl:param name="user_tags" select="user_tags" />
  <xsl:for-each select="user_tags/tag">
    <a href="/omp?cmd=get_tag&amp;tag_id={@id}&amp;token={/envelope/token}">
      <xsl:value-of select="name"/>
      <xsl:if test="value != ''">=<xsl:value-of select="value"/></xsl:if>
    </a>
    <xsl:if test="position()!=last()"><xsl:text>, </xsl:text></xsl:if>
  </xsl:for-each>
</xsl:template>

<!-- Resource Permissions -->
<xsl:template name="resource-permissions-window">
  <xsl:param name="resource_type"/>
  <xsl:param name="resource_id" select="@id"/>
  <xsl:param name="next" select="concat('get_',$resource_type)"/>
  <xsl:param name="report_section" select="''"/>
  <!-- i18n with concat : see dynamic_strings.xsl - type-permissions -->
  <xsl:param name="title" select="gsa-i18n:strformat (gsa:i18n (concat ('Permissions for ', gsa:type-name ($resource_type), ' &quot;%1&quot;'), gsa:type-name ($resource_type)), name)"/>
  <xsl:param name="permissions" select="../../permissions/get_permissions_response"/>
  <xsl:param name="related" select="''"/>
  <xsl:variable name="token" select="/envelope/token"/>
  <xsl:variable name="title_shortened">
    <xsl:choose>
      <xsl:when test="string-length($title) > 80">
        <xsl:value-of select="substring($title, 0, 80)"/>[...]<xsl:if test="substring($title, string-length($title)-1, 1) = '&quot;'">&quot;</xsl:if>:
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$title"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:if test="gsa:may-op ('get_permissions')">
    <xsl:variable name="related_params">
      <xsl:for-each select="exslt:node-set ($related)/*">
        <xsl:text>related:</xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>=</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text>&amp;</xsl:text>
      </xsl:for-each>
    </xsl:variable>
    <div class="gb_window">
      <div class="gb_window_part_left"></div>
      <div class="gb_window_part_right"></div>
      <div class="gb_window_part_center">
        <xsl:value-of select="$title_shortened"/>
        <xsl:text> </xsl:text>
        <xsl:choose>
          <xsl:when test="$permissions/permission_count/filtered != 0">
            <xsl:value-of select="$permissions/permission_count/filtered"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('none', 'Permissions')"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="gsa:may-op ('create_permission')">
            <a href="/omp?cmd=new_permission&amp;next={$next}&amp;next_id={$resource_id}&amp;next_type={$resource_type}&amp;resource_id={$resource_id}&amp;restrict_type={$resource_type}&amp;{$related_params}token={/envelope/token}"
                title="{gsa:i18n ('New Permission', 'Permission')}">
              <img style="margin-left:5px" src="/img/new.png" alt="{gsa:i18n ('New Permission', 'Permission')}"/>
            </a>
          </xsl:when>
          <xsl:otherwise/>
        </xsl:choose>
        <a href="/omp?cmd=get_permissions&amp;filter=name:^.*({$resource_type})s?$ and resource_uuid={$resource_id}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Permissions', 'Permission')}">
          <img style="margin-left:3px" src="/img/list.png"/>
        </a>
        <a href="/help/resource_permissions.html?token={/envelope/token}"
           title="Help: Resource Permissions">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </div>
      <div class="gb_window_part_content">
        <table class="gbntable" cellspacing="2" cellpadding="4">
          <tr class="gbntablehead2">
            <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td><xsl:value-of select="gsa:i18n ('Description', 'Property')"/></td>
            <td><xsl:value-of select="gsa:i18n ('Resource Type', 'Property')"/></td>
            <td><xsl:value-of select="gsa:i18n ('Resource', 'Property')"/></td>
            <td><xsl:value-of select="gsa:i18n ('Subject Type', 'Permission')"/></td>
            <td><xsl:value-of select="gsa:i18n ('Subject', 'Permission')"/></td>
            <td width="{gsa:actions-width (4)}"><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
          </tr>
          <xsl:apply-templates select="$permissions/permission">
            <xsl:with-param name="next" select="$next"/>
            <xsl:with-param name="next_type" select="$resource_type"/>
            <xsl:with-param name="next_id" select="$resource_id"/>
          </xsl:apply-templates>
        </table>
      </div>
    </div>
  </xsl:if>
</xsl:template>

<!-- BEGIN REPORTS MANAGEMENT -->

<xsl:template match="sort">
</xsl:template>

<xsl:template match="apply_overrides">
</xsl:template>

<xsl:template match="all">
</xsl:template>

<xsl:template match="get_reports_response" mode="alert">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Run Alert</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="assets">
  <xsl:variable name="levels"
                select="report/filters/text()"/>
  <xsl:variable name="apply-overrides"
                select="report/filters/apply_overrides"/>
  <xsl:if test="report/@scap_loaded = 0">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SCAP Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP database missing on OMP server.  Prognostic reporting disabled.
        <a href="/help/hosts.html?token={/envelope/token}#scap_missing"
           title="Help: SCAP database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Host Filtering', 'Host')"/>
      <a href="/help/hosts.html?token={/envelope/token}" title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Hosts', 'Host'))}">
        <img src="/img/help.png" border="0"/>
      </a>
      <div id="small_inline_form" style="display: inline; margin-left: 40px; font-weight: normal;">
        <form action="" method="get" name="switch_overrides" enctype="multipart/form-data">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="get_report"/>
          <input type="hidden" name="type" value="assets"/>
          <input type="hidden" name="levels" value="{$levels}"/>
          <input type="hidden" name="search_phrase" value="{report/filters/phrase}"/>
          <!-- Switch back to the first page if the override state changes, because
               this could lead to changes in the number of hosts in the table. -->
          <input type="hidden" name="first_result" value="1"/>
          <input type="hidden" name="max_results" value="{report/hosts/@max}"/>
          <select style="margin-bottom: 0px;" name="overrides" size="1" onchange="switch_overrides.submit ()">
            <xsl:choose>
              <xsl:when test="$apply-overrides = 0">
                <option value="0" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('No overrides', 'Override Controls')"/></option>
                <option value="1" ><xsl:value-of select="gsa:i18n ('Apply overrides', 'Override Controls')"/></option>
              </xsl:when>
              <xsl:otherwise>
                <option value="0"><xsl:value-of select="gsa:i18n ('No overrides', 'Override Controls')"/></option>
                <option value="1" selected="1">&#8730;<xsl:value-of select="gsa:i18n ('Apply overrides', 'Override Controls')"/></option>
              </xsl:otherwise>
            </xsl:choose>
          </select>
          <input type="image"
                 name="{gsa:i18n ('Update', 'Action Verb')}"
                 src="/img/refresh.png"
                 title="{gsa:i18n ('Update', 'Action Verb')}"
                 alt="{gsa:i18n ('Update', 'Action Verb')}" style="margin-left:3px;margin-right:3px;"/>
        </form>
      </div>
    </div>
    <div class="gb_window_part_content">
      <div style="background-color: #EEEEEE;">
        <xsl:variable name="sort_field">
          <xsl:value-of select="report/sort/field/text()"/>
        </xsl:variable>
        <xsl:variable name="sort_order">
          <xsl:value-of select="report/sort/field/order"/>
        </xsl:variable>
        <form action="" method="get" enctype="multipart/form-data">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="get_report"/>
          <input type="hidden" name="type" value="assets"/>
          <input type="hidden" name="sort_field" value="{$sort_field}"/>
          <input type="hidden" name="sort_order" value="{$sort_order}"/>
          <input type="hidden"
                 name="overrides"
                 value="{report/filters/apply_overrides}"/>
          <div style="padding: 2px;">
            <xsl:value-of select="gsa:i18n ('Results per page', 'Filter')"/>:
            <input type="text" name="max_results" size="5"
                   value="{report/hosts/@max}"
                   maxlength="400"/>
          </div>
          <div style="padding: 2px;">
            <xsl:value-of select="gsa:i18n ('Text phrase', 'Report Filter')"/>:
            <input type="text" name="search_phrase" size="50"
                   value="{report/filters/phrase}"
                   maxlength="400"/>
          </div>
          <div style="float: right">
            <input type="submit" value="{gsa:i18n ('Apply', 'Action Verb')}" title="{gsa:i18n ('Apply', 'Action Verb')}"/>
          </div>
          <div style="padding: 2px;">
            <xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:
            <table style="display: inline">
              <tr>
                <td class="threat_info_table_h">
                  <label>
                    <xsl:choose>
                      <xsl:when test="report/filters/filter[text()='High']">
                        <input type="checkbox" name="level_high" value="1"
                               checked="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="checkbox" name="level_high" value="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="severity-label">
                      <xsl:with-param name="level" select="'High'"/>
                    </xsl:call-template>
                  </label>
                </td>
                <td class="threat_info_table_h">
                  <label>
                    <xsl:choose>
                      <xsl:when test="report/filters/filter[text()='Medium']">
                        <input type="checkbox" name="level_medium" value="1"
                               checked="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="checkbox" name="level_medium" value="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="severity-label">
                      <xsl:with-param name="level" select="'Medium'"/>
                    </xsl:call-template>
                  </label>
                </td>
                <td class="threat_info_table_h">
                  <label>
                    <xsl:choose>
                      <xsl:when test="report/filters/filter[text()='Low']">
                        <input type="checkbox" name="level_low" value="1"
                               checked="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="checkbox" name="level_low" value="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="severity-label">
                      <xsl:with-param name="level" select="'Low'"/>
                    </xsl:call-template>
                  </label>
                </td>
                <td class="threat_info_table_h">
                  <label>
                    <xsl:choose>
                      <xsl:when test="report/filters/filter[text()='Log']">
                        <input type="checkbox" name="level_log" value="1"
                               checked="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="checkbox" name="level_log" value="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="severity-label">
                      <xsl:with-param name="level" select="'Log'"/>
                    </xsl:call-template>
                  </label>
                </td>
              </tr>
            </table>
          </div>
        </form>
      </div>
    </div>
  </div>
  <br/>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Filtered Hosts', 'Host')"/>
      <xsl:choose>
        <xsl:when test="count(report/host) &gt; 0">
          <xsl:variable name="last" select="report/hosts/@start + count(report/host) - 1"/>
          <xsl:choose>
            <xsl:when test = "report/hosts/@start &gt; 1">
              <a href="?cmd=get_report&amp;type=assets&amp;first_result=1&amp;max_results={report/hosts/@max}&amp;sort_field={report/sort/field/text()}&amp;sort_order={report/sort/field/order}&amp;overrides={report/filters/apply_overrides}&amp;search_phrase={report/filters/phrase}&amp;levels={$levels}&amp;search_phrase={report/filters/phrase}&amp;token={/envelope/token}"><img style="margin-left:10px;margin-right:3px;" src="/img/first.png" border="0" title="{gsa:i18n ('First', 'Pagination')}"/></a>
              <a href="?cmd=get_report&amp;type=assets&amp;first_result={report/hosts/@start - report/hosts/@max}&amp;max_results={report/hosts/@max}&amp;sort_field={report/sort/field/text()}&amp;sort_order={report/sort/field/order}&amp;overrides={report/filters/apply_overrides}&amp;search_phrase={report/filters/phrase}&amp;levels={$levels}&amp;search_phrase={report/filters/phrase}&amp;token={/envelope/token}"><img style="margin-right:3px;" src="/img/previous.png" border="0" title="{gsa:i18n ('Previous', 'Pagination')}"/></a>
            </xsl:when>
            <xsl:otherwise>
              <img style="margin-left:10px;margin-right:3px;" src="/img/first_inactive.png" border="0" title="{gsa:i18n ('Already on first page', 'Pagination')}"/>
              <img style="margin-right:3px;" src="/img/previous_inactive.png" border="0" title="{gsa:i18n ('Already on first page', 'Pagination')}"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="report/hosts/@start"/> -
          <xsl:value-of select="$last"/>
          <xsl:value-of select="gsa:i18n (' of ', 'Pagination')"/>
          <xsl:value-of select="report/host_count/filtered"/>
          <xsl:choose>
            <xsl:when test = "$last &lt; report/host_count/filtered">
              <a href="?cmd=get_report&amp;type=assets&amp;first_result={report/hosts/@start + report/hosts/@max}&amp;max_results={report/hosts/@max}&amp;overrides={report/filters/apply_overrides}&amp;search_phrase={report/filters/phrase}&amp;levels={$levels}&amp;search_phrase={report/filters/phrase}&amp;token={/envelope/token}"><img style="margin-left:3px;" src="/img/next.png" border="0" title="{gsa:i18n ('Next', 'Pagination')}"/></a>
              <a href="?cmd=get_report&amp;type=assets&amp;first_result={floor((report/host_count/filtered - 1) div report/hosts/@max) * report/hosts/@max + 1}&amp;max_results={report/hosts/@max}&amp;overrides={report/filters/apply_overrides}&amp;search_phrase={report/filters/phrase}&amp;levels={$levels}&amp;search_phrase={report/filters/phrase}&amp;token={/envelope/token}"><img style="margin-left:3px;margin-right:10px;" src="/img/last.png" border="0" title="{gsa:i18n ('Last', 'Pagination')}"/></a>
            </xsl:when>
            <xsl:otherwise>
              <img style="margin-left:3px;" src="/img/next_inactive.png" border="0" title="{gsa:i18n ('Already on last page', 'Pagination')}"/>
              <img style="margin-left:3px;margin-right:10px;" src="/img/last_inactive.png" border="0" title="{gsa:i18n ('Already on last page', 'Pagination')}"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
      <a style="margin-left: 7px" href="/help/hosts.html?token={/envelope/token}" title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Hosts', 'Host'))}">
        <img src="/img/help.png" border="0"/>
      </a>
      <xsl:choose>
        <xsl:when test="count (report/host) = 0">
          <xsl:variable name="desc"
                        select="gsa:i18n ('No hosts available for Prognostic Report', 'Host')"/>
          <img src="/img/prognosis_inactive.png" border="0"
               style="margin-left:3px;"
               title="{$desc}"
               alt="{$desc}"/>
        </xsl:when>
        <xsl:when test="report/@scap_loaded = 0">
          <xsl:variable name="desc"
                        select="gsa:i18n ('No SCAP data available for Prognostic Report', 'Host')"/>
          <img src="/img/prognosis_inactive.png" border="0"
               style="margin-left:3px;"
               title="{$desc}"
               alt="{$desc}"/>
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=get_report&amp;type=prognostic&amp;pos=1&amp;host_search_phrase={report/filters/phrase}&amp;host_levels={gsa:build-levels(report/filters)}&amp;host_first_result={report/hosts/@start}&amp;host_max_results={report/hosts/@max}&amp;result_hosts_only=1&amp;overrides={$apply-overrides}&amp;token={/envelope/token}"
             title="{gsa:i18n ('Prognostic Report', 'Host')}" style="margin-left:3px;">
            <img src="/img/prognosis.png" border="0" alt="{gsa:i18n ('Prognostic Report', 'Host')}"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </div>
    <xsl:choose>
      <xsl:when test="count (report/host)=0">
        <div class="gb_window_part_content">
          <xsl:value-of select="gsa:i18n ('0 hosts', 'Host')"/>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="gb_window_part_content">
          <xsl:apply-templates select="report" mode="assets"/>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </div>
</xsl:template>

<xsl:template match="report" mode="sorting-link">
  <xsl:param name="field"/>
  <xsl:param name="order"/>
  <xsl:param name="levels"/>
  <xsl:param name="name"><xsl:value-of select="$field"/></xsl:param>

  <xsl:choose>
    <xsl:when test="sort/field/text() = $field and sort/field/order = $order">
      <xsl:value-of select="concat($name, ' ', $order)"/>
    </xsl:when>
    <xsl:otherwise>
        <a href="/omp?cmd=get_report&amp;report_id={@id}&amp;delta_report_id={delta/report/@id}&amp;delta_states={filters/delta/text()}&amp;sort_field={$field}&amp;sort_order={$order}&amp;max_results={results/@max}&amp;levels={$levels}&amp;notes={filters/notes}&amp;filterbox={/envelope/params/filterbox}&amp;details={/envelope/params/details}&amp;overrides={filters/overrides}&amp;result_hosts_only={filters/result_hosts_only}&amp;autofp={filters/autofp}&amp;token={/envelope/token}">
        <xsl:value-of select="concat($name, ' ', $order)"/>
      </a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="report" mode="results-pager">
  <xsl:variable name="levels"
                select="report/filters/text()"/>

  <xsl:variable name="common_filter"
                select="concat ('max_results=', report/results/@max,
                                '&amp;levels=', $levels,
                                '&amp;sort_field=', report/sort/field/text(),
                                '&amp;sort_order=', report/sort/field/order,
                                '&amp;notes=', report/filters/notes,
                                '&amp;overrides=', report/filters/apply_overrides,
                                '&amp;result_hosts_only=', report/filters/result_hosts_only,
                                '&amp;apply_min_cvss_base=', number (string-length (report/filters/min_cvss_base) &gt; 0),
                                '&amp;min_cvss_base=', report/filters/min_cvss_base,
                                '&amp;apply_min_qod=', number (string-length (report/filters/min_qod) &gt; 0),
                                '&amp;min_qod=', report/filters/min_qod,
                                '&amp;search_phrase=', report/filters/phrase,
                                '&amp;search_phrase_exact=', number (contains (report/filters/term, concat ('=', report/filters/phrase)) or contains (report/filters/term, concat ('=&quot;', report/filters/phrase, '&quot;'))),
                                '&amp;autofp=', report/filters/autofp,
                                '&amp;delta_states=', report/filters/delta/text())"/>

  <xsl:variable name="last" select="report/results/@start + count(report/results/result) - 1"/>
  <xsl:choose>
    <xsl:when test = "report/results/@start &lt;= 1">
      <img style="vertical-align: text-top; margin-left:10px;margin-right:3px;"
           src="/img/first_inactive.png" border="0" title="{gsa:i18n ('Already on first page', 'Pagination')}"/>
      <img style="vertical-align: text-top; margin-right:3px;"
           src="/img/previous_inactive.png" border="0" title="{gsa:i18n ('Already on first page', 'Pagination')}"/>
    </xsl:when>
    <xsl:when test="../../delta">
      <a href="?cmd=get_report&amp;{$common_filter}&amp;delta_report_id={../../delta}&amp;report_id={report/@id}&amp;first_result=1&amp;delta_states={report/filters/delta/text()}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:10px;margin-right:3px;" src="/img/first.png" border="0" title="{gsa:i18n ('First', 'Pagination')}"/></a>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;delta_report_id={../../delta}&amp;report_id={report/@id}&amp;first_result={report/results/@start - report/results/@max}&amp;delta_states={report/filters/delta/text()}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-right:3px;" src="/img/previous.png" border="0" title="{gsa:i18n ('Previous', 'Pagination')}"/></a>
    </xsl:when>
    <xsl:when test="@type='prognostic'">
      <a href="?cmd=get_report&amp;{$common_filter}&amp;type=prognostic&amp;host={report/filters/host}&amp;pos=1&amp;host_search_phrase={../../host_search_phrase}&amp;host_levels={../../host_levels}&amp;host_first_result={../../results/@start}&amp;host_max_results={../../results/@max}&amp;first_result=1&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:10px;margin-right:3px;" src="/img/first.png" border="0" title="{gsa:i18n ('First', 'Pagination')}"/></a>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;type=prognostic&amp;host={report/filters/host}&amp;pos=1&amp;host_search_phrase={../../host_search_phrase}&amp;host_levels={../../host_levels}&amp;host_first_result={../../results/@start}&amp;host_max_results={../../results/@max}&amp;first_result={report/results/@start - report/results/@max}&amp;token={/envelope/token}">
        <img style="vertical-align: text-top; margin-right:3px;" src="/img/previous.png" border="0" title="{gsa:i18n ('Previous', 'Pagination')}"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;report_id={report/@id}&amp;first_result=1&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:10px;margin-right:3px;" src="/img/first.png" border="0" title="{gsa:i18n ('First', 'Pagination')}"/></a>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;report_id={report/@id}&amp;first_result={report/results/@start - report/results/@max}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-right:3px;" src="/img/previous.png" border="0" title="{gsa:i18n ('Previous', 'Pagination')}"/></a>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:call-template name="report-section-pager">
    <xsl:with-param name="start" select="report/results/@start"/>
    <xsl:with-param name="current" select="$last"/>
    <xsl:with-param name="filtered" select="report/result_count/filtered"/>
    <xsl:with-param name="total" select="report/result_count/full"/>
  </xsl:call-template>

  <xsl:choose>
    <xsl:when test = "$last &gt;= report/result_count/filtered">
      <img style="vertical-align: text-top; margin-left:3px;"
           src="/img/next_inactive.png" border="0" title="{gsa:i18n ('Already on last page', 'Pagination')}"/>
      <img style="vertical-align: text-top; margin-left:3px;margin-right:10px;"
           src="/img/last_inactive.png" border="0" title="{gsa:i18n ('Already on last page', 'Pagination')}"/>
    </xsl:when>
    <xsl:when test="../../delta">
      <a href="?cmd=get_report&amp;{$common_filter}&amp;delta_report_id={../../delta}&amp;report_id={report/@id}&amp;first_result={report/results/@start + report/results/@max}&amp;delta_states={report/filters/delta/text()}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:3px;" src="/img/next.png" border="0" title="{gsa:i18n ('Next', 'Pagination')}"/></a>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;delta_report_id={../../delta}&amp;report_id={report/@id}&amp;first_result={floor((report/result_count/filtered - 1) div report/results/@max) * report/results/@max + 1}&amp;delta_states={report/filters/delta/text()}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:3px;margin-right:10px;" src="/img/last.png" border="0" title="{gsa:i18n ('Last', 'Pagination')}"/></a>
    </xsl:when>
    <xsl:when test="@type='prognostic'">
      <a href="?cmd=get_report&amp;{$common_filter}&amp;type=prognostic&amp;host={report/filters/host}&amp;pos=1&amp;host_search_phrase={../../host_search_phrase}&amp;host_levels={../../host_levels}&amp;host_first_result={../../results/@start}&amp;host_max_results={../../results/@max}&amp;first_result={report/results/@start + report/results/@max}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:3px;" src="/img/next.png" border="0" title="{gsa:i18n ('Next', 'Pagination')}"/></a>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;type=prognostic&amp;host={report/filters/host}&amp;pos=1&amp;host_search_phrase={../../host_search_phrase}&amp;host_levels={../../host_levels}&amp;host_first_result={../../results/@start}&amp;host_max_results={../../results/@max}&amp;first_result={floor((report/result_count/filtered - 1) div report/results/@max) * report/results/@max + 1}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:3px;margin-right:10px;" src="/img/last.png" border="0" title="{gsa:i18n ('Last', 'Pagination')}"/></a>
    </xsl:when>
    <xsl:otherwise>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;report_id={report/@id}&amp;first_result={report/results/@start + report/results/@max}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:3px;" src="/img/next.png" border="0" title="{gsa:i18n ('Next', 'Pagination')}"/></a>
      <a href="?cmd=get_report&amp;{$common_filter}&amp;report_id={report/@id}&amp;first_result={floor((report/result_count/filtered - 1) div report/results/@max) * report/results/@max + 1}&amp;token={/envelope/token}"><img style="vertical-align: text-top; margin-left:3px;margin-right:10px;" src="/img/last.png" border="0" title="{gsa:i18n ('Last', 'Pagination')}"/></a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="fold-filter-icon-img">
  <xsl:param name="fold"/>
  <xsl:choose>
    <xsl:when test="$fold &gt; 0">
      <img src="/img/fold.png"
           style="vertical-align:middle;margin-left:2px;margin-right:2px;"
           alt="{gsa:i18n ('Fold filter', 'Filter')}" title="{gsa:i18n ('Fold filter', 'Filter')}"/>
    </xsl:when>
    <xsl:otherwise>
      <img src="/img/unfold.png"
           style="vertical-align:middle;margin-left:2px;margin-right:2px;"
           alt="{gsa:i18n ('Unfold filter', 'Filter')}" title="{gsa:i18n ('Unfold filter', 'Filter')}"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="report" mode="fold-filter-icon">
  <xsl:variable name="fold">
    <xsl:choose>
      <xsl:when test="/envelope/params/filterbox &gt; 0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="filter_term">
    <xsl:choose>
      <xsl:when test="/envelope/params/cmd='get_report_section' and /envelope/params/report_section != 'results' and /envelope/params/report_section != 'summary'">
        <xsl:value-of select="/envelope/params/filter"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="filters/term"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="filterbox" select="($fold - 1)*($fold - 1)"/>
  <xsl:variable name="apply_filter" select="/envelope/params/apply_filter"/>
  <xsl:variable name="host" select="/envelope/params/host"/>
  <xsl:variable name="pos" select="/envelope/params/pos"/>
  <xsl:variable name="delta" select="delta/report/@id"/>

  <xsl:variable name="link">
    <xsl:choose>
      <xsl:when test="@type='prognostic'">
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;type=prognostic&amp;host=', $host, '&amp;pos=', $pos, '&amp;filterbox=', $filterbox, '&amp;apply_filter=', $apply_filter, '&amp;details=', /envelope/params/details, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:when test="@type='delta'">
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;report_id=', @id, '&amp;delta_report_id=', $delta, '&amp;filterbox=', $filterbox, '&amp;apply_filter=', $apply_filter, '&amp;details=', /envelope/params/details, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:when test="/envelope/params/cmd = 'get_report_section'">
        <xsl:value-of select="concat('/omp?cmd=get_report_section&amp;report_section=', /envelope/params/report_section, '&amp;report_id=', @id, '&amp;delta_report_id=', $delta, '&amp;filterbox=', $filterbox, '&amp;apply_filter=', $apply_filter, '&amp;details=', /envelope/params/details, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;report_id=', @id, '&amp;filterbox=', $filterbox, '&amp;apply_filter=', $apply_filter, '&amp;details=', /envelope/params/details, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="title">
    <xsl:choose>
      <xsl:when test="$fold=1">
        <xsl:value-of select="gsa:i18n ('Fold filter', 'Filter')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="gsa:i18n ('Unfold filter', 'Filter')"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <a href="{$link}"
     title="{$title}">
     <xsl:call-template name="fold-filter-icon-img">
       <xsl:with-param name="fold" select="$fold"/>
     </xsl:call-template>
  </a>
</xsl:template>

<xsl:template name="result-details-icon-img">
  <xsl:param name="details"/>
  <xsl:choose>
    <xsl:when test="$details = 1">
      <img src="/img/fold.png"
           style="vertical-align:middle;margin-left:2px;margin-right:2px;"
           alt="{gsa:i18n ('Collapse details of all vulnerabilities', 'Result')}"
           title="{gsa:i18n ('Collapse details of all vulnerabilities', 'Result')}"/>
    </xsl:when>
    <xsl:otherwise>
      <img src="/img/unfold.png"
           style="vertical-align:middle;margin-left:2px;margin-right:2px;"
           alt="{gsa:i18n ('Expand to full details of all vulnerabilities', 'Result')}"
           title="{gsa:i18n ('Expand to full details of all vulnerabilities', 'Result')}"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="report" mode="result-details-icon">
  <xsl:variable name="details">
    <xsl:choose>
      <xsl:when test="/envelope/params/details &gt; 0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="filter_term">
    <xsl:choose>
      <xsl:when test="/envelope/params/cmd='get_report_section' and /envelope/params/report_section != 'results'">
        <xsl:value-of select="/envelope/params/filter"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="filters/term"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="host" select="/envelope/params/host"/>
  <xsl:variable name="pos" select="/envelope/params/pos"/>
  <xsl:variable name="delta" select="delta/report/@id"/>

  <xsl:variable name="expand" select="($details - 1)*($details - 1)"/>
  <xsl:variable name="apply_filter" select="/envelope/params/apply_filter"/>
  <xsl:variable name="link">
    <xsl:choose>
      <xsl:when test="@type='prognostic'">
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;type=prognostic&amp;host=', $host, '&amp;pos=',$pos ,'&amp;details=', $expand, '&amp;apply_filter=', $apply_filter, '&amp;filterbox=', /envelope/params/filterbox, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:when test="@type='delta'">
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;report_id=', @id, '&amp;delta_report_id=', $delta, '&amp;details=', $expand, '&amp;apply_filter=', $apply_filter, '&amp;filterbox=', /envelope/params/filterbox, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;report_id=', @id, '&amp;details=', $expand, '&amp;apply_filter=', $apply_filter, '&amp;filterbox=', /envelope/params/filterbox, '&amp;filter=', $filter_term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="title">
    <xsl:choose>
      <xsl:when test="$expand=1">
        <xsl:value-of select="'Expand to full details of all vulnerabilities'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'Collapse details of all vulnerabilities'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <a href="{$link}" title="{$title}">
     <xsl:call-template name="result-details-icon-img">
       <xsl:with-param name="details" select="$details"/>
     </xsl:call-template>
  </a>
</xsl:template>

<xsl:template name="result-overrides-icon-img">
  <xsl:param name="overrides"/>
  <xsl:choose>
    <xsl:when test="$overrides = 1">
      <img src="/img/overrides_enabled.png"
           alt="{gsa:i18n('Overrides are Applied', 'Override Controls')}"
           value="Overrides are Applied"
           title="{gsa:i18n('Overrides are Applied', 'Override Controls')}"
           style="margin-left:3px;margin-right:3px;"/>
    </xsl:when>
    <xsl:otherwise>
      <img src="/img/overrides_disabled.png"
           alt="{gsa:i18n('No Overrides', 'Override Controls')}"
           value="No Overrides"
           title="{gsa:i18n('No Overrides', 'Override Controls')}"
           style="margin-left:3px;margin-right:3px;"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="report" mode="result-overrides-icon">
  <xsl:variable name="details">
    <xsl:choose>
      <xsl:when test="/envelope/params/details &gt; 0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="overrides">
    <xsl:choose>
      <xsl:when test="filters/apply_overrides = 0">0</xsl:when>
      <xsl:otherwise>1</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="link-overrides">
    <xsl:choose>
      <xsl:when test="$overrides = 0">1</xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="host" select="/envelope/params/host"/>
  <xsl:variable name="pos" select="/envelope/params/pos"/>
  <xsl:variable name="delta" select="delta/report/@id"/>
  <xsl:variable name="apply_filter" select="/envelope/params/apply_filter"/>

  <xsl:variable name="link">
    <xsl:choose>
      <xsl:when test="@type='prognostic'">
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;type=prognostic&amp;host=', $host, '&amp;pos=',$pos ,'&amp;details=', $details, '&amp;apply_filter=', $apply_filter, '&amp;filterbox=', /envelope/params/filterbox, '&amp;filter=apply_overrides=', $link-overrides, ' ', filters/term, '&amp;filt_id=', /envelope/params/filt_id, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:when test="@type='delta'">
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;report_id=', @id, '&amp;delta_report_id=', $delta, '&amp;details=', $details, '&amp;apply_filter=', $apply_filter, '&amp;filterbox=', /envelope/params/filterbox, '&amp;filter=apply_overrides=', $link-overrides, ' ', filters/term, '&amp;token=', /envelope/token)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat('/omp?cmd=get_report&amp;report_id=', @id, '&amp;details=', $details, '&amp;apply_filter=', $apply_filter, '&amp;filterbox=', /envelope/params/filterbox, '&amp;filter=apply_overrides=', $link-overrides, ' ', filters/term, '&amp;filt_id=&amp;token=', /envelope/token)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="title">
    <xsl:choose>
      <xsl:when test="$overrides='1'">
        <xsl:value-of select="'Overrides are Applied'"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'No Overrides'"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <a href="{$link}" title="{$title}">
    <xsl:call-template name="result-overrides-icon-img">
      <xsl:with-param name="overrides" select="$overrides"/>
    </xsl:call-template>
  </a>
</xsl:template>

<xsl:template match="report" mode="filterbox">
  <xsl:if test="/envelope/params/filterbox &gt; 0">
    <div style="background-color: #EEEEEE;">
      <form action="" method="get" enctype="multipart/form-data">
        <xsl:choose>
          <xsl:when test="/envelope/params/report_section != ''">
            <input type="hidden" name="report_section" value="{/envelope/params/report_section}"/>
            <input type="hidden" name="cmd" value="get_report_section"/>
          </xsl:when>
          <xsl:otherwise>
            <input type="hidden" name="cmd" value="get_report"/>
          </xsl:otherwise>
        </xsl:choose>
        <input type="hidden" name="report_id" value="{report/@id}"/>
        <xsl:if test="@type='prognostic'">
          <input type="hidden" name="type" value="prognostic"/>
          <input type="hidden" name="host" value="{report/filters/host}"/>
          <input type="hidden" name="host_search_phrase" value="{../../host_search_phrase}"/>
          <input type="hidden" name="host_levels" value="{../../host_levels}"/>
          <input type="hidden" name="host_first_result" value="{../../results/@start}"/>
          <input type="hidden" name="host_max_results" value="{../../results/@max}"/>
          <input type="hidden" name="pos" value="{/envelope/params/pos}"/>
        </xsl:if>
        <input type="hidden" name="details" value="{/envelope/params/details}"/>
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <xsl:if test="../../delta">
          <input type="hidden" name="delta_report_id" value="{report/delta/report/@id}"/>
          <div style="float: right;">
            <div style="padding: 2px;"><xsl:value-of select="gsa:i18n ('Show delta results', 'Report Filter')"/>:</div>
            <div style="margin-left: 8px;">
              <label>
                <xsl:choose>
                  <xsl:when test="report/filters/delta/same = 0">
                    <input type="checkbox" name="delta_state_same" value="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="delta_state_same"
                           value="1" checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                = <xsl:value-of select="gsa:i18n ('same', 'Delta Result')"/>
              </label>
            </div>
            <div style="margin-left: 8px;">
              <label>
                <xsl:choose>
                  <xsl:when test="report/filters/delta/new = 0">
                    <input type="checkbox" name="delta_state_new" value="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="delta_state_new"
                           value="1" checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                + <xsl:value-of select="gsa:i18n ('new', 'Delta Result')"/>
              </label>
            </div>
            <div style="margin-left: 8px;">
              <label>
                <xsl:choose>
                  <xsl:when test="report/filters/delta/gone = 0">
                    <input type="checkbox" name="delta_state_gone" value="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="delta_state_gone"
                           value="1" checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                &#8722; <xsl:value-of select="gsa:i18n ('gone', 'Delta Result')"/>
              </label>
            </div>
            <div style="margin-left: 8px;">
              <label>
                <xsl:choose>
                  <xsl:when test="report/filters/delta/changed = 0">
                    <input type="checkbox" name="delta_state_changed" value="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="delta_state_changed"
                           value="1" checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                ~ <xsl:value-of select="gsa:i18n ('changed', 'Delta Result')"/>
              </label>
            </div>
          </div>
        </xsl:if>

        <xsl:if test="not (/envelope/params/report_section) or /envelope/params/report_section = 'results'">
          <div style="padding: 2px;">
            <xsl:value-of select="gsa:i18n ('Results per page', 'Filter')"/>:
            <input type="text" name="max_results" size="5"
                  value="{report/results/@max}"
                  maxlength="400"/>
          </div>
        </xsl:if>

        <xsl:choose>
          <xsl:when test="@type='prognostic'">
          </xsl:when>
          <xsl:otherwise>
            <div style="padding: 2px;">
              <xsl:value-of select="gsa:i18n ('Auto-FP', 'Report Filter')"/>:
              <div style="margin-left: 30px">
                <label>
                  <xsl:choose>
                    <xsl:when test="report/filters/autofp = 0">
                      <input type="checkbox" name="autofp" value="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="autofp" value="1" checked="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:value-of select="gsa:i18n ('Trust vendor security updates', 'Report Filter')"/>
                </label>
                <div style="margin-left: 30px">
                  <label>
                    <xsl:choose>
                      <xsl:when test="report/filters/autofp = 2">
                        <input type="radio" name="autofp_value" value="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="autofp_value" value="1" checked="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:value-of select="gsa:i18n ('Full CVE match', 'Report Filter')"/>
                  </label>
                  <br/>
                  <label>
                    <xsl:choose>
                      <xsl:when test="report/filters/autofp = 2">
                        <input type="radio" name="autofp_value" value="2" checked="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="autofp_value" value="2"/>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:value-of select="gsa:i18n ('Partial CVE match', 'Report Filter')"/>
                  </label>
                </div>
              </div>
            </div>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:choose>
          <xsl:when test="@type='prognostic'">
          </xsl:when>
          <xsl:otherwise>
            <div style="padding: 2px;">
              <label>
                <xsl:choose>
                  <xsl:when test="report/filters/notes = 0">
                    <input type="checkbox" name="notes" value="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="notes" value="1" checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Show Notes', 'Report Filter')"/>
              </label>
            </div>
          </xsl:otherwise>
        </xsl:choose>

        <div style="padding: 2px;">
          <label>
            <xsl:choose>
              <xsl:when test="report/filters/overrides = 0">
                <input type="checkbox" name="overrides" value="1"/>
              </xsl:when>
              <xsl:otherwise>
                <input type="checkbox" name="overrides" value="1" checked="1"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="gsa:i18n ('Show Overrides', 'Report Filter')"/>
          </label>
        </div>

        <div style="padding: 2px;">
          <xsl:choose>
            <xsl:when test="report/filters/result_hosts_only = 0">
              <label>
                <input type="checkbox" name="result_hosts_only" value="1"/>
                <xsl:value-of select="gsa:i18n ('Only show hosts that have results', 'Report Filter')"/>
              </label>
            </xsl:when>
            <xsl:otherwise>
              <label>
                <input type="checkbox" name="result_hosts_only" value="1" checked="1"/>
                <xsl:value-of select="gsa:i18n ('Only show hosts that have results', 'Report Filter')"/>
              </label>
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <div style="padding: 2px;">
          <label>
            <xsl:choose>
              <xsl:when test="report/filters/min_cvss_base = ''">
                <input type="checkbox" name="apply_min_cvss_base" value="1"/>
              </xsl:when>
              <xsl:otherwise>
                <input type="checkbox" name="apply_min_cvss_base" value="1"
                       checked="1"/>
              </xsl:otherwise>
            </xsl:choose>
            CVSS &gt;=
          </label>
          <select name="min_cvss_base">
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'10.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'9.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:choose>
              <xsl:when test="report/filters/min_cvss_base = ''">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'8.0'"/>
                  <xsl:with-param name="select-value" select="'8.0'"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'8.0'"/>
                  <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'7.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'6.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'5.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'4.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'3.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'2.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'1.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'0.0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_cvss_base"/>
            </xsl:call-template>
          </select>
        </div>
        <div style="padding: 2px;">
          <label>
            <xsl:choose>
              <xsl:when test="(report/filters/min_qod = '')">
                <input type="checkbox" name="apply_min_qod" value="1"/>
              </xsl:when>
              <xsl:otherwise>
                <input type="checkbox" name="apply_min_qod" value="1"
                       checked="1"/>
              </xsl:otherwise>
            </xsl:choose>
            QoD &gt;=
          </label>
          <select name="min_qod">
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'100'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'90'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'80'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:choose>
              <xsl:when test="report/filters/min_qod = ''">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'70'"/>
                  <xsl:with-param name="select-value" select="'70'"/>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'70'"/>
                  <xsl:with-param name="select-value" select="report/filters/min_qod"/>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'60'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'50'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'40'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'30'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'20'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'10'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'0'"/>
              <xsl:with-param name="select-value" select="report/filters/min_qod"/>
            </xsl:call-template>
          </select>
          %
        </div>
        <div style="padding: 2px;">
          <xsl:variable name="search_phrase_exact" select="number (contains (report/filters/term, concat ('=', report/filters/phrase)) or contains (report/filters/term, concat ('=&quot;', report/filters/phrase, '&quot;')))"/>
          <xsl:value-of select="gsa:i18n ('Text phrase', 'Report Filter')"/>:
          <input type="text" name="search_phrase" size="50"
                 value="{report/filters/phrase}"
                 maxlength="400"/>
          <div style="margin-left: 30px">
            <label>
              <xsl:choose>
                <xsl:when test="$search_phrase_exact">
                  <input type="radio" name="search_phrase_exact" value="0"
                      maxlength="400"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="radio" name="search_phrase_exact" value="0"
                      maxlength="400" checked="1"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="gsa:i18n ('Can match partially', 'Report Filter')"/>
            </label>
            <br/>
            <label>
              <xsl:choose>
                <xsl:when test="$search_phrase_exact">
                  <input type="radio" name="search_phrase_exact" value="1"
                      maxlength="400" checked="1"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="radio" name="search_phrase_exact" value="1"
                      maxlength="400"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="gsa:i18n ('Must match exactly', 'Report Filter')"/>
            </label>
          </div>
        </div>
        <div style="padding: 2px;">
          <xsl:value-of select="gsa:i18n ('Timezone', 'Time')"/>:
          <xsl:call-template name="timezone-select">
            <xsl:with-param name="timezone" select="report/timezone"/>
            <xsl:with-param name="input-name" select="'timezone'"/>
          </xsl:call-template>
        </div>
        <div style="float: right">
          <input type="submit" value="{gsa:i18n ('Apply', 'Action Verb')}" title="{gsa:i18n ('Apply', 'Action Verb')}"/>
        </div>
        <div style="padding: 2px;">
          <xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:
          <table style="display: inline">
            <tr>
              <td class="threat_info_table_h">
                <label>
                  <xsl:choose>
                    <xsl:when test="report/filters/filter[text()='High']">
                      <input type="checkbox" name="level_high" value="1"
                             checked="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="level_high" value="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:call-template name="severity-label">
                    <xsl:with-param name="level" select="'High'"/>
                  </xsl:call-template>
                </label>
              </td>
              <td class="threat_info_table_h">
                <label>
                  <xsl:choose>
                    <xsl:when test="report/filters/filter[text()='Medium']">
                      <input type="checkbox" name="level_medium" value="1"
                             checked="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="level_medium" value="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:call-template name="severity-label">
                    <xsl:with-param name="level" select="'Medium'"/>
                  </xsl:call-template>
                </label>
              </td>
              <td class="threat_info_table_h">
                <label>
                  <xsl:choose>
                    <xsl:when test="report/filters/filter[text()='Low']">
                      <input type="checkbox" name="level_low" value="1"
                             checked="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="level_low" value="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:call-template name="severity-label">
                    <xsl:with-param name="level" select="'Low'"/>
                  </xsl:call-template>
                </label>
              </td>
              <td class="threat_info_table_h">
                <label>
                  <xsl:choose>
                    <xsl:when test="report/filters/filter[text()='Log']">
                      <input type="checkbox" name="level_log" value="1"
                             checked="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="level_log" value="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:call-template name="severity-label">
                    <xsl:with-param name="level" select="'Log'"/>
                  </xsl:call-template>
                </label>
              </td>
              <td class="threat_info_table_h">
                <label>
                  <xsl:choose>
                    <xsl:when test="report/filters/filter[text()='False Positive']">
                      <input type="checkbox"
                             name="level_false_positive"
                             value="1"
                             checked="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox"
                             name="level_false_positive"
                             value="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:call-template name="severity-label">
                    <xsl:with-param name="level" select="'False Positive'"/>
                  </xsl:call-template>
                </label>
              </td>
            </tr>
          </table>
        </div>
      </form>
    </div>
  </xsl:if>
</xsl:template>

<xsl:template match="report" mode="results">
  <xsl:variable name="levels"
                select="report/filters/text()"/>
  <xsl:variable name="apply-overrides"
                select="report/filters/apply_overrides"/>
  <xsl:variable name="type">
    <xsl:choose>
      <xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
      <xsl:otherwise>normal</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:apply-templates select="report" mode="section-list">
        <xsl:with-param name="current" select="'results'"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="." mode="results-pager"/>
      <xsl:call-template name="report-icons">
        <xsl:with-param name="section" select="'results'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:apply-templates select="report" mode="section-filter">
        <xsl:with-param name="section" select="'results'"/>
      </xsl:apply-templates>
      <xsl:apply-templates select="." mode="filterbox"/>
    </div>
    <div class="gb_window_part_content_no_pad">
      <xsl:choose>
        <xsl:when test="count(report/results/result) &gt; 0">
          <div id="reports">
            <table class="gbntable" cellspacing="2" cellpadding="4" border="0">
              <xsl:apply-templates select="report" mode="details"/>
              <tr>
                <td class="footnote" colspan="1000">
                  <xsl:variable name="prognostic">
                    <xsl:if test="report/@type='prognostic'">
                      <xsl:value-of select="concat ('&amp;type=prognostic&amp;host=', report/filters/host, '&amp;host_search_phrase=', host_search_phrase, '&amp;host_levels=', host_levels, '&amp;host_first_result=', results/@start, '&amp;host_max_results=', results/@max, '&amp;pos=', /envelope/params/pos)"/>
                    </xsl:if>
                  </xsl:variable>
                  <xsl:variable name="delta">
                    <xsl:if test="report/@type='delta'">
                      <xsl:value-of select="concat ('&amp;delta_report_id=', report/delta/report/@id)"/>
                    </xsl:if>
                  </xsl:variable>
                  <div class="float_right">
                    <xsl:apply-templates select="." mode="results-pager"/>
                  </div>
                  (<xsl:value-of select="gsa:i18n('Applied filter:', 'Filter')"/>
                  <a class="footnote"
                     href="/omp?cmd=get_report_section&amp;report_id={report/@id}&amp;report_section=results&amp;overrides={$apply-overrides}&amp;details={/envelope/params/details}&amp;filter={report/filters/term}{$prognostic}{$delta}&amp;token={/envelope/token}">
                    <xsl:value-of select="report/filters/term"/>
                  </a>)
                </td>
              </tr>
            </table>
          </div>
        </xsl:when>
        <xsl:otherwise>
          <div style="padding: 1px">
            <p><xsl:value-of select="gsa:i18n ('0 results', 'Result')"/></p>
            <p>
            <xsl:value-of select="gsa:i18n ('Empty reports can happen for the following reasons:', 'Result')"/>
            </p>
            <p>
            <ul>
            <li><xsl:value-of select="gsa:i18n ('The target hosts where regarded dead.', 'Result')"/></li>
            <li><xsl:value-of select="gsa:i18n ('The filter does not match any result.', 'Result')"/></li>
            <li><xsl:value-of select="gsa:i18n ('A very small or non-verbose scan configuration was applied.', 'Result')"/></li>
            </ul>
            </p>
            <xsl:choose>
              <xsl:when test="report/hosts/count = 0">
                <p><xsl:value-of select="gsa:i18n ('This report also contains no hosts.', 'Report')"/></p>
              </xsl:when>
              <xsl:otherwise>
                <a href="/omp?cmd=get_report_section&amp;report_id={report/@id}&amp;report_section=hosts&amp;result_hosts_only=0&amp;token={/envelope/token}">
                  <p><xsl:value-of select="gsa-i18n:strformat (gsa:n-i18n ('However, this report contains %1 host.', 'However, this report contains %1 hosts.', report/hosts/count), report/hosts/count)"/></p>
                </a>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="report/errors/count &gt; 0">
              <xsl:apply-templates select="report" mode="section-link">
                <xsl:with-param name="count" select="result_count/full"/>
                <xsl:with-param name="section" select="'errors'"/>
                <xsl:with-param name="type" select="$type"/>
                <xsl:with-param name="link_style" select="'element'"/>
                <xsl:with-param name="element">
                  <p title="{gsa:i18n ('Click here to go to the Errors page', 'Result')}."><xsl:value-of select="gsa:i18n ('This report contains at least one Error message', 'Result')"/>.</p>
                </xsl:with-param>
              </xsl:apply-templates>
            </xsl:if>
          </div>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
</xsl:template>


<!-- BEGIN TASKS MANAGEMENT -->

<xsl:template name="task-icons">
  <xsl:param name="next" select="'get_tasks'"/>
  <xsl:param name="show-start-when-scheduled" select="false ()"/>
  <xsl:choose>
    <xsl:when test="target/@id = ''">
      <img style="margin-left: 3px" src="/img/start_inactive.png" border="0" alt="{gsa:i18n ('Start', 'Action Verb')}" title="{gsa:i18n ('Task is a container', 'Task')}"/>
    </xsl:when>
    <xsl:when test="gsa:may ('start_task') = 0">
      <img style="margin-left: 3px" src="/img/start_inactive.png" border="0" alt="{gsa:i18n ('Start', 'Action Verb')}" title="{gsa:i18n ('Permission to start task denied', 'Task')}"/>
    </xsl:when>
    <xsl:when test="string-length(schedule/@id) &gt; 0">
      <xsl:choose>
        <xsl:when test="boolean (schedule/permissions) and count (schedule/permissions/permission) = 0">
          <img style="margin-left: 3px" src="/img/scheduled_inactive.png" border="0"
               alt="{gsa:i18n ('Schedule Unavailable', 'Task|Schedule')}"
               title="{gsa:i18n ('Schedule Unavailable', 'Task|Schedule')} ({gsa:i18n ('Name', 'Property')}: {schedule/name}, ID: {schedule/@id})"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="next_due_string">
            <xsl:choose>
              <xsl:when test="schedule/next_time = 'over'">
    <xsl:text>
    (</xsl:text>
                <xsl:value-of select="gsa:i18n ('Next due: over', 'Task|Schedule')"/>
                <xsl:text>)</xsl:text>
              </xsl:when>
              <xsl:otherwise>
    <xsl:text>
    (</xsl:text>
                <xsl:value-of select="gsa:i18n ('Next due', 'Task|Schedule')"/>: <xsl:value-of select="gsa:long-time (schedule/next_time)"/>
                <xsl:choose>
                  <xsl:when test="schedule_periods = 1">
                    <xsl:value-of select="concat (', ', gsa:i18n ('Once', 'Time'))"/>
                  </xsl:when>
                  <xsl:when test="schedule_periods &gt; 1">
                    <xsl:value-of select="concat (', ', schedule_periods, ' ', gsa:i18n ('more times', 'Time'))"/>
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:text>)</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <a href="/omp?cmd=get_schedule&amp;schedule_id={schedule/@id}&amp;token={/envelope/token}"
             title="{concat (gsa:view_details_title ('schedule', schedule/name), $next_due_string)}">
            <img style="margin-left: 3px" src="/img/scheduled.png" border="0" alt="{gsa:i18n ('Schedule Details', 'Schedule')}"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="boolean ($show-start-when-scheduled)">
        <xsl:choose>
          <xsl:when test="status!='Running' and status!='Stop Requested' and status!='Delete Requested' and status!='Ultimate Delete Requested' and status!='Resume Requested' and status!='Requested'">
            <xsl:call-template name="start-icon">
              <xsl:with-param name="type">task</xsl:with-param>
              <xsl:with-param name="id" select="@id"/>
              <xsl:with-param name="params">
                <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
                <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
                <input type="hidden" name="refresh_interval" value="{/envelope/autorefresh/@interval}"/>
                <input type="hidden" name="next" value="{$next}"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <img style="margin-left: 3px" src="/img/start_inactive.png" border="0" alt="{gsa:i18n ('Start', 'Action Verb')}" title="{gsa:i18n ('Task is already active', 'Task')}"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>
    </xsl:when>
    <xsl:when test="status='Running'">
      <xsl:call-template name="stop-icon">
        <xsl:with-param name="type">task</xsl:with-param>
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="params">
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <input type="hidden" name="refresh_interval" value="{/envelope/autorefresh/@interval}"/>
          <input type="hidden" name="next" value="{$next}"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="status='Stop Requested' or status='Delete Requested' or status='Ultimate Delete Requested' or status='Resume Requested' or status='Requested'">
      <img style="margin-left: 3px" src="/img/start_inactive.png" border="0" alt="{gsa:i18n ('Start', 'Action Verb')}" title="{gsa:i18n ('Task is already active', 'Task')}"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="start-icon">
        <xsl:with-param name="type">task</xsl:with-param>
        <xsl:with-param name="id" select="@id"/>
        <xsl:with-param name="params">
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <input type="hidden" name="refresh_interval" value="{/envelope/autorefresh/@interval}"/>
          <input type="hidden" name="next" value="{$next}"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="string-length (/envelope/params/enable_stop) &gt; 0 and /envelope/params/enable_stop = 1">
    <xsl:call-template name="stop-icon">
      <xsl:with-param name="type">task</xsl:with-param>
      <xsl:with-param name="id" select="@id"/>
      <xsl:with-param name="params">
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <input type="hidden" name="refresh_interval" value="{/envelope/autorefresh/@interval}"/>
        <input type="hidden" name="next" value="{$next}"/>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:if>
  <xsl:choose>
    <xsl:when test="target/@id = ''">
      <img src="/img/resume_inactive.png" border="0" alt="{gsa:i18n ('Resume', 'Action Verb')}" title="{gsa:i18n ('Task is a container', 'Task')}"
         style="margin-left:3px;"/>
    </xsl:when>
    <xsl:when test="string-length(schedule/@id) &gt; 0">
      <img src="/img/resume_inactive.png" border="0" alt="{gsa:i18n ('Resume', 'Action Verb')}" title="{gsa:i18n ('Task is scheduled', 'Task')}"
           style="margin-left:3px;"/>
    </xsl:when>
    <xsl:when test="status='Stopped'">
      <xsl:choose>
        <xsl:when test="gsa:may ('resume_task') = 0">
          <img src="/img/resume_inactive.png" border="0" alt="{gsa:i18n ('Resume', 'Action Verb')}" title="{gsa:i18n ('Permission to resume task denied', 'Task')}"
             style="margin-left:3px;"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="resume-icon">
            <xsl:with-param name="type">task</xsl:with-param>
            <xsl:with-param name="cmd">resume_task</xsl:with-param>
            <xsl:with-param name="id" select="@id"/>
            <xsl:with-param name="params">
              <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
              <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
              <input type="hidden" name="refresh_interval" value="{/envelope/autorefresh/@interval}"/>
              <input type="hidden" name="next" value="{$next}"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <img src="/img/resume_inactive.png" border="0" alt="{gsa:i18n ('Resume', 'Action Verb')}" title="{gsa:i18n ('Task is not stopped', 'Task')}"
           style="margin-left:3px;"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="task" mode="details">
  <xsl:variable name="apply-overrides" select="../apply_overrides"/>
  <xsl:variable name="min-qod" select="/envelope/params/min_qod"/>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Task Details', 'Task')"/><xsl:text> </xsl:text>

      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Task'"/>
        <xsl:with-param name="type" select="'task'"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="alterable = 0">
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/alterable.png" style="margin-left:0px;" border="0"
               alt="{gsa:i18n ('This is an Alterable Task. Reports may not relate to current Scan Config or Target!', 'Task')}"
               title="{gsa:i18n ('This is an Alterable Task. Reports may not relate to current Scan Config or Target!', 'Task')}"/>
        </xsl:otherwise>
      </xsl:choose>
      <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
        <xsl:call-template name="task-icons">
          <xsl:with-param name="next" select="'get_task'"/>
          <xsl:with-param name="show-start-when-scheduled" select="1"/>
        </xsl:call-template>
      </div>
      <div id="small_inline_form" style="margin-left:40px; display: inline">
        <form method="get" action="" enctype="multipart/form-data">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="get_task"/>
          <input type="hidden" name="task_id" value="{/envelope/params/task_id}"/>
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <xsl:call-template name="auto-refresh"/>
          <input type="image" name="Update" src="/img/refresh.png"
                 title="{gsa:i18n ('Update auto-refresh', 'Auto-Refresh')}"
                 alt="{gsa:i18n ('Update', 'Action Verb')}" style="margin-left:3px;margin-right:3px;"/>
          <xsl:choose>
            <xsl:when test="$apply-overrides = 0">
              <input type="hidden" name="overrides" value="0"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="hidden" name="overrides" value="1"/>
            </xsl:otherwise>
          </xsl:choose>
        </form>
      </div>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Target', 'Target')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="boolean (target/permissions) and count (target/permissions/permission) = 0">
                <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                <xsl:text> (</xsl:text>
                <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                <xsl:text>: </xsl:text>
                <xsl:value-of select="target/name"/>
                <xsl:text>, </xsl:text>
                <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="target/@id"/>
                <xsl:text>)</xsl:text>
              </xsl:when>
              <xsl:otherwise>
                <a href="/omp?cmd=get_target&amp;target_id={target/@id}&amp;token={/envelope/token}">
                  <xsl:value-of select="target/name"/>
                </a>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <xsl:if test="gsa:may-op ('get_alerts') or count (alert) &gt; 0">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Alerts', 'Alert')"/>:</td>
            <td>
              <xsl:for-each select="alert">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="name"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="@id"/>
                    <xsl:text>)</xsl:text>
                  </xsl:when>
                  <xsl:when test="gsa:may-op ('get_alerts')">
                    <a href="/omp?cmd=get_alert&amp;alert_id={@id}&amp;token={/envelope/token}">
                      <xsl:value-of select="name"/>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="name"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:if test="position() != last()">, </xsl:if>
              </xsl:for-each>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="gsa:may-op ('get_schedules') or boolean (schedule)">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Schedule', 'Schedule')"/>:</td>
            <td>
              <xsl:if test="schedule">
                <xsl:choose>
                  <xsl:when test="gsa:may-op ('get_schedules')">
                    <xsl:choose>
                      <xsl:when test="boolean (schedule/permissions) and count (schedule/permissions/permission) = 0">
                        <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="schedule/name"/>
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="schedule/@id"/>
                        <xsl:text>)</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                        <a href="/omp?cmd=get_schedule&amp;schedule_id={schedule/@id}&amp;token={/envelope/token}">
                          <xsl:value-of select="schedule/name"/>
                        </a>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="schedule/name"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:choose>
                  <xsl:when test="schedule/next_time = 'over'">
                    (<xsl:value-of select="gsa:i18n ('Next due: over', 'Task|Schedule')"/>)
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="gsa:i18n ('Next due', 'Task|Schedule')"/>: <xsl:value-of select="gsa:long-time (schedule/next_time)"/>
                    <xsl:choose>
                      <xsl:when test="schedule_periods = 1">
                        <xsl:value-of select="concat (', ', gsa:i18n ('Once', 'Time'))"/>
                      </xsl:when>
                      <xsl:when test="schedule_periods &gt; 1">
                        <xsl:value-of select="concat (', ', schedule_periods, ' ', gsa:i18n ('more times', 'Time'))"/>
                      </xsl:when>
                      <xsl:otherwise>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>)</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </td>
          </tr>
        </xsl:if>
        <tr>
          <xsl:variable name="in_assets" select="preferences/preference[scanner_name='in_assets']"/>
          <td>
            <xsl:value-of select="gsa:i18n ('Add to Assets', 'Task')"/>:
          </td>
          <td>
            <xsl:value-of select="gsa:i18n (normalize-space($in_assets/value), 'Task')"/>
          </td>
        </tr>
        <tr>
          <td>
            <xsl:value-of select="gsa:i18n ('Alterable Task', 'Task')"/>:
          </td>
          <td>
            <xsl:variable name="yes" select="alterable"/>
            <xsl:choose>
              <xsl:when test="string-length ($yes) = 0 or $yes = 0">
                <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <xsl:variable name="auto_delete" select="preferences/preference[scanner_name='auto_delete']/value"/>
          <xsl:variable name="auto_delete_data" select="preferences/preference[scanner_name='auto_delete_data']/value"/>
          <td>
            <xsl:value-of select="gsa:i18n ('Auto Delete Reports', 'Task')"/>:
          </td>
          <td>
            <xsl:choose>
              <xsl:when test="$auto_delete = 'keep'">
                <xsl:value-of select="gsa:i18n ('Automatically delete oldest reports but always keep newest ', 'Task')"/>
                <xsl:value-of select="$auto_delete_data"/>
                <xsl:value-of select="gsa:i18n (' reports', 'Task')"/>
              </xsl:when>
              <xsl:otherwise>
               <xsl:value-of select="gsa:i18n ('Do not automatically delete reports', 'Task')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <xsl:if test="target/@id != ''">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Scanner', 'Scanner')"/>:</td>
            <td>
              <xsl:choose>
                <xsl:when test="boolean (scanner/permissions) and count (scanner/permissions/permission) = 0">
                  <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                  <xsl:text> (</xsl:text>
                  <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                  <xsl:text>: </xsl:text>
                  <xsl:value-of select="scanner/name"/>
                  <xsl:text>, </xsl:text>
                  <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="scanner/@id"/>
                  <xsl:text>)</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:choose>
                    <xsl:when test="gsa:may-op ('get_scanners')">
                      <a href="/omp?cmd=get_scanner&amp;scanner_id={scanner/@id}&amp;token={/envelope/token}">
                        <xsl:value-of select="scanner/name"/>
                      </a>
                      (<xsl:value-of select="gsa:i18n ('Type', 'Property')"/>:
                      <xsl:call-template name="scanner-type-name">
                        <xsl:with-param name="type" select="scanner/type"/>
                      </xsl:call-template>)
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="scanner/name"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td></td>
            <td>
              <xsl:value-of select="gsa:i18n ('Scan Config', 'Scan Config')"/>:
              <xsl:choose>
                <xsl:when test="boolean (config/permissions) and count (config/permissions/permission) = 0">
                  <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                  <xsl:text> (</xsl:text>
                  <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                  <xsl:text>: </xsl:text>
                  <xsl:value-of select="config/name"/>
                  <xsl:text>, </xsl:text>
                  <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="config/@id"/>
                  <xsl:text>)</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <a href="/omp?cmd=get_config&amp;config_id={config/@id}&amp;token={/envelope/token}">
                    <xsl:value-of select="config/name"/>
                  </a>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <xsl:if test="config/type = 0">
            <xsl:if test="gsa:may-op ('get_slaves')">
              <tr>
                <td></td>
                <td>
                  <xsl:value-of select="gsa:i18n ('Slave', 'Slave')"/>:
                    <xsl:choose>
                      <xsl:when test="boolean (slave/permissions) and count (slave/permissions/permission) = 0">
                        <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                        <xsl:text> (</xsl:text>
                        <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                        <xsl:text>: </xsl:text>
                        <xsl:value-of select="slave/name"/>
                        <xsl:text>, </xsl:text>
                        <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="slave/@id"/>
                        <xsl:text>)</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                        <a href="/omp?cmd=get_slave&amp;slave_id={slave/@id}&amp;token={/envelope/token}">
                          <xsl:value-of select="slave/name"/>
                        </a>
                      </xsl:otherwise>
                    </xsl:choose>
                </td>
              </tr>
            </xsl:if>
            <tr>
              <td></td>
              <td>
                <xsl:value-of select="gsa:i18n ('Order for target hosts', 'Task')"/>:
                <xsl:choose>
                  <xsl:when test="hosts_ordering = 'sequential'"><xsl:value-of select="gsa:i18n ('Sequential', 'Task|Hosts Ordering')"/></xsl:when>
                  <xsl:when test="hosts_ordering = 'random'"><xsl:value-of select="gsa:i18n ('Random', 'Task|Hosts Ordering')"/></xsl:when>
                  <xsl:when test="hosts_ordering = 'reverse'"><xsl:value-of select="gsa:i18n ('Reverse', 'Task|Hosts Ordering')"/></xsl:when>
                  <xsl:otherwise><xsl:value-of select="gsa:i18n ('N/A', 'Value')"/></xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
            <tr>
              <td></td>
              <td>
                <xsl:value-of select="gsa:i18n ('Network Source Interface', 'Task')"/>:
                <xsl:value-of select="preferences/preference[scanner_name='source_iface']/value"/>
              </td>
            </tr>
            <tr>
              <td></td>
              <td>
                <xsl:value-of select="gsa:i18n (normalize-space (preferences/preference[scanner_name='max_checks']/name), 'Task')"/>:
                <xsl:value-of select="preferences/preference[scanner_name='max_checks']/value"/>
              </td>
            </tr>
            <tr>
              <td></td>
              <td>
                <xsl:value-of select="gsa:i18n (normalize-space (preferences/preference[scanner_name='max_hosts']/name), 'Task')"/>:
                <xsl:value-of select="preferences/preference[scanner_name='max_hosts']/value"/>
              </td>
            </tr>
          </xsl:if>
        </xsl:if>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Status', 'Task')"/>:</td>
          <td>
            <xsl:call-template name="status_bar">
              <xsl:with-param name="status">
                <xsl:choose>
                  <xsl:when test="target/@id='' and status='Running'">
                    <xsl:value-of select="'Uploading'"/>
                  </xsl:when>
                  <xsl:when test="target/@id=''">
                    <xsl:value-of select="'Container'"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="status"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="progress">
                <xsl:value-of select="progress/text()"/>
              </xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
        <tr>
          <td>
            <xsl:value-of select="gsa:i18n ('Reports', 'Report')"/>:
          </td>
          <td>
            <a href="/omp?cmd=get_reports&amp;replace_task_id=1&amp;filt_id=-2&amp;filter=task_id={@id} apply_overrides={$apply-overrides} min_qod={$min-qod} sort-reverse=name&amp;task_filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;task_filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa-i18n:strformat (gsa:i18n ('Reports on Task %1', 'Task'), name)}">
              <xsl:value-of select="report_count/text ()"/>
            </a>
            <xsl:if test="current_report/report/timestamp">
              <xsl:value-of select="concat(', ', gsa:i18n ('Current', 'Task|Report'), ': ')"/>
              <a href="/omp?cmd=get_report&amp;report_id={current_report/report/@id}&amp;overrides={$apply-overrides}&amp;apply_min_qod={number (string-length ($min-qod) != 0)}&amp;min_qod={$min-qod}&amp;token={/envelope/token}">
                <xsl:call-template name="short_timestamp_current"/>
              </a>
            </xsl:if>
             <xsl:value-of select="concat(' (', gsa:i18n ('Finished', 'Task|Reports'), ': ')"/>
             <a href="/omp?cmd=get_reports&amp;replace_task_id=1&amp;filt_id=-2&amp;filter=task_id={@id} and status=Done apply_overrides={$apply-overrides} min_qod={$min-qod} sort-reverse=name&amp;task_filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;task_filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa-i18n:strformat (gsa:i18n ('Reports on Task %1', 'Task'), name)}">
              <xsl:value-of select="report_count/finished"/>
             </a>
             <xsl:if test="last_report/report/timestamp">
               <xsl:value-of select="concat(', ', gsa:i18n ('Last', 'Task|Report'), ': ')"/>
               <a href="/omp?cmd=get_report&amp;report_id={last_report/report/@id}&amp;overrides={$apply-overrides}&amp;apply_min_qod={number (string-length ($min-qod) != 0)}&amp;min_qod={$min-qod}&amp;token={/envelope/token}">
                 <xsl:call-template name="short_timestamp_last"/>
               </a>
             </xsl:if>)
          </td>
        </tr>
        <tr>
          <td>
            <xsl:value-of select="gsa:i18n ('Results', 'Result')"/>:
          </td>
          <td>
            <a href="/omp?cmd=get_results&amp;filter=severity&gt;Error and task_id={@id} sort=nvt&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa-i18n:strformat (gsa:i18n ('Results on Task %1', 'Task'), name)}">
              <xsl:value-of select="result_count/text ()"/>
            </a>
          </td>
        </tr>
        <tr>
          <td>
            <xsl:value-of select="gsa:i18n ('Notes', 'Note')"/>:
          </td>
          <td>
            <a href="/omp?cmd=get_notes&amp;filter=task_id={@id} sort=nvt&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa-i18n:strformat (gsa:i18n ('Notes on Task %1', 'Task'), name)}">
              <xsl:value-of select="count (../../get_notes_response/note)"/>
            </a>
          </td>
        </tr>
        <tr>
          <td>
            <xsl:value-of select="gsa:i18n ('Overrides', 'Override')"/>:
          </td>
          <td>
            <a href="/omp?cmd=get_overrides&amp;filter=task_id={@id} sort=nvt&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa-i18n:strformat (gsa:i18n ('Overrides on Task %1', 'Task'), name)}">
              <xsl:value-of select="count (../../get_overrides_response/override)"/>
            </a>
          </td>
        </tr>
      </table>
    </div>
  </div>
  <xsl:if test="target/@id='' and gsa:may-op ('create_report')">
    <br/>
    <div class="gb_window">
      <div class="gb_window_part_left"></div>
      <div class="gb_window_part_right"></div>
      <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Import Report', 'Task')"/>
        <a href="/help/task_details.html?token={/envelope/token}#import_report" title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Import Report', 'Task'))}">
          <img src="/img/help.png"/>
        </a>
      </div>
      <div class="gb_window_part_content">
        <form action="/omp" method="post" enctype="multipart/form-data">
          <div style="float: right">
            <input type="submit" name="submit" value="{gsa:i18n ('Add Report', 'Task')}"/>
          </div>
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="create_report"/>
          <input type="hidden" name="caller" value="{/envelope/current_page}"/>
          <input type="hidden" name="next" value="get_task"/>
          <input type="hidden" name="task_id" value="{@id}"/>
          <input type="hidden" name="overrides" value="{apply_overrides}"/>
          <input type="file" name="xml_file" size="30"/>
        </form>
      </div>
    </div>
  </xsl:if>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'task'"/>
    <xsl:with-param name="tag_names" select="../../../get_tags_response"/>
  </xsl:call-template>

  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'task'"/>
    <xsl:with-param name="permissions" select="../../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
      <xsl:variable name="detailed_target" select="../../../get_targets_response/target"/>
      <xsl:variable name="detailed_alerts" select="../../../get_alerts_response/alert"/>
      <xsl:if test="target/@id != ''">
        <target id="{target/@id}"/>
        <xsl:if test="$detailed_target/ssh_lsc_credential/@id != ''">
          <lsc_credential id="{$detailed_target/ssh_lsc_credential/@id}"/>
        </xsl:if>
        <xsl:if test="$detailed_target/smb_lsc_credential/@id != '' and $detailed_target/smb_lsc_credential/@id != $detailed_target/ssh_lsc_credential/@id">
          <lsc_credential id="{$detailed_target/smb_lsc_credential/@id}"/>
        </xsl:if>
        <xsl:if test="$detailed_target/esxi_lsc_credential/@id != '' and $detailed_target/esxi_lsc_credential/@id != $detailed_target/ssh_lsc_credential/@id and $detailed_target/esxi_lsc_credential/@id != $detailed_target/smb_lsc_credential/@id">
          <lsc_credential id="{$detailed_target/esxi_lsc_credential/@id}"/>
        </xsl:if>
        <xsl:if test="$detailed_target/port_list/@id != ''">
          <port_list id="{$detailed_target/port_list/@id}"/>
        </xsl:if>
      </xsl:if>
      <xsl:for-each select="alert">
        <xsl:if test="@id != ''">
          <xsl:variable name="alert_id" select="@id"/>
          <alert id="{$alert_id}"/>
          <xsl:if test="$detailed_alerts[@id=$alert_id]/filter/@id != ''">
            <filter id="{$detailed_alerts[@id=$alert_id]/filter/@id}"/>
          </xsl:if>
        </xsl:if>
      </xsl:for-each>
      <xsl:if test="config/@id != ''">
        <config id="{config/@id}"/>
      </xsl:if>
      <xsl:if test="scanner/@id != ''">
        <scanner id="{scanner/@id}"/>
      </xsl:if>
      <xsl:if test="schedule/@id != ''">
        <schedule id="{schedule/@id}"/>
      </xsl:if>
      <xsl:if test="slave/@id != ''">
        <slave id="{slave/@id}"/>
      </xsl:if>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="short_timestamp_first">
  <xsl:if test="first_report/report/timestamp">
    <xsl:value-of select="concat (date:month-abbreviation(first_report/report/timestamp), ' ', date:day-in-month(first_report/report/timestamp), ' ', date:year(first_report/report/timestamp))"/>
  </xsl:if>
</xsl:template>

<xsl:template name="short_timestamp_last">
  <xsl:if test="last_report/report/timestamp">
    <xsl:value-of select="concat (date:month-abbreviation(last_report/report/timestamp), ' ', date:day-in-month(last_report/report/timestamp), ' ', date:year(last_report/report/timestamp))"/>
  </xsl:if>
</xsl:template>

<xsl:template name="short_timestamp_second_last">
  <xsl:if test="first_report/report/timestamp">
    <xsl:value-of select="concat (date:month-abbreviation(second_last_report/report/timestamp), ' ', date:day-in-month(second_last_report/report/timestamp), ' ', date:year(second_last_report/report/timestamp))"/>
  </xsl:if>
</xsl:template>

<xsl:template name="short_timestamp_current">
  <xsl:if test="current_report/report/timestamp">
    <xsl:value-of select="concat (date:month-abbreviation(current_report/report/timestamp), ' ', date:day-in-month(current_report/report/timestamp), ' ', date:year(current_report/report/timestamp))"/>
  </xsl:if>
</xsl:template>

<!-- TREND METER -->
<xsl:template name="trend_meter">
  <xsl:choose>
    <xsl:when test="trend = 'up'">
      <img src="/img/trend_up.png" alt="{gsa:i18n ('Severity increased', 'Task')}"
           title="{gsa:i18n ('Severity increased', 'Task')}"/>
    </xsl:when>
    <xsl:when test="trend = 'down'">
      <img src="/img/trend_down.png" alt="{gsa:i18n ('Severity decreased', 'Task')}"
           title="{gsa:i18n ('Severity decreased', 'Task')}"/>
    </xsl:when>
    <xsl:when test="trend = 'more'">
      <img src="/img/trend_more.png" alt="{gsa:i18n ('Vulnerability count increased', 'Task')}"
           title="{gsa:i18n ('Vulnerability count increased', 'Task')}"/>
    </xsl:when>
    <xsl:when test="trend = 'less'">
      <img src="/img/trend_less.png" alt="{gsa:i18n ('Vulnerability count decreased', 'Task')}"
           title="{gsa:i18n ('Vulnerability count decreased', 'Task')}"/>
    </xsl:when>
    <xsl:when test="trend = 'same'">
      <img src="/img/trend_nochange.png" alt="{gsa:i18n ('Vulnerabilities did not change', 'Task')}"
           title="{gsa:i18n ('Vulnerabilities did not change', 'Task')}"/>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="target" mode="newtask">
  <option value="{@id}"><xsl:value-of select="name"/></option>
</xsl:template>

<xsl:template match="config" mode="newtask">
  <option value="{@id}"><xsl:value-of select="name"/></option>
</xsl:template>

<xsl:template match="alert" mode="newtask">
  <xsl:param name="select_id" select="''"/>
  <xsl:choose>
    <xsl:when test="@id = $select_id">
      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
    </xsl:when>
    <xsl:otherwise>
      <option value="{@id}"><xsl:value-of select="name"/></option>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="group" mode="newtask">
  <option value="{@id}"><xsl:value-of select="name"/></option>
</xsl:template>

<xsl:template match="schedule" mode="newtask">
  <option value="{@id}"><xsl:value-of select="name"/></option>
</xsl:template>

<xsl:template match="slave" mode="newtask">
  <option value="{@id}"><xsl:value-of select="name"/></option>
</xsl:template>

<xsl:template name="status_bar">
  <xsl:param name="status">(Unknown)</xsl:param>
  <xsl:param name="progress">(Unknown)</xsl:param>
  <xsl:param name="title_suffix"></xsl:param>
  <xsl:choose>
    <xsl:when test="$status='Running'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}">
        <div class="progressbar_bar" style="width:{$progress}px;"></div>
        <div class="progressbar_text">
          <xsl:value-of select="$progress"/> %
        </div>
      </div>
    </xsl:when>
    <xsl:when test="$status='New'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_new" style="width:100px;"></div>
        <div class="progressbar_text">
          <i><b><xsl:value-of select="gsa:i18n ($status, 'Status')"/></b></i>
        </div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Requested'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_request" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Delete Requested'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_request" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Ultimate Delete Requested'">
      <div class="progressbar_box" title="{gsa:i18n ('Delete Requested', 'Status')}">
        <div class="progressbar_bar_request" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ('Delete Requested', 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Resume Requested'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_request" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Stop Requested'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_request" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Stopped'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_request" style="width:{$progress}px;"></div>
        <div class="progressbar_text">
          <xsl:value-of select="gsa:i18n ($status, 'Status')"/>
          <xsl:if test="$progress &gt;= 0">
            <xsl:value-of select="gsa:i18n (' at ', 'Status')"/> <xsl:value-of select="$progress"/> %
          </xsl:if>
        </div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Internal Error'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_error" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Done'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_done" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Uploading'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_done" style="width:{$progress}px;"></div>
        <div class="progressbar_text">
          <xsl:value-of select="gsa:i18n ($status, 'Status')"/>
          <xsl:if test="$progress &gt;= 0">
            <xsl:text>: </xsl:text>
            <xsl:value-of select="$progress"/> %
          </xsl:if>
        </div>
      </div>
    </xsl:when>
    <xsl:when test="$status='Container'">
      <div class="progressbar_box" title="{gsa:i18n ($status, 'Status')}{$title_suffix}">
        <div class="progressbar_bar_done" style="width:100px;"></div>
        <div class="progressbar_text"><xsl:value-of select="gsa:i18n ($status, 'Status')"/></div>
      </div>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="gsa:i18n ($status, 'Status')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- BEGIN GENERIC MANAGEMENT -->

<xsl:template name="list-window">
  <xsl:param name="type"/>
  <xsl:param name="subtype"/>
  <xsl:param name="cap-type"/>
  <xsl:param name="cap-type-plural" select="concat ($cap-type, 's')"/>
  <xsl:param name="resources-summary"/>
  <xsl:param name="resources"/>
  <xsl:param name="count"/>
  <xsl:param name="filtered-count"/>
  <xsl:param name="full-count"/>
  <xsl:param name="columns"/>
  <xsl:param name="icon-count" select="8"/>
  <xsl:param name="new-icon" select="gsa:may-op (concat ('create_', $type))"/>
  <xsl:param name="default-filter"/>
  <xsl:param name="extra_params"/>
  <xsl:param name="extra_params_string">
    <xsl:for-each select="exslt:node-set($extra_params)/param">
      <xsl:text>&amp;</xsl:text>
      <xsl:value-of select="name"/>
      <xsl:text>=</xsl:text>
      <xsl:value-of select="value"/>
    </xsl:for-each>
  </xsl:param>
  <xsl:param name="no_bulk" select="0"/>
  <xsl:param name="top-visualization" select="''"/>
  <xsl:variable name="apply-overrides"
                select="filters/keywords/keyword[column='apply_overrides']/value"/>
  <xsl:variable name="subtype_param">
    <xsl:if test="$subtype != ''">
      <xsl:value-of select="concat ('&amp;', $type, '_type=', $subtype)"/>
    </xsl:if>
  </xsl:variable>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="concat(gsa:i18n ($cap-type-plural, $cap-type), ' ')"/>
      <xsl:call-template name="filter-window-pager">
        <xsl:with-param name="type" select="$type"/>
        <xsl:with-param name="list" select="$resources-summary"/>
        <xsl:with-param name="count" select="$count"/>
        <xsl:with-param name="filtered_count" select="$filtered-count"/>
        <xsl:with-param name="full_count" select="$full-count"/>
        <xsl:with-param name="extra_params" select="concat($subtype_param, $extra_params_string)"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="$subtype != ''">
          <a href="/help/{gsa:type-many($subtype)}.html?token={/envelope/token}"
            title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ($cap-type-plural, $cap-type)}">
            <img src="/img/help.png"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <a href="/help/{gsa:type-many($type)}.html?token={/envelope/token}"
            title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ($cap-type-plural, $cap-type)}">
            <img src="/img/help.png"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="gsa:may-op ('run_wizard')">
        <xsl:call-template name="wizard-icon"/>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="$type = 'report'"/>
        <xsl:when test="$type = 'info'"/>
        <xsl:when test="$new-icon">
          <!-- i18n with concat : see dynamic_strings.xsl - type-new -->
          <a href="/omp?cmd=new_{$type}{$extra_params_string}&amp;next=get_{$type}&amp;filter={str:encode-uri (filters/term, true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
             title="{gsa:i18n (concat ('New ', $cap-type), $cap-type)}">
            <img src="/img/new.png" border="0" style="margin-left:3px;"/>
          </a>
        </xsl:when>
      </xsl:choose>
      <a href="/omp?cmd=get_{gsa:type-many($type)}{$subtype_param}{$extra_params_string}&amp;filter={$default-filter}&amp;filt_id=&amp;token={/envelope/token}"
         title="{gsa:i18n ('Return to default filter view', 'Action Verb')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Return', 'Action Verb')}"/>
      </a>
      <xsl:choose>
        <xsl:when test="$type = 'report'"/>
        <xsl:when test="$type = 'info'"/>
        <xsl:otherwise>
          <!-- i18n with concat : see dynamic_strings.xsl - type-export-multiple-filtered-xml -->
          <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
            <a href="/omp?cmd=export_{gsa:type-many($type)}{$extra_params_string}&amp;filter={str:encode-uri (filters/term, true ())}&amp;token={/envelope/token}"
               title="{gsa-i18n:strformat (gsa:n-i18n (concat ('Export %1 filtered ', $cap-type, ' as XML'), concat ('Export %1 filtered ', $cap-type-plural, ' as XML'), $filtered-count, $cap-type), $filtered-count)}"
               style="margin-left:3px;">
              <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export XML', 'Action Verb')}"/>
            </a>
          </div>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$type = 'info'"/>
        <xsl:otherwise>
          <div id="small_inline_form" style="margin-left:40px; display: inline">
            <form method="get" action="" enctype="multipart/form-data">
              <input type="hidden" name="token" value="{/envelope/token}"/>
              <input type="hidden" name="cmd" value="get_{gsa:type-many($type)}"/>
              <input type="hidden" name="filter" value="{filters/term}"/>
              <input type="hidden" name="filt_id" value="{filters/@id}"/>
              <xsl:call-template name="auto-refresh"/>
              <input type="image"
                     name="Update"
                     src="/img/refresh.png"
                     title="{gsa:i18n ('Update auto-refresh', 'Auto-Refresh')}"
                     alt="{gsa:i18n ('Update', 'Action Verb')}" style="margin-left:3px;margin-right:3px;"/>
            </form>
          </div>
        </xsl:otherwise>
      </xsl:choose>
    </div>
    <xsl:call-template name="filter-window-part">
      <xsl:with-param name="type" select="$type"/>
      <xsl:with-param name="subtype" select="$subtype"/>
      <xsl:with-param name="list" select="$resources-summary"/>
      <xsl:with-param name="columns" select="$columns"/>
      <xsl:with-param name="extra_params">
        <xsl:copy-of select="$extra_params"/>
        <xsl:if test="$subtype != ''">
          <param>
            <name><xsl:value-of select="$type"/>_type</name>
            <value><xsl:value-of select="$subtype"/></value>
          </param>
        </xsl:if>
      </xsl:with-param>
    </xsl:call-template>
    <div class="gb_window_part_content_no_pad">
      <xsl:variable name="caller_escaped" select="gsa:escape-js (/envelope/current_page)"/>
      <xsl:choose>
        <xsl:when test="$top-visualization = ''"/>
        <xsl:when test="/envelope/charts = '1'">
          <div id="top-visualization">
            <xsl:copy-of select="$top-visualization"/>
          </div>
          <xsl:choose>
            <xsl:when test="/envelope/params/charts = '1'">
              <a class="charts-bar" href="{substring-before (/envelope/current_page, '&amp;charts=1')}{substring-after (/envelope/current_page, '&amp;charts=1')}&amp;charts=0&amp;token={/envelope/token}" title="{gsa:i18n ('Hide Charts', 'Dashboard')}">&#9650; &#9650; &#9650;</a>
            </xsl:when>
            <xsl:otherwise>
              <a class="charts-bar" href="{/envelope/current_page}&amp;charts=0&amp;token={/envelope/token}" title="{gsa:i18n ('Hide Charts', 'Dashboard')}">&#9650; &#9650; &#9650;</a>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="/envelope/params/charts = '0'">
              <script type="text/javascript">
                document.write ("&lt;a class=\"charts-bar\" href=\"" + encodeURI ("<xsl:value-of select="substring-before ($caller_escaped, '&amp;charts=0')"/><xsl:value-of select="substring-after ($caller_escaped, '&amp;charts=0')"/>&amp;charts=1&amp;token=<xsl:value-of select="/envelope/token"/>") + "\" title=\"<xsl:value-of select="gsa:i18n('Show Charts', 'Dashboard')"/>\"&gt;&#9660; &#9660; &#9660;&lt;/a&gt;");
              </script>
            </xsl:when>
            <xsl:otherwise>
              <script type="text/javascript">
                document.write ("&lt;a class=\"charts-bar\" href=\"" + encodeURI ("<xsl:value-of select="$caller_escaped"/>") + "&amp;charts=1&amp;token=<xsl:value-of select="/envelope/token"/>\" title=\"<xsl:value-of select="gsa:i18n('Show Charts', 'Dashboard')"/>\"&gt;&#9660; &#9660; &#9660;&lt;/a&gt;");
              </script>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <div>
        <xsl:variable name="table">
          <table class="gbntable" cellspacing="2" cellpadding="4" border="0" style="margin-bottom:0px;">
            <tr class="gbntablehead2">
              <xsl:variable name="current" select="."/>
              <xsl:variable name="token" select="/envelope/token"/>
              <xsl:for-each select="exslt:node-set ($columns)/column">
                <xsl:choose>
                  <xsl:when test="count (column) = 0">
                    <td rowspan="2">
                      <xsl:copy-of select="html/before/*"/>
                      <xsl:call-template name="column-name">
                        <xsl:with-param name="head" select="name"/>
                        <xsl:with-param name="image" select="image"/>
                        <xsl:with-param name="name" select="field"/>
                        <xsl:with-param name="type" select="$type"/>
                        <xsl:with-param name="current" select="$current"/>
                        <xsl:with-param name="token" select="$token"/>
                        <xsl:with-param name="extra_params" select="concat($subtype_param, $extra_params_string)"/>
                        <xsl:with-param name="sort-reverse" select="boolean (sort-reverse)"/>
                        <xsl:with-param name="i18n-context" select="$cap-type"/>
                      </xsl:call-template>
                      <xsl:copy-of select="html/after/*"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td colspan="{count (column)}">
                      <xsl:value-of select="gsa:i18n (name, $cap-type)"/>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
              <xsl:if test="$icon-count &gt; 0">
                <td width="{gsa:actions-width ($icon-count)}" rowspan="2"><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
              </xsl:if>
            </tr>
            <tr class="gbntablehead2">
              <xsl:variable name="current" select="."/>
              <xsl:variable name="token" select="/envelope/token"/>
              <xsl:for-each select="exslt:node-set ($columns)/column">
                <xsl:choose>
                  <xsl:when test="count (column) = 0">
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:for-each select="column">
                      <td style="font-size:10px;">
                        <xsl:copy-of select="html/before/*"/>
                        <xsl:call-template name="column-name">
                          <xsl:with-param name="head" select="name"/>
                          <xsl:with-param name="image" select="image"/>
                          <xsl:with-param name="name" select="field"/>
                          <xsl:with-param name="type" select="$type"/>
                          <xsl:with-param name="current" select="$current"/>
                          <xsl:with-param name="token" select="$token"/>
                          <xsl:with-param name="extra_params" select="concat($subtype_param, $extra_params_string)"/>
                          <xsl:with-param name="sort-reverse" select="boolean (sort-reverse)"/>
                          <xsl:with-param name="i18n-context" select="$cap-type"/>
                        </xsl:call-template>
                        <xsl:copy-of select="html/after/*"/>
                      </td>
                    </xsl:for-each>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </tr>

            <xsl:variable name="bulk-elements">
              <xsl:variable name="selection_type">
                <xsl:choose>
                  <xsl:when test="/envelope/params/bulk_select = 1">selection</xsl:when>
                  <xsl:when test="/envelope/params/bulk_select = 2">all filtered</xsl:when>
                  <xsl:otherwise>page contents</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <input type="hidden" name="token" value="{/envelope/token}"/>
              <xsl:text> </xsl:text>
              <input type="hidden" name="cmd" value="process_bulk"/>
              <input type="hidden" name="next" value="get_{$type}s"/>
              <input type="hidden" name="filter" value="{filters/term}"/>
              <input type="hidden" name="filt_id" value="{filters/@id}"/>
              <input type="hidden" name="bulk_select" value="{/envelope/params/bulk_select}"/>
              <xsl:if test="$subtype">
                <input type="hidden" name="{$type}_type" value="{$subtype}"/>
              </xsl:if>

              <xsl:for-each select="exslt:node-set($extra_params)/param">
                <input type="hidden" name="{name}" value="{value}"/>
              </xsl:for-each>

              <input type="hidden" name="resource_type" value="{$type}"/>

              <!-- i18n with concat : see dynamic_strings.xsl - bulk-actions -->
              <xsl:if test="gsa:may-op (concat ('delete_', $type)) and ($type != 'info' and $type != 'user' and $type != 'report')">
                <input style="margin-right:3px" type="image" name="bulk_trash" title="{gsa:i18n (concat ('Move ', $selection_type, ' to trashcan'), 'Bulk Action')}" src="/img/trashcan.png"/>
              </xsl:if>
              <xsl:if test="gsa:may-op (concat ('delete_', $type)) and ($type = 'user' or $type = 'report')">
                <input style="margin-right:3px" type="image" name="bulk_delete" title="{gsa:i18n (concat ('Delete ', $selection_type), 'Bulk Action')}" src="/img/delete.png"/>
              </xsl:if>
              <xsl:if test="$type != 'report'">
                <input style="margin-right:3px" type="image" name="bulk_export" title="{gsa:i18n (concat ('Export ', $selection_type), 'Bulk Action')}" src="/img/download.png"/>
              </xsl:if>
            </xsl:variable>

            <xsl:choose>
              <xsl:when test="$no_bulk">
                <xsl:apply-templates select="$resources"/>
              </xsl:when>
              <xsl:when test="not (/envelope/params/bulk_select = 1)">
                <xsl:apply-templates select="$resources"/>
                <tr style="background:#DDDDDD">
                  <td colspan="{count (exslt:node-set ($columns)/column/column) + count (exslt:node-set ($columns)/column[count (column) = 0]) + ($icon-count &gt; 0)}"  style="text-align:right;" id="small_inline_form">
                    <form name="bulk-actions" method="post" action="/omp" enctype="multipart/form-data">
                      <xsl:choose>
                        <xsl:when test="$type = 'info'">
                          <xsl:for-each select="$resources">
                            <input type="hidden" name="bulk_selected:{../@id}" value="1"/>
                          </xsl:for-each>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:for-each select="$resources">
                            <input type="hidden" name="bulk_selected:{@id}" value="1"/>
                          </xsl:for-each>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:copy-of select="$bulk-elements"/>
                    </form>
                  </td>
                </tr>
              </xsl:when>
              <xsl:otherwise>
                <xsl:apply-templates select="$resources"/>
                <tr style="background:#DDDDDD">
                  <td colspan="{count (exslt:node-set ($columns)/column/column) + count (exslt:node-set ($columns)/column[count (column) = 0]) + ($icon-count &gt; 0)}"  style="text-align:right;" id="small_inline_form">
                    <xsl:copy-of select="$bulk-elements"/>
                  </td>
                </tr>
              </xsl:otherwise>
            </xsl:choose>
          </table>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="/envelope/params/bulk_select = 1">
            <form name="bulk-actions" method="post" action="/omp" enctype="multipart/form-data">
              <xsl:copy-of select="$table"/>
            </form>
          </xsl:when>
          <xsl:otherwise>
            <xsl:copy-of select="$table"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="not ($no_bulk)">
          <form name="bulk_select_type_form" id="small_inline_form" style="margin-top:-23px; margin-right:66px; text-align:right; height:26px"
                enctype="multipart/form-data">
            <input type="hidden" name="token" value="{/envelope/token}"/>
            <input type="hidden" name="cmd" value="get_{gsa:type-many($type)}"/>
            <xsl:if test="$subtype">
              <input type="hidden" name="{$type}_type" value="{$subtype}"/>
            </xsl:if>
            <xsl:for-each select="exslt:node-set($extra_params)/param">
              <input type="hidden" name="{name}" value="{value}"/>
            </xsl:for-each>
            <input type="hidden" name="filter" value="{filters/term}"/>
            <input type="hidden" name="filt_id" value="{filters/@id}"/>
            <select name="bulk_select" onchange="bulk_select_type_form.submit()">
              <!-- TODO selection by current parameter value + check marks -->
              <xsl:choose>
                <xsl:when test="not (/envelope/params/bulk_select != 0)">
                  <option value="0" selected="1">&#8730;<xsl:value-of select="gsa:i18n('Apply to page contents', 'Bulk Action')"/></option>
                </xsl:when>
                <xsl:otherwise>
                  <option value="0"><xsl:value-of select="gsa:i18n('Apply to page contents', 'Bulk Action')"/></option>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:choose>
                <xsl:when test="/envelope/params/bulk_select = '1'">
                  <option value="1" selected="1">&#8730;<xsl:value-of select="gsa:i18n('Apply to selection', 'Bulk Action')"/></option>
                </xsl:when>
                <xsl:otherwise>
                  <option value="1"><xsl:value-of select="gsa:i18n('Apply to selection', 'Bulk Action')"/></option>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:choose>
                <xsl:when test="/envelope/params/bulk_select = '2'">
                  <option value="2" selected="1">&#8730;<xsl:value-of select="gsa:i18n('Apply to all filtered', 'Bulk Action')"/></option>
                </xsl:when>
                <xsl:otherwise>
                  <option value="2"><xsl:value-of select="gsa:i18n('Apply to all filtered', 'Bulk Action')"/></option>
                </xsl:otherwise>
              </xsl:choose>
            </select>
            <xsl:text> </xsl:text>
            <input type="image" src="/img/refresh.png" alt="{gsa:i18n ('Update', 'Action Verb')}" title="{gsa:i18n ('Update', 'Action Verb')}"/>
          </form>
        </xsl:if>
        <xsl:if test="string-length (filters/term) &gt; 0">
          <table style="width:100%; margin-bottom:10px">
            <tr>
              <td class="footnote" colspan="{count (exslt:node-set ($columns)/column/column) + count (exslt:node-set ($columns)/column[count (column) = 0]) + ($icon-count &gt; 0)}">
                <div class="float_right">
                  <xsl:call-template name="filter-window-pager">
                    <xsl:with-param name="type" select="$type"/>
                    <xsl:with-param name="list" select="$resources-summary"/>
                    <xsl:with-param name="count" select="$count"/>
                    <xsl:with-param name="filtered_count" select="$filtered-count"/>
                    <xsl:with-param name="full_count" select="$full-count"/>
                    <xsl:with-param name="extra_params" select="concat($subtype_param, $extra_params_string)"/>
                  </xsl:call-template>
                </div>
                (<xsl:value-of select="gsa:i18n('Applied filter', 'Filter')"/>:
                <a class="footnote" href="/omp?cmd=get_{gsa:type-many($type)}{$extra_params_string}&amp;filter={str:encode-uri (filters/term, true ())}&amp;token={/envelope/token}">
                  <xsl:value-of select="filters/term"/>
                </a>)
              </td>
            </tr>
          </table>
        </xsl:if>
        <xsl:call-template name="wizard"/>
      </div>
    </div>
  </div>
</xsl:template>

<xsl:template name="minor-details">
  <div class="float_right" style="font-size: 10px;">
    <table style="font-size: 10px;">
      <tr>
        <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
        <td><xsl:value-of select="@id"/></td>
      </tr>
      <tr>
        <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
        <td><xsl:value-of select="gsa:long-time (creation_time)"/></td>
      </tr>
      <tr>
        <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
        <td><xsl:value-of select="gsa:long-time (modification_time)"/></td>
      </tr>
      <tr>
        <td><xsl:value-of select="gsa:i18n ('Owner', 'Property')"/>:</td>
        <td><xsl:value-of select="owner/name"/></td>
      </tr>
    </table>
  </div>
</xsl:template>

<xsl:template name="details-header-icons">
  <xsl:param name="cap-type"/>
  <xsl:param name="cap-type-plural" select="concat ($cap-type, 's')"/>
  <xsl:param name="type"/>
  <xsl:param name="noedit"/>
  <xsl:param name="nonew"/>
  <xsl:param name="noclone" select="$nonew"/>
  <xsl:param name="grey-clone" select="0"/>
  <xsl:param name="noexport"/>
  <xsl:param name="filter" select="/envelope/params/filter"/>
  <xsl:param name="filt_id" select="/envelope/params/filt_id"/>

  <!-- i18n with concat : see dynamic_strings.xsl - type-details -->
  <a href="/help/{$type}_details.html?token={/envelope/token}"
    title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n(concat($cap-type, ' Details'), $cap-type)}">
    <img src="/img/help.png"/>
  </a>
  <xsl:choose>
    <xsl:when test="$nonew"/>
    <xsl:when test="gsa:may-op (concat ('create_', $type))">
      <!-- i18n with concat : see dynamic_strings.xsl - type-new -->
      <a href="/omp?cmd=new_{$type}&amp;next=get_{$type}&amp;filter={str:encode-uri ($filter, true ())}&amp;filt_id={$filt_id}&amp;{$type}_id={@id}&amp;token={/envelope/token}"
         title="{gsa:i18n (concat ('New ', $cap-type), $cap-type)}">
        <img src="/img/new.png" border="0" style="margin-left:3px;"/>
      </a>
    </xsl:when>
  </xsl:choose>
  <xsl:choose>
    <xsl:when test="$noclone"/>
    <xsl:when test="$grey-clone">
      <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
      <img src="/img/clone_inactive.png"
           alt="{gsa:i18n ('Clone', 'Action Verb')}"
           value="Clone"
           title="{gsa:i18n (concat ($cap-type, ' may not be cloned'), $cap-type)}"
           style="margin-left:3px;"/>
    </xsl:when>
    <xsl:when test="gsa:may-clone ($type, owner)">
      <xsl:choose>
        <xsl:when test="writable='0' and $type='permission'">
          <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
          <img src="/img/clone_inactive.png"
               alt="{gsa:i18n ('Clone', 'Action Verb')}"
               value="Clone"
               title="{gsa:i18n (concat ($cap-type, ' must be owned or global'), $cap-type)}"
               style="margin-left:3px;"/>
        </xsl:when>
        <xsl:otherwise>
          <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp" method="post" enctype="multipart/form-data">
            <input type="hidden" name="token" value="{/envelope/token}"/>
            <input type="hidden" name="caller" value="{/envelope/current_page}"/>
            <input type="hidden" name="cmd" value="clone"/>
            <input type="hidden" name="resource_type" value="{$type}"/>
            <input type="hidden" name="next" value="get_{$type}"/>
            <input type="hidden" name="id" value="{@id}"/>
            <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
            <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
            <input type="image" src="/img/clone.png" alt="{gsa:i18n ('Clone', 'Action Verb')}"
                  name="Clone" value="Clone" title="{gsa:i18n ('Clone', 'Action Verb')}"/>
          </form>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
  </xsl:choose>
  <a href="/omp?cmd=get_{$type}s&amp;filter={str:encode-uri ($filter, true ())}&amp;filt_id={$filt_id}&amp;token={/envelope/token}"
     title="{gsa:i18n ($cap-type-plural, $cap-type)}" style="margin-left:3px;">
    <img src="/img/list.png" border="0" alt="{gsa:i18n ($cap-type-plural, $cap-type)}"/>
  </a>
  <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
    <xsl:choose>
      <xsl:when test="$type = 'user'">
        <xsl:choose>
          <xsl:when test="name=/envelope/login/text()">
            <img src="/img/delete_inactive.png" border="0" alt="{gsa:i18n ('Delete', 'Action Verb')}"
                 title="{gsa:i18n ('Currently logged in as this user', 'User')}"
                 style="margin-left:3px;"/>
          </xsl:when>
          <xsl:when test="gsa:may (concat ('delete_', $type)) and writable!='0' and in_use='0'">
            <xsl:call-template name="delete-icon">
              <xsl:with-param name="type" select="$type"/>
              <xsl:with-param name="id" select="@id"/>
              <xsl:with-param name="params">
                <input type="hidden" name="filter" value="{$filter}"/>
                <input type="hidden" name="filt_id" value="{$filt_id}"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="inactive_text">
              <xsl:choose>
                <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
                <xsl:when test="in_use != '0'">
                  <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is still in use'), $cap-type)"/>
                </xsl:when>
                <xsl:when test="writable = '0'">
                  <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is not writable'), $cap-type)"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="gsa:i18n (concat ($cap-type, ' cannot be deleted'), $cap-type)"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <img src="/img/delete_inactive.png" border="0" alt="{gsa:i18n ('Delete', 'Action Verb')}"
                 title="{$inactive_text}"
                 style="margin-left:3px;"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="gsa:may (concat ('delete_', $type)) and writable!='0' and in_use='0'">
            <xsl:call-template name="trashcan-icon">
              <xsl:with-param name="type" select="$type"/>
              <xsl:with-param name="id" select="@id"/>
              <xsl:with-param name="params">
                <input type="hidden" name="filter" value="{$filter}"/>
                <input type="hidden" name="filt_id" value="{$filt_id}"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="inactive_text">
              <xsl:choose>
                <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
                <xsl:when test="in_use != '0'">
                  <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is still in use'), $cap-type)"/>
                </xsl:when>
                <xsl:when test="writable = '0'">
                  <xsl:value-of select="gsa:i18n (concat ($cap-type, ' is not writable'), $cap-type)"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="gsa:i18n (concat ($cap-type, ' cannot be moved to the trashcan'), $cap-type)"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <img src="/img/trashcan_inactive.png" border="0" alt="{gsa:i18n ('To Trashcan', 'Action Verb')}"
                 title="{$inactive_text}"
                 style="margin-left:3px;"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="$noedit">
      </xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="gsa:may (concat ('modify_', $type)) and writable!='0'">
            <!-- i18n with concat : see dynamic_strings.xsl - type-edit -->
            <a href="/omp?cmd=edit_{$type}&amp;{$type}_id={@id}&amp;next=get_{$type}&amp;filter={str:encode-uri ($filter, true ())}&amp;filt_id={$filt_id}&amp;token={/envelope/token}"
               title="{gsa:i18n (concat ('Edit ', $cap-type), $cap-type)}">
              <img src="/img/edit.png" border="0" style="margin-left:3px;"/>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <!-- i18n with concat : see dynamic_strings.xsl - type-action-denied -->
            <img src="/img/edit_inactive.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"
                 title="{gsa:i18n (concat ($cap-type, ' is not writable'), $cap-type)}"
                 style="margin-left:3px;"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="$noexport">
      </xsl:when>
      <xsl:otherwise>
        <!-- i18n with concat : see dynamic_strings.xsl - type-export-xml -->
        <a href="/omp?cmd=export_{$type}&amp;{$type}_id={@id}&amp;filter={str:encode-uri ($filter, true ())}&amp;filt_id={$filt_id}&amp;token={/envelope/token}"
           title="{gsa:i18n (concat ('Export ', $cap-type, ' as XML'), $cap-type)}"
           style="margin-left:3px;">
          <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export XML', 'Action Verb')}"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </div>
</xsl:template>

<xsl:template match="gsad_msg">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      <xsl:value-of select="@operation"/>
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
    <xsl:with-param name="details">
      <xsl:value-of select="text()"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="commands_response">
  <xsl:apply-templates/>
</xsl:template>


<!-- BEGIN TASKS MANAGEMENT -->

<xsl:template match="message">
  <div class="message">
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="error">
  <div class="error">
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="status">
</xsl:template>

<xsl:template match="hole">
  H=<xsl:apply-templates/>
</xsl:template>

<xsl:template match="warning">
  W=<xsl:apply-templates/>
</xsl:template>

<xsl:template match="info">
  I=<xsl:apply-templates/>
</xsl:template>

<xsl:template match="debug">
  D=<xsl:apply-templates/>
</xsl:template>

<xsl:template match="log">
  L=<xsl:apply-templates/>
</xsl:template>

<xsl:template match="false_positive">
  F=<xsl:apply-templates/>
</xsl:template>

<xsl:template match="result_count">
  <div>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="create_report_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Container Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="create_task_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="delete_task_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Delete Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="delete_report_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Delete Report</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="run_wizard_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Run Wizard</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="start_task_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Start Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="stop_task_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Stop Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="resume_task_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Resume Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- NEW_TASK -->

<xsl:template name="new-task-alert-select">
  <xsl:param name="position" select="1"/>
  <xsl:param name="count" select="0"/>
  <xsl:param name="alerts" select="get_alerts_response"/>
  <xsl:param name="select_id" select="alert_id"/>
  <select name="alert_id_optional:{$position}">
    <option value="--">--</option>
    <xsl:apply-templates select="$alerts/alert"
                         mode="newtask">
      <xsl:with-param name="select_id" select="$select_id"/>
    </xsl:apply-templates>
  </select>
  <xsl:if test="$count &gt; 1">
    <br/>
    <xsl:call-template name="new-task-alert-select">
      <xsl:with-param name="alerts" select="$alerts"/>
      <xsl:with-param name="count" select="$count - 1"/>
      <xsl:with-param name="position" select="$position + 1"/>
      <xsl:with-param name="select_id" select="$select_id"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="new-task-group-select">
  <xsl:param name="position" select="1"/>
  <xsl:param name="count" select="0"/>
  <xsl:param name="groups" select="get_groups_response"/>
  <select name="group_id_optional:{$position}">
    <option value="--">--</option>
    <xsl:apply-templates select="$groups/group"
                         mode="newtask"/>
  </select>
  <xsl:if test="$count &gt; 1">
    <br/>
    <xsl:call-template name="new-task-group-select">
      <xsl:with-param name="groups" select="$groups"/>
      <xsl:with-param name="count" select="$count - 1"/>
      <xsl:with-param name="position" select="$position + 1"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template match="task_count">
</xsl:template>

<xsl:template match="new_task">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_task_response"/>
  <xsl:apply-templates select="create_report_response"/>

  <div class="gb_window_part_left"></div>
  <div class="gb_window_part_right"></div>
  <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Task', 'Task')"/>
    <a href="/help/new_task.html?token={/envelope/token}#newtask" title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('New Task', 'Task')}">
      <img src="/img/help.png"/>
    </a>
    <a href="/omp?cmd=wizard&amp;name=quick_first_scan&amp;refresh_interval={/envelope/params/refresh_interval}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
       title="{gsa:i18n ('Wizard', 'Wizard')}">
      <img src="/img/wizard.png" border="0" style="margin-left:3px;"/>
    </a>
    <a href="/omp?cmd=get_tasks&amp;refresh_interval={/envelope/params/refresh_interval}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
       title="{gsa:i18n ('Tasks', 'Task')}" style="margin-left:3px;">
      <img src="/img/list.png" border="0" alt="{gsa:i18n ('Tasks', 'Task')}"/>
    </a>
  </div>
  <div class="gb_window_part_content">
    <form action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="cmd" value="create_task"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="next" value="get_task"/>
      <xsl:if test="string-length (/envelope/params/filt_id) = 0">
        <input type="hidden" name="overrides" value="{/envelope/params/overrides}"/>
      </xsl:if>
      <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
      <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
      <xsl:if test="not (gsa:may-op ('get_alerts'))">
        <input type="hidden" name="alerts" value="1"/>
        <input type="hidden" name="alert_id_optional:1" value="--"/>
      </xsl:if>
      <xsl:if test="not (gsa:may-op ('get_schedules'))">
        <input type="hidden" name="schedule_id_optional" value="--"/>
      </xsl:if>
      <xsl:if test="not (gsa:may-op ('get_slaves'))">
        <input type="hidden" name="slave_id_optional" value="--"/>
      </xsl:if>
      <xsl:if test="not (gsa:may-op ('get_groups'))">
        <input type="hidden" name="groups" value="1"/>
        <input type="hidden" name="group_id_optional:1" value="--"/>
      </xsl:if>
      <table border="0" cellspacing="0" cellpadding="3" width="100%">
        <tr>
         <td valign="top" width="150"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
         <td width="280">
           <input type="text" name="name" value="{gsa:param-or ('name', 'unnamed')}" size="30"
                  maxlength="80"/>
         </td>
        </tr>
        <tr>
          <td valign="top"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
          <td>
            <input type="text" name="comment" value="{gsa:param-or ('comment', '')}" size="30" maxlength="400"/>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Scan Targets', 'Task')"/></td>
          <td>
            <select name="target_id">
              <xsl:variable name="target_id">
                <xsl:value-of select="target_id"/>
              </xsl:variable>
              <xsl:for-each select="get_targets_response/target">
                <xsl:choose>
                  <xsl:when test="@id = $target_id">
                    <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="{@id}"><xsl:value-of select="name"/></option>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </select>
          </td>
        </tr>
        <xsl:if test="gsa:may-op ('get_alerts')">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Alerts', 'Alert')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <xsl:variable name="alerts"
                            select="get_alerts_response/alert"/>
              <xsl:for-each select="/envelope/params/_param[substring-before (name, ':') = 'alert_id_optional']">
                <xsl:sort select="substring-after (name, ':')" data-type="number"/>
                <select name="{name}">
                  <xsl:variable name="alert_id" select="value"/>
                  <xsl:choose>
                    <xsl:when test="string-length ($alert_id) &gt; 0">
                      <option value="--">--</option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="--" selected="1">--</option>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:for-each select="$alerts">
                    <xsl:choose>
                      <xsl:when test="@id = $alert_id">
                        <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="{@id}"><xsl:value-of select="name"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:for-each>
                </select>
                <br/>
              </xsl:for-each>
              <xsl:variable name="count"
                            select="count (/envelope/params/_param[substring-before (name, ':') = 'alert_id_optional'])"/>
              <xsl:call-template name="new-task-alert-select">
                <xsl:with-param name="alerts" select="get_alerts_response"/>
                <xsl:with-param name="count" select="/envelope/params/alerts - $count"/>
                <xsl:with-param name="position" select="$count + 1"/>
                <xsl:with-param name="select_id" select="alert_id"/>
              </xsl:call-template>

              <xsl:choose>
                <xsl:when test="string-length (/envelope/params/alerts)">
                  <input type="hidden" name="alerts" value="{/envelope/params/alerts}"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="hidden" name="alerts" value="{1}"/>
                </xsl:otherwise>
              </xsl:choose>
              <!-- Force the Create Task button to be the default. -->
              <input style="position: absolute; left: -100%"
                     type="submit" name="submit" value="{gsa:i18n ('Create Task', 'Task')}"/>
              <input type="submit" name="submit_plus" value="+"/>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="gsa:may-op ('get_schedules')">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Schedule', 'Schedule')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <select name="schedule_id_optional">
                <xsl:variable name="schedule_id"
                              select="schedule_id"/>
                <xsl:choose>
                  <xsl:when test="string-length ($schedule_id) &gt; 0">
                    <option value="--">--</option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="--" selected="1">--</option>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:for-each select="get_schedules_response/schedule">
                  <xsl:choose>
                    <xsl:when test="@id = $schedule_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
              <input name="schedule_periods" type="checkbox" value="1"
                     title="{gsa:i18n ('Once', 'Time')}"/>
              <xsl:value-of select="gsa:i18n ('Once', 'Time')"/>
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Add results to Asset Management', 'Task')"/></td>
          <td>
            <xsl:variable name="yes" select="/envelope/params/in_assets"/>
            <label>
              <xsl:choose>
                <xsl:when test="string-length ($yes) = 0 or $yes = 1">
                  <input type="radio" name="in_assets" value="1" checked="1"/>
                </xsl:when>
                <xsl:otherwise>
                 <input type="radio" name="in_assets" value="1"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
            </label>
            <label>
              <xsl:choose>
                <xsl:when test="string-length ($yes) = 0 or $yes = 1">
                  <input type="radio" name="in_assets" value="0"/>
                </xsl:when>
                <xsl:otherwise>
                 <input type="radio" name="in_assets" value="0" checked="1"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
            </label>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Alterable Task', 'Task')"/></td>
          <td>
            <xsl:variable name="yes" select="/envelope/params/alterable"/>
            <label>
              <xsl:choose>
                <xsl:when test="string-length ($yes) = 0 or $yes = 0">
                  <input type="radio" name="alterable" value="1"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="radio" name="alterable" value="1" checked="1"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
            </label>
            <label>
              <xsl:choose>
                <xsl:when test="string-length ($yes) = 0 or $yes = 0">
                  <input type="radio" name="alterable" value="0" checked="1"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="radio" name="alterable" value="0"/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
            </label>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Auto Delete Reports', 'Task')"/></td>
          <td colspan="2">
            <xsl:variable name="auto_delete" select="/envelope/params/auto_delete"/>
            <xsl:variable name="auto_delete_data" select="/envelope/params/auto_delete_data"/>
            <div>
              <label>
                <xsl:choose>
                  <xsl:when test="$auto_delete = 'keep'">
                    <input type="radio" name="auto_delete" value="no"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="auto_delete" value="no" checked="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Do not automatically delete reports', 'Task')"/>
              </label>
            </div>
            <div>
              <label>
                <xsl:choose>
                  <xsl:when test="$auto_delete = 'keep'">
                    <input type="radio" name="auto_delete" value="keep" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="auto_delete" value="keep"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Automatically delete oldest reports but always keep newest ', 'Task')"/>
                <div style="display: inline;">
                  <input style="display: inline;"
                         type="text" name="auto_delete_data" value="5"
                         size="4" maxlength="5"/>
                </div>
                <xsl:value-of select="gsa:i18n (' reports', 'Task')"/>
              </label>
            </div>
          </td>
        </tr>
      </table>

      <table>
        <tr>
          <td>
            <h3><xsl:value-of select="gsa:i18n ('Scanner', 'Scanner')"/></h3>
          </td>
        </tr>
        <xsl:if test="count(get_scanners_response/scanner[type = 2]) &gt;= 0">
          <tr>
            <td>
              <input type="radio" name="scanner_type" value="2" checked="1"/>
            </td>
            <td>
              <xsl:call-template name="scanner-type-name">
                <xsl:with-param name="type" select="2"/>
              </xsl:call-template>
            </td>
            <td>
              <xsl:variable name="scanner_id" select="scanner_id"/>
              <select name="scanner_id">
                <xsl:for-each select="get_scanners_response/scanner[type = 2]">
                  <xsl:choose>
                    <xsl:when test="@id = $scanner_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
            </td>
          </tr>
          <tr>
            <td>
            </td>
            <td><xsl:value-of select="gsa:i18n ('Scan Config', 'Scan Config')"/>
            </td>
            <td>
              <xsl:variable name="config_id" select="config_id"/>
              <select name="config_id">
                <!-- Skip the "empty" config. -->
                <xsl:for-each select="get_configs_response/config[@id!='085569ce-73ed-11df-83c3-002264764cea' and type = 0]">
                  <xsl:choose>
                    <xsl:when test="@id = $config_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
            </td>
          </tr>
          <xsl:if test="gsa:may-op ('get_slaves')">
            <tr>
              <td></td>
              <td><xsl:value-of select="gsa:i18n ('Slave', 'Slave')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
              <td>
                <select name="slave_id_optional">
                  <xsl:variable name="slave_id">
                    <xsl:value-of select="slave_id"/>
                  </xsl:variable>
                  <xsl:choose>
                    <xsl:when test="string-length ($slave_id) &gt; 0">
                      <option value="--">--</option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="--" selected="1">--</option>
                    </xsl:otherwise>
                  </xsl:choose>
                  <xsl:for-each select="get_slaves_response/slave">
                    <xsl:choose>
                      <xsl:when test="@id = $slave_id">
                        <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="{@id}"><xsl:value-of select="name"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:for-each>
                </select>
              </td>
            </tr>
          </xsl:if>
          <tr>
            <td></td>
            <td><xsl:value-of select="gsa:i18n ('Network Source Interface', 'Task')"/></td>
            <td>
              <input type="text" name="source_iface" value="{/envelope/params/source_iface}"/>
            </td>
          </tr>
          <tr>
            <td></td>
            <td><xsl:value-of select="gsa:i18n ('Order for target hosts', 'Task')"/></td>
            <td>
              <select name="hosts_ordering">
                <option value="sequential" selected="1"><xsl:value-of select="gsa:i18n ('Sequential', 'Task|Hosts Ordering')"/></option>
                <option value="random"><xsl:value-of select="gsa:i18n ('Random', 'Task|Hosts Ordering')"/></option>
                <option value="reverse"><xsl:value-of select="gsa:i18n ('Reverse', 'Task|Hosts Ordering')"/></option>
              </select>
            </td>
          </tr>
          <tr>
            <td></td>
            <td>
              <xsl:value-of select="gsa:i18n ('Maximum concurrently executed NVTs per host', 'Task')"/>
            </td>
            <td>
              <input type="text" name="max_checks" value="{gsa:param-or ('max_checks', '4')}"
                     size="10" maxlength="10"/>
            </td>
          </tr>
          <tr>
            <td></td>
            <td>
              <xsl:value-of select="gsa:i18n ('Maximum concurrently scanned hosts', 'Task')"/>
            </td>
            <td>
              <input type="text" name="max_hosts" value="{gsa:param-or ('max_hosts', '20')}"
                     size="10" maxlength="10"/>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="count(get_scanners_response/scanner[type = 1]) and count(get_configs_response/config[type = 1])">
          <tr>
            <td>
              <input type="radio" name="scanner_type" value="1"/>
            </td>
            <td>
              <xsl:call-template name="scanner-type-name">
                <xsl:with-param name="type" select="1"/>
              </xsl:call-template>
            </td>
            <td>
              <xsl:variable name="osp_scanner_id" select="osp_scanner_id"/>
              <select name="osp_scanner_id">
                <xsl:for-each select="get_scanners_response/scanner[type = 1]">
                  <xsl:choose>
                    <xsl:when test="@id = $osp_scanner_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
            </td>
          </tr>
          <tr>
            <td valign="top"></td>
            <td>
              <xsl:value-of select="gsa:i18n ('Scan Config', 'Scan Config')"/>
            </td>
            <td>
              <xsl:variable name="osp_config_id" select="osp_config_id"/>
              <select name="osp_config_id">
                <!-- Skip the "empty" config. -->
                <xsl:for-each select="get_configs_response/config[type = 1]">
                  <xsl:choose>
                    <xsl:when test="@id = $osp_config_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
            </td>
          </tr>
        </xsl:if>
      </table>
      <xsl:if test="gsa:may-op ('get_tags') and gsa:may-op ('create_task') and count(get_tags_response/tag) != 0">
        <table>
          <tr>
            <td colspan="2">
              <h3><xsl:value-of select="gsa:i18n ('Tag', 'Tag')"/></h3>
            </td>
          </tr>
          <tr>
            <td>
              <label>
                <xsl:choose>
                  <xsl:when test="/envelope/params/add_tag != 0">
                    <input type="checkbox" name="add_tag" value="1" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="checkbox" name="add_tag" value="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Add Tag', 'Tag')"/>:
              </label>
            </td>
            <td>
              <select name="tag_name">
                <xsl:for-each select="get_tags_response/tag">
                  <xsl:call-template name="opt">
                    <xsl:with-param name="value" select="name"/>
                    <xsl:with-param name="select-value" select="/envelope/params/tag_name"/>
                  </xsl:call-template>
                </xsl:for-each>
              </select>
              <xsl:text> </xsl:text>
              <xsl:value-of select="gsa:i18n ('with Value', 'Tag')"/>
              <xsl:text> </xsl:text>
              <input name="tag_value" type="text" value="{/envelope/params/tag_value}"/>
            </td>
          </tr>
        </table>
      </xsl:if>
      <table border="0" cellspacing="0" cellpadding="3" width="100%">
        <tr>
          <td colspan="2" style="text-align:right;">
            <input type="submit" name="submit" value="{gsa:i18n ('Create Task', 'Task')}"/>
          </td>
        </tr>
      </table>
      <br/>
    </form>
  </div>

  <div class="gb_window_part_left"></div>
  <div class="gb_window_part_right"></div>
  <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Container Task', 'Task')"/>
    <a href="/help/new_task.html?token={/envelope/token}#newcontainertask" title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('New Task', 'Task')}">
      <img src="/img/help.png"/>
    </a>
    <a href="/omp?cmd=get_tasks&amp;refresh_interval={/envelope/params/refresh_interval}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
       title="{gsa:i18n ('Tasks', 'Task')}" style="margin-left:3px;">
      <img src="/img/list.png" border="0" alt="{gsa:i18n ('Tasks', 'Task')}"/>
    </a>
  </div>
  <div class="gb_window_part_content">
    <form action="/omp" method="post" enctype="multipart/form-data">
      <input type="hidden" name="token" value="{/envelope/token}"/>
      <input type="hidden" name="cmd" value="create_report"/>
      <input type="hidden" name="caller" value="{/envelope/current_page}"/>
      <input type="hidden" name="next" value="get_tasks"/>
      <xsl:if test="string-length (/envelope/params/filt_id) = 0">
        <input type="hidden" name="overrides" value="{/envelope/params/overrides}"/>
      </xsl:if>
      <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
      <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
      <table border="0" cellspacing="0" cellpadding="3" width="100%">
        <tr>
         <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
         <td>
           <input type="text" name="name" value="unnamed" size="30"
                  maxlength="80"/>
         </td>
        </tr>
        <tr>
          <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
          <td>
            <input type="text" name="comment" size="30" maxlength="400"/>
          </td>
        </tr>
        <tr>
          <td valign="top"><xsl:value-of select="gsa:i18n ('Report', 'Report')"/></td>
          <td><input type="file" name="xml_file" size="30"/></td>
        </tr>
        <tr>
          <td colspan="2" style="text-align:right;">
            <input type="submit" name="submit" value="{gsa:i18n ('Create Task', 'Task')}"/>
          </td>
        </tr>
      </table>
      <br/>
    </form>
  </div>
</xsl:template>

<!-- LAST_REPORT -->

<xsl:template match="last_report">
  <xsl:apply-templates/>
</xsl:template>

<!-- REPORT -->

<xsl:template match="report" name="report">
  <xsl:param name="container">0</xsl:param>
  <xsl:param name="observed" select="0"/>
  <xsl:param name="apply_overrides" select="../../../../apply_overrides"/>
  <xsl:param name="min_qod" select="../../filters/keywords/keyword[column='min_qod']/value"/>
  <xsl:param name="delta" select="/envelope/params/delta_report_id"/>
  <xsl:param name="task_id" select="/envelope/params/task_id"/>

  <tr class="{gsa:table-row-class(position())}">
    <td>
      <b>
        <a href="/omp?cmd=get_report&amp;report_id={@id}&amp;notes=1&amp;overrides={$apply_overrides}&amp;apply_min_qod={number (string-length ($min_qod) != 0)}&amp;min_qod={$min_qod}&amp;result_hosts_only=1&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Report', @id)}">
          <xsl:value-of select="concat (date:day-abbreviation (timestamp), ' ', date:month-abbreviation (timestamp), ' ', date:day-in-month (timestamp), ' ', format-number(date:hour-in-day(timestamp), '00'), ':', format-number(date:minute-in-hour(timestamp), '00'), ':', format-number(date:second-in-minute(timestamp), '00'), ' ', date:year(timestamp))"/>
        </a>
      </b>
    </td>
    <td>
      <xsl:call-template name="status_bar">
        <xsl:with-param name="status">
          <xsl:choose>
            <xsl:when test="task/target/@id='' and scan_run_status='Running'">
              <xsl:text>Uploading</xsl:text>
            </xsl:when>
            <xsl:when test="task/target/@id=''">
              <xsl:text>Container</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="scan_run_status"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
        <xsl:with-param name="progress">
          <xsl:value-of select="task/progress/text()"/>
        </xsl:with-param>
      </xsl:call-template>
    </td>
    <td style="max-width: 100px; overflow: hidden;">
      <a href="/omp?cmd=get_task&amp;task_id={task/@id}&amp;overrides={../../filters/keywords/keyword[column='apply_overrides']/value}&amp;min_qod={$min_qod}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/task_filt_id}&amp;token={/envelope/token}"
         title="{gsa:view_details_title ('Task', task/@id)}"
         style="margin-left:3px;">
        <xsl:value-of select="task/name"/>
      </a>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="severity/full &lt; 0.0">
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="cvss" select="''"/>
            <xsl:with-param name="extra_text" select="gsa:i18n (gsa:result-cvss-risk-factor (severity/full), 'Severity')"/>
            <xsl:with-param name="title" select="gsa:i18n (gsa:result-cvss-risk-factor (severity/full), 'Severity')"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="cvss" select="severity/full"/>
            <xsl:with-param name="extra_text" select="concat (' (', gsa:i18n (gsa:result-cvss-risk-factor (severity/full), 'Severity'), ')')"/>
            <xsl:with-param name="title" select="gsa:i18n (gsa:result-cvss-risk-factor (severity/full), 'Severity')"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td class="threat_info_table">
      <xsl:value-of select="result_count/hole/full"/>
    </td>
    <td class="threat_info_table">
      <xsl:value-of select="result_count/warning/full"/>
    </td>
    <td class="threat_info_table">
      <xsl:value-of select="result_count/info/full"/>
    </td>
    <td class="threat_info_table">
      <xsl:value-of select="result_count/log/full"/>
    </td>
    <td class="threat_info_table">
      <xsl:value-of select="result_count/false_positive/full"/>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:choose>
            <xsl:when test="$delta = @id">
              <img src="/img/delta_inactive.png" border="0" alt="{gsa:i18n ('Compare', 'Report')}"
                  title="{gsa:i18n ('Report is already selected for delta', 'Report')}"
                  style="margin-left:3px;"/>
            </xsl:when>
            <xsl:when test="string-length (../../filters/keywords/keyword[column='task_id']) = 0">
              <img src="/img/delta_inactive.png" border="0" alt="{gsa:i18n ('Compare', 'Report')}"
                  title="{gsa:i18n ('Filter must be limited to a single Task to allow delta reports', 'Report')}"
                  style="margin-left:3px;"/>
            </xsl:when>
            <xsl:when test="string-length ($delta) &gt; 0">
              <a href="/omp?cmd=get_report&amp;report_id={$delta}&amp;delta_report_id={@id}&amp;notes=1&amp;overrides={$apply_overrides}&amp;result_hosts_only=1&amp;token={/envelope/token}"
                title="{gsa:i18n ('Compare', 'Report')}"
                style="margin-left:3px;">
                <img src="/img/delta_second.png" border="0" alt="{gsa:i18n ('Compare', 'Report')}"/>
              </a>
            </xsl:when>
            <xsl:otherwise>
              <a href="/omp?cmd=get_reports&amp;task_id={$task_id}&amp;delta_report_id={@id}&amp;overrides={$apply_overrides}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;task_filter={str:encode-uri (/envelope/params/task_filter, true ())}&amp;task_filt_id={/envelope/params/task_filt_id}&amp;token={/envelope/token}"
                title="{gsa:i18n ('Compare', 'Report')}"
                style="margin-left:3px;">
                <img src="/img/delta.png" border="0" alt="{gsa:i18n ('Compare', 'Report')}"/>
              </a>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="boolean ($observed)">
              <img src="/img/delete_inactive.png"
                  border="0"
                  alt="{gsa:i18n ('Delete', 'Action Verb')}"
                  title="{gsa:i18n ('Report is observed', 'Report')}"
                  style="margin-left:3px;"/>
            </xsl:when>
            <xsl:when test="scan_run_status='Running' or scan_run_status='Requested' or scan_run_status='Stop Requested' or scan_run_status='Resume Requested'">
              <img src="/img/delete_inactive.png"
                  border="0"
                  alt="{gsa:i18n ('Delete', 'Action Verb')}"
                  title="{gsa:i18n ('Scan is active', 'Report')}"
                  style="margin-left:3px;"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="delete-icon">
                <xsl:with-param name="type">report</xsl:with-param>
                <xsl:with-param name="id" select="@id"/>
                <xsl:with-param name="params">
                  <input type="hidden" name="task_id" value="{$task_id}"/>
                  <input type="hidden" name="overrides" value="{/envelope/params/overrides}"/>
                  <input type="hidden" name="next" value="get_reports"/>
                  <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
                  <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
                  <input type="hidden" name="task_filter" value="{/envelope/params/task_filter}"/>
                  <input type="hidden" name="task_filt_id" value="{/envelope/params/task_filt_id}"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<!-- LAST_REPORT -->

<xsl:template match="last_report">
  <xsl:choose>
    <xsl:when test="report/severity &lt; 0.0">
      <xsl:call-template name="severity-bar">
        <xsl:with-param name="cvss" select="''"/>
        <xsl:with-param name="extra_text" select="gsa:i18n (gsa:result-cvss-risk-factor (report/severity), 'Severity')"/>
        <xsl:with-param name="title" select="gsa:i18n (gsa:result-cvss-risk-factor (report/severity), 'Severity')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="severity-bar">
        <xsl:with-param name="cvss" select="report/severity"/>
        <xsl:with-param name="extra_text" select="concat (' (', gsa:i18n (gsa:result-cvss-risk-factor (report/severity), 'Severity'), ')')"/>
        <xsl:with-param name="title" select="gsa:i18n (gsa:result-cvss-risk-factor (report/severity), 'Severity')"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="html-edit-task-config">
  <xsl:param name="type"/>
  <xsl:param name="param_name"/>
  <tr>
    <td></td>
    <td><xsl:value-of select="gsa:i18n ('Scan Config', 'Scan Config')"/></td>
    <td>
      <input type="hidden" name="cmd" value="save_task"/>
      <xsl:variable name="config_id" select="gsa:param-or ('config_id', commands_response/get_tasks_response/task/config/@id)"/>
      <select name="{$param_name}">
        <xsl:choose>
          <xsl:when test="string-length (commands_response/get_configs_response/config/name) &gt; 0">
            <xsl:for-each select="commands_response/get_configs_response/config[type = $type]">
              <xsl:choose>
                <xsl:when test="@id = $config_id">
                  <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                </xsl:when>
                <xsl:otherwise>
                  <option value="{@id}"><xsl:value-of select="name"/></option>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <option value="0">--</option>
          </xsl:otherwise>
        </xsl:choose>
      </select>
    </td>
  </tr>
</xsl:template>

<xsl:template name="html-edit-task-config-disabled">
  <tr>
    <td></td>
    <td><xsl:value-of select="gsa:i18n ('Scan Config', 'Scan Config')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)</td>
    <td>
      <input type="hidden" name="cmd" value="save_task"/>
      <input type="hidden" name="config_id" value="0"/>
      <input type="hidden" name="osp_config_id" value="0"/>
      <select name="dummy" disabled="0">
        <xsl:choose>
          <xsl:when test="string-length (commands_response/get_tasks_response/task/config/name) &gt; 0">
            <xsl:apply-templates select="commands_response/get_tasks_response/task/config" mode="newtask"/>
          </xsl:when>
          <xsl:otherwise>
            <option value="0">--</option>
          </xsl:otherwise>
        </xsl:choose>
      </select>
    </td>
  </tr>
</xsl:template>

<xsl:template name="html-edit-task-scanner-disabled">
  <tr>
    <td><xsl:value-of select="gsa:i18n ('Scanner', 'Scanner')"/>
      (<xsl:call-template name="scanner-type-name">
        <xsl:with-param name="type" select="commands_response/get_tasks_response/task/scanner/type"/>
      </xsl:call-template>)
    </td>
    <td>
      <input type="hidden" name="cmd" value="save_task"/>
      <input type="hidden" name="scanner_type" value="{commands_response/get_tasks_response/task/scanner/type}"/>
      <input type="hidden" name="scanner_id" value="0"/>
      <input type="hidden" name="osp_scanner_id" value="0"/>
      <xsl:variable name="scanner_id">
        <xsl:choose>
          <xsl:when test="string-length (/envelope/params/scanner_id) &gt; 0">
            <xsl:value-of select="/envelope/params/scanner_id"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="commands_response/get_tasks_response/task/scanner/@id"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <select name="dummy" disabled="0">
        <xsl:choose>
          <xsl:when test="string-length (commands_response/get_tasks_response/task/scanner/name) &gt; 0">
            <xsl:for-each select="commands_response/get_scanners_response/scanner">
              <xsl:if test="@id = $scanner_id">
                <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
              </xsl:if>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <option value="0">--</option>
          </xsl:otherwise>
        </xsl:choose>
      </select>
    </td>
  </tr>
</xsl:template>

<xsl:template name="html-edit-task-target">
  <xsl:choose>
    <xsl:when test="commands_response/get_tasks_response/task/status = 'New' or commands_response/get_tasks_response/task/alterable != 0">
      <tr>
        <td><xsl:value-of select="gsa:i18n ('Scan Targets', 'Task')"/></td>
        <td>
          <xsl:variable name="target_id" select="gsa:param-or ('target_id', commands_response/get_tasks_response/task/target/@id)"/>
          <select name="target_id">
            <xsl:choose>
              <xsl:when test="string-length (commands_response/get_targets_response/target/name) &gt; 0">
                <xsl:for-each select="commands_response/get_targets_response/target">
                  <xsl:choose>
                    <xsl:when test="@id = $target_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <option value="0">--</option>
              </xsl:otherwise>
            </xsl:choose>
          </select>
        </td>
      </tr>
    </xsl:when>
    <xsl:otherwise>
      <tr>
        <td><xsl:value-of select="gsa:i18n ('Scan Targets', 'Task')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)</td>
        <td>
          <input type="hidden" name="target_id" value="0"/>
          <select name="dummy2" disabled="0">
            <xsl:choose>
              <xsl:when test="string-length (commands_response/get_tasks_response/task/target/name) &gt; 0">
                <xsl:apply-templates select="commands_response/get_tasks_response/task/target" mode="newtask"/>
              </xsl:when>
              <xsl:otherwise>
                <option value="0">--</option>
              </xsl:otherwise>
            </xsl:choose>
          </select>
        </td>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="html-edit-task-alert">
  <xsl:if test="gsa:may-op ('get_alerts')">
    <tr>
      <td><xsl:value-of select="gsa:i18n ('Alerts', 'Alert')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
      <td>
        <xsl:variable name="alerts" select="commands_response/get_alerts_response/alert"/>
        <xsl:choose>
          <xsl:when test="count (/envelope/params/_param[substring-before (name, ':') = 'alert_id_optional'][value != '--']) &gt; 0">
            <xsl:for-each select="/envelope/params/_param[substring-before (name, ':') = 'alert_id_optional'][value != '--']/value">
              <select name="alert_id_optional:{position ()}">
                <xsl:variable name="alert_id" select="text ()"/>
                <xsl:choose>
                  <xsl:when test="string-length ($alert_id) &gt; 0">
                    <option value="0">--</option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="0" selected="1">--</option>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:for-each select="$alerts">
                  <xsl:choose>
                    <xsl:when test="@id = $alert_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
              <br/>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="commands_response/get_tasks_response/task/alert">
              <select name="alert_id_optional:{position ()}">
                <xsl:variable name="alert_id" select="@id"/>
                <xsl:choose>
                  <xsl:when test="string-length ($alert_id) &gt; 0">
                    <option value="0">--</option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="0" selected="1">--</option>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:for-each select="$alerts">
                  <xsl:choose>
                    <xsl:when test="@id = $alert_id">
                      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
              <br/>
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>

        <xsl:variable name="count">
          <xsl:variable name="params" select="count (/envelope/params/_param[substring-before (name, ':') = 'alert_id_optional'][value != '--'])"/>
          <xsl:choose>
            <xsl:when test="$params &gt; 0">
              <xsl:value-of select="$params"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="count (commands_response/get_tasks_response/task/alert)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:call-template name="new-task-alert-select">
          <xsl:with-param name="alerts" select="commands_response/get_alerts_response"/>
          <xsl:with-param name="count" select="alerts - $count"/>
          <xsl:with-param name="position" select="$count + 1"/>
        </xsl:call-template>

        <!-- Force the Create Task button to be the default. -->
        <input style="position: absolute; left: -100%"
               type="submit" name="submit" value="{gsa:i18n ('Create Task', 'Task')}"/>
        <input type="submit" name="submit_plus" value="+"/>

        <xsl:choose>
          <xsl:when test="string-length (/envelope/params/alerts)">
            <input type="hidden" name="alerts" value="{/envelope/params/alerts}"/>
          </xsl:when>
          <xsl:otherwise>
            <input type="hidden" name="alerts" value="{$count + 1}"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="html-edit-task-scanner">
  <xsl:param name="title"/>
  <xsl:param name="param_name"/>
  <xsl:param name="type"/>
  <xsl:if test="count(get_scanners_response/scanner[type = 0]) &gt;= 0">
    <tr>
      <td>
        <xsl:choose>
          <xsl:when test="commands_response/get_tasks_response/task/scanner/type = $type">
            <input type="radio" name="scanner_type" value="{$type}" checked="1"/>
          </xsl:when>
          <xsl:otherwise>
            <input type="radio" name="scanner_type" value="{$type}"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td><xsl:value-of select="gsa:i18n ($title, 'Scanner')"/></td>
      <td>
        <select name="{$param_name}">
          <xsl:variable name="scanner_id">
            <xsl:choose>
              <xsl:when test="string-length (/envelope/params/scanner_id) &gt; 0">
                <xsl:value-of select="/envelope/params/scanner_id"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="commands_response/get_tasks_response/task/scanner/@id"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:for-each select="commands_response/get_scanners_response/scanner[type = $type]">
            <xsl:choose>
              <xsl:when test="@id = $scanner_id">
                <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
              </xsl:when>
              <xsl:otherwise>
                <option value="{@id}"><xsl:value-of select="name"/></option>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </select>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="html-edit-task-slave">
  <xsl:if test="gsa:may-op ('get_slaves')">
    <tr>
      <td></td>
      <td><xsl:value-of select="gsa:i18n ('Slave', 'Slave')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
      <td>
        <select name="slave_id">
          <xsl:variable name="slave_id">
            <xsl:choose>
              <xsl:when test="string-length (/envelope/params/slave_id) &gt; 0">
                <xsl:value-of select="/envelope/params/slave_id"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="commands_response/get_tasks_response/task/slave/@id"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:choose>
            <xsl:when test="string-length ($slave_id) &gt; 0">
              <option value="0">--</option>
            </xsl:when>
            <xsl:otherwise>
              <option value="0" selected="1">--</option>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:for-each select="commands_response/get_slaves_response/slave">
            <xsl:choose>
              <xsl:when test="@id = $slave_id">
                <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
              </xsl:when>
              <xsl:otherwise>
                <option value="{@id}"><xsl:value-of select="name"/></option>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </select>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="html-edit-task-schedule">
  <xsl:if test="gsa:may-op ('get_schedules')">
    <tr>
      <td><xsl:value-of select="gsa:i18n ('Schedule', 'Schedule')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
      <td>
        <select name="schedule_id">
          <xsl:variable name="schedule_id">
            <xsl:choose>
              <xsl:when test="string-length (/envelope/params/schedule_id) &gt; 0">
                <xsl:value-of select="/envelope/params/schedule_id"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="commands_response/get_tasks_response/task/schedule/@id"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:choose>
            <xsl:when test="string-length ($schedule_id) &gt; 0">
              <option value="0">--</option>
            </xsl:when>
            <xsl:otherwise>
              <option value="0" selected="1">--</option>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:for-each select="commands_response/get_schedules_response/schedule">
            <xsl:choose>
              <xsl:when test="@id = $schedule_id">
                <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
              </xsl:when>
              <xsl:otherwise>
                <option value="{@id}"><xsl:value-of select="name"/></option>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </select>
        <xsl:choose>
          <xsl:when test="commands_response/get_tasks_response/task/schedule_periods = 1">
            <input name="schedule_periods" type="checkbox" value="1" checked="1"
                   title="{gsa:i18n ('Once', 'Time')}"/>
            <xsl:value-of select="gsa:i18n ('Once', 'Time')"/>
          </xsl:when>
          <xsl:when test="commands_response/get_tasks_response/task/schedule_periods &gt; 1">
            <input name="schedule_periods" type="text"
                   value="{commands_response/get_tasks_response/task/schedule_periods}"
                   style="width:40px" checked="1" title="{gsa:i18n ('Periods', 'Time')}"/>
            <xsl:value-of select="gsa:i18n ('more times', 'Time')"/>
          </xsl:when>
          <xsl:otherwise>
            <input name="schedule_periods" type="checkbox" value="1"
                   title="{gsa:i18n ('Once', 'Time')}"/>
            <xsl:value-of select="gsa:i18n ('Once', 'Time')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="html-edit-task-scan-options">
  <tr>
    <xsl:variable name="in_assets" select="commands_response/get_tasks_response/task/preferences/preference[scanner_name='in_assets']"/>
    <td><xsl:value-of select="gsa:i18n ($in_assets/name, 'Task')"/></td>
    <td>
      <xsl:variable name="param_yes" select="/envelope/params/in_assets"/>
      <xsl:choose>
        <xsl:when test="string-length ($param_yes) &gt; 0">
          <xsl:choose>
            <xsl:when test="$param_yes = '1'">
              <label>
                <input type="radio" name="in_assets" value="1" checked="1"/>
                <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
              </label>
              <label>
                <input type="radio" name="in_assets" value="0"/>
                <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
              </label>
            </xsl:when>
            <xsl:otherwise>
              <label>
                <input type="radio" name="in_assets" value="1"/>
                <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
              </label>
              <label>
                <input type="radio" name="in_assets" value="0" checked="1"/>
                <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
              </label>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="((string-length ($param_yes) &gt; 0) and ($param_yes = '1')) or $in_assets/value='yes'">
          <label>
            <input type="radio" name="in_assets" value="1" checked="1"/>
            <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
          </label>
          <label>
            <input type="radio" name="in_assets" value="0"/>
            <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
          </label>
        </xsl:when>
        <xsl:otherwise>
          <label>
            <input type="radio" name="in_assets" value="1"/>
            <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
          </label>
          <label>
            <input type="radio" name="in_assets" value="0" checked="1"/>
            <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
          </label>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
  <xsl:if test="commands_response/get_tasks_response/task/status = 'New'">
    <tr>
      <td><xsl:value-of select="gsa:i18n ('Alterable Task', 'Task')"/></td>
      <td>
        <xsl:variable name="yes" select="commands_response/get_tasks_response/task/alterable"/>
        <label>
          <xsl:choose>
            <xsl:when test="string-length ($yes) = 0 or $yes = 0">
              <input type="radio" name="alterable" value="1"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="radio" name="alterable" value="1" checked="1"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
        </label>
        <label>
          <xsl:choose>
            <xsl:when test="string-length ($yes) = 0 or $yes = 0">
              <input type="radio" name="alterable" value="0" checked="1"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="radio" name="alterable" value="0"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
        </label>
      </td>
    </tr>
  </xsl:if>
  <tr>
    <td><xsl:value-of select="gsa:i18n ('Auto Delete Reports', 'Task')"/></td>
    <td colspan="2">
      <xsl:variable name="auto_delete">
        <xsl:choose>
          <xsl:when test="string-length (/envelope/params/auto_delete) &gt; 0">
            <xsl:value-of select="/envelope/params/auto_delete"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="commands_response/get_tasks_response/task/preferences/preference[scanner_name='auto_delete']/value"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="auto_delete_data">
        <xsl:choose>
          <xsl:when test="string-length (/envelope/params/auto_delete_data) &gt; 0">
            <xsl:value-of select="/envelope/params/auto_delete_data"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="commands_response/get_tasks_response/task/preferences/preference[scanner_name='auto_delete_data']/value"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <div>
        <label>
          <xsl:choose>
            <xsl:when test="$auto_delete = 'keep'">
              <input type="radio" name="auto_delete" value="no"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="radio" name="auto_delete" value="no" checked="1"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="gsa:i18n ('Do not automatically delete reports', 'Task')"/>
        </label>
      </div>
      <div>
        <label>
          <xsl:choose>
            <xsl:when test="$auto_delete = 'keep'">
              <input type="radio" name="auto_delete" value="keep" checked="1"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="radio" name="auto_delete" value="keep"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="gsa:i18n ('Automatically delete oldest reports but always keep newest ', 'Task')"/>
          <div style="display: inline;">
            <xsl:variable name="data">
              <xsl:choose>
                <xsl:when test="$auto_delete_data = 0">5</xsl:when>
                <xsl:otherwise><xsl:value-of select="$auto_delete_data"/></xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <input style="display: inline;"
                   type="text" name="auto_delete_data" value="{$data}"
                   size="4" maxlength="5"/>
          </div>
          <xsl:value-of select="gsa:i18n (' reports', 'Task')"/>
        </label>
      </div>
    </td>
  </tr>
</xsl:template>

<xsl:template name="html-edit-task-openvas-options">
  <tr>
    <td></td>
    <td><xsl:value-of select="gsa:i18n ('Network Source Interface', 'Task')"/></td>
    <td>
      <input type="text" name="source_iface" value="{commands_response/get_tasks_response/task/preferences/preference[scanner_name='source_iface']/value}"/>
    </td>
  </tr>
  <tr>
    <td></td>
    <td><xsl:value-of select="gsa:i18n ('Order for target hosts', 'Task')"/></td>
    <td>
      <xsl:variable name="hosts_ordering"
                    select="commands_response/get_tasks_response/task/hosts_ordering"/>
      <select name="hosts_ordering">
        <xsl:call-template name="opt">
          <xsl:with-param name="content" select="gsa:i18n ('Sequential', 'Task|Hosts Ordering')"/>
          <xsl:with-param name="value" select="'sequential'"/>
          <xsl:with-param name="select-value" select="$hosts_ordering"/>
        </xsl:call-template>
        <xsl:call-template name="opt">
          <xsl:with-param name="content" select="gsa:i18n ('Random', 'Task|Hosts Ordering')"/>
          <xsl:with-param name="value" select="'random'"/>
          <xsl:with-param name="select-value" select="$hosts_ordering"/>
        </xsl:call-template>
        <xsl:call-template name="opt">
          <xsl:with-param name="content" select="gsa:i18n ('Reverse', 'Task|Hosts Ordering')"/>
          <xsl:with-param name="value" select="'reverse'"/>
          <xsl:with-param name="select-value" select="$hosts_ordering"/>
        </xsl:call-template>
      </select>
    </td>
  </tr>
  <xsl:choose>
    <xsl:when test="commands_response/get_tasks_response/task/target/@id = ''">
      <input type="hidden" name="target_id" value="--"/>
    </xsl:when>
    <xsl:otherwise>
      <tr>
        <td></td>
        <td>
          <xsl:value-of select="gsa:i18n (commands_response/get_tasks_response/task/preferences/preference[scanner_name='max_checks']/name, 'Task')"/>
        </td>
        <td>
          <input type="text" name="max_checks"
                 value="{gsa:param-or ('max_checks', commands_response/get_tasks_response/task/preferences/preference[scanner_name='max_checks']/value)}"
                 size="10" maxlength="10"/>
        </td>
      </tr>
      <tr>
        <td></td>
        <td>
          <xsl:value-of select="gsa:i18n (commands_response/get_tasks_response/task/preferences/preference[scanner_name='max_hosts']/name, 'Task')"/>
        </td>
        <td>
          <input type="text" name="max_hosts"
                 value="{gsa:param-or ('max_hosts', commands_response/get_tasks_response/task/preferences/preference[scanner_name='max_hosts']/value)}"
                 size="10" maxlength="10"/>
        </td>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="html-edit-task-name">
  <tr>
   <td valign="top" width="150"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
   <td width="340">
     <input type="text" name="name"
            value="{gsa:param-or ('name', commands_response/get_tasks_response/task/name)}"
            size="30" maxlength="80"/>
   </td>
  </tr>
</xsl:template>

<xsl:template name="html-edit-task-comment">
  <tr>
    <td valign="top"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
    <td>
      <input type="text" name="comment" size="30" maxlength="400"
             value="{gsa:param-or ('comment', commands_response/get_tasks_response/task/comment)}"/>
    </td>
  </tr>
</xsl:template>

<xsl:template name="html-edit-task-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Task', 'Task')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Task'"/>
        <xsl:with-param name="type" select="'task'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_tasks_response/task/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="task_id"
               value="{commands_response/get_tasks_response/task/@id}"/>
        <input type="hidden"
               name="refresh_interval"
               value="{refresh_interval}"/>
        <input type="hidden" name="next" value="{next}"/>
        <input type="hidden" name="sort_field" value="{sort_field}"/>
        <input type="hidden" name="sort_order" value="{sort_order}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <xsl:if test="not (gsa:may-op ('get_alerts'))">
          <input type="hidden" name="alerts" value="1"/>
          <input type="hidden" name="alert_id_optional:1" value="--"/>
        </xsl:if>
        <xsl:if test="not (gsa:may-op ('get_schedules'))">
          <input type="hidden" name="schedule_id" value="0"/>
        </xsl:if>
        <xsl:if test="not (gsa:may-op ('get_slaves'))">
          <input type="hidden" name="slave_id" value="0"/>
        </xsl:if>
        <xsl:if test="not (gsa:may-op ('get_groups'))">
          <input type="hidden" name="groups" value="1"/>
          <input type="hidden" name="group_id_optional:1" value="--"/>
        </xsl:if>
        <xsl:variable name="new_task">
          <xsl:choose>
            <xsl:when test="commands_response/get_tasks_response/task/status = 'New' or commands_response/get_tasks_response/task/alterable != 0">1</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <xsl:call-template name="html-edit-task-name"/>
          <xsl:call-template name="html-edit-task-comment"/>
          <xsl:choose>
            <xsl:when test="commands_response/get_tasks_response/task/target/@id = ''">
              <input type="hidden" name="target_id" value="--"/>
              <input type="hidden" name="cmd" value="save_container_task"/>
              <xsl:call-template name="html-edit-task-scan-options"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="html-edit-task-target"/>
              <xsl:call-template name="html-edit-task-alert"/>
              <xsl:call-template name="html-edit-task-schedule"/>
              <xsl:call-template name="html-edit-task-scan-options"/>
              <xsl:if test="$new_task = 0">
                <input type="hidden" name="scanner_type" value="1"/>
                <xsl:call-template name="html-edit-task-scanner-disabled"/>
                <xsl:call-template name="html-edit-task-config-disabled"/>
                <xsl:if test="commands_response/get_tasks_response/task/scanner/type = 2">
                  <xsl:call-template name="html-edit-task-slave"/>
                  <xsl:call-template name="html-edit-task-openvas-options"/>
                </xsl:if>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
        </table>
        <xsl:if test="$new_task != 0">
          <table>
            <tr>
              <td>
                <h3>
                  <xsl:value-of select="gsa:i18n ('Scanner', 'Scanner')"/>
                </h3>
              </td>
            </tr>
            <xsl:call-template name="html-edit-task-scanner">
              <xsl:with-param name="title">
                <xsl:call-template name="scanner-type-name">
                  <xsl:with-param name="type" select="2"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="type">2</xsl:with-param>
              <xsl:with-param name="param_name">scanner_id</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="html-edit-task-config">
              <xsl:with-param name="param_name">config_id</xsl:with-param>
              <xsl:with-param name="type">0</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="html-edit-task-slave"/>
            <xsl:call-template name="html-edit-task-openvas-options"/>
            <xsl:call-template name="html-edit-task-scanner">
              <xsl:with-param name="title">
                <xsl:call-template name="scanner-type-name">
                  <xsl:with-param name="type" select="1"/>
                </xsl:call-template>
              </xsl:with-param>
              <xsl:with-param name="type">1</xsl:with-param>
              <xsl:with-param name="param_name">osp_scanner_id</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="html-edit-task-config">
              <xsl:with-param name="param_name">osp_config_id</xsl:with-param>
              <xsl:with-param name="type">1</xsl:with-param>
            </xsl:call-template>
          </table>
        </xsl:if>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Task', 'Task')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
  <xsl:if test="commands_response/get_tasks_response/task/target/@id = '' and gsa:may-op ('create_report')">
    <br/>
    <div class="gb_window">
      <div class="gb_window_part_left"></div>
      <div class="gb_window_part_right"></div>
      <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Import Report', 'Task')"/>
        <a href="/help/task_details.html?token={/envelope/token}#import_report" title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('Import Report', 'Task')}">
          <img src="/img/help.png"/>
        </a>
      </div>
      <div class="gb_window_part_content">
        <form action="/omp" method="post" enctype="multipart/form-data">
          <div style="float: right">
            <input type="submit" name="submit" value="{gsa:i18n ('Add Report', 'Task')}"/>
          </div>
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="create_report"/>
          <input type="hidden" name="caller" value="{/envelope/current_page}"/>
          <input type="hidden" name="next" value="{next}"/>
          <input type="hidden" name="task_id" value="{task/@id}"/>
          <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
          <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
          <input type="file" name="xml_file" size="30"/>
        </form>
      </div>
    </div>
  </xsl:if>
</xsl:template>

<xsl:template match="edit_task">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_task_response"/>
  <xsl:call-template name="html-edit-task-form"/>
</xsl:template>

<xsl:template match="modify_task_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Task</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- TASK -->

<xsl:template match="task">
  <xsl:choose>
    <xsl:when test="report">
      <xsl:variable name="class">
        <xsl:choose>
          <xsl:when test="position() mod 2 = 0">even</xsl:when>
          <xsl:otherwise>odd</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:apply-templates select="report"/>
    </xsl:when>
    <xsl:otherwise>

      <tr class="{gsa:table-row-class(position())}">
        <td>
          <div class="float_right">
            <xsl:choose>
              <xsl:when test="alterable = 0">
              </xsl:when>
              <xsl:otherwise>
                <img src="/img/alterable.png"
                     style="margin-left:3px;"
                     border="0"
                     alt="{gsa:i18n ('Task is alterable', 'Task')}"
                     title="{gsa:i18n ('Task is alterable', 'Task')}"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
              <xsl:when test="string-length(slave/@id) &gt; 0">
                <img src="/img/sensor.png"
                     style="margin-left:3px;"
                     border="0"
                     alt="{gsa-i18n:strformat (gsa:i18n ('Task is configured to run on slave %1', 'Task'), slave/name)}"
                     title="{gsa-i18n:strformat (gsa:i18n ('Task is configured to run on slave %1', 'Task'), slave/name)}"/>
              </xsl:when>
              <xsl:otherwise>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
              <xsl:when test="string-length (observers) &gt; 0 or count (observers/group) &gt; 0">
                <xsl:variable name="observer_groups">
                  <xsl:choose>
                    <xsl:when test="count (observers/group) &gt; 0">
                      <xsl:value-of select="concat ('&#10;', gsa:i18n ('Task made visible for Groups:', 'Task'),' ', gsa:join (observers/group))"/>
                    </xsl:when>
                    <xsl:otherwise></xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <xsl:variable name="observer_roles">
                  <xsl:choose>
                    <xsl:when test="count (observers/role) &gt; 0">
                      <xsl:value-of select="concat ('&#10;', gsa:i18n ('Task made visible for Roles:', 'Task'),' ', gsa:join (observers/role))"/>
                    </xsl:when>
                    <xsl:otherwise></xsl:otherwise>
                  </xsl:choose>
                </xsl:variable>
                <img src="/img/provide_view.png"
                     style="margin-left:3px;"
                     border="0"
                     alt="{gsa:i18n ('Task made visible for:', 'Task')} {observers/text()}{$observer_groups}{$observer_roles}"
                     title="{gsa:i18n ('Task made visible for:', 'Task')} {observers/text()}{$observer_groups}{$observer_roles}"/>
              </xsl:when>
              <xsl:otherwise>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
              <xsl:when test="owner/name=/envelope/login/text()">
              </xsl:when>
              <xsl:otherwise>
                <img src="/img/view_other.png"
                     style="margin-left:3px;"
                     border="0"
                     alt="{gsa-i18n:strformat (gsa:i18n ('Observing task owned by %1', 'Task'), owner/name)}"
                     title="{gsa-i18n:strformat (gsa:i18n ('Observing task owned by %1', 'Task'), owner/name)}"/>
              </xsl:otherwise>
            </xsl:choose>
          </div>
          <b>
            <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;overrides={../filters/keywords/keyword[column='apply_overrides']/value}&amp;min_qod={../filters/keywords/keyword[column='min_qod']/value}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;filt_id={../filters/@id}{gsa:token ()}"
               title="{gsa:view_details_title ('Task', name)}">
              <xsl:value-of select="name"/>
            </a>
          </b>
          <xsl:choose>
            <xsl:when test="comment != ''">
              <br/>(<xsl:value-of select="comment"/>)
            </xsl:when>
            <xsl:otherwise></xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <xsl:variable name="current_or_last_report_id">
            <xsl:choose>
              <xsl:when test="current_report/report/@id">
                <xsl:value-of select="current_report/report/@id"/>
              </xsl:when>
              <xsl:when test="last_report/report/@id">
                <xsl:value-of select="last_report/report/@id"/>
              </xsl:when>
              <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:choose>
            <xsl:when test="$current_or_last_report_id != ''">
              <a href="/omp?cmd=get_report&amp;report_id={$current_or_last_report_id}&amp;notes=1&amp;overrides={../apply_overrides}&amp;apply_min_qod={number (string-length (../filters/keywords/keyword[column='min_qod']/value) != 0)}&amp;min_qod={../filters/keywords/keyword[column='min_qod']/value}&amp;result_hosts_only=1&amp;token={/envelope/token}" title="{gsa-i18n:strformat (gsa:i18n ('View last report for Task %1', 'Task'), name)}">
                <xsl:call-template name="status_bar">
                  <xsl:with-param name="status">
                    <xsl:choose>
                      <xsl:when test="target/@id='' and status='Running'">
                        <xsl:text>Uploading</xsl:text>
                      </xsl:when>
                      <xsl:when test="target/@id=''">
                        <xsl:text>Container</xsl:text>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="status"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:with-param>
                  <xsl:with-param name="progress">
                    <xsl:value-of select="progress/text()"/>
                  </xsl:with-param>
                  <xsl:with-param name="title_suffix">
                    <xsl:text> - </xsl:text><xsl:value-of select="gsa:i18n ('Go to the current report', 'Task')"/>
                  </xsl:with-param>
                </xsl:call-template>
              </a>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="status_bar">
                <xsl:with-param name="status">
                  <xsl:choose>
                    <xsl:when test="target/@id='' and status='Running'">
                      <xsl:text>Uploading</xsl:text>
                    </xsl:when>
                    <xsl:when test="target/@id=''">
                      <xsl:text>Container</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="status"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:with-param>
                <xsl:with-param name="progress">
                  <xsl:value-of select="progress/text()"/>
                </xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="report_count &gt; 0">
              <a href="/omp?cmd=get_reports&amp;replace_task_id=1&amp;filt_id=-2&amp;filter=task_id={@id} and status=Done apply_overrides={../apply_overrides} min_qod={../filters/keywords/keyword[column='min_qod']/value} sort-reverse=name&amp;task_filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;task_filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
                title="{gsa-i18n:strformat (gsa:i18n ('View list of all finished reports for Task %1', 'Task'), name)}">
                <xsl:value-of select="report_count/finished"/>
              </a>
              (<a href="/omp?cmd=get_reports&amp;replace_task_id=1&amp;filt_id=-2&amp;filter=task_id={@id} apply_overrides={../apply_overrides} min_qod={../filters/keywords/keyword[column='min_qod']/value} sort-reverse=name&amp;task_filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;task_filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
                title="{gsa-i18n:strformat (gsa:i18n ('View list of all reports for Task %1, including unfinished ones', 'Task'), name)}">
                <xsl:value-of select="report_count/text()"/>
               </a>)
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <a href="/omp?cmd=get_report&amp;report_id={last_report/report/@id}&amp;notes=1&amp;overrides={../apply_overrides}&amp;apply_min_qod={number (string-length (../filters/keywords/keyword[column='min_qod']/value) != 0)}&amp;min_qod={../filters/keywords/keyword[column='min_qod']/value}&amp;result_hosts_only=1&amp;token={/envelope/token}" title="{gsa-i18n:strformat (gsa:i18n ('View last report for Task %1', 'Task'), name)}">
            <xsl:call-template name="short_timestamp_last"/>
          </a>
        </td>
        <td style="text-align:center;">
          <xsl:choose>
            <xsl:when test="target/@id=''">
            </xsl:when>
            <xsl:when test="last_report">
              <xsl:apply-templates select="last_report"/>
            </xsl:when>
          </xsl:choose>
        </td>
        <td style="text-align:center;">
          <xsl:choose>
            <xsl:when test="target/@id=''">
            </xsl:when>
            <xsl:when test="alterable = 0">
              <!-- Trend -->
              <xsl:call-template name="trend_meter"/>
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <xsl:choose>
          <xsl:when test="/envelope/params/bulk_select = 1">
            <td style="text-align:center">
              <label style="width:100%">
                <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
              </label>
            </td>
          </xsl:when>
          <xsl:otherwise>
            <td>
              <xsl:call-template name="task-icons"/>
              <xsl:call-template name="list-window-line-icons">
                <xsl:with-param name="cap-type" select="'Task'"/>
                <xsl:with-param name="type" select="'task'"/>
                <xsl:with-param name="id" select="@id"/>
              </xsl:call-template>
            </td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="task" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Task'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="status_bar">
        <xsl:with-param name="status">
          <xsl:choose>
            <xsl:when test="target/@id=''">
              <xsl:text>Container</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="status"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:with-param>
        <xsl:with-param name="progress">
          <xsl:value-of select="progress/text()"/>
        </xsl:with-param>
      </xsl:call-template>
    </td>
    <td style="text-align:right;font-size:10px;">
      <xsl:choose>
        <xsl:when test="report_count &gt; 0">
          <xsl:value-of select="report_count/finished"/>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td style="font-size:10px;">
      <xsl:choose>
        <xsl:when test="last_report/report/@id = first_report/report/@id">
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="short_timestamp_first"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td style="font-size:10px;">
      <xsl:call-template name="short_timestamp_last"/>
    </td>
    <td style="text-align:center;">
      <xsl:choose>
        <xsl:when test="last_report">
          <xsl:apply-templates select="last_report"/>
        </xsl:when>
      </xsl:choose>
    </td>
    <td style="text-align:center;">
      <!-- Trend -->
      <xsl:call-template name="trend_meter"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="not (gsa:may-op ('restore'))"/>
        <xsl:when test="(target/trash = '0') and (config/trash = '0') and (schedule/trash = '0') and (slave/trash = '0') and (gsa:alert-in-trash () = 0)">
          <xsl:call-template name="restore-icon">
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="resources_list" select="target[trash!='0'] | config[trash!='0'] | schedule[trash!='0'] | slave[trash!='0'] | (alert[trash!='0'])[0]"/>
          <xsl:variable name="resources_string">
            <xsl:for-each select="$resources_list">
              <xsl:value-of select="gsa:i18n (gsa:type-name (name (.)), gsa:type-name (name (.)))"/>
              <xsl:if test="position() &lt; last()-1">, </xsl:if>
              <xsl:if test="position() = last()-1">
                <xsl:text> </xsl:text><xsl:value-of select="gsa:i18n ('and', 'List Conjunction')"/><xsl:text> </xsl:text>
              </xsl:if>
            </xsl:for-each>
          </xsl:variable>
          <img src="/img/restore_inactive.png" border="0" alt="{gsa:i18n ('Restore', 'Action Verb')}"
               title="{$resources_string}{gsa:i18n (' must be restored first.', 'Action Message')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:call-template name="trash-delete-icon">
        <xsl:with-param name="type">task</xsl:with-param>
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
    </td>
  </tr>
</xsl:template>

<!-- GET_TASKS_RESPONSE -->

<xsl:template match="get_tasks_response">
  <xsl:choose>
    <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
      <xsl:call-template name="command_result_dialog">
        <xsl:with-param name="operation">Get Tasks</xsl:with-param>
        <xsl:with-param name="status">
          <xsl:value-of select="@status"/>
        </xsl:with-param>
        <xsl:with-param name="msg">
          <xsl:value-of select="@status_text"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="html-tasks-table"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- GET_TASK -->

<xsl:template match="get_task">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_task_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="delete_task_response"/>
  <xsl:apply-templates select="create_report_response"/>
  <xsl:apply-templates select="create_task_response"/>
  <xsl:apply-templates select="start_task_response"/>
  <xsl:apply-templates select="stop_task_response"/>
  <xsl:apply-templates select="modify_task_response"/>
  <xsl:apply-templates select="resume_task_response"/>
  <xsl:apply-templates select="commands_response/get_tasks_response/task"
                       mode="details"/>
</xsl:template>

<!-- GET_TASKS -->

<xsl:template match="get_tasks">
  <xsl:apply-templates select="run_wizard_response"/>
  <xsl:apply-templates select="delete_task_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_report_response"/>
  <xsl:apply-templates select="create_task_response"/>
  <xsl:apply-templates select="start_task_response"/>
  <xsl:apply-templates select="stop_task_response"/>
  <xsl:apply-templates select="modify_task_response"/>
  <xsl:apply-templates select="resume_task_response"/>
  <xsl:apply-templates select="get_tasks_response"/>
</xsl:template>

<xsl:template name="html-tasks-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'task'"/>
    <xsl:with-param name="cap-type" select="'Task'"/>
    <xsl:with-param name="resources-summary" select="tasks"/>
    <xsl:with-param name="resources" select="task"/>
    <xsl:with-param name="count" select="count (task)"/>
    <xsl:with-param name="filtered-count" select="task_count/filtered"/>
    <xsl:with-param name="full-count" select="task_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Status', 'Task')"/></name>
        <field>status</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Reports', 'Report')"/></name>
        <column>
          <name><xsl:value-of select="gsa:i18n('Total', 'Task|Reports')"/></name>
          <field>total</field>
          <sort-reverse/>
        </column>
        <column>
          <name><xsl:value-of select="gsa:i18n('Last', 'Task|Report')"/></name>
          <field>last</field>
          <sort-reverse/>
        </column>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
        <html>
          <before>
            <xsl:choose>
              <xsl:when test="/envelope/params/bulk_select = 1">
                <div style="float: right; display: inline">
                  <xsl:choose>
                    <xsl:when test="filters/keywords/keyword[column='apply_overrides']/value = 0">
                      <img src="/img/overrides_disabled.png"
                          alt="{gsa:i18n ('No Overrides', 'Override Controls')}"
                          title="{gsa:i18n ('No Overrides', 'Override Controls')}"
                          style="margin-left:3px;margin-right:3px;"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <img src="/img/overrides_enabled.png"
                          alt="{gsa:i18n ('Overrides are Applied', 'Override Controls')}"
                          title="{gsa:i18n ('Overrides are Applied', 'Override Controls')}"
                          style="margin-left:3px;margin-right:3px;"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </div>
              </xsl:when>
              <xsl:otherwise>
                <div style="float: right; display: inline">
                  <form method="get" action="" enctype="multipart/form-data">
                    <input type="hidden" name="token" value="{/envelope/token}"/>
                    <input type="hidden" name="cmd" value="get_tasks"/>
                    <input type="hidden" name="filter" value="{filters/term}"/>
                    <input type="hidden"
                          name="refresh_interval"
                          value="{/envelope/autorefresh/@interval}"/>
                    <xsl:choose>
                      <xsl:when test="filters/keywords/keyword[column='apply_overrides']/value = 0">
                        <input type="hidden" name="overrides" value="1"/>
                        <input type="image"
                              name="No Overrides"
                              src="/img/overrides_disabled.png"
                              alt="{gsa:i18n ('No Overrides', 'Override Controls')}"
                              value="No Overrides"
                              title="{gsa:i18n ('No Overrides', 'Override Controls')}"
                              style="margin-left:3px;margin-right:3px;"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="hidden" name="overrides" value="0"/>
                        <input type="image"
                              name="Overrides are Applied"
                              src="/img/overrides_enabled.png"
                              alt="{gsa:i18n ('Overrides are Applied', 'Override Controls')}"
                              value="Overrides are Applied"
                              title="{gsa:i18n ('Overrides are Applied', 'Override Controls')}"
                              style="margin-left:3px;margin-right:3px;"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </form>
                </div>
              </xsl:otherwise>
            </xsl:choose>
          </before>
        </html>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Trend', 'Severity')"/></name>
        <field>trend</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="6"/>
    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-scan-management-top-visualization">
        <xsl:with-param name="type" select="'task'"/>
        <xsl:with-param name="auto_load_left_default" select="'left-by-class'"/>
        <xsl:with-param name="auto_load_right_default" select="'right-by-task-status'"/>
      </xsl:call-template>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>


<!-- BEGIN LSC_CREDENTIALS MANAGEMENT -->

<xsl:template match="new_lsc_credential">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_lsc_credential_response"/>
  <xsl:apply-templates select="commands_response/delete_lsc_credential_response"/>
  <xsl:call-template name="html-create-lsc-credential-form"/>
</xsl:template>

<xsl:template name="html-create-lsc-credential-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('New Credential', 'Credential')"/>
      <a href="/help/new_lsc_credential.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Credential', 'Credential'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_lsc_credentials&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Credentials', 'Credential')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Credentials', 'Credential')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_lsc_credential"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_lsc_credential"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Login', 'Auth Data')"/></td>
            <td>
              <input type="text" name="credential_login" value="" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" value="" size="30"
                     maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td></td>
            <td>
              <table>
                <tr>
                  <td colspan="3">
                    <label>
                      <input type="radio" name="base" value="gen"/>
                      <xsl:value-of select="gsa:i18n ('Autogenerate credential', 'Credential')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td colspan="2">
                    <label>
                      <input type="radio" name="base" value="pass" checked="1"/>
                      <xsl:value-of select="gsa:i18n ('Password', 'Auth Data')"/>
                    </label>
                  </td>
                  <td>
                    <input type="password" autocomplete="off"
                           name="lsc_password" value="" size="30"
                           maxlength="40"/>
                  </td>
                </tr>
                <tr>
                  <td colspan="3">
                    <label>
                      <input type="radio" name="base" value="key"/>
                      <xsl:value-of select="gsa:i18n ('Key pair', 'Auth Data')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td>
                    <xsl:value-of select="gsa:i18n ('Private key', 'Auth Data')"/>
                  </td>
                  <td>
                    <input type="file" name="private_key" size="30"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td>
                    <xsl:value-of select="gsa:i18n ('Passphrase', 'Auth Data')"/>
                  </td>
                  <td>
                    <input type="password" autocomplete="off" name="passphrase"
                           value="" size="30" maxlength="40"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Credential', 'Credential')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template name="html-lsc-credentials-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'lsc_credential'"/>
    <xsl:with-param name="cap-type" select="'Credential'"/>
    <xsl:with-param name="resources-summary" select="lsc_credentials"/>
    <xsl:with-param name="resources" select="lsc_credential"/>
    <xsl:with-param name="count" select="count (lsc_credential)"/>
    <xsl:with-param name="filtered-count" select="lsc_credential_count/filtered"/>
    <xsl:with-param name="full-count" select="lsc_credential_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Login', 'Auth Data')"/></name>
        <field>login</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="8"/>
  </xsl:call-template>
</xsl:template>

<!--     CREATE_LSC_CREDENTIAL_RESPONSE -->

<xsl:template match="create_lsc_credential_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Credential</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     DELETE_LSC_CREDENTIAL_RESPONSE -->

<xsl:template match="delete_lsc_credential_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Credential
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     EDITING LSC CREDENTIALS -->

<xsl:template name="html-edit-lsc-credential-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Credential', 'Credential')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Credential'"/>
        <xsl:with-param name="type" select="'lsc_credential'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_lsc_credentials_response/lsc_credential/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_lsc_credential"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="lsc_credential_id"
               value="{commands_response/get_lsc_credentials_response/lsc_credential/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text"
                     name="name"
                     value="{commands_response/get_lsc_credentials_response/lsc_credential/name}"
                     size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/></td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{commands_response/get_lsc_credentials_response/lsc_credential/comment}"/>
            </td>
          </tr>
          <tr>
            <td valign="top"><xsl:value-of select="gsa:i18n ('Login', 'Auth Data')"/></td>
            <td>
              <xsl:choose>
                <xsl:when test="commands_response/get_lsc_credentials_response/lsc_credential/type = 'gen'">
                  <input type="text" name="credential_login_off" size="30" maxlength="400"
                         disabled="1"
                         value="{commands_response/get_lsc_credentials_response/lsc_credential/login}"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="text" name="credential_login" size="30" maxlength="400"
                         value="{commands_response/get_lsc_credentials_response/lsc_credential/login}"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top"><xsl:value-of select="gsa:i18n ('Password', 'Auth Data')"/></td>
            <td>
              <xsl:choose>
                <xsl:when test="commands_response/get_lsc_credentials_response/lsc_credential/type = 'gen'">
                  <label>
                    <input type="checkbox" name="enable_off" value="1"
                           disabled="1"/>
                    <xsl:value-of select="gsa:i18n ('Replace existing value with', 'Auth Data|Password')"/>:
                    <br/>
                  </label>
                  <input type="password" name="password" size="30" maxlength="400"
                         disabled="1" value=""/>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="checkbox" name="enable" value="1"/>
                    <xsl:value-of select="gsa:i18n ('Replace existing value with', 'Auth Data|Password')"/>:
                    <br/>
                  </label>
                  <input type="password" autocomplete="off" name="password"
                         size="30" maxlength="400" value=""/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Credential', 'Credential')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_lsc_credential">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_lsc_credential_response"/>
  <xsl:call-template name="html-edit-lsc-credential-form"/>
</xsl:template>

<xsl:template match="modify_lsc_credential_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Credential</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     LSC_CREDENTIAL -->

<xsl:template name="lsc-credential-download-icons">
  <a href="/omp?cmd=download_lsc_credential&amp;lsc_credential_id={@id}&amp;package_format=rpm&amp;token={/envelope/token}"
     title="{gsa:i18n ('Download RPM package', 'Credential')}" style="margin-left:3px;">
    <img src="/img/rpm.png" border="0" alt="{gsa:i18n ('Download RPM', 'Credential')}"/>
  </a>
  <a href="/omp?cmd=download_lsc_credential&amp;lsc_credential_id={@id}&amp;package_format=deb&amp;token={/envelope/token}"
     title="{gsa:i18n ('Download Debian package', 'Credential')}" style="margin-left:3px;">
    <img src="/img/deb.png" border="0" alt="{gsa:i18n ('Download Deb', 'Credential')}"/>
  </a>
  <a href="/omp?cmd=download_lsc_credential&amp;lsc_credential_id={@id}&amp;package_format=exe&amp;token={/envelope/token}"
     title="{gsa:i18n ('Download Exe package', 'Credential')}" style="margin-left:3px;">
    <img src="/img/exe.png" border="0" alt="{gsa:i18n ('Download Exe', 'Credential')}"/>
  </a>
  <a href="/omp?cmd=download_lsc_credential&amp;lsc_credential_id={@id}&amp;package_format=key&amp;token={/envelope/token}"
     title="{gsa:i18n ('Download Public Key', 'Credential')}" style="margin-left:3px;">
    <img src="/img/key.png" border="0" alt="{gsa:i18n ('Download Public Key', 'Credential')}"/>
  </a>
</xsl:template>

<xsl:template match="lsc_credential">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Credential'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Credential', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="login"/>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Credential'"/>
            <xsl:with-param name="type" select="'lsc_credential'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
          <xsl:if test="type='gen'">
            <xsl:call-template name="lsc-credential-download-icons"/>
          </xsl:if>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="lsc_credential" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <b><xsl:value-of select="name"/></b>
    </td>
    <td>
      <xsl:value-of select="login"/>
    </td>
    <td>
      <xsl:value-of select="comment"/>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type">lsc_credential</xsl:with-param>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png" border="0" alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Credential is still in use', 'Credential')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="lsc_credential" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Credential Details', 'Credential')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Credential'"/>
        <xsl:with-param name="type" select="'lsc_credential'"/>
      </xsl:call-template>
      <xsl:if test="type='gen'">
        <xsl:call-template name="lsc-credential-download-icons"/>
      </xsl:if>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Login', 'Auth Data')"/>:</td>
          <td><xsl:value-of select="login"/></td>
        </tr>
      </table>

      <xsl:choose>
        <xsl:when test="count(targets/target) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Targets using this Credential', 'Credential')"/>: <xsl:value-of select="gsa:i18n ('None', 'Targets')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Targets using this Credential', 'Credential')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="targets/target">
              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_target&amp;target_id={@id}&amp;token={/envelope/token}"
                         title="{gsa:i18n ('Target Details', 'Target')}">
                        <img src="/img/details.png"
                             border="0"
                             alt="{gsa:i18n ('Details', 'Generic Resource')}"
                             style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'lsc_credential'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'lsc_credential'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     GET_LSC_CREDENTIAL -->

<xsl:template match="get_lsc_credential">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_lsc_credential_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="commands_response/delete_lsc_credential_response"/>
  <xsl:apply-templates select="commands_response/modify_lsc_credential_response"/>
  <xsl:apply-templates select="get_lsc_credentials_response/lsc_credential"
                       mode="details"/>
</xsl:template>

<!--     GET_LSC_CREDENTIALS_RESPONSE -->

<xsl:template match="get_lsc_credentials_response">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_lsc_credential_response"/>
  <xsl:call-template name="html-lsc-credentials-table"/>
</xsl:template>

<xsl:template match="lsc_credential" mode="select">
  <xsl:param name="select_id" select="''"/>
  <xsl:choose>
    <xsl:when test="@id = $select_id">
      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
    </xsl:when>
    <xsl:otherwise>
      <option value="{@id}"><xsl:value-of select="name"/></option>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="lsc_credentials_response" mode="select">
  <xsl:apply-templates select="lsc_credential" mode="select"/>
</xsl:template>


<!-- BEGIN AGENTS MANAGEMENT -->

<xsl:template name="html-create-agent-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('New Agent', 'Agent')"/>
      <a href="/help/new_agent.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Agent', 'Agent'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_agents&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Agents', 'Agent')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Agents', 'Agent')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_agent"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_agent"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Installer', 'Agent')"/></td>
            <td><input type="file" name="installer" size="30"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Installer signature', 'Agent')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td><input type="file" name="installer_sig" size="30"/></td>
          </tr>
          <!--
          <tr>
            <td valign="top" width="125">Howto Install</td>
            <td><input type="file" name="howto_install" size="30"/></td>
          </tr>
          <tr>
            <td valign="top" width="125">Howto Use</td>
            <td><input type="file" name="howto_use" size="30"/></td>
          </tr>
          -->
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Agent', 'Agent')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_agent">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_agent_response"/>
  <xsl:apply-templates select="commands_response/delete_agent_response"/>
  <xsl:call-template name="html-create-agent-form"/>
</xsl:template>

<xsl:template name="html-agents-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'agent'"/>
    <xsl:with-param name="cap-type" select="'Agent'"/>
    <xsl:with-param name="resources-summary" select="agents"/>
    <xsl:with-param name="resources" select="agent"/>
    <xsl:with-param name="count" select="count (agent)"/>
    <xsl:with-param name="filtered-count" select="agent_count/filtered"/>
    <xsl:with-param name="full-count" select="agent_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Trust', 'Trust')"/></name>
        <field>trust</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="6"/>
  </xsl:call-template>
</xsl:template>

<!--     EDIT_AGENT -->

<xsl:template name="html-edit-agent-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Agent', 'Agent')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Agent'"/>
        <xsl:with-param name="type" select="'agent'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_agents_response/agent/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_agent"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="agent_id"
               value="{commands_response/get_agents_response/agent/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="agent" value="{/envelope/params/agent}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" size="30" maxlength="80"
                     value="{commands_response/get_agents_response/agent/name}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{commands_response/get_agents_response/agent/comment}"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Agent', 'Agent')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_agent">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_agent_response"/>
  <xsl:call-template name="html-edit-agent-form"/>
</xsl:template>

<!--     RESPONSES -->

<xsl:template match="create_agent_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Agent</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="delete_agent_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Agent
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="modify_agent_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Agent</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="verify_agent_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Verify Agent</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     AGENT -->

<xsl:template match="agent">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Agent'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_agent&amp;agent_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Agent', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:i18n (installer/trust/text(), 'Trust')"/>
      <xsl:choose>
        <xsl:when test="installer/trust/time != ''">
          (<xsl:value-of select="concat (date:month-abbreviation (installer/trust/time), ' ', date:day-in-month (installer/trust/time), ' ', date:year (installer/trust/time))"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Agent'"/>
            <xsl:with-param name="type" select="'agent'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
          <a href="/omp?cmd=download_agent&amp;agent_id={@id}&amp;agent_format=installer&amp;token={/envelope/token}"
            title="{gsa:i18n ('Download installer package', 'Agent')}" style="margin-left:3px;">
            <img src="/img/agent.png" border="0" alt="{gsa:i18n ('Download Installer', 'Agent')}"/>
          </a>
          <a href="/omp?cmd=verify_agent&amp;agent_id={@id}&amp;token={/envelope/token}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}"
            title="{gsa:i18n ('Verify Agent', 'Agent')}"
            style="margin-left:3px;">
            <img src="/img/verify.png" border="0" alt="{gsa:i18n ('Verify Agent', 'Agent')}"/>
          </a>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="agent" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Agent'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:i18n (installer/trust/text(), 'Trust')"/>
      <xsl:choose>
        <xsl:when test="installer/trust/time != ''">
          <br/>(<xsl:value-of select="concat (date:month-abbreviation (installer/trust/time), ' ', date:day-in-month (installer/trust/time), ' ', date:year (installer/trust/time))"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:call-template name="trash-delete-icon">
        <xsl:with-param name="type" select="'agent'"/>
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
    </td>
  </tr>
</xsl:template>

<xsl:template match="agent" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Agent Details', 'Agent')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Agent'"/>
        <xsl:with-param name="type" select="'agent'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Trust', 'Trust')"/>:</td>
          <td>
            <xsl:value-of select="gsa:i18n (installer/trust/text(), 'Trust')"/>
            <xsl:choose>
              <xsl:when test="installer/trust/time != ''">
                (<xsl:value-of select="concat (date:month-abbreviation (installer/trust/time), ' ', date:day-in-month (installer/trust/time), ' ', date:year (installer/trust/time))"/>)
              </xsl:when>
              <xsl:otherwise></xsl:otherwise>
            </xsl:choose>
        </td>
        </tr>
      </table>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'agent'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'agent'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     GET_AGENT -->

<xsl:template match="get_agent">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_agent_response"/>
  <xsl:apply-templates select="modify_agent_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="verify_agent_response"/>
  <xsl:apply-templates select="get_agents_response/agent" mode="details"/>
</xsl:template>

<!--     GET_AGENTS_RESPONSE -->

<xsl:template match="get_agents_response">
  <xsl:apply-templates select="modify_agent_response"/>
  <xsl:choose>
    <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
      <xsl:call-template name="command_result_dialog">
        <xsl:with-param name="operation">
          Get Agents
        </xsl:with-param>
        <xsl:with-param name="status">
          <xsl:value-of select="@status"/>
        </xsl:with-param>
        <xsl:with-param name="msg">
          <xsl:value-of select="@status_text"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="html-agents-table"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="agent" mode="select">
  <option value="{name}"><xsl:value-of select="name"/></option>
</xsl:template>

<xsl:template match="agents_response" mode="select">
  <xsl:apply-templates select="agent" mode="select"/>
</xsl:template>

<!-- BEGIN AGGREGATES MANAGEMENT -->

<xsl:template match="get_aggregate">
  <xsl:variable name="filter_term" select="/envelope/params/filter"/>
  <xsl:variable name="filt_id" select="/envelope/params/filt_id"/>

  <xsl:call-template name="init-d3charts"/>
  <div id="aggregate-container"/>
  <xsl:choose>
    <xsl:when test="$filter_term != ''">
      <div id="applied_filter" class="footnote" style="padding: 5px 10px">
        <b><xsl:value-of select="gsa:i18n('Applied filter:', 'Filter')"/></b>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$filter_term"/>
      </div>
    </xsl:when>
    <xsl:otherwise>
      <div id="applied_filter"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="html-footer"/>
  <script>
    <xsl:call-template name="js-create-chart-box">
      <xsl:with-param name="parent_id" select="'aggregate-container'"/>
      <xsl:with-param name="container_id" select="'aggregate-display'"/>
      <xsl:with-param name="container_width" select="'98%'"/>
    </xsl:call-template>
    <xsl:call-template name="js-aggregate-data-source">
      <xsl:with-param name="data_source_name" select="'aggregate-source'"/>
      <xsl:with-param name="aggregate_type" select="/envelope/params/aggregate_type"/>
      <xsl:with-param name="group_column" select="/envelope/params/group_column"/>
      <xsl:with-param name="data_column" select="/envelope/params/data_column"/>
      <xsl:with-param name="filter" select="$filter_term"/>
      <xsl:with-param name="filt_id" select="$filt_id"/>
      <xsl:with-param name="chart_template" select="/envelope/params/chart_template"/>
    </xsl:call-template>
    <xsl:call-template name="js-aggregate-chart">
      <xsl:with-param name="chart_name" select="'aggregate-chart'"/>
      <xsl:with-param name="data_source_name" select="'aggregate-source'"/>
      <xsl:with-param name="generator_name" select="'aggregate-generator'"/>
      <xsl:with-param name="display_name" select="'aggregate-display'"/>
      <xsl:with-param name="aggregate_type" select="/envelope/params/aggregate_type"/>
      <xsl:with-param name="group_column" select="/envelope/params/group_column"/>
      <xsl:with-param name="data_column" select="/envelope/params/data_column"/>
      <xsl:with-param name="chart_type" select="/envelope/params/chart_type"/>
      <xsl:with-param name="chart_template" select="/envelope/params/chart_template"/>
      <xsl:with-param name="auto_load" select="0"/>
    </xsl:call-template>

    if (this.fit_window)
      fit_detached_window ()

    window.onresize = detached_chart_resize_listener (gsa.displays ["aggregate-display"])
    window.onresize ();
  </script>
</xsl:template>


<!-- END AGGREGATES MANAGEMENT -->


<!-- BEGIN ALERTS MANAGEMENT -->

<xsl:variable name="include-message-default">
Task '$n': $e

After the event $e,
the following condition was met: $c

This email escalation is configured to apply report format '$r'.
Full details and other report formats are available on the scan engine.

$t
$i

Note:
This email was sent to you as a configured security scan escalation.
Please contact your local system administrator if you think you
should not have received it.
</xsl:variable>

<xsl:variable name="attach-message-default">
Task '$n': $e

After the event $e,
the following condition was met: $c

This email escalation is configured to attach report format '$r'.
Full details and other report formats are available on the scan engine.

$t

Note:
This email was sent to you as a configured security scan escalation.
Please contact your local system administrator if you think you
should not have received it.
</xsl:variable>

<xsl:template name="condition-field">
  <xsl:param name="condition" select="false ()"/>
  <xsl:param name="condition-text">
    <xsl:choose>
      <xsl:when test="$condition">
        <xsl:value-of select="$condition/text()"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="filters"/>
  <table border="0" width="100%">
    <tr>
      <td colspan="2" valign="top">
        <xsl:choose>
          <xsl:when test="not ($condition)">
            <xsl:call-template name="radio-button">
              <xsl:with-param name="value" select="'Always'"/>
              <xsl:with-param name="select-value" select="'Always'"/>
              <xsl:with-param name="text" select="gsa:i18n ('Always', 'Alert')"/>
              <xsl:with-param name="name" select="'condition'"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="radio-button">
              <xsl:with-param name="value" select="'Always'"/>
              <xsl:with-param name="select-value" select="$condition-text"/>
              <xsl:with-param name="text" select="gsa:i18n ('Always', 'Alert')"/>
              <xsl:with-param name="name" select="'condition'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td colspan="2" valign="top">
        <xsl:call-template name="radio-button">
          <xsl:with-param name="value" select="'Severity at least'"/>
          <xsl:with-param name="select-value" select="$condition-text"/>
          <xsl:with-param name="text" select="gsa:i18n ('Severity at least', 'Alert')"/>
          <xsl:with-param name="name" select="'condition'"/>
        </xsl:call-template>
        <xsl:text> </xsl:text>
        <xsl:choose>
          <xsl:when test="$condition and $condition/text() = 'Severity at least'">
            <input name="condition_data:severity" value="{$condition/data/text()}" size="5"/>
          </xsl:when>
          <xsl:otherwise>
            <input name="condition_data:severity" value="0.1" size="5"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <tr>
      <td colspan="2" valign="top">
        <xsl:call-template name="radio-button">
          <xsl:with-param name="name" select="'condition'"/>
          <xsl:with-param name="value" select="'Severity changed'"/>
          <xsl:with-param name="select-value" select="$condition-text"/>
          <xsl:with-param name="text" select="gsa:i18n ('Severity level ', 'Alert Condition')"/>
        </xsl:call-template>
        <select name="condition_data:direction">
          <xsl:call-template name="opt">
            <xsl:with-param name="value" select="'changed'"/>
            <xsl:with-param name="select-value" select="$condition-text"/>
            <xsl:with-param name="content" select="gsa:i18n ('changed', 'Alert Condition')"/>
          </xsl:call-template>
          <xsl:call-template name="opt">
            <xsl:with-param name="value" select="'increased'"/>
            <xsl:with-param name="select-value" select="$condition-text"/>
            <xsl:with-param name="content" select="gsa:i18n ('increased', 'Alert Condition')"/>
          </xsl:call-template>
          <xsl:call-template name="opt">
            <xsl:with-param name="value" select="'decreased'"/>
            <xsl:with-param name="select-value" select="$condition-text"/>
            <xsl:with-param name="content" select="gsa:i18n ('decreased', 'Alert Condition')"/>
          </xsl:call-template>
        </select>
      </td>
    </tr>
    <tr>
      <td colspan="2" valign="top">
        <xsl:call-template name="radio-button">
          <xsl:with-param name="name" select="'condition'"/>
          <xsl:with-param name="value" select="'Filter count at least'"/>
          <xsl:with-param name="select-value" select="$condition-text"/>
          <xsl:with-param name="text">
            <xsl:value-of select="gsa:i18n ('Filter ', 'Alert')"/>
            <select name="condition_data:at_least_filter_id">
              <xsl:for-each select="$filters/filter">
                <xsl:choose>
                  <xsl:when test="$condition and $condition/text() = 'Filter count at least' and $condition/data[name='filter_id']/text() = @id">
                    <option value="{@id}" selected="1">
                      <xsl:value-of select="name"/>
                    </option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="{@id}"><xsl:value-of select="name"/></option>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </select>
            <xsl:value-of select="gsa:i18n (' matches at least ', 'Alert')"/>
            <xsl:choose>
              <xsl:when test="$condition and $condition/text() = 'Filter count at least'">
                <input name="condition_data:at_least_count"
                       value="{$condition/data[name='count']/text()}"
                       size="5"/>
              </xsl:when>
              <xsl:otherwise>
                <input name="condition_data:at_least_count" value="1" size="5"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="gsa:i18n (' result(s)', 'Alert')"/>
          </xsl:with-param>
        </xsl:call-template>
      </td>
    </tr>
    <tr>
      <td colspan="2" valign="top">
        <xsl:call-template name="radio-button">
          <xsl:with-param name="name" select="'condition'"/>
          <xsl:with-param name="value" select="'Filter count changed'"/>
          <xsl:with-param name="select-value" select="$condition-text"/>
          <xsl:with-param name="text">
            <xsl:value-of select="gsa:i18n ('Filter ', 'Alert')"/>
            <input type="hidden" name="condition_data:filter_direction" value="increased"/>
            <select name="condition_data:filter_id">
              <xsl:for-each select="$filters/filter">
                <xsl:choose>
                  <xsl:when test="$condition and $condition/text() = 'Filter count changed' and $condition/data[name='filter_id']/text() = @id">
                    <option value="{@id}" selected="1">
                      <xsl:value-of select="name"/>
                    </option>
                  </xsl:when>
                  <xsl:otherwise>
                    <option value="{@id}"><xsl:value-of select="name"/></option>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:for-each>
            </select>
            <xsl:value-of select="gsa:i18n (' matches at least ', 'Alert')"/>
            <xsl:choose>
              <xsl:when test="$condition and $condition/text() = 'Filter count changed'">
                <input name="condition_data:count"
                       value="{$condition/data[name='count']/text()}"
                       size="5"/>
              </xsl:when>
              <xsl:otherwise>
                <input name="condition_data:count" value="1" size="5"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="gsa:i18n (' result(s) more than previous scan', 'Alert')"/>
          </xsl:with-param>
        </xsl:call-template>
      </td>
    </tr>
  </table>
</xsl:template>

<xsl:template name="html-create-alert-form">
  <xsl:param name="report-formats"></xsl:param>
  <xsl:param name="filters"/>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Alert', 'Alert')"/>
      <a href="/help/new_alert.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Alert', 'Alert'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_alerts&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Alerts', 'Alert')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Alerts', 'Alert')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_alert"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_alert"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <xsl:if test="not (gsa:may-op ('get_filters'))">
          <input type="hidden" name="filter_id" value="0"/>
        </xsl:if>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr class="odd">
            <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Event', 'Alert')"/></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="2" valign="top">
                    <label>
                      <input type="radio" name="event" value="Task run status changed" checked="1"/>
                      <xsl:value-of select="gsa:i18n ('Task run status changed to', 'Alert')"/>
                      <xsl:text> </xsl:text>
                    </label>
                    <select name="event_data:status">
                      <option value="Done" selected="1"><xsl:value-of select="gsa:i18n ('Done', 'Status')"/></option>
                      <option value="New"><xsl:value-of select="gsa:i18n ('New', 'Status')"/></option>
                      <option value="Requested"><xsl:value-of select="gsa:i18n ('Requested', 'Status')"/></option>
                      <option value="Running"><xsl:value-of select="gsa:i18n ('Running', 'Status')"/></option>
                      <option value="Stop Requested"><xsl:value-of select="gsa:i18n ('Stop Requested', 'Status')"/></option>
                      <option value="Stopped"><xsl:value-of select="gsa:i18n ('Stopped', 'Status')"/></option>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Condition', 'Alert')"/></td>
            <td colspan="2">
              <xsl:call-template name="condition-field">
                <xsl:with-param name="filters" select="$filters"/>
              </xsl:call-template>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Method', 'Alert')"/></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <input type="radio" name="method" value="Email" checked="1"/>
                      <xsl:value-of select="gsa:i18n ('Email', 'Alert')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('To Address', 'Alert|Email')"/></td>
                  <td>
                    <input type="text" name="method_data:to_address" size="30" maxlength="301"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('From Address', 'Alert|Email')"/></td>
                  <td>
                    <input type="text" name="method_data:from_address" size="30" maxlength="301"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Subject', 'Alert|Email')"/></td>
                  <td>
                    <input type="text" name="method_data:subject"
                           size="30" maxlength="80"
                           value="[OpenVAS-Manager] Task '$n': $e"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Content', 'Alert|Email')"/></td>
                  <td>
                    <table>
                      <tr>
                        <td colspan="3" valign="top">
                          <label>
                            <input type="radio" name="method_data:notice" value="1" checked="1"/>
                            <xsl:value-of select="gsa:i18n ('Simple notice', 'Alert|Email')"/>
                          </label>
                        </td>
                      </tr>
                      <xsl:if test="gsa:may-op ('get_report_formats')">
                        <tr>
                          <td colspan="3" valign="top">
                            <label>
                              <input type="radio" name="method_data:notice" value="0"/>
                              <xsl:value-of select="gsa:i18n ('Include report', 'Alert|Email')"/>
                              <xsl:text> </xsl:text>
                            </label>
                            <select name="method_data:notice_report_format">
                              <xsl:for-each select="$report-formats/report_format">
                                <xsl:if test="substring(content_type, 1, 5) = 'text/'">
                                  <xsl:choose>
                                    <xsl:when test="@id='19f6f1b3-7128-4433-888c-ccc764fe6ed5'">
                                      <option value="{@id}" selected="1">
                                        <xsl:value-of select="name"/>
                                      </option>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <option value="{@id}">
                                        <xsl:value-of select="name"/>
                                      </option>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:if>
                              </xsl:for-each>
                            </select>
                            with message:
                            <br/>
                            <textarea style="margin-left:15px;"
                                      name="method_data:message"
                                      rows="3" cols="50">
                              <xsl:value-of select="$include-message-default"/>
                            </textarea>
                          </td>
                        </tr>
                        <tr>
                          <td colspan="3" valign="top">
                            <label>
                              <input type="radio" name="method_data:notice" value="2"/>
                              <xsl:value-of select="gsa:i18n ('Attach report', 'Alert|Email')"/>
                              <xsl:text> </xsl:text>
                            </label>
                            <select name="method_data:notice_attach_format">
                              <xsl:for-each select="$report-formats/report_format">
                                <xsl:choose>
                                  <xsl:when test="@id='1a60a67e-97d0-4cbf-bc77-f71b08e7043d'">
                                    <option value="{@id}" selected="1">
                                      <xsl:value-of select="name"/>
                                    </option>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <option value="{@id}">
                                      <xsl:value-of select="name"/>
                                    </option>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:for-each>
                            </select>
                            with message:
                            <br/>
                            <textarea style="margin-left:15px;"
                                      name="method_data:message_attach"
                                      rows="3" cols="50">
                              <xsl:value-of select="$attach-message-default"/>
                            </textarea>
                          </td>
                        </tr>
                      </xsl:if>
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="2" valign="top">
                    <label width="250">
                      <input type="radio" name="method" value="syslog"/>
                      <xsl:value-of select="gsa:i18n ('System Logger', 'Alert')"/>
                      <xsl:text> </xsl:text>
                    </label>
                    <input type="hidden" name="method_data:submethod"
                           value="syslog"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <input type="radio" name="method" value="HTTP Get"/>
                      <xsl:value-of select="gsa:i18n ('HTTP Get', 'Alert')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150">URL</td>
                  <td>
                    <input type="text" name="method_data:URL" size="30" maxlength="301"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <input type="radio" name="method" value="Sourcefire Connector"/>
                      <xsl:value-of select="gsa:i18n ('Sourcefire Connector', 'Alert')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Defense Center IP', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:defense_center_ip"
                           size="30" maxlength="40"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Defense Center Port', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:defense_center_port"
                           size="30" maxlength="400" value="8307"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('PKCS12 file', 'Alert')"/></td>
                  <td>
                    <input type="file" name="method_data:pkcs12" size="30"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <input type="radio" name="method" value="verinice Connector"/>
                      <xsl:value-of select="gsa:i18n ('verinice.PRO Connector', 'Alert')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO URL', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:verinice_server_url"
                           size="30" maxlength="256"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO Username', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:verinice_server_username"
                           size="30" maxlength="40"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO Password', 'Alert')"/></td>
                  <td>
                    <input type="password" name="method_data:verinice_server_password"
                           size="30" maxlength="40"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO Report', 'Alert')"/></td>
                  <td>
                    <select name="method_data:verinice_server_report_format">
                      <xsl:for-each select="$report-formats/report_format">
                        <xsl:if test="extension = 'vna'">
                          <xsl:choose>
                            <xsl:when test="name='Verinice ISM'">
                              <option value="{@id}" selected="1">
                                <xsl:value-of select="name"/>
                              </option>
                            </xsl:when>
                            <xsl:otherwise>
                              <option value="{@id}">
                                <xsl:value-of select="name"/>
                              </option>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:if>
                      </xsl:for-each>
                      <xsl:if test="count ($report-formats/report_format) = 0">
                        <option value="''">--</option>
                      </xsl:if>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <input type="radio" name="method" value="Send"/>
                      <xsl:value-of select="gsa:i18n ('Send to host ', 'Alert')"/>
                    </label>
                    <input type="text" name="method_data:send_host"
                           size="30" maxlength="256"/>
                    <xsl:value-of select="gsa:i18n (' on port ', 'Alert')"/>
                    <input type="text" name="method_data:send_port"
                           size="6" maxlength="6"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Report', 'Alert')"/></td>
                  <td>
                    <select name="method_data:send_report_format">
                      <xsl:for-each select="$report-formats/report_format">
                        <option value="{@id}">
                          <xsl:value-of select="name"/>
                        </option>
                      </xsl:for-each>
                      <xsl:if test="count ($report-formats/report_format) = 0">
                        <option value="''">--</option>
                      </xsl:if>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Method: SCP. -->

          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <input type="radio" name="method" value="SCP"/>
                      <xsl:value-of select="gsa:i18n ('SCP', 'Alert')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Username', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:scp_username"
                           size="30" maxlength="256"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Password', 'Alert')"/></td>
                  <td>
                    <input type="password" name="method_data:scp_password"
                           size="30" maxlength="256"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Host', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:scp_host"
                           size="30" maxlength="256"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Known Hosts', 'Alert')"/></td>
                  <td>
                    <textarea name="method_data:scp_known_hosts"
                              rows="3" cols="50">
                    </textarea>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Path', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:scp_path"
                           size="30" maxlength="256" value="report.xml"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Report', 'Alert')"/></td>
                  <td>
                    <select name="method_data:scp_report_format">
                      <xsl:for-each select="$report-formats/report_format">
                        <option value="{@id}">
                          <xsl:value-of select="name"/>
                        </option>
                      </xsl:for-each>
                      <xsl:if test="count ($report-formats/report_format) = 0">
                        <option value="''">--</option>
                      </xsl:if>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Method: SNMP. -->

          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label width="250">
                      <input type="radio" name="method" value="SNMP"/>
                      <xsl:value-of select="gsa:i18n ('SNMP', 'Alert')"/>
                      <xsl:text> </xsl:text>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Community', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:snmp_community" size="30"
                           maxlength="301" value="public"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Agent', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:snmp_agent" size="30" maxlength="301"
                           value="localhost"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Message', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:snmp_message" size="30" maxlength="301"
                           value="$e"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <xsl:if test="gsa:may-op ('get_filters')">
            <tr>
              <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Report Result Filter', 'Alert')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
              <td colspan="2">
                <select name="filter_id">
                  <option value="0">--</option>
                  <xsl:for-each select="$filters/filter">
                    <option value="{@id}"><xsl:value-of select="name"/></option>
                  </xsl:for-each>
                </select>
              </td>
            </tr>
          </xsl:if>
          <tr class="even">
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Alert', 'Alert')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_alert">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_alert_response"/>
  <xsl:apply-templates select="commands_response/delete_alert_response"/>
  <xsl:call-template name="html-create-alert-form">
    <xsl:with-param
      name="report-formats"
      select="get_report_formats_response | commands_response/get_report_formats_response"/>
    <xsl:with-param
      name="filters"
      select="get_filters_response | commands_response/get_filters_response"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-alerts-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'alert'"/>
    <xsl:with-param name="cap-type" select="'Alert'"/>
    <xsl:with-param name="resources-summary" select="alerts"/>
    <xsl:with-param name="resources" select="alert"/>
    <xsl:with-param name="count" select="count (alert)"/>
    <xsl:with-param name="filtered-count" select="alert_count/filtered"/>
    <xsl:with-param name="full-count" select="alert_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Event', 'Alert')"/></name>
        <field>event</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Condition', 'Alert')"/></name>
        <field>condition</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Method', 'Alert')"/></name>
        <field>method</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Filter', 'Filter')"/></name>
        <field>filter</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="5"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="radio-button">
  <xsl:param name="name"></xsl:param>
  <xsl:param name="value"></xsl:param>
  <xsl:param name="text"></xsl:param>
  <xsl:param name="select-value"></xsl:param>
  <label>
    <xsl:choose>
      <xsl:when test="$value = $select-value">
        <input type="radio" name="{$name}" checked="1" value="{$value}"/>
      </xsl:when>
      <xsl:otherwise>
        <input type="radio" name="{$name}" value="{$value}"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="$text">
        <xsl:copy-of select="$text"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$value"/>
      </xsl:otherwise>
    </xsl:choose>
  </label>
</xsl:template>

<xsl:template name="html-edit-alert-form">
  <xsl:param name="report-formats"></xsl:param>
  <xsl:param name="filters"/>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Alert', 'Alert')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Alert'"/>
        <xsl:with-param name="type" select="'alert'"/>
        <xsl:with-param name="id"
                        select="get_alerts_response/alert/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_alert"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="alert_id"
               value="{get_alerts_response/alert/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="alert" value="{/envelope/params/alert}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <xsl:if test="not (gsa:may-op ('get_filters'))">
          <input type="hidden" name="filter_id" value="0"/>
        </xsl:if>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr class="odd">
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" size="30" maxlength="80"
                     value="{get_alerts_response/alert/name}"/>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{get_alerts_response/alert/comment}"/>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Event', 'Alert')"/></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="2" valign="top">
                    <label>
                      <input type="radio" name="event" value="Task run status changed" checked="1"/>
                      <xsl:value-of select="gsa:i18n ('Task run status changed to', 'Alert')"/>
                      <xsl:text> </xsl:text>
                    </label>
                    <xsl:variable name="eventdata"
                                  select="get_alerts_response/alert/event/data/text()"/>
                    <select name="event_data:status">
                      <xsl:if test="$eventdata = 'Delete Requested'">
                        <!-- In case the user has an alert with this state. -->
                        <xsl:call-template name="opt">
                          <xsl:with-param name="value" select="'Delete Requested'"/>
                          <xsl:with-param name="content" select="gsa:i18n ('Delete Requested', 'Status')"/>
                          <xsl:with-param name="select-value" select="$eventdata"/>
                        </xsl:call-template>
                      </xsl:if>
                      <xsl:call-template name="opt">
                        <xsl:with-param name="value" select="'Done'"/>
                        <xsl:with-param name="content" select="gsa:i18n ('Done', 'Status')"/>
                        <xsl:with-param name="select-value" select="$eventdata"/>
                      </xsl:call-template>
                      <xsl:call-template name="opt">
                        <xsl:with-param name="value" select="'New'"/>
                        <xsl:with-param name="content" select="gsa:i18n ('New', 'Status')"/>
                        <xsl:with-param name="select-value" select="$eventdata"/>
                      </xsl:call-template>
                      <xsl:call-template name="opt">
                        <xsl:with-param name="value" select="'Requested'"/>
                        <xsl:with-param name="content" select="gsa:i18n ('Requested', 'Status')"/>
                        <xsl:with-param name="select-value" select="$eventdata"/>
                      </xsl:call-template>
                      <xsl:call-template name="opt">
                        <xsl:with-param name="value" select="'Running'"/>
                        <xsl:with-param name="content" select="gsa:i18n ('Running', 'Status')"/>
                        <xsl:with-param name="select-value" select="$eventdata"/>
                      </xsl:call-template>
                      <xsl:call-template name="opt">
                        <xsl:with-param name="value" select="'Stop Requested'"/>
                        <xsl:with-param name="content" select="gsa:i18n ('Stop Requested', 'Status')"/>
                        <xsl:with-param name="select-value" select="$eventdata"/>
                      </xsl:call-template>
                      <xsl:call-template name="opt">
                        <xsl:with-param name="value" select="'Stopped'"/>
                        <xsl:with-param name="content" select="gsa:i18n ('Stopped', 'Status')"/>
                        <xsl:with-param name="select-value" select="$eventdata"/>
                      </xsl:call-template>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="even">
            <xsl:variable name="condition"
                          select="get_alerts_response/alert/condition"/>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Condition', 'Alert')"/></td>
            <td colspan="2">
              <xsl:call-template name="condition-field">
                <xsl:with-param name="condition"
                                select="get_alerts_response/alert/condition"/>
                <xsl:with-param name="filters" select="$filters"/>
              </xsl:call-template>
            </td>
          </tr>
          <xsl:variable name="method"
                        select="get_alerts_response/alert/method"/>
          <tr class="odd">
            <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Method', 'Alert')"/></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'Email'"/>
                      <xsl:with-param name="select-value" select="$method/text()"/>
                      <xsl:with-param name="text" select="gsa:i18n ('Email', 'Alert')"/>
                    </xsl:call-template>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('To Address', 'Alert|Email')"/></td>
                  <td>
                    <input type="text" name="method_data:to_address" size="30" maxlength="301"
                        value="{$method/data[name='to_address']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('From Address', 'Alert|Email')"/></td>
                  <td>
                    <input type="text" name="method_data:from_address" size="30" maxlength="301"
                        value="{$method/data[name='from_address']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Subject', 'Alert|Email')"/></td>
                  <td>
                    <input type="text" name="method_data:subject"
                           size="30" maxlength="80"
                           value="{$method/data[name='subject']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Content', 'Alert|Email')"/></td>
                  <td>
                    <table>
                      <tr>
                        <td colspan="3" valign="top">
                          <label>
                            <xsl:call-template name="radio-button">
                              <xsl:with-param name="name" select="'method_data:notice'"/>
                              <xsl:with-param name="text" select="gsa:i18n ('Simple notice', 'Alert|Email')"/>
                              <xsl:with-param name="value" select="'1'"/>
                              <xsl:with-param name="select-value" select="$method/data[name='notice']/text()"/>
                            </xsl:call-template>
                          </label>
                        </td>
                      </tr>
                      <xsl:if test="gsa:may-op ('get_filters')">
                        <tr>
                          <td colspan="3" valign="top">
                              <xsl:call-template name="radio-button">
                                <xsl:with-param name="name" select="'method_data:notice'"/>
                                <xsl:with-param name="text" select="gsa:i18n ('Include report', 'Alert|Email')"/>
                                <xsl:with-param name="value" select="'0'"/>
                                <xsl:with-param name="select-value" select="$method/data[name='notice']/text()"/>
                              </xsl:call-template>
                            <xsl:text> </xsl:text>
                            <select name="method_data:notice_report_format">
                              <xsl:for-each select="$report-formats/report_format">
                                <xsl:if test="substring(content_type, 1, 5) = 'text/'">
                                  <xsl:choose>
                                    <xsl:when test="@id=$method/data[name='notice_report_format']/text()">
                                      <option value="{@id}" selected="1">
                                        <xsl:value-of select="name"/>
                                      </option>
                                    </xsl:when>
                                    <xsl:otherwise>
                                      <option value="{@id}">
                                        <xsl:value-of select="name"/>
                                      </option>
                                    </xsl:otherwise>
                                  </xsl:choose>
                                </xsl:if>
                              </xsl:for-each>
                            </select>
                            with message:
                            <br/>
                            <textarea style="margin-left:15px;"
                                      name="method_data:message"
                                      rows="3" cols="50">
                              <xsl:choose>
                                <xsl:when test="$method/data[name='notice']/text() = 0">
                                  <xsl:value-of select="$method/data[name='message']/text()"/>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="$include-message-default"/>
                                </xsl:otherwise>
                              </xsl:choose>
                            </textarea>
                          </td>
                        </tr>
                        <tr>
                          <td colspan="3" valign="top">
                              <xsl:call-template name="radio-button">
                                <xsl:with-param name="name" select="'method_data:notice'"/>
                                <xsl:with-param name="text" select="gsa:i18n ('Attach report', 'Alert|Email')"/>
                                <xsl:with-param name="value" select="'2'"/>
                                <xsl:with-param name="select-value" select="$method/data[name='notice']/text()"/>
                              </xsl:call-template>
                            <xsl:text> </xsl:text>
                            <select name="method_data:notice_attach_format">
                              <xsl:for-each select="$report-formats/report_format">
                                <xsl:choose>
                                  <xsl:when test="@id=$method/data[name='notice_attach_format']/text()">
                                    <option value="{@id}" selected="1">
                                      <xsl:value-of select="name"/>
                                    </option>
                                  </xsl:when>
                                  <xsl:otherwise>
                                    <option value="{@id}">
                                      <xsl:value-of select="name"/>
                                    </option>
                                  </xsl:otherwise>
                                </xsl:choose>
                              </xsl:for-each>
                            </select>
                            with message:
                            <br/>
                            <textarea style="margin-left:15px;"
                                      name="method_data:message_attach"
                                      rows="3" cols="50">
                              <xsl:choose>
                                <xsl:when test="$method/data[name='notice']/text() = 2">
                                  <xsl:value-of select="$method/data[name='message']/text()"/>
                                </xsl:when>
                                <xsl:otherwise>
                                  <xsl:value-of select="$attach-message-default"/>
                                </xsl:otherwise>
                              </xsl:choose>
                            </textarea>
                          </td>
                        </tr>
                      </xsl:if>
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'syslog'"/>
                      <xsl:with-param name="select-value" select="gsa:lower-case($method/text())"/>
                      <xsl:with-param name="text" select="gsa:i18n ('System Logger', 'Alert')"/>
                    </xsl:call-template>
                    <xsl:text> </xsl:text>
                    <xsl:variable name="submethod"
                                  select="$method/data[name='submethod']/text()"/>
                    <xsl:choose>
                      <xsl:when test="string-length ($submethod) = 0 or $submethod = 'syslog'">
                        <input type="hidden" name="method_data:submethod" value="syslog"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <select name="method_data:submethod">
                          <xsl:call-template name="opt">
                            <xsl:with-param name="value" select="'syslog'"/>
                            <xsl:with-param name="select-value" select="$submethod"/>
                          </xsl:call-template>
                          <xsl:call-template name="opt">
                            <xsl:with-param name="value" select="$submethod"/>
                            <xsl:with-param name="select-value" select="$submethod"/>
                          </xsl:call-template>
                        </select>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'HTTP Get'"/>
                      <xsl:with-param name="select-value" select="$method/text()"/>
                      <xsl:with-param name="text" select="gsa:i18n ('HTTP Get', 'Alert')"/>
                    </xsl:call-template>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150">URL</td>
                  <td>
                    <input type="text" name="method_data:URL" size="30" maxlength="301"
                        value="{$method/data[name='URL']/text()}"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'Sourcefire Connector'"/>
                      <xsl:with-param name="select-value" select="$method/text()"/>
                      <xsl:with-param name="text" select="gsa:i18n ('Sourcefire Connector', 'Alert')"/>
                    </xsl:call-template>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Defense Center IP', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:defense_center_ip"
                           size="30" maxlength="40" value="{$method/data[name='defense_center_ip']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Defense Center Port', 'Alert')"/></td>
                  <td>
                    <xsl:choose>
                      <xsl:when test="$method/data[name='defense_center_port']/text()">
                        <input type="text" name="method_data:defense_center_port"
                               size="30" maxlength="400"  value="{$method/data[name='defense_center_port']/text()}"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="text" name="method_data:defense_center_port"
                               size="30" maxlength="400" value="8307"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('PKCS12 file', 'Alert')"/></td>
                  <td>
                    <input type="file" name="method_data:pkcs12" size="30"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'verinice Connector'"/>
                      <xsl:with-param name="select-value" select="$method/text()"/>
                      <xsl:with-param name="text" select="gsa:i18n ('verinice.PRO Connector', 'Alert')"/>
                    </xsl:call-template>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO URL', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:verinice_server_url"
                           size="30" maxlength="256" value="{$method/data[name='verinice_server_url']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO Username', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:verinice_server_username"
                           size="30" maxlength="40" value="{$method/data[name='verinice_server_username']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO Password', 'Alert')"/></td>
                  <td>
                    <input type="password" name="method_data:verinice_server_password"
                           size="30" maxlength="40"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('verinice.PRO Report', 'Alert')"/></td>
                  <td>
                    <select name="method_data:verinice_server_report_format">
                      <xsl:for-each select="$report-formats/report_format">
                        <xsl:if test="extension = 'vna'">
                          <xsl:choose>
                            <xsl:when test="@id=$method/data[name='verinice_server_report_format']/text()">
                              <option value="{@id}" selected="1">
                                <xsl:value-of select="name"/>
                              </option>
                            </xsl:when>
                            <xsl:otherwise>
                              <option value="{@id}">
                                <xsl:value-of select="name"/>
                              </option>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:if>
                      </xsl:for-each>
                      <xsl:if test="count ($report-formats/report_format) = 0">
                        <option value="''">--</option>
                      </xsl:if>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'Send'"/>
                      <xsl:with-param name="select-value" select="$method/text()"/>
                      <xsl:with-param name="text" select="gsa:i18n ('Send to host ', 'Alert')"/>
                    </xsl:call-template>
                    <input type="text" name="method_data:send_host"
                           size="30" maxlength="256"
                           value="{$method/data[name='send_host']/text()}"/>
                    <xsl:value-of select="gsa:i18n (' on port ', 'Alert')"/>
                    <input type="text" name="method_data:send_port"
                           size="6" maxlength="6"
                           value="{$method/data[name='send_port']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Report', 'Alert')"/></td>
                  <td>
                    <select name="method_data:send_report_format">
                      <xsl:for-each select="$report-formats/report_format">
                        <xsl:choose>
                          <xsl:when test="@id=$method/data[name='send_report_format']/text()">
                            <option value="{@id}" selected="1">
                              <xsl:value-of select="name"/>
                            </option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}">
                              <xsl:value-of select="name"/>
                            </option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                      <xsl:if test="count ($report-formats/report_format) = 0">
                        <option value="''">--</option>
                      </xsl:if>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="odd">

            <!-- Method: SCP. -->

            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <label>
                      <xsl:call-template name="radio-button">
                        <xsl:with-param name="name" select="'method'"/>
                        <xsl:with-param name="value" select="'SCP'"/>
                        <xsl:with-param name="select-value" select="$method/text()"/>
                        <xsl:with-param name="text">
                          <xsl:value-of select="gsa:i18n ('SCP', 'Alert')"/>
                        </xsl:with-param>
                      </xsl:call-template>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Username', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:scp_username"
                           size="30" maxlength="256"
                           value="{$method/data[name='scp_username']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Password', 'Alert')"/></td>
                  <td>
                    <input type="password" name="method_data:scp_password"
                           size="30" maxlength="256"
                           value="{$method/data[name='scp_password']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Host', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:scp_host"
                           size="30" maxlength="256"
                           value="{$method/data[name='scp_host']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Known Hosts', 'Alert')"/></td>
                  <td>
                    <textarea name="method_data:scp_known_hosts"
                              rows="3" cols="50">
                      <xsl:value-of select="$method/data[name='scp_known_hosts']/text()"/>
                    </textarea>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Path', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:scp_path"
                           size="30" maxlength="256"
                           value="{$method/data[name='scp_path']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td></td>
                  <td><xsl:value-of select="gsa:i18n ('Report', 'Alert')"/></td>
                  <td>
                    <select name="method_data:scp_report_format">
                      <xsl:for-each select="$report-formats/report_format">
                        <xsl:call-template name="opt">
                          <xsl:with-param name="value" select="@id"/>
                          <xsl:with-param name="content" select="name"/>
                          <xsl:with-param name="select-value" select="$method/data[name='scp_report_format']/text()"/>
                        </xsl:call-template>
                      </xsl:for-each>
                      <xsl:if test="count ($report-formats/report_format) = 0">
                        <option value="''">--</option>
                      </xsl:if>
                    </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr class="even">

            <!-- Method: SNMP. -->

            <td valign="top" width="125"></td>
            <td colspan="2">
              <table border="0" width="100%">
                <tr>
                  <td colspan="3" valign="top">
                    <xsl:call-template name="radio-button">
                      <xsl:with-param name="name" select="'method'"/>
                      <xsl:with-param name="value" select="'SNMP'"/>
                      <xsl:with-param name="select-value" select="$method/text()"/>
                      <xsl:with-param name="text" select="gsa:i18n ('SNMP', 'Alert')"/>
                    </xsl:call-template>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Community', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:snmp_community"
                           size="30" maxlength="256" value="{$method/data[name='snmp_community']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Agent', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:snmp_agent"
                           size="30" maxlength="40" value="{$method/data[name='snmp_agent']/text()}"/>
                  </td>
                </tr>
                <tr>
                  <td width="45"></td>
                  <td width="150"><xsl:value-of select="gsa:i18n ('Message', 'Alert')"/></td>
                  <td>
                    <input type="text" name="method_data:snmp_message"
                           size="30" maxlength="40" value="{$method/data[name='snmp_message']/text()}"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <xsl:if test="gsa:may-op ('get_filters')">
            <xsl:variable name="filtername"
                select="get_alerts_response/alert/filter/name"/>
            <tr>
              <td valign="top" width="145"><xsl:value-of select="gsa:i18n ('Report Result Filter', 'Alert')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
              <td colspan="2">
                <select name="filter_id">
                  <option value="0">--</option>
                  <xsl:for-each select="$filters/filter">
                    <xsl:choose>
                      <xsl:when test="name = $filtername">
                        <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="{@id}"><xsl:value-of select="name"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:for-each>
                </select>
              </td>
            </tr>
          </xsl:if>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Alert', 'Alert')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_alert">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_alert_response"/>
  <xsl:call-template name="html-edit-alert-form">
    <xsl:with-param
      name="report-formats"
      select="get_report_formats_response | commands_response/get_report_formats_response"/>
    <xsl:with-param
      name="filters"
      select="get_filters_response | commands_response/get_filters_response"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="get_alerts_response">
</xsl:template>

<!--     CREATE_ALERT_RESPONSE -->

<xsl:template match="create_alert_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Alert</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     DELETE_ALERT_RESPONSE -->

<xsl:template match="delete_alert_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Alert
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     TEST_ALERT_RESPONSE -->

<xsl:template match="test_alert_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Test Alert</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     MODIFY_ALERT_RESPONSE -->

<xsl:template match="modify_alert_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Alert</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     ALERT -->

<xsl:template match="alert">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Alert'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_alert&amp;alert_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Alert', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:i18n(event/text(), 'Alert')"/>
      <xsl:choose>
        <xsl:when test="event/text()='Task run status changed' and string-length(event/data[name='status']/text()) &gt; 0">
          <br/>(<xsl:value-of select="gsa:i18n ('to', 'Alert')"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="gsa:i18n (event/data[name='status']/text(), 'Status')"/>)
        </xsl:when>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="condition"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="method/text()='SCP'">
          <xsl:value-of select="gsa:i18n ('SCP to ', 'Alert')"/>
          <xsl:value-of select="method/data[name='scp_username']/text()"/>
          <xsl:text>@</xsl:text>
          <xsl:value-of select="method/data[name='scp_host']/text()"/>
          <xsl:text>:</xsl:text>
          <xsl:value-of select="method/data[name='scp_path']/text()"/>
        </xsl:when>
        <xsl:when test="method/text()='Send'">
          <xsl:value-of select="gsa:i18n ('Send to ', 'Alert')"/>
          <xsl:value-of select="method/data[name='send_host']/text()"/>
          <xsl:text>:</xsl:text>
          <xsl:value-of select="method/data[name='send_port']/text()"/>
        </xsl:when>
        <xsl:when test="method/text()='Syslog' and method/data[name='submethod']/text() = 'SNMP'">
          SNMP
        </xsl:when>
        <xsl:when test="method/text()='SNMP'">
          <xsl:value-of select="gsa:i18n ('SNMP to ', 'Alert')"/>
          <xsl:value-of select="method/data[name='snmp_agent']/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n (method/text(), 'Alert')"/>
          <xsl:choose>
            <xsl:when test="method/text()='Email' and string-length(method/data[name='to_address']/text()) &gt; 0">
              <br/>(<xsl:value-of select="gsa:i18n ('To', 'Alert|Email')"/>
              <xsl:text> </xsl:text>
              <xsl:value-of select="method/data[name='to_address']/text()"/>)
            </xsl:when>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="boolean (filter/permissions) and count (filter/permissions/permission) = 0">
          <xsl:value-of select="filter/name"/>
        </xsl:when>
        <xsl:when test="gsa:may-op ('get_filters')">
          <a href="/omp?cmd=get_filter&amp;filter_id={filter/@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
            <xsl:value-of select="filter/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="filter/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Alert'"/>
            <xsl:with-param name="type" select="'alert'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
          <xsl:call-template name="start-icon">
            <xsl:with-param name="type">alert</xsl:with-param>
            <xsl:with-param name="id" select="@id"/>
            <xsl:with-param name="cmd">test_alert</xsl:with-param>
            <xsl:with-param name="alt"><xsl:value-of select="gsa:i18n ('Test', 'Action Verb')"/></xsl:with-param>
            <xsl:with-param name="name">Test</xsl:with-param>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="alert" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Alert'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:i18n (event/text(), 'Alert')"/>
      <xsl:choose>
        <xsl:when test="event/text()='Task run status changed' and string-length(event/data[name='status']/text()) &gt; 0">
          <br/>(<xsl:value-of select="gsa:i18n ('to', 'Alert')"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="gsa:i18n (event/data[name='status']/text(), 'Alert')"/>)
        </xsl:when>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:i18n (condition/text(), 'Alert')"/>
      <xsl:choose>
        <xsl:when test="condition/text()='Severity at least' and string-length(condition/data[name='severity']/text()) &gt; 0">
          <br/>(<xsl:value-of select="condition/data[name='severity']/text()"/>)
        </xsl:when>
        <xsl:when test="condition/text()='Severity changed' and string-length(condition/data[name='direction']/text()) &gt; 0">
          <br/>(<xsl:value-of select="gsa:i18n (condition/data[name='direction']/text(), 'Alert')"/>)
        </xsl:when>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="method/text()='Syslog' and method/data[name='submethod']/text() = 'SNMP'">
          SNMP
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n (method/text(), 'Alert')"/>
          <xsl:choose>
            <xsl:when test="method/text()='Email' and string-length(method/data[name='to_address']/text()) &gt; 0">
              <br/>(<xsl:value-of select="gsa:i18n ('To', 'Alert|Email')"/>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="method/data[name='to_address']/text()"/>)
            </xsl:when>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="filter/trash = '1'">
          <xsl:value-of select="filter/name"/>
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=get_filter&amp;filter_id={filter/@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
            <xsl:value-of select="filter/name"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="not (gsa:may-op ('restore'))"/>
        <xsl:when test="filter/trash = '1'">
          <img src="/img/restore_inactive.png" border="0" alt="{gsa:i18n ('Restore', 'Action Verb')}"
               title="{gsa:i18n ('Filter', 'Filter')}{gsa:i18n (' must be restored first', 'Trashcan')}"
               style="margin-left:3px;"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="restore-icon">
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'alert'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0"
               alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Alert is still in use', 'Alert')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template name="condition">
  <xsl:choose>
    <xsl:when test="condition/text()='Filter count at least'">
      <xsl:variable name="id" select="condition/data[name='filter_id']/text()"/>
      <xsl:text>Filter </xsl:text>
      <xsl:choose>
        <xsl:when test="gsa:may-op ('get_filters')">
          <a href="/omp?cmd=get_filter&amp;filter_id={$id}&amp;token={/envelope/token}"
             title="{gsa:i18n ('Details', 'Generic Resource')}">
            <xsl:value-of select="../../get_filters_response/filter[@id=$id]/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="../../get_filters_response/filter[@id=$id]/name"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> matches at least </xsl:text>
      <xsl:value-of select="condition/data[name='count']/text()"/>
      <xsl:text> results</xsl:text>
    </xsl:when>
    <xsl:when test="condition/text()='Filter count changed'">
      <xsl:variable name="id" select="condition/data[name='filter_id']/text()"/>
      <xsl:text>Filter </xsl:text>
      <xsl:choose>
        <xsl:when test="gsa:may-op ('get_filters')">
          <a href="/omp?cmd=get_filter&amp;filter_id={$id}&amp;token={/envelope/token}"
             title="{gsa:i18n ('Details', 'Generic Resource')}">
            <xsl:value-of select="../../get_filters_response/filter[@id=$id]/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="../../get_filters_response/filter[@id=$id]/name"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> matches at least </xsl:text>
      <xsl:value-of select="condition/data[name='count']/text()"/>
      <xsl:choose>
        <xsl:when test="condition/data[name='direction']/text() = 'decreased'">
          <xsl:text> fewer</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text> more</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="condition/data[name='count']/text() &gt; 1">
          <xsl:text> results than previous scan</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text> result than previous scan</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="condition/text()='Severity at least' and string-length(condition/data[name='severity']/text()) &gt; 0">
      <xsl:value-of select="gsa:i18n (condition/text(), 'Alert')"/>
      (<xsl:value-of select="condition/data[name='severity']/text()"/>)
    </xsl:when>
    <xsl:when test="condition/text()='Severity changed' and string-length(condition/data[name='direction']/text()) &gt; 0">
      <xsl:value-of select="gsa:i18n (condition/text(), 'Alert')"/>
      (<xsl:value-of select="gsa:i18n (condition/data[name='direction']/text(), 'Alert')"/>)
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="gsa:i18n (condition/text(), 'Alert')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="alert" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Alert Details', 'Alert')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Alert'"/>
        <xsl:with-param name="type" select="'alert'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Condition', 'Alert')"/>:</td>
          <td>
            <xsl:call-template name="condition"/>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Event', 'Alert')"/>:</td>
          <td>
            <xsl:value-of select="gsa:i18n (event/text(), 'Alert')"/>
            <xsl:choose>
              <xsl:when test="event/text()='Task run status changed' and string-length(event/data[name='status']/text()) &gt; 0">
                (<xsl:value-of select="gsa:i18n ('to', 'Alert')"/>
                 <xsl:text> </xsl:text>
                 <xsl:value-of select="gsa:i18n (event/data[name='status']/text(), 'Status')"/>)
              </xsl:when>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td valign="top"><xsl:value-of select="gsa:i18n ('Method', 'Alert')"/>:</td>
          <td>
            <table>
              <tr>
                <td colspan="3">
                  <xsl:choose>
                    <xsl:when test="method/text()='Send'">
                      <xsl:value-of select="gsa:i18n ('Send report to host', 'Alert')"/>
                    </xsl:when>
                    <xsl:when test="method/text()='Syslog' and method/data[name='submethod']/text() = 'SNMP'">
                      SNMP
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="gsa:i18n (method/text(), 'Alert')"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
              <xsl:choose>
                <xsl:when test="method/text()='Email'">
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('To Address', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='to_address']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='to_address']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('From Address', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='from_address']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='from_address']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Content', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="method/data[name='notice']/text() = '0'">
                          <xsl:value-of select="gsa:i18n ('Include report', 'Alert|Email')"/>
                          <xsl:variable name="id"
                                        select="method/data[name='notice_report_format']/text()"/>
                          <xsl:text> </xsl:text>
                          <xsl:choose>
                            <xsl:when test="boolean (../../get_report_formats_response/report_format[@id=$id])">
                              <xsl:value-of select="../../get_report_formats_response/report_format[@id=$id]/name"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:text>(</xsl:text>
                              <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                              <xsl:text>, </xsl:text>
                              <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>
                              <xsl:text>: </xsl:text>
                              <xsl:value-of select="$id"/>
                              <xsl:text>)</xsl:text>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:when test="method/data[name='notice']/text() = '2'">
                          <xsl:value-of select="gsa:i18n ('Attach report', 'Alert|Email')"/>
                          <xsl:variable name="id"
                                        select="method/data[name='notice_attach_format']/text()"/>
                          <xsl:text> </xsl:text>
                          <xsl:choose>
                            <xsl:when test="boolean (../../get_report_formats_response/report_format[@id=$id])">
                              <xsl:value-of select="../../get_report_formats_response/report_format[@id=$id]/name"/>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:text>(</xsl:text>
                              <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                              <xsl:text>, </xsl:text>
                              <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>
                              <xsl:text>: </xsl:text>
                              <xsl:value-of select="$id"/>
                              <xsl:text>)</xsl:text>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:value-of select="gsa:i18n ('Simple notice', 'Alert|Email')"/>
                        </xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Subject', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='subject']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='subject']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Message', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='message']/text()) &gt; 0">
                          <xsl:choose>
                            <xsl:when test="contains (method/data[name='message']/text(), '&#10;')">
                              <xsl:value-of select="substring-before (method/data[name='message']/text(), '&#10;')"/>
                              <xsl:text>...</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="method/data[name='message']/text()"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
                <xsl:when test="method/text()='HTTP Get'">
                  <tr>
                    <td width="45"></td>
                    <td>URL:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='URL']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='URL']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
                <xsl:when test="method/text()='Sourcefire Connector'">
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Defense Center IP', 'Alert')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='defense_center_ip']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='defense_center_ip']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Defense Center Port', 'Alert')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='defense_center_port']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='defense_center_port']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
                <xsl:when test="method/text()='verinice Connector'">
                  <tr>
                    <td width="45"></td>
                    <td>URL:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='verinice_server_url']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='verinice_server_url']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Username', 'Auth Data')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='verinice_server_username']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='verinice_server_username']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Report', 'Report')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='verinice_server_report_format']/text()) &gt; 0">
                          <xsl:variable name="id"
                                        select="method/data[name='verinice_server_report_format']/text()"/>
                          <xsl:value-of select="../../get_report_formats_response/report_format[@id=$id]/name"/>
                        </xsl:when>
                        <xsl:otherwise>
                          Verinice ISM
                        </xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
                <xsl:when test="method/text()='Send'">
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Host', 'Alert')"/>:</td>
                    <td><xsl:value-of select="method/data[name='send_host']/text()"/></td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Port', 'Alert')"/>:</td>
                    <td><xsl:value-of select="method/data[name='send_port']/text()"/></td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Report', 'Report')"/>:</td>
                    <td>
                      <xsl:variable name="id"
                                    select="method/data[name='send_report_format']/text()"/>
                      <xsl:choose>
                        <xsl:when test="string-length($id) &gt; 0 and boolean (../../get_report_formats_response/report_format[@id=$id])">
                          <a href="/omp?cmd=get_report_format&amp;report_format_id={$id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
                             title="{gsa:view_details_title ('Report Format', name)}">
                            <xsl:value-of select="../../get_report_formats_response/report_format[@id=$id]/name"/>
                          </a>
                        </xsl:when>
                        <xsl:when test="string-length($id) &gt; 0">
                          <xsl:value-of select="$id"/>
                        </xsl:when>
                        <xsl:otherwise>
                          XML
                        </xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
                <xsl:when test="method/text()='SCP'">
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Username', 'Alert|SCP')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='scp_username']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='scp_username']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Host', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='scp_host']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='scp_host']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Known Hosts', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:if test="string-length (method/data[name='scp_known_hosts']/text ()) &gt; 0">
                        <xsl:choose>
                          <xsl:when test="string-length (method/data[name='scp_known_hosts']/text ()) &gt; 40">
                            <xsl:choose>
                              <xsl:when test="contains (substring (method/data[name='scp_known_hosts']/text (), 0, 40), '&#10;')">
                                <xsl:value-of select="substring-before (substring (method/data[name='scp_known_hosts']/text (), 0, 40), '&#10;')"/>
                                <xsl:text>...</xsl:text>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="substring (method/data[name='scp_known_hosts']/text (), 0, 40)"/>
                                <xsl:text>...</xsl:text>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:when>
                          <xsl:when test="contains (method/data[name='scp_known_hosts']/text (), '&#10;')">
                            <xsl:value-of select="substring-before (method/data[name='scp_known_hosts']/text (), '&#10;')"/>
                            <xsl:text>...</xsl:text>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:value-of select="method/data[name='scp_known_hosts']/text()"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:if>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Path', 'Alert|Email')"/>:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='scp_path']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='scp_path']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td><xsl:value-of select="gsa:i18n ('Report', 'Report')"/>:</td>
                    <td>
                      <xsl:variable name="id"
                                    select="method/data[name='scp_report_format']/text()"/>
                      <xsl:choose>
                        <xsl:when test="string-length($id) &gt; 0 and boolean (../../get_report_formats_response/report_format[@id=$id])">
                          <a href="/omp?cmd=get_report_format&amp;report_format_id={$id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
                             title="{gsa:view_details_title ('Report Format', name)}">
                            <xsl:value-of select="../../get_report_formats_response/report_format[@id=$id]/name"/>
                          </a>
                        </xsl:when>
                        <xsl:when test="string-length($id) &gt; 0">
                          <xsl:value-of select="$id"/>
                        </xsl:when>
                        <xsl:otherwise>
                          XML
                        </xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
                <xsl:when test="method/text()='SNMP'">
                  <tr>
                    <td width="45"></td>
                    <td>Community:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='snmp_community']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='snmp_community']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td>Agent:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='snmp_agent']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='snmp_agent']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                  <tr>
                    <td width="45"></td>
                    <td>Message:</td>
                    <td>
                      <xsl:choose>
                        <xsl:when test="string-length(method/data[name='snmp_message']/text()) &gt; 0">
                          <xsl:value-of select="method/data[name='snmp_message']/text()"/>
                        </xsl:when>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:when>
              </xsl:choose>
            </table>
          </td>
        </tr>
        <xsl:if test="gsa:may-op ('get_filters') or string-length (filter/name) &gt; 0">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Filter', 'Filter')"/>:</td>
            <td>
              <xsl:choose>
                <xsl:when test="boolean (filter/permissions) and count (filter/permissions/permission) = 0">
                  <xsl:value-of select="filter/name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="filter/@id"/>)
                </xsl:when>
                <xsl:when test="string-length (filter/name) &gt; 0">
                  <xsl:choose>
                    <xsl:when test="gsa:may-op ('get_filters')">
                      <a href="/omp?cmd=get_filter&amp;filter_id={filter/@id}&amp;token={/envelope/token}"
                         title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <xsl:value-of select="filter/name"/>
                      </a>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="filter/name"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="gsa:i18n ('None', 'Alert|Filter')"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </xsl:if>
      </table>

      <xsl:choose>
        <xsl:when test="count(tasks/task) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Alert', 'Alert')"/>: <xsl:value-of select="gsa:i18n ('None', 'Tasks')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Alert', 'Alert')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="tasks/task">
              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                             border="0"
                             alt="{gsa:i18n ('Details', 'Generic Resource')}"
                             style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'alert'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'alert'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
      <xsl:if test="filter/@id != ''">
        <filter id="{filter/@id}"/>
      </xsl:if>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     GET_ALERT -->

<xsl:template match="get_alert">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_alert_response"/>
  <xsl:apply-templates select="commands_response/delete_alert_response"/>
  <xsl:apply-templates select="modify_alert_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="get_alerts_response/alert" mode="details"/>
</xsl:template>

<!--     GET_ALERTS_RESPONSE -->

<xsl:template match="get_alerts">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_alert_response"/>
  <xsl:apply-templates select="delete_alert_response"/>
  <xsl:apply-templates select="create_alert_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="test_alert_response"/>
  <xsl:apply-templates select="modify_alert_response"/>
  <!-- The for-each makes the get_alerts_response the current node. -->
  <xsl:for-each select="get_alerts_response | commands_response/get_alerts_response">
    <xsl:call-template name="html-alerts-table"/>
  </xsl:for-each>
</xsl:template>


<!-- BEGIN FILTERS MANAGEMENT -->

<xsl:template match="filters">
</xsl:template>

<xsl:template match="create_filter_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Filter</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="delete_filter_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Delete Filter</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="modify_filter_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Filter</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="filter">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Filter'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_filter&amp;filter_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Filter', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="term"/></td>
    <td><xsl:value-of select="gsa:i18n (type, 'Type')"/></td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Filter'"/>
            <xsl:with-param name="type" select="'filter'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="filter" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Filter'"/>
      </xsl:call-template>
      <b>
        <xsl:value-of select="name"/>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="term"/></td>
    <td><xsl:value-of select="gsa:i18n (type, 'Type')"/></td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'filter'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0"
               alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Filter is still in use', 'Filter')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="filter" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Filter Details', 'Filter')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Filter'"/>
        <xsl:with-param name="type" select="'filter'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Term', 'Filter')"/>:</td>
          <td><xsl:value-of select="term"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Type', 'Property')"/>:</td>
          <td><xsl:value-of select="gsa:i18n (type, 'Type')"/></td>
        </tr>
      </table>

      <xsl:choose>
        <xsl:when test="count(alerts/alert) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Alerts using this Filter', 'Filter')"/>: <xsl:value-of select="gsa:i18n ('None', 'Alerts')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Alerts using this Filter', 'Filter')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="alerts/alert">
              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_alert&amp;alert_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                             border="0"
                             alt="{gsa:i18n ('Details', 'Generic Resource')}"
                             style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'filter'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'filter'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-filters-trash-table">
  <div>
    <table class="gbntable" cellspacing="2" cellpadding="4" border="0">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Term', 'Filter')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Type', 'Property')"/></td>
        <td width="{$trash-actions-width}"><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:apply-templates select="filter" mode="trash"/>
    </table>
  </div>
</xsl:template>

<xsl:template name="html-filters-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'filter'"/>
    <xsl:with-param name="cap-type" select="'Filter'"/>
    <xsl:with-param name="resources-summary" select="filters"/>
    <xsl:with-param name="resources" select="filter"/>
    <xsl:with-param name="count" select="count (filter)"/>
    <xsl:with-param name="filtered-count" select="filter_count/filtered"/>
    <xsl:with-param name="full-count" select="filter_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Term', 'Filter')"/></name>
        <field>term</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Type', 'Property')"/></name>
        <field>type</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="4"/>
  </xsl:call-template>
</xsl:template>

<!-- NEW_FILTER -->

<xsl:template name="html-create-filter-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Filter', 'Filter')"/>
      <a href="/help/new_filter.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Filter', 'Filter'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_filters&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Filters', 'Filter')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Filters', 'Filter')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_filter"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_filter"/>
        <input type="hidden" name="filter_id" value="{/envelope/params/filter_id}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
            </td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Term', 'Filter')"/></td>
            <td>
              <input type="text" name="term" size="30" maxlength="1000"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Type', 'Property')"/></td>
            <td>
              <select name="optional_resource_type">
                <option value="">--</option>
                <xsl:for-each select="str:split ('Agent|Alert|Config|Credential|Filter|Note|Override|Permission|Port List|Report|Report Format|Result|Role|Schedule|Slave|Tag|Target|Task|SecInfo', '|')">
                  <option value="{.}"><xsl:value-of select="gsa:i18n(., 'Type')"/></option>
                </xsl:for-each>
              </select>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Filter', 'Filter')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_filter">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_filter_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:call-template name="html-create-filter-form"/>
</xsl:template>

<!--     EDIT_FILTER -->

<xsl:template name="html-edit-filter-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Filter', 'Filter')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Filter'"/>
        <xsl:with-param name="type" select="'filter'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_filters_response/filter/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_filter"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="filter_id"
               value="{commands_response/get_filters_response/filter/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text"
                     name="name"
                     value="{commands_response/get_filters_response/filter/name}"
                     size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{commands_response/get_filters_response/filter/comment}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Term', 'Filter')"/></td>
            <td>
              <input type="text" name="term"
                     value="{commands_response/get_filters_response/filter/term}"
                     size="50"
                     maxlength="1000"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Type', 'Property')"/></td>
            <td>
              <select name="optional_resource_type">
                <xsl:variable name="type">
                  <xsl:value-of select="commands_response/get_filters_response/filter/type"/>
                </xsl:variable>
                <option value="">--</option>
                <xsl:for-each select="str:split ('Agent|Alert|Config|Credential|Filter|Note|Override|Permission|Port List|Report|Report Format|Result|Role|Schedule|Slave|Tag|Target|Task|SecInfo', '|')">
                  <xsl:choose>
                    <xsl:when test=". = $type">
                      <option value="{.}" selected="1"><xsl:value-of select="gsa:i18n ($type, 'Type')"/></option>
                    </xsl:when>
                    <xsl:otherwise>
                      <option value="{.}"><xsl:value-of select="gsa:i18n (., 'Type')"/></option>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:for-each>
              </select>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Filter', 'Filter')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_filter">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_filter_response"/>
  <xsl:call-template name="html-edit-filter-form"/>
</xsl:template>

<!--     GET_FILTER -->

<xsl:template match="get_filter">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="get_filters_response/filter" mode="details"/>
</xsl:template>

<!--     GET_FILTERS -->

<xsl:template match="get_filters">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_filter_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <!-- The for-each makes the get_filters_response the current node. -->
  <xsl:for-each select="get_filters_response | commands_response/get_filters_response">
    <xsl:choose>
      <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
        <xsl:call-template name="command_result_dialog">
          <xsl:with-param name="operation">
            Get Filters
          </xsl:with-param>
          <xsl:with-param name="status">
            <xsl:value-of select="@status"/>
          </xsl:with-param>
          <xsl:with-param name="msg">
            <xsl:value-of select="@status_text"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="html-filters-table"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>


<!-- BEGIN TAGS MANAGEMENT -->

<xsl:template name="tagged_resource_link">
  <xsl:param name="resource_type"/>
  <xsl:param name="resource_id"/>
  <xsl:param name="resource_name"/>
  <xsl:param name="resource_location" select="0"/>
  <xsl:param name="resource_permissions"/>
  <xsl:param name="token"/>
  <xsl:choose>
    <xsl:when test="boolean ($resource_permissions) and count ($resource_permissions/permission) = 0">
      <xsl:value-of select="$resource_name"/>
    </xsl:when>
    <xsl:when test="$resource_type='cve' or $resource_type='cpe' or $resource_type='ovaldef' or $resource_type='cert_bund_adv' or $resource_type='dfn_cert_adv'">
      <xsl:choose>
        <xsl:when test="gsa:may-op ('get_info') and $resource_location = '0'">
          <a href="/omp?cmd=get_info&amp;info_type={$resource_type}&amp;info_id={$resource_id}&amp;details=1&amp;token={$token}">
            <xsl:value-of select="$resource_name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$resource_name"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$resource_type='nvt' and $resource_location = '0'">
      <a href="/omp?cmd=get_info&amp;info_type=nvt&amp;info_id={$resource_id}&amp;details=1&amp;token={$token}">
        <xsl:value-of select="$resource_name"/>
      </a>
    </xsl:when>
    <xsl:when test="$resource_type='nvt'">
      <xsl:value-of select="$resource_name"/>
    </xsl:when>
    <xsl:when test="gsa:may-op (concat ('get_', $resource_type, 's')) and $resource_location = '0'">
      <a href="/omp?cmd=get_{$resource_type}&amp;{$resource_type}_id={$resource_id}&amp;details=1&amp;token={$token}">
        <xsl:value-of select="$resource_name"/>
      </a>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$resource_name"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
    <xsl:when test="$resource_location != 0 and boolean ($resource_permissions) and count ($resource_permissions/permission) = 0">
      <xsl:text> (</xsl:text>
      <xsl:value-of select="gsa:i18n ('in ', 'Trashcan')"/>
      <xsl:value-of select="gsa:i18n ('trashcan', 'Trashcan')"/>
      <xsl:text>)</xsl:text>
    </xsl:when>
    <xsl:when test="$resource_location != 0">
      <xsl:text> (</xsl:text>
      <xsl:value-of select="gsa:i18n ('in ', 'Trashcan')"/><a href="/omp?cmd=get_trash&amp;token={/envelope/token}"><xsl:value-of select="gsa:i18n ('trashcan', 'Trashcan')"/></a>
      <xsl:text>)</xsl:text>
    </xsl:when>
    <xsl:otherwise/>
  </xsl:choose>
</xsl:template>

<xsl:template match="get_tags">
  <xsl:apply-templates select="gsad_msg"/>

  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>

  <!-- The for-each makes the get_targets_response the current node. -->
  <xsl:for-each select="get_tags_response | commands_response/get_tags_response">
    <xsl:choose>
      <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
        <xsl:call-template name="command_result_dialog">
          <xsl:with-param name="operation">
            Get Tags
          </xsl:with-param>
          <xsl:with-param name="status">
            <xsl:value-of select="@status"/>
          </xsl:with-param>
          <xsl:with-param name="msg">
            <xsl:value-of select="@status_text"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="html-tags-table"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template name="html-tags-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'tag'"/>
    <xsl:with-param name="cap-type" select="'Tag'"/>
    <xsl:with-param name="resources-summary" select="tags"/>
    <xsl:with-param name="resources" select="tag"/>
    <xsl:with-param name="count" select="count (tag)"/>
    <xsl:with-param name="filtered-count" select="tag_count/filtered"/>
    <xsl:with-param name="full-count" select="tag_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Value', 'Property')"/></name>
        <field>value</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Active', 'Tag')"/></name>
        <field>active</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Resource Type', 'Property')"/></name>
        <field>resource_type</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Resource Name', 'Property')"/></name>
        <field>resource_name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Modified', 'Date')"/></name>
        <field>modified</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="5"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="tag">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Tag'"/>
      </xsl:call-template>
      <a href="/omp?cmd=get_tag&amp;tag_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;first={../tags/@start}&amp;max={../tags/@max}&amp;token={/envelope/token}"
          title="{gsa:view_details_title ('Tag', name)}">
        <xsl:if test="orphan = 1"><b><xsl:value-of select="gsa:i18n ('Orphan', 'Tag')"/></b><br/></xsl:if>
        <xsl:value-of select="name"/>
      </a>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="value"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="active=0">
          <xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:i18n (gsa:type-name (resource/type), gsa:type-name (resource/type))"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="orphan='0'">
          <xsl:call-template name="tagged_resource_link">
            <xsl:with-param name="resource_type" select="resource/type"/>
            <xsl:with-param name="resource_id" select="resource/@id"/>
            <xsl:with-param name="resource_name" select="resource/name"/>
            <xsl:with-param name="resource_location" select="resource/trash"/>
            <xsl:with-param name="resource_permissions" select="resource/permissions"/>
            <xsl:with-param name="token" select="/envelope/token"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          <xsl:text> </xsl:text>
          <xsl:choose>
            <xsl:when test="resource/@id != ''">
              <i>(<xsl:value-of select="resource/@id"/>)</i>
            </xsl:when>
            <xsl:otherwise/>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:date (modification_time)"/>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="toggle-tag-icon">
            <xsl:with-param name="id" select="@id"/>
            <xsl:with-param name="enable" select="number(active=0)"/>
            <xsl:with-param name="params">
              <input type="hidden" name="next" value="get_tags"/>
              <input type="hidden" name="tag_id" value="{@id}"/>
              <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
              <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
            </xsl:with-param>
            <xsl:with-param name="fragment" select="'#user_tags'"/>
          </xsl:call-template>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Tag'"/>
            <xsl:with-param name="type" select="'tag'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="get_tag">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_tag_response"/>
  <xsl:apply-templates select="get_tags_response/tag" mode="details"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
</xsl:template>

<xsl:template match="tag" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Tag Details', 'Tag')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Tag'"/>
        <xsl:with-param name="type" select="'tag'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Value', 'Property')"/>:</td>
          <td><xsl:value-of select="value"/></td>
        </tr>
        <xsl:choose>
          <xsl:when test="resource/name != '' and orphan='0'">
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Attached to Resource', 'Tag')"/>:</td>
              <td>
                <xsl:choose>
                  <xsl:when test="boolean (resource/permissions) and count (resource/permissions/permission) = 0">
                    <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="resource/name"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="resource/@id"/>
                    <xsl:text>)</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="tagged_resource_link">
                      <xsl:with-param name="resource_type" select="resource/type"/>
                      <xsl:with-param name="resource_id" select="resource/@id"/>
                      <xsl:with-param name="resource_name" select="resource/name"/>
                      <xsl:with-param name="resource_location" select="resource/trash"/>
                      <xsl:with-param name="resource_permissions" select="resource/permissions"/>
                      <xsl:with-param name="token" select="/envelope/token"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </xsl:when>
        </xsl:choose>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Resource Type', 'Property')"/>:</td>
          <td><xsl:value-of select="gsa:i18n (gsa:type-name (resource/type), gsa:type-name (resource/type))"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Resource ID', 'Property')"/>:</td>
          <td><xsl:value-of select="resource/@id"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Active', 'Tag')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="active = 0"><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/></xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Orphan', 'Tag')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="orphan = 0"><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/></xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>
    </div>
  </div>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'tag'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="tag" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Tag'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="value"/></td>
    <td><xsl:value-of select="gsa:i18n (gsa:type-name (resource/type), gsa:type-name (resource/type))"/></td>
    <td>
      <xsl:choose>
        <xsl:when test="orphan='0'">
          <xsl:call-template name="tagged_resource_link">
            <xsl:with-param name="resource_type" select="resource/type"/>
            <xsl:with-param name="resource_id" select="resource/@id"/>
            <xsl:with-param name="resource_name" select="resource/name"/>
            <xsl:with-param name="resource_location" select="resource/trash"/>
            <xsl:with-param name="token" select="/envelope/token"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          <xsl:text> </xsl:text>
          <xsl:choose>
            <xsl:when test="resource/@id != ''">
              <i>(<xsl:value-of select="resource/@id"/>)</i>
            </xsl:when>
            <xsl:otherwise/>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'tag'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0"
               alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Tag is still in use', 'Tag')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template name="tag_resource_types">
  <xsl:param name="select_type"/>
  <xsl:if test="$select_type = 'agent' or gsa:may-op ('get_agents')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'agent'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Agent', 'Agent')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'alert' or gsa:may-op ('get_alerts')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'alert'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Alert', 'Alert')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'cpe' or gsa:may-op ('get_info')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'cpe'"/>
      <xsl:with-param name="content" select="gsa:i18n ('CPE', 'CPE')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'lsc_credential' or gsa:may-op ('get_lsc_credentials')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'lsc_credential'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Credential', 'Credential')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'cve' or gsa:may-op ('get_info')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'cve'"/>
      <xsl:with-param name="content" select="gsa:i18n ('CVE', 'CVE')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'cert_bund_adv' or gsa:may-op ('get_info')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'cert_bund_adv'"/>
      <xsl:with-param name="content" select="gsa:i18n ('CERT-Bund Advisory', 'CERT-Bund Advisory')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'dfn_cert_adv' or gsa:may-op ('get_info')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'dfn_cert_adv'"/>
      <xsl:with-param name="content" select="gsa:i18n ('DFN-CERT Advisory', 'DFN-CERT Advisory')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'filter' or gsa:may-op ('get_filters')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'filter'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Filter', 'Filter')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'group' or gsa:may-op ('get_groups')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'group'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Group', 'Group')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'note' or gsa:may-op ('get_notes')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'note'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Note', 'Note')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'nvt' or gsa:may-op ('get_info')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'nvt'"/>
      <xsl:with-param name="content" select="gsa:i18n ('NVT', 'NVT')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'ovaldef' or gsa:may-op ('get_info')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'ovaldef'"/>
      <xsl:with-param name="content" select="gsa:i18n ('OVAL Definition', 'OVAL Definition')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'override' or gsa:may-op ('get_overrides')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'override'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Override', 'Override')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'permission' or gsa:may-op ('get_permissions')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'permission'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Permission', 'Permission')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'port_list' or gsa:may-op ('get_port_lists')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'port_list'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Port List', 'Port List')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'report' or gsa:may-op ('get_reports')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'report'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Report', 'Report')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'report_format' or gsa:may-op ('get_report_formats')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'report_format'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Report Format', 'Report Format')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'result' or gsa:may-op ('get_results')">
      <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'result'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Result', 'Result')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'role' or gsa:may-op ('get_roles')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'role'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Role', 'Role')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'config' or gsa:may-op ('get_configs')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'config'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Scan Configuration', 'Scan Config')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'schedule' or gsa:may-op ('get_schedules')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'schedule'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Schedule', 'Schedule')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'slave' or gsa:may-op ('get_slaves')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'slave'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Slave', 'Slave')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'target' or gsa:may-op ('get_targets')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'target'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Target', 'Target')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'task' or gsa:may-op ('get_tasks')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'task'"/>
      <xsl:with-param name="content" select="gsa:i18n ('Task', 'Task')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
  <xsl:if test="$select_type = 'user' or gsa:may-op ('get_users')">
    <xsl:call-template name="opt">
      <xsl:with-param name="value" select="'user'"/>
      <xsl:with-param name="content" select="gsa:i18n ('User', 'User')"/>
      <xsl:with-param name="select-value" select="$select_type"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template match="new_tag">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="commands_response/delete_tag_response"/>
  <xsl:call-template name="html-create-tag-form"/>
  <!-- <xsl:call-template name="html-import-tag-form"/> -->
</xsl:template>

<xsl:template name="html-create-tag-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Tag', 'Tag')"/>
      <a href="/help/new_tag.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Tag', 'Tag'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_tags&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Tags', 'Tag')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Tags', 'Tag')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_tag"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <xsl:if test="/envelope/params/next_type!=''">
          <xsl:if test="/envelope/params/next_id != ''">
            <xsl:choose>
              <xsl:when test="/envelope/params/next_type='nvt'">
                <input type="hidden"
                       name="oid"
                       value="{/envelope/params/next_id}"/>
              </xsl:when>
              <xsl:otherwise>
                <input type="hidden"
                       name="{/envelope/params/next_type}_id"
                       value="{/envelope/params/next_id}"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="/envelope/params/next_type='info'">
              <input type="hidden"
                    name="details"
                    value="1"/>
            </xsl:if>
          </xsl:if>
          <xsl:if test="/envelope/params/next_subtype != ''">
            <input type="hidden"
                   name="{/envelope/params/next_type}_type"
                   value="{/envelope/params/next_subtype}"/>
          </xsl:if>
        </xsl:if>
        <xsl:if test="/envelope/params/report_section">
          <input type="hidden" name="report_section" value="{/envelope/params/report_section}"/>
        </xsl:if>
        <input type="hidden" name="filter" value="{filters/term}"/>
        <input type="hidden" name="first" value="{/envelope/params/start}"/>
        <input type="hidden" name="max" value="{/envelope/params/max}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
            </td>
            <td>
              <input type="text" name="tag_name" value="{tag_name}" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" value="{comment}" size="30"
                     maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Value', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)
            </td>
            <td>
              <input type="text" name="tag_value" value="{tag_value}" size="30"
                     maxlength="200"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Resource Type', 'Property')"/></td>
            <td>
              <select name="resource_type">
                <xsl:call-template name="tag_resource_types">
                  <xsl:with-param name="select_type">
                    <xsl:value-of select="resource_type"/>
                  </xsl:with-param>
                </xsl:call-template>
              </select>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Resource ID', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="resource_id" value="{resource_id}" size="30"
                         maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Active', 'Tag')"/></td>
            <td>
              <label>
                <xsl:choose>
                  <xsl:when test="active!=0">
                    <input type="radio" name="active" value="1" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="active" value="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
              </label>
              <label>
                <xsl:choose>
                  <xsl:when test="active=0">
                    <input type="radio" name="active" value="0" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="active" value="0"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
              </label>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Tag', 'Tag')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="create_tag_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Tag</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="edit_tag">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:call-template name="html-edit-tag-form"/>
</xsl:template>

<xsl:template name="html-edit-tag-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Tag', 'Tag')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Tag'"/>
        <xsl:with-param name="type" select="'tag'"/>
        <xsl:with-param name="id"
                        select="get_tags_response/tag/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_tag"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="tag_id"
               value="{get_tags_response/tag/@id}"/>
        <xsl:if test="/envelope/params/next_type!=''">
          <xsl:if test="/envelope/params/next_id != ''">
            <xsl:choose>
              <xsl:when test="/envelope/params/next_type='nvt'">
                <input type="hidden"
                       name="oid"
                       value="{/envelope/params/next_id}"/>
              </xsl:when>
              <xsl:otherwise>
                <input type="hidden"
                       name="{/envelope/params/next_type}_id"
                       value="{/envelope/params/next_id}"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:if test="/envelope/params/next_type='info'">
              <input type="hidden"
                    name="details"
                    value="1"/>
            </xsl:if>
          </xsl:if>
          <xsl:if test="/envelope/params/next_subtype != ''">
            <input type="hidden"
                   name="{/envelope/params/next_type}_type"
                   value="{/envelope/params/next_subtype}"/>
          </xsl:if>
        </xsl:if>
        <xsl:if test="/envelope/params/report_section != ''">
          <input type="hidden"
                  name="report_section"
                  value="{/envelope/params/report_section}"/>
        </xsl:if>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="sort_field" value="{sort_field}"/>
        <input type="hidden" name="sort_order" value="{sort_order}"/>
        <input type="hidden" name="filter" value="{filters/term}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <input type="hidden" name="first" value="{limits/@start}"/>
        <input type="hidden" name="max" value="{limits/@max}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
            </td>
            <td>
              <input type="text" name="tag_name" value="{get_tags_response/tag/name}" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" value="{get_tags_response/tag/comment}" size="30"
                     maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Value', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)
            </td>
            <td>
              <input type="text" name="tag_value" value="{get_tags_response/tag/value}" size="30"
                     maxlength="200"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Resource Type', 'Property')"/></td>
            <td>
              <select name="resource_type">
                <xsl:call-template name="tag_resource_types">
                  <xsl:with-param name="select_type">
                    <xsl:value-of select="get_tags_response/tag/resource/type"/>
                  </xsl:with-param>
                </xsl:call-template>
              </select>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Resource ID', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="resource_id" value="{get_tags_response/tag/resource/@id}" size="30"
                         maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Active', 'Tag')"/></td>
            <td>
              <label>
                <xsl:choose>
                  <xsl:when test="get_tags_response/tag/active!=0">
                    <input type="radio" name="active" value="1" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="active" value="1"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
              </label>
              <label>
                <xsl:choose>
                  <xsl:when test="get_tags_response/tag/active=0">
                    <input type="radio" name="active" value="0" checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="active" value="0"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
              </label>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Tag', 'Tag')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="modify_tag_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Tag</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="delete_tag_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Delete Tag</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="get_tags_response"/>


<!-- BEGIN TARGETS MANAGEMENT -->

<xsl:template match="modify_target_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Target</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="port_list" mode="select">
  <xsl:param name="select_id" select="''"/>
  <xsl:choose>
    <xsl:when test="@id = $select_id">
      <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
    </xsl:when>
    <xsl:otherwise>
      <option value="{@id}"><xsl:value-of select="name"/></option>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="html-create-target-form">
  <xsl:param name="lsc-credentials"></xsl:param>
  <xsl:param name="port-lists"></xsl:param>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Target', 'Target')"/>
      <a href="/help/new_target.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Target', 'Target'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_targets&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Targets', 'Target')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Targets', 'Target')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_target"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_target"/>
        <input type="hidden" name="filter" value="{filters/term}"/>
        <input type="hidden" name="first" value="{targets/@start}"/>
        <input type="hidden" name="max" value="{targets/@max}"/>
        <xsl:if test="not (gsa:may-op ('get_lsc_credentials'))">
          <input type="hidden" name="lsc_credential_id" value="--"/>
        </xsl:if>
        <xsl:if test="not (gsa:may-op ('get_lsc_credentials'))">
          <input type="hidden" name="lsc_credential_id" value="--"/>
          <input type="hidden" name="lsc_smb_credential_id" value="--"/>
        </xsl:if>
        <xsl:if test="not (gsa:may-op ('get_port_lists'))">
          <!-- Use port list "OpenVAS Default". -->
          <input type="hidden"
                 name="port_list_id"
                 value="c7e03b6c-3bbe-11e1-a057-406186ea4fc5"/>
        </xsl:if>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
            </td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/></td>
            <td>
              <table>
                <tr>
                  <td>
                    <label>
                      <input type="radio" name="target_source" value="manual"
                             checked="1"/>
                      <xsl:value-of select="gsa:i18n ('Manual', 'Target')"/>
                    </label>
                  </td>
                  <td>
                    <input type="text" name="hosts" value="localhost" size="30"
                            maxlength="2000"/>
                  </td>
                </tr>
                <tr>
                  <td>
                    <label>
                      <input type="radio" name="target_source" value="file"/>
                      <xsl:value-of select="gsa:i18n ('From file', 'Target')"/>
                    </label>
                  </td>
                  <td>
                    <input type="file" name="file" size="30"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Exclude Hosts', 'Target')"/></td>
            <td>
              <input type="text" name="exclude_hosts" value="" size="30"
                      maxlength="2000"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Reverse Lookup Only', 'Target')"/></td>
            <td>
              <label>
                <input type="radio" name="reverse_lookup_only" value="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
              </label>
              <label>
                <input type="radio" name="reverse_lookup_only" value="0"
                       checked="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
              </label>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Reverse Lookup Unify', 'Target')"/></td>
            <td>
              <label>
                <input type="radio" name="reverse_lookup_unify" value="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
              </label>
              <label>
                <input type="radio" name="reverse_lookup_unify" value="0"
                       checked="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
              </label>
            </td>
          </tr>
          <xsl:if test="gsa:may-op ('get_port_lists')">
            <tr>
              <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Port List', 'Port List')"/></td>
              <td>
                <select name="port_list_id">
                  <xsl:apply-templates select="$port-lists" mode="select">
                    <xsl:with-param name="select_id" select="port_list_id"/>
                  </xsl:apply-templates>
                </select>
              </td>
            </tr>
          </xsl:if>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Alive Test', 'Target')"/></td>
            <td>
              <select name="alive_tests">
                <option value="Scan Config Default"><xsl:value-of select="gsa:i18n ('Scan Config Default', 'Target')"/></option>
                <option value="ICMP Ping">ICMP Ping</option>
                <option value="TCP-ACK Service Ping">TCP-ACK Service Ping</option>
                <option value="TCP-SYN Service Ping">TCP-SYN Service Ping</option>
                <option value="ARP Ping">ARP Ping</option>
                <option value="ICMP &amp; TCP-ACK Service Ping">ICMP &amp; TCP-ACK Service Ping</option>
                <option value="ICMP &amp; ARP Ping">ICMP &amp; ARP Ping</option>
                <option value="TCP-ACK Service &amp; ARP Ping">TCP-ACK Service &amp; ARP Ping</option>
                <option value="ICMP, TCP-ACK Service &amp; ARP Ping">ICMP, TCP-ACK Service &amp; ARP Ping</option>
                <option value="Consider Alive">Consider Alive</option>
              </select>
            </td>
          </tr>
          <xsl:if test="gsa:may-op ('get_lsc_credentials')">
            <tr>
              <td valign="top" width="175" colspan="2">
                <xsl:value-of select="gsa:i18n ('Credentials for authenticated checks', 'Target')"/>
                (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>):
              </td>
            </tr>
            <tr>
              <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('SSH', 'Target|Credential')"/></td>
              <td>
                <select name="lsc_credential_id">
                  <option value="--">--</option>
                  <xsl:apply-templates select="$lsc-credentials" mode="select">
                    <xsl:with-param name="select_id" select="lsc_credential_id"/>
                  </xsl:apply-templates>
                </select>
                <xsl:text> </xsl:text>
                <xsl:value-of select="gsa:i18n ('on port', 'Target|Credential')"/>
                <xsl:text> </xsl:text>
                <input type="text" name="port" value="22" size="6"
                       maxlength="400"/>
              </td>
            </tr>
            <tr>
              <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('SMB', 'Target|Credential')"/></td>
              <td>
                <select name="lsc_smb_credential_id">
                  <option value="--">--</option>
                  <xsl:apply-templates select="$lsc-credentials" mode="select">
                    <xsl:with-param name="select_id" select="lsc_smb_credential_id"/>
                  </xsl:apply-templates>
                </select>
              </td>
            </tr>
            <tr>
              <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('ESXi', 'Target|Credential')"/></td>
              <td>
                <select name="lsc_esxi_credential_id">
                  <option value="--">--</option>
                  <xsl:apply-templates select="$lsc-credentials" mode="select">
                    <xsl:with-param name="select_id" select="lsc_esxi_credential_id"/>
                  </xsl:apply-templates>
                </select>
              </td>
            </tr>
          </xsl:if>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Target', 'Target')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template name="html-edit-target-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Target', 'Target')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Target'"/>
        <xsl:with-param name="type" select="'target'"/>
        <xsl:with-param name="id"
                        select="get_targets_response/target/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_target"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="target_id"
               value="{get_targets_response/target/@id}"/>
        <input type="hidden" name="next" value="{next}"/>
        <input type="hidden" name="sort_field" value="{sort_field}"/>
        <input type="hidden" name="sort_order" value="{sort_order}"/>
        <input type="hidden" name="filter" value="{filters/term}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <input type="hidden" name="first" value="{targets/@start}"/>
        <input type="hidden" name="max" value="{targets/@max}"/>
        <input type="hidden" name="in_use" value="{get_targets_response/target/in_use}"/>
        <xsl:if test="not (gsa:may-op ('get_lsc_credentials'))">
          <input type="hidden" name="lsc_credential_id" value="--"/>
          <input type="hidden" name="lsc_smb_credential_id" value="--"/>
          <input type="hidden" name="lsc_esxi_credential_id" value="--"/>
        </xsl:if>
        <xsl:if test="not (gsa:may-op ('get_port_lists'))">
          <!-- Use port list "OpenVAS Default". -->
          <input type="hidden"
                 name="port_list_id"
                 value="c7e03b6c-3bbe-11e1-a057-406186ea4fc5"/>
        </xsl:if>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text"
                     name="name"
                     value="{get_targets_response/target/name}"
                     size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{get_targets_response/target/comment}"/>
            </td>
          </tr>
          <xsl:choose>
            <xsl:when test="get_targets_response/target/in_use = '0'">
              <tr>
                <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/></td>
                <td>
                  <table>
                    <tr>
                      <td>
                        <label>
                          <input type="radio" name="target_source" value="manual"
                                 checked="1"/>
                          <xsl:value-of select="gsa:i18n ('Manual', 'Target')"/>
                        </label>
                      </td>
                      <td>
                        <input type="text" name="hosts"
                               value="{get_targets_response/target/hosts}"
                               size="30"
                               maxlength="2000"/>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <label>
                          <input type="radio" name="target_source" value="file"/>
                          <xsl:value-of select="gsa:i18n ('From file', 'Target')"/>
                        </label>
                      </td>
                      <td>
                        <input type="file" name="file" size="30"/>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr>
                <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Exclude Hosts', 'Target')"/></td>
                <td>
                  <input type="text" name="exclude_hosts"
                         value="{get_targets_response/target/exclude_hosts}"
                         size="30" maxlength="2000"/>
                </td>
              </tr>
              <tr>
                <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Reverse Lookup Only', 'Target')"/></td>
                <td>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_only = '1'">
                        <input type="radio" name="reverse_lookup_only" value="1" checked="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_only" value="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_only = '0'">
                        <input type="radio" name="reverse_lookup_only" value="0" checked="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_only" value="0"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                </td>
              </tr>
              <tr>
                <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Reverse Lookup Unify', 'Target')"/></td>
                <td>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_unify = '1'">
                        <input type="radio" name="reverse_lookup_unify" value="1" checked="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_unify" value="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_unify = '0'">
                        <input type="radio" name="reverse_lookup_unify" value="0" checked="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_unify" value="0"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                </td>
              </tr>
              <xsl:if test="gsa:may-op ('get_port_lists')">
                <tr>
                  <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Port List', 'Port List')"/></td>
                  <td>
                    <select name="port_list_id">
                      <xsl:variable name="port_list_id">
                        <xsl:value-of select="get_targets_response/target/port_list/@id"/>
                      </xsl:variable>
                      <xsl:for-each select="get_port_lists_response/port_list">
                        <xsl:choose>
                          <xsl:when test="@id = $port_list_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                  </td>
                </tr>
              </xsl:if>
              <tr>
                <td><xsl:value-of select="gsa:i18n ('Alive Test', 'Target')"/></td>
                <td>
                  <xsl:variable name="alive_tests" select="get_targets_response/target/alive_tests/text()"/>
                  <select name="alive_tests">
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'Scan Config Default'"/>
                      <xsl:with-param name="content" select="gsa:i18n ('Scan Config Default', 'Target')"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'TCP-ACK Service Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'TCP-SYN Service Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP &amp; TCP-ACK Service Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP &amp; ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'TCP-ACK Service &amp; ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP, TCP-ACK Service &amp; ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'Consider Alive'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                  </select>
                </td>
              </tr>
              <xsl:if test="gsa:may-op ('get_lsc_credentials')">
                <tr>
                  <td valign="top" width="175" colspan="2">
                    <xsl:value-of select="gsa:i18n ('Credentials for authenticated checks', 'Target')"/>
                    (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>):
                  </td>
                </tr>
                <tr>
                  <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('SSH', 'Target|Credential')"/></td>
                  <td>
                    <select name="lsc_credential_id">
                      <xsl:variable name="lsc_credential_id">
                        <xsl:value-of select="get_targets_response/target/ssh_lsc_credential/@id"/>
                      </xsl:variable>
                      <xsl:choose>
                        <xsl:when test="string-length ($lsc_credential_id) &gt; 0">
                          <option value="0">--</option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="0" selected="1">--</option>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:for-each select="get_lsc_credentials_response/lsc_credential">
                        <xsl:choose>
                          <xsl:when test="@id = $lsc_credential_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="gsa:i18n ('on port', 'Target|Credential')"/>
                    <xsl:text> </xsl:text>
                    <xsl:variable name="credential"
                                  select="get_targets_response/target/ssh_lsc_credential"/>
                    <xsl:choose>
                      <xsl:when test="$credential and string-length ($credential/port)">
                        <input type="text"
                               name="port"
                               value="{get_targets_response/target/ssh_lsc_credential/port}"
                               size="6"
                               maxlength="400"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="text" name="port" value="22" size="6" maxlength="400"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
                <tr>
                  <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('SMB', 'Target|Credential')"/></td>
                  <td>
                    <select name="lsc_smb_credential_id">
                      <xsl:variable name="lsc_credential_id">
                        <xsl:value-of select="get_targets_response/target/smb_lsc_credential/@id"/>
                      </xsl:variable>
                      <xsl:choose>
                        <xsl:when test="string-length ($lsc_credential_id) &gt; 0">
                          <option value="0">--</option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="0" selected="1">--</option>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:for-each select="get_lsc_credentials_response/lsc_credential">
                        <xsl:choose>
                          <xsl:when test="@id = $lsc_credential_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('ESXi', 'Target|Credential')"/></td>
                  <td>
                    <select name="lsc_esxi_credential_id">
                      <xsl:variable name="lsc_credential_id">
                        <xsl:value-of select="get_targets_response/target/esxi_lsc_credential/@id"/>
                      </xsl:variable>
                      <xsl:choose>
                        <xsl:when test="string-length ($lsc_credential_id) &gt; 0">
                          <option value="0">--</option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="0" selected="1">--</option>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:for-each select="get_lsc_credentials_response/lsc_credential">
                        <xsl:choose>
                          <xsl:when test="@id = $lsc_credential_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                  </td>
                </tr>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <xsl:variable name="width" select="240"/>
              <!-- Target is in use. -->
              <tr>
                <td valign="top" width="{$width}">
                  <xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)
                </td>
                <td>
                  <table>
                    <tr>
                      <td>
                        <label>
                          <input type="radio" name="target_source" value="manual"
                                 checked="1" disabled="1"/>
                          <xsl:value-of select="gsa:i18n ('Manual', 'Target')"/>
                        </label>
                      </td>
                      <td>
                        <input type="text" name="hosts"
                               value="{get_targets_response/target/hosts}"
                               size="30"
                               maxlength="2000"
                               disabled="1"/>
                      </td>
                    </tr>
                    <tr>
                      <td>
                        <label>
                          <input type="radio" name="target_source" value="file" disabled="1"/>
                          <xsl:value-of select="gsa:i18n ('From file', 'Target')"/>
                        </label>
                      </td>
                      <td>
                        <input type="file" name="file" size="30" disabled="1"/>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr>
                <td valign="top" width="{$width}">
                  <xsl:value-of select="gsa:i18n ('Exclude Hosts', 'Target')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)
                </td>
                <td>
                  <input type="text" name="exclude_hosts"
                         value="{get_targets_response/target/exclude_hosts}"
                         size="30" maxlength="2000"
                         disabled="1"/>
                </td>
              </tr>
              <tr>
                <td valign="top" width="{$width}">
                  <xsl:value-of select="gsa:i18n ('Reverse Lookup Only', 'Target')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)
                </td>
                <td>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_only = '1'">
                        <input type="radio" name="reverse_lookup_only" value="1" checked="1" disabled="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_only" value="1" disabled="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_only = '0'">
                        <input type="radio" name="reverse_lookup_only" value="0" checked="1" disabled="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_only" value="0" disabled="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                </td>
              </tr>
              <tr>
                <td valign="top" width="{$width}">
                  <xsl:value-of select="gsa:i18n ('Reverse Lookup Unify', 'Target')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)
                </td>
                <td>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_unify = '1'">
                        <input type="radio" name="reverse_lookup_unify" value="1" checked="1" disabled="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_unify" value="1" disabled="1"/><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_targets_response/target/reverse_lookup_unify = '0'">
                        <input type="radio" name="reverse_lookup_unify" value="0" checked="1" disabled="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="reverse_lookup_unify" value="0" disabled="1"/><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                </td>
              </tr>
              <xsl:if test="gsa:may-op ('get_port_lists')">
                <tr>
                  <td valign="top" width="{$width}">
                    <xsl:value-of select="gsa:i18n ('Port List', 'Port List')"/> (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>)
                  </td>
                  <td>
                    <select name="port_list_id" disabled="1">
                      <option>
                        <xsl:value-of select="get_targets_response/target/port_list/name"/>
                      </option>
                    </select>
                  </td>
                </tr>
              </xsl:if>
              <tr>
                <td><xsl:value-of select="gsa:i18n ('Alive Test', 'Target')"/></td>
                <td>
                  <xsl:variable name="alive_tests" select="get_targets_response/target/alive_tests/text()"/>
                  <select name="alive_tests">
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'Scan Config Default'"/>
                      <xsl:with-param name="content" select="gsa:i18n ('Scan Config Default', 'Target')"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'TCP-ACK Service Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'TCP-SYN Service Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP &amp; TCP-ACK Service Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP &amp; ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'TCP-ACK Service &amp; ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'ICMP, TCP-ACK Service &amp; ARP Ping'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                    <xsl:call-template name="opt">
                      <xsl:with-param name="value" select="'Consider Alive'"/>
                      <xsl:with-param name="select-value" select="$alive_tests"/>
                    </xsl:call-template>
                  </select>
                </td>
              </tr>
              <xsl:if test="gsa:may-op ('get_lsc_credentials')">
                <tr>
                  <td valign="top" width="175" colspan="2">
                    <xsl:value-of select="gsa:i18n ('Credentials for authenticated checks', 'Target')"/>
                    (<xsl:value-of select="gsa:i18n ('immutable', 'Meta Property')"/>):
                  </td>
                </tr>
                <tr>
                  <td valign="top" width="{$width}">
                    <xsl:value-of select="gsa:i18n ('SSH', 'Target|Credential')"/>
                  </td>
                  <td>
                    <select name="lsc_credential_id" disabled="1">
                      <xsl:variable name="lsc_credential_id">
                        <xsl:value-of select="get_targets_response/target/ssh_lsc_credential/@id"/>
                      </xsl:variable>
                      <xsl:choose>
                        <xsl:when test="string-length ($lsc_credential_id) &gt; 0">
                          <option value="0">--</option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="0" selected="1">--</option>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:for-each select="get_lsc_credentials_response/lsc_credential">
                        <xsl:choose>
                          <xsl:when test="@id = $lsc_credential_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                    <xsl:text> </xsl:text>
                    <xsl:value-of select="gsa:i18n ('on port', 'Target|Credential')"/>
                    <xsl:text> </xsl:text>
                    <xsl:variable name="credential"
                                  select="get_targets_response/target/ssh_lsc_credential"/>
                    <xsl:choose>
                      <xsl:when test="$credential and string-length ($credential/port)">
                        <input type="text"
                               name="port"
                               value="{get_targets_response/target/ssh_lsc_credential/port}"
                               size="6"
                               maxlength="400"
                               disabled="1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="text" name="port" value="22" size="6" maxlength="400" disabled="1"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
                <tr>
                  <td valign="top" width="{$width}">
                    <xsl:value-of select="gsa:i18n ('SMB', 'Target|Credential')"/>
                  </td>
                  <td>
                    <select name="lsc_smb_credential_id" disabled="1">
                      <xsl:variable name="lsc_credential_id">
                        <xsl:value-of select="get_targets_response/target/smb_lsc_credential/@id"/>
                      </xsl:variable>
                      <xsl:choose>
                        <xsl:when test="string-length ($lsc_credential_id) &gt; 0">
                          <option value="0">--</option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="0" selected="1">--</option>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:for-each select="get_lsc_credentials_response/lsc_credential">
                        <xsl:choose>
                          <xsl:when test="@id = $lsc_credential_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                  </td>
                </tr>
                <tr>
                  <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('ESXi', 'Target|Credential')"/></td>
                  <td>
                    <select name="lsc_esxi_credential_id" disabled="1">
                      <xsl:variable name="lsc_credential_id">
                        <xsl:value-of select="get_targets_response/target/esxi_lsc_credential/@id"/>
                      </xsl:variable>
                      <xsl:choose>
                        <xsl:when test="string-length ($lsc_credential_id) &gt; 0">
                          <option value="0">--</option>
                        </xsl:when>
                        <xsl:otherwise>
                          <option value="0" selected="1">--</option>
                        </xsl:otherwise>
                      </xsl:choose>
                      <xsl:for-each select="get_lsc_credentials_response/lsc_credential">
                        <xsl:choose>
                          <xsl:when test="@id = $lsc_credential_id">
                            <option value="{@id}" selected="1"><xsl:value-of select="name"/></option>
                          </xsl:when>
                          <xsl:otherwise>
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:for-each>
                    </select>
                  </td>
                </tr>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Target', 'Target')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_target">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_target_response"/>
  <xsl:call-template name="html-edit-target-form"/>
</xsl:template>

<xsl:template name="column-name">
  <xsl:param name="type">target</xsl:param>
  <xsl:param name="head"/>
  <xsl:param name="image"/>
  <xsl:param name="name"/>
  <xsl:param name="current" select="."/>
  <xsl:param name="extra_params"/>
  <xsl:param name="sort-reverse"/>
  <xsl:param name="token" select="/envelope/token"/>
  <xsl:variable name="heading">
    <xsl:choose>
      <xsl:when test="image">
        <img src="{$image}"
             alt="{$head}"
             title="{$head}"/>
      </xsl:when>
      <xsl:when test="contains ($head, '.png')">
        <img src="/img/{$head}"
             alt="{gsa:capitalise (str:replace (gsa:lower-case ($name), '_', ' '))}"
             title="{gsa:capitalise (str:replace (gsa:lower-case ($name), '_', ' '))}"/>
      </xsl:when>
      <xsl:when test="$head = 'High' or $head = 'Medium' or $head = 'Low' or $head = 'Log' or $head = 'False Positive'">
        <xsl:call-template name="severity-label">
          <xsl:with-param name="level" select="translate($head, '_', ' ')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$head"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$current/sort/field/text() = $name and $current/sort/field/order = 'descending'">
      <a class="gbntablehead2" href="/omp?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=sort={$name} first=1 {$current/filters/term}&amp;token={$token}"><xsl:copy-of select="$heading"/></a>
    </xsl:when>
    <xsl:when test="$current/sort/field/text() = $name and $current/sort/field/order = 'ascending'">
      <a class="gbntablehead2" href="/omp?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=sort-reverse={$name} first=1 {$current/filters/term}&amp;token={$token}"><xsl:copy-of select="$heading"/></a>
    </xsl:when>
    <xsl:when test="$name = ''">
      <!-- Starts with some other column. -->
      <xsl:copy-of select="$heading"/>
    </xsl:when>
    <xsl:when test="$sort-reverse">
      <!-- Starts with some other column.  Include reverse sorting link. -->
      <a class="gbntablehead2" href="/omp?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=sort-reverse={$name} first=1 {$current/filters/term}&amp;token={$token}"><xsl:copy-of select="$heading"/></a>
    </xsl:when>
    <xsl:otherwise>
      <!-- Starts with some other column.  Include sorting link. -->
      <a class="gbntablehead2" href="/omp?cmd=get_{gsa:type-many($type)}{$extra_params}&amp;filter=sort={$name} first=1 {$current/filters/term}&amp;token={$token}"><xsl:copy-of select="$heading"/></a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="html-targets-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'target'"/>
    <xsl:with-param name="cap-type" select="'Target'"/>
    <xsl:with-param name="resources-summary" select="targets"/>
    <xsl:with-param name="resources" select="target"/>
    <xsl:with-param name="count" select="count (target)"/>
    <xsl:with-param name="filtered-count" select="target_count/filtered"/>
    <xsl:with-param name="full-count" select="target_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Hosts', 'Host')"/></name>
        <field>hosts</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('IPs', 'Target')"/></name>
        <field>ips</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Port List', 'Port List')"/></name>
        <field>port_list</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Credentials', 'Credential')"/></name>
        <column>
          <name><xsl:value-of select="gsa:i18n('SSH', 'Target|Credential')"/></name>
          <field>ssh_credential</field>
        </column>
        <column>
          <name><xsl:value-of select="gsa:i18n('SMB', 'Target|Credential')"/></name>
          <field>smb_credential</field>
        </column>
        <column>
          <name><xsl:value-of select="gsa:i18n('ESXi', 'Target|Credential')"/></name>
          <field>esxi_credential</field>
        </column>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="4"/>
  </xsl:call-template>
</xsl:template>

<!--     NEW_TARGET -->

<xsl:template match="new_target">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_target_response"/>
  <xsl:apply-templates select="create_target_response"/>
  <xsl:call-template name="html-create-target-form">
    <xsl:with-param
      name="lsc-credentials"
      select="get_lsc_credentials_response | commands_response/get_lsc_credentials_response"/>
    <xsl:with-param
      name="port-lists"
      select="get_port_lists_response | commands_response/get_port_lists_response"/>
  </xsl:call-template>
</xsl:template>

<!--     CREATE_TARGET_RESPONSE -->

<xsl:template match="create_target_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Target</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     DELETE_TARGET_RESPONSE -->

<xsl:template match="delete_target_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Target
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     TARGET -->

<xsl:template match="target">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Target'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_target&amp;target_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;first={../targets/@start}&amp;max={../targets/@max}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Target', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:variable name="max" select="500"/>
      <xsl:choose>
        <xsl:when test="string-length(hosts) &gt; $max">
          <xsl:value-of select="substring (hosts, 0, $max)"/>...
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="hosts"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="max_hosts"/></td>
    <td>
      <xsl:choose>
        <xsl:when test="gsa:may-op ('get_port_lists')">
          <a href="/omp?cmd=get_port_list&amp;port_list_id={port_list/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="port_list/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="port_list/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="boolean (ssh_lsc_credential/permissions) and count (ssh_lsc_credential/permissions/permission) = 0">
          <xsl:value-of select="ssh_lsc_credential/name"/>
        </xsl:when>
        <xsl:when test="gsa:may-op ('get_lsc_credentials')">
          <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={ssh_lsc_credential/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="ssh_lsc_credential/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="ssh_lsc_credential/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="boolean (smb_lsc_credential/permissions) and count (smb_lsc_credential/permissions/permission) = 0">
          <xsl:value-of select="smb_lsc_credential/name"/>
        </xsl:when>
        <xsl:when test="gsa:may-op ('get_lsc_credentials')">
          <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={smb_lsc_credential/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="smb_lsc_credential/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="smb_lsc_credential/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="boolean (esxi_lsc_credential/permissions) and count (esxi_lsc_credential/permissions/permission) = 0">
          <xsl:value-of select="esxi_lsc_credential/name"/>
        </xsl:when>
        <xsl:when test="gsa:may-op ('get_lsc_credentials')">
          <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={esxi_lsc_credential/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="esxi_lsc_credential/name"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="esxi_lsc_credential/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Target'"/>
            <xsl:with-param name="type" select="'target'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="target" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Target'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="hosts"/></td>
    <td><xsl:value-of select="max_hosts"/></td>
    <td>
      <xsl:choose>
        <xsl:when test="port_list/trash = '1'">
          <xsl:value-of select="port_list/name"/>
          <br/>(<xsl:value-of select="gsa:i18n ('in trashcan', 'Trashcan')"/>)
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=get_port_list&amp;port_list_id={port_list/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="port_list/name"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="ssh_lsc_credential/trash = '1'">
          <xsl:value-of select="ssh_lsc_credential/name"/>
          <br/>(<xsl:value-of select="gsa:i18n ('in trashcan', 'Trashcan')"/>)
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={ssh_lsc_credential/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="ssh_lsc_credential/name"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="smb_lsc_credential/trash = '1'">
          <xsl:value-of select="smb_lsc_credential/name"/>
          <br/>(<xsl:value-of select="gsa:i18n ('in trashcan', 'Trashcan')"/>)
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={smb_lsc_credential/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="smb_lsc_credential/name"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="esxi_lsc_credential/trash = '1'">
          <xsl:value-of select="esxi_lsc_credential/name"/>
          <br/>(<xsl:value-of select="gsa:i18n ('in trashcan', 'Trashcan')"/>)
        </xsl:when>
        <xsl:otherwise>
          <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={esxi_lsc_credential/@id}&amp;token={/envelope/token}">
            <xsl:value-of select="esxi_lsc_credential/name"/>
          </a>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="not (gsa:may-op ('restore'))"/>
        <xsl:when test="ssh_lsc_credential/trash = '1' or smb_lsc_credential/trash = '1' or port_list/trash = '1'">
          <xsl:variable name="resources_string">
            <xsl:if test="ssh_lsc_credential/trash = '1' or smb_lsc_credential/trash = '1'"><xsl:value-of select="gsa:i18n ('Credentials', 'Credential')"/></xsl:if>
            <xsl:if test="(ssh_lsc_credential/trash = '1' or smb_lsc_credential/trash = '1') and port_list/trash = '1'">
              <xsl:text> </xsl:text><xsl:value-of select="gsa:i18n ('and', 'List Conjunction')"/><xsl:text> </xsl:text>
            </xsl:if>
            <xsl:if test="port_list/trash = '1'"><xsl:value-of select="gsa:i18n ('Port List', 'Port List')"/></xsl:if>
            <xsl:value-of select="gsa:i18n (' must be restored first.', 'Action Message')"/>
          </xsl:variable>
          <img src="/img/restore_inactive.png" border="0" alt="{gsa:i18n ('Restore', 'Action Verb')}" title="{$resources_string}"
               style="margin-left:3px;"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="restore-icon">
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'target'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0"
               alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Target is still in use', 'Target')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="target" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Target Details', 'Target')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Target'"/>
        <xsl:with-param name="type" select="'target'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/>:</td>
          <td><xsl:value-of select="hosts"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Exclude Hosts', 'Target')"/>:</td>
          <td><xsl:value-of select="exclude_hosts"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Reverse Lookup Only', 'Target')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="reverse_lookup_only = 1"><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/></xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Reverse Lookup Unify', 'Target')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="reverse_lookup_unify = 1"><xsl:value-of select="gsa:i18n ('Yes', 'Binary Choice')"/></xsl:when>
              <xsl:otherwise><xsl:value-of select="gsa:i18n ('No', 'Binary Choice')"/></xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Maximum number of hosts', 'Target')"/>:</td>
          <td><xsl:value-of select="max_hosts"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Port List', 'Port List')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="gsa:may-op ('get_port_lists')">
                <xsl:choose>
                  <xsl:when test="boolean (port_list/permissions) and count (port_list/permissions/permission) = 0">
                    <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="port_list/name"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="port_list/@id"/>
                    <xsl:text>)</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <a href="/omp?cmd=get_port_list&amp;port_list_id={port_list/@id}&amp;token={/envelope/token}">
                      <xsl:value-of select="port_list/name"/>
                    </a>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="port_list/name"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Alive Test', 'Target')"/>:</td>
          <td>
            <xsl:value-of select="gsa:i18n (alive_tests/text(), 'Target')"/>
          </td>
        </tr>
        <xsl:if test="gsa:may-op ('get_lsc_credentials') or string-length (ssh_lsc_credential/@id) &gt; 0">
          <tr>
            <td valign="top" width="175" colspan="2">
              <xsl:value-of select="gsa:i18n ('Credentials for authenticated checks', 'Target')"/>:
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('SSH', 'Target|Credential')"/>:</td>
            <td>
              <xsl:if test="string-length (ssh_lsc_credential/@id) &gt; 0">
                <xsl:choose>
                  <xsl:when test="boolean (ssh_lsc_credential/permissions) and count (ssh_lsc_credential/permissions/permission) = 0">
                    <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                    <xsl:text> (</xsl:text>
                    <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                    <xsl:text>: </xsl:text>
                    <xsl:value-of select="ssh_lsc_credential/name"/>
                    <xsl:text>, </xsl:text>
                    <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="ssh_lsc_credential/@id"/>
                    <xsl:text>)</xsl:text>
                  </xsl:when>
                  <xsl:when test="gsa:may-op ('get_lsc_credentials')">
                    <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={ssh_lsc_credential/@id}&amp;token={/envelope/token}">
                      <xsl:value-of select="ssh_lsc_credential/name"/>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="ssh_lsc_credential/name"/>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:text> </xsl:text>
                <xsl:value-of select="gsa:i18n ('on port', 'Target|Credential')"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="ssh_lsc_credential/port"/>
              </xsl:if>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="gsa:may-op ('get_lsc_credentials') or string-length (smb_lsc_credential/@id) &gt; 0">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('SMB', 'Target|Credential')"/>:</td>
            <td>
              <xsl:choose>
                <xsl:when test="boolean (smb_lsc_credential/permissions) and count (smb_lsc_credential/permissions/permission) = 0">
                  <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                  <xsl:text> (</xsl:text>
                  <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                  <xsl:text>: </xsl:text>
                  <xsl:value-of select="smb_lsc_credential/name"/>
                  <xsl:text>, </xsl:text>
                  <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="smb_lsc_credential/@id"/>
                  <xsl:text>)</xsl:text>
                </xsl:when>
                <xsl:when test="gsa:may-op ('get_lsc_credentials')">
                  <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={smb_lsc_credential/@id}&amp;token={/envelope/token}">
                    <xsl:value-of select="smb_lsc_credential/name"/>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="smb_lsc_credential/name"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="gsa:may-op ('get_lsc_credentials') or string-length (esxi_lsc_credential/@id) &gt; 0">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('ESXi', 'Target|Credential')"/>:</td>
            <td>
              <xsl:choose>
                <xsl:when test="boolean (esxi_lsc_credential/permissions) and count (esxi_lsc_credential/permissions/permission) = 0">
                  <xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>
                  <xsl:text> (</xsl:text>
                  <xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
                  <xsl:text>: </xsl:text>
                  <xsl:value-of select="esxi_lsc_credential/name"/>
                  <xsl:text>, </xsl:text>
                  <xsl:value-of select="gsa:i18n ('ID', 'Property')"/>: <xsl:value-of select="esxi_lsc_credential/@id"/>
                  <xsl:text>)</xsl:text>
                </xsl:when>
                <xsl:when test="gsa:may-op ('get_lsc_credentials')">
                  <a href="/omp?cmd=get_lsc_credential&amp;lsc_credential_id={esxi_lsc_credential/@id}&amp;token={/envelope/token}">
                    <xsl:value-of select="esxi_lsc_credential/name"/>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="esxi_lsc_credential/name"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </xsl:if>
      </table>

      <xsl:choose>
        <xsl:when test="count(tasks/task) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Target', 'Target')"/>: <xsl:value-of select="gsa:i18n ('None', 'Tasks')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Target', 'Target')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="tasks/task">
              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                             border="0"
                             alt="{gsa:i18n ('Details', 'Generic Resource')}"
                             style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'target'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'target'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
      <xsl:if test="port_list/@id != ''">
        <port_list id="{port_list/@id}"/>
      </xsl:if>
      <xsl:if test="ssh_lsc_credential/@id != ''">
        <lsc_credential id="{ssh_lsc_credential/@id}"/>
      </xsl:if>
      <xsl:if test="smb_lsc_credential/@id != '' and smb_lsc_credential/@id != ssh_lsc_credential/@id">
        <lsc_credential id="{smb_lsc_credential/@id}"/>
      </xsl:if>
      <xsl:if test="esxi_lsc_credential/@id != '' and esxi_lsc_credential/@id != ssh_lsc_credential/@id and esxi_lsc_credential/@id != smb_lsc_credential/@id">
        <lsc_credential id="{esxi_lsc_credential/@id}"/>
      </xsl:if>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     GET_TARGET -->

<xsl:template match="get_target">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_target_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="get_targets_response/target" mode="details"/>
</xsl:template>

<!--     GET_TARGETS -->

<xsl:template match="get_targets">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_target_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_target_response"/>
  <!-- The for-each makes the get_targets_response the current node. -->
  <xsl:for-each select="get_targets_response | commands_response/get_targets_response">
    <xsl:choose>
      <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
        <xsl:call-template name="command_result_dialog">
          <xsl:with-param name="operation">
            Get Targets
          </xsl:with-param>
          <xsl:with-param name="status">
            <xsl:value-of select="@status"/>
          </xsl:with-param>
          <xsl:with-param name="msg">
            <xsl:value-of select="@status_text"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="html-targets-table"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>


<!-- BEGIN CONFIGS MANAGEMENT -->

<xsl:template name="html-create-config-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('New Scan Config', 'Scan Config')"/>
      <a href="/help/new_config.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Scan Config', 'Scan Config'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_configs&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Scan Configs', 'Scan Config')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Configs', 'Scan Config')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_config"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_config"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Base', 'Scan Config')"/></td>
            <td>
              <table>
                <tr>
                  <td colspan="2">
                    <label>
                      <input type="radio" name="base"
                             value="085569ce-73ed-11df-83c3-002264764cea"
                             checked="1"/>
                      <xsl:value-of select="gsa:i18n ('Empty, static and fast', 'Scan Config')"/>
                    </label>
                  </td>
                </tr>
                <tr>
                  <td colspan="2">
                    <label>
                      <input type="radio" name="base"
                             value="daba56c8-73ec-11df-a475-002264764cea"/>
                      <xsl:value-of select="gsa:i18n ('Full and fast', 'Scan Config')"/>
                    </label>
                  </td>
                </tr>
                <xsl:if test="get_scanners_response/scanner[type != '2']">
                  <tr>
                    <td colspan="2">
                      <label>
                        <input type="radio" name="base" value="0"/>
                        <select name="scanner_id">
                          <xsl:for-each select="get_scanners_response/scanner[type != '2']">
                            <option value="{@id}"><xsl:value-of select="name"/></option>
                          </xsl:for-each>
                        </select>
                      </label>
                    </td>
                  </tr>
                </xsl:if>
              </table>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Scan Config', 'Scan Config')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template name="html-import-config-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Import Scan Config', 'Scan Config')"/>
      <a href="/help/new_config.html?token={/envelope/token}#importconfig"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Import Scan Config', 'Scan Config'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_configs&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Scan Configs', 'Scan Config')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Configs', 'Scan Config')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="import_config"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_config"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Import XML config', 'Scan Config')"/>
            </td>
            <td><input type="file" name="xml_file" size="30"/></td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n('Import Scan Config', 'Scan Config')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_config">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_config_response"/>
  <xsl:apply-templates select="commands_response/delete_config_response"/>
  <xsl:call-template name="html-create-config-form"/>
  <xsl:call-template name="html-import-config-form"/>
</xsl:template>

<xsl:template name="html-config-family-table">
 <div class="gb_window">
  <div class="gb_window_part_left"></div>
  <div class="gb_window_part_right"></div>
  <div class="gb_window_part_center">
    <xsl:choose>
      <xsl:when test="edit">
        <xsl:value-of select="gsa:i18n ('Edit Scan Config Family', 'Scan Config')"/>
        <a href="/help/config_editor_nvt_families.html?token={/envelope/token}"
           title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Scan Configs', 'Scan Config'),' (',gsa:i18n('Edit Scan Config Family', 'Scan Config'),')')}">
          <img src="/img/help.png"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="gsa:i18n ('Scan Config Family Details', 'Scan Config')"/>
        <a href="/help/config_family_details.html?token={/envelope/token}"
           title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Scan Configs', 'Scan Config'),' (',gsa:i18n('Scan Config Family Details', 'Scan Config'),')')}">
          <img src="/img/help.png"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="edit">
        <a href="?cmd=edit_config&amp;config_id={config/@id}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Scan Config', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Config', 'Scan Config')}"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <a href="?cmd=get_config&amp;config_id={config/@id}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Scan Config', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Config', 'Scan Config')}"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </div>
  <div class="gb_window_part_content">
    <xsl:variable name="config_id" select="config/@id"/>
    <xsl:variable name="config_name" select="config/name"/>
    <xsl:variable name="family" select="config/family"/>

    <table>
    <tr><td><xsl:value-of select="gsa:i18n ('Config', 'Scan Config')"/>:</td><td><xsl:value-of select="$config_name"/></td></tr>
    <tr><td><b><xsl:value-of select="gsa:i18n ('Family', 'Scan Config')"/>:</b></td><td><b><xsl:value-of select="$family"/></b></td></tr>
    </table>

    <xsl:choose>
      <xsl:when test="edit">
        <h1><xsl:value-of select="gsa:i18n ('Edit Network Vulnerability Tests', 'Scan Config')"/></h1>
      </xsl:when>
      <xsl:otherwise>
        <h1><xsl:value-of select="gsa:i18n ('Network Vulnerability Tests', 'Scan Config')"/></h1>
      </xsl:otherwise>
    </xsl:choose>

    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <td><xsl:value-of select="gsa:i18n ('OID', 'NVT')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Timeout', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Prefs', 'Scan Config')"/></td>
        <xsl:if test="edit">
          <td><xsl:value-of select="gsa:i18n ('Selected', 'Scan Config')"/></td>
        </xsl:if>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:choose>
        <xsl:when test="edit">
          <form action="" method="post" enctype="multipart/form-data">
            <input type="hidden" name="token" value="{/envelope/token}"/>
            <input type="hidden" name="cmd" value="save_config_family"/>
            <input type="hidden" name="caller" value="{/envelope/current_page}"/>
            <input type="hidden" name="config_id" value="{$config_id}"/>
            <input type="hidden" name="name" value="{$config_name}"/>
            <input type="hidden" name="family" value="{$family}"/>
            <xsl:for-each select="all/get_nvts_response/nvt" >
              <xsl:variable name="current_name" select="name/text()"/>
              <xsl:variable name="id" select="@oid"/>

              <tr class="{gsa:table-row-class(position())}">
                <td><xsl:value-of select="$current_name"/></td>
                <td>
                  <xsl:value-of select="@oid"/>
                </td>
                <td>
                  <xsl:call-template name="severity-bar">
                    <xsl:with-param name="cvss" select="cvss_base"/>
                  </xsl:call-template>
                </td>
                <td>
                  <xsl:variable
                    name="timeout"
                    select="../../../get_nvts_response/nvt[@oid=$id]/timeout"/>
                  <xsl:choose>
                    <xsl:when test="string-length($timeout) &gt; 0">
                      <xsl:value-of select="$timeout"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="gsa:i18n ('default', 'Scan Config')"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
                <td style="text-align:center;">
                  <xsl:choose>
                    <xsl:when test="preference_count&gt;0">
                      <xsl:value-of select="preference_count"/>
                    </xsl:when>
                    <xsl:otherwise>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
                <td style="text-align:center;">
                  <xsl:choose>
                    <xsl:when test="../../../get_nvts_response/nvt[@oid=$id]">
                      <input type="checkbox" name="nvt:{@oid}" value="1"
                             checked="1"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="checkbox" name="nvt:{@oid}" value="1"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
                <td>
                  <a href="/omp?cmd=get_config_nvt&amp;oid={@oid}&amp;config_id={$config_id}&amp;name={$config_name}&amp;family={$family}&amp;token={/envelope/token}"
                     title="{gsa:i18n ('NVT Details', 'NVT')}" style="margin-left:3px;">
                    <img src="/img/details.png" border="0" alt="{gsa:i18n ('Details', 'Generic Resource')}"/>
                  </a>
                  <a href="/omp?cmd=edit_config_nvt&amp;oid={@oid}&amp;config_id={$config_id}&amp;name={$config_name}&amp;family={$family}&amp;token={/envelope/token}"
                     title="{gsa:i18n ('Select and Edit NVT Details', 'Scan Config')}"
                     style="margin-left:3px;">
                    <img src="/img/edit.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"/>
                  </a>
                </td>
              </tr>
            </xsl:for-each>
            <tr>
              <td>
                <xsl:value-of select="gsa:i18n ('Total', 'NVTs')"/>:
                <xsl:value-of select="count(all/get_nvts_response/nvt)"/>
              </td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td></td>
              <td>
                <xsl:value-of select="gsa:i18n ('Total', 'NVTs')"/>:
                <xsl:value-of select="count(get_nvts_response/nvt)"/>
              </td>
              <td></td>
            </tr>
            <tr>
              <td colspan="8" style="text-align:right;">
                <input type="submit"
                       name="submit"
                       value="{gsa:i18n ('Save Config', 'Scan Config')}"
                       title="{gsa:i18n ('Save Config', 'Scan Config')}"/>
              </td>
            </tr>
          </form>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="get_nvts_response/nvt" >
            <xsl:variable name="current_name" select="name/text()"/>

            <tr class="{gsa:table-row-class(position())}">
              <td><xsl:value-of select="$current_name"/></td>
              <td>
                <xsl:value-of select="@oid"/>
              </td>
              <td>
                <xsl:call-template name="severity-bar">
                  <xsl:with-param name="cvss" select="cvss_base"/>
                </xsl:call-template>
              </td>
              <td>
                <xsl:choose>
                  <xsl:when test="string-length(timeout) &gt; 0">
                    <xsl:value-of select="timeout"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="gsa:i18n ('default', 'Scan Config')"/>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td style="text-align:center;">
                <xsl:choose>
                  <xsl:when test="preference_count&gt;0">
                    <xsl:value-of select="preference_count"/>
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
              <td>
                <a href="/omp?cmd=get_config_nvt&amp;oid={@oid}&amp;config_id={$config_id}&amp;name={$config_name}&amp;family={$family}&amp;token={/envelope/token}"
                   title="{gsa:i18n ('NVT Details', 'NVT')}" style="margin-left:3px;">
                  <img src="/img/details.png" border="0" alt="{gsa:i18n ('Details', 'Generic Resource')}"/>
                </a>
              </td>
            </tr>
          </xsl:for-each>
          <tr>
            <td>
              <xsl:value-of select="gsa:i18n ('Total', 'NVTs')"/>:
              <xsl:value-of select="count(get_nvts_response/nvt)"/>
            </td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
    </table>
  </div>
 </div>
</xsl:template>

<!--     CONFIG PREFERENCES -->

<xsl:template name="preference" match="preference">
  <xsl:param name="config_id"></xsl:param>
  <xsl:param name="config_name"></xsl:param>
  <xsl:param name="edit"></xsl:param>

  <tr class="{gsa:table-row-class(position())}">
    <td><xsl:value-of select="nvt/name"/></td>
    <td><xsl:value-of select="name"/></td>
    <td>
      <xsl:choose>
        <xsl:when test="type='file' and string-length(value) &gt; 0">
          <i><xsl:value-of select="gsa:i18n ('File attached.', 'Scan Config')"/></i>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="value"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:if test="string-length($config_id) &gt; 0">
        <a href="/omp?cmd=get_config_nvt&amp;oid={nvt/@oid}&amp;config_id={$config_id}&amp;name={$config_name}&amp;family={nvt/family}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Scan Config NVT Details', 'Scan Config')}" style="margin-left:3px;">
          <img src="/img/details.png" border="0" alt="{gsa:i18n ('Details', 'Generic Resource')}"/>
        </a>
      </xsl:if>
      <xsl:if test="string-length($edit) &gt; 0">
        <a href="/omp?cmd=edit_config_nvt&amp;oid={nvt/@oid}&amp;config_id={$config_id}&amp;name={$config_name}&amp;family={nvt/family}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Edit Scan Config NVT Details', 'Scan Config')}" style="margin-left:3px;">
          <img src="/img/edit.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"/>
        </a>
      </xsl:if>
      <xsl:if test="type='file' and string-length(value) &gt; 0">
        <a href="/omp?cmd=export_preference_file&amp;config_id={$config_id}&amp;oid={nvt/@oid}&amp;preference_name={name}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Export File', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export File', 'Scan Config')}"/>
        </a>
      </xsl:if>
    </td>
  </tr>
</xsl:template>

<xsl:template name="preference-details" match="preference" mode="details">
  <xsl:param name="config" select=".."/>

  <tr class="{gsa:table-row-class(position())}">
    <td><xsl:value-of select="name"/></td>
    <xsl:if test="$config != ''">
      <td>
        <xsl:choose>
          <xsl:when test="type='osp_boolean' and value = '0'">False</xsl:when>
          <xsl:when test="type='osp_boolean'">True</xsl:when>
          <xsl:when test="type='file' and string-length(value) &gt; 0">
            <i><xsl:value-of select="gsa:i18n ('File attached.', 'Scan Config')"/></i>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="value"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </xsl:if>
    <td>
      <xsl:choose>
        <xsl:when test="type='file' and string-length(value) &gt; 0">
          <i><xsl:value-of select="gsa:i18n ('File attached.', 'Scan Config')"/></i>
        </xsl:when>
        <xsl:when test="type='osp_ovaldef_file'">OVAL Definitions files list.</xsl:when>
        <xsl:when test="type='osp_selection'">List.</xsl:when>
        <xsl:when test="type='osp_boolean' and default = '0'">False</xsl:when>
        <xsl:when test="type='osp_boolean'">True</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="default"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:if test="type='file' and string-length(value) &gt; 0">
        <a href="/omp?cmd=export_preference_file&amp;config_id={$config/@id}&amp;oid={nvt/@oid}&amp;preference_name={name}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Export File', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export File', 'Scan Config')}"/>
        </a>
      </xsl:if>
    </td>
  </tr>
</xsl:template>

<xsl:template match="preference"
              name="edit-config-preference"
              mode="edit-details">
  <xsl:param name="config"></xsl:param>
  <xsl:param name="for_config_details"></xsl:param>
  <xsl:param name="family"></xsl:param>
  <xsl:param name="nvt"></xsl:param>

  <tr class="{gsa:table-row-class(position())}">
    <xsl:if test="$for_config_details">
      <td><xsl:value-of select="nvt/name"/></td>
    </xsl:if>
    <td><xsl:value-of select="name"/></td>
    <td>
      <xsl:choose>

        <!-- OSP config types. -->
        <xsl:when test="type='osp_ovaldef_file' or type='osp_selection'">
          <xsl:variable name="value">
            <xsl:value-of select="value"/>
          </xsl:variable>
          <select name="osp_pref_{name}">
            <xsl:for-each select="str:split (default, '|')">
              <xsl:call-template name="opt">
                <xsl:with-param name="value" select="."/>
                <xsl:with-param name="select-value" select="$value"/>
              </xsl:call-template>
            </xsl:for-each>
          </select>
        </xsl:when>
        <xsl:when test="type='osp_integer'">
          <input type="text" name="osp_pref_{name}"
                 value="{value}" size="30" maxlength="400"/>
        </xsl:when>
        <xsl:when test="type='osp_string'">
          <input type="text" name="osp_pref_{name}"
                 value="{value}" size="30" maxlength="400"/>
        </xsl:when>
        <xsl:when test="type='osp_file'">
          <input type="file" name="osp_pref_{name}" value="{value}"/>
        </xsl:when>
        <xsl:when test="type='osp_boolean'">
          <select name="osp_pref_{name}">
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'1'"/>
              <xsl:with-param name="content" select="'True'"/>
              <xsl:with-param name="select-value" select="value"/>
            </xsl:call-template>
            <xsl:call-template name="opt">
              <xsl:with-param name="value" select="'0'"/>
              <xsl:with-param name="content" select="'False'"/>
              <xsl:with-param name="select-value" select="value"/>
            </xsl:call-template>
          </select>
        </xsl:when>

        <!-- Classic config types. -->
        <xsl:when test="type='checkbox'">
          <xsl:choose>
            <xsl:when test="value='yes'">
              <label>
                <input type="radio" name="preference:{nvt/name}[checkbox]:{name}"
                       value="yes" checked="1"/>
                yes
              </label>
              <label>
                <input type="radio" name="preference:{nvt/name}[checkbox]:{name}"
                       value="no"/>
                no
              </label>
            </xsl:when>
            <xsl:otherwise>
              <label>
                <input type="radio" name="preference:{nvt/name}[checkbox]:{name}"
                       value="yes"/>
                yes
              </label>
              <label>
                <input type="radio" name="preference:{nvt/name}[checkbox]:{name}"
                       value="no" checked="1"/>
                no
              </label>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="type='password'">
          <label>
            <input type="checkbox" name="password:{nvt/name}[password]:{name}"
                   value="yes"/>
            <xsl:value-of select="gsa:i18n ('Replace existing value with', 'Auth Data|Password')"/>:
          </label>
          <br/>
          <input type="password" autocomplete="off"
                 name="preference:{nvt/name}[password]:{name}"
                 value="{value}" size="30" maxlength="40"/>
        </xsl:when>
        <xsl:when test="type='file'">
          <label>
            <input type="checkbox" name="file:{nvt/name}[file]:{name}"
                   value="yes"/>
            <xsl:choose>
              <xsl:when test="string-length(value) &gt; 0">
                <xsl:value-of select="gsa:i18n ('Replace existing file with', 'Scan Config')"/>:
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Upload file', 'Scan Config')"/>:
              </xsl:otherwise>
            </xsl:choose>
          </label>
          <br/>
          <input type="file" name="preference:{nvt/name}[file]:{name}" size="30"/>
        </xsl:when>
        <xsl:when test="type='entry'">
          <input type="text" name="preference:{nvt/name}[entry]:{name}"
                 value="{value}" size="30" maxlength="400"/>
        </xsl:when>
        <xsl:when test="type='radio'">
          <label>
            <input type="radio" name="preference:{nvt/name}[radio]:{name}"
                   value="{value}" checked="1"/>
            <xsl:value-of select="value"/>
          </label>
          <xsl:for-each select="alt">
            <br/>
            <label>
              <input type="radio"
                     name="preference:{../nvt/name}[radio]:{../name}"
                     value="{text()}"/>
              <xsl:value-of select="."/>
            </label>
          </xsl:for-each>
        </xsl:when>
        <xsl:when test="type=''">
          <xsl:choose>
            <xsl:when test="name='ping_hosts' or name='reverse_lookup' or name='unscanned_closed' or name='nasl_no_signature_check' or name='ping_hosts' or name='reverse_lookup' or name='unscanned_closed' or name='auto_enable_dependencies' or name='kb_dont_replay_attacks' or name='kb_dont_replay_denials' or name='kb_dont_replay_info_gathering' or name='kb_dont_replay_scanners' or name='kb_restore' or name='log_whole_attack' or name='only_test_hosts_whose_kb_we_dont_have' or name='only_test_hosts_whose_kb_we_have' or name='optimize_test' or name='safe_checks' or name='save_knowledge_base' or name='silent_dependencies' or name='slice_network_addresses' or name='use_mac_addr' or name='drop_privileges' or name='network_scan'">
              <xsl:choose>
                <xsl:when test="value='yes'">
                  <label>
                    <input type="radio" name="preference:scanner[scanner]:{name}"
                           value="yes" checked="1"/>
                    yes
                  </label>
                  <label>
                    <input type="radio" name="preference:scanner[scanner]:{name}"
                           value="no"/>
                    no
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="preference:scanner[scanner]:{name}"
                           value="yes"/>
                    yes
                  </label>
                  <label>
                    <input type="radio" name="preference:scanner[scanner]:{name}"
                           value="no" checked="1"/>
                    no
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <input type="text"
                     name="preference:scanner[scanner]:{name}"
                     value="{value}"
                     size="30"
                     maxlength="400"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <input type="text"
                 name="preference:{nvt/name}[{type}]:{name}"
                 value="{value}"
                 size="30"
                 maxlength="400"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="type = 'osp_boolean' and value = '0'">False</xsl:when>
        <xsl:when test="type = 'osp_boolean'">True</xsl:when>
        <xsl:when test="type = 'osp_file'">
          <xsl:if test="string-length(value) &gt; 0">Uploaded file</xsl:if>
        </xsl:when>
        <xsl:when test="substring (type, 1, 4) ='osp_'">
          <xsl:value-of select="value"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="default"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:if test="$for_config_details">
        <a href="/omp?cmd=edit_config_nvt&amp;oid={nvt/@oid}&amp;config_id={$config/@id}&amp;family={$family}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Edit NVT Details', 'Scan Config')}" style="margin-left:3px;">
          <img src="/img/edit.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"/>
        </a>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="$config and type='file' and (string-length(value) &gt; 0)">
          <a href="/omp?cmd=export_preference_file&amp;config_id={$config/@id}&amp;oid={nvt/@oid}&amp;preference_name={name}&amp;token={/envelope/token}"
             title="{gsa:i18n ('Export File', 'Scan Config')}"
             style="margin-left:3px;">
            <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export File', 'Scan Config')}"/>
          </a>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="preferences" name="preferences">
  <xsl:param name="config_id"></xsl:param>
  <xsl:param name="config_name"></xsl:param>
  <xsl:param name="edit"></xsl:param>
  <div id="preferences">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('NVT', 'NVT')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Value', 'Property')"/></td>
        <td width="{gsa:actions-width (1)}"><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:for-each select="preference[string-length(./nvt)&gt;0]">
        <xsl:call-template name="preference">
          <xsl:with-param name="config_id" select="$config_id"/>
          <xsl:with-param name="config_name" select="$config_name"/>
          <xsl:with-param name="edit" select="$edit"/>
        </xsl:call-template>
      </xsl:for-each>
    </table>
  </div>
</xsl:template>

<xsl:template name="preferences-details" match="preferences" mode="details">
  <xsl:param name="config"></xsl:param>
  <div id="preferences">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <xsl:if test="$config != ''">
          <td><xsl:value-of select="gsa:i18n ('Current Value', 'Scan Config')"/></td>
        </xsl:if>
        <td><xsl:value-of select="gsa:i18n ('Default Value', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>

      <!-- Special case the NVT timeout. -->
      <tr class="even">
        <td><xsl:value-of select="gsa:i18n ('Timeout', 'Scan Config')"/></td>
        <td>
          <xsl:choose>
            <xsl:when test="string-length(timeout) &gt; 0">
              <xsl:value-of select="timeout"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n ('default', 'Scan Config')"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <xsl:if test="$config != ''">
          <td><xsl:value-of select="gsa:i18n ('default', 'Scan Config')"/></td>
        </xsl:if>
        <td></td>
      </tr>

      <xsl:for-each select="preference">
        <xsl:call-template name="preference-details">
          <xsl:with-param name="config" select="$config"/>
        </xsl:call-template>
      </xsl:for-each>
    </table>
  </div>
</xsl:template>

<xsl:template name="preferences-edit-details">
  <xsl:param name="config"></xsl:param>
  <div id="preferences">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <td><xsl:value-of select="gsa:i18n ('New Value', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Default Value', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>

      <!-- Special case the NVT timeout. -->
      <tr class="even">
        <td><xsl:value-of select="gsa:i18n ('Timeout', 'Scan Config')"/></td>
        <td>
          <label>
            <xsl:choose>
              <xsl:when test="string-length(timeout) &gt; 0">
                <input type="radio"
                       name="timeout"
                       value="0"/>
              </xsl:when>
              <xsl:otherwise>
                <input type="radio"
                       name="timeout"
                       value="0"
                       checked="1"/>
              </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="gsa:i18n ('Apply default timeout', 'Scan Config')"/>
          </label>
          <br/>
          <xsl:choose>
            <xsl:when test="string-length(timeout) &gt; 0">
              <input type="radio"
                     name="timeout"
                     value="1"
                     checked="1"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="radio"
                     name="timeout"
                     value="1"/>
            </xsl:otherwise>
          </xsl:choose>
          <input type="text"
                 name="preference:scanner[scanner]:timeout.{../@oid}"
                 value="{timeout}"
                 size="30"
                 maxlength="400"/>
          <br/>
        </td>
        <td></td>
        <td></td>
      </tr>

      <xsl:for-each select="preference">
        <xsl:call-template name="edit-config-preference">
          <xsl:with-param name="config" select="$config"/>
        </xsl:call-template>
      </xsl:for-each>

      <tr>
        <td colspan="4" style="text-align:right;">
          <input type="submit"
                 name="submit"
                 value="{gsa:i18n ('Save Config', 'Scan Config')}"
                 title="{gsa:i18n ('Save Config', 'Scan Config')}"/>
        </td>
      </tr>
    </table>
  </div>
</xsl:template>

<xsl:template match="preferences" mode="scanner">
  <div id="preferences">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Current Value', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Default Value', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:apply-templates
        select="preference[string-length(nvt)=0]"
        mode="details"/>
    </table>
  </div>
</xsl:template>

<xsl:template match="preferences" mode="edit-scanner-details">
  <div id="preferences">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
        <td><xsl:value-of select="gsa:i18n ('New Value', 'Scan Config')"/></td>
        <xsl:choose>
          <xsl:when test="../type != 1">
            <td><xsl:value-of select="gsa:i18n ('Default', 'Value')"/></td>
          </xsl:when>
          <xsl:otherwise>
            <td><xsl:value-of select="gsa:i18n ('Value', 'Property')"/></td>
          </xsl:otherwise>
        </xsl:choose>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:apply-templates
        select="preference[string-length(nvt)=0]"
        mode="edit-details"/>
      <tr>
        <td colspan="4" style="text-align:right;">
          <input type="submit"
                 name="submit"
                 value="{gsa:i18n ('Save Config', 'Scan Config')}"
                 title="{gsa:i18n ('Save Config', 'Scan Config')}"/>
        </td>
      </tr>
    </table>
  </div>
</xsl:template>

<!--     CONFIG NVTS -->

<xsl:template name="html-config-nvt-table">
 <xsl:variable name="family">
   <xsl:value-of select="get_nvts_response/nvt/family"/>
 </xsl:variable>
 <div class="gb_window">
  <div class="gb_window_part_left"></div>
  <div class="gb_window_part_right"></div>
  <div class="gb_window_part_center">
    <xsl:choose>
      <xsl:when test="edit">
        <xsl:value-of select="gsa:i18n ('Edit Scan Config NVT', 'Scan Config')"/>
        <a href="/help/config_editor_nvt.html?token={/envelope/token}"
           title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Scan Configs', 'Scan Config'),' (',gsa:i18n('Edit Scan Config NVT', 'Scan Config'),')')}">
          <img src="/img/help.png"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="gsa:i18n ('Scan Config NVT Details', 'Scan Config')"/>
        <a href="/help/config_nvt_details.html?token={/envelope/token}"
           title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Scan Configs', 'Scan Config'),' (',gsa:i18n('Scan Config NVT Details', 'Scan Config'),')')}">
          <img src="/img/help.png"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="edit">
        <a href="?cmd=edit_config_family&amp;config_id={config/@id}&amp;name={config/name}&amp;family={$family}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Scan Config Family', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Config Family', 'Scan Config')}"/>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <a href="?cmd=get_config_family&amp;config_id={config/@id}&amp;name={config/name}&amp;family={$family}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Scan Config Family', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Config Family', 'Scan Config')}"/>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </div>
  <div class="gb_window_part_content">
    <xsl:apply-templates select="get_nvts_response/nvt" mode="details">
      <xsl:with-param name="config" select="config/name"/>
    </xsl:apply-templates>

    <h2><xsl:value-of select="gsa:i18n ('Preferences', 'Scan Config')"/></h2>
    <xsl:variable name="config" select="config"/>
    <xsl:choose>
      <xsl:when test="edit">
        <form action="" method="post" enctype="multipart/form-data">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="save_config_nvt"/>
          <input type="hidden" name="caller" value="{/envelope/current_page}"/>
          <input type="hidden" name="config_id" value="{config/@id}"/>
          <input type="hidden" name="name" value="{config/name}"/>
          <input type="hidden" name="family" value="{$family}"/>
          <input type="hidden"
                 name="oid"
                 value="{get_nvts_response/nvt/@oid}"/>
          <xsl:for-each select="get_nvts_response/nvt/preferences">
            <xsl:call-template name="preferences-edit-details">
              <xsl:with-param name="config" select="$config"/>
            </xsl:call-template>
          </xsl:for-each>
        </form>
      </xsl:when>
      <xsl:otherwise>
        <xsl:for-each select="get_nvts_response/nvt/preferences">
          <xsl:call-template name="preferences-details">
            <xsl:with-param name="config" select="$config"/>
          </xsl:call-template>
        </xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </div>
 </div>
</xsl:template>

<!--     CONFIG FAMILIES -->

<xsl:template name="edit-families-family">
  <xsl:param name="config"></xsl:param>
  <xsl:param name="config-family"></xsl:param>
  <xsl:variable name="current_name" select="name/text()"/>
  <xsl:choose>
    <xsl:when test="name=''">
    </xsl:when>
    <xsl:otherwise>

      <tr class="{gsa:table-row-class(position())}">
        <td><xsl:value-of select="$current_name"/></td>
        <td>
          <xsl:choose>
            <xsl:when test="$config-family">
              <xsl:choose>
                <xsl:when test="$config-family/nvt_count='-1'">
                  N
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="$config-family/nvt_count"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              0
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="max_nvt_count='-1'">
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n (' of ', 'Scan Config|NVTs')"/> <xsl:value-of select="max_nvt_count"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td style="text-align:center;">
          <label>
            <xsl:choose>
              <xsl:when test="$config-family">
                <xsl:choose>
                  <xsl:when test="$config-family/growing=1">
                    <input type="radio" name="trend:{$current_name}" value="1"
                           checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="trend:{$current_name}" value="1"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <input type="radio" name="trend:{$current_name}" value="1"/>
              </xsl:otherwise>
            </xsl:choose>
            <img src="/img/trend_more.png"
                 alt="{gsa:i18n ('Grows', 'Scan Config')}"
                 title="{gsa:i18n ('The NVT selection is DYNAMIC. New NVTs will automatically be added and considered.', 'Scan Config')}"/>
          </label>
          <label>
            <xsl:choose>
              <xsl:when test="$config-family">
                <xsl:choose>
                  <xsl:when test="$config-family/growing=0">
                    <input type="radio" name="trend:{$current_name}" value="0"
                           checked="1"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <input type="radio" name="trend:{$current_name}" value="0"/>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <input type="radio" name="trend:{$current_name}" value="0"
                       checked="1"/>
              </xsl:otherwise>
            </xsl:choose>
            <img src="/img/trend_nochange.png"
                 alt="{gsa:i18n ('Static', 'Scan Config')}"
                 title="{gsa:i18n ('The NVT selection is STATIC. New NVTs will NOT automatically be added or considered.', 'Scan Config')}"/>
          </label>
        </td>
        <td style="text-align:center;">
          <xsl:choose>
            <xsl:when test="$config-family and ($config-family/nvt_count = max_nvt_count)">
              <input type="checkbox" name="select:{$current_name}"
                     value="1" checked="1"/>
            </xsl:when>
            <xsl:otherwise>
              <input type="checkbox" name="select:{$current_name}"
                     value="0"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <a href="/omp?cmd=edit_config_family&amp;config_id={$config/@id}&amp;name={$config/name}&amp;family={$current_name}&amp;token={/envelope/token}"
             title="{gsa:i18n ('Edit Scan Config Family', 'Scan Config')}" style="margin-left:3px;">
            <img src="/img/edit.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"/>
          </a>
        </td>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="family">
  <xsl:variable name="current_name" select="name/text()"/>
  <xsl:choose>
    <xsl:when test="name=''">
    </xsl:when>
    <xsl:otherwise>

      <tr class="{gsa:table-row-class(position())}">
        <td><xsl:value-of select="$current_name"/></td>
        <td>
          <xsl:choose>
            <xsl:when test="nvt_count='-1'">
              N
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="nvt_count"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:choose>
            <xsl:when test="max_nvt_count='-1'">
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n (' of ', 'Scan Config|NVTs')"/>
              <xsl:value-of select="max_nvt_count"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="growing='1'">
              <img src="/img/trend_more.png"
                   alt="{gsa:i18n ('Grows', 'Scan Config')}"
                   title="{gsa:i18n ('The NVT selection is DYNAMIC. New NVTs will automatically be added and considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:when test="growing='0'">
              <img src="/img/trend_nochange.png"
                   alt="{gsa:i18n ('Static', 'Scan Config')}"
                   title="{gsa:i18n ('The NVT selection is STATIC. New NVTs will NOT automatically be added or considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td>
          <a href="/omp?cmd=get_config_family&amp;config_id={../../@id}&amp;name={../../name}&amp;family={$current_name}&amp;token={/envelope/token}"
             title="{gsa:i18n ('Scan Config Family Details', 'Scan Config')}" style="margin-left:3px;">
            <img src="/img/details.png" border="0" alt="{gsa:i18n ('Details', 'Generic Resource')}"/>
          </a>
        </td>
      </tr>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="config" mode="families">
  <div id="families">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td>
          <xsl:value-of select="gsa:i18n ('Family', 'Scan Config')"/>
          <xsl:choose>
            <xsl:when test="family_count/growing='1'">
              <img src="/img/trend_more.png"
                   alt="{gsa:i18n ('Grows', 'Scan Config')}"
                   title="{gsa:i18n ('The family selection is DYNAMIC. New families will automatically be added and considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:when test="family_count/growing='0'">
              <img src="/img/trend_nochange.png"
                   alt="{gsa:i18n ('Static', 'Scan Config')}"
                   title="{gsa:i18n ('The family selection is STATIC. New families will NOT automatically be added or considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td><xsl:value-of select="gsa:i18n ('NVTs selected', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Trend', 'Scan Config|NVTs')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:apply-templates select="families/family"/>
      <tr>
        <td><xsl:value-of select="gsa:i18n ('Total', 'Families')"/>: <xsl:value-of select="count(families/family)"/></td>
        <td>
          <table>
            <tr>
              <td style="margin-right:10px;">
                <xsl:value-of select="known_nvt_count/text()"/>
              </td>
              <td>
                <div style="margin-left:6px;">
                  <xsl:value-of select="gsa:i18n (' of ', 'Scan Config|NVTs')"/>
                  <xsl:value-of select="max_nvt_count/text()"/>
                  <xsl:value-of select="gsa:i18n (' in selected families', 'Scan Config')"/><br/>
                  <xsl:value-of select="gsa:i18n (' of ', 'Scan Config|NVTs')"/>
                  <xsl:value-of select="sum(../../get_nvt_families_response/families/family/max_nvt_count)"/>
                  <xsl:value-of select="gsa:i18n (' in total', 'Scan Config')"/>
                </div>
              </td>
            </tr>
          </table>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="nvt_count/growing='1'">
              <img src="/img/trend_more.png"
                   alt="{gsa:i18n ('Grows', 'Scan Config')}"
                   title="{gsa:i18n ('The NVT selection is DYNAMIC. New NVTs will automatically be added and considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:when test="nvt_count/growing='0'">
              <img src="/img/trend_nochange.png"
                   alt="{gsa:i18n ('Static', 'Scan Config')}"
                   title="{gsa:i18n ('The NVT selection is STATIC. New NVTs will NOT automatically be added or considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td></td>
      </tr>
    </table>
  </div>
</xsl:template>

<xsl:template name="edit-families">
  <xsl:param name="config"></xsl:param>
  <xsl:param name="families"></xsl:param>
  <div id="families">
    <table class="gbntable" cellspacing="2" cellpadding="4">
      <tr class="gbntablehead2">
        <td>
          <xsl:value-of select="gsa:i18n ('Family', 'Scan Config')"/>
          <xsl:choose>
            <xsl:when test="$config/family_count/growing=1">
              <label>
                <input type="radio" name="trend" value="1" checked="1"/>
                <img src="/img/trend_more.png"
                     alt="{gsa:i18n ('Grows', 'Scan Config')}"
                     title="{gsa:i18n ('The family selection is DYNAMIC. New families will automatically be added and considered.', 'Scan Config')}"/>
              </label>
              <label>
                <input type="radio" name="trend" value="0"/>
                <img src="/img/trend_nochange.png"
                     alt="{gsa:i18n ('Static', 'Scan Config')}"
                     title="{gsa:i18n ('The family selection is STATIC. New families will NOT automatically be added or considered.', 'Scan Config')}"/>
              </label>
            </xsl:when>
            <xsl:otherwise>
              <label>
                <input type="radio" name="trend" value="1"/>
                <img src="/img/trend_more.png"
                     alt="{gsa:i18n ('Grows', 'Scan Config')}"
                     title="{gsa:i18n ('The family selection is DYNAMIC. New families will automatically be added and considered.', 'Scan Config')}"/>
              </label>
              <label>
                <input type="radio" name="trend" value="0" checked="0"/>
                <img src="/img/trend_nochange.png"
                     alt="{gsa:i18n ('Static', 'Scan Config')}"
                     title="{gsa:i18n ('The family selection is STATIC. New families will NOT automatically be added or considered.', 'Scan Config')}"/>
              </label>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td><xsl:value-of select="gsa:i18n ('NVTs selected', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Trend', 'Scan Config|NVTs')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Select all NVTs', 'Scan Config')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:for-each select="$families/family">
        <xsl:variable name="family_name">
          <xsl:value-of select="name"/>
        </xsl:variable>
        <xsl:call-template name="edit-families-family">
          <xsl:with-param
            name="config-family"
            select="$config/families/family[name=$family_name]"/>
          <xsl:with-param name="config" select="$config"/>
        </xsl:call-template>
      </xsl:for-each>
      <tr>
        <td>
          <xsl:value-of select="gsa:i18n ('Total', 'Families')"/>: <xsl:value-of select="count($config/families/family)"/>
        </td>
        <td>
          <xsl:value-of select="$config/known_nvt_count/text()"/>
          <xsl:value-of select="gsa:i18n (' of ', 'Scan Config|NVTs')"/>
          <xsl:value-of select="$config/max_nvt_count/text()"/>
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="$config/nvt_count/growing='1'">
              <img src="/img/trend_more.png"
                   alt="{gsa:i18n ('Grows', 'Scan Config')}"
                   title="{gsa:i18n ('The NVT selection is DYNAMIC. New NVTs will automatically be added and considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:when test="$config/nvt_count/growing='0'">
              <img src="/img/trend_nochange.png"
                   alt="{gsa:i18n ('Static', 'Scan Config')}"
                   title="{gsa:i18n ('The NVT selection is STATIC. New NVTs will NOT automatically be added or considered.', 'Scan Config')}"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td></td>
        <td></td>
      </tr>
      <tr>
        <td colspan="5" style="text-align:right;">
          <input type="submit"
                 name="submit"
                 value="{gsa:i18n ('Save Config', 'Scan Config')}"
                 title="{gsa:i18n ('Save Config', 'Scan Config')}"/>
        </td>
      </tr>
    </table>
  </div>
</xsl:template>

<!--     CONFIG OVERVIEW -->

<xsl:template name="html-config-table">
 <xsl:variable name="config" select="get_configs_response/config"/>
 <div class="gb_window">
  <div class="gb_window_part_left"></div>
  <div class="gb_window_part_right"></div>
  <div class="gb_window_part_center">
  <xsl:choose>
    <xsl:when test="edit">
      <xsl:value-of select="gsa:i18n ('Edit Scan Config', 'Scan Config')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Scan Config'"/>
        <xsl:with-param name="type" select="'config'"/>
        <xsl:with-param name="id"
                        select="$config/@id"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="gsa:i18n ('Scan Config Details', 'Scan Config')"/>
      <a href="/help/config_details.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('Scan Config Details', 'Scan Config'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=new_config&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;config_id={$config/@id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('New Scan Config', 'Scan Config')}">
        <img src="/img/new.png" border="0" style="margin-left:3px;"/>
      </a>
      <xsl:choose>
        <xsl:when test="gsa:may-clone ('config')">
          <div style="display: inline">
            <form style="display: inline; font-size: 0px; margin-left: 3px" action="/omp" method="post" enctype="multipart/form-data">
              <input type="hidden" name="token" value="{/envelope/token}"/>
              <input type="hidden" name="caller" value="{/envelope/current_page}"/>
              <input type="hidden" name="cmd" value="clone"/>
              <input type="hidden" name="resource_type" value="config"/>
              <input type="hidden" name="next" value="get_config"/>
              <input type="hidden" name="id" value="{$config/@id}"/>
              <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
              <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
              <input type="image" src="/img/clone.png" alt="{gsa:i18n ('Clone', 'Action Verb')}"
                     name="Clone" value="Clone" title="{gsa:i18n ('Clone', 'Action Verb')}"/>
            </form>
          </div>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/clone_inactive.png"
               alt="{gsa:i18n ('Clone', 'Action Verb')}"
               value="Clone"
               title="{gsa:i18n ('Permission to clone denied', 'Action Message')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
      <a href="/omp?cmd=get_configs&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Scan Configs', 'Scan Config')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scan Configs', 'Scan Config')}"/>
      </a>
      <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
        <xsl:choose>
          <xsl:when test="$config/writable!='0' and $config/in_use='0'">
            <xsl:call-template name="trashcan-icon">
              <xsl:with-param name="type" select="'config'"/>
              <xsl:with-param name="id" select="$config/@id"/>
              <xsl:with-param name="params">
                <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
                <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="inactive_text">
              <xsl:choose>
                <xsl:when test="in_use != '0'"><xsl:value-of select="gsa:i18n ('Scan Config is not writable', 'Scan Config')"/></xsl:when>
                <xsl:when test="writable = '0'"><xsl:value-of select="gsa:i18n ('Scan Config is not writable', 'Scan Config')"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="gsa:i18n ('Cannot move Scan Config to trashcan', 'Scan Config')"/></xsl:otherwise>
              </xsl:choose>
            </xsl:variable>
            <img src="/img/trashcan_inactive.png" border="0" alt="{gsa:i18n ('To Trashcan', 'Action Verb')}"
                 title="{$inactive_text}"
                 style="margin-left:3px;"/>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:choose>
          <xsl:when test="$config/writable='0'">
            <img src="/img/edit_inactive.png" border="0" alt="{gsa:i18n ('Edit', 'Action Verb')}"
                 title="{gsa:i18n ('Scan Config is not writable', 'Scan Config')}"
                 style="margin-left:3px;"/>
          </xsl:when>
          <xsl:otherwise>
            <a href="/omp?cmd=edit_config&amp;config_id={$config/@id}&amp;next=get_config&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa:i18n ('Edit Scan Config', 'Scan Config')}">
              <img src="/img/edit.png" border="0" style="margin-left:3px;"/>
            </a>
          </xsl:otherwise>
        </xsl:choose>
        <a href="/omp?cmd=export_config&amp;config_id={$config/@id}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
           title="{gsa:i18n ('Export Scan Config as XML', 'Scan Config')}"
           style="margin-left:3px;">
          <img src="/img/download.png" border="0" alt="{gsa:i18n ('Export XML', 'Action Verb')}"/>
        </a>
      </div>
    </xsl:otherwise>
  </xsl:choose>
  </div>
  <div class="gb_window_part_content">

    <xsl:choose>
      <xsl:when test="edit">
        <form action="" method="post" enctype="multipart/form-data">
          <input type="hidden" name="token" value="{/envelope/token}"/>
          <input type="hidden" name="cmd" value="save_config"/>
          <input type="hidden" name="caller" value="{/envelope/current_page}"/>
          <input type="hidden" name="config_id" value="{$config/@id}"/>
          <input type="hidden" name="name" value="{$config/name}"/>

          <table border="0" cellspacing="0" cellpadding="3" width="100%">
            <tr>
              <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td>
                <input type="text" name="name" value="{$config/name}" size="30"
                       maxlength="80"/>
              </td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
              <td>
                <input type="text" name="comment" size="30" maxlength="400"
                       value="{$config/comment}"/>
              </td>
            </tr>
            <tr>
              <td colspan="2" style="text-align:right;">
                <input type="submit" name="submit" value="{gsa:i18n ('Save Config', 'Scan Config')}"/>
              </td>
            </tr>
          </table>

          <xsl:if test="$config/type = 0">
            <h1><xsl:value-of select="gsa:i18n ('Edit Network Vulnerability Test Families', 'Scan Config')"/></h1>

            <xsl:call-template name="edit-families">
              <xsl:with-param name="config" select="$config"/>
              <xsl:with-param
                name="families"
                select="get_nvt_families_response/families"/>
            </xsl:call-template>
          </xsl:if>

          <xsl:choose>
            <xsl:when test="count($config/preferences/preference[string-length(nvt)=0]) = 0">
              <h1><xsl:value-of select="gsa:i18n ('Edit Scanner Preferences', 'Scan Config')"/>: <xsl:value-of select="gsa:i18n ('None', 'Scanner|Preferences')"/></h1>
              <xsl:if test="$config/type = 0">
                <h1><xsl:value-of select="gsa:i18n ('Network Vulnerability Test Preferences', 'Scan Config')"/>: <xsl:value-of select="gsa:i18n ('None', 'NVT|Preferences')"/></h1>
              </xsl:if>
            </xsl:when>
            <xsl:otherwise>
              <h1><xsl:value-of select="gsa:i18n ('Edit Scanner Preferences', 'Scan Config')"/></h1>

              <xsl:apply-templates select="$config/preferences" mode="edit-scanner-details"/>

              <xsl:if test="$config/type = 0">
                <h1><xsl:value-of select="gsa:i18n ('Network Vulnerability Test Preferences', 'Scan Config')"/></h1>
                <xsl:for-each select="$config/preferences">
                  <xsl:call-template name="preferences">
                    <xsl:with-param name="config_id" select="$config/@id"/>
                    <xsl:with-param name="config_name" select="$config/name"/>
                    <xsl:with-param name="edit">yes</xsl:with-param>
                  </xsl:call-template>
                </xsl:for-each>
              </xsl:if>
            </xsl:otherwise>
          </xsl:choose>

        </form>
      </xsl:when>
      <xsl:otherwise>
        <div class="float_right" style="font-size: 10px;">
          <table style="font-size: 10px;">
            <tr>
              <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
              <td><xsl:value-of select="$config/@id"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
              <td><xsl:value-of select="gsa:long-time ($config/creation_time)"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
              <td><xsl:value-of select="gsa:long-time ($config/modification_time)"/></td>
            </tr>
          </table>
        </div>
        <table>
          <tr>
            <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
            <td><b><xsl:value-of select="$config/name"/></b></td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td><td><xsl:value-of select="$config/comment"/></td>
          </tr>
        </table>

        <br/>

        <xsl:if test="$config/type = 0">
          <h1>
            <xsl:value-of select="gsa:i18n ('Network Vulnerability Test Families', 'Scan Config')"/>
          </h1>
          <xsl:apply-templates select="$config" mode="families"/>
        </xsl:if>

        <xsl:choose>
          <xsl:when test="count($config/preferences/preference[string-length(nvt)=0]) = 0">
            <h1><xsl:value-of select="gsa:i18n ('Scanner Preferences', 'Scan Config')"/>: <xsl:value-of select="gsa:i18n ('None', 'Scanner|Preferences')"/></h1>
            <xsl:if test="$config/type = 0">
              <h1><xsl:value-of select="gsa:i18n ('Network Vulnerability Test Preferences', 'Scan Config')"/>: <xsl:value-of select="gsa:i18n ('None', 'NVT|Preferences')"/></h1>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <h1><xsl:value-of select="gsa:i18n ('Scanner Preferences', 'Scan Config')"/></h1>
            <xsl:apply-templates select="$config/preferences" mode="scanner"/>

            <xsl:if test="$config/type = 0">
              <h1><xsl:value-of select="gsa:i18n ('Network Vulnerability Test Preferences', 'Scan Config')"/></h1>
              <xsl:for-each select="$config/preferences">
                <xsl:call-template name="preferences">
                  <xsl:with-param name="config_id" select="$config/@id"/>
                  <xsl:with-param name="config_name" select="$config/name"/>
                </xsl:call-template>
              </xsl:for-each>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
      <xsl:when test="count($config/tasks/task) = 0">
        <h1><xsl:value-of select="gsa:i18n ('Tasks using this Config', 'Scan Config')"/>: <xsl:value-of select="gsa:i18n ('None', 'Tasks')"/></h1>
      </xsl:when>
      <xsl:otherwise>
        <h1><xsl:value-of select="gsa:i18n ('Tasks using this Config', 'Scan Config')"/></h1>
        <table class="gbntable" cellspacing="2" cellpadding="4">
          <tr class="gbntablehead2">
            <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
          </tr>
          <xsl:for-each select="$config/tasks/task">
            <tr class="{gsa:table-row-class(position())}">
              <xsl:choose>
                <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                  <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                  <td width="100">
                    <img src="/img/details_inactive.png"
                         border="0"
                         alt="{gsa:i18n ('Details', 'Generic Resource')}"
                         style="margin-left:3px;"/>
                  </td>
                </xsl:when>
                <xsl:otherwise>
                  <td><xsl:value-of select="name"/></td>
                  <td width="100">
                    <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                      <img src="/img/details.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </a>
                  </td>
                </xsl:otherwise>
              </xsl:choose>
            </tr>
          </xsl:for-each>
        </table>
      </xsl:otherwise>
    </xsl:choose>
  </div>
 </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="user_tags" select="$config/user_tags"/>
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), $config/name)"/>
    <xsl:with-param name="resource_type" select="'config'"/>
    <xsl:with-param name="next" select="'get_config'"/>
    <xsl:with-param name="resource_id"   select="$config/@id"/>
  </xsl:call-template>

  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'config'"/>
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Permissions for Config &quot;%1&quot;', 'Scan Config'), $config/name)"/>
    <xsl:with-param name="permissions" select="permissions/get_permissions_response"/>
    <xsl:with-param name="resource_id" select="$config/@id"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-configs-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'config'"/>
    <xsl:with-param name="cap-type" select="'Scan Configuration'"/>
    <xsl:with-param name="resources-summary" select="configs"/>
    <xsl:with-param name="resources" select="config"/>
    <xsl:with-param name="count" select="count (config)"/>
    <xsl:with-param name="filtered-count" select="config_count/filtered"/>
    <xsl:with-param name="full-count" select="config_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Families', 'Scan Config')"/></name>
        <column>
          <name><xsl:value-of select="gsa:i18n('Total', 'Scan Config|Families')"/></name>
          <field>families_total</field>
          <sort-reverse/>
        </column>
        <column>
          <name><xsl:value-of select="gsa:i18n('Trend', 'Scan Config|Families')"/></name>
          <field>families_trend</field>
        </column>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('NVTs', 'NVT')"/></name>
        <column>
          <name><xsl:value-of select="gsa:i18n('Total', 'Scan Config|NVTs')"/></name>
          <field>nvts_total</field>
          <sort-reverse/>
        </column>
        <column>
          <name><xsl:value-of select="gsa:i18n('Trend', 'Scan Config|NVTs')"/></name>
          <field>nvts_total</field>
          <sort-reverse/>
        </column>
      </column>
    </xsl:with-param>
    <xsl:with-param name="default-filter" select="'apply_overrides=1 sort-reverse=date'"/>
    <xsl:with-param name="icon-count" select="4"/>
  </xsl:call-template>
</xsl:template>

<!--     CREATE_CONFIG_RESPONSE -->

<xsl:template match="create_config_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Config</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
    <xsl:with-param name="details">
      <xsl:if test="@status = '201' and config/name">
        Name of new config is '<xsl:value-of select="config/name"/>'.
      </xsl:if>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     DELETE_CONFIG_RESPONSE -->

<xsl:template match="delete_config_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Delete Config</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!-- CONFIG -->

<xsl:template match="config">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Config'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_config&amp;config_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Scan Config', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="family_count/text()='-1'">
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="family_count/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td style="text-align:center;">
      <xsl:choose>
        <xsl:when test="family_count/growing='1'">
          <img src="/img/trend_more.png"
               alt="{gsa:i18n ('Grows', 'Scan Config')}"
               title="{gsa:i18n ('The family selection is DYNAMIC. New families will automatically be added and considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:when test="family_count/growing='0'">
          <img src="/img/trend_nochange.png"
               alt="{gsa:i18n ('Static', 'Scan Config')}"
               title="{gsa:i18n ('The family selection is STATIC. New families will NOT automatically be added or considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="nvt_count/text()='-1'">
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="nvt_count/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td style="text-align:center;">
      <xsl:choose>
        <xsl:when test="nvt_count/growing='1'">
          <img src="/img/trend_more.png"
               alt="{gsa:i18n ('Dynamic', 'Scan Config')}"
               title="{gsa:i18n ('The NVT selection is DYNAMIC. New NVTs of selected families will automatically be added and considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:when test="nvt_count/growing='0'">
          <img src="/img/trend_nochange.png"
               alt="{gsa:i18n ('Static', 'Scan Config')}"
               title="{gsa:i18n ('The NVT selection is STATIC. New NVTs will NOT automatically be added or considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Scan Config'"/>
            <xsl:with-param name="type" select="'config'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="config" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Config'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="family_count/text()='-1'">
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="family_count/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td style="text-align:center;">
      <xsl:choose>
        <xsl:when test="family_count/growing='1'">
          <img src="/img/trend_more.png"
               alt="{gsa:i18n ('Grows', 'Scan Config')}"
               title="{gsa:i18n ('The family selection is DYNAMIC. New families will automatically be added and considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:when test="family_count/growing='0'">
          <img src="/img/trend_nochange.png"
               alt="{gsa:i18n ('Static', 'Scan Config')}"
               title="{gsa:i18n ('The family selection is STATIC. New families will NOT automatically be added or considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="nvt_count/text()='-1'">
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="nvt_count/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td style="text-align:center;">
      <xsl:choose>
        <xsl:when test="nvt_count/growing='1'">
          <img src="/img/trend_more.png"
               alt="{gsa:i18n ('Grows', 'Scan Config')}"
               title="{gsa:i18n ('The NVT selection is DYNAMIC. New NVTs of selected families will automatically be added and considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:when test="nvt_count/growing='0'">
          <img src="/img/trend_nochange.png"
               alt="{gsa:i18n ('Static', 'Scan Config')}"
               title="{gsa:i18n ('The NVT selection is STATIC. New NVTs will NOT automatically be added or considered.', 'Scan Config')}"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'config'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png" border="0" alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Scan Config is still in use', 'Scan Config')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<!-- GET_CONFIGS_RESPONSE -->

<xsl:template match="get_configs_response">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="delete_config_response"/>
  <xsl:call-template name="html-configs-table"/>
</xsl:template>

<!-- GET_CONFIG_RESPONSE -->

<xsl:template match="get_config_response">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_config_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:call-template name="html-config-table"/>
</xsl:template>

<!-- GET_CONFIG_FAMILY_RESPONSE -->

<xsl:template match="get_config_family_response">
  <xsl:call-template name="html-config-family-table"/>
</xsl:template>

<!-- GET_CONFIG_NVT_RESPONSE -->

<xsl:template match="get_config_nvt_response">
  <xsl:call-template name="html-config-nvt-table"/>
</xsl:template>


<!-- BEGIN SCHEDULES MANAGEMENT -->

<xsl:template name="opt">
  <xsl:param name="value"></xsl:param>
  <xsl:param name="content"><xsl:value-of select="$value"/></xsl:param>
  <xsl:param name="select-value"></xsl:param>
  <xsl:choose>
    <xsl:when test="$value = $select-value">
      <option value="{$value}" selected="1"><xsl:value-of select="$content"/></option>
    </xsl:when>
    <xsl:otherwise>
      <option value="{$value}"><xsl:value-of select="$content"/></option>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="html-create-schedule-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Schedule', 'Schedule')"/>
      <a href="/help/new_schedule.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Schedule', 'Schedule'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_schedules&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Schedules', 'Schedule')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Schedules', 'Schedule')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_schedule"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_schedule"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (optional)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('First Time', 'Schedule')"/></td>
            <td>
              <select name="hour">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'00'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'01'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'02'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'03'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'04'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'06'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'07'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'08'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'09'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'11'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'12'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'13'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'14'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'15'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'16'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'17'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'18'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'19'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'20'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'21'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'22'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'23'"/>
                  <xsl:with-param name="select-value" select="time/hour"/>
                </xsl:call-template>
              </select>
              h
              <select name="minute">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'00'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'15'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'20'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'25'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'30'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'35'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'40'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'45'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'50'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'55'"/>
                  <xsl:with-param name="select-value" select="time/minute - (time/minute mod 5)"/>
                </xsl:call-template>
              </select>
              ,
              <select name="day_of_month">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'01'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'02'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'03'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'04'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'06'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'07'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'08'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'09'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'11'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'12'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'13'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'14'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'15'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'16'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'17'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'18'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'19'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'20'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'21'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'22'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'23'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'24'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'25'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'26'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'27'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'28'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'29'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'30'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'31'"/>
                  <xsl:with-param name="select-value" select="time/day_of_month"/>
                </xsl:call-template>
              </select>
              <select name="month">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'01'"/>
                  <xsl:with-param name="content" select="'Jan'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'02'"/>
                  <xsl:with-param name="content" select="'Feb'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'03'"/>
                  <xsl:with-param name="content" select="'Mar'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'04'"/>
                  <xsl:with-param name="content" select="'Apr'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="content" select="'May'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'06'"/>
                  <xsl:with-param name="content" select="'Jun'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'07'"/>
                  <xsl:with-param name="content" select="'Jul'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'08'"/>
                  <xsl:with-param name="content" select="'Aug'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'09'"/>
                  <xsl:with-param name="content" select="'Sep'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="content" select="'Oct'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'11'"/>
                  <xsl:with-param name="content" select="'Nov'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'12'"/>
                  <xsl:with-param name="content" select="'Dec'"/>
                  <xsl:with-param name="select-value" select="time/month"/>
                </xsl:call-template>
              </select>
              <select name="year">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2012'"/>
                  <xsl:with-param name="select-value" select="time/year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2013'"/>
                  <xsl:with-param name="select-value" select="time/year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2014'"/>
                  <xsl:with-param name="select-value" select="time/year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2015'"/>
                  <xsl:with-param name="select-value" select="time/year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2016'"/>
                  <xsl:with-param name="select-value" select="time/year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2017'"/>
                  <xsl:with-param name="select-value" select="time/year"/>
                </xsl:call-template>
              </select>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Timezone', 'Time')"/></td>
            <td>
              <xsl:call-template name="timezone-select">
                <xsl:with-param name="timezone" select="/envelope/timezone"/>
                <xsl:with-param name="input-name" select="'timezone'"/>
              </xsl:call-template>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Period', 'Schedule')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text"
                     name="period"
                     value="0"
                     size="3"
                     maxlength="80"/>
              <select name="period_unit">
                <option value="hour" selected="1"><xsl:value-of select="gsa:i18n ('hour(s)', 'Time')"/></option>
                <option value="day"><xsl:value-of select="gsa:i18n ('day(s)', 'Time')"/></option>
                <option value="week"><xsl:value-of select="gsa:i18n ('week(s)', 'Time')"/></option>
                <option value="month"><xsl:value-of select="gsa:i18n ('month(s)', 'Time')"/></option>
              </select>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Duration', 'Schedule')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text"
                     name="duration"
                     value="0"
                     size="3"
                     maxlength="80"/>
              <select name="duration_unit">
                <option value="hour" selected="1"><xsl:value-of select="gsa:i18n ('hour(s)', 'Time')"/></option>
                <option value="day"><xsl:value-of select="gsa:i18n ('day(s)', 'Time')"/></option>
                <option value="week"><xsl:value-of select="gsa:i18n ('week(s)', 'Time')"/></option>
              </select>
            </td>
          </tr>
          <tr class="even">
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Schedule', 'Schedule')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_schedule">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_schedule_response"/>
  <xsl:apply-templates select="commands_response/delete_schedule_response"/>
  <xsl:call-template name="html-create-schedule-form"/>
</xsl:template>

<xsl:template name="html-schedules-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'schedule'"/>
    <xsl:with-param name="cap-type" select="'Schedule'"/>
    <xsl:with-param name="resources-summary" select="schedules"/>
    <xsl:with-param name="resources" select="schedule"/>
    <xsl:with-param name="count" select="count (schedule)"/>
    <xsl:with-param name="filtered-count" select="schedule_count/filtered"/>
    <xsl:with-param name="full-count" select="schedule_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('First Run', 'Schedule')"/></name>
        <field>first_run</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Next Run', 'Schedule')"/></name>
        <field>next_run</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Period', 'Schedule')"/></name>
        <field>period</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Duration', 'Schedule')"/></name>
        <field>duration</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="4"/>
  </xsl:call-template>
</xsl:template>

<!--     CREATE_SCHEDULE_RESPONSE -->

<xsl:template match="create_schedule_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Schedule</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     DELETE_SCHEDULE_RESPONSE -->

<xsl:template match="delete_schedule_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Schedule
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     MODIFY_SCHEDULE_RESPONSE -->

<xsl:template match="modify_schedule_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Schedules</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     EDIT_SCHEDULE -->

<xsl:template name="schedule-select-options">
  <xsl:param name="selected"/>
  <xsl:param name="max" select="24"/>
  <xsl:param name="current" select="0"/>
  <xsl:if test="$current &lt;= $max">
    <xsl:choose>
      <xsl:when test="$selected = $current">
        <option value="{format-number ($current, '00')}" selected="1">
          <xsl:value-of select="format-number ($current, '00')"/>
        </option>
      </xsl:when>
      <xsl:otherwise>
        <option value="{format-number ($current, '00')}">
          <xsl:value-of select="format-number ($current, '00')"/>
        </option>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:call-template name="schedule-select-options">
      <xsl:with-param name="selected" select="$selected"/>
      <xsl:with-param name="current" select="$current + 1"/>
      <xsl:with-param name="max" select="$max"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="html-edit-schedule-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Schedule', 'Schedule')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Schedule'"/>
        <xsl:with-param name="type" select="'schedule'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_schedules_response/schedule/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_schedule"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="schedule_id"
               value="{commands_response/get_schedules_response/schedule/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="schedule" value="{/envelope/params/schedule}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr class="odd">
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text"
                     name="name"
                     value="{commands_response/get_schedules_response/schedule/name}"
                     size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{commands_response/get_schedules_response/schedule/comment}"/>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('First Time', 'Schedule')"/></td>
            <td>
              <xsl:variable name="hour"
                            select="format-number (date:hour-in-day (commands_response/get_schedules_response/schedule/first_time), '00')"/>
              <select name="hour">
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'00'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'01'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'02'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'03'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'04'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'06'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'07'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'08'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'09'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'11'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'12'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'13'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'14'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'15'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'16'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'17'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'18'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'19'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'20'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'21'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'22'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'23'"/>
                  <xsl:with-param name="select-value" select="$hour"/>
                </xsl:call-template>
              </select>
              h
              <select name="minute">
                <xsl:variable name="minute"
                              select="format-number (date:minute-in-hour (commands_response/get_schedules_response/schedule/first_time), '00')"/>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'00'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'15'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'20'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'25'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'30'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'35'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'40'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'45'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'50'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'55'"/>
                  <xsl:with-param name="select-value" select="$minute - ($minute mod 5)"/>
                </xsl:call-template>
              </select>
              ,
              <select name="day_of_month">
                <xsl:variable name="day"
                              select="format-number (date:day-in-month (commands_response/get_schedules_response/schedule/first_time), '00')"/>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'01'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'02'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'03'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'04'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'06'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'07'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'08'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'09'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'11'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'12'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'13'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'14'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'15'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'16'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'17'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'18'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'19'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'20'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'21'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'22'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'23'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'24'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'25'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'26'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'27'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'28'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'29'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'30'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'31'"/>
                  <xsl:with-param name="select-value" select="$day"/>
                </xsl:call-template>
              </select>
              <select name="month">
                <xsl:variable name="month"
                              select="format-number (date:month-in-year (commands_response/get_schedules_response/schedule/first_time), '00')"/>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'01'"/>
                  <xsl:with-param name="content" select="'Jan'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'02'"/>
                  <xsl:with-param name="content" select="'Feb'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'03'"/>
                  <xsl:with-param name="content" select="'Mar'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'04'"/>
                  <xsl:with-param name="content" select="'Apr'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'05'"/>
                  <xsl:with-param name="content" select="'May'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'06'"/>
                  <xsl:with-param name="content" select="'Jun'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'07'"/>
                  <xsl:with-param name="content" select="'Jul'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'08'"/>
                  <xsl:with-param name="content" select="'Aug'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'09'"/>
                  <xsl:with-param name="content" select="'Sep'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'10'"/>
                  <xsl:with-param name="content" select="'Oct'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'11'"/>
                  <xsl:with-param name="content" select="'Nov'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'12'"/>
                  <xsl:with-param name="content" select="'Dec'"/>
                  <xsl:with-param name="select-value" select="$month"/>
                </xsl:call-template>
              </select>
              <select name="year">
                <xsl:variable name="year"
                              select="date:year (commands_response/get_schedules_response/schedule/first_time)"/>
                <xsl:if test="$year &lt; 2012 or $year &gt; 2017">
                  <option value="{$year}"><xsl:value-of select="$year"/></option>
                </xsl:if>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2012'"/>
                  <xsl:with-param name="select-value" select="$year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2013'"/>
                  <xsl:with-param name="select-value" select="$year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2014'"/>
                  <xsl:with-param name="select-value" select="$year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2015'"/>
                  <xsl:with-param name="select-value" select="$year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2016'"/>
                  <xsl:with-param name="select-value" select="$year"/>
                </xsl:call-template>
                <xsl:call-template name="opt">
                  <xsl:with-param name="value" select="'2017'"/>
                  <xsl:with-param name="select-value" select="$year"/>
                </xsl:call-template>
              </select>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Timezone', 'Time')"/></td>
            <td>
              <xsl:call-template name="timezone-select">
                <xsl:with-param name="timezone" select="commands_response/get_schedules_response/schedule/timezone"/>
                <xsl:with-param name="input-name" select="'timezone'"/>
              </xsl:call-template>
            </td>
          </tr>
          <tr class="even">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Period', 'Schedule')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <xsl:choose>
                <xsl:when test="commands_response/get_schedules_response/schedule/simple_period/text() = 0 and commands_response/get_schedules_response/schedule/period/text() &gt; 0">
                  <input type="text"
                         name="period"
                         value="{commands_response/get_schedules_response/schedule/period}"
                         size="10"
                         maxlength="80"/>
                  <input type="hidden" name="period_unit" value="second"/>
                  <xsl:value-of select="gsa:i18n ('seconds', 'Time')"/>
                </xsl:when>
                <xsl:when test="commands_response/get_schedules_response/schedule/simple_period/text() = 0 and commands_response/get_schedules_response/schedule/period_months/text() &gt; 0">
                  <input type="text"
                         name="period"
                         value="{commands_response/get_schedules_response/schedule/period_months}"
                         size="10"
                         maxlength="80"/>
                  <input type="hidden" name="period_unit" value="month"/>
                  <xsl:value-of select="gsa:i18n ('months', 'Time')"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="text"
                         name="period"
                         value="{commands_response/get_schedules_response/schedule/simple_period/text()}"
                         size="4"
                         maxlength="80"/>
                  <select name="period_unit">
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_period/unit = 'hour'">
                        <option value="hour" selected="1"><xsl:value-of select="gsa:i18n ('hour(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="hour"><xsl:value-of select="gsa:i18n ('hour(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_period/unit = 'day'">
                        <option value="day" selected="1"><xsl:value-of select="gsa:i18n ('day(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="day"><xsl:value-of select="gsa:i18n ('day(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_period/unit = 'week'">
                        <option value="week" selected="1"><xsl:value-of select="gsa:i18n ('week(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="week"><xsl:value-of select="gsa:i18n ('week(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_period/unit = 'month'">
                        <option value="month" selected="1"><xsl:value-of select="gsa:i18n ('month(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="month"><xsl:value-of select="gsa:i18n ('month(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                  </select>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr class="odd">
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Duration', 'Schedule')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <xsl:choose>
                <xsl:when test="commands_response/get_schedules_response/schedule/simple_duration/text() = 0 and commands_response/get_schedules_response/schedule/duration/text() &gt; 0">
                  <input type="text"
                         name="duration"
                         value="{commands_response/get_schedules_response/schedule/duration}"
                         size="10"
                         maxlength="80"/>
                  <input type="hidden" name="duration_unit" value="second"/>
                  <xsl:value-of select="gsa:i18n ('seconds', 'Time')"/>
                </xsl:when>
                <xsl:otherwise>
                  <input type="text"
                         name="duration"
                         value="{commands_response/get_schedules_response/schedule/simple_duration/text()}"
                         size="4"
                         maxlength="80"/>
                  <select name="duration_unit">
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_duration/unit = 'hour'">
                        <option value="hour" selected="1"><xsl:value-of select="gsa:i18n ('hour(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="hour"><xsl:value-of select="gsa:i18n ('hour(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_duration/unit = 'day'">
                        <option value="day" selected="1"><xsl:value-of select="gsa:i18n ('day(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="day"><xsl:value-of select="gsa:i18n ('day(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                    <xsl:choose>
                      <xsl:when test="commands_response/get_schedules_response/schedule/simple_duration/unit = 'week'">
                        <option value="week" selected="1"><xsl:value-of select="gsa:i18n ('week(s)', 'Time')"/></option>
                      </xsl:when>
                      <xsl:otherwise>
                        <option value="week"><xsl:value-of select="gsa:i18n ('week(s)', 'Time')"/></option>
                      </xsl:otherwise>
                    </xsl:choose>
                  </select>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Schedule', 'Schedule')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_schedule">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_schedule_response"/>
  <xsl:call-template name="html-edit-schedule-form"/>
</xsl:template>

<!--     SCHEDULE -->

<xsl:template name="interval-with-unit">
  <xsl:param name="interval">0</xsl:param>
  <xsl:choose>
    <xsl:when test="$interval mod (60 * 60 * 24 * 7) = 0">
      <xsl:value-of select="$interval div (60 * 60 * 24 * 7)"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="$interval = (60 * 60 * 24 * 7)">
          <xsl:value-of select="gsa:i18n ('week', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('weeks', 'Time')"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$interval mod (60 * 60 * 24) = 0">
      <xsl:value-of select="$interval div (60 * 60 * 24)"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="$interval = (60 * 60 * 24)">
          <xsl:value-of select="gsa:i18n ('day', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('days', 'Time')"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$interval mod (60 * 60) = 0">
      <xsl:value-of select="$interval div (60 * 60)"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="$interval = (60 * 60)">
          <xsl:value-of select="gsa:i18n ('hour', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('hours', 'Time')"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$interval mod (60) = 0">
      <xsl:value-of select="$interval div (60)"/>
      <xsl:text> </xsl:text>
      <xsl:choose>
        <xsl:when test="$interval = 60">
          <xsl:value-of select="gsa:i18n ('min', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('mins', 'Time')"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="$interval = 1">
      <xsl:value-of select="$interval"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="gsa:i18n ('sec', 'Time')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$interval"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="gsa:i18n ('secs', 'Time')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="schedule">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Schedule'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_schedule&amp;schedule_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Schedule', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="gsa:long-time (first_time)"/>
      <xsl:text> </xsl:text>
      <xsl:value-of select="timezone_abbrev"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="next_time = 'over'">
          -
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:long-time (next_time)"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="timezone_abbrev"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="period = 0 and period_months = 0">
          <xsl:value-of select="gsa:i18n ('Once', 'Time')"/>
        </xsl:when>
        <xsl:when test="period = 0 and period_months = 1">
          1 <xsl:value-of select="gsa:i18n ('month', 'Time')"/>
        </xsl:when>
        <xsl:when test="period = 0">
          <xsl:value-of select="period_months"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="gsa:i18n ('months', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="interval-with-unit">
            <xsl:with-param name="interval">
              <xsl:value-of select="period"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="duration = 0">
          <xsl:value-of select="gsa:i18n ('Entire Operation', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="interval-with-unit">
            <xsl:with-param name="interval">
              <xsl:value-of select="duration"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Schedule'"/>
            <xsl:with-param name="type" select="'schedule'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="schedule" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Schedule'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="first_time"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="next_time &gt; 0">
          <xsl:value-of select="next_time"/>
        </xsl:when>
        <xsl:otherwise>-</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="period = 0 and period_months = 0">
          <xsl:value-of select="gsa:i18n ('Once', 'Time')"/>
        </xsl:when>
        <xsl:when test="period = 0 and period_months = 1">
          1 <xsl:value-of select="gsa:i18n ('month', 'Time')"/>
        </xsl:when>
        <xsl:when test="period = 0">
          <xsl:value-of select="period_months"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="gsa:i18n ('months', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="interval-with-unit">
            <xsl:with-param name="interval">
              <xsl:value-of select="period"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="duration = 0">
          <xsl:value-of select="gsa:i18n ('Entire Operation', 'Time')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="interval-with-unit">
            <xsl:with-param name="interval">
              <xsl:value-of select="duration"/>
            </xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'schedule'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0"
               alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Schedule is still in use', 'Schedule')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="schedule" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Schedule Details', 'Schedule')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Schedule'"/>
        <xsl:with-param name="type" select="'schedule'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('First Run', 'Schedule')"/>:</td>
          <td>
            <xsl:value-of select="gsa:long-time (first_time)"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="timezone_abbrev"/>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Next Run', 'Schedule')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="next_time = 'over'">
                -
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:long-time (next_time)"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="timezone_abbrev"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Timezone', 'Time')"/>:</td>
          <td>
            <xsl:value-of select="timezone"/>
            <xsl:if test="timezone != timezone_abbrev">
              (<xsl:value-of select="timezone_abbrev"/>)
            </xsl:if>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Period', 'Schedule')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="period = 0 and period_months = 0">
                <xsl:value-of select="gsa:i18n ('Once', 'Time')"/>
              </xsl:when>
              <xsl:when test="period = 0 and period_months = 1">
                1 <xsl:value-of select="gsa:i18n ('month', 'Time')"/>
              </xsl:when>
              <xsl:when test="period = 0">
                <xsl:value-of select="period_months"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="gsa:i18n ('months', 'Time')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="interval-with-unit">
                  <xsl:with-param name="interval">
                    <xsl:value-of select="period"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Duration', 'Schedule')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="duration = 0">
                <xsl:value-of select="gsa:i18n ('Entire Operation', 'Time')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:call-template name="interval-with-unit">
                  <xsl:with-param name="interval">
                    <xsl:value-of select="duration"/>
                  </xsl:with-param>
                </xsl:call-template>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>

      <xsl:choose>
        <xsl:when test="count(tasks/task) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Schedule', 'Schedule')"/>: <xsl:value-of select="gsa:i18n ('None', 'Tasks')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Schedule', 'Schedule')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="tasks/task">
              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                             border="0"
                             alt="{gsa:i18n ('Details', 'Generic Resource')}"
                             style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'schedule'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'schedule'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     GET_SCHEDULE -->

<xsl:template match="get_schedule">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_schedule_response"/>
  <xsl:apply-templates select="modify_schedule_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="get_schedules_response/schedule" mode="details"/>
</xsl:template>

<!--     GET_SCHEDULES -->

<xsl:template match="get_schedules">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_schedule_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_schedule_response"/>
  <xsl:apply-templates select="modify_schedule_response"/>
  <!-- The for-each makes the get_schedules_response the current node. -->
  <xsl:for-each select="get_schedules_response | commands_response/get_schedules_response">
    <xsl:choose>
      <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
        <xsl:call-template name="command_result_dialog">
          <xsl:with-param name="operation">
            Get Schedules
          </xsl:with-param>
          <xsl:with-param name="status">
            <xsl:value-of select="@status"/>
          </xsl:with-param>
          <xsl:with-param name="msg">
            <xsl:value-of select="@status_text"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="html-schedules-table"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<!--    BEGIN SCANNERS MANAGEMENT -->

<xsl:template name="html-create-scanner-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('New Scanner', 'Scanner')"/>
      <a href="/help/new_scanner.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Scanner', 'Scanner'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_scanners&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Scanners', 'Scanner')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Scanners', 'Scanner')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_scanner"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_scanner"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Host', 'Host')"/></td>
            <td><input type="text" name="host" value="localhost" size="30"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Port', 'Port')"/></td>
            <td><input type="text" name="port" value="9391" size="30"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Type', 'Property')"/></td>
            <td>
              <select name="scanner_type">
                <xsl:call-template name="scanner-type-list">
                  <xsl:with-param name="default" select="2"/>
                </xsl:call-template>
              </select>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('CA Certificate', 'Auth Data')"/></td>
            <td><input type="file" name="ca_pub"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Certificate', 'Auth Data')"/></td>
            <td><input type="file" name="key_pub"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Private Key', 'Auth Data')"/></td>
            <td><input type="file" name="key_priv"/></td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Scanner', 'Scanner')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="create_scanner_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Scanner</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="delete_scanner_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Scanner
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="modify_scanner_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Scanner</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="new_scanner">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_scanner_response"/>
  <xsl:apply-templates select="commands_response/delete_scanner_response"/>
  <xsl:call-template name="html-create-scanner-form"/>
</xsl:template>

<xsl:template name="html-scanners-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'scanner'"/>
    <xsl:with-param name="cap-type" select="'Scanner'"/>
    <xsl:with-param name="resources-summary" select="scanners"/>
    <xsl:with-param name="resources" select="scanner"/>
    <xsl:with-param name="count" select="count (scanner)"/>
    <xsl:with-param name="filtered-count" select="scanner_count/filtered"/>
    <xsl:with-param name="full-count" select="scanner_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Host', 'Host')"/></name>
        <field>host</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Port', 'Port')"/></name>
        <field>port</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Type', 'Property')"/></name>
        <field>type</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="7"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-edit-scanner-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Scanner', 'Scanner')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Scanner'"/>
        <xsl:with-param name="type" select="'scanner'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_scanners_response/scanner/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_scanner"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="scanner_id"
               value="{commands_response/get_scanners_response/scanner/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="scanner" value="{/envelope/params/scanner}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" size="30" maxlength="80"
                     value="{commands_response/get_scanners_response/scanner/name}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{commands_response/get_scanners_response/scanner/comment}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Host', 'Host')"/></td>
            <td>
              <input type="text" name="host" size="30" maxlength="400"
                     value="{commands_response/get_scanners_response/scanner/host}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Port', 'Port')"/></td>
            <td>
              <input type="text" name="port" size="30" maxlength="400"
                     value="{commands_response/get_scanners_response/scanner/port}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Type', 'Property')"/></td>
            <td>
              <select name="scanner_type">
                <xsl:call-template name="scanner-type-list">
                  <xsl:with-param name="default" select="commands_response/get_scanners_response/scanner/type"/>
                </xsl:call-template>
              </select>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('CA Certificate', 'Auth Data')"/></td>
            <td><input type="file" name="ca_pub"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Certificate', 'Auth Data')"/></td>
            <td><input type="file" name="key_pub"/></td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Private Key', 'Auth Data')"/></td>
            <td><input type="file" name="key_priv"/></td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Scanner', 'Scanner')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_scanner">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_scanner_response"/>
  <xsl:call-template name="html-edit-scanner-form"/>
</xsl:template>

<xsl:template match="scanner" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Scanner Details', 'Scanner')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Scanner'"/>
        <xsl:with-param name="type" select="'scanner'"/>
      </xsl:call-template>
      <xsl:call-template name="scanner-icons">
        <xsl:with-param name="scanner_id" select="@id"/>
        <xsl:with-param name="ca_pub" select="ca_pub"/>
        <xsl:with-param name="key_pub" select="key_pub"/>
        <xsl:with-param name="next" select="'get_scanner'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Host', 'Host')"/>:</td>
          <td><xsl:value-of select="host"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Port', 'Port')"/>:</td>
          <td><xsl:value-of select="port"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Type', 'Property')"/>:</td>
          <td>
            <xsl:call-template name="scanner-type-name">
              <xsl:with-param name="type" select="type"/>
            </xsl:call-template>
          </td>
        </tr>
      </table>

      <xsl:choose>
        <!-- OpenVAS Scanner case -->
        <xsl:when test="info/scanner/name = 'OpenVAS'">
        </xsl:when>
        <!-- OSP Scanner is online case -->
        <xsl:when test="string-length(info/scanner/name)">
          <h1><xsl:value-of select="gsa:i18n ('Online Response of Scanner', 'Scanner')"/></h1>

          <table>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Scanner Name', 'Scanner')"/>:</td>
              <td><xsl:value-of select="info/scanner/name"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Scanner Version', 'Scanner')"/>:</td>
              <td><xsl:value-of select="info/scanner/version"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('OSP Daemon', 'Scanner')"/>:</td>
              <td>
                <xsl:value-of select="info/daemon/name"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="info/daemon/version"/>
              </td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Protocol', 'Scanner')"/>:</td>
              <td>
                <xsl:value-of select="info/protocol/name"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="info/protocol/version"/>
              </td>
            </tr>
          </table>

          <h2><xsl:value-of select="gsa:i18n ('Description', 'Property')"/></h2>

          <p>
            <xsl:call-template name="structured-text">
              <xsl:with-param name="string" select="info/description"/>
            </xsl:call-template>
          </p>

          <h2><xsl:value-of select="gsa:i18n ('Scanner parameters', 'Scanner')"/></h2>

          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n('Description', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n('Type', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n('Default', 'Property')"/></td>
            </tr>
            <xsl:for-each select="info/params/param">
              <tr class="{gsa:table-row-class(position())}">
                <td><xsl:value-of select="name"/></td>
                <td><xsl:value-of select="description"/></td>
                <td><xsl:value-of select="substring-after(type, 'osp_')"/></td>
                <td>
                  <xsl:choose>
                    <xsl:when test="type='osp_ovaldef_file'">OVAL Definitions files list.</xsl:when>
                    <xsl:when test="type='osp_selection'">List.</xsl:when>
                    <xsl:when test="type='osp_boolean' and default = '0'">False</xsl:when>
                    <xsl:when test="type='osp_boolean'">True</xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="default"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </xsl:for-each>
          </table>

        </xsl:when>
        <!-- OSP Scanner is offline case -->
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('OSP Scanner is offline', 'Scanner')"/></h1>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:choose>
        <xsl:when test="count(tasks/task) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Scanner', 'Scanner')"/>: <xsl:value-of select="gsa:i18n ('None', 'Tasks')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Scanner', 'Scanner')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="tasks/task">
              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png" border="0" alt="{gsa:i18n ('Details', 'Generic Resource')}" style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'scanner'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'scanner'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="get_scanner">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_scanner_response"/>
  <xsl:apply-templates select="modify_scanner_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="get_scanners_response/scanner" mode="details"/>
</xsl:template>

<xsl:template match="get_scanners">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_scanner_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_scanner_response"/>
  <xsl:apply-templates select="modify_scanner_response"/>
  <!-- The for-each makes the get_scanners_response the current node. -->
  <xsl:for-each select="get_scanners_response | commands_response/get_scanners_response">
    <xsl:choose>
      <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
        <xsl:call-template name="command_result_dialog">
          <xsl:with-param name="operation">
            Get Scanners
          </xsl:with-param>
          <xsl:with-param name="status">
            <xsl:value-of select="@status"/>
          </xsl:with-param>
          <xsl:with-param name="msg">
            <xsl:value-of select="@status_text"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="html-scanners-table"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template match="verify_scanner_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Verify Scanner</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template match="scanner">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Scanner'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_scanner&amp;scanner_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Scanner', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="host"/>
    </td>
    <td>
      <xsl:value-of select="port"/>
    </td>
    <td>
      <xsl:call-template name="scanner-type-name">
        <xsl:with-param name="type" select="type"/>
      </xsl:call-template>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Scanner'"/>
            <xsl:with-param name="type" select="'scanner'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
          <xsl:call-template name="scanner-icons">
            <xsl:with-param name="scanner_id" select="@id"/>
            <xsl:with-param name="ca_pub" select="ca_pub"/>
            <xsl:with-param name="key_pub" select="key_pub"/>
            <xsl:with-param name="next" select="'get_scanners'"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="scanner" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Scanner'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="host"/>
    </td>
    <td>
      <xsl:value-of select="port"/>
    </td>
    <td>
      <xsl:call-template name="scanner-type-name">
        <xsl:with-param name="type" select="type"/>
      </xsl:call-template>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'scanner'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0" alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Scanner is still in use', 'Scanner')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>


<!-- BEGIN SLAVES MANAGEMENT -->

<xsl:template name="html-create-slave-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Slave', 'Slave')"/>
      <a href="/help/new_slave.html?token={/envelope/token}"
         title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('New Slave', 'Slave'))}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_slaves&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Slaves', 'Slave')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Slaves', 'Slave')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_slave"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="get_slave"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>
            </td>
            <td>
              <input type="text" name="name" value="unnamed" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Host', 'Host')"/></td>
            <td>
              <input type="text" name="host" value="localhost" size="30"
                      maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Port', 'Port')"/></td>
            <td>
              <input type="text" name="port" value="9390" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Login', 'Auth Data')"/></td>
            <td>
              <input type="text" name="login" value="" size="30"
                     maxlength="80"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Password', 'Auth Data')"/></td>
            <td>
              <input type="password" autocomplete="off" name="password"
                     value="" size="30" maxlength="40"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Slave', 'Slave')}"/>
            </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_slave">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_slave_response"/>
  <xsl:apply-templates select="commands_response/delete_slave_response"/>
  <xsl:call-template name="html-create-slave-form"/>
</xsl:template>

<xsl:template name="html-slaves-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'slave'"/>
    <xsl:with-param name="cap-type" select="'Slave'"/>
    <xsl:with-param name="resources-summary" select="slaves"/>
    <xsl:with-param name="resources" select="slave"/>
    <xsl:with-param name="count" select="count (slave)"/>
    <xsl:with-param name="filtered-count" select="slave_count/filtered"/>
    <xsl:with-param name="full-count" select="slave_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Host', 'Host')"/></name>
        <field>host</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Port', 'Port')"/></name>
        <field>port</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Login', 'Auth Data')"/></name>
        <field>login</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="4"/>
  </xsl:call-template>
</xsl:template>

<!--     CREATE_SLAVE_RESPONSE -->

<xsl:template match="create_slave_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Create Slave</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     DELETE_SLAVE_RESPONSE -->

<xsl:template match="delete_slave_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">
      Delete Slave
    </xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     MODIFY_SLAVE_RESPONSE -->

<xsl:template match="modify_slave_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Slave</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     EDIT_SLAVE -->

<xsl:template name="html-edit-slave-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Slave', 'Slave')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Slave'"/>
        <xsl:with-param name="type" select="'slave'"/>
        <xsl:with-param name="id"
                        select="commands_response/get_slaves_response/slave/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <form action="" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_slave"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden"
               name="slave_id"
               value="{commands_response/get_slaves_response/slave/@id}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="slave" value="{/envelope/params/slave}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>
        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
            <td>
              <input type="text" name="name" size="30" maxlength="80"
                     value="{commands_response/get_slaves_response/slave/name}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="165"><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/> (<xsl:value-of select="gsa:i18n ('optional', 'Meta Property')"/>)</td>
            <td>
              <input type="text" name="comment" size="30" maxlength="400"
                     value="{commands_response/get_slaves_response/slave/comment}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Host', 'Host')"/></td>
            <td>
              <input type="text" name="host"
                     value="{commands_response/get_slaves_response/slave/host}"
                     size="30"
                     maxlength="1000"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Port', 'Port')"/></td>
            <td>
              <input type="text" name="port" size="30" maxlength="1000"
                     value="{commands_response/get_slaves_response/slave/port}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Login', 'Auth Data')"/></td>
            <td>
              <input type="text" name="login" size="30" maxlength="1000"
                     value="{commands_response/get_slaves_response/slave/login}"/>
            </td>
          </tr>
          <tr>
            <td valign="top" width="175"><xsl:value-of select="gsa:i18n ('Password', 'Auth Data')"/></td>
            <td>
              <input type="password" autocomplete="off" name="password"
                     size="30" maxlength="1000"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Slave', 'Slave')}"/>
            </td>
          </tr>
        </table>
        <br/>
      </form>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_slave">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_slave_response"/>
  <xsl:call-template name="html-edit-slave-form"/>
</xsl:template>

<!--     SLAVE -->

<xsl:template match="slave">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Slave'"/>
      </xsl:call-template>
      <b>
        <a href="/omp?cmd=get_slave&amp;slave_id={@id}&amp;filter={str:encode-uri (../filters/term, true ())}&amp;token={/envelope/token}"
           title="{gsa:view_details_title ('Slave', name)}">
          <xsl:value-of select="name"/>
        </a>
      </b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="host"/></td>
    <td><xsl:value-of select="port"/></td>
    <td><xsl:value-of select="login"/></td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Slave'"/>
            <xsl:with-param name="type" select="'slave'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="slave" mode="trash">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Slave'"/>
      </xsl:call-template>
      <b><xsl:value-of select="name"/></b>
      <xsl:choose>
        <xsl:when test="comment != ''">
          <br/>(<xsl:value-of select="comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td><xsl:value-of select="host"/></td>
    <td><xsl:value-of select="port"/></td>
    <td><xsl:value-of select="login"/></td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="in_use='0'">
          <xsl:call-template name="trash-delete-icon">
            <xsl:with-param name="type" select="'slave'"/>
            <xsl:with-param name="id" select="@id"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <img src="/img/delete_inactive.png"
               border="0"
               alt="{gsa:i18n ('Delete', 'Action Verb')}"
               title="{gsa:i18n ('Slave is still in use', 'Slave')}"
               style="margin-left:3px;"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="slave" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Slave Details', 'Slave')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Slave'"/>
        <xsl:with-param name="type" select="'slave'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td><b><xsl:value-of select="name"/></b></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Comment', 'Property')"/>:</td>
          <td><xsl:value-of select="comment"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Host', 'Host')"/>:</td>
          <td><xsl:value-of select="host"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Port', 'Port')"/>:</td>
          <td><xsl:value-of select="port"/></td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Login', 'Auth Data')"/>:</td>
          <td><xsl:value-of select="login"/></td>
        </tr>
      </table>

      <xsl:choose>
        <xsl:when test="count(tasks/task) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Slave', 'Slave')"/>: <xsl:value-of select="gsa:i18n ('None', 'Tasks')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Tasks using this Slave', 'Slave')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
            </tr>
            <xsl:for-each select="tasks/task">

              <tr class="{gsa:table-row-class(position())}">
                <xsl:choose>
                  <xsl:when test="boolean (permissions) and count (permissions/permission) = 0">
                    <td><xsl:value-of select="name"/> (<xsl:value-of select="gsa:i18n('Unavailable', 'Property')"/>, <xsl:value-of select="gsa:i18n('UUID', 'Property')"/>: <xsl:value-of select="@id"/>)</td>
                    <td width="100">
                      <img src="/img/details_inactive.png"
                           border="0"
                           alt="{gsa:i18n ('Details', 'Generic Resource')}"
                           style="margin-left:3px;"/>
                    </td>
                  </xsl:when>
                  <xsl:otherwise>
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="/omp?cmd=get_task&amp;task_id={@id}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                             border="0"
                             alt="{gsa:i18n ('Details', 'Generic Resource')}"
                             style="margin-left:3px;"/>
                      </a>
                    </td>
                  </xsl:otherwise>
                </xsl:choose>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="resource_type" select="'slave'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="resource_type" select="'slave'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<!--     GET_SLAVE -->

<xsl:template match="get_slave">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_slave_response"/>
  <xsl:apply-templates select="modify_slave_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:apply-templates select="get_slaves_response/slave" mode="details"/>
</xsl:template>

<!--     GET_SLAVES -->

<xsl:template match="get_slaves">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_slave_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_slave_response"/>
  <xsl:apply-templates select="modify_slave_response"/>
  <!-- The for-each makes the get_slaves_response the current node. -->
  <xsl:for-each select="get_slaves_response | commands_response/get_slaves_response">
    <xsl:choose>
      <xsl:when test="substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5'">
        <xsl:call-template name="command_result_dialog">
          <xsl:with-param name="operation">
            Get Slaves
          </xsl:with-param>
          <xsl:with-param name="status">
            <xsl:value-of select="@status"/>
          </xsl:with-param>
          <xsl:with-param name="msg">
            <xsl:value-of select="@status_text"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="html-slaves-table"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>


<!-- BEGIN GET RAW INFO -->

<xsl:template name="ref_cve_list">
  <xsl:param name="cvelist"/>

  <xsl:variable name="token" select="/envelope/token"/>

  <xsl:variable name="cvecount" select="count(str:split($cvelist, ','))"/>
  <xsl:if test="$cvecount &gt; 0">
    <tr valign="top">
      <td><xsl:value-of select="gsa:i18n('CVE', 'SecInfo|References')"/>:</td>
      <td>
        <xsl:for-each select="str:split($cvelist, ',')">
          <xsl:call-template name="get_info_cve_lnk">
            <xsl:with-param name="cve" select="."/>
            <xsl:with-param name="gsa_token" select="$token"/>
          </xsl:call-template>
          <xsl:if test="position() &lt; $cvecount">
            <xsl:text>, </xsl:text>
          </xsl:if>
        </xsl:for-each>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="ref_bid_list">
  <xsl:param name="bidlist"/>

  <xsl:variable name="token" select="/envelope/token"/>

  <xsl:variable name="bidcount" select="count(str:split($bidlist, ','))"/>
  <xsl:if test="$bidcount &gt; 0">
    <tr valign="top">
      <td><xsl:value-of select="gsa:i18n('BID', 'SecInfo|References')"/>:</td>
      <td>
        <xsl:for-each select="str:split($bidlist, ',')">
          <xsl:value-of select="."/>
          <xsl:if test="position() &lt; $bidcount">
            <xsl:text>, </xsl:text>
          </xsl:if>
        </xsl:for-each>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="ref_cert_list">
  <xsl:param name="certlist"/>
  <xsl:variable name="token" select="/envelope/token"/>
  <xsl:variable name="certcount" select="count($certlist/cert_ref)"/>

  <xsl:if test="count($certlist/warning)">
    <xsl:for-each select="$certlist/warning">
      <tr valign="top">
        <td><xsl:value-of select="gsa:i18n('CERT', 'SecInfo|References')"/>:</td>
        <td><i><xsl:value-of select="gsa:i18n ('Warning', 'SecInfo|References')"/>: <xsl:value-of select="text()"/></i></td>
      </tr>
    </xsl:for-each>
  </xsl:if>

  <xsl:if test="$certcount &gt; 0">
    <tr valign="top">
      <td><xsl:value-of select="gsa:i18n('CERT', 'SecInfo|References')"/>:</td>
      <td>
        <xsl:for-each select="$certlist/cert_ref">
          <xsl:choose>
            <xsl:when test="@type='CERT-Bund'">
              <xsl:call-template name="get_info_cert_bund_adv_lnk">
                <xsl:with-param name="cert_bund_adv" select="@id"/>
                <xsl:with-param name="gsa_token" select="$token"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="@type='DFN-CERT'">
              <xsl:call-template name="get_info_dfn_cert_adv_lnk">
                <xsl:with-param name="dfn_cert_adv" select="@id"/>
                <xsl:with-param name="gsa_token" select="$token"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <b>?</b><xsl:value-of select="./@id"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:if test="position() &lt; $certcount">
            <xsl:text>, </xsl:text>
          </xsl:if>
        </xsl:for-each>
      </td>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="ref_xref_list">
  <xsl:param name="xreflist"/>

  <xsl:variable name="token" select="/envelope/token"/>

  <xsl:variable name="xrefcount" select="count(str:split($xreflist, ','))"/>
  <xsl:if test="$xrefcount &gt; 0">
    <xsl:for-each select="str:split($xreflist, ',')">
      <tr valign="top">
        <td><xsl:if test="position()=1"><xsl:value-of select="gsa:i18n ('Other', 'SecInfo|References')"/>:</xsl:if></td>
        <xsl:choose>
          <xsl:when test="contains(., 'URL:')">
            <td><xsl:value-of select="substring-after(., 'URL:')"/></td>
          </xsl:when>
          <xsl:otherwise>
            <td><xsl:value-of select="."/></td>
          </xsl:otherwise>
        </xsl:choose>
      </tr>
    </xsl:for-each>
  </xsl:if>
</xsl:template>

<xsl:template match="info/cpe">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <b>
        <xsl:call-template name="get_info_cpe_lnk">
          <xsl:with-param name="cpe" select="../name"/>
          <xsl:with-param name="cpe_id" select="../@id"/>
        </xsl:call-template>
      </b>
      <xsl:choose>
        <xsl:when test="../comment != ''">
          <br/>(<xsl:value-of select="../comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="title != ''">
          <xsl:value-of select="title"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="../modification_time != ''">
          <xsl:value-of select="gsa:date (../modification_time)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="cve_refs"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="max_cvss &gt;= 0.0">
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="cvss" select="max_cvss"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="info/cve">

  <tbody class="{gsa:table-row-class(position())}">
    <tr>
      <td rowspan="2">
        <b>
          <xsl:call-template name="get_info_cve_lnk">
            <xsl:with-param name="cve" select="../name"/>
            <xsl:with-param name="cve_id" select="../@id"/>
          </xsl:call-template>
        </b>
        <xsl:choose>
          <xsl:when test="../comment != ''">
            <br/>(<xsl:value-of select="../comment"/>)
          </xsl:when>
          <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="vector != ''">
            <xsl:value-of select="vector"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="complexity != ''">
            <xsl:value-of select="complexity"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="authentication != ''">
            <xsl:value-of select="authentication"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="confidentiality_impact != ''">
            <xsl:value-of select="confidentiality_impact"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="integrity_impact != ''">
            <xsl:value-of select="integrity_impact"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="availability_impact != ''">
            <xsl:value-of select="availability_impact"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="../creation_time != ''">
            <xsl:value-of select="gsa:date (../creation_time)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="cvss &gt;= 0.0">
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="cvss" select="cvss"/>
              <xsl:with-param name="scale" select="7"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
              <xsl:with-param name="scale" select="7"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <xsl:choose>
        <xsl:when test="/envelope/params/bulk_select = 1">
          <td style="text-align:center" rowspan="2">
            <label style="width:100%">
              <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
            </label>
          </td>
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </tr>
    <tr>
      <td colspan="8" style="font-size: 80%;">
        <xsl:variable name="truncate_length"
        select="string-length(description) - string-length(substring-after(substring(description, 250), ' ')) + 1"/>
        <xsl:value-of select="substring(description, 0, $truncate_length)"/>
        <xsl:if test="string-length(description) >= $truncate_length"><i><abbr title="[...] {substring(description, $truncate_length, string-length(description))}">[...]</abbr></i></xsl:if>
      </td>
    </tr>
  </tbody>
</xsl:template>

<xsl:template match="info/nvt">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <b>
        <xsl:call-template name="get_info_nvt_lnk">
          <xsl:with-param name="nvt" select="../name"/>
          <xsl:with-param name="oid" select="@oid"/>
        </xsl:call-template>
      </b>
    </td>
    <td>
      <a href="/omp?cmd=get_info&amp;info_type=nvt&amp;filter=family=&quot;{family}&quot;&amp;token={/envelope/token}">
        <xsl:value-of select="family"/>
      </a>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="../creation_time != ''">
          <xsl:value-of select="gsa:date (../creation_time)"/>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="../modification_time != ''">
          <xsl:value-of select="gsa:date (../modification_time)"/>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="version"/>
    </td>
    <td>
      <!-- "NOCVE" means no CVE ID, skip. -->
      <xsl:choose>
        <xsl:when test="cve_id = 'NOCVE'">
        </xsl:when>
        <xsl:otherwise>
          <!-- get the GSA token before entering the for-each loop over the str:tokenize elements -->
          <xsl:variable name="gsa_token" select="/envelope/token"/>

          <xsl:for-each select="str:tokenize (cve_id, ', ')">
            <xsl:call-template name="get_info_cve_lnk">
              <xsl:with-param name="cve" select="text()"/>
              <xsl:with-param name="gsa_token" select="$gsa_token"/>
            </xsl:call-template>
            <xsl:text> </xsl:text>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:variable name="solution_type">
        <xsl:for-each select="str:split (tags, '|')">
          <xsl:if test="'solution_type' = substring-before (., '=')">
            <xsl:value-of select="substring-after (., '=')"/>
          </xsl:if>
        </xsl:for-each>
      </xsl:variable>
      <xsl:call-template name="solution-icon">
        <xsl:with-param name="solution_type" select="$solution_type"/>
      </xsl:call-template>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="cvss_base &gt;= 0.0">
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="cvss" select="cvss_base"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="qod/value != ''">
          <xsl:value-of select="qod/value"/>%
        </xsl:when>
        <xsl:otherwise/>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="info/ovaldef">

  <tbody class="{gsa:table-row-class(position())}">
    <tr>
      <td rowspan="2">
        <b>
          <xsl:call-template name="get_info_ovaldef_lnk">
            <xsl:with-param name="ovaldef" select="../name"/>
            <xsl:with-param name="ovaldef_id" select="../@id"/>
          </xsl:call-template>
        </b>
        <br/>
        <span style="font-size:80%; color:grey">
          <xsl:choose>
            <xsl:when test="string-length(file) > 45">
              <abbr title="{file}"><i>[...]</i><xsl:value-of select="substring(file, string-length(file)-40, string-length(file))"/></abbr>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="file"/>
            </xsl:otherwise>
          </xsl:choose>
        </span>
        <xsl:choose>
          <xsl:when test="../comment != ''">
            <br/>(<xsl:value-of select="../comment"/>)
          </xsl:when>
          <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="version != ''">
            <xsl:value-of select="version"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="status != ''">
            <xsl:value-of select="status"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="class != ''">
            <xsl:value-of select="class"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="../creation_time != ''">
            <xsl:value-of select="gsa:date (../creation_time)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="../modification_time != ''">
            <xsl:value-of select="gsa:date (../modification_time)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:value-of select="cve_refs"/>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="max_cvss &gt;= 0.0">
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="cvss" select="max_cvss"/>
              <xsl:with-param name="scale" select="7"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
              <xsl:with-param name="scale" select="7"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <xsl:choose>
        <xsl:when test="/envelope/params/bulk_select = 1">
          <td style="text-align:center" rowspan="2">
            <label style="width:100%">
              <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
            </label>
          </td>
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </tr>
    <tr>
      <td colspan="7" style="font-size: 80%;">
        <xsl:choose>
          <xsl:when test="title != ''">
            <xsl:variable name="truncate_length"
              select="string-length(title) - string-length(substring-after(substring(title, 200), ' ')) + 1"/>
            <xsl:value-of select="substring(title, 0, $truncate_length)"/>
            <xsl:if test="string-length(title) >= $truncate_length"><i><abbr title="[...] {substring(title, $truncate_length, string-length(title))}">[...]</abbr></i></xsl:if>
          </xsl:when>
          <xsl:otherwise>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
  </tbody>
</xsl:template>

<xsl:template match="info/cert_bund_adv">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <b>
        <xsl:call-template name="get_info_cert_bund_adv_lnk">
          <xsl:with-param name="cert_bund_adv" select="../name"/>
          <xsl:with-param name="cert_bund_adv_id" select="../@id"/>
        </xsl:call-template>
      </b>
      <xsl:choose>
        <xsl:when test="../comment != ''">
          <br/>(<xsl:value-of select="../comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="title"/>
    </td>
    <td>
      <xsl:value-of select="gsa:date (../creation_time)"/>
    </td>
    <td>
      <xsl:value-of select="cve_refs"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="max_cvss &gt;= 0.0">
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="cvss" select="max_cvss"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="info/dfn_cert_adv">
  <tr class="{gsa:table-row-class(position())}">
    <td>
      <b>
        <xsl:call-template name="get_info_dfn_cert_adv_lnk">
          <xsl:with-param name="dfn_cert_adv" select="../name"/>
          <xsl:with-param name="dfn_cert_adv_id" select="../@id"/>
        </xsl:call-template>
      </b>
      <xsl:choose>
        <xsl:when test="../comment != ''">
          <br/>(<xsl:value-of select="../comment"/>)
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="title"/>
    </td>
    <td>
      <xsl:value-of select="gsa:date (../creation_time)"/>
    </td>
    <td>
      <xsl:value-of select="cve_refs"/>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="max_cvss &gt;= 0.0">
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="cvss" select="max_cvss"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="severity-bar">
            <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
            <xsl:with-param name="scale" select="7"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="info/allinfo">

  <tbody class="{gsa:table-row-class(position())}">
    <tr>
      <td rowspan="2">
        <b>
          <xsl:call-template name="get_info_allinfo_lnk">
            <xsl:with-param name="name" select="../name"/>
            <xsl:with-param name="type" select="type"/>
            <xsl:with-param name="id" select="../@id"/>
          </xsl:call-template>
        </b>
        <xsl:choose>
          <xsl:when test="../comment != ''">
            <br/>(<xsl:value-of select="../comment"/>)
          </xsl:when>
          <xsl:otherwise></xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="type != ''">
            <xsl:value-of select="type"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="../creation_time != ''">
            <xsl:value-of select="gsa:date (../creation_time)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="../modification_time != ''">
            <xsl:value-of select="gsa:date (../modification_time)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="gsa:i18n ('N/A', 'Value')"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:choose>
          <xsl:when test="severity &gt;= 0.0">
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="cvss" select="severity"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <xsl:choose>
        <xsl:when test="/envelope/params/bulk_select = 1">
          <td style="text-align:center" rowspan="2">
            <label style="width:100%">
              <input name="bulk_selected:{../@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
            </label>
          </td>
        </xsl:when>
        <xsl:otherwise></xsl:otherwise>
      </xsl:choose>
    </tr>
    <tr>
      <td colspan="4" style="font-size: 95%;">
        <xsl:variable name="summary">
          <xsl:choose>
            <xsl:when test="contains(extra, 'summary=')">
              <xsl:for-each select="str:split (extra, '|')">
                <xsl:if test="'summary' = substring-before (., '=')">
                  <xsl:value-of select="substring-after (., '=')"/><br />
                </xsl:if>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
             <xsl:value-of select="extra"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="truncate_length" select="string-length($summary) - string-length(substring-after(substring($summary, 135), ' ')) + 1"/>
        <xsl:value-of select="substring($summary, 0, $truncate_length)"/>
        <xsl:if test="string-length($summary) >= $truncate_length"><i><abbr title="[...] {substring(extra, $truncate_length, string-length($summary))}">[...]</abbr></i></xsl:if>
      </td>
    </tr>
  </tbody>
</xsl:template>

<xsl:template name="get_info_allinfo_action">
  <xsl:param name="name"/>
  <xsl:param name="info_name"/>
  <xsl:param name="info_id"/>
  <xsl:param name="type"/>
  <xsl:param name="action"/>
  <!-- i18n with concat : see dynamic_strings.xsl - type-details -->
  <a href="/omp?cmd=get_info&amp;info_type={$type}&amp;info_id={$info_id}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;filt_id={../../filters/@id}&amp;token={/envelope/token}"
     title="{gsa:i18n (concat ($name, ' Details'))}" style="margin-left:3px;">
    <img src="/img/details.png" border="0" alt="{gsa:i18n (concat ($name, ' Details'))}"/>
  </a>
</xsl:template>

<xsl:template name="get_info_allinfo_lnk">
 <xsl:param name="name"/>
 <xsl:param name="type"/>
 <xsl:param name="id"/>
  <xsl:choose>
    <xsl:when test="$type = 'cve'">
      <xsl:call-template name="get_info_cve_lnk">
        <xsl:with-param name="cve" select="$name"/>
        <xsl:with-param name="cve_id" select="$id"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$type = 'cpe'">
      <xsl:call-template name="get_info_cpe_lnk">
        <xsl:with-param name="cpe" select="$name"/>
        <xsl:with-param name="cpe_id" select="$id"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$type = 'ovaldef'">
      <xsl:call-template name="get_info_ovaldef_lnk">
        <xsl:with-param name="ovaldef" select="$name"/>
        <xsl:with-param name="ovaldef_id" select="$id"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$type = 'nvt'">
      <xsl:call-template name="get_info_nvt_lnk">
        <xsl:with-param name="nvt" select="$name"/>
        <xsl:with-param name="oid" select="$id"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$type = 'cert_bund_adv'">
      <xsl:call-template name="get_info_cert_bund_adv_lnk">
        <xsl:with-param name="cert_bund_adv" select="$name"/>
        <xsl:with-param name="cert_bund_adv_id" select="$id"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="$type = 'dfn_cert_adv'">
      <xsl:call-template name="get_info_dfn_cert_adv_lnk">
        <xsl:with-param name="dfn_cert_adv" select="$name"/>
        <xsl:with-param name="dfn_cert_adv_id" select="$id"/>
      </xsl:call-template>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="get_info_cpe_lnk">
  <xsl:param name="cpe"/>
  <xsl:param name="cpe_id"/>
  <xsl:param name="no_icon"/>
  <xsl:param name="hide_other_icon"/>
  <xsl:variable name="cpe_select">
    <xsl:choose>
      <xsl:when test="$cpe_id">info_id=<xsl:value-of select="str:encode-uri (str:replace($cpe_id, '&amp;','&amp;amp;'), true())"/></xsl:when>
      <xsl:otherwise>info_name=<xsl:value-of select="str:encode-uri (str:replace($cpe, '&amp;','&amp;amp;'), true())"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <span style="white-space:nowrap">
    <xsl:if test="not($no_icon)">
      <xsl:call-template name="cpe-icon">
        <xsl:with-param name="cpe" select="$cpe"/>
        <xsl:with-param name="hide_other" select="$hide_other_icon"/>
      </xsl:call-template>
    </xsl:if>
    <a href="/omp?cmd=get_info&amp;info_type=cpe&amp;{$cpe_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;filt_id={../../filters/@id}&amp;token={/envelope/token}"
       title="{gsa:view_details_title ('CPE', $cpe)}">
      <xsl:call-template name="wrap" disable-output-escaping="yes">
        <xsl:with-param name="string" select="$cpe"/>
        <xsl:with-param name="width" select="'55'"/>
        <xsl:with-param name="marker" select="'&#8629;&lt;br/&gt;'"/>
      </xsl:call-template>
    </a>
  </span>
</xsl:template>

<xsl:template name="get_info_cve_lnk">
  <xsl:param name="cve"/>
  <xsl:param name="cve_id"/>
  <xsl:param name="gsa_token"/>
  <xsl:variable name="cve_select">
    <xsl:choose>
      <xsl:when test="$cve_id">info_id=<xsl:value-of select="$cve_id"/></xsl:when>
      <xsl:otherwise>info_name=<xsl:value-of select="normalize-space($cve)"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$gsa_token = ''">
      <a href="/omp?cmd=get_info&amp;info_type=cve&amp;{$cve_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;filt_id={../../filters/@id}&amp;token={/envelope/token}"
         title="{gsa:view_details_title ('CVE', $cve)}"><xsl:value-of select="normalize-space($cve)"/></a>
    </xsl:when>
    <xsl:otherwise>
      <a href="/omp?cmd=get_info&amp;info_type=cve&amp;{$cve_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;filt_id={../../filters/@id}&amp;token={$gsa_token}"
         title="{gsa:i18n ('Details', 'Generic Resource')}"><xsl:value-of select="normalize-space($cve)"/></a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="get_info_nvt_lnk">
  <xsl:param name="nvt"/>
  <xsl:param name="oid"/>
  <xsl:param name="gsa_token"/>
  <xsl:variable name="nvt_select">
    <xsl:choose>
      <xsl:when test="$oid">info_id=<xsl:value-of select="$oid"/></xsl:when>
      <xsl:otherwise>info_name=<xsl:value-of select="normalize-space($nvt)"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$gsa_token = ''">
      <a href="/omp?cmd=get_info&amp;info_type=nvt&amp;{$nvt_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;filt_id={../../filters/@id}&amp;token={/envelope/token}"
         title="{gsa:view_details_title ('NVT', $oid)}"><xsl:value-of select="normalize-space($nvt)"/></a>
    </xsl:when>
    <xsl:otherwise>
      <a href="/omp?cmd=get_info&amp;info_type=nvt&amp;{$nvt_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;filt_id={../../filters/@id}&amp;token={$gsa_token}"
         title="{gsa:view_details_title ('NVT', $oid)}"><xsl:value-of select="normalize-space($nvt)"/></a>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="get_info_ovaldef_lnk">
  <xsl:param name="ovaldef"/>
  <xsl:param name="ovaldef_id"/>
  <xsl:variable name="ovaldef_select">
    <xsl:choose>
      <xsl:when test="$ovaldef_id">info_id=<xsl:value-of select="$ovaldef_id"/></xsl:when>
      <xsl:otherwise>info_name=<xsl:value-of select="$ovaldef"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <a href="/omp?cmd=get_info&amp;info_type=ovaldef&amp;{$ovaldef_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;token={/envelope/token}"
     title="{gsa:view_details_title ('OVAL Definition', $ovaldef)}">
     <xsl:call-template name="wrap" disable-output-escaping="yes">
      <xsl:with-param name="string" select="$ovaldef"/>
      <xsl:with-param name="width" select="'55'"/>
      <xsl:with-param name="marker" select="'&#8629;&lt;br/&gt;'"/>
    </xsl:call-template>
  </a>
</xsl:template>

<xsl:template name="get_info_cert_bund_adv_lnk">
  <xsl:param name="cert_bund_adv"/>
  <xsl:param name="cert_bund_adv_id"/>
  <xsl:variable name="cert_bund_adv_select">
    <xsl:choose>
      <xsl:when test="$cert_bund_adv_id">info_id=<xsl:value-of select="$cert_bund_adv_id"/></xsl:when>
      <xsl:otherwise>info_name=<xsl:value-of select="$cert_bund_adv"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <a href="/omp?cmd=get_info&amp;info_type=cert_bund_adv&amp;{$cert_bund_adv_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;token={/envelope/token}"
     title="{gsa:view_details_title ('CERT-Bund Advisory', $cert_bund_adv)}">
    <xsl:call-template name="wrap" disable-output-escaping="yes">
      <xsl:with-param name="string" select="$cert_bund_adv"/>
      <xsl:with-param name="width" select="'55'"/>
      <xsl:with-param name="marker" select="'&#8629;&lt;br/&gt;'"/>
    </xsl:call-template>
  </a>
</xsl:template>

<xsl:template name="get_info_dfn_cert_adv_lnk">
  <xsl:param name="dfn_cert_adv"/>
  <xsl:param name="dfn_cert_adv_id"/>
  <xsl:variable name="dfn_cert_adv_select">
    <xsl:choose>
      <xsl:when test="$dfn_cert_adv_id">info_id=<xsl:value-of select="$dfn_cert_adv_id"/></xsl:when>
      <xsl:otherwise>info_name=<xsl:value-of select="$dfn_cert_adv"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <a href="/omp?cmd=get_info&amp;info_type=dfn_cert_adv&amp;{$dfn_cert_adv_select}&amp;details=1&amp;filter={str:encode-uri (../../filters/term, true ())}&amp;token={/envelope/token}"
     title="{gsa:view_details_title ('DFN-CERT Advisory', $dfn_cert_adv)}">
    <xsl:call-template name="wrap" disable-output-escaping="yes">
      <xsl:with-param name="string" select="$dfn_cert_adv"/>
      <xsl:with-param name="width" select="'55'"/>
      <xsl:with-param name="marker" select="'&#8629;&lt;br/&gt;'"/>
    </xsl:call-template>
  </a>
</xsl:template>

<xsl:template name="html-cpe-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/cpes.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'cpe'"/>
    <xsl:with-param name="cap-type" select="'CPE'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/cpe"/>
    <xsl:with-param name="count" select="count (info/cpe)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>
    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'cpe'"/>
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Title', 'Property')"/></name>
        <field>title</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Modified', 'Date')"/></name>
        <field>modified</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('CVEs', 'CVE')"/></name>
        <field>cves</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-cve-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/cves.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'cve'"/>
    <xsl:with-param name="cap-type" select="'CVE'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/cve"/>
    <xsl:with-param name="count" select="count (info/cve)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>

    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'cve'"/>
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Vector', 'CVSS Vector Short')"/></name>
        <field>vector</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Complexity', 'CVSS Vector Short')"/></name>
        <field>complexity</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Authentication', 'CVSS Vector Short')"/></name>
        <field>authentication</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Confidentiality Impact', 'CVSS Vector Short')"/></name>
        <field>confidentiality_impact</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Integrity Impact', 'CVSS Vector Short')"/></name>
        <field>integrity_impact</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Availability Impact', 'CVSS Vector Short')"/></name>
        <field>availability_impact</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Published', 'Date')"/></name>
        <field>published</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-nvt-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/nvts.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'nvt'"/>
    <xsl:with-param name="cap-type" select="'NVT'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/nvt"/>
    <xsl:with-param name="count" select="count (info/nvt)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>
    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'nvt'"/>
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Family', 'NVT')"/></name>
        <field>family</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Created', 'Date')"/></name>
        <field>created</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Modified', 'Date')"/></name>
        <field>modified</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Version', 'NVT')"/></name>
        <field>version</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('CVE', 'CVE')"/></name>
        <field>cve</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Solution type', 'NVT or Result')"/></name>
        <field>solution_type</field>
        <image>/img/solution_type.png</image>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('QoD', 'NVT or Result')"/></name>
        <field>qod</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-ovaldef-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/ovaldefs.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'ovaldef'"/>
    <xsl:with-param name="cap-type" select="'OVAL Definition'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/ovaldef"/>
    <xsl:with-param name="count" select="count (info/ovaldef)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>
    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'ovaldef'"/>
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Version', 'OVAL Definition')"/></name>
        <field>version</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Status', 'OVAL Definition')"/></name>
        <field>status</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Class', 'OVAL Definition')"/></name>
        <field>class</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Created', 'Date')"/></name>
        <field>created</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Modified', 'Date')"/></name>
        <field>modified</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('CVEs', 'CVE')"/></name>
        <field>cves</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-cert_bund_adv-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/cert_bund_advs.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'cert_bund_adv'"/>
    <xsl:with-param name="cap-type" select="'CERT-Bund Advisory'"/>
    <xsl:with-param name="cap-type-plural" select="'CERT-Bund Advisories'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/cert_bund_adv"/>
    <xsl:with-param name="count" select="count (info/cert_bund_adv)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>

    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'cert_bund_adv'"/>
      </xsl:call-template>
    </xsl:with-param>

    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Title', 'Property')"/></name>
        <field>title</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Created', 'Date')"/></name>
        <field>created</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('CVEs', 'CVE')"/></name>
        <field>cves</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-dfn_cert_adv-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/dfn_cert_advs.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'dfn_cert_adv'"/>
    <xsl:with-param name="cap-type" select="'DFN-CERT Advisory'"/>
    <xsl:with-param name="cap-type-plural" select="'DFN-CERT Advisories'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/dfn_cert_adv"/>
    <xsl:with-param name="count" select="count (info/dfn_cert_adv)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>

    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'dfn_cert_adv'"/>
      </xsl:call-template>
    </xsl:with-param>

    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Title', 'Property')"/></name>
        <field>title</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Created', 'Date')"/></name>
        <field>created</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('CVEs', 'CVE')"/></name>
        <field>cves</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-allinfo-table">
  <xsl:if test="@status = 400">
    <xsl:call-template name="error_window">
      <xsl:with-param name="heading">Warning: SecInfo Database Missing</xsl:with-param>
      <xsl:with-param name="message">
        SCAP and/or CERT database missing on OMP server.
        <a href="/help/allinfo.html?token={/envelope/token}#secinfo_missing"
           title="Help: SecInfo database missing">
          <img style="margin-left:5px" src="/img/help.png"/>
        </a>
      </xsl:with-param>
    </xsl:call-template>
    <br/>
  </xsl:if>
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'info'"/>
    <xsl:with-param name="subtype" select="'allinfo'"/>
    <xsl:with-param name="cap-type" select="'All SecInfo Information'"/>
    <xsl:with-param name="cap-type-plural" select="'All SecInfo Information'"/>
    <xsl:with-param name="resources-summary" select="info"/>
    <xsl:with-param name="resources" select="info/allinfo"/>
    <xsl:with-param name="count" select="count (info/allinfo)"/>
    <xsl:with-param name="filtered-count" select="info_count/filtered"/>
    <xsl:with-param name="full-count" select="info_count/text ()"/>
    <xsl:with-param name="no_bulk" select="1"/>
    <xsl:with-param name="top-visualization">
      <xsl:call-template name="init-d3charts"/>
      <xsl:call-template name="js-secinfo-top-visualization">
        <xsl:with-param name="type" select="'allinfo'"/>
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Name', 'Property')"/></name>
        <field>name</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Type', 'Property')"/></name>
        <field>type</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Created', 'Date')"/></name>
        <field>created</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Modified', 'Date')"/></name>
        <field>modified</field>
        <sort-reverse/>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Severity', 'Severity Short')"/></name>
        <field>severity</field>
        <sort-reverse/>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="/envelope/params/bulk_select = 1"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="get_info_response">
  <xsl:choose>
    <xsl:when test="(substring(@status, 1, 1) = '4' or substring(@status, 1, 1) = '5') and not (contains (@status_text, 'GET_INFO requires the'))">
      <xsl:call-template name="command_result_dialog">
        <xsl:with-param name="operation">
          Get SecInfo
        </xsl:with-param>
        <xsl:with-param name="status">
          <xsl:value-of select="@status"/>
        </xsl:with-param>
        <xsl:with-param name="msg">
          <xsl:value-of select="@status_text"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'CPE' or /envelope/params/info_type = 'cpe'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="cpe-details"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-cpe-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'CVE' or /envelope/params/info_type = 'cve'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="cve-details"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-cve-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'NVT' or /envelope/params/info_type = 'nvt'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="nvt-details">
            <xsl:with-param name="nvts_response" select="info"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-nvt-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'OVALDEF' or /envelope/params/info_type = 'ovaldef'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="ovaldef-details"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-ovaldef-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'CERT_BUND_ADV' or /envelope/params/info_type = 'cert_bund_adv'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="cert_bund_adv-details"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-cert_bund_adv-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'DFN_CERT_ADV' or /envelope/params/info_type = 'dfn_cert_adv'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="dfn_cert_adv-details"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-dfn_cert_adv-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:when test="/envelope/params/info_type = 'ALLINFO' or /envelope/params/info_type = 'allinfo'">
      <xsl:choose>
        <xsl:when test="(/envelope/params/info_name and info_count/filtered &lt;= 1)
                        or /envelope/params/info_id">
          <xsl:call-template name="allinfo-details"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="html-allinfo-table"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <div class="gb_window">
        <div class="gb_window_part_left"></div>
        <div class="gb_window_part_right"></div>
        <div class="gb_window_part_center">SecInfo Management</div>
        <div class="gb_window_part_content">
          <xsl:choose>
            <xsl:when test="contains (@status_text, 'SCAP') and @status = '400'">
              <h1>SecInfo Database not available</h1>
              <p>
                Please ensure that your SCAP data is synced by either running openvas-scapdata-sync
                or greenbone-scapdata-sync on your system.
              </p>
            </xsl:when>
            <xsl:when test="contains (@status_text, 'CVE-')">
              <h1>Unknown vulnerability</h1>
              <p>
                <xsl:value-of select="@status_text"/>
              </p>
              <p>
                Please ensure that your SCAP data is up to date and that you entered
                a valid CVE. If the problem persists, the CVE is not available.
                In some cases, CVE references are reserved but did not
                enter the offical CVE database yet. Some were reserved and used as
                a reference by vendors, but never entered the CVE database.
              </p>
            </xsl:when>
            <xsl:otherwise>
              <h1>Unknown element</h1>
              <p>
                <xsl:value-of select="@status_text"/>
              </p>
              <p>
                Unknown element type. Ensure that the URL is correct and
                especially that the <code>info_type</code> and
                <code>info_name</code> parameters are consistent.
              </p>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </div>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="cve-details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('CVE Details', 'CVE')"/>
      <a href="/help/cve_details.html?token={/envelope/token}"
        title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('CVE', 'CVE'),' (',gsa:i18n('CVE Details', 'CVE'),')')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_info&amp;info_type=cve&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
        title="{gsa:i18n ('CVEs', 'CVE')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('CVEs', 'CVE')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <div class="float_right" style="font-size: 10px;">
        <table style="font-size: 10px;">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
            <td>
              <xsl:choose>
                <xsl:when test="info/cve">
                  <xsl:value-of select="info/cve/raw_data/cve:entry/@id"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="/envelope/params/info_name"/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Published', 'Date')"/>:</td>
            <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:published-datetime"/></td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
            <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:last-modified-datetime"/></td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last updated', 'Date')"/>:</td>
            <td><xsl:value-of select="info/update_time"/></td>
          </tr>
        </table>
      </div>

      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
          <td>
            <b>
              <xsl:choose>
                <xsl:when test="info/cve">
                  <xsl:value-of select="info/cve/raw_data/cve:entry/@id"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="/envelope/params/info_name"/>
                </xsl:otherwise>
              </xsl:choose>
            </b>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('CWE ID', 'CVE')"/>:</td>
          <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cwe/@id"/></td>
        </tr>
      </table>

      <xsl:choose>
        <xsl:when test="info/cve">
          <h1><xsl:value-of select="gsa:i18n ('Description', 'Property')"/></h1>
          <xsl:value-of select="info/cve/raw_data/cve:entry/vuln:summary/text()"/>

          <xsl:choose>
            <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss">
              <h1>CVSS</h1>
              <table>
                <tr>
                  <td><xsl:value-of select="gsa:i18n ('Base score', 'CVE')"/></td>
                  <td>
                    <div style="float: left;">
                      <xsl:call-template name="severity-bar">
                        <xsl:with-param name="cvss" select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:score"/>
                      </xsl:call-template>
                    </div>
                    <xsl:variable name="vector">
                      <xsl:text>AV:</xsl:text>
                      <xsl:choose>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-vector = 'LOCAL'">L</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-vector = 'NETWORK'">N</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-vector = 'ADJACENT_NETWORK'">A</xsl:when>
                        <xsl:otherwise>ERROR</xsl:otherwise>
                      </xsl:choose>/AC:<xsl:choose>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-complexity = 'LOW'">L</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-complexity = 'MEDIUM'">M</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-complexity = 'HIGH'">H</xsl:when>
                        <xsl:otherwise>ERROR</xsl:otherwise>
                      </xsl:choose>/Au:<xsl:choose>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:authentication = 'NONE'">N</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:authentication = 'MULTIPLE_INSTANCES'">M</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:authentication = 'SINGLE_INSTANCE'">S</xsl:when>
                        <xsl:otherwise>ERROR</xsl:otherwise>
                      </xsl:choose>/C:<xsl:choose>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:confidentiality-impact = 'NONE'">N</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:confidentiality-impact = 'PARTIAL'">P</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:confidentiality-impact = 'COMPLETE'">C</xsl:when>
                        <xsl:otherwise>ERROR</xsl:otherwise>
                      </xsl:choose>/I:<xsl:choose>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:integrity-impact = 'NONE'">N</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:integrity-impact = 'PARTIAL'">P</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:integrity-impact = 'COMPLETE'">C</xsl:when>
                        <xsl:otherwise>ERROR</xsl:otherwise>
                      </xsl:choose>/A:<xsl:choose>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:availability-impact = 'NONE'">N</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:availability-impact = 'PARTIAL'">P</xsl:when>
                        <xsl:when test="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:availability-impact = 'COMPLETE'">C</xsl:when>
                        <xsl:otherwise>ERROR</xsl:otherwise>
                      </xsl:choose>
                    </xsl:variable>
                    (<a href="/omp?cmd=cvss_calculator&amp;cvss_vector={$vector}&amp;token={/envelope/token}">
                      <xsl:value-of select="$vector"/>
                    </a>)
                  </td>
                </tr>
                <tr>
                  <td>Access vector</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-vector"/></td>
                </tr>
                <tr>
                  <td>Access Complexity</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:access-complexity"/></td>
                </tr>
                <tr>
                  <td>Authentication</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:authentication"/></td>
                </tr>
                <tr>
                  <td>Confidentiality impact</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:confidentiality-impact"/></td>
                </tr>
                <tr>
                  <td>Integrity impact</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:integrity-impact"/></td>
                </tr>
                <tr>
                  <td>Availability impact</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:availability-impact"/></td>
                </tr>
                <tr>
                  <td>Source</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:source"/></td>
                </tr>
                <tr>
                  <td>Generated</td>
                  <td><xsl:value-of select="info/cve/raw_data/cve:entry/vuln:cvss/cvss:base_metrics/cvss:generated-on-datetime"/></td>
                </tr>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <h1>CVSS:
                <div style="display: inline-block; vertical-align: middle;">
                  <xsl:call-template name="severity-bar">
                    <xsl:with-param name="extra_text" select="'N/A'"/>
                  </xsl:call-template>
                </div>
              </h1>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cve/raw_data/cve:entry/vuln:references) = 0">
              <h1><xsl:value-of select="gsa:i18n ('References', 'SecInfo')"/>: <xsl:value-of select="gsa:i18n ('None', 'SecInfo|References')"/></h1>
            </xsl:when>
            <xsl:otherwise>
              <h1><xsl:value-of select="gsa:i18n ('References', 'SecInfo')"/></h1>
              <table>
                <xsl:for-each select="info/cve/raw_data/cve:entry/vuln:references">
                  <tr>
                    <td><xsl:value-of select="vuln:source/text()"/></td>
                  </tr>
                  <tr>
                    <td></td>
                    <td><xsl:value-of select="vuln:reference/text()"/></td>
                  </tr>
                  <tr>
                    <td></td>
                    <td><xsl:value-of select="vuln:reference/@href"/></td>
                  </tr>
                </xsl:for-each>
              </table>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cve/cert/cert_ref) = 0">
            </xsl:when>
            <xsl:otherwise>
              <h1><xsl:value-of select="gsa:i18n ('CERT Advisories referencing this CVE', 'CVE')"/></h1>
              <table class="gbntable" cellspacing="2" cellpadding="4">
                <tr class="gbntablehead2">
                  <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
                  <td><xsl:value-of select="gsa:i18n ('Title', 'Property')"/></td>
                  <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
                </tr>
                <xsl:for-each select="info/cve/cert/cert_ref">

                  <tr class="{gsa:table-row-class(position())}">
                    <td><xsl:value-of select="name"/></td>
                    <td><xsl:value-of select="title"/></td>
                    <td width="100">
                      <xsl:choose>
                        <xsl:when test="@type='CERT-Bund'">
                        <a href="?cmd=get_info&amp;info_type=cert_bund_adv&amp;info_name={name}&amp;details=1&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                          <img src="/img/details.png"
                          border="0"
                          alt="{gsa:i18n ('Details', 'Generic Resource')}"
                          style="margin-left:3px;"/>
                        </a>
                        </xsl:when>
                        <xsl:when test="@type='DFN-CERT'">
                        <a href="?cmd=get_info&amp;info_type=dfn_cert_adv&amp;info_name={name}&amp;details=1&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                          <img src="/img/details.png"
                          border="0"
                          alt="{gsa:i18n ('Details', 'Generic Resource')}"
                          style="margin-left:3px;"/>
                        </a>
                        </xsl:when>
                        <xsl:otherwise>
                          <div class="error"><xsl:value-of select="gsa:i18n ('Unknown CERT type!', 'CVE')"/></div>
                        </xsl:otherwise>
                      </xsl:choose>
                    </td>
                  </tr>
                </xsl:for-each>
              </table>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cve/raw_data/cve:entry/vuln:vulnerable-software-list/vuln:product) = 0">
              <h1><xsl:value-of select="gsa:i18n ('Vulnerable products', 'CVE')"/>: <xsl:value-of select="gsa:i18n ('None', 'CVE|Products')"/></h1>
            </xsl:when>
            <xsl:otherwise>
              <h1><xsl:value-of select="gsa:i18n ('Vulnerable products', 'CVE')"/></h1>
              <table class="gbntable" cellspacing="2" cellpadding="4">
                <tr class="gbntablehead2">
                  <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
                  <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
                </tr>
                <xsl:for-each select="info/cve/raw_data/cve:entry/vuln:vulnerable-software-list/vuln:product">
                  <xsl:sort select="text()"/>

                  <tr class="{gsa:table-row-class(position())}">
                    <td>
                      <xsl:call-template name="get_info_cpe_lnk">
                        <xsl:with-param name="cpe" select="str:decode-uri(text())"/>
                      </xsl:call-template>
                    </td>
                    <td width="100">
                      <a href="?cmd=get_info&amp;info_type=cpe&amp;info_name={str:decode-uri(text())}&amp;details=1&amp;token={/envelope/token}"
                        title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                          border="0"
                          alt="{gsa:i18n ('Details', 'Generic Resource')}"
                          style="margin-left:3px;"/>
                      </a>
                    </td>
                  </tr>
                </xsl:for-each>
              </table>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cve/nvts/nvt) = 0">
              <h1><xsl:value-of select="gsa:i18n ('NVTs addressing this CVE', 'CVE')"/>: <xsl:value-of select="gsa:i18n ('None', 'NVTs')"/></h1>
            </xsl:when>
            <xsl:otherwise>
              <h1><xsl:value-of select="gsa:i18n ('NVTs addressing this CVE', 'CVE')"/></h1>
              <table class="gbntable" cellspacing="2" cellpadding="4">
                <tr class="gbntablehead2">
                  <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
                  <td><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
                </tr>
                <xsl:for-each select="info/cve/nvts/nvt">

                  <tr class="{gsa:table-row-class(position())}">
                    <td><xsl:value-of select="name"/></td>
                    <td width="100">
                      <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={@oid}&amp;token={/envelope/token}" title="{gsa:i18n ('Details', 'Generic Resource')}">
                        <img src="/img/details.png"
                          border="0"
                          alt="{gsa:i18n ('Details', 'Generic Resource')}"
                          style="margin-left:3px;"/>
                      </a>
                    </td>
                  </tr>
                </xsl:for-each>
              </table>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Description', 'Property')"/></h1>
          <p>
            <xsl:value-of select="gsa:i18n ('This CVE was not found in the database.  This is not necessarily an error, because the CVE number might have been assigned for the issue, but the CVE not yet published.  Eventually the CVE content will appear in the database.', 'CVE')"/>
          </p>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), info/name)"/>
    <xsl:with-param name="user_tags" select="info/user_tags"/>
    <xsl:with-param name="tag_names" select="../get_tags_response"/>
    <xsl:with-param name="resource_type" select="'info'"/>
    <xsl:with-param name="resource_id"   select="info/@id"/>
    <xsl:with-param name="resource_subtype" select="'cve'"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="cpe-details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('CPE Details', 'CPE')"/>
      <a href="/help/cpe_details.html?token={/envelope/token}"
        title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('CPE', 'CPE'),' (',gsa:i18n('CPE Details', 'CPE'),')')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_info&amp;info_type=cpe&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
        title="{gsa:i18n ('CPEs', 'CPE')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('CPEs', 'CPE')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <div class="float_right" style="font-size: 10px;">
        <table style="font-size: 10px;">
          <xsl:if test="info/@id != ''">
            <tr>
              <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
              <td><xsl:value-of select="info/@id"/></td>
            </tr>
          </xsl:if>
          <xsl:if test="info/modification_time != ''">
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
              <td><xsl:value-of select="gsa:long-time (info/modification_time)"/></td>
            </tr>
          </xsl:if>
          <xsl:if test="info/creation_time != ''">
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
              <td><xsl:value-of select="gsa:long-time (info/creation_time)"/></td>
            </tr>
          </xsl:if>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last updated', 'Date')"/>:</td>
            <td><xsl:value-of select="info/update_time"/></td>
          </tr>
        </table>
      </div>
      <table>
        <tr>
          <xsl:if test="info/name">
            <td width="100"><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
            <td>
              <b>
                <xsl:call-template name="cpe-icon">
                  <xsl:with-param name="cpe" select="info/@id"/>
                  <xsl:with-param name="hide_other" select="1"/>
                </xsl:call-template>
                <xsl:value-of select="info/name"/>
              </b>
            </td>
          </xsl:if>
        </tr>
        <xsl:if test="info/cpe/title">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Title', 'Property')"/>:</td>
            <td><xsl:value-of select="info/cpe/title"/></td>
          </tr>
        </xsl:if>
        <xsl:if test="info/@id != ''">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('NVD ID', 'CPE')"/>:</td>
            <td><xsl:value-of select="info/cpe/nvd_id"/></td>
          </tr>
        </xsl:if>
        <xsl:if test="info/cpe/deprecated_by">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Deprecated by', 'CPE')"/>:</td>
            <td><xsl:value-of select="info/cpe/deprecated_by"/></td>
          </tr>
        </xsl:if>
        <xsl:if test="info/cpe/update_time">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last updated', 'Date')"/>:</td>
            <td><xsl:value-of select="info/cpe/update_time"/></td>
          </tr>
        </xsl:if>
        <xsl:if test="info/cpe/status != ''">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Status', 'CPE')"/>:</td>
            <td><xsl:value-of select="info/cpe/status"/></td>
          </tr>
        </xsl:if>
        <xsl:if test="info/cpe != ''">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:</td>
            <td>
              <xsl:choose>
                <xsl:when test="info/cpe/max_cvss &gt;= 0.0">
                  <xsl:call-template name="severity-bar">
                    <xsl:with-param name="cvss" select="info/cpe/max_cvss"/>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:call-template name="severity-bar">
                    <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
                  </xsl:call-template>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
        </xsl:if>
      </table>
      <xsl:if test="count(info/cpe/title) = 0">
        <p>
          <xsl:value-of select="gsa:i18n ('This CPE does not appear in the CPE dictionary but is referenced by one or more CVE.', 'CPE')"/>
        </p>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="count(details) = 0 or details = '0' or not(info/cpe)"/>
        <xsl:when test="count(info/cpe/cves/cve) = 0">
          <h1><xsl:value-of select="gsa:i18n ('Reported vulnerabilites', 'CPE')"/>: <xsl:value-of select="gsa:i18n ('None', 'CPE|Vulnerabilities')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Reported vulnerabilites', 'CPE')"/></h1>
          <table class="gbntable" cellspacing="2" cellpadding="4">
            <tr class="gbntablehead2">
              <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
              <td width="104"><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/></td>
            </tr>
            <xsl:for-each select="info/cpe/cves/cve">

              <tr class="{gsa:table-row-class(position())}">
                <td>
                  <xsl:call-template name="get_info_cve_lnk">
                    <xsl:with-param name="cve" select="cve:entry/@id"/>
                  </xsl:call-template>
                </td>
                <td>
                  <xsl:call-template name="severity-bar">
                    <xsl:with-param name="cvss" select="cve:entry/vuln:cvss/cvss:base_metrics/cvss:score"/>
                  </xsl:call-template>
                </td>
              </tr>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), info/name)"/>
    <xsl:with-param name="user_tags" select="info/user_tags"/>
    <xsl:with-param name="tag_names" select="../get_tags_response"/>
    <xsl:with-param name="resource_type" select="'info'"/>
    <xsl:with-param name="resource_id"   select="info/@id"/>
    <xsl:with-param name="resource_subtype" select="'cpe'"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="ovaldef-details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('OVAL Definition Details', 'OVAL Definition')"/>
      <a href="/help/ovaldef_details.html?token={/envelope/token}"
        title="{concat(gsa:i18n('Help', 'Help'),': OVALDEF (',gsa:i18n('OVAL Definition Details', 'OVAL Definition'),')')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_info&amp;info_type=ovaldef&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;token={/envelope/token}"
        title="{gsa:i18n ('OVAL Definitions', 'OVAL Definition')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('OVAL Definitions', 'OVAL Definition')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <div class="float_right" style="font-size: 10px;">
        <table style="font-size: 10px;">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
            <td>
              <xsl:value-of select="info/@id"/>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
            <td><xsl:value-of select="info/creation_time"/></td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
            <td><xsl:value-of select="info/modification_time"/></td>
          </tr>
        </table>
      </div>

      <xsl:choose>
        <xsl:when test="info/ovaldef">
          <table>
            <tr>
              <td width="130px"><b><xsl:value-of select="gsa:i18n ('Name (OVAL ID)', 'OVAL Definition')"/>:</b></td>
              <td><b><xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/@id"/></b></td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Title', 'Property')"/>:</td>
              <td><xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:title"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Version', 'Property')"/>:</td>
              <td><xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/@version"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Definition class', 'OVAL Definition')"/>:</td>
              <td><xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/@class"/></td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Referenced CVEs', 'SecInfo')"/>:</td>
              <td>
                <xsl:value-of name="cvss" select="info/ovaldef/cve_refs"/>
              </td>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:</td>
              <td>
                <xsl:choose>
                  <xsl:when test="info/ovaldef/max_cvss &gt;= 0.0">
                    <xsl:call-template name="severity-bar">
                      <xsl:with-param name="cvss" select="info/ovaldef/max_cvss"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="severity-bar">
                      <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
            <tr>
              <xsl:choose>
              <xsl:when test="info/ovaldef/raw_data/oval_definitions:definition/@deprecated != ''">
              <td><xsl:value-of select="gsa:i18n ('Deprecated', 'OVAL Definition')"/>:</td>
              <td><xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/@deprecated"/></td>
              </xsl:when>
              <xsl:otherwise />
              </xsl:choose>
            </tr>
            <tr>
              <td><xsl:value-of select="gsa:i18n ('File', 'OVAL Definition')"/>:</td>
              <td><xsl:value-of select="info/ovaldef/file"/></td>
            </tr>
          </table>

          <xsl:choose>
            <xsl:when test ="count(info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:description) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Description', 'Property')"/></h2>
              <xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:description"/>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('Description', 'Property')"/>: <xsl:value-of select="gsa:i18n ('None', 'Resource Property|Description')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:affected) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Affected', 'OVAL Definition')"/></h2>
              <xsl:for-each select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:affected">
                <h3>
                <xsl:if test="count(.)>1"><xsl:value-of select="position()"/>) </xsl:if><xsl:value-of select="gsa:i18n ('Family', 'OVAL Definition')"/>: <xsl:value-of select="./@family"/>
                </h3>
                <table class="gbntable" cellspacing="2" cellpadding="4">
                <tr class="gbntablehead2">
                  <td><xsl:value-of select="gsa:i18n ('Type', 'Property')"/></td>
                  <td><xsl:value-of select="gsa:i18n ('Name', 'Property')"/></td>
                </tr>
                <xsl:for-each select="./*">

                <tr class="{gsa:table-row-class(position())}">
                  <td><xsl:value-of select="name()"/></td>
                  <td><xsl:value-of select="text()"/></td>
                </tr>
                </xsl:for-each>
                </table>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('Affected', 'OVAL Definition')"/>: <xsl:value-of select="gsa:i18n ('None', 'OVAL Definition|Affected')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:criteria) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Criteria', 'OVAL Definition')"/></h2>
              <ul>
              <xsl:apply-templates select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:criteria"/>
              </ul>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('Criteria', 'OVAL Definition')"/>: <xsl:value-of select="gsa:i18n ('None', 'OVAL Definition|Criteria')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:reference) > 0">
              <h2><xsl:value-of select="gsa:i18n ('References', 'SecInfo')"/></h2>
              <table class="gbntable" cellspacing="2" cellpadding="4">
                <tr class="gbntablehead2">
                  <td><xsl:value-of select="gsa:i18n ('Source', 'OVAL Definition')"/></td>
                  <td><xsl:value-of select="gsa:i18n ('Ref.ID', 'OVAL Definition')"/></td>
                  <td>URL</td>
                </tr>
                <xsl:for-each select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:reference">

                  <tr class="{gsa:table-row-class(position())}">
                  <td><xsl:value-of select="./@source"/></td>
                  <td>
                  <xsl:choose>
                    <xsl:when test="translate(./@source,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'cve'">
                      <xsl:call-template name="get_info_cve_lnk">
                        <xsl:with-param name="cve" select="./@ref_id"/>
                        <xsl:with-param name="gsa_token" select="/envelope/token"/>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="translate(./@source,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'cpe'">
                      <xsl:call-template name="get_info_cpe_lnk">
                        <xsl:with-param name="cpe" select="str:decode-uri(./@ref_id)"/>
                        <xsl:with-param name="gsa_token" select="/envelope/token"/>
                      </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="./@ref_id"/>
                    </xsl:otherwise>
                  </xsl:choose></td>
                  <td><xsl:value-of select="./@ref_url"/></td>
                  </tr>
                </xsl:for-each>
              </table>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('References', 'SecInfo')"/>: <xsl:value-of select="gsa:i18n ('None', 'SecInfo|References')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:oval_repository) > 0">
            <h2><xsl:value-of select="gsa:i18n ('Repository history', 'OVAL Definition')"/></h2>
            <p><b><xsl:value-of select="gsa:i18n('Status', 'OVAL Definition')"/>: </b>
              <xsl:value-of select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:oval_repository/oval_definitions:status"/>
            </p>
            <table class="gbntable" cellspacing="2" cellpadding="4">
              <tr class="gbntablehead2">
                <td><xsl:value-of select="gsa:i18n ('Status', 'OVAL Definition')"/></td>
                <td><xsl:value-of select="gsa:i18n ('Date', 'Date')"/></td>
                <td><xsl:value-of select="gsa:i18n ('Contributors', 'OVAL Definition')"/></td>
              </tr>
              <xsl:for-each select="info/ovaldef/raw_data/oval_definitions:definition/oval_definitions:metadata/oval_definitions:oval_repository/oval_definitions:dates/*">

              <tr class="{gsa:table-row-class(position())}">
                <td><xsl:value-of select="name()"/>
                  <xsl:if test="name() = 'status_change'">
                    <i> (<xsl:value-of select="text()"/>)</i>
                  </xsl:if>
                </td>
                <td><xsl:value-of select="./@date"/></td>
                <td>
                  <xsl:for-each select="./oval_definitions:contributor">
                  <xsl:value-of select="./text()"/>
                  <i> (<xsl:value-of select="./@organization"/>)</i><br />
                  </xsl:for-each>
                </td>
              </tr>
              </xsl:for-each>
            </table>
            </xsl:when>
            <xsl:otherwise>
              <h1><xsl:value-of select="gsa:i18n ('Repository history', 'OVAL Definition')"/>: <xsl:value-of select="gsa:i18n ('None', 'OVAL Definition|History')"/></h1>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('OVAL definition not found', 'OVAL Definition')"/></h1>
          <xsl:value-of select="gsa:i18n ('No OVAL definition with the requested ID could be found in the SCAP database.', 'OVAL Definition')"/>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), info/name)"/>
    <xsl:with-param name="user_tags" select="info/user_tags"/>
    <xsl:with-param name="tag_names" select="../get_tags_response"/>
    <xsl:with-param name="resource_type" select="'info'"/>
    <xsl:with-param name="resource_id"   select="info/@id"/>
    <xsl:with-param name="resource_subtype" select="'ovaldef'"/>
  </xsl:call-template>
</xsl:template>

<xsl:template match="oval_definitions:criteria">
  <li>
    <b><xsl:if test="translate(./@negate,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'true'">NOT </xsl:if><xsl:value-of select="./@operator"/></b> <xsl:if test="./@comment != ''"><i> (<xsl:value-of select="./@comment"/>)</i></xsl:if><xsl:if test="translate(./@applicability_check,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'true'"><b> [Applicability check]</b></xsl:if>
    <ul>
      <xsl:apply-templates select="./oval_definitions:criteria | ./oval_definitions:criterion | ./oval_definitions:extend_definition"/>
    </ul>
  </li>
</xsl:template>

<xsl:template match="oval_definitions:criterion">
  <li>
    <xsl:if test="translate(./@negate,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'true'"><b>NOT </b></xsl:if><xsl:value-of select="./@comment"/> <i> (<xsl:value-of select="./@test_ref"/>)</i><xsl:if test="translate(./@applicability_check,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'true'"><b> [Applicability check]</b></xsl:if>
  </li>
</xsl:template>

<xsl:template match="oval_definitions:extend_definition">
  <li>
    <xsl:if test="translate(./@negate,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'true'"><b>NOT </b></xsl:if><xsl:value-of select="./@comment"/><i> (<a href="/omp?cmd=get_info&amp;info_type=ovaldef&amp;info_name={./@definition_ref}&amp;details=1&amp;token={/envelope/token}"><xsl:value-of select="./@definition_ref"/></a>)</i><xsl:if test="translate(./@applicability_check,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz') = 'true'"><b> [Applicability check]</b></xsl:if>
  </li>
</xsl:template>


<xsl:template name="cert_bund_adv-details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('CERT-Bund Advisory Details', 'CERT-Bund Advisory')"/>
      <a href="/help/cert_bund_adv_details.html?token={/envelope/token}"
        title="{concat(gsa:i18n('Help', 'Help'),': DFN_CERT_ADV (',gsa:i18n('CERT-Bund Details', 'CERT-Bund Advisory'),')')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_info&amp;info_type=cert_bund_adv&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;token={/envelope/token}"
        title="{gsa:i18n ('CERT-Bund Advisories', 'CERT-Bund Advisory')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('CERT-Bund Advisories', 'CERT-Bund Advisory')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <div class="float_right" style="font-size: 10px;">
        <table style="font-size: 10px;">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
            <td>
              <xsl:value-of select="info/name"/>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
            <td><xsl:value-of select="info/creation_time"/></td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
            <td><xsl:value-of select="info/modification_time"/></td>
          </tr>
        </table>
      </div>

      <xsl:choose>
        <xsl:when test="info/cert_bund_adv">
          <table>
            <tr>
              <td valign="top" width="130px"><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
              <td>
                <b><xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Ref_Num"/></b>
              </td>
            </tr>
            <xsl:if test="info/cert_bund_adv/raw_data/Advisory/Version != ''">
              <tr>
                <td valign="top"><xsl:value-of select="gsa:i18n ('Version', 'Property')"/>:</td>
                <td valign="top"><xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Version"/></td>
              </tr>
            </xsl:if>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Title', 'Property')"/>:</td>
              <td>
                <xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Title"/>
              </td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Software', 'CERT-Bund Advisory')"/>:</td>
              <td valign="top"><xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Software"/></td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Platform', 'CERT-Bund Advisory')"/>:</td>
              <td valign="top"><xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Platform"/></td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Effect', 'CERT-Bund Advisory')"/>:</td>
              <td valign="top"><xsl:value-of select="gsa:i18n (info/cert_bund_adv/raw_data/Advisory/Effect, 'CERT-Bund Advisory')"/></td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Remote Attack', 'CERT-Bund Advisory')"/>:</td>
              <td valign="top"><xsl:value-of select="gsa:i18n (info/cert_bund_adv/raw_data/Advisory/RemoteAttack, 'CERT-Bund Advisory')"/></td>
            </tr>

            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:</td>
              <td valign="top">
                <xsl:choose>
                  <xsl:when test="info/cert_bund_adv/max_cvss &gt;= 0.0">
                    <xsl:call-template name="severity-bar">
                      <xsl:with-param name="cvss" select="info/cert_bund_adv/max_cvss"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="severity-bar">
                      <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Value')"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('CERT-Bund risk rating', 'CERT-Bund Advisory')"/>:</td>
              <td valign=""><xsl:value-of select="gsa:i18n (info/cert_bund_adv/raw_data/Advisory/Risk, 'CERT-Bund Advisory')"/></td>
            </tr>

            <xsl:if test="info/cert_bund_adv/raw_data/Advisory/Reference_Source">
              <tr>
                <td valign="top"><xsl:value-of select="gsa:i18n ('Reference', 'CERT-Bund Advisory')"/>:</td>
                <td valign="top"><xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Reference_Source"/></td>
              </tr>
            </xsl:if>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Reference URL', 'CERT-Bund Advisory')"/>:</td>
              <td valign="top"><xsl:value-of select="info/cert_bund_adv/raw_data/Advisory/Reference_URL"/></td>
            </tr>
          </table>

          <xsl:choose>
            <xsl:when test="count(info/cert_bund_adv/raw_data/Advisory/CategoryTree) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Categories', 'CERT-Bund Advisory')"/></h2>
              <ul>
                <xsl:for-each select="info/cert_bund_adv/raw_data/Advisory/CategoryTree">
                  <li><xsl:value-of select="text()"/></li>
                </xsl:for-each>
              </ul>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('Categories', 'CERT-Bund Advisory')"/>: <xsl:value-of select="gsa:i18n ('None', 'CERT-Bund Advisory|Categories')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cert_bund_adv/raw_data/Advisory/Description/Element/TextBlock) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Description', 'Property')"/></h2>
              <xsl:for-each select="info/cert_bund_adv/raw_data/Advisory/Description/Element/TextBlock">
                <p><xsl:value-of select="text()"/></p>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('Description', 'Property')"/>: <xsl:value-of select="gsa:i18n ('None', 'Resource Property|Description')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cert_bund_adv/raw_data/Advisory/CVEList/CVE) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Referenced CVEs', 'SecInfo')"/></h2>
              <ul>
              <xsl:for-each select="info/cert_bund_adv/raw_data/Advisory/CVEList/CVE">
                <li>
                  <xsl:call-template name="get_info_cve_lnk">
                    <xsl:with-param name="cve" select="."/>
                    <xsl:with-param name="gsa_token" select="/envelope/token"/>
                  </xsl:call-template>
                </li>
              </xsl:for-each>
              </ul>
            </xsl:when>
            <xsl:otherwise>
            <h2><xsl:value-of select="gsa:i18n ('Referenced CVEs', 'SecInfo')"/>: <xsl:value-of select="gsa:i18n ('None', 'CVEs')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/cert_bund_adv/raw_data/Advisory/Description/Element/Infos/Info) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Other links', 'DFN-CERT Advisory')"/></h2>
              <ul>
              <xsl:for-each select="info/cert_bund_adv/raw_data/Advisory/Description/Element/Infos/Info">
                <li><p><b><xsl:value-of select="@Info_Issuer"/>:</b><br/> <xsl:value-of select="@Info_URL"/></p></li>
              </xsl:for-each>
              </ul>
            </xsl:when>
            <xsl:otherwise>
              <!-- hide because the feed is not expected to contain other links -->
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('CERT-Bund advisory not found', 'CERT-Bund Advisory')"/></h1>
          <xsl:value-of select="gsa:i18n ('No CERT-Bund advisory with the requested ID could be found in the SCAP database.', 'CERT-Bund Advisory')"/>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), info/name)"/>
    <xsl:with-param name="user_tags" select="info/user_tags"/>
    <xsl:with-param name="tag_names" select="../get_tags_response"/>
    <xsl:with-param name="resource_type" select="'info'"/>
    <xsl:with-param name="resource_id"   select="info/@id"/>
    <xsl:with-param name="resource_subtype" select="'cert_bund_adv'"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="dfn_cert_adv-details">
  <xsl:variable name="token" select="/envelope/token"/>
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('DFN-CERT Advisory Details', 'DFN-CERT Advisory')"/>
      <a href="/help/dfn_cert_adv_details.html?token={/envelope/token}"
        title="{concat(gsa:i18n('Help', 'Help'),': DFN_CERT_ADV (',gsa:i18n('DFN-CERT Advisory Details', 'DFN-CERT Advisory'),')')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_info&amp;info_type=dfn_cert_adv&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;token={/envelope/token}"
        title="{gsa:i18n ('DFN-CERT Advisories', 'DFN-CERT Advisory')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('DFN-CERT Advisories', 'DFN-CERT Advisory')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <div class="float_right" style="font-size: 10px;">
        <table style="font-size: 10px;">
          <tr>
            <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
            <td>
              <xsl:value-of select="info/name"/>
            </td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
            <td><xsl:value-of select="info/creation_time"/></td>
          </tr>
          <tr>
            <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
            <td><xsl:value-of select="info/modification_time"/></td>
          </tr>
        </table>
      </div>

      <xsl:choose>
        <xsl:when test="info/dfn_cert_adv">
          <table>
            <tr>
              <td valign="top" width="130px"><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td>
              <td>
                <b><xsl:value-of select="info/dfn_cert_adv/raw_data/atom:entry/dfncert:refnum"/></b>
              </td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Title', 'Property')"/>:</td>
              <td>
                <xsl:value-of select="info/dfn_cert_adv/raw_data/atom:entry/atom:title"/>
              </td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Advisory link', 'DFN-CERT Advisory')"/>:</td>
              <td valign="top"><xsl:value-of select="info/dfn_cert_adv/raw_data/atom:entry/atom:link[@rel='alternate']/@href"/></td>
            </tr>
            <tr>
              <td valign="top"><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:</td>
              <td valign="top">
                <xsl:choose>
                  <xsl:when test="info/dfn_cert_adv/max_cvss &gt;= 0.0">
                    <xsl:call-template name="severity-bar">
                      <xsl:with-param name="cvss" select="info/dfn_cert_adv/max_cvss"/>
                    </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:call-template name="severity-bar">
                      <xsl:with-param name="extra_text" select="gsa:i18n ('N/A', 'Severity')"/>
                    </xsl:call-template>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </table>

          <xsl:choose>
            <xsl:when test="count(info/dfn_cert_adv/raw_data/atom:entry/atom:summary) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Summary', 'Property')"/></h2>
              <p><xsl:value-of select="info/dfn_cert_adv/raw_data/atom:entry/atom:summary"/></p>
            </xsl:when>
            <xsl:otherwise>
              <h2><xsl:value-of select="gsa:i18n ('Summary', 'Property')"/>: <xsl:value-of select="gsa:i18n ('None', 'Resource Property|Summary')"/></h2>
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/dfn_cert_adv/raw_data/atom:entry/atom:link[@rel!='alternate']) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Other links', 'DFN-CERT Advisory')"/>:</h2>
              <ul>
              <xsl:for-each select="info/dfn_cert_adv/raw_data/atom:entry/atom:link[@rel!='alternate']">
                <li><b><xsl:value-of select="@rel"/>: </b> <xsl:value-of select="@href"/></li>
              </xsl:for-each>
              </ul>
            </xsl:when>
            <xsl:otherwise>
              <!-- hide because the feed is not expected to contain other links -->
            </xsl:otherwise>
          </xsl:choose>

          <xsl:choose>
            <xsl:when test="count(info/dfn_cert_adv/raw_data/atom:entry/dfncert:cve) > 0">
              <h2><xsl:value-of select="gsa:i18n ('Referenced CVEs', 'SecInfo')"/></h2>
              <ul>
              <xsl:for-each select="info/dfn_cert_adv/raw_data/atom:entry/dfncert:cve">
                <xsl:for-each select="str:tokenize (str:replace (text (), 'CVE ', 'CVE-'), ' ')">
                  <xsl:if test="starts-with (text (), 'CVE-') and (string-length (text ()) &gt;= 13) and string (number(substring (text (), 4, 4))) != 'NaN'">
                    <li>
                      <xsl:call-template name="get_info_cve_lnk">
                        <xsl:with-param name="cve" select="."/>
                        <xsl:with-param name="gsa_token" select="$token"/>
                      </xsl:call-template>
                    </li>
                  </xsl:if>
                </xsl:for-each>
              </xsl:for-each>
              </ul>
            </xsl:when>
            <xsl:otherwise>
            <h2><xsl:value-of select="gsa:i18n ('Referenced CVEs', 'SecInfo')"/>: None</h2>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('DFN-CERT advisory not found', 'DFN-CERT Advisory')"/></h1>
          <xsl:value-of select="gsa:i18n ('No DFN-CERT advisory with the requested ID could be found in the SCAP database.', 'DFN-CERT Advisory')"/>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), info/name)"/>
    <xsl:with-param name="user_tags" select="info/user_tags"/>
    <xsl:with-param name="tag_names" select="../get_tags_response"/>
    <xsl:with-param name="resource_type" select="'info'"/>
    <xsl:with-param name="resource_id"   select="info/@id"/>
    <xsl:with-param name="resource_subtype" select="'dfn_cert_adv'"/>
  </xsl:call-template>
</xsl:template>


<!-- BEGIN NVT DETAILS -->

<xsl:template match="nvt" mode="details">
  <xsl:param name="config"/>
  <div class="float_right" style="font-size: 10px;">
    <table style="font-size: 10px;">
      <xsl:if test="@oid != ''">
        <tr>
          <td><xsl:value-of select="gsa:i18n ('ID', 'Property')"/>:</td>
          <td><xsl:value-of select="@oid"/></td>
        </tr>
      </xsl:if>
      <xsl:if test="modification_time != ''">
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Last modified', 'Date')"/>:</td>
          <td><xsl:value-of select="gsa:long-time (modification_time)"/></td>
        </tr>
      </xsl:if>
      <xsl:if test="creation_time != ''">
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Created', 'Date')"/>:</td>
          <td><xsl:value-of select="gsa:long-time (creation_time)"/></td>
        </tr>
      </xsl:if>
    </table>
  </div>
  <table>
    <tr><td><b><xsl:value-of select="gsa:i18n ('Name', 'Property')"/>:</b></td><td><b><xsl:value-of select="name"/></b></td></tr>
    <xsl:if test="summary != 'NOSUMMARY'">
      <tr><td><xsl:value-of select="gsa:i18n ('Summary', 'Property')"/>:</td><td><xsl:value-of select="summary"/></td></tr>
    </xsl:if>
    <tr><td><xsl:value-of select="gsa:i18n ('Config', 'Scan Config')"/>:</td><td><xsl:value-of select="$config"/></td></tr>
    <tr><td><xsl:value-of select="gsa:i18n ('Family', 'NVT')"/>:</td><td><xsl:value-of select="family"/></td></tr>
    <tr><td><xsl:value-of select="gsa:i18n ('OID', 'NVT')"/>:</td><td><xsl:value-of select="@oid"/></td></tr>
    <tr><td><xsl:value-of select="gsa:i18n ('Version', 'NVT')"/>:</td><td><xsl:value-of select="version"/></td></tr>
    <tr>
      <td><xsl:value-of select="gsa:i18n ('Notes', 'Note')"/>:</td>
      <td>
        <a href="/omp?cmd=get_notes&amp;filter=nvt_id={@oid} sort=nvt&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
           title="{gsa-i18n:strformat (gsa:i18n ('Notes on NVT %1', 'NVT'), name)}">
          <xsl:value-of select="count (../../../get_notes_response/note)"/>
        </a>
      </td>
    </tr>
    <tr>
      <td><xsl:value-of select="gsa:i18n ('Overrides', 'Override')"/>:</td>
      <td>
        <a href="/omp?cmd=get_overrides&amp;filter=nvt_id={@oid} sort=nvt&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
           title="{gsa-i18n:strformat (gsa:i18n ('Overrides on NVT %1', 'NVT'), name)}">
          <xsl:value-of select="count (../../../get_overrides_response/override)"/>
        </a>
      </td>
    </tr>
  </table>

  <p>
    <a href="/omp?cmd=get_results&amp;filter={@oid}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}">
      <xsl:value-of select="gsa:i18n ('Show scan results for this NVT', 'NVT')"/>
    </a>
  </p>

  <xsl:choose>
    <xsl:when test="contains(tags, 'summary=')">
      <h2><xsl:value-of select="gsa:i18n ('Summary', 'Property')"/></h2>
      <xsl:for-each select="str:split (tags, '|')">
        <xsl:if test="'summary' = substring-before (., '=')">
          <xsl:call-template name="structured-text">
            <xsl:with-param name="string" select="substring-after (., '=')"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="contains(tags, 'affected=')">
      <h2><xsl:value-of select="gsa:i18n ('Affected Software/OS', 'NVT or Result')"/></h2>
      <xsl:for-each select="str:split (tags, '|')">
        <xsl:if test="'affected' = substring-before (., '=')">
          <xsl:call-template name="structured-text">
            <xsl:with-param name="string" select="substring-after (., '=')"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <h2><xsl:value-of select="gsa:i18n ('Vulnerability Scoring', 'NVT or Result')"/></h2>
  <table>
    <tr>
      <td><xsl:value-of select="gsa:i18n ('CVSS base', 'NVT or Result')"/>:</td>
      <td>
        <xsl:choose>
          <xsl:when test="cvss_base &gt;= 0.0">
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="cvss" select="cvss_base"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="severity-bar">
              <xsl:with-param name="extra_text" select="'N/A'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
    <xsl:variable name="token" select="/envelope/token"/>
    <xsl:for-each select="str:split (tags, '|')">
      <xsl:if test="'cvss_base_vector' = substring-before (., '=')">
        <xsl:variable name="cvss_vector" select="substring-after (., '=')"/>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('CVSS base vector', 'NVT or Result')"/>:</td>
          <td>
            <a href="/omp?cmd=cvss_calculator&amp;cvss_vector={$cvss_vector}&amp;token={$token}">
              <xsl:value-of select="$cvss_vector"/>
            </a>
          </td>
        </tr>
      </xsl:if>
    </xsl:for-each>
  </table>

  <xsl:choose>
    <xsl:when test="contains(tags, 'insight=')">
      <xsl:if test="not (contains(tags, 'insight=N/A'))">
        <h2><xsl:value-of select="gsa:i18n ('Vulnerability Insight', 'NVT or Result')"/></h2>
        <xsl:for-each select="str:split (tags, '|')">
          <xsl:if test="'insight' = substring-before (., '=')">
            <xsl:call-template name="structured-text">
              <xsl:with-param name="string" select="substring-after (., '=')"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="contains(tags, 'vuldetect=') or (qod != '')">
      <h2><xsl:value-of select="gsa:i18n ('Vulnerability Detection Method', 'NVT or Result')"/></h2>
      <xsl:for-each select="str:split (tags, '|')">
        <xsl:if test="'vuldetect' = substring-before (., '=')">
          <xsl:call-template name="structured-text">
            <xsl:with-param name="string" select="substring-after (., '=')"/>
          </xsl:call-template>
        </xsl:if>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="qod != ''">
      <p>
      <b><xsl:value-of select="gsa:i18n ('Quality of Detection', 'NVT')"/>: </b>
        <xsl:choose>
          <xsl:when test="qod/type != ''">
            <xsl:value-of select="qod/type"/>
          </xsl:when>
          <xsl:otherwise>
            <i>N/A</i>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:if test="qod/value != ''">
          (<xsl:value-of select="qod/value"/>%)
        </xsl:if>
      </p>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <xsl:when  test="contains(tags, 'impact=')">
      <xsl:if test="not (contains(tags, 'impact=N/A'))">
        <h2><xsl:value-of select="gsa:i18n ('Impact', 'NVT or Result')"/></h2>
        <xsl:for-each select="str:split (tags, '|')">
          <xsl:if test="'impact' = substring-before (., '=')">
            <xsl:call-template name="structured-text">
              <xsl:with-param name="string" select="substring-after (., '=')"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="contains(tags, 'solution=') or contains(tags, 'solution_type=')">
      <xsl:if test="not (contains(tags, 'solution=N/A')) or contains(tags, 'solution_type=')">
        <h2><xsl:value-of select="gsa:i18n ('Solution', 'NVT or Result')"/></h2>
        <xsl:for-each select="str:split (tags, '|')">
          <xsl:if test="'solution_type' = substring-before (., '=')">
            <p>
              <b><xsl:value-of select="gsa:i18n ('Solution type', 'NVT or Result')"/>: </b>
              <xsl:call-template name="solution-icon">
                <xsl:with-param name="solution_type" select="substring-after (., '=')"/>
              </xsl:call-template>
              <xsl:text> </xsl:text>
              <xsl:value-of select="substring-after (., '=')"/>
            </p>
          </xsl:if>
        </xsl:for-each>
        <xsl:for-each select="str:split (tags, '|')">
          <xsl:if test="'solution' = substring-before (., '=')">
            <xsl:call-template name="structured-text">
              <xsl:with-param name="string" select="substring-after (., '=')"/>
            </xsl:call-template>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>

  <!-- "NOTAG" means no tags, skip. -->
  <xsl:choose>
    <xsl:when test="tags = 'NOTAG' or (contains(tags,'summary=') + contains(tags,'affected=') + contains(tags,'cvss_base_vector=') + contains(tags,'insight=') + contains(tags,'vuldetect=') + contains(tags,'impact=') + contains(tags,'solution=') + contains(tags,'solution_type=') + contains(tags,'qod_type=')= count(str:split (tags, '|')))">
    </xsl:when>
    <xsl:otherwise>
      <h2><xsl:value-of select="gsa:i18n ('Other tags', 'NVT')"/></h2>
      <table>
      <xsl:for-each select="str:split (tags, '|')">
        <xsl:if test="not(contains('summary|cvss_base_vector|affected|insight|vuldetect|impact|solution|solution_type|qod_type',substring-before (., '=')))">
          <tr>
            <td valign="top"><xsl:value-of select="substring-before (., '=')"/>:</td>
            <td>
              <xsl:call-template name="structured-text">
                <xsl:with-param name="string" select="substring-after (., '=')"/>
              </xsl:call-template>
            </td>
          </tr>
        </xsl:if>
      </xsl:for-each>
      </table>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:variable name="cve_ref">
    <xsl:if test="cve_id != '' and cve_id != 'NOCVE'">
      <xsl:value-of select="cve_id/text()"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="bid_ref">
    <xsl:if test="bugtraq_id != '' and bugtraq_id != 'NOBID'">
      <xsl:value-of select="bugtraq_id/text()"/>
    </xsl:if>
  </xsl:variable>
  <xsl:variable name="cert_ref" select="cert_refs"/>
  <xsl:variable name="xref">
    <xsl:if test="xrefs != '' and xrefs != 'NOXREF'">
      <xsl:value-of select="xrefs/text()"/>
    </xsl:if>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="$cve_ref != '' or $bid_ref != '' or $xref != '' or count($cert_ref/cert_ref) > 0">
      <h2><xsl:value-of select="gsa:i18n ('References', 'SecInfo')"/></h2>
      <table>
        <xsl:call-template name="ref_cve_list">
          <xsl:with-param name="cvelist" select="$cve_ref"/>
        </xsl:call-template>
        <xsl:call-template name="ref_bid_list">
          <xsl:with-param name="bidlist" select="$bid_ref"/>
        </xsl:call-template>
        <xsl:call-template name="ref_cert_list">
          <xsl:with-param name="certlist" select="$cert_ref"/>
        </xsl:call-template>
        <xsl:call-template name="ref_xref_list">
          <xsl:with-param name="xreflist" select="$xref"/>
        </xsl:call-template>
      </table>
    </xsl:when>
    <xsl:otherwise>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="get_notes_response">
</xsl:template>

<xsl:template match="get_overrides_response">
</xsl:template>

<xsl:template name="nvt-details">
  <xsl:param name="nvts_response" select="commands_response/get_nvts_response"/>

  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="commands_response/delete_note_response"/>
  <xsl:apply-templates select="commands_response/delete_override_response"/>
  <xsl:apply-templates select="commands_response/modify_note_response"/>
  <xsl:apply-templates select="commands_response/modify_override_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>

  <xsl:choose>
      <xsl:when test="substring($nvts_response/@status, 1, 1) = '4' or substring($nvts_response/@status, 1, 1) = '5'">
      <xsl:call-template name="command_result_dialog">
        <xsl:with-param name="operation">
          Get NVTs
        </xsl:with-param>
        <xsl:with-param name="status">
          <xsl:value-of select="$nvts_response/@status"/>
        </xsl:with-param>
        <xsl:with-param name="msg">
          <xsl:value-of select="$nvts_response/@status_text"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <div class="gb_window">
        <div class="gb_window_part_left"></div>
        <div class="gb_window_part_right"></div>
        <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('NVT Details', 'NVT')"/>
          <a href="/help/nvt_details.html?token={/envelope/token}"
             title="{concat(gsa:i18n('Help', 'Help'),': ',gsa:i18n('NVT Details', 'NVT'))}">
            <img src="/img/help.png"/>
          </a>
          <a href="/omp?cmd=get_info&amp;info_type=nvt&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
            title="{gsa:i18n ('NVTs', 'NVT')}" style="margin-left:3px;">
            <img src="/img/list.png" border="0" alt="{gsa:i18n ('NVTs', 'NVT')}"/>
          </a>
          <div id="small_inline_form" style="display: inline; margin-left: 15px; font-weight: normal;">
            <a href="/omp?cmd=new_note&amp;next=get_info&amp;info_type=nvt&amp;info_id={$nvts_response/nvt/@oid}&amp;oid={$nvts_response/nvt/@oid}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa:i18n ('Add Note', 'Note')}" style="margin-left:3px;">
              <img src="/img/new_note.png" border="0" alt="{gsa:i18n ('Add Note', 'Note')}"/>
            </a>
            <a href="/omp?cmd=new_override&amp;next=get_info&amp;info_type=nvt&amp;info_id={$nvts_response/nvt/@oid}&amp;oid={$nvts_response/nvt/@oid}&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
               title="{gsa:i18n ('Add Override', 'Override')}" style="margin-left:3px;">
              <img src="/img/new_override.png" border="0" alt="{gsa:i18n ('Add Override', 'Override')}"/>
            </a>
          </div>
        </div>
        <div class="gb_window_part_content">
          <xsl:apply-templates
            select="$nvts_response/nvt" mode="details"/>

          <h2><xsl:value-of select="gsa:i18n ('Preferences', 'NVT')"/></h2>
          <xsl:for-each select="$nvts_response/nvt/preferences">
            <xsl:call-template name="preferences-details">
            </xsl:call-template>
          </xsl:for-each>
        </div>
      </div>

      <xsl:call-template name="user-tags-window">
        <xsl:with-param name="title" select="gsa-i18n:strformat (gsa:i18n ('User Tags for &quot;%1&quot;', 'Tag'), $nvts_response/nvt/name)"/>
        <xsl:with-param name="user_tags" select="$nvts_response/nvt/user_tags"/>
        <xsl:with-param name="tag_names" select="get_tags_response"/>
        <xsl:with-param name="resource_type" select="'info'"/>
        <xsl:with-param name="resource_id"   select="$nvts_response/nvt/@oid"/>
        <xsl:with-param name="resource_subtype" select="'nvt'"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- BEGIN NOTES MANAGEMENT -->

<xsl:template name="html-create-note-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Note', 'Note')"/>
      <a href="/help/new_note.html?token={/envelope/token}"
         title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('New Note', 'Note')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_notes&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Notes', 'Note')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Notes', 'Note')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp#notes-{result/@id}"
            method="post"
            enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_note"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>

        <xsl:choose>
          <xsl:when test="/envelope/params/next='get_result'">
            <!-- get_result params. -->
            <input type="hidden" name="result_id" value="{result/@id}"/>
            <input type="hidden" name="name" value="{task/name}"/>
            <input type="hidden" name="task_id" value="{task/@id}"/>
            <input type="hidden" name="overrides" value="{overrides}"/>
            <input type="hidden" name="apply_overrides" value="{/envelope/params/apply_overrides}"/>
            <input type="hidden" name="autofp" value="{/envelope/params/autofp}"/>
            <input type="hidden" name="report_result_id" value="{/envelope/params/report_result_id}"/>

            <!-- get_report passthrough params. -->
            <input type="hidden" name="report_id" value="{report/@id}"/>
            <input type="hidden" name="overrides" value="{overrides}"/>
          </xsl:when>
          <xsl:when test="/envelope/params/next='get_info'">
            <!-- get_info (nvt) params. -->
            <input type="hidden" name="info_id" value="{/envelope/params/oid}"/>
            <input type="hidden" name="info_type" value="nvt"/>
          </xsl:when>
          <xsl:otherwise>
            <!-- get_report params. -->
            <input type="hidden" name="report_id" value="{/envelope/params/report_id}"/>
            <input type="hidden" name="overrides" value="{/envelope/params/overrides}"/>
            <input type="hidden" name="details" value="{/envelope/params/details}"/>
          </xsl:otherwise>
        </xsl:choose>

        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <xsl:choose>
            <xsl:when test="result/@id">
              <input type="hidden" name="oid" value="{nvt/@id}"/>
              <tr>
                <td valign="center" width="125"><b><xsl:value-of select="gsa:i18n ('NVT Name', 'Note or Override')"/></b></td>
                <td>
                  <xsl:variable name="nvt" select="get_results_response/result/nvt"/>
                  <xsl:variable name="max" select="70"/>
                  <xsl:choose>
                    <xsl:when test="$nvt/@oid = 0">
                      <xsl:value-of select="gsa:i18n ('None.  Result was an open port.', 'Note or Override')"/>
                    </xsl:when>
                    <xsl:when test="string-length($nvt/name) &gt; $max">
                      <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={$nvt/@oid}&amp;token={/envelope/token}">
                        <abbr title="{$nvt/name} ({$nvt/@oid})"><xsl:value-of select="substring($nvt/name, 0, $max)"/>...</abbr>
                      </a>
                    </xsl:when>
                    <xsl:otherwise>
                      <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={$nvt/@oid}&amp;token={/envelope/token}">
                        <xsl:value-of select="$nvt/name"/>
                      </a>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td valign="center" width="125"><b><xsl:value-of select="gsa:i18n ('NVT OID', 'Note or Override')"/></b></td>
                <td>
                  <xsl:choose>
                    <xsl:when test="nvt/@id = '0'">
                      <input type="text" name="oid" size="30" maxlength="80" value="1.3.6.1.4.1.25623.1.0."/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="text" name="oid" size="30" maxlength="80" value="{nvt/@id}"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
          <tr>
            <td valign="center" width="125">
              <xsl:value-of select="gsa:i18n ('Active', 'Note')"/>
            </td>
            <td>
              <div>
                <label>
                  <input type="radio" name="active" value="-1" checked="1"/>
                  <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('always', 'Time'))"/>
                </label>
              </div>
              <div>
                <label>
                  <input type="radio" name="active" value="1"/>
                  <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('for the next', 'Time'), ' ')"/>
                </label>
                <label>
                  <input type="text" name="days" size="3" maxlength="7" value="30"/>
                  <xsl:value-of select="gsa:i18n ('days', 'Time')"/>
                </label>
              </div>
              <div>
                <label>
                  <input type="radio" name="active" value="0"/>
                  <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
                </label>
              </div>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="result/@id">
                  <label>
                    <input type="radio" name="hosts" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Hosts')"/>
                  </label>
                  <label>
                    <input type="radio" name="hosts" value="{hosts}" checked="1"/>
                    <xsl:value-of select="hosts"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="hosts" value="" checked="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Hosts')"/>
                  </label>
                  <label>
                    <input type="radio" name="hosts" value="--"/>
                  </label>
                  <input type="text" name="hosts_manual" size="30" maxlength="80" value=""/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Port', 'Port')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="result/@id">
                  <label>
                    <input type="radio" name="port" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Note or Override|Location')"/>
                  </label>
                  <label>
                    <input type="radio" name="port" value="{port}" checked="1"/>
                    <xsl:value-of select="port"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="port" value="" checked="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Note or Override|Location')"/>
                  </label>
                  <label>
                    <input type="radio" name="port" value="--"/>
                  </label>
                  <input type="text" name="port_manual" size="30" maxlength="80" value=""/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="result/@id">
                  <label>
                    <input type="radio" name="severity" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Severity')"/>
                  </label>
                  <label>
                    <xsl:choose>
                      <xsl:when test="severity &gt; 0.0">
                        <input type="radio" name="severity" value="0.1" checked="1"/>
                        &gt; 0.0
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="severity" value="{severity}" checked="1"/>
                        <xsl:value-of select="gsa:i18n (gsa:result-cvss-risk-factor (severity), 'Severity')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="severity" value="" checked="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Severity')"/>
                  </label>
                  <label>
                    <input type="radio" name="severity" value="0.1"/>
                    &gt; 0.0
                  </label>
                  <label>
                    <input type="radio" name="severity" value="0.0"/>
                    <xsl:value-of select="gsa:i18n ('Log', 'Severity')"/>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Task', 'Task')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="task/@id">
                  <label>
                    <input type="radio" name="note_task_id" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Task')"/>
                  </label>
                  <label>
                    <input type="radio" name="note_task_id" value="{task/@id}"
                           checked="1"/>
                    <xsl:value-of select="task/name"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="note_task_id" value="" checked="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Task')"/>
                  </label>
                  <label>
                    <input type="radio" name="note_task_id" value="0"/>
                  </label>
                  <select style="margin-bottom: 0px;" name="note_task_uuid">
                    <xsl:for-each select="get_tasks_response/task">
                      <option value="{@id}"><xsl:value-of select="name"/></option>
                    </xsl:for-each>
                  </select>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Result', 'Result')"/>
            </td>
            <td>
              <label>
                <input type="radio" name="note_result_id" value="" checked="1"/>
                <xsl:value-of select="gsa:i18n ('Any', 'Result')"/>
              </label>
              <xsl:choose>
                <xsl:when test="result/@id">
                  <label>
                    <input type="radio" name="note_result_id" value="{result/@id}"/>
                    <xsl:value-of select="gsa:i18n ('Only the selected one', 'Note or Override|Result')"/> (<xsl:value-of select="result/@id"/>)
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="note_result_id" value="0"/>
                    UUID
                  </label>
                  <input type="text" name="note_result_uuid" size="30" maxlength="80" value=""/>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Text', 'Note or Override')"/></td>
            <td>
              <textarea name="text" rows="10" cols="60"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Create Note', 'Note')}"/>
            </td>
          </tr>
        </table>
      </form>
      <xsl:choose>
        <xsl:when test="result/@id">
          <h3>
            <xsl:value-of select="gsa:i18n ('Associated Result', 'Note or Override')"/>
          </h3>
          <table class="gbntable" cellspacing="2" cellpadding="4" border="0">
            <xsl:for-each select="get_results_response/result">
              <xsl:call-template name="result-detailed">
                <xsl:with-param name="override-buttons">0</xsl:with-param>
                <xsl:with-param name="note-buttons">0</xsl:with-param>
              </xsl:call-template>
            </xsl:for-each>
          </table>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
</xsl:template>

<xsl:template match="new_note">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="create_note_response"/>
  <xsl:call-template name="html-create-note-form"/>
</xsl:template>

<xsl:template name="html-edit-note-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('Edit Note', 'Note')"/>
      <xsl:call-template name="edit-header-icons">
        <xsl:with-param name="cap-type" select="'Note'"/>
        <xsl:with-param name="type" select="'note'"/>
        <xsl:with-param name="id"
                        select="get_notes_response/note/@id"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:variable name="fragment">
        <xsl:choose>
          <xsl:when test="/envelope/params/next = 'get_report'">
            <xsl:value-of select="concat ('#notes-', /envelope/params/report_result_id)"/>
          </xsl:when>
        </xsl:choose>
      </xsl:variable>
      <form action="{$fragment}" method="post" enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="save_note"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="note_id"
               value="{get_notes_response/note/@id}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>

        <input type="hidden" name="next" value="{/envelope/params/next}"/>

        <!-- get_report params. -->
        <input type="hidden" name="report_id" value="{/envelope/params/report_id}"/>
        <input type="hidden" name="report_result_id" value="{/envelope/params/report_result_id}"/>
        <input type="hidden" name="delta_report_id" value="{/envelope/params/delta_report_id}"/>
        <input type="hidden" name="overrides" value="{/envelope/params/overrides}"/>
        <input type="hidden" name="details" value="{/envelope/params/details}"/>

        <!-- get_tasks param. -->
        <input type="hidden" name="task_id" value="{/envelope/params/task_id}"/>

        <!-- get_result params. -->
        <input type="hidden" name="name" value="{/envelope/params/name}"/>
        <input type="hidden" name="result_id" value="{/envelope/params/result_id}"/>
        <input type="hidden" name="apply_overrides" value="{/envelope/params/apply_overrides}"/>
        <input type="hidden" name="autofp" value="{/envelope/params/autofp}"/>

        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <tr>
            <td><b><xsl:value-of select="gsa:i18n ('NVT Name', 'Note or Override')"/></b></td>
            <td>
              <xsl:variable name="nvt" select="get_notes_response/note/nvt"/>
              <xsl:variable name="max" select="70"/>
              <xsl:choose>
                <xsl:when test="$nvt/@oid = 0">
                  <xsl:value-of select="gsa:i18n ('None.  Result was an open port.', 'Note or Override')"/>
                </xsl:when>
                <xsl:when test="string-length($nvt/name) &gt; $max">
                  <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={$nvt/@oid}&amp;token={/envelope/token}">
                    <abbr title="{$nvt/name} ({$nvt/@oid})"><xsl:value-of select="substring($nvt/name, 0, $max)"/>...</abbr>
                  </a>
                </xsl:when>
                <xsl:otherwise>
                  <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={$nvt/@oid}&amp;token={/envelope/token}">
                    <xsl:value-of select="$nvt/name"/>
                  </a>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="center"><xsl:value-of select="gsa:i18n ('Active', 'Note')"/></td>
            <td>
              <xsl:choose>
                <xsl:when test="get_notes_response/note/active='1' and string-length(get_notes_response/note/end_time) &gt; 0">
                  <div>
                    <label>
                      <input type="radio" name="active" value="-1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('always', 'Time'))"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="-2" checked="1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('until', 'Time'), ' ')"/>
                      <xsl:value-of select="get_notes_response/note/end_time"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('for the next', 'Time'), ' ')"/>
                    </label>
                    <label>
                      <input type="text" name="days" size="3" maxlength="7" value="30"/>
                      <xsl:value-of select="gsa:i18n ('days', 'Time')"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="0"/>
                      <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
                    </label>
                  </div>
                </xsl:when>
                <xsl:when test="get_notes_response/note/active='1'">
                  <div>
                    <label>
                      <input type="radio" name="active" value="-1" checked="1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('always', 'Time'))"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('for the next', 'Time'), ' ')"/>
                    </label>
                    <label>
                      <input type="text" name="days" size="3" maxlength="7" value="30"/>
                      <xsl:value-of select="gsa:i18n ('days', 'Time')"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="0"/>
                      <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
                    </label>
                  </div>
                </xsl:when>
                <xsl:otherwise>
                  <div>
                    <label>
                      <input type="radio" name="active" value="-1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('always', 'Time'))"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="1"/>
                      <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('for the next', 'Time'), ' ')"/>
                    </label>
                    <label>
                      <input type="text" name="days" size="3" maxlength="7" value="30"/>
                      <xsl:value-of select="gsa:i18n ('days', 'Time')"/>
                    </label>
                  </div>
                  <div>
                    <label>
                      <input type="radio" name="active" value="0" checked="1"/>
                      <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
                    </label>
                  </div>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length (get_notes_response/note/hosts) = 0">
                  <label>
                    <input type="radio" name="hosts" value="" checked="1"
                           readonly="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Hosts')"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="hosts" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Hosts')"/>
                  </label>
                  <label>
                    <input type="radio" name="hosts" value="{get_notes_response/note/hosts}"
                           checked="1"/>
                    <xsl:value-of select="get_notes_response/note/hosts"/>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Port', 'Port')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length (get_notes_response/note/port) = 0">
                  <label>
                    <input type="radio" name="port" value="" checked="1"
                           readonly="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Port')"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="port" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Port')"/>
                  </label>
                  <label>
                    <input type="radio" name="port" value="{get_notes_response/note/port}" checked="1"/>
                    <xsl:value-of select="get_notes_response/note/port"/>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length (get_notes_response/note/severity) = 0">
                  <label>
                    <input type="radio" name="severity" value="" checked="1"
                           readonly="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Severity')"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="severity" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Severity')"/>
                  </label>
                  <label>
                    <xsl:choose>
                      <xsl:when test="get_notes_response/note/severity &gt; 0.0">
                        <input type="radio" name="severity" value="0.1" checked="1"/>
                        &gt; 0.0
                      </xsl:when>
                      <xsl:otherwise>
                        <input type="radio" name="severity" value="{get_notes_response/note/severity}" checked="1"/>
                        <xsl:value-of select="gsa:i18n (gsa:result-cvss-risk-factor (get_notes_response/note/severity), 'Severity')"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Task', 'Task')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length (get_notes_response/note/task/@id) = 0">
                  <label>
                    <input type="radio" name="note_task_id" value="" checked="1"
                           readonly="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Task')"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="note_task_id" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Task')"/>
                  </label>
                  <label>
                    <input type="radio" name="note_task_id" value="{get_notes_response/note/task/@id}"
                           checked="1"/>
                    <xsl:value-of select="get_notes_response/note/task/name"/>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Result', 'Result')"/>
            </td>
            <td>
              <xsl:choose>
                <xsl:when test="string-length (get_notes_response/note/result/@id) = 0">
                  <label>
                    <input type="radio" name="note_result_id" value="" checked="1"
                           readonly="1"/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Result')"/>
                  </label>
                </xsl:when>
                <xsl:otherwise>
                  <label>
                    <input type="radio" name="note_result_id" value=""/>
                    <xsl:value-of select="gsa:i18n ('Any', 'Result')"/>
                  </label>
                  <label>
                    <input type="radio" name="note_result_id"
                           value="{get_notes_response/note/result/@id}" checked="1"/>
                    <xsl:value-of select="get_notes_response/note/result/@id"/>
                  </label>
                </xsl:otherwise>
              </xsl:choose>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125"><xsl:value-of select="gsa:i18n ('Text', 'Note or Override')"/></td>
            <td>
              <textarea name="text" rows="10" cols="60"><xsl:value-of select="get_notes_response/note/text"/></textarea>
            </td>
          </tr>
          <tr>
            <td colspan="2" style="text-align:right;">
              <input type="submit" name="submit" value="{gsa:i18n ('Save Note', 'Note')}"/>
            </td>
          </tr>
        </table>
      </form>
      <xsl:choose>
        <xsl:when test="string-length(get_notes_response/note/result/@id) = 0">
          <h3><xsl:value-of select="gsa:i18n ('Associated Result', 'Note or Override')"/>: <xsl:value-of select="gsa:i18n ('Any', 'Result')"/></h3>
        </xsl:when>
        <xsl:otherwise>
          <h3>
            <xsl:value-of select="gsa:i18n ('Associated Result', 'Note or Override')"/>
          </h3>
          <table class="gbntable" cellspacing="2" cellpadding="4" border="0">
            <xsl:for-each select="get_notes_response/note/result">
              <xsl:call-template name="result-detailed">
                <xsl:with-param name="note-buttons">0</xsl:with-param>
                <xsl:with-param name="override-buttons">0</xsl:with-param>
              </xsl:call-template>
            </xsl:for-each>
          </table>
        </xsl:otherwise>
      </xsl:choose>
    </div>
  </div>
</xsl:template>

<xsl:template match="edit_note">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_note_response"/>
  <xsl:call-template name="html-edit-note-form"/>
</xsl:template>

<xsl:template match="modify_note_response">
  <xsl:call-template name="command_result_dialog">
    <xsl:with-param name="operation">Save Note</xsl:with-param>
    <xsl:with-param name="status">
      <xsl:value-of select="@status"/>
    </xsl:with-param>
    <xsl:with-param name="msg">
      <xsl:value-of select="@status_text"/>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="note" match="note">
  <xsl:param name="next">get_notes</xsl:param>
  <xsl:param name="params"/>
  <xsl:param name="params-get"/>

  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Note'"/>
      </xsl:call-template>
      <a href="/omp?cmd=get_note&amp;note_id={@id}&amp;token={/envelope/token}"
         title="{gsa:view_details_title ('Note', @id)}">
        <xsl:if test="orphan = 1"><b><xsl:value-of select="gsa:i18n ('Orphan', 'Note')"/></b><br/></xsl:if>
        <xsl:choose>
          <xsl:when test="text/@excerpt = 1">
              <xsl:value-of select="text/text()"/>...
          </xsl:when>
          <xsl:otherwise>
              <xsl:value-of select="text/text()"/>
          </xsl:otherwise>
        </xsl:choose>
      </a>
    </td>
    <td>
      <xsl:variable name="max" select="70"/>
      <xsl:choose>
        <xsl:when test="nvt/@oid = 0">
          <abbr title="{gsa:i18n ('Result was an open port.', 'Note or Override')}"><xsl:value-of select="gsa:i18n ('None', 'NVT')"/></abbr>
        </xsl:when>
        <xsl:when test="string-length(nvt/name) &gt; $max">
          <abbr title="{nvt/name} ({nvt/@oid})"><xsl:value-of select="substring(nvt/name, 0, $max)"/>...</abbr>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="nvt/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="active='0'">
          <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:choose>
      <xsl:when test="/envelope/params/bulk_select = 1">
        <td style="text-align:center">
          <label style="width:100%">
            <input name="bulk_selected:{@id}" type="checkbox" style="width:100%; height:100%" title="{gsa:i18n ('Select for bulk action', 'Bulk Action')}"/>
          </label>
        </td>
      </xsl:when>
      <xsl:otherwise>
        <td>
          <xsl:call-template name="list-window-line-icons">
            <xsl:with-param name="cap-type" select="'Note'"/>
            <xsl:with-param name="type" select="'note'"/>
            <xsl:with-param name="id" select="@id"/>
            <xsl:with-param name="params" select="$params-get"/>
            <xsl:with-param name="next" select="$next"/>
          </xsl:call-template>
        </td>
      </xsl:otherwise>
    </xsl:choose>
  </tr>
</xsl:template>

<xsl:template match="note" mode="trash">
  <xsl:param name="next">get_notes</xsl:param>
  <xsl:param name="params"/>
  <xsl:param name="params-get"/>

  <tr class="{gsa:table-row-class(position())}">
    <td>
      <xsl:variable name="max" select="70"/>
      <xsl:call-template name="observers-icon">
        <xsl:with-param name="type" select="'Note'"/>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="nvt/@oid = 0">
          <abbr title="{gsa:i18n ('Result was an open port.', 'Note or Override')}"><xsl:value-of select="gsa:i18n ('None', 'NVT')"/></abbr>
        </xsl:when>
        <xsl:when test="string-length(nvt/name) &gt; $max">
          <abbr title="{nvt/name} ({nvt/@oid})"><xsl:value-of select="substring(nvt/name, 0, $max)"/>...</abbr>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="nvt/name"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:if test="orphan = 1"><b><xsl:value-of select="gsa:i18n ('Orphan', 'Note')"/></b><br/></xsl:if>
      <xsl:choose>
        <xsl:when test="text/@excerpt = 1">
          <xsl:value-of select="text/text()"/>...
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="text/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:call-template name="restore-icon">
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
      <xsl:call-template name="trash-delete-icon">
        <xsl:with-param name="type" select="'note'"/>
        <xsl:with-param name="id" select="@id"/>
      </xsl:call-template>
    </td>
  </tr>
</xsl:template>

<xsl:template match="note" mode="details">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center">
      <xsl:value-of select="gsa:i18n ('Note Details', 'Note')"/>
      <xsl:call-template name="details-header-icons">
        <xsl:with-param name="cap-type" select="'Note'"/>
        <xsl:with-param name="type" select="'note'"/>
      </xsl:call-template>
    </div>
    <div class="gb_window_part_content">
      <xsl:call-template name="minor-details"/>
      <table>
        <tr>
          <td><b><xsl:value-of select="gsa:i18n ('NVT Name', 'Note or Override')"/>:</b></td>
          <td>
            <xsl:variable name="max" select="70"/>
            <xsl:choose>
              <xsl:when test="nvt/@oid = 0">
                <xsl:value-of select="gsa:i18n ('None.  Result was an open port.', 'Note or Override')"/>
              </xsl:when>
              <xsl:when test="string-length(nvt/name) &gt; $max">
                <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={nvt/@oid}&amp;token={/envelope/token}">
                  <abbr title="{nvt/name} ({nvt/@oid})"><xsl:value-of select="substring(nvt/name, 0, $max)"/>...</abbr>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={nvt/@oid}&amp;token={/envelope/token}">
                  <xsl:value-of select="nvt/name"/>
                </a>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('NVT OID', 'Note or Override')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="nvt/@oid = 0"></xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="nvt/@oid"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Active', 'Note')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="active='0'">
                <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
              </xsl:when>
              <xsl:when test="active='1' and string-length (end_time) &gt; 0">
                <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>, <xsl:value-of select="gsa:i18n ('until', 'Time')"/> <xsl:value-of select="gsa:long-time (end_time)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('yes', 'Binary Choice')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>

      <h1><xsl:value-of select="gsa:i18n ('Application', 'Note or Override')"/></h1>
      <table>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="string-length(hosts) &gt; 0">
                <xsl:value-of select="hosts"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Any', 'Hosts')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Port', 'Port')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="string-length(port) &gt; 0">
                <xsl:value-of select="port"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Any', 'Port')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Severity', 'Severity')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="severity &lt;= 0">
                <xsl:value-of select="gsa:i18n (gsa:result-cvss-risk-factor (severity), 'Severity')"/>
              </xsl:when>
              <xsl:when test="string-length(severity) &gt; 0">
                &gt; <xsl:value-of select="format-number(severity - 0.1, '0.0')"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Any', 'Severity')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Task', 'Task')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="orphan != 0">
                <b><xsl:value-of select="gsa:i18n ('Orphan', 'Note')"/></b>
              </xsl:when>
              <xsl:when test="task and string-length(task/@id) &gt; 0">
                <xsl:choose>
                  <xsl:when test="task/trash = '1'">
                    <xsl:value-of select="task/name"/> (<xsl:value-of select="gsa:i18n ('in ', 'Trashcan')"/><a href="/omp?cmd=get_trash&amp;token={/envelope/token}"><xsl:value-of select="gsa:i18n ('trashcan', 'Trashcan')"/></a>)
                  </xsl:when>
                  <xsl:otherwise>
                    <a href="?cmd=get_task&amp;task_id={task/@id}&amp;token={/envelope/token}">
                      <xsl:value-of select="task/name"/>
                    </a>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Any', 'Task')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
        <tr>
          <td><xsl:value-of select="gsa:i18n ('Result', 'Result')"/>:</td>
          <td>
            <xsl:choose>
              <xsl:when test="orphan != 0">
                <b><xsl:value-of select="gsa:i18n ('Orphan', 'Note')"/></b>
              </xsl:when>
              <xsl:when test="string-length(result/@id) &gt; 0">
                <xsl:value-of select="result/@id"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="gsa:i18n ('Any', 'Result')"/>
              </xsl:otherwise>
            </xsl:choose>
          </td>
        </tr>
      </table>

      <xsl:choose>
        <xsl:when test="active = '0'">
          <h1><xsl:value-of select="gsa:i18n ('Appearance when Active', 'Note or Override')"/></h1>
        </xsl:when>
        <xsl:otherwise>
          <h1><xsl:value-of select="gsa:i18n ('Appearance', 'Note or Override')"/></h1>
        </xsl:otherwise>
      </xsl:choose>
      <div class="note_top_line"></div>
      <xsl:call-template name="note-detailed">
        <xsl:with-param name="note-buttons">0</xsl:with-param>
      </xsl:call-template>
    </div>
  </div>
  <xsl:call-template name="user-tags-window">
    <xsl:with-param name="title" select="concat(gsa:i18n ('User Tags for this Note', 'Note'),': ')"/>
    <xsl:with-param name="tag_names" select="../../../get_tags_response"/>
    <xsl:with-param name="resource_type" select="'note'"/>
  </xsl:call-template>
  <xsl:call-template name="resource-permissions-window">
    <xsl:with-param name="title" select="concat(gsa:i18n ('Permissions for this Note', 'Note'),': ')"/>
    <xsl:with-param name="resource_type" select="'note'"/>
    <xsl:with-param name="permissions" select="../../permissions/get_permissions_response"/>
    <xsl:with-param name="related">
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-notes-table">
  <xsl:call-template name="list-window">
    <xsl:with-param name="type" select="'note'"/>
    <xsl:with-param name="cap-type" select="'Note'"/>
    <xsl:with-param name="resources-summary" select="notes"/>
    <xsl:with-param name="resources" select="note"/>
    <xsl:with-param name="count" select="count (note)"/>
    <xsl:with-param name="filtered-count" select="note_count/filtered"/>
    <xsl:with-param name="full-count" select="note_count/text ()"/>
    <xsl:with-param name="columns">
      <column>
        <name><xsl:value-of select="gsa:i18n('Text', 'Note or Override')"/></name>
        <field>text</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('NVT', 'NVT')"/></name>
        <field>nvt</field>
      </column>
      <column>
        <name><xsl:value-of select="gsa:i18n('Active', 'Note')"/></name>
        <field>active</field>
      </column>
    </xsl:with-param>
    <xsl:with-param name="icon-count" select="4"/>
  </xsl:call-template>
</xsl:template>

<xsl:template name="html-notes-trash-table">
  <div>
    <table class="gbntable" cellspacing="2" cellpadding="4" border="0">
      <tr class="gbntablehead2">
        <td><xsl:value-of select="gsa:i18n ('NVT', 'NVT')"/></td>
        <td><xsl:value-of select="gsa:i18n ('Text', 'Note or Override')"/></td>
        <td width="{$trash-actions-width}"><xsl:value-of select="gsa:i18n ('Actions', 'Actions')"/></td>
      </tr>
      <xsl:apply-templates select="note" mode="trash"/>
    </table>
  </div>
</xsl:template>

<xsl:template match="get_note">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="modify_note_response"/>
  <xsl:apply-templates select="delete_tag_response"/>
  <xsl:apply-templates select="create_tag_response"/>
  <xsl:apply-templates select="modify_tag_response"/>
  <xsl:choose>
    <xsl:when test="get_notes_response/@status = '500'">
      <xsl:call-template name="command_result_dialog">
        <xsl:with-param name="operation">
          Get Note
        </xsl:with-param>
        <xsl:with-param name="status">
          <xsl:value-of select="500"/>
        </xsl:with-param>
        <xsl:with-param name="msg">
          <xsl:value-of select="get_notes_response/@status_text"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="get_notes_response/note" mode="details"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="get_notes">
  <xsl:apply-templates select="gsad_msg"/>
  <xsl:apply-templates select="delete_note_response"/>
  <xsl:apply-templates select="create_filter_response"/>
  <xsl:apply-templates select="create_note_response"/>
  <!-- The for-each makes the get_notes_response the current node. -->
  <xsl:for-each select="get_notes_response | commands_response/get_notes_response">
    <xsl:call-template name="html-notes-table"/>
  </xsl:for-each>
</xsl:template>


<!-- BEGIN OVERRIDES MANAGEMENT -->

<xsl:template name="html-create-override-form">
  <div class="gb_window">
    <div class="gb_window_part_left"></div>
    <div class="gb_window_part_right"></div>
    <div class="gb_window_part_center"><xsl:value-of select="gsa:i18n ('New Override', 'Override')"/>
      <a href="/help/new_override.html?token={/envelope/token}"
         title="{gsa:i18n ('Help', 'Help')}: {gsa:i18n ('New Override', 'Override')}">
        <img src="/img/help.png"/>
      </a>
      <a href="/omp?cmd=get_overrides&amp;filter={str:encode-uri (gsa:envelope-filter (), true ())}&amp;filt_id={/envelope/params/filt_id}&amp;token={/envelope/token}"
         title="{gsa:i18n ('Overrides', 'Override')}" style="margin-left:3px;">
        <img src="/img/list.png" border="0" alt="{gsa:i18n ('Overrides', 'Override')}"/>
      </a>
    </div>
    <div class="gb_window_part_content">
      <form action="/omp#overrides-{result/@id}"
            method="post"
            enctype="multipart/form-data">
        <input type="hidden" name="token" value="{/envelope/token}"/>
        <input type="hidden" name="cmd" value="create_override"/>
        <input type="hidden" name="caller" value="{/envelope/current_page}"/>
        <input type="hidden" name="next" value="{/envelope/params/next}"/>
        <input type="hidden" name="filter" value="{gsa:envelope-filter ()}"/>
        <input type="hidden" name="filt_id" value="{/envelope/params/filt_id}"/>

        <xsl:choose>
          <xsl:when test="/envelope/params/next='get_result'">
            <!-- get_result params. -->
            <input type="hidden" name="result_id" value="{result/@id}"/>
            <input type="hidden" name="name" value="{task/name}"/>
            <input type="hidden" name="task_id" value="{task/@id}"/>
            <input type="hidden" name="overrides" value="{overrides}"/>
            <input type="hidden" name="apply_overrides" value="{/envelope/params/apply_overrides}"/>
            <input type="hidden" name="autofp" value="{/envelope/params/autofp}"/>
            <input type="hidden" name="report_result_id" value="{/envelope/params/report_result_id}"/>

            <!-- get_report passthrough params. -->
            <input type="hidden" name="report_id" value="{report/@id}"/>
            <input type="hidden" name="overrides" value="{overrides}"/>
          </xsl:when>
          <xsl:when test="/envelope/params/next='get_info'">
            <!-- get_info (nvt) params. -->
            <input type="hidden" name="info_id" value="{/envelope/params/oid}"/>
            <input type="hidden" name="info_type" value="nvt"/>
          </xsl:when>
          <xsl:otherwise>
            <!-- get_report params. -->
            <input type="hidden" name="report_id" value="{/envelope/params/report_id}"/>
            <input type="hidden" name="overrides" value="{/envelope/params/overrides}"/>
            <input type="hidden" name="details" value="{/envelope/params/details}"/>
          </xsl:otherwise>
        </xsl:choose>

        <table border="0" cellspacing="0" cellpadding="3" width="100%">
          <xsl:choose>
            <xsl:when test="result/@id">
              <input type="hidden" name="oid" value="{nvt/@id}"/>
              <tr>
                <td valign="center" width="125"><b><xsl:value-of select="gsa:i18n ('NVT Name', 'Note or Override')"/></b></td>
                <td>
                  <xsl:variable name="nvt" select="get_results_response/result/nvt"/>
                  <xsl:variable name="max" select="70"/>
                  <xsl:choose>
                    <xsl:when test="$nvt/@oid = 0">
                      <xsl:value-of select="gsa:i18n ('None.  Result was an open port.', 'Note or Override')"/>
                    </xsl:when>
                    <xsl:when test="string-length($nvt/name) &gt; $max">
                      <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={$nvt/@oid}&amp;token={/envelope/token}">
                        <abbr title="{$nvt/name} ({$nvt/@oid})"><xsl:value-of select="substring($nvt/name, 0, $max)"/>...</abbr>
                      </a>
                    </xsl:when>
                    <xsl:otherwise>
                      <a href="?cmd=get_info&amp;info_type=nvt&amp;info_id={$nvt/@oid}&amp;token={/envelope/token}">
                        <xsl:value-of select="$nvt/name"/>
                      </a>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td valign="center" width="125"><b><xsl:value-of select="gsa:i18n ('NVT OID', 'Note or Override')"/></b></td>
                <td>
                  <xsl:choose>
                    <xsl:when test="nvt/@id = '0'">
                      <input type="text" name="oid" size="30" maxlength="80" value="1.3.6.1.4.1.25623.1.0."/>
                    </xsl:when>
                    <xsl:otherwise>
                      <input type="text" name="oid" size="30" maxlength="80" value="{nvt/@id}"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
          <tr>
            <td valign="center" width="125">
              <xsl:value-of select="gsa:i18n ('Active', 'Override')"/>
            </td>
            <td>
              <div>
                <label>
                  <input type="radio" name="active" value="-1" checked="1"/>
                  <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('always', 'Time'))"/>
                </label>
              </div>
              <div>
                <label>
                  <input type="radio" name="active" value="1"/>
                  <xsl:value-of select="concat (gsa:i18n ('yes', 'Binary Choice'), ', ', gsa:i18n ('for the next', 'Time'), ' ')"/>
                </label>
                <label>
                  <input type="text" name="days" size="3" maxlength="7" value="30"/>
                  <xsl:value-of select="gsa:i18n ('days', 'Time')"/>
                </label>
              </div>
              <div>
                <label>
                  <input type="radio" name="active" value="0"/>
                  <xsl:value-of select="gsa:i18n ('no', 'Binary Choice')"/>
                </label>
              </div>
            </td>
          </tr>
          <tr>
            <td valign="top" width="125">
              <xsl:value-of select="gsa:i18n ('Hosts', 'Host')"/>
            </td>
            <td>
  