// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/servicecontrol/v1/service_controller.proto
// DO NOT EDIT!

package google_api_servicecontrol_v1 // import "google.golang.org/genproto/googleapis/api/servicecontrol/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request message for the Check method.
type CheckRequest struct {
	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See [google.api.Service][google.api.Service] for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The operation to be checked.
	Operation *Operation `protobuf:"bytes,2,opt,name=operation" json:"operation,omitempty"`
	// Specifies which version of service configuration should be used to process
	// the request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId string `protobuf:"bytes,4,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *CheckRequest) Reset()                    { *m = CheckRequest{} }
func (m *CheckRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()               {}
func (*CheckRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{0} }

func (m *CheckRequest) GetOperation() *Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// Response message for the Check method.
type CheckResponse struct {
	// The same operation_id value used in the CheckRequest.
	// Used for logging and diagnostics purposes.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// Indicate the decision of the check.
	//
	// If no check errors are present, the service should process the operation.
	// Otherwise the service should use the list of errors to determine the
	// appropriate action.
	CheckErrors []*CheckError `protobuf:"bytes,2,rep,name=check_errors,json=checkErrors" json:"check_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,5,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *CheckResponse) Reset()                    { *m = CheckResponse{} }
func (m *CheckResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckResponse) ProtoMessage()               {}
func (*CheckResponse) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{1} }

func (m *CheckResponse) GetCheckErrors() []*CheckError {
	if m != nil {
		return m.CheckErrors
	}
	return nil
}

// Request message for the Report method.
type ReportRequest struct {
	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See [google.api.Service][google.api.Service] for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// Operations to be reported.
	//
	// Typically the service should report one operation per request.
	// Putting multiple operations into a single request is allowed, but should
	// be used only when multiple operations are natually available at the time
	// of the report.
	//
	// If multiple operations are in a single request, the total request size
	// should be no larger than 1MB. See [ReportResponse.report_errors][google.api.servicecontrol.v1.ReportResponse.report_errors] for
	// partial failure behavior.
	Operations []*Operation `protobuf:"bytes,2,rep,name=operations" json:"operations,omitempty"`
	// Specifies which version of service config should be used to process the
	// request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId string `protobuf:"bytes,3,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *ReportRequest) Reset()                    { *m = ReportRequest{} }
func (m *ReportRequest) String() string            { return proto.CompactTextString(m) }
func (*ReportRequest) ProtoMessage()               {}
func (*ReportRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{2} }

func (m *ReportRequest) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// Response message for the Report method.
type ReportResponse struct {
	// Partial failures, one for each `Operation` in the request that failed
	// processing. There are three possible combinations of the RPC status:
	//
	// 1. The combination of a successful RPC status and an empty `report_errors`
	//    list indicates a complete success where all `Operations` in the
	//    request are processed successfully.
	// 2. The combination of a successful RPC status and a non-empty
	//    `report_errors` list indicates a partial success where some
	//    `Operations` in the request succeeded. Each
	//    `Operation` that failed processing has a corresponding item
	//    in this list.
	// 3. A failed RPC status indicates a complete failure where none of the
	//    `Operations` in the request succeeded.
	ReportErrors []*ReportResponse_ReportError `protobuf:"bytes,1,rep,name=report_errors,json=reportErrors" json:"report_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,2,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *ReportResponse) Reset()                    { *m = ReportResponse{} }
func (m *ReportResponse) String() string            { return proto.CompactTextString(m) }
func (*ReportResponse) ProtoMessage()               {}
func (*ReportResponse) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{3} }

func (m *ReportResponse) GetReportErrors() []*ReportResponse_ReportError {
	if m != nil {
		return m.ReportErrors
	}
	return nil
}

// Represents the processing error of one `Operation` in the request.
type ReportResponse_ReportError struct {
	// The [Operation.operation_id][google.api.servicecontrol.v1.Operation.operation_id] value from the request.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// Details of the error when processing the `Operation`.
	Status *google_rpc.Status `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *ReportResponse_ReportError) Reset()                    { *m = ReportResponse_ReportError{} }
func (m *ReportResponse_ReportError) String() string            { return proto.CompactTextString(m) }
func (*ReportResponse_ReportError) ProtoMessage()               {}
func (*ReportResponse_ReportError) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{3, 0} }

func (m *ReportResponse_ReportError) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*CheckRequest)(nil), "google.api.servicecontrol.v1.CheckRequest")
	proto.RegisterType((*CheckResponse)(nil), "google.api.servicecontrol.v1.CheckResponse")
	proto.RegisterType((*ReportRequest)(nil), "google.api.servicecontrol.v1.ReportRequest")
	proto.RegisterType((*ReportResponse)(nil), "google.api.servicecontrol.v1.ReportResponse")
	proto.RegisterType((*ReportResponse_ReportError)(nil), "google.api.servicecontrol.v1.ReportResponse.ReportError")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ServiceController service

type ServiceControllerClient interface {
	// Checks an operation with Google Service Control to decide whether
	// the given operation should proceed. It should be called before the
	// operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// up to 60s. In case of server errors, the client may rely on the cached
	// results for longer time.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Reports operations to Google Service Control. It should be called
	// after the operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5s to
	// reduce API traffic. Limiting aggregation to 5s is to reduce data loss
	// during client crashes. Clients should carefully choose the aggregation
	// window to avoid data loss risk more than 0.01% for business and
	// compliance reasons.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error)
}

type serviceControllerClient struct {
	cc *grpc.ClientConn
}

func NewServiceControllerClient(cc *grpc.ClientConn) ServiceControllerClient {
	return &serviceControllerClient{cc}
}

func (c *serviceControllerClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := grpc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Check", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceControllerClient) Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error) {
	out := new(ReportResponse)
	err := grpc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Report", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ServiceController service

type ServiceControllerServer interface {
	// Checks an operation with Google Service Control to decide whether
	// the given operation should proceed. It should be called before the
	// operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// up to 60s. In case of server errors, the client may rely on the cached
	// results for longer time.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Reports operations to Google Service Control. It should be called
	// after the operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5s to
	// reduce API traffic. Limiting aggregation to 5s is to reduce data loss
	// during client crashes. Clients should carefully choose the aggregation
	// window to avoid data loss risk more than 0.01% for business and
	// compliance reasons.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(context.Context, *ReportRequest) (*ReportResponse, error)
}

func RegisterServiceControllerServer(s *grpc.Server, srv ServiceControllerServer) {
	s.RegisterService(&_ServiceController_serviceDesc, srv)
}

func _ServiceController_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceController_Report_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Report(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Report",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Report(ctx, req.(*ReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicecontrol.v1.ServiceController",
	HandlerType: (*ServiceControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Check",
			Handler:    _ServiceController_Check_Handler,
		},
		{
			MethodName: "Report",
			Handler:    _ServiceController_Report_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/api/servicecontrol/v1/service_controller.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/servicecontrol/v1/service_controller.proto", fileDescriptor5)
}

var fileDescriptor5 = []byte{
	// 535 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x94, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xb5, 0xee, 0x1f, 0xa9, 0xe3, 0x04, 0xd4, 0x3d, 0xa0, 0xc8, 0xe2, 0x90, 0xfa, 0x40,
	0x23, 0xb7, 0xd8, 0x6a, 0xb8, 0xa0, 0x48, 0x1c, 0x68, 0x54, 0xaa, 0xa8, 0x02, 0x2a, 0x87, 0x23,
	0x28, 0x5a, 0x9c, 0xad, 0xb1, 0x48, 0xbc, 0xcb, 0xae, 0x9b, 0x0b, 0xe2, 0xc2, 0x03, 0x70, 0x80,
	0x37, 0x40, 0x48, 0x1c, 0x78, 0x02, 0x9e, 0x83, 0x57, 0xe0, 0x21, 0xe0, 0x86, 0xbc, 0xbb, 0x76,
	0x5d, 0x61, 0x2c, 0x97, 0x9e, 0xec, 0x9d, 0xdd, 0x99, 0xf9, 0xe9, 0xfb, 0x46, 0x03, 0xcf, 0x62,
	0xc6, 0xe2, 0x05, 0xf5, 0x63, 0xb6, 0x20, 0x69, 0xec, 0x33, 0x11, 0x07, 0x31, 0x4d, 0xb9, 0x60,
	0x19, 0x0b, 0xf4, 0x15, 0xe1, 0x89, 0x0c, 0x08, 0x4f, 0x02, 0x49, 0xc5, 0x2a, 0x89, 0x68, 0xc4,
	0xd2, 0x4c, 0xb0, 0x45, 0xb0, 0x3a, 0x28, 0x22, 0x33, 0x13, 0x5a, 0x50, 0xe1, 0xab, 0x4c, 0x7c,
	0xdb, 0x54, 0x25, 0x3c, 0xf1, 0x2f, 0xa7, 0xf9, 0xab, 0x03, 0x67, 0xf2, 0x3f, 0x3d, 0xcf, 0x92,
	0x38, 0x20, 0x69, 0xca, 0x32, 0x92, 0x25, 0x2c, 0x95, 0xba, 0x91, 0xf3, 0xf8, 0x3a, 0xf8, 0xd1,
	0x2b, 0x1a, 0xbd, 0x9e, 0x51, 0x21, 0x98, 0xe1, 0x76, 0x4e, 0xae, 0x53, 0x8e, 0x71, 0x2a, 0x14,
	0x9c, 0x29, 0xf6, 0xa0, 0x5d, 0x31, 0xc1, 0xa3, 0x40, 0x66, 0x24, 0x3b, 0x97, 0xe6, 0xa3, 0xd3,
	0xdd, 0x2f, 0x08, 0x3a, 0xe3, 0x9c, 0x30, 0xa4, 0x6f, 0xce, 0xa9, 0xcc, 0xf0, 0x0e, 0x74, 0x0a,
	0xc1, 0x53, 0xb2, 0xa4, 0x3d, 0xd4, 0x47, 0x83, 0xad, 0xd0, 0x36, 0xb1, 0x27, 0x64, 0x49, 0xf1,
	0x11, 0x6c, 0x95, 0x14, 0x3d, 0xab, 0x8f, 0x06, 0xf6, 0x70, 0xd7, 0x6f, 0xf2, 0xc2, 0x7f, 0x5a,
	0x3c, 0x0f, 0x2f, 0x32, 0xb1, 0x07, 0xdb, 0x15, 0x6b, 0xcf, 0x92, 0x78, 0x96, 0xcc, 0x7b, 0xeb,
	0xaa, 0xdd, 0x4d, 0x73, 0x31, 0x56, 0xf1, 0xc9, 0xdc, 0xfd, 0x86, 0xa0, 0x6b, 0x30, 0x25, 0x67,
	0xa9, 0xa4, 0x39, 0x67, 0x59, 0x2a, 0x4f, 0x34, 0x9c, 0x65, 0x6c, 0x32, 0xc7, 0x27, 0xd0, 0xa9,
	0x88, 0x2f, 0x7b, 0x56, 0x7f, 0x6d, 0x60, 0x0f, 0x07, 0xcd, 0xa8, 0xaa, 0xcb, 0x51, 0x9e, 0x10,
	0xda, 0x51, 0xf9, 0x2f, 0xeb, 0x69, 0x37, 0xea, 0x69, 0xbf, 0x22, 0xe8, 0x86, 0x94, 0x33, 0x91,
	0x5d, 0x41, 0xd5, 0x63, 0x80, 0x12, 0xbe, 0x60, 0x6d, 0x2d, 0x6b, 0x25, 0xb5, 0x9e, 0x74, 0xad,
	0x9e, 0xf4, 0x37, 0x82, 0x1b, 0x05, 0xa9, 0x11, 0xf6, 0x05, 0x74, 0x85, 0x8a, 0x14, 0xb2, 0x21,
	0x85, 0x72, 0xbf, 0x19, 0xe5, 0x72, 0x11, 0x73, 0xd4, 0x32, 0x76, 0xc4, 0xc5, 0xe1, 0x1f, 0x74,
	0x56, 0x2d, 0x9d, 0xf3, 0x1c, 0xec, 0x4a, 0xa1, 0x36, 0x96, 0x7b, 0xb0, 0xa9, 0xc7, 0xdb, 0xcc,
	0x25, 0x2e, 0xa8, 0x05, 0x8f, 0xfc, 0xa9, 0xba, 0x09, 0xcd, 0x8b, 0xe1, 0x77, 0x0b, 0xb6, 0xa7,
	0x65, 0x47, 0xb3, 0x5a, 0xf0, 0x07, 0x04, 0x1b, 0x6a, 0x06, 0xb0, 0xd7, 0x62, 0x50, 0x8c, 0xbf,
	0xce, 0x5e, 0xab, 0xb7, 0x5a, 0x1c, 0x77, 0xff, 0xfd, 0x8f, 0x9f, 0x9f, 0xac, 0x3b, 0xee, 0x4e,
	0x65, 0xbb, 0xc9, 0xe0, 0x6d, 0x75, 0x40, 0xde, 0x8d, 0xd4, 0xec, 0x8d, 0x90, 0x87, 0x3f, 0x22,
	0xd8, 0xd4, 0x2a, 0xe0, 0xbd, 0x76, 0x1e, 0x68, 0xa4, 0xfd, 0xab, 0x18, 0xe6, 0xde, 0x55, 0x4c,
	0xbb, 0xae, 0xdb, 0xc4, 0xa4, 0x8d, 0x1c, 0x21, 0xef, 0xf0, 0x11, 0xf4, 0x23, 0xb6, 0x6c, 0xec,
	0x70, 0x78, 0xeb, 0x2f, 0x71, 0x4f, 0xf3, 0x95, 0x73, 0x8a, 0x7e, 0x21, 0xf4, 0xd9, 0x5a, 0x3f,
	0x7e, 0x38, 0x1d, 0xbf, 0xdc, 0x54, 0x5b, 0xe8, 0xde, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd6,
	0x78, 0xcd, 0xf0, 0x21, 0x06, 0x00, 0x00,
}
