/* PROGRAM:     eggsh
 * FILE:        $Header: /home/egg/src/RCS/reg_pseudo.c,v 1.1 1998/12/31 22:04:39 ghn Exp $
 * PURPOSE:     PEAR (Bradish box/micro-REG) hardware interface
 * AUTHOR:      Greg Nelson
 * DATE:        98-04-12
 *
 * REVISED:     $Log: reg_pseudo.c,v $
 * REVISED:     Revision 1.1  1998/12/31 22:04:39  ghn
 * REVISED:     Initial revision
 * REVISED:
 * REVISED:     Revision 1.3  1998/08/01 18:50:39  ghn
 * REVISED:     Added John's byte-order-independence changes and PSEUDO support.
 * REVISED:
 * REVISED:     Revision 1.2  1998/08/01 17:13:51  ghn
 * REVISED:     Added John's Solaris support and DUMPREG option.
 * REVISED:
 * REVISED:     Revision 1.1  1998/07/21 11:37:41  ghn
 * REVISED:     Initial revision
 * REVISED:
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

/* Define this to dump samples from the REG which we actually use into
   a file named dumpreg.dat.  */
/* #define DUMPREG */

#include <stdio.h>
#include <unistd.h>

#include "global.h"
#include "genlib.h"
#include "reg.h"
#include "lecuyer.h"

#define MAXDEV  20

static int32 oldbits[MAXDEV], bitsleft[MAXDEV];

#ifdef DUMPREG
static FILE *dumpfile;                /* REG dump file handle */
static unsigned char dumpbuf[1024];   /* REG dump buffer */
static int dumpptr = 0;               /* Pointer into dump buffer */
#endif

static int32 OpenDev(DevOpts *opts) {
    int32 seed;
    int i;

    seed = time(NULL);
    LEsetSeed(seed);

    for (i = 0; i < 37; i++) {
        seed = (seed << 3) ^ LEnextByte();
    }
    LEsetSeed(seed);
    seed = LEnextByte();
    for (i = 0; i < (seed & 0x37); i++) {
        (void) LEnextByte();
    }
    return 0;
}

static int32 Sample(int32 dd, uint16 bits) {
  int32 bc, sum;
  uint8 c1;

  sum = bc = 0;
  while (bc < bits) {
    if (bitsleft[dd]) {
      sum += (oldbits[dd] & 0x01);
      oldbits[dd] >>= 1;
      bitsleft[dd]--;
      bc++;
    } else {
      c1 = LEnextByte();
#ifdef DUMPREG
      dumpbuf[dumpptr++] = c1;
      if (dumpptr >= sizeof(dumpbuf)) {
        fwrite(dumpbuf, sizeof(dumpbuf), 1, dumpfile);
        dumpptr = 0;
      }
#endif
      oldbits[dd] = c1;
      bitsleft[dd] = 8;
    }
  }

  return sum;
}

#define SAMP_PERIOD     1000    /* msec */
#define MARGIN          .95     /* how much to headroom to allow in
                                   speed measurement */

static int32 EvalSpeed(int32 dd) {
  struct timeval start, end;
  int32 bitct, samp;

  gettimeofday(&start, NULL);
  bitct = 0;
  while (1) {
    gettimeofday(&end, NULL);
    if (deltams(&end, &start) >= SAMP_PERIOD) break;
    samp = Sample(dd, 1);
    bitct++;
  }

  return (int32)(bitct * MARGIN);
}

static int32 Discard(int32 dd) {
  int32 disc;
  
  disc = bitsleft[dd];
  bitsleft[dd] = 0;
  return disc;
}

static int32 CloseDev(int32 dd) {
  return 0;
}

/*  Driver description table.  */

REG_driver REG_pseudo = {
                        "PSEUDO", 
                        2000,
                        OpenDev,
                        EvalSpeed,
                        Sample,
                        Discard,
                        CloseDev
                      };
