
! Copyright (C) 2018 T. Mueller, J. K. Dewhurst, S. Sharma and E. K. U. Gross.
! This file is distributed under the terms of the GNU General Public License.
! See the file COPYING for license details.

subroutine potxculr
use modmain
use modulr
use modomp
implicit none
! local variables
integer idm,is,ias,ir
integer np,npc,i
integer nthd,ithd
real(8) t1
! allocatable arrays
real(8), allocatable :: vxcrmt(:,:,:),vxcrir(:,:)
real(8), allocatable :: bxcrmt(:,:,:,:),bxcrir(:,:,:)
real(8), allocatable :: rhomt_(:,:),magmt_(:,:,:)
real(8), allocatable :: vxcmt_(:,:),bxcmt_(:,:,:)
real(8), allocatable :: rfmt(:,:)
complex(8), allocatable :: zfft(:,:)
allocate(vxcrmt(npcmtmax,natmtot,nqpt),vxcrir(ngtot,nqpt))
if (spinpol) then
  allocate(bxcrmt(npcmtmax,natmtot,ndmag,nqpt))
  allocate(bxcrir(ngtot,ndmag,nqpt))
end if
! generate the core density in spherical coordinates
allocate(rfmt(npmtmax,natmtot))
do ias=1,natmtot
  is=idxis(ias)
  i=1
  do ir=1,nrmti(is)
    t1=rhocr(ir,ias,1)*y00
    rfmt(i:i+lmmaxi-1,ias)=t1
    i=i+lmmaxi
  end do
  do ir=nrmti(is)+1,nrmt(is)
    t1=rhocr(ir,ias,1)*y00
    rfmt(i:i+lmmaxo-1,ias)=t1
    i=i+lmmaxo
  end do
end do
call omp_hold(nqpt,nthd)
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(rhomt_,vxcmt_,magmt_,bxcmt_) &
!$OMP PRIVATE(ias,is,np,idm) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
do ir=1,nqpt
  allocate(rhomt_(npmtmax,natmtot),vxcmt_(npmtmax,natmtot))
  if (spinpol) then
    allocate(magmt_(npmtmax,natmtot,ndmag),bxcmt_(npmtmax,natmtot,ndmag))
  end if
! convert the density from a coarse to a fine radial mesh
  do ias=1,natmtot
    is=idxis(ias)
    call dcopy(npcmt(is),rhormt(:,ias,ir),1,rhomt_(:,ias),1)
  end do
  call rfmtctof(rhomt_)
! add the core density
  do ias=1,natmtot
    is=idxis(ias)
    np=npmt(is)
    rhomt_(1:np,ias)=rhomt_(1:np,ias)+rfmt(1:np,ias)
  end do
! convert magnetisation from a coarse to a fine radial mesh
  do idm=1,ndmag
    do ias=1,natmtot
      is=idxis(ias)
      call dcopy(npcmt(is),magrmt(:,ias,idm,ir),1,magmt_(:,ias,idm),1)
    end do
    call rfmtctof(magmt_(:,:,idm))
  end do
! calculate the exchange-correlation potential and magnetic field
  call potxc(.false.,xctype,rhomt_,rhorir(:,ir),magmt_,magrir(:,:,ir),taumt, &
   tauir,exmt,exir,ecmt,ecir,vxcmt_,vxcrir(:,ir),bxcmt_,bxcrir(:,:,ir),wxcmt, &
   wxcir)
! convert muffin-tin potential and field from fine to coarse radial mesh
  do ias=1,natmtot
    is=idxis(ias)
    call rfmtftoc(nrmt(is),nrmti(is),vxcmt_(:,ias),vxcrmt(:,ias,ir))
  end do
  do idm=1,ndmag
    do ias=1,natmtot
      is=idxis(ias)
      call rfmtftoc(nrmt(is),nrmti(is),bxcmt_(:,ias,idm),bxcrmt(:,ias,idm,ir))
    end do
  end do
  deallocate(rhomt_,vxcmt_)
  if (spinpol) deallocate(magmt_,bxcmt_)
end do
!$OMP END DO
!$OMP END PARALLEL
call omp_free(nthd)
deallocate(rfmt)
! add the external Coulomb potential and Fourier transform to Q-space
do ias=1,natmtot
  is=idxis(ias)
  npc=npcmt(is)
  call omp_hold(npc,nthd)
  allocate(zfft(nqpt,0:nthd-1))
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(ithd) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
  do i=1,npc
    ithd=omp_get_thread_num()
    zfft(:,ithd)=vxcrmt(i,ias,:)+vclru(:)
    call zfftifc(3,ngridq,-1,zfft(:,ithd))
    vsqmt(i,ias,:)=vsqmt(i,ias,:)+zfft(:,ithd)
  end do
!$OMP END DO
!$OMP END PARALLEL
  deallocate(zfft)
  call omp_free(nthd)
end do
call omp_hold(ngtot,nthd)
allocate(zfft(nqpt,0:nthd-1))
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(ithd) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
do ir=1,ngtot
  ithd=omp_get_thread_num()
  zfft(:,ithd)=vxcrir(ir,:)+vclru(:)
  call zfftifc(3,ngridq,-1,zfft(:,ithd))
  vsqir(ir,:)=vsqir(ir,:)+zfft(:,ithd)
end do
!$OMP END DO
!$OMP END PARALLEL
deallocate(zfft)
call omp_free(nthd)
deallocate(vxcrmt,vxcrir)
if (.not.spinpol) return
! add the external magnetic fields and Fourier transform to Q-space
do idm=1,ndmag
  do ias=1,natmtot
    is=idxis(ias)
    npc=npcmt(is)
    call omp_hold(npc,nthd)
    allocate(zfft(nqpt,0:nthd-1))
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(ithd) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
    do i=1,npc
      ithd=omp_get_thread_num()
      zfft(:,ithd)=bxcrmt(i,ias,idm,:)+bfcru(:,idm)+bfcmtru(:,ias,idm)
      call zfftifc(3,ngridq,-1,zfft(:,ithd))
      bsqmt(i,ias,idm,:)=zfft(:,ithd)
    end do
!$OMP END DO
!$OMP END PARALLEL
    deallocate(zfft)
    call omp_free(nthd)
  end do
end do
do idm=1,ndmag
  call omp_hold(ngtot,nthd)
  allocate(zfft(nqpt,0:nthd-1))
!$OMP PARALLEL DEFAULT(SHARED) &
!$OMP PRIVATE(ithd) &
!$OMP NUM_THREADS(nthd)
!$OMP DO
  do ir=1,ngtot
    ithd=omp_get_thread_num()
    zfft(:,ithd)=bxcrir(ir,idm,:)+bfcru(:,idm)
    call zfftifc(3,ngridq,-1,zfft(:,ithd))
    bsqir(ir,idm,:)=zfft(:,ithd)
  end do
!$OMP END DO
!$OMP END PARALLEL
  deallocate(zfft)
  call omp_free(nthd)
end do
if (spinpol) deallocate(bxcrmt,bxcrir)
return
end subroutine

