DACS_CURRENT_CREDENT(8)    DACS Web Services Manual    DACS_CURRENT_CREDENT(8)



[1mNAME[0m
       dacs_current_credentials - display [1mDACS [22mcredentials

[1mSYNOPSIS[0m
       [1mdacs_current_credentials [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_current_credentials [22mweb service provides information about the
       credentials that accompany the request and the identities described by
       those credentials. It can be used to determine whether credentials are
       valid, confirm who they belong to, find out which roles are associated
       with the credentials, and so on.

       If [34m[1muser activity[0m[1m[22m[2] data is available, [1mdacs_current_credentials [22mcan
       also return information for the identity associated with each valid set
       of credentials, including the time of the last sign on and a
       description of any sign-on that is still "active" (i.e., has not
       expired and was not signed off). This information can be useful for
       detecting unauthorized account access, regardless of the authentication
       method used, and other potentially problematic activity.

       The [34m[4mFORMAT[24m argument[0m[3] determines the type of output, with the default
       being HTML, using the style sheet [34m[1mdacs_current_credentials.css[0m[1m[22m[4]. If
       XML output is selected, a document conforming to
       [34m[1mdacs_current_credentials.dtd[0m[1m[22m[5] is returned, which supplies additional
       information. The JSON format ([34m[1mRFC 7159[0m[1m[22m[6]) is also recognized. The
       previous_auth and active_auth elements appear only when user activity
       tracking data is accessible. The previous_auth element is empty if
       there are not two or more records of authentication activity for the
       associated identity. For a given identity, an active_auth element is
       present for each authentication event for which there is no
       corresponding sign off event, other than the most recent one, and for
       which the issued credentials have not expired - these are "active
       sessions". Reauthentication as the same identity does not create a sign
       off event, however, and signing off (e.g., via [34m[1mdacs_signout(8)[0m[1m[22m[7]) does
       not necessarily mean that a user agent has destroyed credentials
       (though that is normally the case). Also, a user can unilaterally
       destroy credentials (e.g., by terminating a browser session or removing
       cookies manually), so not all active sessions necessarily exist.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       [1mdacs_current_credentials [22maccepts the following arguments in addition to
       the [34m[1mstandard CGI arguments[0m[1m[22m[8].

       [4mDETAIL[0m
           If "yes", this optional argument requests additional information.
           It is recognized only in conjunction with XML format output. By
           default, this argument can only be used by a [1mDACS [22madministrator
           (see [34m[1mdacs_admin()[0m[1m[22m[9]). The activity tracking information is
           returned only if detail is requested.

[1mEXAMPLE[0m
       After [34m[1mauthenticating[0m[1m[22m[10] as DSS::INFOCARDS:bob, [34m[1minvoke[0m
       [1m[34mdacs_current_credentials (HTML)[0m[1m[22m[11] to view the identity (or
       identities) stored as a cookie in your browser. Information about the
       credentials can also be [34m[1mreturned as XML[0m[1m[22m[12].

[1mFILES[0m
       [34m[1mdacs_current_credentials.css[0m[1m[22m[4]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mSEE ALSO[0m
       [34m[1mdacs_authenticate(8)[0m[1m[22m[13], [34m[1mdacs_signout(8)[0m[1m[22m[7]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[14])

[1mCOPYING[0m
       Copyright (C) 2003-2015 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[15] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. user activity
           http://dacs.dss.ca/man/dacs.1.html#tracking_user_activity

        3. [4mFORMAT[24m argument
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

        4. dacs_current_credentials.css
           http://dacs.dss.ca/man//css/dacs_current_credentials.css

        5. dacs_current_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_current_credentials.dtd

        6. RFC 7159
           https://tools.ietf.org/html/rfc7159

        7. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

        8. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        9. dacs_admin()
           http://dacs.dss.ca/man/dacs.exprs.5.html#dacs_admin

       10. authenticating
           https://dacs.dss.ca/cgi-bin/dacs/dacs_authenticate?USERNAME=bob&PASSWORD=foozle&DACS_JURISDICTION=INFOCARDS&AUXILIARY=&DACS_BROWSER=1&COOKIE_SYNTAX=COOKIE_NETSCAPE

       11. invoke dacs_current_credentials (HTML)
           https://dacs.dss.ca/cgi-bin/dacs/dacs_current_credentials?FORMAT=HTML

       12. returned as XML
           https://dacs.dss.ca/cgi-bin/dacs/dacs_current_credentials?FORMAT=XML&DETAIL=yes

       13. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       14. www.dss.ca
           http://www.dss.ca

       15. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016           DACS_CURRENT_CREDENT(8)
