/* RunDialog.c generated by valac 0.32.1, the Vala compiler
 * generated from RunDialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <theme-manager.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <budgie-config.h>


#define BUDGIE_TYPE_DBUS_IMPL (budgie_dbus_impl_get_type ())
#define BUDGIE_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DBUS_IMPL, BudgieDBusImpl))
#define BUDGIE_IS_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DBUS_IMPL))
#define BUDGIE_DBUS_IMPL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_DBUS_IMPL, BudgieDBusImplIface))

typedef struct _BudgieDBusImpl BudgieDBusImpl;
typedef struct _BudgieDBusImplIface BudgieDBusImplIface;

#define BUDGIE_TYPE_DBUS_IMPL_PROXY (budgie_dbus_impl_proxy_get_type ())
typedef GDBusProxy BudgieDBusImplProxy;
typedef GDBusProxyClass BudgieDBusImplProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_APP_LAUNCHER_BUTTON (budgie_app_launcher_button_get_type ())
#define BUDGIE_APP_LAUNCHER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButton))
#define BUDGIE_APP_LAUNCHER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButtonClass))
#define BUDGIE_IS_APP_LAUNCHER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APP_LAUNCHER_BUTTON))
#define BUDGIE_IS_APP_LAUNCHER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APP_LAUNCHER_BUTTON))
#define BUDGIE_APP_LAUNCHER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButtonClass))

typedef struct _BudgieAppLauncherButton BudgieAppLauncherButton;
typedef struct _BudgieAppLauncherButtonClass BudgieAppLauncherButtonClass;
typedef struct _BudgieAppLauncherButtonPrivate BudgieAppLauncherButtonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_RUN_DIALOG (budgie_run_dialog_get_type ())
#define BUDGIE_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog))
#define BUDGIE_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogClass))
#define BUDGIE_IS_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RUN_DIALOG))
#define BUDGIE_IS_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RUN_DIALOG))
#define BUDGIE_RUN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogClass))

typedef struct _BudgieRunDialog BudgieRunDialog;
typedef struct _BudgieRunDialogClass BudgieRunDialogClass;
typedef struct _BudgieRunDialogPrivate BudgieRunDialogPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _BudgieRunDialogSetupDbusData BudgieRunDialogSetupDbusData;

#define BUDGIE_TYPE_RUN_DIALOG_APP (budgie_run_dialog_app_get_type ())
#define BUDGIE_RUN_DIALOG_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogApp))
#define BUDGIE_RUN_DIALOG_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppClass))
#define BUDGIE_IS_RUN_DIALOG_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RUN_DIALOG_APP))
#define BUDGIE_IS_RUN_DIALOG_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RUN_DIALOG_APP))
#define BUDGIE_RUN_DIALOG_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppClass))

typedef struct _BudgieRunDialogApp BudgieRunDialogApp;
typedef struct _BudgieRunDialogAppClass BudgieRunDialogAppClass;
typedef struct _BudgieRunDialogAppPrivate BudgieRunDialogAppPrivate;

struct _BudgieDBusImplIface {
	GTypeInterface parent_iface;
	void (*list_names) (BudgieDBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (BudgieDBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _BudgieAppLauncherButton {
	GtkBox parent_instance;
	BudgieAppLauncherButtonPrivate * priv;
	GAppInfo* app_info;
};

struct _BudgieAppLauncherButtonClass {
	GtkBoxClass parent_class;
};

struct _BudgieRunDialog {
	GtkApplicationWindow parent_instance;
	BudgieRunDialogPrivate * priv;
};

struct _BudgieRunDialogClass {
	GtkApplicationWindowClass parent_class;
};

struct _BudgieRunDialogPrivate {
	GtkRevealer* bottom_revealer;
	GtkListBox* app_box;
	GtkSearchEntry* entry;
	BudgieThemeManager* theme_manager;
	GdkAppLaunchContext* context;
	gboolean focus_quit;
	BudgieDBusImpl* impl;
	gchar* search_text;
	gchar* wanted_dbus_id;
	GHashTable* active_names;
};

struct _BudgieRunDialogSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BudgieRunDialog* self;
	BudgieDBusImpl* _tmp0_;
	BudgieDBusImpl* _tmp1_;
	BudgieDBusImpl* _tmp2_;
	gchar** _tmp3_;
	BudgieDBusImpl* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** name_collection;
	gint name_collection_length1;
	gint _name_collection_size_;
	gint name_it;
	gchar* _tmp8_;
	gchar* name;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	BudgieDBusImpl* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _BudgieRunDialogApp {
	GtkApplication parent_instance;
	BudgieRunDialogAppPrivate * priv;
};

struct _BudgieRunDialogAppClass {
	GtkApplicationClass parent_class;
};

struct _BudgieRunDialogAppPrivate {
	BudgieRunDialog* rd;
};


static gpointer budgie_app_launcher_button_parent_class = NULL;
static gpointer budgie_run_dialog_parent_class = NULL;
static gpointer budgie_run_dialog_app_parent_class = NULL;

GType budgie_dbus_impl_proxy_get_type (void) G_GNUC_CONST;
guint budgie_dbus_impl_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_dbus_impl_get_type (void) G_GNUC_CONST;
void budgie_dbus_impl_list_names (BudgieDBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** budgie_dbus_impl_list_names_finish (BudgieDBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void budgie_dbus_impl_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void budgie_dbus_impl_proxy_list_names_async (BudgieDBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** budgie_dbus_impl_proxy_list_names_finish (BudgieDBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void budgie_dbus_impl_proxy_budgie_dbus_impl_interface_init (BudgieDBusImplIface* iface);
static void _dbus_budgie_dbus_impl_list_names (BudgieDBusImpl* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_dbus_impl_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void budgie_dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_budgie_dbus_impl_name_owner_changed (GObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer* _data);
static void _budgie_dbus_impl_unregister_object (gpointer user_data);
GType budgie_app_launcher_button_get_type (void) G_GNUC_CONST;
enum  {
	BUDGIE_APP_LAUNCHER_BUTTON_DUMMY_PROPERTY
};
BudgieAppLauncherButton* budgie_app_launcher_button_new (GAppInfo* info);
BudgieAppLauncherButton* budgie_app_launcher_button_construct (GType object_type, GAppInfo* info);
static void budgie_app_launcher_button_finalize (GObject* obj);
GType budgie_run_dialog_get_type (void) G_GNUC_CONST;
#define BUDGIE_RUN_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogPrivate))
enum  {
	BUDGIE_RUN_DIALOG_DUMMY_PROPERTY
};
BudgieRunDialog* budgie_run_dialog_new (GtkApplication* app);
BudgieRunDialog* budgie_run_dialog_construct (GType object_type, GtkApplication* app);
static void _g_free0_ (gpointer var);
static void budgie_run_dialog_on_launched (BudgieRunDialog* self, GAppInfo* info, GVariant* v);
static void _budgie_run_dialog_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender, GAppInfo* info, GVariant* platform_data, gpointer self);
static void budgie_run_dialog_on_launch_failed (BudgieRunDialog* self, const gchar* id);
static void _budgie_run_dialog_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender, const gchar* startup_notify_id, gpointer self);
static gboolean budgie_run_dialog_on_key_release (BudgieRunDialog* self, GdkEventKey* btn);
static gboolean _budgie_run_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void budgie_run_dialog_on_search_changed (BudgieRunDialog* self);
static void _budgie_run_dialog_on_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void budgie_run_dialog_on_search_activate (BudgieRunDialog* self);
static void _budgie_run_dialog_on_search_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void budgie_run_dialog_on_row_activate (BudgieRunDialog* self, GtkListBoxRow* row);
static void _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static gboolean budgie_run_dialog_on_filter (BudgieRunDialog* self, GtkListBoxRow* row);
static gboolean _budgie_run_dialog_on_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self);
static void budgie_run_dialog_build_app_box (BudgieRunDialog* self);
static gboolean __lambda5_ (BudgieRunDialog* self);
static gboolean ___lambda5__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void budgie_run_dialog_setup_dbus (BudgieRunDialog* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void budgie_run_dialog_setup_dbus_finish (BudgieRunDialog* self, GAsyncResult* _res_);
static void budgie_run_dialog_launch_button (BudgieRunDialog* self, BudgieAppLauncherButton* button);
static void budgie_run_dialog_check_dbus_name (BudgieRunDialog* self);
static void budgie_run_dialog_add_application (BudgieRunDialog* self, GAppInfo* app_info);
static void _budgie_run_dialog_add_application_gfunc (gconstpointer data, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean ___lambda4_ (BudgieRunDialog* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void budgie_run_dialog_on_name_owner_changed (BudgieRunDialog* self, const gchar* n, const gchar* o, const gchar* ne);
static void budgie_run_dialog_setup_dbus_data_free (gpointer _data);
static gboolean budgie_run_dialog_setup_dbus_co (BudgieRunDialogSetupDbusData* _data_);
static void budgie_run_dialog_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _budgie_run_dialog_on_name_owner_changed_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self);
static void budgie_run_dialog_finalize (GObject* obj);
GType budgie_run_dialog_app_get_type (void) G_GNUC_CONST;
#define BUDGIE_RUN_DIALOG_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppPrivate))
enum  {
	BUDGIE_RUN_DIALOG_APP_DUMMY_PROPERTY
};
BudgieRunDialogApp* budgie_run_dialog_app_new (void);
BudgieRunDialogApp* budgie_run_dialog_app_construct (GType object_type);
static void budgie_run_dialog_app_real_activate (GApplication* base);
static void budgie_run_dialog_app_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_list_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _budgie_dbus_impl_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _budgie_dbus_impl_dbus_arg_info_list_names_out[] = {&_budgie_dbus_impl_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _budgie_dbus_impl_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_budgie_dbus_impl_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_budgie_dbus_impl_dbus_arg_info_list_names_out)};
static const GDBusMethodInfo * const _budgie_dbus_impl_dbus_method_info[] = {&_budgie_dbus_impl_dbus_method_info_list_names, NULL};
static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_name_owner_changed_name = {-1, "name", "s"};
static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s"};
static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s"};
static const GDBusArgInfo * const _budgie_dbus_impl_dbus_arg_info_name_owner_changed[] = {&_budgie_dbus_impl_dbus_arg_info_name_owner_changed_name, &_budgie_dbus_impl_dbus_arg_info_name_owner_changed_old_owner, &_budgie_dbus_impl_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _budgie_dbus_impl_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_budgie_dbus_impl_dbus_arg_info_name_owner_changed)};
static const GDBusSignalInfo * const _budgie_dbus_impl_dbus_signal_info[] = {&_budgie_dbus_impl_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _budgie_dbus_impl_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_dbus_impl_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_budgie_dbus_impl_dbus_method_info), (GDBusSignalInfo **) (&_budgie_dbus_impl_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_dbus_impl_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_dbus_impl_dbus_interface_vtable = {budgie_dbus_impl_dbus_interface_method_call, budgie_dbus_impl_dbus_interface_get_property, budgie_dbus_impl_dbus_interface_set_property};

void budgie_dbus_impl_list_names (BudgieDBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BUDGIE_DBUS_IMPL_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


gchar** budgie_dbus_impl_list_names_finish (BudgieDBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return BUDGIE_DBUS_IMPL_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void budgie_dbus_impl_base_init (BudgieDBusImplIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", BUDGIE_TYPE_DBUS_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	}
}


/**
 * We need to probe the dbus daemon directly, hence this interface
 */
GType budgie_dbus_impl_get_type (void) {
	static volatile gsize budgie_dbus_impl_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_dbus_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieDBusImplIface), (GBaseInitFunc) budgie_dbus_impl_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType budgie_dbus_impl_type_id;
		budgie_dbus_impl_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieDBusImpl", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (budgie_dbus_impl_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_dbus_impl_proxy_get_type);
		g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_dbus_impl_dbus_interface_info));
		g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_dbus_impl_register_object);
		g_once_init_leave (&budgie_dbus_impl_type_id__volatile, budgie_dbus_impl_type_id);
	}
	return budgie_dbus_impl_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BudgieDBusImplProxy, budgie_dbus_impl_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_DBUS_IMPL, budgie_dbus_impl_proxy_budgie_dbus_impl_interface_init) )
static void budgie_dbus_impl_proxy_class_init (BudgieDBusImplProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_dbus_impl_proxy_g_signal;
}


static void _dbus_handle_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp0_;
	gchar* old_owner = NULL;
	GVariant* _tmp1_;
	gchar* new_owner = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	new_owner = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


static void budgie_dbus_impl_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_budgie_dbus_impl_name_owner_changed ((BudgieDBusImpl*) proxy, parameters);
	}
}


static void budgie_dbus_impl_proxy_init (BudgieDBusImplProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void budgie_dbus_impl_proxy_list_names_async (BudgieDBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** budgie_dbus_impl_proxy_list_names_finish (BudgieDBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp3_;
	gchar** _tmp4_;
	int _tmp4__length;
	int _tmp4__size;
	int _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	g_variant_iter_init (&_tmp5_, _tmp3_);
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
		}
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
	}
	_result_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	_result = _tmp4_;
	g_variant_unref (_tmp3_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void budgie_dbus_impl_proxy_budgie_dbus_impl_interface_init (BudgieDBusImplIface* iface) {
	iface->list_names = budgie_dbus_impl_proxy_list_names_async;
	iface->list_names_finish = budgie_dbus_impl_proxy_list_names_finish;
}


static void _dbus_budgie_dbus_impl_list_names (BudgieDBusImpl* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_dbus_impl_list_names (self, (GAsyncReadyCallback) _dbus_budgie_dbus_impl_list_names_ready, invocation);
}


static void _dbus_budgie_dbus_impl_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	invocation = _user_data_;
	result = budgie_dbus_impl_list_names_finish ((BudgieDBusImpl*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("as"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		g_variant_builder_add_value (&_tmp8_, g_variant_new_string (*_tmp7_));
		_tmp7_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListNames") == 0) {
		_dbus_budgie_dbus_impl_list_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_budgie_dbus_impl_name_owner_changed (GObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


guint budgie_dbus_impl_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_dbus_impl_dbus_interface_info), &_budgie_dbus_impl_dbus_interface_vtable, data, _budgie_dbus_impl_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_budgie_dbus_impl_name_owner_changed, data);
	return result;
}


static void _budgie_dbus_impl_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_dbus_impl_name_owner_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BudgieAppLauncherButton* budgie_app_launcher_button_construct (GType object_type, GAppInfo* info) {
	BudgieAppLauncherButton * self = NULL;
	GAppInfo* _tmp0_ = NULL;
	GAppInfo* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkImage* image = NULL;
	GAppInfo* _tmp3_ = NULL;
	GIcon* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	gchar* nom = NULL;
	GAppInfo* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* sdesc = NULL;
	GAppInfo* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* desc = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GValue _tmp25_ = {0};
	GAppInfo* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	self = (BudgieAppLauncherButton*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, NULL);
	_tmp0_ = info;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->app_info);
	self->app_info = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp2_, "launcher-button");
	_tmp3_ = info;
	_tmp4_ = g_app_info_get_icon (_tmp3_);
	_tmp5_ = (GtkImage*) gtk_image_new_from_gicon (_tmp4_, GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp5_);
	image = _tmp5_;
	_tmp6_ = image;
	gtk_image_set_pixel_size (_tmp6_, 48);
	_tmp7_ = image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp7_, 8);
	_tmp8_ = image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = info;
	_tmp10_ = g_app_info_get_name (_tmp9_);
	_tmp11_ = g_markup_escape_text (_tmp10_, (gssize) -1);
	nom = _tmp11_;
	_tmp12_ = info;
	_tmp13_ = g_app_info_get_description (_tmp12_);
	_tmp14_ = g_strdup (_tmp13_);
	sdesc = _tmp14_;
	_tmp15_ = sdesc;
	if (_tmp15_ == NULL) {
		gchar* _tmp16_ = NULL;
		_tmp16_ = g_strdup ("");
		_g_free0 (sdesc);
		sdesc = _tmp16_;
	}
	_tmp17_ = sdesc;
	_tmp18_ = g_markup_escape_text (_tmp17_, (gssize) -1);
	desc = _tmp18_;
	_tmp19_ = nom;
	_tmp20_ = g_strdup_printf ("<big>%s</big>\n<small>%s</small>", _tmp19_, desc);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	label = _tmp23_;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) label);
	gtk_style_context_add_class (_tmp24_, "dim-label");
	gtk_label_set_line_wrap (label, TRUE);
	g_value_init (&_tmp25_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp25_, 0.0);
	g_object_set_property ((GObject*) label, "xalign", &_tmp25_);
	G_IS_VALUE (&_tmp25_) ? (g_value_unset (&_tmp25_), NULL) : NULL;
	gtk_label_set_use_markup (label, TRUE);
	gtk_widget_set_margin_start ((GtkWidget*) label, 12);
	gtk_label_set_max_width_chars (label, 60);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_widget_set_hexpand ((GtkWidget*) self, FALSE);
	gtk_widget_set_vexpand ((GtkWidget*) self, FALSE);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp26_ = info;
	_tmp27_ = g_app_info_get_name (_tmp26_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp27_);
	gtk_widget_set_margin_top ((GtkWidget*) self, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 3);
	_g_object_unref0 (label);
	_g_free0 (desc);
	_g_free0 (sdesc);
	_g_free0 (nom);
	_g_object_unref0 (image);
	return self;
}


BudgieAppLauncherButton* budgie_app_launcher_button_new (GAppInfo* info) {
	return budgie_app_launcher_button_construct (BUDGIE_TYPE_APP_LAUNCHER_BUTTON, info);
}


static void budgie_app_launcher_button_class_init (BudgieAppLauncherButtonClass * klass) {
	budgie_app_launcher_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_app_launcher_button_finalize;
}


static void budgie_app_launcher_button_instance_init (BudgieAppLauncherButton * self) {
	self->app_info = NULL;
}


static void budgie_app_launcher_button_finalize (GObject* obj) {
	BudgieAppLauncherButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APP_LAUNCHER_BUTTON, BudgieAppLauncherButton);
	_g_object_unref0 (self->app_info);
	G_OBJECT_CLASS (budgie_app_launcher_button_parent_class)->finalize (obj);
}


/**
 * Simple launcher button
 */
GType budgie_app_launcher_button_get_type (void) {
	static volatile gsize budgie_app_launcher_button_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_app_launcher_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieAppLauncherButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_app_launcher_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppLauncherButton), 0, (GInstanceInitFunc) budgie_app_launcher_button_instance_init, NULL };
		GType budgie_app_launcher_button_type_id;
		budgie_app_launcher_button_type_id = g_type_register_static (gtk_box_get_type (), "BudgieAppLauncherButton", &g_define_type_info, 0);
		g_once_init_leave (&budgie_app_launcher_button_type_id__volatile, budgie_app_launcher_button_type_id);
	}
	return budgie_app_launcher_button_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _budgie_run_dialog_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender, GAppInfo* info, GVariant* platform_data, gpointer self) {
	budgie_run_dialog_on_launched ((BudgieRunDialog*) self, info, platform_data);
}


static void _budgie_run_dialog_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender, const gchar* startup_notify_id, gpointer self) {
	budgie_run_dialog_on_launch_failed ((BudgieRunDialog*) self, startup_notify_id);
}


static gboolean _budgie_run_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = budgie_run_dialog_on_key_release ((BudgieRunDialog*) self, event);
	return result;
}


static void _budgie_run_dialog_on_search_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	budgie_run_dialog_on_search_changed ((BudgieRunDialog*) self);
}


static void _budgie_run_dialog_on_search_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	budgie_run_dialog_on_search_activate ((BudgieRunDialog*) self);
}


static void _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	budgie_run_dialog_on_row_activate ((BudgieRunDialog*) self, row);
}


static gboolean _budgie_run_dialog_on_filter_gtk_list_box_filter_func (GtkListBoxRow* row, gpointer self) {
	gboolean result;
	result = budgie_run_dialog_on_filter ((BudgieRunDialog*) self, row);
	return result;
}


static gboolean __lambda5_ (BudgieRunDialog* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkApplication* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	_tmp0_ = self->priv->focus_quit;
	if (!_tmp0_) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp1_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	g_application_quit ((GApplication*) _tmp2_);
	result = GDK_EVENT_STOP;
	return result;
}


static gboolean ___lambda5__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda5_ ((BudgieRunDialog*) self);
	return result;
}


BudgieRunDialog* budgie_run_dialog_construct (GType object_type, GtkApplication* app) {
	BudgieRunDialog * self = NULL;
	GtkApplication* _tmp0_ = NULL;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkVisual* _tmp3_ = NULL;
	GdkVisual* _tmp4_ = NULL;
	GdkVisual* _tmp5_ = NULL;
	GHashFunc _tmp7_ = NULL;
	GEqualFunc _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	GdkDisplay* _tmp10_ = NULL;
	GdkAppLaunchContext* _tmp11_ = NULL;
	GdkAppLaunchContext* _tmp12_ = NULL;
	GdkAppLaunchContext* _tmp13_ = NULL;
	BudgieThemeManager* _tmp14_ = NULL;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp15_ = NULL;
	GtkStyleContext* _tmp16_ = NULL;
	GtkStyleContext* _tmp17_ = NULL;
	GtkBox* main_layout = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp19_ = NULL;
	GtkSearchEntry* _tmp20_ = NULL;
	GtkSearchEntry* _tmp21_ = NULL;
	GtkSearchEntry* _tmp22_ = NULL;
	GtkSearchEntry* _tmp23_ = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GtkSearchEntry* _tmp25_ = NULL;
	GtkRevealer* _tmp26_ = NULL;
	GtkRevealer* _tmp27_ = NULL;
	GtkListBox* _tmp28_ = NULL;
	GtkListBox* _tmp29_ = NULL;
	GtkListBox* _tmp30_ = NULL;
	GtkListBox* _tmp31_ = NULL;
	GtkListBox* _tmp32_ = NULL;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp33_ = NULL;
	GtkStyleContext* _tmp34_ = NULL;
	GtkListBox* _tmp35_ = NULL;
	GtkRevealer* _tmp36_ = NULL;
	GtkRevealer* _tmp37_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = app;
	self = (BudgieRunDialog*) g_object_new (object_type, "application", _tmp0_, NULL);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_screen_get_rgba_visual (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	visual = _tmp4_;
	_tmp5_ = visual;
	if (_tmp5_ != NULL) {
		GdkVisual* _tmp6_ = NULL;
		_tmp6_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp6_);
	}
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->active_names);
	self->priv->active_names = _tmp9_;
	_tmp10_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp11_ = gdk_display_get_app_launch_context (_tmp10_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp11_;
	_tmp12_ = self->priv->context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp12_, "launched", (GCallback) _budgie_run_dialog_on_launched_g_app_launch_context_launched, self, 0);
	_tmp13_ = self->priv->context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp13_, "launch-failed", (GCallback) _budgie_run_dialog_on_launch_failed_g_app_launch_context_launch_failed, self, 0);
	_tmp14_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp14_;
	_tmp15_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp15_);
	header = _tmp15_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_remove_class (_tmp16_, "titlebar");
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp17_, "budgie-run-dialog");
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _budgie_run_dialog_on_key_release_gtk_widget_key_release_event, self, 0);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp18_);
	main_layout = _tmp18_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_layout);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp19_);
	hbox = _tmp19_;
	gtk_box_pack_start (main_layout, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp20_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp20_;
	_tmp21_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp21_, "changed", (GCallback) _budgie_run_dialog_on_search_changed_gtk_editable_changed, self, 0);
	_tmp22_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp22_, "activate", (GCallback) _budgie_run_dialog_on_search_activate_gtk_entry_activate, self, 0);
	_tmp23_ = self->priv->entry;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_set_junction_sides (_tmp24_, GTK_JUNCTION_BOTTOM);
	_tmp25_ = self->priv->entry;
	gtk_box_pack_start (hbox, (GtkWidget*) _tmp25_, TRUE, TRUE, (guint) 0);
	_tmp26_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->bottom_revealer);
	self->priv->bottom_revealer = _tmp26_;
	_tmp27_ = self->priv->bottom_revealer;
	gtk_box_pack_start (main_layout, (GtkWidget*) _tmp27_, TRUE, TRUE, (guint) 0);
	_tmp28_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->app_box);
	self->priv->app_box = _tmp28_;
	_tmp29_ = self->priv->app_box;
	gtk_list_box_set_selection_mode (_tmp29_, GTK_SELECTION_SINGLE);
	_tmp30_ = self->priv->app_box;
	gtk_list_box_set_activate_on_single_click (_tmp30_, TRUE);
	_tmp31_ = self->priv->app_box;
	g_signal_connect_object (_tmp31_, "row-activated", (GCallback) _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp32_ = self->priv->app_box;
	gtk_list_box_set_filter_func (_tmp32_, _budgie_run_dialog_on_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp33_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp33_);
	scroll = _tmp33_;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) scroll);
	gtk_style_context_set_junction_sides (_tmp34_, GTK_JUNCTION_TOP);
	gtk_widget_set_size_request ((GtkWidget*) scroll, -1, 300);
	_tmp35_ = self->priv->app_box;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp35_);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp36_ = self->priv->bottom_revealer;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) scroll);
	_tmp37_ = self->priv->bottom_revealer;
	gtk_revealer_set_reveal_child (_tmp37_, FALSE);
	budgie_run_dialog_build_app_box (self);
	gtk_widget_set_size_request ((GtkWidget*) self, 240, -1);
	gtk_widget_show_all ((GtkWidget*) main_layout);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda5__gtk_widget_focus_out_event, self, 0);
	budgie_run_dialog_setup_dbus (self, NULL, NULL);
	_g_object_unref0 (scroll);
	_g_object_unref0 (hbox);
	_g_object_unref0 (main_layout);
	_g_object_unref0 (header);
	_g_object_unref0 (visual);
	return self;
}


BudgieRunDialog* budgie_run_dialog_new (GtkApplication* app) {
	return budgie_run_dialog_construct (BUDGIE_TYPE_RUN_DIALOG, app);
}


/**
     * Handle click/<enter> activation on the main list
     */
static void budgie_run_dialog_on_row_activate (BudgieRunDialog* self, GtkListBoxRow* row) {
	BudgieAppLauncherButton* child = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	BudgieAppLauncherButton* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = row;
	_tmp1_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp0_) : NULL);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BUDGIE_TYPE_APP_LAUNCHER_BUTTON) ? ((BudgieAppLauncherButton*) _tmp1_) : NULL);
	child = _tmp2_;
	budgie_run_dialog_launch_button (self, child);
	_g_object_unref0 (child);
}


/**
     * Handle <enter> activation on the search
     */
static void budgie_run_dialog_on_search_activate (BudgieRunDialog* self) {
	BudgieAppLauncherButton* act = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	BudgieAppLauncherButton* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	act = NULL;
	_tmp0_ = self->priv->app_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				gboolean _tmp2_ = FALSE;
				GtkWidget* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = row;
				_tmp4_ = gtk_widget_get_visible (_tmp3_);
				if (_tmp4_) {
					GtkWidget* _tmp5_ = NULL;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = row;
					_tmp6_ = gtk_widget_get_child_visible (_tmp5_);
					_tmp2_ = _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GtkWidget* _tmp7_ = NULL;
					GtkWidget* _tmp8_ = NULL;
					BudgieAppLauncherButton* _tmp9_ = NULL;
					_tmp7_ = row;
					_tmp8_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_bin_get_type ()) ? ((GtkBin*) _tmp7_) : NULL);
					_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, BUDGIE_TYPE_APP_LAUNCHER_BUTTON) ? ((BudgieAppLauncherButton*) _tmp8_) : NULL);
					_g_object_unref0 (act);
					act = _tmp9_;
					break;
				}
			}
		}
		_g_list_free0 (row_collection);
	}
	_tmp10_ = act;
	if (_tmp10_ != NULL) {
		BudgieAppLauncherButton* _tmp11_ = NULL;
		_tmp11_ = act;
		budgie_run_dialog_launch_button (self, _tmp11_);
	}
	_g_object_unref0 (act);
}


/**
     * Launch the given preconfigured button
     */
static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void budgie_run_dialog_launch_button (BudgieRunDialog* self, BudgieAppLauncherButton* button) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GDesktopAppInfo* dinfo = NULL;
		BudgieAppLauncherButton* _tmp0_ = NULL;
		GAppInfo* _tmp1_ = NULL;
		GDesktopAppInfo* _tmp2_ = NULL;
		GdkAppLaunchContext* _tmp3_ = NULL;
		GdkScreen* _tmp4_ = NULL;
		GdkAppLaunchContext* _tmp5_ = NULL;
		gchar** splits = NULL;
		GDesktopAppInfo* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint splits_length1 = 0;
		gint _splits_size_ = 0;
		GDesktopAppInfo* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GDesktopAppInfo* _tmp15_ = NULL;
		GdkAppLaunchContext* _tmp16_ = NULL;
		_tmp0_ = button;
		_tmp1_ = _tmp0_->app_info;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp1_) : NULL);
		dinfo = _tmp2_;
		_tmp3_ = self->priv->context;
		_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
		gdk_app_launch_context_set_screen (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->context;
		gdk_app_launch_context_set_timestamp (_tmp5_, (guint32) GDK_CURRENT_TIME);
		self->priv->focus_quit = FALSE;
		_tmp6_ = dinfo;
		_tmp7_ = g_app_info_get_id ((GAppInfo*) _tmp6_);
		_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ".desktop", 0);
		splits = _tmp9_;
		splits_length1 = _vala_array_length (_tmp8_);
		_splits_size_ = splits_length1;
		_tmp10_ = dinfo;
		_tmp11_ = g_desktop_app_info_get_boolean (_tmp10_, "DBusActivatable");
		if (_tmp11_) {
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gchar* _tmp14_ = NULL;
			_tmp12_ = splits;
			_tmp12__length1 = splits_length1;
			_tmp13_ = splits;
			_tmp13__length1 = splits_length1;
			_tmp14_ = _vala_g_strjoinv (".desktop", _tmp12_ + 0, (_tmp13__length1 - 1) - 0);
			_g_free0 (self->priv->wanted_dbus_id);
			self->priv->wanted_dbus_id = _tmp14_;
		}
		_tmp15_ = dinfo;
		_tmp16_ = self->priv->context;
		g_app_info_launch ((GAppInfo*) _tmp15_, NULL, (GAppLaunchContext*) _tmp16_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			splits = (_vala_array_free (splits, splits_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (dinfo);
			goto __catch0_g_error;
		}
		budgie_run_dialog_check_dbus_name (self);
		gtk_widget_hide ((GtkWidget*) self);
		splits = (_vala_array_free (splits, splits_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (dinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkApplication* _tmp17_ = NULL;
		GtkApplication* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp18_ = _tmp17_;
		g_application_quit ((GApplication*) _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void budgie_run_dialog_on_search_changed (BudgieRunDialog* self) {
	GtkSearchEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkWidget* active_row = NULL;
	GtkListBox* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
	_g_free0 (self->priv->search_text);
	self->priv->search_text = _tmp2_;
	_tmp3_ = self->priv->app_box;
	gtk_list_box_invalidate_filter (_tmp3_);
	active_row = NULL;
	_tmp4_ = self->priv->app_box;
	_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp5_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				gboolean _tmp6_ = FALSE;
				GtkWidget* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp7_ = row;
				_tmp8_ = gtk_widget_get_visible (_tmp7_);
				if (_tmp8_) {
					GtkWidget* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = row;
					_tmp10_ = gtk_widget_get_child_visible (_tmp9_);
					_tmp6_ = _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GtkWidget* _tmp11_ = NULL;
					GtkWidget* _tmp12_ = NULL;
					_tmp11_ = row;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					_g_object_unref0 (active_row);
					active_row = _tmp12_;
					break;
				}
			}
		}
		_g_list_free0 (row_collection);
	}
	_tmp13_ = active_row;
	if (_tmp13_ == NULL) {
		GtkRevealer* _tmp14_ = NULL;
		GtkRevealer* _tmp15_ = NULL;
		_tmp14_ = self->priv->bottom_revealer;
		gtk_revealer_set_transition_type (_tmp14_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
		_tmp15_ = self->priv->bottom_revealer;
		gtk_revealer_set_reveal_child (_tmp15_, FALSE);
	} else {
		GtkRevealer* _tmp16_ = NULL;
		GtkRevealer* _tmp17_ = NULL;
		GtkListBox* _tmp18_ = NULL;
		GtkWidget* _tmp19_ = NULL;
		_tmp16_ = self->priv->bottom_revealer;
		gtk_revealer_set_transition_type (_tmp16_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		_tmp17_ = self->priv->bottom_revealer;
		gtk_revealer_set_reveal_child (_tmp17_, TRUE);
		_tmp18_ = self->priv->app_box;
		_tmp19_ = active_row;
		gtk_list_box_select_row (_tmp18_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp19_) : NULL);
	}
	_g_object_unref0 (active_row);
}


/**
     * Filter the list
     */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean budgie_run_dialog_on_filter (BudgieRunDialog* self, GtkListBoxRow* row) {
	gboolean result = FALSE;
	BudgieAppLauncherButton* button = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	BudgieAppLauncherButton* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* app_name = NULL;
	gchar* desc = NULL;
	gchar* name = NULL;
	gchar* exec = NULL;
	BudgieAppLauncherButton* _tmp4_ = NULL;
	GAppInfo* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	BudgieAppLauncherButton* _tmp12_ = NULL;
	GAppInfo* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	BudgieAppLauncherButton* _tmp20_ = NULL;
	GAppInfo* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	BudgieAppLauncherButton* _tmp28_ = NULL;
	GAppInfo* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = row;
	_tmp1_ = gtk_bin_get_child ((GtkBin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BUDGIE_TYPE_APP_LAUNCHER_BUTTON) ? ((BudgieAppLauncherButton*) _tmp1_) : NULL);
	button = _tmp2_;
	_tmp3_ = self->priv->search_text;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = FALSE;
		_g_object_unref0 (button);
		return result;
	}
	_tmp4_ = button;
	_tmp5_ = _tmp4_->app_info;
	_tmp6_ = g_app_info_get_display_name (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (app_name);
	app_name = _tmp7_;
	_tmp8_ = app_name;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = app_name;
		_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
		_g_free0 (app_name);
		app_name = _tmp10_;
	} else {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("");
		_g_free0 (app_name);
		app_name = _tmp11_;
	}
	_tmp12_ = button;
	_tmp13_ = _tmp12_->app_info;
	_tmp14_ = g_app_info_get_description (_tmp13_);
	_tmp15_ = g_strdup (_tmp14_);
	_g_free0 (desc);
	desc = _tmp15_;
	_tmp16_ = desc;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp17_ = desc;
		_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) -1);
		_g_free0 (desc);
		desc = _tmp18_;
	} else {
		gchar* _tmp19_ = NULL;
		_tmp19_ = g_strdup ("");
		_g_free0 (desc);
		desc = _tmp19_;
	}
	_tmp20_ = button;
	_tmp21_ = _tmp20_->app_info;
	_tmp22_ = g_app_info_get_name (_tmp21_);
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (name);
	name = _tmp23_;
	_tmp24_ = name;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		_tmp25_ = name;
		_tmp26_ = g_utf8_strdown (_tmp25_, (gssize) -1);
		_g_free0 (name);
		name = _tmp26_;
	} else {
		gchar* _tmp27_ = NULL;
		_tmp27_ = g_strdup ("");
		_g_free0 (name);
		name = _tmp27_;
	}
	_tmp28_ = button;
	_tmp29_ = _tmp28_->app_info;
	_tmp30_ = g_app_info_get_executable (_tmp29_);
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (exec);
	exec = _tmp31_;
	_tmp32_ = exec;
	if (_tmp32_ != NULL) {
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		_tmp33_ = exec;
		_tmp34_ = g_utf8_strdown (_tmp33_, (gssize) -1);
		_g_free0 (exec);
		exec = _tmp34_;
	} else {
		gchar* _tmp35_ = NULL;
		_tmp35_ = g_strdup ("");
		_g_free0 (exec);
		exec = _tmp35_;
	}
	_tmp39_ = app_name;
	_tmp40_ = self->priv->search_text;
	_tmp41_ = string_contains (_tmp39_, _tmp40_);
	if (_tmp41_) {
		_tmp38_ = TRUE;
	} else {
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		_tmp42_ = desc;
		_tmp43_ = self->priv->search_text;
		_tmp44_ = string_contains (_tmp42_, _tmp43_);
		_tmp38_ = _tmp44_;
	}
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
		_tmp45_ = name;
		_tmp46_ = self->priv->search_text;
		_tmp47_ = string_contains (_tmp45_, _tmp46_);
		_tmp37_ = _tmp47_;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		const gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		gboolean _tmp50_ = FALSE;
		_tmp48_ = exec;
		_tmp49_ = self->priv->search_text;
		_tmp50_ = string_contains (_tmp48_, _tmp49_);
		_tmp36_ = _tmp50_;
	}
	result = _tmp36_;
	_g_free0 (exec);
	_g_free0 (name);
	_g_free0 (desc);
	_g_free0 (app_name);
	_g_object_unref0 (button);
	return result;
}


/**
     * Build the app box in the background
     */
static void _budgie_run_dialog_add_application_gfunc (gconstpointer data, gpointer self) {
	budgie_run_dialog_add_application ((BudgieRunDialog*) self, (GAppInfo*) data);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void budgie_run_dialog_build_app_box (BudgieRunDialog* self) {
	GList* apps = NULL;
	GList* _tmp0_ = NULL;
	GtkListBox* _tmp1_ = NULL;
	GtkSearchEntry* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_app_info_get_all ();
	apps = _tmp0_;
	g_list_foreach (apps, _budgie_run_dialog_add_application_gfunc, self);
	_tmp1_ = self->priv->app_box;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->entry;
	gtk_entry_set_text ((GtkEntry*) _tmp2_, "");
	__g_list_free__g_object_unref0_0 (apps);
}


static void budgie_run_dialog_add_application (BudgieRunDialog* self, GAppInfo* app_info) {
	GAppInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	BudgieAppLauncherButton* button = NULL;
	GAppInfo* _tmp2_ = NULL;
	BudgieAppLauncherButton* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	BudgieAppLauncherButton* _tmp5_ = NULL;
	BudgieAppLauncherButton* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_info;
	_tmp1_ = g_app_info_should_show (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = app_info;
	_tmp3_ = budgie_app_launcher_button_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	button = _tmp3_;
	_tmp4_ = self->priv->app_box;
	_tmp5_ = button;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = button;
	gtk_widget_show_all ((GtkWidget*) _tmp6_);
	_g_object_unref0 (button);
}


/**
     * Be a good citizen and pretend to be a dialog.
     */
static gboolean ___lambda4_ (BudgieRunDialog* self) {
	gboolean result = FALSE;
	GtkApplication* _tmp0_ = NULL;
	GtkApplication* _tmp1_ = NULL;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
	result = FALSE;
	return result;
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((BudgieRunDialog*) self);
	return result;
}


static gboolean budgie_run_dialog_on_key_release (BudgieRunDialog* self, GdkEventKey* btn) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (btn != NULL, FALSE);
	_tmp0_ = btn;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ == ((guint) GDK_KEY_Escape)) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


/**
     * Handle startup notification, mark it done, quit
     * We may not get the ID but we'll be told it's launched
     */
static void budgie_run_dialog_on_launched (BudgieRunDialog* self, GAppInfo* info, GVariant* v) {
	GVariant* elem = NULL;
	GVariantIter* iter = NULL;
	GVariant* _tmp0_ = NULL;
	GVariantIter* _tmp1_ = NULL;
	GtkApplication* _tmp14_ = NULL;
	GtkApplication* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_iter_new (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GVariantIter* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		GVariant* _tmp4_ = NULL;
		gchar* key = NULL;
		GVariant* val = NULL;
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GVariant* _tmp7_ = NULL;
		const GVariantType* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_ = NULL;
		GdkDisplay* _tmp11_ = NULL;
		GVariant* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = g_variant_iter_next_value (_tmp2_);
		_g_variant_unref0 (elem);
		elem = _tmp3_;
		_tmp4_ = elem;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		key = NULL;
		val = NULL;
		_tmp5_ = elem;
		g_variant_get (_tmp5_, "{sv}", &key, &val, NULL);
		_tmp6_ = key;
		if (_tmp6_ == NULL) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp7_ = val;
		_tmp8_ = G_VARIANT_TYPE_STRING;
		_tmp9_ = g_variant_is_of_type (_tmp7_, _tmp8_);
		if (!_tmp9_) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp10_ = key;
		if (g_strcmp0 (_tmp10_, "startup-notification-id") != 0) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp11_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp12_ = val;
		_tmp13_ = g_variant_get_string (_tmp12_, NULL);
		gdk_display_notify_startup_complete (_tmp11_, _tmp13_);
		_g_variant_unref0 (val);
		_g_free0 (key);
	}
	_tmp14_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp15_ = _tmp14_;
	g_application_quit ((GApplication*) _tmp15_);
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (elem);
}


/**
     * Set the ID if it exists, quit regardless
     */
static void budgie_run_dialog_on_launch_failed (BudgieRunDialog* self, const gchar* id) {
	GdkDisplay* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkApplication* _tmp2_ = NULL;
	GtkApplication* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = id;
	gdk_display_notify_startup_complete (_tmp0_, _tmp1_);
	_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp3_ = _tmp2_;
	g_application_quit ((GApplication*) _tmp3_);
}


static void budgie_run_dialog_on_name_owner_changed (BudgieRunDialog* self, const gchar* n, const gchar* o, const gchar* ne) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = o;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		GHashTable* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->priv->active_names;
		_tmp2_ = n;
		_tmp3_ = g_strdup (_tmp2_);
		g_hash_table_insert (_tmp1_, _tmp3_, (gpointer) ((gintptr) TRUE));
		budgie_run_dialog_check_dbus_name (self);
	} else {
		GHashTable* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->active_names;
		_tmp5_ = n;
		_tmp6_ = g_hash_table_contains (_tmp4_, _tmp5_);
		if (_tmp6_) {
			GHashTable* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = self->priv->active_names;
			_tmp8_ = n;
			g_hash_table_remove (_tmp7_, _tmp8_);
		}
	}
}


/**
     * Check if our dbus name appeared. if it did, bugger off.
     */
static void budgie_run_dialog_check_dbus_name (BudgieRunDialog* self) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->wanted_dbus_id;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GHashTable* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->active_names;
		_tmp3_ = self->priv->wanted_dbus_id;
		_tmp4_ = g_hash_table_contains (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkApplication* _tmp5_ = NULL;
		GtkApplication* _tmp6_ = NULL;
		_tmp5_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp6_ = _tmp5_;
		g_application_quit ((GApplication*) _tmp6_);
	}
}


static void budgie_run_dialog_setup_dbus_data_free (gpointer _data) {
	BudgieRunDialogSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieRunDialogSetupDbusData, _data_);
}


void budgie_run_dialog_setup_dbus (BudgieRunDialog* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BudgieRunDialogSetupDbusData* _data_;
	BudgieRunDialog* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BudgieRunDialogSetupDbusData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, budgie_run_dialog_setup_dbus);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, budgie_run_dialog_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_run_dialog_setup_dbus_co (_data_);
}


void budgie_run_dialog_setup_dbus_finish (BudgieRunDialog* self, GAsyncResult* _res_) {
	BudgieRunDialogSetupDbusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Do basic dbus initialisation
     */
static void budgie_run_dialog_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BudgieRunDialogSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_run_dialog_setup_dbus_co (_data_);
}


static void _budgie_run_dialog_on_name_owner_changed_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self) {
	budgie_run_dialog_on_name_owner_changed ((BudgieRunDialog*) self, name, old_owner, new_owner);
}


static gboolean budgie_run_dialog_setup_dbus_co (BudgieRunDialogSetupDbusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (BUDGIE_TYPE_DBUS_IMPL_PROXY, 0, NULL, budgie_run_dialog_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", "g-interface-info", g_type_get_qdata (BUDGIE_TYPE_DBUS_IMPL, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = (BudgieDBusImpl*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->impl);
		_data_->self->priv->impl = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->impl;
		_data_->_tmp5_ = 0;
		_data_->_state_ = 2;
		budgie_dbus_impl_list_names (_data_->_tmp4_, budgie_run_dialog_setup_dbus_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = budgie_dbus_impl_list_names_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
		_data_->_tmp3__length1 = 0;
		_data_->__tmp3__size_ = 0;
		_data_->_tmp3_ = _data_->_tmp6_;
		_data_->_tmp3__length1 = _data_->_tmp5_;
		_data_->__tmp3__size_ = _data_->_tmp3__length1;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch1_g_error;
		}
		_data_->_tmp7_ = NULL;
		_data_->_tmp7__length1 = 0;
		_data_->_tmp7_ = _data_->_tmp3_;
		_data_->_tmp7__length1 = _data_->_tmp3__length1;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3__length1 = 0;
		{
			_data_->name_collection_length1 = 0;
			_data_->_name_collection_size_ = 0;
			_data_->name_collection = _data_->_tmp7_;
			_data_->name_collection_length1 = _data_->_tmp7__length1;
			for (_data_->name_it = 0; _data_->name_it < _data_->_tmp7__length1; _data_->name_it = _data_->name_it + 1) {
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = g_strdup (_data_->name_collection[_data_->name_it]);
				_data_->name = _data_->_tmp8_;
				{
					_data_->_tmp9_ = NULL;
					_data_->_tmp9_ = _data_->self->priv->active_names;
					_data_->_tmp10_ = NULL;
					_data_->_tmp10_ = _data_->name;
					_data_->_tmp11_ = NULL;
					_data_->_tmp11_ = g_strdup (_data_->_tmp10_);
					g_hash_table_insert (_data_->_tmp9_, _data_->_tmp11_, (gpointer) ((gintptr) TRUE));
					_g_free0 (_data_->name);
				}
			}
			_data_->name_collection = (_vala_array_free (_data_->name_collection, _data_->name_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->self->priv->impl;
		g_signal_connect_object (_data_->_tmp12_, "name-owner-changed", (GCallback) _budgie_run_dialog_on_name_owner_changed_budgie_dbus_impl_name_owner_changed, _data_->self, 0);
		_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("RunDialog.vala:397: Failed to initialise dbus: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void budgie_run_dialog_class_init (BudgieRunDialogClass * klass) {
	budgie_run_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieRunDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_run_dialog_finalize;
}


static void budgie_run_dialog_instance_init (BudgieRunDialog * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self->priv = BUDGIE_RUN_DIALOG_GET_PRIVATE (self);
	self->priv->focus_quit = TRUE;
	self->priv->impl = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->search_text = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->wanted_dbus_id = _tmp1_;
	self->priv->active_names = NULL;
}


static void budgie_run_dialog_finalize (GObject* obj) {
	BudgieRunDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog);
	_g_object_unref0 (self->priv->bottom_revealer);
	_g_object_unref0 (self->priv->app_box);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->theme_manager);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->impl);
	_g_free0 (self->priv->search_text);
	_g_free0 (self->priv->wanted_dbus_id);
	_g_hash_table_unref0 (self->priv->active_names);
	G_OBJECT_CLASS (budgie_run_dialog_parent_class)->finalize (obj);
}


/**
 * The meat of the operation
 */
GType budgie_run_dialog_get_type (void) {
	static volatile gsize budgie_run_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_run_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieRunDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_run_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRunDialog), 0, (GInstanceInitFunc) budgie_run_dialog_instance_init, NULL };
		GType budgie_run_dialog_type_id;
		budgie_run_dialog_type_id = g_type_register_static (gtk_application_window_get_type (), "BudgieRunDialog", &g_define_type_info, 0);
		g_once_init_leave (&budgie_run_dialog_type_id__volatile, budgie_run_dialog_type_id);
	}
	return budgie_run_dialog_type_id__volatile;
}


BudgieRunDialogApp* budgie_run_dialog_app_construct (GType object_type) {
	BudgieRunDialogApp * self = NULL;
	self = (BudgieRunDialogApp*) g_object_new (object_type, "application-id", "com.solus_project.BudgieRunDialog", "flags", 0, NULL);
	return self;
}


BudgieRunDialogApp* budgie_run_dialog_app_new (void) {
	return budgie_run_dialog_app_construct (BUDGIE_TYPE_RUN_DIALOG_APP);
}


static void budgie_run_dialog_app_real_activate (GApplication* base) {
	BudgieRunDialogApp * self;
	BudgieRunDialog* _tmp0_ = NULL;
	BudgieRunDialog* _tmp2_ = NULL;
	self = (BudgieRunDialogApp*) base;
	_tmp0_ = self->priv->rd;
	if (_tmp0_ == NULL) {
		BudgieRunDialog* _tmp1_ = NULL;
		_tmp1_ = budgie_run_dialog_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->rd);
		self->priv->rd = _tmp1_;
	}
	_tmp2_ = self->priv->rd;
	gtk_window_present ((GtkWindow*) _tmp2_);
}


static void budgie_run_dialog_app_class_init (BudgieRunDialogAppClass * klass) {
	budgie_run_dialog_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieRunDialogAppPrivate));
	((GApplicationClass *) klass)->activate = budgie_run_dialog_app_real_activate;
	G_OBJECT_CLASS (klass)->finalize = budgie_run_dialog_app_finalize;
}


static void budgie_run_dialog_app_instance_init (BudgieRunDialogApp * self) {
	self->priv = BUDGIE_RUN_DIALOG_APP_GET_PRIVATE (self);
	self->priv->rd = NULL;
}


static void budgie_run_dialog_app_finalize (GObject* obj) {
	BudgieRunDialogApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogApp);
	_g_object_unref0 (self->priv->rd);
	G_OBJECT_CLASS (budgie_run_dialog_app_parent_class)->finalize (obj);
}


/**
 * GtkApplication for single instance wonderness
 */
GType budgie_run_dialog_app_get_type (void) {
	static volatile gsize budgie_run_dialog_app_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_run_dialog_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieRunDialogAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_run_dialog_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRunDialogApp), 0, (GInstanceInitFunc) budgie_run_dialog_app_instance_init, NULL };
		GType budgie_run_dialog_app_type_id;
		budgie_run_dialog_app_type_id = g_type_register_static (gtk_application_get_type (), "BudgieRunDialogApp", &g_define_type_info, 0);
		g_once_init_leave (&budgie_run_dialog_app_type_id__volatile, budgie_run_dialog_app_type_id);
	}
	return budgie_run_dialog_app_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	BudgieRunDialogApp* rd = NULL;
	BudgieRunDialogApp* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (BUDGIE_GETTEXT_PACKAGE, BUDGIE_LOCALEDIR);
	bind_textdomain_codeset (BUDGIE_GETTEXT_PACKAGE, "UTF-8");
	textdomain (BUDGIE_GETTEXT_PACKAGE);
	_tmp0_ = budgie_run_dialog_app_new ();
	rd = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) rd, _tmp1__length1, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (rd);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



