// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package storagegateway_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/storagegateway"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleStorageGateway_ActivateGateway() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ActivateGatewayInput{
		ActivationKey:     aws.String("ActivationKey"),   // Required
		GatewayName:       aws.String("GatewayName"),     // Required
		GatewayRegion:     aws.String("RegionId"),        // Required
		GatewayTimezone:   aws.String("GatewayTimezone"), // Required
		GatewayType:       aws.String("GatewayType"),
		MediumChangerType: aws.String("MediumChangerType"),
		TapeDriveType:     aws.String("TapeDriveType"),
	}
	resp, err := svc.ActivateGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_AddCache() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.AddCacheInput{
		DiskIds: []*string{ // Required
			aws.String("DiskId"), // Required
			// More values...
		},
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.AddCache(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_AddTagsToResource() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.AddTagsToResourceInput{
		ResourceARN: aws.String("ResourceARN"), // Required
		Tags: []*storagegateway.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"),   // Required
				Value: aws.String("TagValue"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.AddTagsToResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_AddUploadBuffer() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.AddUploadBufferInput{
		DiskIds: []*string{ // Required
			aws.String("DiskId"), // Required
			// More values...
		},
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.AddUploadBuffer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_AddWorkingStorage() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.AddWorkingStorageInput{
		DiskIds: []*string{ // Required
			aws.String("DiskId"), // Required
			// More values...
		},
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.AddWorkingStorage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CancelArchival() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CancelArchivalInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		TapeARN:    aws.String("TapeARN"),    // Required
	}
	resp, err := svc.CancelArchival(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CancelRetrieval() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CancelRetrievalInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		TapeARN:    aws.String("TapeARN"),    // Required
	}
	resp, err := svc.CancelRetrieval(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CreateCachediSCSIVolume() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CreateCachediSCSIVolumeInput{
		ClientToken:        aws.String("ClientToken"),        // Required
		GatewayARN:         aws.String("GatewayARN"),         // Required
		NetworkInterfaceId: aws.String("NetworkInterfaceId"), // Required
		TargetName:         aws.String("TargetName"),         // Required
		VolumeSizeInBytes:  aws.Int64(1),                     // Required
		SnapshotId:         aws.String("SnapshotId"),
	}
	resp, err := svc.CreateCachediSCSIVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CreateSnapshot() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CreateSnapshotInput{
		SnapshotDescription: aws.String("SnapshotDescription"), // Required
		VolumeARN:           aws.String("VolumeARN"),           // Required
	}
	resp, err := svc.CreateSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CreateSnapshotFromVolumeRecoveryPoint() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CreateSnapshotFromVolumeRecoveryPointInput{
		SnapshotDescription: aws.String("SnapshotDescription"), // Required
		VolumeARN:           aws.String("VolumeARN"),           // Required
	}
	resp, err := svc.CreateSnapshotFromVolumeRecoveryPoint(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CreateStorediSCSIVolume() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CreateStorediSCSIVolumeInput{
		DiskId:               aws.String("DiskId"),             // Required
		GatewayARN:           aws.String("GatewayARN"),         // Required
		NetworkInterfaceId:   aws.String("NetworkInterfaceId"), // Required
		PreserveExistingData: aws.Bool(true),                   // Required
		TargetName:           aws.String("TargetName"),         // Required
		SnapshotId:           aws.String("SnapshotId"),
	}
	resp, err := svc.CreateStorediSCSIVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_CreateTapes() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.CreateTapesInput{
		ClientToken:       aws.String("ClientToken"),       // Required
		GatewayARN:        aws.String("GatewayARN"),        // Required
		NumTapesToCreate:  aws.Int64(1),                    // Required
		TapeBarcodePrefix: aws.String("TapeBarcodePrefix"), // Required
		TapeSizeInBytes:   aws.Int64(1),                    // Required
	}
	resp, err := svc.CreateTapes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteBandwidthRateLimit() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteBandwidthRateLimitInput{
		BandwidthType: aws.String("BandwidthType"), // Required
		GatewayARN:    aws.String("GatewayARN"),    // Required
	}
	resp, err := svc.DeleteBandwidthRateLimit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteChapCredentials() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteChapCredentialsInput{
		InitiatorName: aws.String("IqnName"),   // Required
		TargetARN:     aws.String("TargetARN"), // Required
	}
	resp, err := svc.DeleteChapCredentials(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteGateway() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteGatewayInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DeleteGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteSnapshotSchedule() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteSnapshotScheduleInput{
		VolumeARN: aws.String("VolumeARN"), // Required
	}
	resp, err := svc.DeleteSnapshotSchedule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteTape() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteTapeInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		TapeARN:    aws.String("TapeARN"),    // Required
	}
	resp, err := svc.DeleteTape(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteTapeArchive() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteTapeArchiveInput{
		TapeARN: aws.String("TapeARN"), // Required
	}
	resp, err := svc.DeleteTapeArchive(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DeleteVolume() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DeleteVolumeInput{
		VolumeARN: aws.String("VolumeARN"), // Required
	}
	resp, err := svc.DeleteVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeBandwidthRateLimit() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeBandwidthRateLimitInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DescribeBandwidthRateLimit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeCache() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeCacheInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DescribeCache(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeCachediSCSIVolumes() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeCachediSCSIVolumesInput{
		VolumeARNs: []*string{ // Required
			aws.String("VolumeARN"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeCachediSCSIVolumes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeChapCredentials() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeChapCredentialsInput{
		TargetARN: aws.String("TargetARN"), // Required
	}
	resp, err := svc.DescribeChapCredentials(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeGatewayInformation() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeGatewayInformationInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DescribeGatewayInformation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeMaintenanceStartTime() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeMaintenanceStartTimeInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DescribeMaintenanceStartTime(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeSnapshotSchedule() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeSnapshotScheduleInput{
		VolumeARN: aws.String("VolumeARN"), // Required
	}
	resp, err := svc.DescribeSnapshotSchedule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeStorediSCSIVolumes() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeStorediSCSIVolumesInput{
		VolumeARNs: []*string{ // Required
			aws.String("VolumeARN"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeStorediSCSIVolumes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeTapeArchives() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeTapeArchivesInput{
		Limit:  aws.Int64(1),
		Marker: aws.String("Marker"),
		TapeARNs: []*string{
			aws.String("TapeARN"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeTapeArchives(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeTapeRecoveryPoints() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeTapeRecoveryPointsInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		Limit:      aws.Int64(1),
		Marker:     aws.String("Marker"),
	}
	resp, err := svc.DescribeTapeRecoveryPoints(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeTapes() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeTapesInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		Limit:      aws.Int64(1),
		Marker:     aws.String("Marker"),
		TapeARNs: []*string{
			aws.String("TapeARN"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeTapes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeUploadBuffer() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeUploadBufferInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DescribeUploadBuffer(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeVTLDevices() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeVTLDevicesInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		Limit:      aws.Int64(1),
		Marker:     aws.String("Marker"),
		VTLDeviceARNs: []*string{
			aws.String("VTLDeviceARN"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVTLDevices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DescribeWorkingStorage() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DescribeWorkingStorageInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DescribeWorkingStorage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_DisableGateway() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.DisableGatewayInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.DisableGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ListGateways() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ListGatewaysInput{
		Limit:  aws.Int64(1),
		Marker: aws.String("Marker"),
	}
	resp, err := svc.ListGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ListLocalDisks() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ListLocalDisksInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.ListLocalDisks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ListTagsForResource() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ListTagsForResourceInput{
		Limit:       aws.Int64(1),
		Marker:      aws.String("Marker"),
		ResourceARN: aws.String("ResourceARN"),
	}
	resp, err := svc.ListTagsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ListVolumeInitiators() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ListVolumeInitiatorsInput{
		VolumeARN: aws.String("VolumeARN"), // Required
	}
	resp, err := svc.ListVolumeInitiators(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ListVolumeRecoveryPoints() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ListVolumeRecoveryPointsInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.ListVolumeRecoveryPoints(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ListVolumes() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ListVolumesInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		Limit:      aws.Int64(1),
		Marker:     aws.String("Marker"),
	}
	resp, err := svc.ListVolumes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_RemoveTagsFromResource() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.RemoveTagsFromResourceInput{
		ResourceARN: aws.String("ResourceARN"),
		TagKeys: []*string{
			aws.String("TagKey"), // Required
			// More values...
		},
	}
	resp, err := svc.RemoveTagsFromResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ResetCache() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ResetCacheInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.ResetCache(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_RetrieveTapeArchive() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.RetrieveTapeArchiveInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		TapeARN:    aws.String("TapeARN"),    // Required
	}
	resp, err := svc.RetrieveTapeArchive(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_RetrieveTapeRecoveryPoint() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.RetrieveTapeRecoveryPointInput{
		GatewayARN: aws.String("GatewayARN"), // Required
		TapeARN:    aws.String("TapeARN"),    // Required
	}
	resp, err := svc.RetrieveTapeRecoveryPoint(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_ShutdownGateway() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.ShutdownGatewayInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.ShutdownGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_StartGateway() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.StartGatewayInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.StartGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateBandwidthRateLimit() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateBandwidthRateLimitInput{
		GatewayARN:                           aws.String("GatewayARN"), // Required
		AverageDownloadRateLimitInBitsPerSec: aws.Int64(1),
		AverageUploadRateLimitInBitsPerSec:   aws.Int64(1),
	}
	resp, err := svc.UpdateBandwidthRateLimit(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateChapCredentials() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateChapCredentialsInput{
		InitiatorName:                 aws.String("IqnName"),    // Required
		SecretToAuthenticateInitiator: aws.String("ChapSecret"), // Required
		TargetARN:                     aws.String("TargetARN"),  // Required
		SecretToAuthenticateTarget:    aws.String("ChapSecret"),
	}
	resp, err := svc.UpdateChapCredentials(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateGatewayInformation() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateGatewayInformationInput{
		GatewayARN:      aws.String("GatewayARN"), // Required
		GatewayName:     aws.String("GatewayName"),
		GatewayTimezone: aws.String("GatewayTimezone"),
	}
	resp, err := svc.UpdateGatewayInformation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateGatewaySoftwareNow() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateGatewaySoftwareNowInput{
		GatewayARN: aws.String("GatewayARN"), // Required
	}
	resp, err := svc.UpdateGatewaySoftwareNow(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateMaintenanceStartTime() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateMaintenanceStartTimeInput{
		DayOfWeek:    aws.Int64(1),             // Required
		GatewayARN:   aws.String("GatewayARN"), // Required
		HourOfDay:    aws.Int64(1),             // Required
		MinuteOfHour: aws.Int64(1),             // Required
	}
	resp, err := svc.UpdateMaintenanceStartTime(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateSnapshotSchedule() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateSnapshotScheduleInput{
		RecurrenceInHours: aws.Int64(1),            // Required
		StartAt:           aws.Int64(1),            // Required
		VolumeARN:         aws.String("VolumeARN"), // Required
		Description:       aws.String("Description"),
	}
	resp, err := svc.UpdateSnapshotSchedule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleStorageGateway_UpdateVTLDeviceType() {
	svc := storagegateway.New(session.New())

	params := &storagegateway.UpdateVTLDeviceTypeInput{
		DeviceType:   aws.String("DeviceType"),   // Required
		VTLDeviceARN: aws.String("VTLDeviceARN"), // Required
	}
	resp, err := svc.UpdateVTLDeviceType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
