/******************************************************************************
 *                       ____    _    _____                                   *
 *                      / ___|  / \  |  ___|    C++                           *
 *                     | |     / _ \ | |_       Actor                         *
 *                     | |___ / ___ \|  _|      Framework                     *
 *                      \____/_/   \_|_|                                      *
 *                                                                            *
 * Copyright (C) 2011 - 2015                                                  *
 * Dominik Charousset <dominik.charousset (at) haw-hamburg.de>                *
 *                                                                            *
 * Distributed under the terms and conditions of the BSD 3-Clause License or  *
 * (at your option) under the terms and conditions of the Boost Software      *
 * License 1.0. See accompanying files LICENSE and LICENSE_ALTERNATIVE.       *
 *                                                                            *
 * If you did not receive a copy of the license files, see                    *
 * http://opensource.org/licenses/BSD-3-Clause and                            *
 * http://www.boost.org/LICENSE_1_0.txt.                                      *
 ******************************************************************************/

#ifndef CAF_TYPED_EVENT_BASED_ACTOR_HPP
#define CAF_TYPED_EVENT_BASED_ACTOR_HPP

#include "caf/replies_to.hpp"
#include "caf/local_actor.hpp"
#include "caf/typed_behavior.hpp"
#include "caf/abstract_event_based_actor.hpp"

#include "caf/mixin/sync_sender.hpp"

namespace caf {

/**
 * A cooperatively scheduled, event-based actor implementation with strong type
 * checking. This is the recommended base class for user-defined actors and is
 * used implicitly when spawning typed, functor-based actors without the
 * `blocking_api` flag.
 * @extends local_actor
 */
template <class... Sigs>
class typed_event_based_actor
    : public abstract_event_based_actor<typed_behavior<Sigs...>, true> {
 public:
  using signatures = detail::type_list<Sigs...>;

  using behavior_type = typed_behavior<Sigs...>;

  std::set<std::string> message_types() const override {
    return {Sigs::static_type_name()...};
  }

  void initialize() override {
    this->is_initialized(true);
    auto bhvr = make_behavior();
    CAF_LOG_DEBUG_IF(!bhvr, "make_behavior() did not return a behavior, "
                            << "has_behavior() = "
                            << std::boolalpha << this->has_behavior());
    if (bhvr) {
      // make_behavior() did return a behavior instead of using become()
      CAF_LOG_DEBUG("make_behavior() did return a valid behavior");
      this->do_become(std::move(bhvr.unbox()), true);
    }
  }

 protected:
  virtual behavior_type make_behavior() = 0;
};

} // namespace caf

#endif // CAF_TYPED_EVENT_BASED_ACTOR_HPP
