/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_INIT.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfg_initGetopt
su(bsystem): cmdline
ty(pe): L
sy(nopsis): 
sh(ort description): Initialize non-user-defined values
he(ader files): 
lo(ng description): Between the time the \subsys{cmdline} has been initialized and
	the first argument is retreived, the user can change certain
	configuration parameters, such as option characters. By default these
	parameters are initialized with \tok{NULL}. Before the first argument
	is retreived, any \tok{NULL} parameter is initialized with the
	appropriate default value, in order all parameters have a non-\tok{NULL}
	value afterwards.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_init.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include <portable.h>
#include "dynstr.h"
#include "environ.h"
#include "suppl.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_INIT.C 1.6 2001/02/27 01:28:03 ska Exp ska $";
#endif

void cfg_initGetopt(struct Cfg_Getopt * const optstru)
{
	static char buf[2] = "/";		/* normal switchar */
	static char slash[2] = "/";		/* unchangeble switchars */
	IREGS r;

#ifndef NDEBUG
	union {		/* probe the physical representation of NULL */
		void *qq_poi;
		byte qq_arr[sizeof(void *)];
	} q;
	int i;
#endif

	DBG_ENTER("cfg_initGetopt", Suppl_cmdline)

#ifndef NDEBUG
	q.qq_poi = 0;
	for(i = 0; i < sizeof(void *); ++i)
		assert(q.qq_arr[i] == 0);
#endif

	assert(optstru);

	chkHeap
	if(!C(_stk))
		C(_stk) = cfg_newStackItem();

	chkHeap
	if(!C(_ch)	/* default option character */
		/* 1. environment variable SWITCHAR */
	 && (C(_ch) = StrWord(env_dupvar(0, "SWITCHAR"))) == 0) {
		/* 2. DOS API or "/" */
		C(_ch) = buf;
		r.r_ax = 0x3700;		/* Get SWITCHAR */
		invokeDOS(aS(r));
		if((r.r_ax & 0xff) == 0)	/* success */
			buf[0] = (char)r.r_dx;
		/* else use the slash */
	}

	if(!C(_ioch) && strchr(C(_ch), '/'))	/* in-option optch */
		C(_ioch) = slash;

	if(!C(_iach))							/* in-argument optch */
		C(_iach) = C(_ioch);

	if(!C(_bool))							/* boolean signs */
		C(_bool) = "-+";

	if(!C(_quote))							/* quotes */
		C(_quote) = "\"";

	if(!C(_arg))							/* argument signs */
		C(_arg) = ":=";

	C(type) = CFG_NONE;

	chkHeap
	DBG_EXIT
}
