/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_GC.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgGetCounter
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Scan an option as counter
he(ader files): 
lo(ng description): Check if the current option applies to the counter
	type and perform the actions, if so.\par
	On success the value of \para{*num} has been changed according the
	specified action: increment, decrement, or assign number.
pr(erequistes): 
re(lated to): 
se(condary subsystems): 
va: 0: on success\item else: on failure
xr(ef): 
im(port): 
fi(le): cfg_gc.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <limits.h>
#include <portable.h>
#include "str.h"
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_GC.C 1.6 2001/02/27 01:28:02 ska Exp ska $";
#endif

int cfgGetCounter(struct Cfg_Getopt * const optstru, int * const num)
{	char *p;
	int n;

	DBG_ENTER("cfgGetCounter", Suppl_cmdline)

	assert(optstru);

	chkHeap
	switch(optArgType()) {
	case CFG_TERROR:
		DBG_RETURN_I( 1)		/* no argument at all */

	case CFG_TINTEGER:
		*num += optArgInteger();
		DBG_RETURN_I( 0)

	case CFG_TBOOLEAN:
		break;			/* Invalid type */

	default:			/* Unknown == string */
		if((p = singleword(optArgString())) == 0)
			DBG_RETURN_I( 2)		/* more than one word cannot be here */

		if(lookupwordi(p, cfgNamesIncrement)) {
			++*num;
			DBG_RETURN_I( 0)
		}

		if(lookupwordi(p, cfgNamesDecrement)) {
			--*num;
			DBG_RETURN_I( 0)
		}

		if(lookupwordi(p, cfgNamesOff)) {
			*num = 0;
			DBG_RETURN_I( 0)
		}

		if(lookupwordi(p, cfgNamesOn)) {
			*num = 1;
			DBG_RETURN_I( 0)
		}

		if(cfgGetSigned(optstru, &n, INT_MIN, INT_MAX, 10) == 0) {
			*num += n;
			DBG_RETURN_I( 0)
		}
	}

	DBG_RETURN_I( 3)		/* failed */
}
