# -*- coding: iso-8859-1 -*-

"""
ATSchemaEditorNG

(C) 2003,2004, Andreas Jung, ZOPYX Software Development and Consulting
and Contributors
D-72070 Tbingen, Germany

Contact: andreas@andreas-jung.com

License: see LICENSE.txt

$Id: ManagedSchema.py 8434 2005-05-10 00:55:53Z rafrombrc $
"""

from Globals import InitializeClass 
from AccessControl import ClassSecurityInfo

from Products.CMFCore import CMFCorePermissions
from Products.Archetypes.public import ManagedSchema

from config import ATSE_MANAGED_FULL, ATSE_MANAGED_NONE

class ManagedSchema(ManagedSchema):
    """ We wrap the ManagedSchema class in case we need something
        special.
    """

    security = ClassSecurityInfo()

    def _fieldIsUnmanaged(self, field):
        if getattr(field,
                   'atse_managed',
                   ATSE_MANAGED_FULL) == ATSE_MANAGED_NONE or \
                   field.schemata in self._filtered_schemas:
            return 1

    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
                              'insertFieldAfterFieldName')
    def addFieldAfterFieldName(self, fieldName, field):
        """ inserts a new field into the schema immediately after the
        field w/ name matching the fieldName argument """
        if not fieldName in self._names:
            raise KeyError, ('Field %s does not exist' % fieldName)
        else:
            self.addField(field)
            self._names.remove(field.getName())
            idx = self._names.index(fieldName)
            self._names = self._names[:idx+1] + [field.getName()] + \
                          self._names[idx+1:]


InitializeClass(ManagedSchema)
