#ifndef IMAGEOBJ_H
#define IMAGEOBJ_H

#include <qimage.h>
#include <qcanvas.h>
#include <qpainter.h>

#include "mapobj.h"

enum ImageType {qimage,qpixmap,undef};

class ImageObj: public QCanvasRectangle
{
public:
    ImageObj( QCanvas *canvas );
    ~ImageObj();
	virtual void copy (ImageObj*);
    virtual void setVisibility(bool);
	void save (const QString &, const char *);
	bool load (const QString &);
	bool load (QPixmap);
	void setImage(QImage img);
	QPixmap getPixmap();
protected:
    void drawShape( QPainter & );
private:
    QImage image;
    QPixmap pixmap;
	ImageType type;
};
#endif
