/*
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *                                                            1998, 2010
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * Support:
 *     http://sourceforge.net/projects/sarg/forums/forum/363374
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void mklastlog(const char *outdir)
{

   FILE *fp_in, *fp_ou;
   DIR *dirp;
   struct dirent *direntp;
   char temp[MAXLEN];
   char warea[MAXLEN];
   char ftime[128];
   int  ftot=0;
   time_t t;
   struct tm *local;
   struct stat statb;
   int cstatus;
   struct getwordstruct gwarea;

   if(LastLog <= 0)
      return;

   sprintf(temp,"%slastlog1",outdir);
   if((fp_ou=fopen(temp,"w"))==NULL) {
     fprintf(stderr, "SARG: (lastlog) %s: %s\n",text[9],temp);
     exit(1);
   }

   dirp = opendir(outdir);
   while ((direntp = readdir( dirp )) != NULL ){
      if(strchr(direntp->d_name,'-') == 0)
         continue;

      sprintf(warea,"%s%s",outdir,direntp->d_name);
      stat(warea,&statb);
      t=statb.st_ctime;
      local = localtime(&t);
      strftime(ftime, sizeof(ftime), "%Y%m%d%H%M%S", local);
      fprintf(fp_ou,"%s\t%s\n",ftime,direntp->d_name);
      ftot++;
   }

   (void)closedir( dirp );
   fclose(fp_ou);

   sprintf(buf,"sort -n -k 1,1 -o \"%slastlog\" \"%s\"",outdir,temp);
   cstatus=system(buf);
   if (!WIFEXITED(cstatus) || WEXITSTATUS(cstatus)) {
      fprintf(stderr, "SARG: sort command return status %d\n",WEXITSTATUS(cstatus));
      fprintf(stderr, "SARG: sort command: %s\n",buf);
      exit(1);
   }

   unlink(temp);

   if(ftot<=LastLog) {
      sprintf(temp,"%slastlog",outdir);
      if(access(temp, R_OK) == 0)
         unlink(temp);
      return;
   }

   ftot-=LastLog;

   sprintf(temp,"%slastlog",outdir);
   if((fp_in=fopen(temp,"r"))==NULL) {
     fprintf(stderr, "SARG: (lastlog) %s: %s\n",text[9],temp);
     exit(1);
   }

   while(ftot>0 && fgets(buf,sizeof(buf),fp_in)!=NULL) {
      fixendofline(buf);
      getword_start(&gwarea,buf);
      if (getword(warea,sizeof(warea),&gwarea,'\t')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",temp);
         exit(1);
      }

      if(debug)
         debuga("%s: %s",text[81],gwarea.current);
      if (snprintf(temp,sizeof(temp),"%s%s",outdir,gwarea.current)>=sizeof(temp)) {
         fprintf(stderr,"SARG: Directory name too long: %s%s\n",outdir,gwarea.current);
         exit(1);
      }
      unlinkdir(temp,0);
      ftot--;
   }

   fclose(fp_in);
   sprintf(temp,"%slastlog",outdir);
   unlink(temp);

   return;
}
