/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifndef KBANKING_CATEGORY_H
#define KBANKING_CATEGORY_H


#include <list>

#include <gwenhywfar/db.h>
#include <aqbanking/value.h>

#include <string>



class Category {
  friend class App;
public:
  Category(const std::string &id,
           const std::string &name,
           const std::string &descr="",
           Category *parent=0);
  Category(const Category &cat);
  Category(GWEN_DB_NODE *db, Category *parent=0);
  ~Category();

  Category *getParent();

  std::list<Category*> &getChildren();

  GWEN_DB_NODE *getRules();

  void setRules(GWEN_DB_NODE *dbRules);

  const std::string &getId() const;
  const std::string &getName() const;
  void setName(const std::string &s);

  const std::string &getDescription() const;
  void setDescription(const std::string &s);

  bool isIncome() const;
  void setIsIncome(bool b);

  void toDb(GWEN_DB_NODE *db);

  const AB_VALUE *getValue() const;
  void addValue(const AB_VALUE *v);
  void resetValues();

  const std::string &getPath();

private:
  Category *_parent;
  std::string _id;
  std::string _name;
  std::string _path;
  std::string _description;
  bool _isIncome;
  AB_VALUE *_value;
  std::list<Category*> _children;
  GWEN_DB_NODE *_dbRules;

  void setId(const std::string &s);

  /** takes over ownership of the given category */
  void addCategory(Category *cat);

  /** unlinks this category from the parents list.
   * This makes the caller responsible for freeing this category,
   * because the parent (which would do that normally) does not longer
   * know about this category. */
  void unlink();

  void _setIsIncomeToBranch(bool b);

};


#endif


