/* $Cambridge: hermes/src/prayer/accountd/test.c,v 1.1.1.1 2003/04/15 13:00:03 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2002 */
/* See the file NOTICE for conditions of use and distribution. */

#include "accountd.h"

#define BUFFER_SIZE (1024)

int main(int argc, char **argv)
{
    int fd;
    struct iostream *stream;
    char buffer[BUFFER_SIZE];
    struct termios attr, oldattr;

    if ((fd = open("/dev/tty", O_RDWR)) < 0)
        log_fatal("Couldn't open /dev/tty");

    if (!(stream = iostream_create(NIL, fd, 0)))
        log_fatal("Couldn't open iostream");

    ioprintf(stream, "Changing password for user dpc22.\n");
    ioflush(stream);
    ioprintf(stream, "Changing password for dpc22\n");
    ioflush(stream);

    ioprintf(stream, "(current) UNIX password: ");
    ioflush(stream);

    if (tcgetattr(fd, &oldattr) != 0)
        log_fatal("tcgetattr() failed");

    memcpy(&attr, &oldattr, sizeof(struct termios));

    attr.c_lflag &= ~(ISIG | ECHO);
    attr.c_lflag |= ECHONL;

    if (tcsetattr(fd, TCSANOW, &attr) != 0)
        log_fatal("tcgetattr() failed");

    if (!iostream_getline(stream, buffer, BUFFER_SIZE))
        log_fatal("Couldn't read line");

    if (tcsetattr(fd, TCSANOW, &oldattr) != 0)
        log_fatal("tcgetattr() failed");

    ioprintf(stream, "passwd: Authentication token manipulation error\n");
    ioflush(stream);
    iostream_close(stream);

    exit(0);
}
