create table roads_local (
  ogc_fid       INTEGER,
  geom          GEOMETRY,
  module        VARCHAR(8),
  tlid          INTEGER,
  side1         INTEGER,
  source        CHAR(1),
  fedirp        VARCHAR(2),
  fename        VARCHAR(30),
  fetype        VARCHAR(4),
  fedirs        VARCHAR(2),
  cfcc          VARCHAR(3),
  fraddl        INTEGER,
  toaddl        INTEGER,
  fraddr        INTEGER,
  toaddr        INTEGER,
  friaddl       CHAR(1),
  toiaddl       CHAR(1),
  friaddr       CHAR(1),
  toiaddr       CHAR(1),
  zipl          INTEGER,
  zipr          INTEGER,
  aianhhfpl     INTEGER,
  aianhhfpr     INTEGER,
  aihhtlil      CHAR(1),
  aihhtlir      CHAR(1),
  census1       CHAR(1),
  census2       CHAR(1),
  statel        INTEGER,
  stater        INTEGER,
  countyl       INTEGER,
  countyr       INTEGER,
  cousubl       INTEGER,
  cousubr       INTEGER,
  submcdl       INTEGER,
  submcdr       INTEGER,
  placel        INTEGER,
  placer        INTEGER,
  tractl        INTEGER,
  tractr        INTEGER,
  blockl        INTEGER,
  blockr        INTEGER
);

insert into roads_local
select
  ogc_fid,
  wkb_geometry,
  trim(module),
  tlid,
  side1,
  trim(source),
  trim(fedirp),
  trim(fename),
  trim(fetype),
  trim(fedirs),
  trim(cfcc),
  to_number(fraddl,'99999999999'),
  to_number(toaddl,'99999999999'),
  to_number(fraddr,'99999999999'),
  to_number(toaddr,'99999999999'),
  trim(friaddl),
  trim(toiaddl),
  trim(friaddr),
  trim(toiaddr),
  zipl,
  zipr,
  aianhhfpl,
  aianhhfpr,
  trim(aihhtlil),
  trim(aihhtlir),
  trim(census1),
  trim(census2),
  statel,
  stater,
  countyl,
  countyr,
  cousubl,
  cousubr,
  submcdl,
  submcdr,
  placel,
  placer,
  tractl,
  tractr,
  blockl,
  blockr
from completechain;

CREATE INDEX roads_local_tlid_idx ON roads_local (tlid);
CREATE INDEX roads_local_geom_idx ON roads_local USING GIST (geom public.gist_geometry_ops);
CREATE INDEX roads_local_cfcc_idx ON roads_local (cfcc);
