#include "config.h"
#include <fnmatch.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "types.h"
#include "adb.h"
#include "dirdb.h"
#include "gendir.h"
#include "mdb.h"
#include "modlist.h"
#include "pfilesel.h"
#include "playlist.h"
#include "stuff/compat.h"

void fsAddPlaylist(struct modlist *ml, struct dmDrive *base, const char *mask, unsigned long opt, const char *source)
{
	const struct dmDrive *dmDrive=0;
	char fullpath[PATH_MAX+1];
	char fullbasepath[PATH_MAX+1];
	struct stat st;
	struct modlistentry retval;
	char *s3;


	if (source[0]!='/')
	{
		if ((s3=index(source, '/')))
			if (s3[-1]==':')
			{
				if (!(dmDrive=dmFindDrive(source)))
				{
					*s3=0;
					fprintf(stderr, "[playlist] Drive/Protocol not supported (%s)\n", source);
					/* Drive/Protocol not supported */
					return;
				}
				source+=strlen(dmDrive->drivename);
				if ((source[0]!='/')||strstr(source, "/../"))
				{ /* doesnt catch /.. suffix, but shouldn' be a issue */
					fprintf(stderr, "[playlist] Relative paths in fullpath not possible\n");
					return;
				}
			}
	}
	if (!dmDrive)
		dmDrive=dmFindDrive("file:");

	if (strcmp(dmDrive->drivename, "file:"))
	{
		fprintf(stderr, "[playlist], API for getting handlers via dmDrive needed. TODO\n");
		return;
	}

	dirdbGetFullnameNoBase(dmDrive->currentpath, fullbasepath);
	gendir(fullbasepath, source, fullpath); /* path's doesn't need to reflect dmDrive, if drive is given, path must be full */
	if ((s3=rindex(fullpath, '/')))
		s3++;
	else
		s3=fullpath;

	memset(&st, 0, sizeof(st));
	memset(&retval, 0, sizeof(retval));

	if (stat(fullpath, &st)<0)
	{
		fprintf(stderr, "[playlist] stat() failed for %s\n", fullpath);
		return;
	}

	retval.drive=dmDrive->drivename;
	strncpy(retval.name, s3, NAME_MAX);
	retval.name[NAME_MAX]=0;

	strncpy(retval.fullname, fullpath, PATH_MAX);
	retval.fullname[PATH_MAX]=0;

	fs12name(retval.shortname, s3);	

	if (S_ISREG(st.st_mode))
	{
		if (isarchivepath(retval.fullname))
		{
			retval.flags=MODLIST_FLAG_ARC;
			strncat(retval.fullname, "/", PATH_MAX-strlen(retval.fullname)-1);
		} else {
			char curext[NAME_MAX+1];
			_splitpath(retval.fullname, 0, 0, 0, curext);
		      	if ((fnmatch(mask, retval.name, FNM_CASEFOLD))||(!fsIsModule(curext)))
				return;
			retval.fileref=mdbGetModuleReference(retval.shortname, st.st_size);
			retval.flags=MODLIST_FLAG_FILE;
		}
	} else if (S_ISDIR(st.st_mode))
	{
		if ((opt&RD_PUTSUBS))
		{
			retval.flags=MODLIST_FLAG_DIR;
			strncat(retval.fullname, "/", PATH_MAX-strlen(retval.fullname)-1);
		} else if ((opt&RD_PUTRSUBS))
		{
			strncat(retval.fullname, "/", PATH_MAX-strlen(retval.fullname)-1);
			fsReadDir(ml, base->drivename, retval.fullname, mask, opt);
			return;
		} else
			return;
	} else
		return;
	retval.Read=dosfile_Read;
	retval.ReadHeader=dosfile_ReadHeader;
	retval.ReadHandle=dosfile_ReadHandle;
	ml->append(ml, &retval); 
}
