/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 2005 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: PangoTextSrc.h
Responsibility: Daniel Glassey
Last reviewed: Not yet.

Description:
	A simple text source that shows how to use this interface within Graphite.
-------------------------------------------------------------------------------*//*:End Ignore*/
#ifndef PANGOTXTSRC_INCLUDED
#define PANGOTXTSRC_INCLUDED

#include <graphite/ITextSource.h>
typedef char   gchar;
using gr::GrResult;

/*----------------------------------------------------------------------------------------------
	Class: PangoTextSrc
	This class provides a simple implementation for a text source for the Graphite engine.
	There are no paragraph properties of interest and one set of character properties that
	apply to the entire string.
----------------------------------------------------------------------------------------------*/

namespace gr
{

class PangoTextSrc : public gr::ITextSource
{
public:
	// Constructor:
	PangoTextSrc(const char * pszText, int bytelength, int rtl, const char *language=0);
	PangoTextSrc(PangoTextSrc & textsrc);
	~PangoTextSrc();
	

	// -------------------------------------------------------------------------------
	// New interface:
	virtual gr::UtfType utfEncodingForm()
	{
		return gr::kutf8;
	}
	virtual size_t getLength()
	{
		return m_cchLength;
	}
	virtual const char * getText()
	{
		return m_prgchText;
	}
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf32 * prgchBuffer)
	{
		assert(false);
		return 0;
	}
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf16 * prgchwBuffer)
	{
		assert(false);
		return 0;
	};
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf8  * prgchsBuffer);
	virtual GrResult getFaceName(int ich, unsigned int cchMax,
		gr::utf16 * prgchFaceName, unsigned int * pcchLen);
	virtual bool getRightToLeft(toffset ich);
	virtual unsigned int getDirectionDepth(toffset ich);
	virtual float getVerticalOffset(toffset ich);
  virtual isocode getLanguage(toffset ich);

	virtual std::pair<toffset, toffset> propertyRange(toffset ich)
	{
		std::pair<toffset, toffset> pairRet;
		pairRet.first = 0;
		pairRet.second = m_cchLength;
		return pairRet;
	}

	virtual size_t getFontFeatures(toffset ich, gr::FeatureSetting * prgfset)
	{
		return 0; // no features in this simple implementation
	}
	virtual bool sameSegment(toffset ich1, toffset ich2)
	{
		return true;
	}

	// Temporary--eventually these properties will be of interest only to SegmentPainter.
	virtual void getColors(toffset ich, int * pclrFore, int * pclrBack)
	{
		*pclrFore = gr::kclrBlack;
		*pclrBack = gr::kclrTransparent;
	}


protected:
	gchar * m_prgchText;
	int m_cchLength;
  isocode m_langid;
    bool m_fRtl;
};

}; //namespace gr

#endif // !GRTXTSRC_INCLUDED
