/*

Create uninstaller, file associations and configure LyX

*/

!define SHORTCUT '\${APP_NAME} ${APP_SERIES_NAME}.lnk" "$INSTDIR\${APP_RUN}" "" "$INSTDIR\bin\lyx_32x32.ico" "" "" "" "${APP_INFO}"'

;--------------------------------
;Sections

Section -FileAssociations

  ;Associate .lyx files with LyX for current user of all users

  ;Write information about file type
  !define REG_FILETYPE 'WriteRegStr SHELL_CONTEXT "Software\Classes\${APP_REGNAME_DOC}'
  
  ${REG_FILETYPE}" "" "${APP_NAME} Document"
  ${REG_FILETYPE}\DefaultIcon" "" "$INSTDIR\bin\lyx_doc_32x32.ico"
  ${REG_FILETYPE}\Shell\open\command" "" '"$INSTDIR\${APP_RUN}" "%1"'
  
  !define REG_FILEEXT 'WriteRegStr SHELL_CONTEXT "Software\Classes\${APP_EXT}"'
  
  ${REG_FILEEXT} "" "${APP_REGNAME_DOC}"
  ${REG_FILEEXT} "Content Type" "${APP_MIME_TYPE}"  
  
  ;Refresh shell
  System::Call 'shell32.dll::SHChangeNotify(i, i, i, i) (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'

SectionEnd

Section -InstallData

  ;Registry information
  WriteRegStr SHELL_CONTEXT ${APP_REGKEY} "" $INSTDIR
  WriteRegStr SHELL_CONTEXT ${APP_REGKEY} "Version" "${APP_VERSION}"

  WriteRegStr SHELL_CONTEXT ${APP_REGKEY_SETUP} "LaTeX Path" $PathLaTeX
  WriteRegStr SHELL_CONTEXT ${APP_REGKEY_SETUP} "ImageMagick Path" $PathImageMagick
  WriteRegStr SHELL_CONTEXT ${APP_REGKEY_SETUP} "Ghostscript Path" $PathGhostscript
  WriteRegStr SHELL_CONTEXT ${APP_REGKEY_SETUP} "LyX Language" $LangName

  ;Start Menu shortcut
  ;There is only one shortcut to the application, so it should be in the main group
  CreateShortCut "$SMPROGRAMS\${SHORTCUT}
    
  ;Uninstaller information
  !define REG_UNINSTALL 'WriteRegStr SHELL_CONTEXT "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SETUP_UNINSTALLER_KEY}"'
  
  ${REG_UNINSTALL} "UninstallString" "$\"$INSTDIR\${SETUP_UNINSTALLER}$\""
  ${REG_UNINSTALL} "DisplayName" "${APP_NAME} ${APP_VERSION}"
  ${REG_UNINSTALL} "DisplayVersion" "${APP_VERSION}"
  ${REG_UNINSTALL} "DisplayIcon" "$INSTDIR\bin\lyx_32x32.ico"
  ${REG_UNINSTALL} "URLUpdateInfo" "http://www.lyx.org/"
  ${REG_UNINSTALL} "URLInfoAbout" "http://www.lyx.org/about/"
  ${REG_UNINSTALL} "Publisher" "LyX Team"
  ${REG_UNINSTALL} "HelpLink" "http://www.lyx.org/internet/mailing.php"  
 
  ;Create uninstaller
  WriteUninstaller "$INSTDIR\${SETUP_UNINSTALLER}"
  
SectionEnd

Section -Configure

  ;Remove old configuration files
  
  Delete "$INSTDIR\Resources\lyxrc.defaults"
  Delete "$INSTDIR\Resources\textclass.lst"
  Delete "$INSTDIR\Resources\packages.lst"

  ;Set a path prefix in lyxrc.dist
  
  Call GetPathPrefix
  Pop $R0
  
  Delete "$INSTDIR\Resources\lyxrc.dist"
  FileOpen $R1 "$INSTDIR\Resources\lyxrc.dist" w
  
  FileWrite $R1 '\path_prefix "$R0"$\r$\n'

  ;Default screen fonts
  FileWrite $R1 '\screen_font_roman "Times New Roman"$\r$\n'
  FileWrite $R1 '\screen_font_sans "Arial"$\r$\n'
  FileWrite $R1 '\screen_font_typewriter "Courier New"$\r$\n'
  
  FileClose $R1

  ;Create a batch file to start LyX with the environment variables set
  
  Delete "$INSTDIR\${APP_RUN}"
  FileOpen $R1 "$INSTDIR\${APP_RUN}" w

  FileWrite $R1 '@echo off$\r$\n'  
  FileWrite $R1 'SET LC_ALL=$LangCode$\r$\n'
  FileWrite $R1 'SET AIK_DATA_DIR=$INSTDIR\aiksaurus$\r$\n'
  FileWrite $R1 'start "${APP_NAME}" "$INSTDIR\bin\lyx.exe" %*$\r$\n'

  FileClose $R1

SectionEnd

;--------------------------------
;Functions

Function CreateDesktopShortcut

  ;Creating a desktop shortcut is an option on the finish page

  CreateShortCut "$DESKTOP\${SHORTCUT}

FunctionEnd
  