/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "enterpassworddialog.h"
#include <qdialog.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qdialog.h>
#include "enterpassworddialog.moc"

EnterUsernamePasswordDialog::EnterUsernamePasswordDialog(QWidget *parent, const QString& caption,bool askForGrouppassword, bool askForUsername) : KDialogBase( parent, "Enter_account_data", true, caption,
		KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	Password="";
	GroupPassword="";
	this->askForGrouppassword = askForGrouppassword;
	this->askForUsername = askForUsername;
	
	main = new EnterUsernamePasswordDialogBase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());
	
	if (!askForGrouppassword){
		main->PSKLineEdit->hide();
		main->LabelGroupPassword->hide();
	}


	main->textLabel2->setText( QString("<b><font size=\"+1\">"+i18n( "Enter account data:")+"</b></font>" ));
}

EnterUsernamePasswordDialog::~ EnterUsernamePasswordDialog()
{
	delete main;
}


void EnterUsernamePasswordDialog::accept()
{
	bool ok=true;

		if (askForGrouppassword){
			if (main->PasswordEdit->text().isEmpty() || main->PSKLineEdit->text().isEmpty() || 	main->UsernameEdit->text().isEmpty())
			{
				KMessageBox::sorry( 0, i18n( "All fields must be filled in!"));
				ok=false;
			}
		}
		else {
			if (main->PasswordEdit->text().isEmpty()  || main->UsernameEdit->text().isEmpty()) {
			KMessageBox::sorry( 0, i18n( "All fields must be filled in!"));
			ok=false;
			}
		}
	
	if (ok)
	{
		Password= main->PasswordEdit->text();
		GroupPassword = main->PSKLineEdit->text();
		Username = main->UsernameEdit->text();
		QDialog::accept();
	}


}
