/***************************************************************************
                          contactonlinenotification.cpp  -  description
                             -------------------
    begin                : Thu Jan 30 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "contactonlinenotification.h"

#include <qfile.h>
#include <qpixmap.h>

#include <kaudioplayer.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <klocale.h>
#include <knotifyclient.h>

#include "../contact/contact.h"
#include "../kmessdebug.h"
#include "../systemtraywidget.h"

#include "balloonwidget.h"
#include "notificationitem.h"
#include "notificationwidget.h"

// The constructor
ContactOnlineNotification::ContactOnlineNotification( BalloonWidget *balloonWidget )
 : balloonWidget_( balloonWidget )
{
  notificationWidget_ = new NotificationWidget( balloonWidget );
  notificationWidget_->setCaption( i18n( "The following people are online" ) );

  notificationWidget_->setPaletteBackgroundColor( "#B4FFB1" );

  connect( notificationWidget_,  SIGNAL(   clicked( QStringList, QObject * ) ),
           this,                   SLOT(   clicked( QStringList, QObject * ) ) );
}



// The destructor
ContactOnlineNotification::~ContactOnlineNotification()
{
#ifdef KMESSDEBUG_CONTACTONLINENOTIFICATION
  kdDebug() << "DESTROYED ContactOnlineNotification" << endl;
#endif
}



// The balloon was clicked
void ContactOnlineNotification::clicked( QStringList stringList, QObject */*object*/ )
{
  // Request a chat with the contact
  emit startChat( stringList[0] );
}



// Called when a contact comes online
void ContactOnlineNotification::contactOnline(Contact *contact, bool showBaloon)
{
#ifdef KMESSTEST
  ASSERT( contact != 0 );
#endif
  if ( contact == 0 )
  {
    kdDebug() << "ContactOnlineNotification::contactOnline() - WARNING - Contact is null!" << endl;
    return;
  }
#ifdef KMESSTEST
  ASSERT( contact->getExtension() != 0 );
#endif
  if ( contact->getExtension()->getNotifyOnline() && showBaloon )
  {
#ifdef KMESSDEBUG_CONTACTONLINENOTIFICATION
    kdDebug() << "ContactOnlineNotification: Contact is " << contact->getFriendlyName() << " getNotifyOnline is " << contact->getExtension()->getNotifyOnline() << endl;
#endif

    QFile        soundFile;
    QPixmap      pixmap;
    QString      text, soundPath;
    KIconLoader *loader = KGlobal::iconLoader();

    // Save the contact's handle
    handle_ = contact->getHandle();
    // Try to get the contact's picture
    pixmap.load( contact->getContactPicturePath() );
    // If the pixmap couldn't be loaded, use the generic "online" icon
    if ( pixmap.isNull() )
    {
      pixmap = loader->loadIcon("online", KIcon::User);
    }

    new NotificationItem( notificationWidget_, 0, contact->getFriendlyName(), contact->getContactPicturePath(), handle_, 0 );

    // Make the message
    text = i18n("%1 is online").arg( contact->getFriendlyName() );
    // Show the popup balloon
    //showBalloon( text, pixmap, "#B4FFB1"/*"#D1FCFF"*/ );

    // Play a sound
    soundPath = contact->getExtension()->getContactSoundPath();
    soundFile.setName( soundPath );

#ifdef KMESSDEBUG_CONTACTONLINENOTIFICATION
    kdDebug() << "ContactOnlineNotification: Look for a sound file at '" << soundPath << "'." << endl;
#endif
    // If the file exists, play it
    if ( soundFile.exists() )
    {
#ifdef KMESSDEBUG_CONTACTONLINENOTIFICATION
      kdDebug() << "ContactOnlineNotification: Play the sound." << endl;
#endif
      // Play the sound instead of the generic sound
      KAudioPlayer::play( soundPath );
    }
    else
    {
#ifdef KMESSDEBUG_CONTACTONLINENOTIFICATION
      kdDebug() << "ContactOnlineNotification: Play the default sound." << endl;
#endif
      KNotifyClient::event("contact online", text );
    }
  }
}

#include "contactonlinenotification.moc"
