/***************************************************************************
                          contactofflinenotification.h  -  description
                             -------------------
    begin                : Fri Jan 31 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTOFFLINENOTIFICATION_H
#define CONTACTOFFLINENOTIFICATION_H

#include <qwidget.h>
#include "popupnotification.h"

// Forward declarations
class Contact;
class BalloonWidget;
class NotificationWidget;

/**The popup for when a contact goes offline.  
  *@author Mike K. Bennett
  */

class ContactOfflineNotification : public QObject
{
  Q_OBJECT

  public:
    // The constructor
  	           ContactOfflineNotification( BalloonWidget *balloonWidget );
    // The destructor
  	          ~ContactOfflineNotification();

  public slots:
    // Called when a contact goes offline
    void       contactOffline(Contact *contact, bool showBaloon);

  private slots: // Private slots
    // The balloon was clicked
    void       balloonClicked();

  private: // Private attributes
    // Balloon Widget
    BalloonWidget      *balloonWidget_;
    CurrentAccount     *currentAccount_;
    // Not. Widget
    NotificationWidget *notificationWidget_;

};

#endif
