/***************************************************************************
                          account.h  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ACCOUNT_H
#define ACCOUNT_H

#include <qfont.h>
#include <qwidget.h>

#include "msnobject.h"

// Forward declarations
class KConfig;
class KMessTest;

/**A user account.
  *@author Mike K. Bennett
  */

class Account : public QWidget
{
  Q_OBJECT

  friend class KMessTest;

  public: // Public methods
    enum PROXYTYPE { TYPE_HTTP = 0, TYPE_SOCKS4, TYPE_SOCKS5 };


    // Directory structure constants
    enum ChatDirectoryStructure { SINGLEDIRECTORY = 0
                                , BYYEAR          = 1
                                , BYMONTH         = 2
                                , BYDAY           = 3
                                };

    // The constructor
    Account();
    // The destructor
    virtual ~Account();
    // Copy an account
    virtual void                 copyAccount( const Account *account );
    // Copy an account's user-interface, not settings, changable properties
    void                         copyAccountUISettings( const Account *account );
    // Read the auto-reply message.
    const QString&               getAutoreplyMessage() const;
    // Return the chat format string.
    const QString&               getChatFormat() const;
    // Return the font used for contact messages, if forced to.
    const QFont&                 getContactFont() const;
    // Return the color of the forced contact font.
    const QString&               getContactFontColor() const;
    // Read the email command used when not using hotmail
    const QString&               getEmailCommand() const;
    // Return whether email notifications are supported
    bool                         getEmailSupported() const;
    // Return the user message font.
    const QFont&                 getFont() const;
    // Return the color of the user message font.
    const QString&               getFontColor() const;
    // Return the user's friendlyName
    QString                      getFriendlyName() const;
    // Return the user's handle
    QString                      getHandle() const;
    // Return the length of time waited before the user goes idle.
    const int&                   getIdleTime() const;
    // Return the time popup windows are shown.
    const int&                   getNotificationDuration() const;
    // Return the user's password
    QString                      getPassword() const;
    // Return the proxy password
    const QString&               getProxyPassword() const;
    // Return the proxy port
    const int&                   getProxyPort() const;
    // Return the proxy server IP
    const QString&               getProxyServer() const;
    // Return the proxy server type
    const int&                   getProxyType() const;
    // Return the user's proxy user ID
    const QString&               getProxyUID() const;
   // Return whether or not to save chats.
    bool                         getSaveChats() const;
    // Return the base directory to which chats are saved.
    const QString&               getSaveChatPath() const;
    // Return the code of the structure used to save chats.
    const int&                   getSavedChatDirectoryStructure() const;
    // Read whether or not allowed contacts are shown.
    bool                         getShowAllowedContacts() const;
    // Read whether contacts are shown by group or by online/offline.
    bool                         getShowContactsByGroup() const;
    // Read whether the email information should be shown in the main view.
    bool                         getShowEmail() const;
    // Read whether offline contacts should be shown.
    bool                         getShowOfflineContacts() const;
    // Read property of bool showOfflineNotification_.
    bool                         getShowOfflineNotification() const;
    // Read property of bool showOtherFolders.
    bool                         getShowOtherFolders() const;
    // Read whether or not removed (reverse) contacts are shown.
    bool                         getShowRemovedContacts() const;
    // Read whether or not the sidebar should be shown in chats
    bool                         getShowSidebar() const;
    // Return whether or not to start in "hidden" mode
    bool                         getStartInvisible() const;
    // Return whether or not to autologin with this profile.
    bool                         getUseAutologin() const;
    // Return whether or not to show contact messages in the stored font.
    bool                         getUseContactFont() const;
    // Return whether or not to show emoticons in chats.
    bool                         getUseEmoticons() const;
    // Return whether or not to use bold/italic/underline effects in chats.
    bool                         getUseFontEffects() const;
    // Read whether the user uses hotmail to read email or a set command
    bool                         getUseHotmail() const;
    // Return whether the idle timer should be used.
    bool                         getUseIdleTimer() const;
    // Return whether or not to show popup notifications.
    bool                         getUseNotifier() const;
    // Return whether or not to use a proxy.
    bool                         getUseProxy() const;
    // Returns whether or not to send our display image
    bool                         getShowImage() const;
    // Returns whether or not to show a custom image
    bool                         getCustomImage() const;
    // Return the path of the custom display image.
    const QString                getCustomImagePath() const;
    // Return the path to the *current* display image
    const QString                getImagePath() const;
    // Returns the string representation of the MsnObject
    const QString                getMsnObjectString() const;
    // Read in account properties
    void                         readProperties(KConfig *config, QString  handle);
    // Save account properties
    void                         saveProperties(KConfig *config);
    // Set alert information
    void                         setAlertsInformation( bool useIdleTimer, int idleTime, bool useNotifier, int notificationDuration, bool showOfflineNotification);
    // Set the auto-reply message.
    void                         setAutoreplyMessage( const QString&  autoreplyMessage);
    // Set chat information
    void                         setChatInformation( bool useContactFont, bool useEmoticons, bool useFontEffects, const QString& chatFormat );
    // Set chat logging information
    void                         setChatLoggingInformation( bool saveChats, const QString& saveChatPath, const int& directoryStructure );
    // Set email information
    void                         setEmailInformation( bool useHotmail, const QString&  emailCommand, bool showEmail, bool showOtherFolders );
    // Set the font
    void                         setFont( const QFont& font );
    // Set the font color
    void                         setFontColor( const QString&  fontColor );
    // Set the fonts and font colors
    void                         setFontInformation( const QFont& font, const QString  &fontColor, const QFont& contactFont, const QString  &contactFontColor);
    // Change the friendly name
    void                         setFriendlyName( const QString&  newName );
    // Set proxy information
    void                         setProxyInformation( bool useproxy, const int& proxytype,const QString& proxyserver, const int& proxyport,const QString& proxyuid, const QString& password );
    // Set basic account data
    void                         setLoginInformation( QString  handle, QString  friendlyName, QString  password = "" );
    // Set whether or not allowed contacts are shown.
    void                         setShowAllowedContacts( bool showAllowedContacts );
    // Set whether contacts are shown by group or by online/offline.
    void                         setShowContactsByGroup( bool showContactsByGroup );
    // Set whether offline contacts should be shown.
    void                         setShowOfflineContacts( bool showOfflineContacts );
    // Set whether or not removed (reverse) contacts are shown.
    void                         setShowRemovedContacts( bool showRemovedContacts );
    // Set whether or not the sidebar should be shown in chats
    void                         setShowSidebar( bool showSidebar );
    // Set whether or not to start in "hidden" mode
    void                         setStartInvisible( bool startInvisible );
    // Set whether or not to login with this account.
    void                         setUseAutologin( bool useAutologin);
    // Set whether or not to show emoticons in chats.
    void                         setUseEmoticons( bool useEmoticons);
    // Set whether or not to send our display image
    void                         setShowImage( bool showImage );
    // Set whether or not to show a custom display image
    void                         setCustomImage( bool customImage );
    // Creates the MsnObject only if the user wants to show a display picture
    void                         updateMsnObject();

  protected: // Protected methods
    // Update the email-supported state (protected method)
    void                         setEmailSupported(bool emailSupported);

  private: // Private attributes
    // The message used to automatically reply to messages when the user is away.
    QString                      autoreplyMessage_;
    // The chat format, with the {time}, {name}, and {message} elements.
    QString                      chatFormat_;
    // The message font to be used by contact messages.
    QFont                        contactFont_;
    // The font color to be applied to contact messages.
    QString                      contactFontColor_;
    // Whether the account has been changed at all
    bool                         dirty_;
    // The external command used, optionally, to open email
    QString                      emailCommand_;
    // Whether the user can receive email notifications (hotmail.com or msn.com account)
    bool                         emailSupported_;
    // The user's message font.
    QFont                        font_;
    // The user's message font color.
    QString                      fontColor_;
    // The user's friendly name, i.e. "Mike"
    QString                      friendlyName_;
    // The user's handle, i.e. mkb137b@hotmail.com
    QString                      handle_;
    // The number of minutes of inactivity before the user status is
    //  changed to idle.
    int                          idleTime_;
    // The duration in seconds that a notification balloon is shown.
    int                          notificationDuration_;
    // The user's password
    QString                      password_;
    // The path to which chat files are automatically saved.
    QString                      saveChatPath_;
    // Whether or not to save chat files.
    bool                         saveChats_;
    // Whether saved chats are organized by year, month, day, or all in a single directory
    int                          savedChatDirectoryStructure_;
    // Whether or not allowed contacts should be visible.
    bool                         showAllowedContacts_;
    // Whether contacts should be shown by group (true) or by online/offline status (false).
    bool                         showContactsByGroup_;
    // Whether or not to show any email notifications (the user may not
    //  have a hotmail account).
    bool                         showEmail_;
    // Whether or not offline contacts are shown.
    bool                         showOfflineContacts_;
    // Whether or not "contact is offline" notifications are shown.
    bool                         showOfflineNotification_;
    // Whether or not notifications should be shown for "other folder" email.
    bool                         showOtherFolders_;
    // Whether or not removed (or reverse) contacts should be visible.
    bool                         showRemovedContacts_;
    // Whether or not the sidebar should be shown in chats
    bool                         showSidebar_;
    // Whether or not to start in "hidden" mode
    bool                         startInvisible_;
    // Whether or not to autologin with this user.
    bool                         useAutologin_;
    // Whether or not the contact's font should be forced to some value.
    bool                         useContactFont_;
    // Whether or not emoticons should be used.
    bool                         useEmoticons_;
    // Whether or not to use bold/italic/underline effects in chats.
    bool                         useFontEffects_;
    // Whether to use Hotmail as the mail client or not (ie, use command given)
    bool                         useHotmail_;
    // Whether or not the user wants to go idle after a certain time.
    bool                         useIdleTimer_;
    // Whether or not to show notification messages (balloons)
    bool                         useNotifier_;
    //Whether or not to use a proxy
    bool                         useProxy_;
    // The proxy type
    PROXYTYPE                    proxyType_;
    // The proxy host
    QString                      proxyServer_;
    // The proxy port
    int                          proxyPort_;
    // The proxy User ID
    QString                      proxyUID_;
    // The proxy user's password
    QString                      proxyPassword_;
    // Whether or not to send our display image
    bool                         showImage_;
    // whether or not to use a custom display image
    bool                         customImage_;
    // MsnObject representing our display picture if we have one
    MsnObject                    *msnObject_;
  signals: // Public signals
    // Signal that group/contact display settings have been changed
    void                         changedDisplaySettings();
    // Signal that the user changed email display settings
    void                         changedEmailDisplaySettings();
    // Signal that font settings have changed
    void                         changedFontSettings();
    // Signal that the friendly name has changed
    void                         changedFriendlyName();
    // SIgnal that the msn object has changed.
    void                         changedMsnObject();
    // Signal that timer settings were changed
    void                         changedTimerSettings();
    // Signal that the view mode has changed
    void                         changedViewMode();
};

#endif
