/***************************************************************************

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***************************************************************************
Copyright (C) 2005 by 
Pan Wojtas (Wojtek Sulewski)
wojteksulewski <at> op.pl
gg: 2087202

***************************************************************************/

#include <qpainter.h>
#include <qapplication.h>
#include <qsimplerichtext.h>
#include <qspinbox.h>

#include "osd_widget.h"

#include "config_dialog.h"
#include "chat_manager.h"
#include "debug.h"



const int DEFAULT_FRAMES_PER_SECOND = 30;
//const int HINT_MARGIN = 0;
const int DISSOLVE_SIZE_VALUE = 24;


OSDWidget::OSDWidget(QWidget * parent) : KaduTextBrowser(parent)
{
	kdebugf();
	
	reparent(parent, WStyle_NoBorder | WStyle_StaysOnTop | WStyle_Tool | WX11BypassWM | WWinOwnDC | WDestructiveClose, QPoint(0,0));
	m_dissolveSize = DISSOLVE_SIZE_VALUE;
	
	setVScrollBarMode(QScrollView::AlwaysOff);
	setHScrollBarMode(QScrollView::AlwaysOff);
	setReadOnly(true);
	setFocusPolicy(NoFocus);
	setFrameStyle(QFrame::Plain);
	
	connect(&m_frameTimer, SIGNAL(timeout()), SLOT(dissolveMask()));
	connect(this, SIGNAL(mouseReleased(QMouseEvent *, KaduTextBrowser *)), this, SLOT(mouseReleased(QMouseEvent *, KaduTextBrowser *)));
	
	kdebugf2();
}

OSDWidget::~OSDWidget()
{
	kdebugf();
	
	disconnect(this, SIGNAL(mouseReleased(QMouseEvent *, KaduTextBrowser *)), this, SLOT(mouseReleased(QMouseEvent *, KaduTextBrowser *)));
	
	kdebugf2();
}

void OSDWidget::prepare()
{
	kdebugf();
	
	QPalette p(QWidget::palette());
	p.setColor(QPalette::Inactive, QColorGroup::Text, m_data.fg_color);
	p.setColor(QPalette::Inactive, QColorGroup::Link, m_data.fg_color.light());
	QWidget::setPalette(p);
	
// tworzy QSimpleRichText tylko w celu obliczenia szerokoci i wysokoci, jak zajmuje rich text - jak to zrobi inaczej?
	// _ma_ znaczenie, czy jest "QString::null, 0, QMimeSourceFactory::defaultFactory()" - inna szeroko!
	
	kdebugm(KDEBUG_INFO, "m_data.message: %s\n", m_data.message.local8Bit().data());
	
	QSimpleRichText m_richText(m_data.message, currentFont(), QString::null, 0, mimeSourceFactory());
	m_richText.setWidth(600);	//ustawia warto wiksz, ni spodziewana - bo inaczej s bdy (z ';'); kto robi sobie dymki > 600px?

	m_width = m_richText.widthUsed();
	m_height = m_richText.height();
	
	if (m_data.message.contains("<table", false))
		m_height -= fontMetrics().height();		//Qt dodaje za duy margines pod tabelk - bd qt #102749
	
	setFixedWidth(m_width);
	setFixedHeight(m_height);
	
// to
	if (m_data.translucency_val == 1)
	{
		background.resize(m_width, m_height);
		background.fill(m_data.bg_color);
		
		background_light.resize(m_width, m_height);
		background_light.fill(m_data.bg_color.light(160));
		
		// border
		drawBorder();
	}
	
// create and set transparency mask
	m_mask.resize(m_width, m_height);
	switch(m_data.maskEffect)
	{
		case Plain:
			plainMask();
			break;
	
		case Dissolve:
			dissolveMask();		// tworzy efekt pojawiania...
			break;
	}

// close the message window after given mS
	if (m_data.duration > 0)
	{
		QTimer::singleShot(m_data.duration, this, SLOT(timeout()));
	}
	
	kdebugf2();
}

void OSDWidget::display()
{
	kdebugf();
	
//ensure we don't dip below the screen
	const QRect screen = QApplication::desktop()->screenGeometry(0);
	if (m_data.x + m_width > screen.width())
		m_data.x = screen.width() - m_width;
	else if (m_data.x < 0)
		m_data.x = 0;

	if (m_data.y + m_height > screen.height())
		m_data.y = screen.height() - m_height;
	else if (m_data.y < 0)
		m_data.y = 0;

	move(m_data.x, m_data.y);

// przezroczysto
	if (m_data.translucency_val != 1)
	{
		background.resize(m_width, m_height);
		background.fill(m_data.bg_color);

		QImage scr(QPixmap::grabWindow(qt_xrootwin(), m_data.x, m_data.y, m_width, m_height).convertToImage());
		background = fade(scr, m_data.translucency_val, m_data.bg_color);
		background_light = fade(scr, m_data.translucency_val, m_data.bg_color.light(160));
		
		// border
		drawBorder();
	}

	mimeSourceFactory()->setPixmap("mime_bg", background);
	
	setText("<qt background=\"mime_bg\" >" +  m_data.message + "</qt>");	// musi by po mime;

	QWidget::show();
	
	setText("<qt background=\"mime_bg\">" +  m_data.message + "</qt>");	// dwa razy, eby si odwieyo :| musi by po show :|
	
	kdebugf2();
}

void OSDWidget::drawBorder()
{
	kdebugf();
	
	QPainter p( &background );
	p.setPen(m_data.border_color);
	p.drawRoundRect(0,0,m_width,m_height, 1600 / m_width,1600 / m_height);
	//TODO light?
	
	kdebugf2();
}

void OSDWidget::plainMask()
{
	
	kdebugf();
	QPainter maskPainter(&m_mask);
	
	m_mask.fill(Qt::black);
	
	maskPainter.setBrush(Qt::white);
	maskPainter.setPen(Qt::white);
	maskPainter.drawRoundRect(0, 0, m_width, m_height, 1600 / m_width, 1600 / m_height);
	
	setMask(m_mask);
	
	kdebugf2();
}

void OSDWidget::dissolveMask()
{
	kdebugf();
	
	QPainter maskPainter(&m_mask);

	m_mask.fill(Qt::black);
	
	maskPainter.setBrush(Qt::white);
	maskPainter.setPen(Qt::white);
	maskPainter.drawRoundRect(0, 0, m_width, m_height, 1600 / m_width, 1600 / m_height);

	m_dissolveSize--;
	
	if (m_dissolveSize > 0)
	{
		maskPainter.setRasterOp(Qt::EraseROP);

		int x, y, s;
		const int size = 16;
	
		for (y = 0; y < m_height + size; y += size)
		{
			x = m_width;
			s = m_dissolveSize * x / 128;
			for (; x > -size; x -= size, s -= 2)
			{
				if (s < 0)
					break;

				maskPainter.drawEllipse(x - s / 2, y - s / 2, s, s);
			}
		}
		
		m_frameTimer.start(1000 / DEFAULT_FRAMES_PER_SECOND, true);
	}
	setMask(m_mask);
	
	kdebugf2();
}

void OSDWidget::timeout(bool b)
{
	kdebugf();
	
	QWidget::hide();
	emit timeout(m_data.id, b);
	
	kdebugf2();
}

void OSDWidget::enterEvent(QEvent* /*e*/)
{
	kdebugf();
	
	QPalette p(QWidget::palette());
	p.setColor(QPalette::Inactive, QColorGroup::Text, m_data.fg_color.dark(350));
	p.setColor(QPalette::Inactive, QColorGroup::Link, m_data.fg_color);
	QWidget::setPalette(p);
	
	mimeSourceFactory()->setPixmap("mime_bg", background_light);
	
	// TODO: zamieni na jaki refresh...
	//msg ma dodatkow spacj - bez tego nie odwiea si.
	QString msg("<qt background=\"mime_bg\" >" +  m_data.message + "</qt>");
	setText(msg);
	
	kdebugf2();
}

void OSDWidget::leaveEvent(QEvent* /*e*/)
{
	kdebugf();
	
	QPalette p(QWidget::palette());
	p.setColor(QPalette::Inactive, QColorGroup::Text, m_data.fg_color);
	p.setColor(QPalette::Inactive, QColorGroup::Link, m_data.fg_color.light());
	QWidget::setPalette(p);
	
	mimeSourceFactory()->setPixmap("mime_bg", background);
	QString msg("<qt background=\"mime_bg\">" +  m_data.message + "</qt>");
	setText(msg);
	
	kdebugf2();
}

void OSDWidget::mouseReleased(QMouseEvent *e, KaduTextBrowser *sender)
{
	kdebugf();
	
	switch (e->button())
	{
		case Qt::LeftButton:
			buttonPressed("LeftButton");
			break;
			
		case Qt::MidButton:
			buttonPressed("MiddleButton");
			break;
			
		case Qt::RightButton:
			buttonPressed("RightButton");
			break;
			
		default:
			break;
	}
	
	kdebugf2();
}

void OSDWidget::buttonPressed(QString button)
{
	kdebugf();
// 0 - nothing
// 1 - open chat
// 2 - delete hint
// 3 - delete all hints
	
	switch(config_file.readNumEntry("osdhints", button))
	{
		case 1:
			if (!m_data.users.empty())
			{
				chat_manager->openPendingMsgs(m_data.users);
//				timeout(true);		//nie, bo jest ju w chatCreated w hintsmanager
			}
			break;
		case 2:
			if(config_file.readBoolEntry("osdhints", "DeletePendingMsg", false) && !m_data.users.empty())
			{
				chat_manager->deletePendingMsgs(m_data.users);
				timeout(true);
			}
			else
				timeout(false);
			break;
		case 3:	
			if(config_file.readBoolEntry("osdhints", "DeletePendingMsg", false) && !m_data.users.empty())
				chat_manager->deletePendingMsgs(m_data.users);

			emit deleteAll();
			break;
		default:
			break;
	}
	
	kdebugf2();
}

// eby nie przesuwa zawartoci...
void OSDWidget::contentsWheelEvent(QWheelEvent *e)
{
	kdebugf();
	kdebugf2();
}

// eby nie robio si popupmenu
QPopupMenu *OSDWidget::createPopupMenu(const QPoint &point)
{
	kdebugf();
	
	return NULL;
	
	kdebugf2();
}

//////  OSDPreviewWidget below /////////////////////


#include <qvbuttongroup.h>
#include <qcursor.h>
#include <qcombobox.h>
#include <qcheckbox.h>

OSDPreviewWidget::OSDPreviewWidget(QWidget *parent) : OSDWidget(parent)
{
	kdebugf();
	
	m_data.duration = 0;
	m_dragging = false;
	
	kdebugf2();
}

void OSDPreviewWidget::doUpdate()
{
	kdebugf();
	
	QWidget::hide();

	setFont(ConfigDialog::getSelectFont("osdhints", "Font in OSD")->font());
	
	switch(ConfigDialog::getComboBox("osdhints", "Show effect:")->currentItem())
	{
		case 1:
			m_dissolveSize = DISSOLVE_SIZE_VALUE;
			m_data.maskEffect = Dissolve;
			break;
		default:
			m_data.maskEffect = Plain;
			break;
	}
	
	if (ConfigDialog::getCheckBox("osdhints", "Make the background translucent")->isChecked())
		m_data.translucency_val = ConfigDialog::getSpinBox("osdhints", "Translucency level")->value() * 0.01;	// * 0.01, bo w spinie s wartoci w %
	else
		m_data.translucency_val = 1;

	m_data.bg_color = ConfigDialog::getColorButton("osdhints", "Background color:")->color();
	m_data.fg_color = ConfigDialog::getColorButton("osdhints", "Text color:")->color();
	m_data.border_color = ConfigDialog::getColorButton("osdhints", "Border color:")->color();
	
	m_data.message = ConfigDialog::getTextEdit("osdhints", "Syntax:")->text();

	if(ConfigDialog::getCheckBox("osdhints", "Show emoticons")->isChecked())
	{
		HtmlDocument doc;
		doc.parseHtml(m_data.message);
		doc.convertUrlsToHtml();
		mimeSourceFactory()->addFilePath(emoticons->themePath());
		emoticons->expandEmoticons(doc, m_data.bg_color);
		m_data.message = doc.generateHtml();
	}

	prepare();
	
	const QRect screen = QApplication::desktop()->screenGeometry(0);
	int corner = ConfigDialog::getVButtonGroup("osdhints", "For corner:")->selectedId();
	switch(corner)
	{
		case 0:		// Left top
			m_data.x = ConfigDialog::getSpinBox("osdhints", "X:")->value();
			m_data.y = ConfigDialog::getSpinBox("osdhints", "Y:")->value();
			
			ConfigDialog::getSpinBox("osdhints", "X:")->setMinValue(0);
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMinValue(0);
			ConfigDialog::getSpinBox("osdhints", "X:")->setMaxValue(screen.width() - m_width);
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMaxValue(screen.height() - m_height);
			break;
		case 1:		// Left bottom
			m_data.x = ConfigDialog::getSpinBox("osdhints", "X:")->value();
			m_data.y = ConfigDialog::getSpinBox("osdhints", "Y:")->value() - m_height;
			
			ConfigDialog::getSpinBox("osdhints", "X:")->setMinValue(0);
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMinValue(m_height);
			ConfigDialog::getSpinBox("osdhints", "X:")->setMaxValue(screen.width() - m_width);
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMaxValue(screen.height());
			break;
		case 2:		// Right top
			m_data.x = ConfigDialog::getSpinBox("osdhints", "X:")->value() - m_width;
			m_data.y = ConfigDialog::getSpinBox("osdhints", "Y:")->value();
			
			ConfigDialog::getSpinBox("osdhints", "X:")->setMinValue(m_width);
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMinValue(0);
			ConfigDialog::getSpinBox("osdhints", "X:")->setMaxValue(screen.width());
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMaxValue(screen.height() - m_height);
			break;
		case 3:		// Right bottom
			m_data.x = ConfigDialog::getSpinBox("osdhints", "X:")->value() - m_width;
			m_data.y = ConfigDialog::getSpinBox("osdhints", "Y:")->value() - m_height;
			
			ConfigDialog::getSpinBox("osdhints", "X:")->setMinValue(m_width);
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMinValue(m_height);
			ConfigDialog::getSpinBox("osdhints", "X:")->setMaxValue(screen.width());
			ConfigDialog::getSpinBox("osdhints", "Y:")->setMaxValue(screen.height());
			break;
	}

	display();
	
	kdebugf2();
}

void OSDPreviewWidget::contentsMousePressEvent(QMouseEvent *e)
{
	kdebugf();
	
	m_dragOffset = e->pos(); //TODO: do ifa

	if(e->button() == LeftButton && !m_dragging)
	{
		m_dragging = true;
//		setCursor(QCursor::sizeAllCursor);
//		grabMouse(QCursor::sizeAllCursor);
	}
	
	kdebugf2();
}

void OSDPreviewWidget::contentsMouseMoveEvent(QMouseEvent *e)
{
	kdebugf();
	
	if(m_dragging)
	{
		const QRect screen = QApplication::desktop()->screenGeometry(0);
			
		QPoint destination = e->globalPos() - m_dragOffset - screen.topLeft();
		// czy nie wyszed za ekran
		int maxX = screen.width() - m_width;
		if(destination.x() < 0)
			destination.rx() = 0;
		if(destination.x() > maxX )
			destination.rx() = maxX;
		int maxY = screen.height() - m_height;
		if(destination.y() < 0)
			destination.ry() = 0;
		if(destination.y() > maxY)
			destination.ry() = maxY;
		
		
		destination += screen.topLeft();
		
		move(destination);
	}
	
	kdebugf2();
}

void OSDPreviewWidget::mouseReleased(QMouseEvent *e, KaduTextBrowser *sender)
{
	kdebugf();
	
	switch (e->button())
	{
		case Qt::LeftButton:
			m_dragging = false;

			if(QApplication::desktop()->screenNumber(pos()) != -1)
			{
				// set new data
				
				m_data.x = QWidget::x();
				m_data.y = QWidget::y();
				
				switch ((int)ConfigDialog::getVButtonGroup("osdhints", "For corner:")->selectedId())
				{
					case 1:
						emit positionChanged(m_data.x, m_data.y + m_height);
						break;
					case 2:
						
						emit positionChanged(m_data.x + m_width, m_data.y);
						break;
					case 3:
						emit positionChanged(m_data.x + m_width, m_data.y + m_height);
						break;
					default:
						emit positionChanged(m_data.x, m_data.y);
				}
			}
			break;
			
		default:
			break;
	}
	
	kdebugf2();
}

/**

		Code copied from kpixmapeffect.cpp

 **/
 
QImage OSDWidget::fade(QImage img, const float val, const QColor &color)
{
	kdebugf();
	
	if (img.width() == 0 || img.height() == 0)
		return img;
	
	// We don't handle bitmaps
	if (img.depth() == 1)
		return img;
	
	unsigned char tbl[256];
	for (int i=0; i<256; i++)
		tbl[i] = (int) (val * i + 0.5);
	
	int red = color.red();
	int green = color.green();
	int blue = color.blue();
	
	QRgb col;
	int r, g, b, cr, cg, cb;
	
	if (img.depth() <= 8)
	{
		// pseudo color
		for (int i=0; i<img.numColors(); i++)
		{
			col = img.color(i);
			cr = qRed(col); cg = qGreen(col); cb = qBlue(col);
			if (cr > red)
				r = cr - tbl[cr - red];
			else
				r = cr + tbl[red - cr];
			if (cg > green)
				g = cg - tbl[cg - green];
			else
				g = cg + tbl[green - cg];
			if (cb > blue)
				b = cb - tbl[cb - blue];
			else
				b = cb + tbl[blue - cb];
			img.setColor(i, qRgba(r, g, b, qAlpha(col)));
		}
	} else 
	{
	// truecolor
		for (int y=0; y<img.height(); y++)
		{
			QRgb *data = (QRgb *) img.scanLine(y);
			for (int x=0; x<img.width(); x++)
			{
				col = *data;
				cr = qRed(col); cg = qGreen(col); cb = qBlue(col);
				if (cr > red)
					r = cr - tbl[cr - red];
				else
					r = cr + tbl[red - cr];
				if (cg > green)
					g = cg - tbl[cg - green];
				else
					g = cg + tbl[green - cg];
				if (cb > blue)
					b = cb - tbl[cb - blue];
				else
					b = cb + tbl[blue - cb];
				*data++ = qRgba(r, g, b, qAlpha(col));
			}
		}
	}
	
	kdebugf2();
	return img;
}
