/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qlistview.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include "infos_dialog.h"
#include "infos_list_view_item.h"

#include "modules.h"
#include "userlist.h"
#include "debug.h"


InfosDialog::InfosDialog(const LastSeen &lastSeen, QWidget *parent, const char *name, bool modal, WFlags f)
:QDialog(parent, name, modal, f)
{
	kdebugf();
	QVBoxLayout *mainLayout = new QVBoxLayout(this, 10, -1, "infos_dialog_main_layout");
	QListView *listView = new QListView(this, "list view");
	mainLayout->addWidget(listView);
	QHBoxLayout *buttonsLayout = new QHBoxLayout(mainLayout, -1, "infos_dialog_buttons_layout");
	listView->setAllColumnsShowFocus(true);
	listView->addColumn(tr("Contact"));
	listView->addColumn(tr("Uin"));
	listView->addColumn(tr("Nick"));
	listView->addColumn(tr("IP"));
	listView->addColumn(tr("Domain name"));
	listView->addColumn(tr("Description"));
	listView->addColumn(tr("Last time seen on"));
	QPushButton *closeButton = new QPushButton(tr("&Close"), this, "infos close button");
	buttonsLayout->addStretch();
	buttonsLayout->addWidget(closeButton);
	
	for(UserList::const_iterator it = userlist->begin(); it != userlist->end(); ++it)
	{
		if((*it).usesProtocol("Gadu"))
		{
			QString desc, ip;
			if((*it).status("Gadu").hasDescription())
				desc = (*it).status("Gadu").description();
			desc.replace('\n', ' ');
			if((*it).hasIP("Gadu"))
				ip = (*it).IP("Gadu").toString();
			new InfosListViewItem(listView, (*it).altNick(), (*it).ID("Gadu"), (*it).nickName(), ip,
					(*it).DNSName("Gadu"), desc, lastSeen[(*it).ID("Gadu")]);
		}
	}
	
	connect(closeButton, SIGNAL( clicked() ), this, SLOT( close() ));

	modules_manager->moduleIncUsageCount("powerkadu");
	kdebugf2();
}

InfosDialog::~InfosDialog()
{
	kdebugf();
	modules_manager->moduleDecUsageCount("powerkadu");
	kdebugf2();
}


