Name:           gcfilms
Version:        6.1
Release:        1%{?dist}
Summary:        Movies collection management

Group:          Applications/Databases
License:        GPL
URL:            https://gna.org/projects/gcfilms/
Source0:        http://download.gna.org/gcfilms/gcfilms-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

BuildRequires:    desktop-file-utils
Requires:         perl-Gtk2
Requires(post):   desktop-file-utils, shared-mime-info
Requires(postun): desktop-file-utils, shared-mime-info

%define desktop_vendor gna

%description
GCfilms is an application for managing your movie collection.
Detailed information on each movie can be automatically retrieved from the internet
and you can store additional data, such as the location, format and even who you've lent them to.
You may also search and filter your collection by criteria such as director,
genre, rating and much more.

%prep
%setup -n gcfilms


%build

%install
rm -rf %{buildroot}
%{__mkdir_p} %{buildroot}%{_prefix}
%{__install} -d %{buildroot}%{_bindir}
%{__install} bin/gcfilms %{buildroot}%{_bindir}
%{__install} -d %{buildroot}%{_libdir}
%{__cp} -a lib/gcfilms %{buildroot}%{_libdir}
%{__install} -d %{buildroot}%{_datadir}
%{__cp} -a share/gcfilms %{buildroot}%{_datadir}

# Install menu entry
%{__cat} > %{name}.desktop << EOF
[Desktop Entry]
Name=GCfilms
Comment=Manage your movies collection
GenericName=Movies collection management
Exec=gcfilms
Icon=%{_datadir}/gcfilms/icons/gcfilms_64x64.png
Terminal=false
Type=Application
MimeType=application/x-gcfilms
Categories=Application;Office;
Encoding=UTF-8
EOF

%{__mkdir_p} %{buildroot}%{_datadir}/applications
desktop-file-install \
    --vendor %{desktop_vendor} \
    --dir %{buildroot}%{_datadir}/applications  \
    %{name}.desktop

#Mime Type
%{__cat} > %{name}.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<mime-info xmlns="http://www.freedesktop.org/standards/shared-mime-info">
        <mime-type type="application/x-gcfilms">
                <comment>GCfilms movie collection</comment>
                <glob pattern="*.gcf"/>
        </mime-type>
</mime-info>
EOF

%{__mkdir_p} %{buildroot}%{_datadir}/mime/packages
cp %{name}.xml %{buildroot}%{_datadir}/mime/packages


%clean
rm -rf %{buildroot}

%post
update-desktop-database &> /dev/null ||:
update-mime-database %{_datadir}/mime &> /dev/null || :

%postun
update-desktop-database &> /dev/null ||:
update-mime-database %{_datadir}/mime &> /dev/null || :

%files
%defattr(-,root,root)
%doc CHANGELOG README LICENSE
%{_libdir}/gcfilms
%{_datadir}/gcfilms
%attr(0755,root,root) %{_bindir}/gcfilms
%{_datadir}/applications/%{desktop_vendor}-%{name}.desktop
%{_datadir}/mime/packages/%{name}.xml

%changelog
* Sun Nov 20 2005 Tian <tian@c-sait.net> - 6.0-1
  - New upstream version.
  - Changed description to follow upstream conventions.
  - Use of new iconset.
* Fri Jul 1 2005 Tian <tian@c-sait.net> - 5.3-1
  - New upstream version.
  - Added dist tag
* Wed Jun 22 2005 Tian <tian@c-sait.net> - 5.2-1
  - New upstream version with important bug fixes.
* Sun Jun 19 2005 Tian <tian@c-sait.net> - 5.1-1
  - Fixed days of the week in changelog section.
  - New upstream version.
* Sat May 21 2005 Tian <tian@c-sait.net> - 5.0-5
  - Removed useless lines about doc into install section.
* Fri May 20 2005 Tian <tian@c-sait.net> - 5.0-4
  - Changed prep section to specify gcfilms directory
  - Reduced other lines thanks to previous modification
* Mon May 16 2005 Tian <tian@c-sait.net> - 5.0-3
  - Replaced multiple __install with a few __cp -a
* Mon May 09 2005 Tian <tian@c-sait.net> - 5.0-2
  - Use install binary for install section
  - Removed _without_freedesktop use.
  - Full URL for Source0.
  - Small changes in files.
  - Requires(post) and Requires(postun) added.
* Mon Apr 25 2005 Tian <tian@c-sait.net> - 5.0-1
  - First Fedora version.
