package GCPlugins::GCDVDPost;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;
use utf8;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginDVDPost;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if (($attr->{href} =~ /^product_info\.php\?products_id=/))
                {
                    my $url = $attr->{href};
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
			    if ($attr->{src} =~ /http:\/\/images\.dvdpost\.be\/\/dvd/)
				{
                    $self->{curInfo}->{image} = $attr->{src};
				}
				elsif ($self->{insideAge})
				{
				    (my $fileName = $attr->{src}) =~ s|.+/([^/]+)$|$1|;
   				    $self->{curInfo}->{age} = 2 if $fileName eq 'all.gif';
   				    $self->{curInfo}->{age} = 12 if $fileName eq '-12.gif';
				    $self->{curInfo}->{age} = 16 if $fileName eq '-16.gif';
				    $self->{insideAge} = 0;
				}
            }
            elsif ($tagname eq "table")
            {
                if (($attr->{cellpadding} eq "0") && ($attr->{cellspacing} eq "0")
                && ($attr->{width} eq "100%") && ($attr->{border} ne "0"))
                {
					$self->{insideSynopsisFather} = 1;
				}
			}
            elsif ($tagname eq "td")
            {
              if ($attr->{style} eq "text-align:right;font-size:9px;color:gray")
            	{
            		$self->{insideType} = 1;
            	}
            	elsif (($attr->{class} eq "boxText") && $attr->{align} eq "left")
            	{
            		if ($self->{insideSynopsisFather} == 1)
            		{
            	  	    $self->{insideSynopsis} = 1;
            			$self->{insideSynopsisFather} = 0;
            		}
            		else
            		{
            			$self->{insideSynopsis} = 0;
            		}
            	}
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
			$self->{inside}->{$tagname}--;

    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
        }
        else
        {
			$origtext =~ s/\n*//g if !$self->{insideSynopsis};
			$origtext =~ s/\s{2,}//g;

						if ($self->{insideDate})
			{
					$self->{curInfo}->{date} = $origtext;
					$self->{insideDate} = 0;
			}
            elsif ($self->{insideDirector})
            {
				$origtext =~ s/ ,/, /g;
				$origtext =~ s/^(.*), /$1/;
                $self->{curInfo}->{director} = $origtext if !$self->{curInfo}->{director};
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
								$self->{insideSynopsis} = 0;
            }
            elsif ($self->{insideNat})
            {
                $self->{curInfo}->{nat} = $origtext;
								$self->{insideNat} = 0;
            }
            elsif ($self->{insideTime})
            {
                $self->{curInfo}->{time} = $origtext . " min";
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideActors})
            {
				$origtext =~ s/ ,/, /g;
				$origtext =~ s/^(.*), /$1/;
                $self->{curInfo}->{actors} = $origtext if !$self->{curInfo}->{actors};
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideOrig})
            {
                $self->{curInfo}->{orig} = $origtext if !$self->{curInfo}->{orig};
                $self->{insideOrig} = 0;
            }
			elsif ($self->{inside}->{b})
			{
                $self->{insideDirector} = 1 if $origtext =~ m/R.alisateur/;
                $self->{insideTime} = 1 if $origtext =~ m/Dur.e/;
                $self->{insideActors} = 1 if $origtext =~ m/Acteurs/;
                $self->{insideAge} = 1 if $origtext =~ m/Public/;
            }
    		elsif ($self->{inside}->{table})
    		{
    			if ($origtext =~ /(.*) \( ([0-9]{4}) \)/)
    			{
    				$self->{curInfo}->{title} = $1 if !$self->{curInfo}->{title};
    				$self->{curInfo}->{date} = $2 if !$self->{curInfo}->{date};
    			}
    			elsif ($self->{insideType})
    			{
    				$origtext =~ s/\|/,/g;
    				$self->{curInfo}->{type} = $origtext;
    				$self->{insideType} = 0;
    			}
    		}
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html =~ s/&nbsp;/ /g;
        $html =~ s/<u>|<\/u>//g;
        $html =~ s/<a href="directors\.php\?directors\_id=[0-9]*">([^<]*)<\/a>/$1/gi;
        $html =~ s/<a href="actors\.php\?actors\_id=[0-9]*">([^<]*)<\/a>/$1/gi;
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
			return "http://www.dvdpost.be/advanced_search_result2.php?language=fr&keywords=$word";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
		return "http://www.dvdpost.be/" . $url . "&language=fr" unless $url eq '';
		return "http://www.dvdpost.be/";
    }

    sub getName
    {
        return "DVDPost.be";
    }
    
    sub getImageFile
    {
        return "dvdpost.png";
    }
    
    sub getAuthor
    {
        return 'MeV';
    }
    
    sub getLang
    {
        return 'FR';
    }

    sub hasSearchYear
    {
        return 0;
    }

    sub hasSearchDirector
    {
        return 0;
    }

    sub hasSearchActors
    {
        return 0;
    }
}

1;
