# -*- encoding: utf-8 -*-
#
#   Hidden Menu - Epiphany Extension
#   Copyright © 2006, 2008  Diego Escalante Urrelo <diegoe@gnome.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along
#   with this program; if not, write to the Free Software Foundation, Inc.,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import epiphany
import gtk, gconf

# Now with ross-style (check http://www.burtonini.com for ephydeli)
HIDDENMENU_KEY = '/apps/epiphany-extensions/hiddenmenu/hidden'
EGG_TB_MODEL_NAME_KNOWN = 1 << 2

class HiddenMenuExtension(object):
	def __init__(self):		
		shell = epiphany.ephy_shell_get_default()
		model = shell.get_toolbars_model(False)
		flags = model.get_name_flags('HideMenu')
		model.set_name_flags('HideMenu', flags | EGG_TB_MODEL_NAME_KNOWN)
		
		self.client = gconf.client_get_default ();
		self.mb_hidden = self.client.get_bool(HIDDENMENU_KEY)

		if self.client.key_is_writable(HIDDENMENU_KEY):
			self.gconf = True
		else:
			self.gconf = False
			del self.client

	def attach(self, window):
		actions = [('HideMenu', gtk.STOCK_GO_DOWN, 'Hi_de menubar',
					 None, 'Toggle menubar visibility', self._hmb_activate_cb)]
		group = self._find_group(window)
		group.add_actions(actions, window)
		window._mb_visible = self.mb_hidden

	def detach(self, window):
		if self.gconf:
			self.client.set_bool(HIDDENMENU_KEY, window._mb_visible)
	
	# Not supported yet in Epiphany
	def finalize(self):
		shell = epiphany.ephy_shell_get_default()
		model = shell.get_toolbars_model(False)
		name_flags = model.get_name_flags('HideMenu')
		model.set_name_flags('HideMenu', name_flags & ~EGG_TB_MODEL_NAME_KNOWN)
		
	def _find_group(self, window):
		for group in window.get_ui_manager().get_action_groups():
			if group.get_name() == 'SpecialToolbarActions':
				return group
		else:
			raise AssertionError('Cannot find SpecialToolbarActions group')
	
	def _toggle_visible(self, menubar):
		if menubar.parent.parent.parent._mb_visible:
			menubar.hide()
		else:
			menubar.show()
	
	def _hmb_activate_cb(self, action, window):
		menubar = window.get_child().get_children()[0].get_children()[0]
		window._mb_visible = self.mb_hidden = not window._mb_visible
		self._toggle_visible(menubar)

hm = HiddenMenuExtension()

def attach_window(window):
	hm.attach(window)
	window.hm_started = False

def attach_tab(window, tab):
	if not window.hm_started:
		menubar = window.get_child().get_children()[0].get_children()[0]
		hm._toggle_visible(menubar)
		window.hm_started = True

def detach_window(window):
	hm.detach(window)
