#!/bin/sh
#
# Copyright (c) 2008  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Ringlet: t/06-get-default.t 2728 2008-10-14 10:40:35Z roam $

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

T1="$TESTDIR/t1.ini"
T2="$TESTDIR/t2.ini"

echo '1..5'

if [ ! -f "$T1" ]; then
	echo "Bail out!  No test file $T1"
	exit 255
fi
if [ ! -f "$T2" ]; then
	echo "Bail out!  No test file $T2"
	exit 255
fi

v=`$CONFGET -f "$T1" key1`
if [ "$v" = 'value1' ]; then echo 'ok 1'; else echo "not ok 1 v is '$v'"; fi
v=`$CONFGET -f "$T1" key4`
if [ "$v" = '' ]; then echo 'ok 2'; else echo "not ok 2 v is '$v'"; fi
v=`$CONFGET -f "$T1" key6`
if [ "$v" = 'value6' ]; then echo 'ok 3'; else echo "not ok 3 v is '$v'"; fi
v=`$CONFGET -f "$T2" key1`
if [ "$v" = '1' ]; then echo 'ok 4'; else echo "not ok 4 v is '$v'"; fi
v=`$CONFGET -f "$T2" key1 key2 | tr "\n" ' '`
if [ "$v" = 'key1=1 key2=2 ' ]; then echo 'ok 5'; else echo "not ok 5 v is '$v'"; fi
