#!/bin/sh
#
# Copyright (c) 2008  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Ringlet: t/02-check-values.t 2801 2008-10-25 17:31:46Z roam $

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

T1="$TESTDIR/t1.ini"

echo '1..15'

if [ ! -f "$T1" ]; then
	echo "Bail out!  No test file $T1"
	exit 255
fi

if $CONFGET -f "$T1" -s a -c key1; then echo 'ok 1 '; else echo "not ok 1 $?"; fi
if $CONFGET -f "$T1" -s a -c key2; then echo 'ok 2 '; else echo "not ok 2 $?"; fi
if $CONFGET -f "$T1" -s a -c key3; then echo 'ok 3 '; else echo "not ok 3 $?"; fi
if ! $CONFGET -f "$T1" -s a -c key4; then echo 'ok 4 '; else echo "not ok 4 $?"; fi
if ! $CONFGET -f "$T1" -s b -c key5; then echo 'ok 5 '; else echo "not ok 5 $?"; fi
if $CONFGET -f "$T1" -s b -c key4; then echo 'ok 6 '; else echo "not ok 6 $?"; fi
if $CONFGET -f "$T1" -s c -c key5; then echo 'ok 7 '; else echo "not ok 7 $?"; fi

QUERY_STRING='key1=value1&key2=%3Dvalue2%26&amp;key3=%09%09%20val%27ue3'
Q1='key4&amp;key5=%09%09%20val%27ue5&key6'
Q2=''
export QUERY_STRING Q1 Q2

if $CONFGET -t http_get -c key1; then echo 'ok 8 '; else echo "not ok 8 $?"; fi
if $CONFGET -t http_get -c key2; then echo 'ok 9 '; else echo "not ok 9 $?"; fi
if $CONFGET -t http_get -c key3; then echo 'ok 10 '; else echo "not ok 10 $?"; fi
if $CONFGET -t http_get -s Q1 -c key4; then echo 'ok 11 '; else echo "not ok 11 $?"; fi
if $CONFGET -t http_get -s Q1 -c key6; then echo 'ok 12 '; else echo "not ok 12 $?"; fi
if ! $CONFGET -t http_get -c key6; then echo 'ok 13 '; else echo "not ok 13 $?"; fi
if ! $CONFGET -t http_get -s Q1 -c key1; then echo 'ok 14 '; else echo "not ok 14 $?"; fi
if ! $CONFGET -t http_get -s Q2 -c key1; then echo 'ok 15 '; else echo "not ok 15 $?"; fi
