(* $Id: uReStr.mli,v 1.5 2003/12/19 17:24:34 yori Exp $ *)
(* Copyright 2003 Yamagata Yoriyuki. distributed with LGPL *)

(** Module for a Str-like regular expression syntax.
   The difference can be summarised as follows.
   - Non-ASCII characters can be used if encoded by UTF-8, or
   using the escape syntax \u<code number as hex digits>.
   - Each Unicode character is treated as a single character.
   - Character properties like Lu ({!UCharInfo.general_category_type}),
   White_Space ({!UCharInfo.character_property_type}),
   Ogham ({!UCharInfo.script_type}) can be used in character sets. e.g.
   \[\{Lu & ID_Start\}\]\[\{ID_Continue\}\]* (capitalised identifier),
   \(\[\{Han\}\]+\|\[\{Katakana\}\]+\)\[\{Hiragana\}\]* 
   (Japanese word component).
   Boolean notations as | (or) :, & (and) - (set subtraction) can be used
   in \{...\} notations.  Any is used to denote the set of all characters
   in \{...\} notations.

*)

type regexp = URe.regexp

(** Theses functions are similar to Str. *)

val regexp : string -> regexp
val quote : string -> string
val regexp_string : string -> regexp

(** Theses are aliases of those of {!URe}.*)

module type Type = URe.Type

module Make : functor (Text : UnicodeString.Type) ->
  Type with type text = Text.t and type index = Text.index
