//
//  Copyright 1999, 2000 Gregory Colvin
//  All Rights Reserved.
//

#include <assert.h>
#include <vector>
#include <list>
#include <algorithm>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <typeinfo>
#include <boost/smart_ptr.hpp>
#include "linked_ptr.hpp"
#include "fast_shared_ptr.hpp"
#include "shared_in_ptr.hpp"
#include "cyclic_ptr.hpp"
#include "cyclic_ptr.cpp"



class B : public boost::shared_in_base<std::size_t>
{
public:

   B() : val( rand() ) {}
   bool operator<( const B & other ) const { return val < other.val; }

private:

   int val;
};



using namespace std;
using namespace boost;


int main(int argc, char** argv) {
   srand( (unsigned)time( NULL ) );
   const int N = 300000;
   //const int N = atoi(argv[1]);

   typedef B* ptr_int;
   //typedef shared_ptr<B> ptr_int;
   //typedef fast_shared::shared_ptr<B> ptr_int;
   //typedef smart_pointers::linked_ptr<B> ptr_int;
   //typedef boost::cyclic_ptr<B> ptr_int;
   //typedef boost::shared_in_ptr<B> ptr_int;

   printf( "Testing %s\n", typeid(ptr_int).name() );

   {  clock_t start = clock();
      vector<ptr_int> container;
      for (int i = 0; i < N; i++ )
         container.push_back(ptr_int(new B()));
      printf("fill vector: %ld\n",(long)clock() - start);
      sort(container.begin(), container.end());
      printf("sort vector: %ld\n",(long)clock() - start);
   }
   {  clock_t start = clock();
      list<ptr_int> container;
      for (int i = 0; i < N; i++ )
         container.push_back(ptr_int(new B()));
      printf("fill list: %ld\n",(long)clock() - start);
      container.sort();
      printf("sort list: %ld\n",(long)clock() - start);
   }
   return 0;
}
