// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __sb_string_h__
#define __sb_string_h__

#include "Puma/ScanBuffer.h"

namespace Puma {


class SB_String : public ScanBuffer {
  const char *string;
  const char *TokenBuffer;
  const char *end;
  int  BuffPos;

public:
  void init (const char *str, int len = 0) {
    string = str; end = str + (len ? len : strlen (str)); reset (); 
  }

  char next () { return TokenBuffer[BuffPos++]; }
  char *token () { return (char*)TokenBuffer; }
  int len () const { return BuffPos; }
  void reset () { TokenBuffer = string; BuffPos = 0; }
  void retry () { BuffPos = 0; }
  void accept (int len) { BuffPos = 0; TokenBuffer += len; }
  void more (int len) { BuffPos = len; }
  State state () const { return  (TokenBuffer + BuffPos == end) ? STATE_END : STATE_OK; }
};


} // namespace Puma

#endif /* __sb_string_h__ */
