// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CArgumentInfo_h__
#define __CArgumentInfo_h__

// function parameter info

#include "Puma/CScopeRequest.h"

namespace Puma {


/** \file 
 *  Representation of a function parameter.
 *  \see Puma::CArgumentInfo */

/** \class CArgumentInfo CArgumentInfo.h Puma/infos/CArgumentInfo.h
 *  A CArgumentInfo object represents a function parameter declaration. */
class CArgumentInfo : public CScopeRequest {
  bool _hasDefaultArg; // can be set to true even without an init tree
                       // (needed for inline member functions)
public: 
  /** Construct a function parameter info. */
  CArgumentInfo ();
  /** Destruct the function parameter info. If the object id is 
   *  \c ARGUMENT_INFO, Puma::CObjectInfo::CleanUp() is called. */
  ~CArgumentInfo ();

  /** Get the default argument of the parameter.
   *  \return The syntax tree node of the default argument or
   *          \c NULL if parameter has no default argument. */
  CT_ExprList *Init () const;
  /** Return \e true if the parameter has a default argument. */
  bool hasDefaultArg () const;  
  /** Set whether the parameter has a default argument. */
  void hasDefaultArg (bool);  
};

inline CArgumentInfo::CArgumentInfo () :
  CScopeRequest (CObjectInfo::ARGUMENT_INFO), _hasDefaultArg (false)
 {}

inline bool CArgumentInfo::hasDefaultArg () const
 { return (_hasDefaultArg || Init ()); }

inline void CArgumentInfo::hasDefaultArg (bool has_arg)
 { _hasDefaultArg = has_arg; }

} // namespace Puma

#endif /* __CArgumentInfo_h__ */
