// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/CRecord.h"
#include "Puma/CClassInfo.h"
#include "Puma/CUnionInfo.h"
#include "Puma/CFunctionInfo.h"
#include "Puma/CTemplateInfo.h"
#include "Puma/CTree.h"
#include "Puma/CClassDatabase.h"
#include <string.h>

namespace Puma {


CRecord::~CRecord () {
////  for (unsigned i = 0; i < Users (); i++) 
////    User (i)->removeType (this);
//  CScopeInfo *parent = Parent ();
//  if (parent && parent->Structure ())
//    parent->Structure ()->removeType (this);
//  if (AssignedScope ())
//    AssignedScope ()->removeType (this);
//  if (_TemplateInfo)
//    _TemplateInfo->ObjectInfo ((CObjectInfo*)0);
}

//CObjectInfo *CRecord::Referer (const char *name) const { 
//  for (unsigned i = 0; i < Referers (); i++) 
//    if (! strcmp (Referer (i)->Name (), name)) 
//      return Referer (i);
//  return (CObjectInfo*)0;
//}
//
//CObjectInfo *CRecord::Usage (const char *name) const { 
//  for (unsigned i = 0; i < Usages (); i++) 
//    if (! strcmp (Usage (i)->Name (), name)) 
//      return Usage (i);
//  return (CObjectInfo*)0;
//}
//
//CFunctionInfo *CRecord::Transferer (const char *name) const { 
//  for (unsigned i = 0; i < Transferers (); i++) 
//    if (! strcmp (Transferer (i)->Name (), name)) 
//      return Transferer (i);
//  return (CFunctionInfo*)0;
//}
//
//CObjectInfo *CRecord::Transfer (const char *name) const { 
//  for (unsigned i = 0; i < Transfers (); i++) 
//    if (! strcmp (Transfer (i)->Name (), name)) 
//      return Transfer (i);
//  return (CObjectInfo*)0;
//}
//
//void CRecord::addReferer (CObjectInfo *info) { 
//  for (unsigned i = 0; i < Referers (); i++) 
//    if (Referer (i) == info) 
//      return;
//  _Referer.append (info); 
//}
//
//void CRecord::addUsage (CObjectInfo *info) { 
//  for (unsigned i = 0; i < Usages (); i++) 
//    if (Usage (i) == info) 
//      return;
//  _Used.append (info); 
//}
//
//void CRecord::addTransferer (CFunctionInfo *info) { 
//  for (unsigned i = 0; i < Transferers (); i++) 
//    if (Transferer (i) == info) 
//      return;
//  _Transferer.append (info); 
//}
//
//void CRecord::addTransfer (CObjectInfo *info) { 
//  for (unsigned i = 0; i < Transfers (); i++) 
//    if (Transfer (i) == info) 
//      return;
//  _Transfered.append (info); 
//}
//
//void CRecord::removeReferer (const CObjectInfo *info) { 
//  for (unsigned i = 0; i < Referers (); i++) 
//    if (Referer (i) == info) {
//      _Referer.remove (i); 
//      break;
//    }
//}
//
//void CRecord::removeUsage (const CObjectInfo *info) { 
//  for (unsigned i = 0; i < Usages (); i++) 
//    if (Usage (i) == info) {
//      _Used.remove (i); 
//      break;
//    }
//}
//
//void CRecord::removeTransferer (const CFunctionInfo *info) { 
//  for (unsigned i = 0; i < Transferers (); i++) 
//    if (Transferer (i) == info) {
//      _Transferer.remove (i); 
//      break;
//    }
//}
//
//void CRecord::removeTransfer (const CObjectInfo *info) { 
//  for (unsigned i = 0; i < Transfers (); i++) 
//    if (Transfer (i) == info) {
//      _Transfered.remove (i); 
//      break;
//    }
//}
//
//bool CRecord::isReferer (const CObjectInfo *info) const { 
//  for (unsigned i = 0; i < Referers (); i++) 
//    if (Referer (i) == info)
//      return true;
//  return false;
//}
//
//bool CRecord::isUsed (const CObjectInfo *info) const { 
//  for (unsigned i = 0; i < Usages (); i++) 
//    if (Usage (i) == info)
//      return true;
//  return false;
//}
//
//bool CRecord::isTransferer (const CFunctionInfo *info) const { 
//  for (unsigned i = 0; i < Transferers (); i++) 
//    if (Transferer (i) == info)
//      return true;
//  return false;
//}
//
//bool CRecord::isTransfered (const CObjectInfo *info) const { 
//  for (unsigned i = 0; i < Transfers (); i++) 
//    if (Transfer (i) == info)
//      return true;
//  return false;
//}

bool CRecord::isComplete (unsigned long pos) const {
  CRecord *info = (CRecord*)DefObject ();
  if (info->isDefined ()) { 
    if (pos == 0)
      return true;
    CT_Token *token = info->Tree ()->token_node ();
    if (token && token->Number () <= pos)
      return true;
  }
  return false;
}

bool CRecord::isDefined () const { 
  return Tree () && (Tree ()->NodeName () == CT_ClassDef::NodeId () ||
                     Tree ()->NodeName () == CT_UnionDef::NodeId ()); 
}


} // namespace Puma
