#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_CProject_cc__
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_

#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            


#ifndef __ac_fwd_WinIfExists__
#define __ac_fwd_WinIfExists__
class WinIfExists;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinIfExists_WinIfExists_a0_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#endif

#ifndef __ac_fwd_WinImportHandler__
#define __ac_fwd_WinImportHandler__
class WinImportHandler;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinImportHandler_WinImportHandler_a0_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#endif

#ifndef __ac_fwd_PragmaOnce__
#define __ac_fwd_PragmaOnce__
class PragmaOnce;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif

#ifndef __ac_fwd_WinMacros__
#define __ac_fwd_WinMacros__
class WinMacros;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinMacros_WinMacros_a0_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinIfExists__
#define __WinIfExists__

/********************************************************/
/* Win __if_exists and __if_not_exists support aspect   */
/********************************************************/

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __stack_h__
#define __stack_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __array_h__
#define __array_h__

#include <assert.h>

namespace Puma {

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class Item>
class Array {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

   protected:
      static const long default_init_size = 5;
      static const long default_increment = 5;

   public:
      Array (long is = default_init_size, long incr = default_increment);
      Array (const Array<Item>& array);
      Array<Item>& operator =(const Array<Item>&);
      ~Array ();
      void append (const Item& item);
      void insert (long index, const Item& item);
      void prepend (const Item& item);
      void remove (long index);
      void reset ();
      Item& get (long index);
      Item& operator[] (long index);
      Item fetch (long index) const;
      Item& lookup (long index) const;
      long length () const;

   private:
      Item* data;
      long size;
      long count;
      long increment;
      
      void check (long wanted);
 };

template <class Item>
inline Array<Item>::Array (long is, long incr)
 {
   count     = 0; 
   size      = is;
   increment = incr;
   data      = new Item[size];
 }

template <class Item>
Array<Item>::Array (const Array<Item>& array)
 {
   count = 0;
   size  = array.size;
   data  = new Item[size];
   increment = array.increment;

   for (int pos = 0; pos < array.length (); pos++)
      append (array.lookup (pos));
 }

template <class Item>
Array<Item>& Array<Item>::operator =(const Array<Item>& array)
 {
   if (data)
      delete[] data;
   count = 0;
   size  = array.size;
   data  = new Item[size];
   increment = array.increment;

   for (int pos = 0; pos < array.length (); pos++)
      append (array.lookup (pos));
   return *this;
 }

template <class Item>
Array<Item>::~Array ()
 {
   if (data)
      delete[] data;
 }

template <class Item>
inline void Array<Item>::check (long wanted)
 {
   if (wanted >= size)
    {
      Item* new_data;

      while (wanted >= size)
      {
         size += increment;
         increment*=2;
      }
      new_data = new Item[size];
      for (int pos = 0; pos < count; pos++)
         new_data[pos] = data[pos];
      delete[] data;
      data = new_data;
    }
 }
   
template <class Item>
inline void Array<Item>::append (const Item& item)
 {
   check (count);
   data[count++] = item;
 }

template <class Item>
void Array<Item>::prepend (const Item& item)
 {
   insert (0, item);
 }

template <class Item>
void Array<Item>::insert (long index, const Item& item)
 {
   check (count);
   for (int pos = count; pos > index; pos--)
      data[pos] = data[pos - 1];
   data[index] = item;
   count++;
 }

template <class Item>
inline Item& Array<Item>::get (long index)
 {
   check (index);
   if (index >= count)
      count = index + 1;
   return data[index];
 }

template <class Item>
inline Item& Array<Item>::operator[] (long index)
 {
   return get (index);
 }

template <class Item>
inline Item Array<Item>::fetch (long index) const
 {
   assert(index < count);
   return data[index];
 }

template <class Item>
inline long Array<Item>::length () const
 {
   return count;
 }

template <class Item>
inline void Array<Item>::remove (long index)
 {
   if (index < count && count > 0)
    {
      for (int pos = index; pos < count - 1; pos++)
         data[pos] = data[pos + 1];
      count--;
    }
 }

#ifndef __puma
template <>
inline void Array<int>::reset () {
   count = 0; 
}
#endif

template <class Item>
void Array<Item>::reset ()
 {
   if (data)
      delete[] data;
   count     = 0; 
   size      = default_init_size;
   increment = default_increment;
   data      = new Item[size];
 }

template <class Item>
inline Item& Array<Item>::lookup (long index) const
 {
   assert(index >= 0 && index < count);
//   if (index >= count) index = count - 1; 
//   if (index < 0)      index = 0;
   return data[index];
 }


} // namespace Puma

// Array specialization for pointer types sharing method definitions

#ifndef __puma

#include "Puma/VoidPtrArray.h"

namespace Puma {


template <class Item>
class Array<Item*> : private VoidPtrArray {
  typedef VoidPtrArray Base;

public:
  Array (long is = default_init_size, long incr = default_increment) :
    Base (is, incr) {}
  Array (const Array<Item*> &array) : 
    Base (array) {}
  Array<Item*> &operator= (const Array<Item*> &array) 
   { return (Array<Item*>&)Base::operator= (array); }

  ~Array () {}

  void append (const Item *item)           { Base::append ((void*)item); }
  void insert (long idx, const Item *item) { Base::insert (idx, (void*)item); }
  void prepend (const Item *item)          { Base::prepend ((void*)item); }
  void remove (long idx)                   { Base::remove (idx); }
  void reset ()                            { Base::reset (); }

  Item *&get (long idx)          { return (Item*&)Base::get (idx); }
  Item *&operator[] (long idx)   { return (Item*&)Base::operator[] (idx); }
  Item *fetch (long idx) const   { return (Item*)Base::fetch (idx); }
  Item *&lookup (long idx) const { return (Item*&)Base::lookup (idx); }
  long length () const           { return Base::length (); }
};


} // namespace Puma

#endif /* __puma */

#endif /* __array_h__ */
namespace Puma {

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class Item>
class Stack : private Array<Item> {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  Stack (long is = 8192, long incr = 8192) :
    Array<Item> (is, incr) {}
  void push (Item f) { Array<Item>::append (f); }
  Item &top () const { long len = Array<Item>::length ()-1; 
                       return Array<Item>::lookup (len >= 0 ? len : 0); }
  void pop () { Array<Item>::remove (Array<Item>::length () - 1); }
  long length () const { return Array<Item>::length (); }
  void reset () { Array<Item>::reset (); }
};

} // namespace Puma

#endif /* __stack_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __C_TOKENS__
#define __C_TOKENS__

namespace Puma {

enum CTokens {

  // core tokens, i.e. numbers, operator symbols, brackets, etc.
  TOK_AT = 100,
  TOK_ZERO_VAL,
  TOK_INT_VAL,
  TOK_FLT_VAL,
  TOK_COMMA,
  TOK_ASSIGN,
  TOK_QUESTION,
  TOK_OR,
  TOK_ROOF,
  TOK_AND,
  TOK_PLUS,
  TOK_MINUS,
  TOK_MUL,
  TOK_DIV,
  TOK_MODULO,
  TOK_LESS,
  TOK_GREATER,
  TOK_OPEN_ROUND,
  TOK_CLOSE_ROUND,
  TOK_OPEN_SQUARE,
  TOK_CLOSE_SQUARE,
  TOK_OPEN_CURLY,
  TOK_CLOSE_CURLY,
  TOK_SEMI_COLON,
  TOK_COLON,
  TOK_NOT,
  TOK_TILDE,
  TOK_DOT,
  TOK_MUL_EQ,
  TOK_DIV_EQ,
  TOK_MOD_EQ,
  TOK_ADD_EQ,
  TOK_SUB_EQ,
  TOK_LSH_EQ,
  TOK_RSH_EQ,
  TOK_AND_EQ,
  TOK_XOR_EQ,
  TOK_IOR_EQ,
  TOK_OR_OR,
  TOK_AND_AND,
  TOK_EQL,
  TOK_NEQ,
  TOK_LEQ,
  TOK_GEQ,
  TOK_LSH,
  TOK_RSH,
  TOK_DOT_STAR,
  TOK_PTS_STAR,
  TOK_INCR,
  TOK_DECR,
  TOK_PTS,
  TOK_COLON_COLON,
  TOK_ELLIPSIS,
  TOK_LAST_CORE = TOK_ELLIPSIS, // this is a group separator for the scanner!
  
  // C keywords:
  TOK_ASM,
  TOK_AUTO,
  TOK_BREAK,
  TOK_CASE,
  TOK_CHAR,
  TOK_CONST,
  TOK_CONTINUE,
  TOK_DEFAULT,
  TOK_DO,
  TOK_DOUBLE,
  TOK_ELSE,
  TOK_ENUM,
  TOK_EXTERN,
  TOK_FLOAT,
  TOK_FOR,
  TOK_GOTO,
  TOK_IF,
  TOK_INLINE,
  TOK_INT,
  TOK_LONG,
  TOK_REGISTER,
  TOK_RESTRICT,
  TOK_RETURN,
  TOK_SHORT,
  TOK_SIGNED,
  TOK_SIZEOF,
  TOK_STATIC,
  TOK_STRUCT,
  TOK_SWITCH,
  TOK_TYPEDEF,
  TOK_UNION,
  TOK_UNSIGNED,
  TOK_VOID,
  TOK_VOLATILE,
  TOK_WCHAR_T,
  TOK_WHILE,

  // C compatibility keywords

  TOK_ASM_2,
  TOK_ASM_3,
  TOK_BOOL_2,
  TOK_CONST_2,
  TOK_CONST_3,
  TOK_INLINE_2,
  TOK_INLINE_3,
  TOK_RESTRICT_2,
  TOK_RESTRICT_3,
  TOK_SIGNED_2,
  TOK_SIGNED_3,
  TOK_VOLATILE_2,
  TOK_VOLATILE_3,
  TOK_WCHAR_T_2,
  TOK_TYPEOF,
  TOK_TYPEOF_2,
  TOK_TYPEOF_3,

  // C win specific keywords

  TOK_INT64,
  TOK_CDECL,
  TOK_CDECL_2,
  TOK_STDCALL,
  TOK_STDCALL_2,
  TOK_FASTCALL,
  TOK_FASTCALL_2,
  TOK_IF_EXISTS,
  TOK_IF_NOT_EXISTS,

  TOK_LAST_C = TOK_IF_NOT_EXISTS,
  
  // a boolean constant:
  TOK_BOOL_VAL,

  // C++ keywords:

  TOK_BOOL,
  TOK_CATCH,
  TOK_CLASS,
  TOK_CONST_CAST,
  TOK_DELETE,
  TOK_DYN_CAST,
  TOK_EXPLICIT,
  TOK_EXPORT,
  TOK_FRIEND,
  TOK_MUTABLE,
  TOK_NAMESPACE,
  TOK_NEW,
  TOK_OPERATOR,
  TOK_PRIVATE,
  TOK_PROTECTED,
  TOK_PUBLIC,
  TOK_REINT_CAST,
  TOK_STAT_CAST,
  TOK_TEMPLATE,
  TOK_THIS,
  TOK_THROW,
  TOK_TRY,
  TOK_TYPEID,
  TOK_TYPENAME,
  TOK_USING,
  TOK_VIRTUAL,

  // C++ alternative representation of operators (ISO 646):

  TOK_AND_AND_ISO_646,
  TOK_AND_EQ_ISO_646,
  TOK_AND_ISO_646,
  TOK_OR_ISO_646,
  TOK_TILDE_ISO_646,
  TOK_NOT_ISO_646,
  TOK_NEQ_ISO_646,
  TOK_OR_OR_ISO_646,
  TOK_IOR_EQ_ISO_646,
  TOK_ROOF_ISO_646,
  TOK_XOR_EQ_ISO_646,

  TOK_LAST_CC = TOK_XOR_EQ_ISO_646,
  
  // AspectC++ keywords:

  TOK_POINTCUT,
  TOK_ASPECT,
  TOK_ADVICE,
  TOK_SLICE,
  TOK_UNKNOWN_T,

  TOK_LAST_AC = TOK_UNKNOWN_T,
  
  // further [A](C|C++) token
  TOK_STRING_VAL,
  TOK_CHAR_VAL,
  TOK_ID,

  // These two always have to be the ** last ** token listed here!!!
  TOK_EPSILON,
  TOK_NO
  
};

} // namespace Puma

#endif /* __C_TOKENS__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Token_h__
#define __Token_h__

// Abstract interface of a language token. A token is created by an
// invocation of a scanner's 'scan' method. The token encapsulates a
// lexical unit of the scanned text.

#include <stdlib.h>
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __language_id_h__
#define __language_id_h__

// A language ID is a unique identifier for a language

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class LanguageID {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_id;

public:
  LanguageID () : _id ((const char*)0) {}
  LanguageID (const char *id) : _id (id) {}
  operator const char *() const { return _id; }
  bool operator == (const LanguageID &id) const
   { return _id == (const char*)id; }
};


} // namespace Puma

#endif /* __language_id_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_h__
#define __location_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __smart_ptr_h__
#define __smart_ptr_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ref_cnt_h__
#define __ref_cnt_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _counter;

public:
  RefCnt () : _counter (0) {}
  virtual ~RefCnt () {}
  
  void ref () { _counter++; }
  void deref () { _counter--; }
  int counter () { return _counter; }
};


} // namespace Puma

#endif /* __ref_cnt_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SmartPtr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  RefCnt *_data;

public:
  SmartPtr () : _data ((RefCnt*)0) {}
  ~SmartPtr () { clear (); }
  SmartPtr (const SmartPtr &copy);
  SmartPtr (RefCnt *rc) : _data (rc) {}
  SmartPtr &operator = (const SmartPtr &copy);

  void data (RefCnt *d);
  void clear ();
  RefCnt *data () const { return _data; }
  bool is_defined () const { return _data != (RefCnt*)0; }
};


} // namespace Puma

#endif /* __smart_ptr_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __printable_h__
#define __printable_h__

#include <iostream>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~Printable () {}
  virtual void print (ostream &os) const = 0;
};


inline ostream &operator << (ostream &os, const Printable &object) {
  object.print (os);
  return os;
}


} // namespace Puma

#endif /* __printable_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_info_h__
#define __location_info_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_h__
#define __filename_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_info_h__
#define __filename_info_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __DString_h__
#define __DString_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashTable_h__
#define __StrHashTable_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashKey_h__
#define __StrHashKey_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __str_col__
#define __str_col__

// Collection of functions handling strings.

namespace Puma {


class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrCol {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  StrCol () {}
        
public:
  // Return true if c is a white space character.
  static bool isSpace (const char c);

  // Return true if the string consists only of spaces.
  static bool onlySpaces (const char *);

  // Return true if the two strings differ not only in spaces.
  static bool effectivelyDifferent (const char *, const char *);

  // Build a string from a unit.
  static char *buildString (Unit *);
        
  // Duplicate a string
  static char *dup (const char *);
  static char *dup (const char *, int);
};


} // namespace Puma

#endif /* __str_col__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Chain_h__
#define __Chain_h__

//
// implements a simple chain
// 

#ifndef __puma
#include <iostream>
using namespace std;
#endif 

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Chain *next;

public:
  Chain () { next = 0; }
   
  void select (Chain *c) { next = c; }
  Chain *select () const { return next; }

  Chain *unlink () {
    Chain *res = next;
    if (next) {
      next = next->select ();
    }
    return res;
  }

  void insert (Chain *c) {
    c->select (next);
    next = c;
  }
};

#ifndef __puma


//
// Chain with useage/max counter
// 

class ChainCnt : public Chain {
  const char* name;

public:
  long long max, use;
  
  ChainCnt (const char *n) : name (n) { max = use = 0; }
  ~ChainCnt () {
    cout << "max list " << name << ": " << max << endl;
  }

  Chain *unlink () {
    Chain *c = Chain::unlink ();
    if (c) 
      use--;
    return c;
  }
  
  void insert (Chain *c) {
    use++;
    if(use > max) 
      max = use;
    Chain::insert (c);
  }
};

#endif /* __puma */


} // namespace Puma

#endif /* __Chain_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrHashKey : public Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  unsigned int m_Magic;
  unsigned int m_Len;
  const char  *m_Str;

  StrHashKey () : m_Len (0), m_Str (0) {}

public:
  StrHashKey (int m, const char *s, int l) : 
    m_Magic (m), m_Len (l), m_Str (StrCol::dup (s, l)) {}

  unsigned int getMagic () const { return m_Magic; }
  unsigned int length () const { return m_Len; }
  const char  *c_str () const { return m_Str; }
};


} // namespace Puma

#endif /* __StrHashKey_h__ */
#include <assert.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrHashTable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  StrHashKey *_emptyKey;

public:
  StrHashTable () {
    _emptyKey = insert ("");
    assert (_emptyKey);
  }

  StrHashKey *empty () const { assert (_emptyKey); return _emptyKey; }
  StrHashKey *insert (const char *);
  void remove (StrHashKey *);

  enum { STRHASHTABLE_SIZE=0xffff };
  
private:
  Chain m_Table[STRHASHTABLE_SIZE];

  StrHashKey *find (unsigned int, const char *, unsigned int);
  unsigned int hash (const char *, unsigned int);
};


} // namespace Puma

#endif /* __StrHashTable_h__ */
#include <assert.h>

namespace Puma {


extern StrHashTable ___str_dict;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class DString {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  StrHashKey *m_Key;

public:
  DString () {
    m_Key = ___str_dict.empty ();
    assert (m_Key);
  }
  DString (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
  }
  DString (const DString &s) : m_Key (s.m_Key) {
    assert (s.m_Key);
  }
  
  DString &operator = (const DString &s) {
    assert (s.m_Key);
    m_Key = s.m_Key;
    return *this;
  }
  
  DString &operator = (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
    return *this;
  }

  bool operator == (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key == s.m_Key; 
  }
  bool operator != (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key != s.m_Key; 
  }

  const char *c_str() const { 
    assert (m_Key);
    return m_Key->c_str (); 
  }
  unsigned int length () const { 
    assert (m_Key);
    return m_Key->length (); 
  }
  bool empty () const {
    assert (m_Key);
    return m_Key->length () == 0;
  }
  unsigned int magic () const { 
    assert (m_Key);
    return m_Key->getMagic (); 
  }

  operator const char *() const {
    assert (m_Key);
    return c_str ();
  }
};


} // namespace Puma

#endif /* __DString_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FilenameInfo : public RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  DString _name;
  const char *_path;
  const char *_root;

public:
  FilenameInfo () : _path ((const char*)0), _root ((const char*)0) {}
  ~FilenameInfo ();
  void name (const char *n);
  void name (const DString &dsn) { _name = dsn; }
  const char *name () const { return _name.c_str (); }
  const char *path ();
  const char *root ();
  bool is_absolute () const;
  bool operator == (const FilenameInfo &rc) const {
    return _name == rc._name;
  }
};


} // namespace Puma

#endif /* __filename_info_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Filename : public SmartPtr, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  FilenameInfo *info () const { return (FilenameInfo*)data (); }

public:
  Filename () {}
  Filename (const char *n) { name (n); }
  Filename &operator = (const char *n) { name (n); return *this; }
  void name (const char *n);
  const char *name () const;
  const char *path () const;
  const char *root () const;
  bool is_absolute () const;
  bool operator == (const Filename &f) const;
  bool operator != (const Filename &f) const { return !(*this == f); }
  virtual void print (ostream &os) const { if (info ()) os << name (); }
};


} // namespace Puma

#endif /* __filename_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class LocationInfo : public RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Filename _filename;
  int _line;

public:
  LocationInfo () : _filename (), _line (0) {}
  void setup (Filename f, int l);
  const Filename &filename () const { return _filename; }
  int line () const { return _line; }
  bool operator < (const LocationInfo &l) const;
  bool operator == (const LocationInfo &l) const;
};


} // namespace Puma

#endif /* __location_info_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Location : public SmartPtr, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  LocationInfo *info () const { return (LocationInfo*)data (); }

public:
  Location () {}
  Location (Filename f, int l) { setup (f, l); }
  Location (LocationInfo *lptr) : SmartPtr (lptr) {}
  LocationInfo *operator ~ () { if (info ()) info ()->ref (); return info (); }
  void setup (Filename f, int l);
  const Filename &filename () const   { return info ()->filename (); }
  int line () const;
  bool operator == (const Location &l) const;
  bool operator != (const Location &l) const { return ! (*this == l); }
  bool operator < (const Location &l) const;

  virtual void print (ostream &os) const {
    if (info ())
#ifdef VISUAL_STUDIO
      os << filename () << "(" << line () << ")";
#else
      os << filename () << ":" << line ();
#endif
  }
};


} // namespace Puma

#endif /* __location_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_element_h__
#define __list_element_h__

// Base class for objects that may be inserted into a List. Lists
// autonomously delete or copy list element. So it's necessary to
// define a destructor and a duplicate method in the derived
// classes.

#include <assert.h>

namespace Puma {


class List;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ListElement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  friend class List;

  List        *_belonging_to;
  ListElement *_next;
  ListElement *_prev;

public:
  ListElement () : _belonging_to ((List*)0) {}
  virtual ~ListElement () { assert (! _belonging_to); };

  virtual ListElement *duplicate () = 0;
  List *belonging_to () const { return _belonging_to; }
};


} // namespace Puma

#endif /* __list_element_h__ */
#include <assert.h>
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Token : public ListElement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _type, _real_type;

  Location _location;
  LanguageID _language;
  DString _text;

  Array<int> *_cont_lines;
   
  enum TK_Flags {
          TK_COMMENT = (0x01 << 0),
          TK_CORE = (0x01 << 1),
          TK_MACRO_CALL = (0x01 << 2),
          TK_MACRO_GENERATED = (0x01 << 3)
  };
  unsigned short _flags;

public:
  enum {
    ID_END_OF_FILE = -1,
    ID_UNKNOWN = -2,
    ID_ERROR = -3,
    ID_WARNING = -4
  };

  static LanguageID comment_id, pre_id, dir_id, cpp_id, white_id, 
                    wildcard_id, keyword_id, open_id, macro_op_id,
                    identifier_id, comma_id, close_id;

public:
  Token (int = 0, LanguageID lang = LanguageID(0), const char * = "");
  Token (const Token &);
  virtual ~Token ();

//  virtual void print (ostream &) const;
  void print (ostream &) const;
  virtual ListElement *duplicate () { return new Token (*this); }

  void reset (int = 0, const char * = 0, LanguageID = LanguageID(0));
  
  void location (const Location &loc)      { _location = loc; }
  void cont_lines (Array<int> *cl)  { _cont_lines = cl; }
  int line_breaks () const;
  void macro_generated ()           { _flags |= TK_MACRO_GENERATED; }
  void macro_call ()                { _flags |= TK_MACRO_CALL; }
  
  const DString &text () const     { return _text; }
  char *get_static_text () const;
  int type () const                 { return _type; }
  const Location &location () const { return _location; }
   
  // functions to query token flags
  bool is_macro_generated () const  { return (_flags & TK_MACRO_GENERATED) != 0; }
  bool is_macro_call () const       { return (_flags & TK_MACRO_CALL) != 0; }
  bool is_core () const;
  bool is_identifier () const;    // subset of core
  bool is_keyword () const;       // subset of identifier
  bool is_wildcard () const;      // subset of core
  bool is_preprocessor () const;  // a preprocessor directive (include, etc.)
  bool is_directive () const;     // a compiler directive (pragma, line, etc.)
  bool is_whitespace () const;
  bool is_comment () const;
  bool is_macro_op () const;
  bool is_open () const;          // subset of core
  bool is_comma () const;         // subset of core
  bool is_close () const;         // subset of core

  void *operator new (size_t);
  void  operator delete (void *);

private:
  int get_general_type () const;
  LanguageID language () const { return _language; }
  void is_comment_internal ();
  void is_core_internal ();
};


inline void Token::is_core_internal () {
  if (_language == cpp_id || _language == wildcard_id || 
      _language == open_id || _language == comma_id || 
      _language == close_id || is_identifier ())
    _flags |= TK_CORE;
}
inline void Token::is_comment_internal () { 
  if (_language == comment_id) 
    _flags |= TK_COMMENT;
}

inline bool Token::is_core () const 
 { return (_flags & TK_CORE) != 0; }
inline bool Token::is_identifier () const 
 { return _language == identifier_id || is_keyword ();}
inline bool Token::is_keyword () const 
 { return _language == keyword_id; }
inline bool Token::is_wildcard () const 
 { return _language == wildcard_id; }
inline bool Token::is_preprocessor () const 
 { return _language == pre_id; }
inline bool Token::is_directive () const 
 { return _language == dir_id; }
inline bool Token::is_whitespace () const 
 { return _language == white_id; }
inline bool Token::is_comment () const 
 { return (_flags & TK_COMMENT) != 0; }
inline bool Token::is_macro_op () const 
 { return _language == macro_op_id; }
inline bool Token::is_open () const 
 { return _language == open_id; }
inline bool Token::is_comma () const 
 { return _language == comma_id; }
inline bool Token::is_close () const 
 { return _language == close_id; }

inline ostream &operator << (ostream &os, const Token &object) {
  object.print (os);
  return os;
}

} // namespace Puma

#endif /* __Token_h__ */
using namespace Puma;

namespace Puma {
  
}

class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinIfExists {
public:
  static WinIfExists *aspectof () {
    static WinIfExists __instance;
    return &__instance;
  }
  static WinIfExists *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win __if_exists and __if_not_exists                  */
  /********************************************************/

  // pointcut definitions
  

  // structural extensions
  

  // preprocess __if_exists and __if_not_exists statements
  
public: template<class JoinPoint> void __a0_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    Token *token;
    int type;
    __JP_That *preparser;
  
  	preparser = tjp->that ();
    tjp->proceed (); // get the next token
    token = *tjp->result ();
    if (token) {
      type = token->type ();
      // __if_exists (...) { ... }
      if (type == TOK_IF_EXISTS) {
        preparser->skip_up_to (TOK_CLOSE_CURLY);
		    *(Token**)thisJoinPoint->result () = preparser->next ();
		    return;
        // __if_not_exists (...) { ... }
      } else if (type == TOK_IF_NOT_EXISTS) {
        preparser->skip_up_to (TOK_OPEN_CURLY);
        preparser->_depth.push (1);
		    *(Token**)thisJoinPoint->result () = preparser->next ();
		    return;
      }
      // skip closing `}' of __if_not_exists
      if (preparser->_depth.length ()) {
        if (type == TOK_OPEN_CURLY) 
          preparser->_depth.top () = preparser->_depth.top () + 1;
        else if (type == TOK_CLOSE_CURLY) { 
          preparser->_depth.top () = preparser->_depth.top () - 1;
	  	    if (preparser->_depth.top () == 0) {
	          preparser->_depth.pop ();
  	    	  *(Token**)thisJoinPoint->result () = preparser->next ();
	       	  return;
	  	    }
        }
      }
    }
  }
private:


protected:
  WinIfExists () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinIfExists_WinIfExists_a0_around (JoinPoint *tjp) {
    ::WinIfExists::aspectof()->__a0_around (tjp);
  }
} 


namespace Puma {
  
    
  // skip __if_exists resp. __if_not_exists statement
  
}

#endif /* __WinIfExists__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinImportHandler__
#define __WinImportHandler__

/********************************************************/
/* Win #import directive support                        */
/********************************************************/

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Config_h__
#define __Config_h__

// Class Config provides evaluation of configuration 
// information from file or command line.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Flags_h__
#define __Flags_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Flags {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Flag {
    NONE                       = 0x0,
    
    SKIP_FCT_BODY              = 0x1,
    SKIP_INITS                 = 0x2,
    
    // GNU extensions
    GNU_NESTED_FCT             = 0x4,
    GNU_CONDITION_SCOPE        = 0x8,
    GNU_PARAM_DECL             = 0x10,
    GNU_FCT_DECL               = 0x20,
    GNU_PARAM_SCOPE            = 0x40,
    GNU_DEFAULT_ARGS           = 0x80,
    GNU_EXTENDED_ASM           = 0x100,
    GNU_EXTENDED_EXPR          = 0x200,
    GNU_LONG_LONG              = 0x400,
    GNU_NAME_SCOPE             = 0x800, 
    GNU_IMPLICIT_INT           = 0x1000,
    GNU_FCT_ATTRIBUTE          = 0x2000,
    GNU_IF_THEN_EXPR           = 0x4000
  };
  
private:
  Flag _Flags;
  
public:
  Flags ();
  Flags (const Flags &);
  Flags &operator =(const Flags &);

  // add/remove flag
  Flags &operator +=(Flag);
  Flags &operator -=(Flag);
  
  // test for flag
  bool operator ==(Flag) const;
  bool operator !=(Flag) const;
};

inline Flags::Flags () : _Flags (NONE) 
 {}
inline Flags::Flags (const Flags &f)
 { _Flags = f._Flags; }
inline Flags &Flags::operator =(const Flags &f)
 { _Flags = f._Flags; return *(Flags*)this; }

inline Flags &Flags::operator +=(Flags::Flag f)
 { _Flags = (Flag)(_Flags | f); return *(Flags*)this; }
inline Flags &Flags::operator -=(Flags::Flag f)
 { _Flags = (Flag)(_Flags ^ (_Flags & f)); return *(Flags*)this; }

inline bool Flags::operator ==(Flags::Flag f) const
 { return _Flags & f; }
inline bool Flags::operator !=(Flags::Flag f) const
 { return ! (_Flags & f); }


} // namespace Puma

#endif /* __Flags_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ConfOption_h__
#define __ConfOption_h__

#include <stdlib.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ConfOption {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_name;
  Array<const char *> _args;
  
public:
  ConfOption (const char *);
  ConfOption (const char *, const char *);
  ConfOption (const char *, const char *, const char *);
  ~ConfOption ();
  
  const char *Name () const;
  unsigned Arguments () const;
  const char *Argument (unsigned) const;
  
  void addArgument (const char *);
};

inline ConfOption::ConfOption (const char *n) : _args (1, 1) 
 { _name = StrCol::dup (n); }
inline ConfOption::ConfOption (const char *n, const char *a1) : _args (1, 1) 
 { _name = StrCol::dup (n); addArgument (a1); }
inline ConfOption::ConfOption (const char *n, const char *a1, const char *a2) : _args (2, 1) 
 { _name = StrCol::dup (n); addArgument (a1); addArgument (a2); }
 
inline ConfOption::~ConfOption ()
 { delete[] _name; 
   for (unsigned i = 0; i < Arguments (); i++) 
     delete[] Argument (i);
 }

inline const char *ConfOption::Name () const 
 { return _name; }
inline unsigned ConfOption::Arguments () const
 { return _args.length (); }
inline const char *ConfOption::Argument (unsigned i) const
 { return _args.lookup (i); }
  
inline void ConfOption::addArgument (const char *a) 
 { if (a) _args.append (StrCol::dup (a)); }


} // namespace Puma

#endif /* __ConfOption_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_stream_h__
#define __error_stream_h__

// An ErrorStream is a special ErrorSink that prints out an error message
// as soon as it complete. It also stores the maximum error severity.
// The ErrorStream can be reset to it's initial state.

#include <sstream>
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_sink_h__
#define __error_sink_h__

// This is an interface for classes that may be used to consume error
// messages during a process where many errors can occur like parsing
// a program.
// The error information is handed over to the ErrorSink in stream-like
// style. Different severities of errors are predefined and can be used
// to classify error information that follows. Also a location can be
// handed over to the ErrorSink to specify where the error was found
// (filename, line, etc.). The error information itself can be of any
// standard data type or anything that is "Printable".
// Specializations of this class could either build and print error
// messages or collect them for a later processing.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_severity_h__
#define __error_severity_h__

// Severity of errors: represented by a short integer and a text

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorSeverity {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  unsigned short _severity;
  const char *_text;

public:
  ErrorSeverity (unsigned short s = 0, const char* t = (const char*)0) :
    _severity (s), _text (t) {}
  ErrorSeverity (const ErrorSeverity &s) :
    _severity (s._severity), _text (s._text) {}
  ErrorSeverity &operator =(const ErrorSeverity &s) 
    { _severity = s._severity; _text = s._text; return *this; }

  int operator < (const ErrorSeverity &s) const
   { return _severity < s._severity; }
  int operator > (const ErrorSeverity &s) const
   { return _severity > s._severity; }
  int operator <= (const ErrorSeverity &s) const
   { return _severity < s._severity || _severity == s._severity; }
  int operator >= (const ErrorSeverity &s) const
   { return _severity > s._severity || _severity == s._severity; }
  int operator == (const ErrorSeverity &s) const
   { return _severity == s._severity; }
  int operator != (const ErrorSeverity &s) const
   { return _severity != s._severity; }
  const char *text () const
   { return _text; }
};

extern const ErrorSeverity sev_none;
extern const ErrorSeverity sev_message;
extern const ErrorSeverity sev_warning;
extern const ErrorSeverity sev_error;
extern const ErrorSeverity sev_fatal;
      

} // namespace Puma

#endif /* __error_severity_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorSink {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~ErrorSink () {}
  virtual ErrorSink &operator << (const char *) = 0;
  virtual ErrorSink &operator << (long) = 0;
  virtual ErrorSink &operator << (unsigned) = 0;
  virtual ErrorSink &operator << (int) = 0;
  virtual ErrorSink &operator << (short) = 0;
  virtual ErrorSink &operator << (char) = 0;
  virtual ErrorSink &operator << (double) = 0;
  virtual ErrorSink &operator << (const ErrorSeverity &) = 0;
  virtual ErrorSink &operator << (Location) = 0;
  virtual ErrorSink &operator << (const Printable &) = 0;
  virtual ErrorSink &operator << (void (*f)(ErrorSink &)) = 0;
  virtual void endMessage () = 0;
};

void endMessage (ErrorSink &);


} // namespace Puma

#endif /* __error_sink_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorStream : public ErrorSink {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ostream *_ostream;
  ErrorSeverity _max_severity;
  ErrorSeverity _curr_severity;
  Location _location;
  bool _have_location;
  std::ostringstream *_msg;
  bool _silently;

  void output ();
  void clear ();

public:
  ErrorStream (std::ostream &s = cerr) : _ostream (&s), _msg ((std::ostringstream*)0)
   { reset (); _silently = false; }
  virtual ~ErrorStream () { delete _msg; }

  ErrorStream &operator << (const char *);
  ErrorStream &operator << (long);
  ErrorStream &operator << (unsigned);
  ErrorStream &operator << (int);
  ErrorStream &operator << (short);
  ErrorStream &operator << (char);
  ErrorStream &operator << (double);
  ErrorStream &operator << (const ErrorSeverity &);
  ErrorStream &operator << (Location);
  ErrorStream &operator << (const Printable &);
  ErrorStream &operator << (void (*f)(ErrorSink &));

  void endMessage ();
  void reset ();
  void silent ();
  void loud ();

  ErrorSeverity severity () const { return _max_severity; }
};


} // namespace Puma

#endif /* __error_stream_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OptsParser_h__
#define __OptsParser_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SimpleParser_h__
#define __SimpleParser_h__

#include <vector>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SimpleParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  SimpleParser() {}
  ~SimpleParser() {}
   
  static int tokenize (const string &, vector<string> &, 
                       const string &delimiters = " ");
  static string strip (const string &);
};


} // namespace Puma

#endif /* __SimpleParser_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class OptsParser : public SimpleParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  vector<string> m_argv;
  unsigned int m_curarg;
  unsigned int m_tonext;
  int m_number;

  string m_arg;
  string m_opt;
   
public:
  
  enum {NOARG =-4, ERR = -3, NOOPTION = -2, UNKNOWN = -1, FINISH = 0 };
  
  enum ArgType { AT_NONE = 0, AT_MANDATORY = 1, AT_OPTIONAL = 2 };
  
  struct Option {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    int number;
    char key; 
    const char *name;
    const char *desc;
    ArgType args;
  };

private:
  const Option *m_opts;
   
public:
  OptsParser (int, char **, const Option *);
  OptsParser (const string &, const Option *);

  int getCurrentArgNum () const;
  int getNextArgNum () const;
  int getOption ();
  int getResult () const;
  
  const string &getArgument () const;
  const string &getOptionName () const;

  bool revokeArgument();
   
private:
  int  getShortOption (const string &);
  int  getLongOption  (const string &);
  bool processOption  (const string &, unsigned int,ArgType argtype);
};


} // namespace Puma

#endif /* __OptsParser_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Config {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Flags _flags;
  ErrorStream &_err;
  Array<const ConfOption *> _options;
  
public:
  enum OPTIONS {
    PRE_ASSERT = 1,
    PRE_DEFINE, 
    PRE_UNDEFINE, 
    PRE_LOCK_MACRO,
    PRE_INCLUDE,
    CFG_FILE, 
    PROJ_PATH, 
    PROJ_DESTINATION,
    SET_SUFFIX, 
    SET_EXTENSION, 
    SET_WRITE_PROTECTED,
    SET_OPTION, 
    SET_OPTION_ARG
  };
   
public:
  Config (ErrorStream &);
  Config (const Config &);
  ~Config ();
  
  // read config file
  Config (ErrorStream &, const char *);
  // read command line
  Config (ErrorStream &, int &, char **&);
  // read config file and command line
  Config (ErrorStream &, const char *, int &, char **&);
        
  // join with another configuration
  void Join (const Config &);

  // evaluate file, if file not given read from $PUMA_CONFIG
  // or /etc/puma.config
  void Read (const char * = (const char *)0);
  // evaluate command line
  void Read (int &, char **&);

  // add options to configuration
  void Add (const ConfOption *);
  void Add (const char *);
  void Add (const char *, const char *);
  void Add (const char *, const char *, const char *);

  // get options
  unsigned Options () const;
  const ConfOption *Option (unsigned) const;
  const ConfOption *Option (const char *) const;

  Flags FlagTable () const;
  
private:
  bool Valid (const char *, const char * = (const char *)0) const;

  bool Process (OptsParser&);
  bool ProcessAssert (const string&);
  bool ProcessDefine (const string&);
  bool ProcessLockMacro (const string&);
  bool ProcessUndefine (const string&);
  bool ProcessConfigFile (const string&,const string&);
  bool ProcessArgument (const string&,const string&);
  bool ProcessPathArgument (const string&,const string&);

};

inline Config::Config (ErrorStream &e) : _err (e)
 {}
inline Config::Config (const Config &c) : _err (c._err)
 { Join (c); }
  
inline Config::Config (ErrorStream &e, const char *file) : _err (e)
 { Read (file); }
inline Config::Config (ErrorStream &e, int &argc, char **&argv) : _err (e)
 { Read (argc, argv); }
inline Config::Config (ErrorStream &e, const char *file, int &argc, char **&argv) : _err (e)
 { Read (file); Read (argc, argv); }

inline Config::~Config  ()
 { for (unsigned i = 0; i < Options (); i++)
     delete (ConfOption *) Option (i);
 }

inline void Config::Add (const ConfOption *o) 
 { _options.append (o); }
inline void Config::Add (const char *n)
 { Add (new ConfOption (n)); }
inline void Config::Add (const char *n, const char *a1)
 { Add (new ConfOption (n, a1)); }
inline void Config::Add (const char *n, const char *a1, const char *a2)
 { Add (new ConfOption (n, a1, a2)); }

inline unsigned Config::Options () const
 { return _options.length (); }
inline const ConfOption *Config::Option (unsigned i) const
 { return _options.lookup (i); }

inline Flags Config::FlagTable () const
 { return _flags; }


} // namespace Puma

#endif /* __Config_h__ */
using namespace Puma;


class WinIfExists;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinImportHandler {
public:
  static WinImportHandler *aspectof () {
    static WinImportHandler __instance;
    return &__instance;
  }
  static WinImportHandler *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win #import directive                                */
  /********************************************************/

  // pointcuts
  
  
  // add access method for _importHandler data member
  

  // handle --import-handler option
  
public: template<class JoinPoint> void __a0_before (JoinPoint *tjp, const Config &config, bool process_includes) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    const ConfOption *opt;
    char *tmp;
    
    if (process_includes) {
      opt = config.Option ("--import-handler");
      if (opt && opt->Arguments ()) {
        // delete old import handler
        if (thisJoinPoint->that ()->_importHandler)
          delete[] thisJoinPoint->that ()->_importHandler;
        
        // get new import handler
        tmp = new char[strlen (opt->Argument (0))+1];
        strcpy (tmp, opt->Argument (0));
        thisJoinPoint->that ()->_importHandler = tmp;
      }
    }
  }
private:


protected:
  WinImportHandler () {}
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinImportHandler_WinImportHandler_a0_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    typedef typename Binding::template Arg<1> Arg1;
    ::WinImportHandler::aspectof()->__a0_before (tjp, (const Puma::Config &)Arg0::val (tjp), (bool)Arg1::val (tjp));
  }
} 



#endif /* __WinImportHandler__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __PragmaOnce__
#define __PragmaOnce__

/********************************************************/
/* Win #pragma once support aspect                      */
/********************************************************/

using std::cout;
using std::endl;

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __unit_h__
#define __unit_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_h__
#define __list_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ListElement *_first;
  ListElement *_last;

public:
  List () : _first ((ListElement*)0), _last ((ListElement*)0) {}
  List (const List &);
  ~List();

  List &operator = (const List &);
  List &operator += (const List &);
  List operator + (const List &);

  void clear ();

  void append (ListElement &);
  void prepend (ListElement &);
  void insert (ListElement *at, ListElement &element);
  void remove (ListElement *element);
  void kill (ListElement *from, ListElement *to = (ListElement*)0)
   { List discard; cut (discard, from, to); }

  void cut (List &out, ListElement *from, ListElement *to = (ListElement*)0);
  //List *cut (ListElement *from, ListElement *to = (ListElement*)0);
  List *copy (ListElement *from = (ListElement*)0, 
              ListElement *to = (ListElement*)0);
  void paste (ListElement *at, const List &l);
  void paste_before (ListElement *at, const List &l);
  void move (ListElement *at, List &l);
  void move_before (ListElement *at, List &l);

  bool empty () const { return _first == (ListElement*)0; }
  const ListElement *first () const { return _first; }
  const ListElement *last () const { return _last; }
  const ListElement *next (const ListElement *element) const
   { return element->_next; }
  const ListElement *prev (const ListElement *element) const 
   { return element->_prev; }
};


} // namespace Puma

#endif /* __list_h__ */

#ifndef __ac_fwd_PragmaOnceUnitState__
#define __ac_fwd_PragmaOnceUnitState__
class PragmaOnceUnitState;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __PragmaOnceUnitState__
#define __PragmaOnceUnitState__

using namespace Puma;

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class PragmaOnceUnitState {
public:
  static PragmaOnceUnitState *aspectof () {
    static PragmaOnceUnitState __instance;
    return &__instance;
  }
  static PragmaOnceUnitState *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /******************************************************/
  /* specific #pragma once unit state                   */
  /******************************************************/

  // pointcut definitions
  

  
  
  // initialize new state flag
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    thisJoinPoint->that ()->_once = false;
  }
private:


protected:
  // this aspect should never be instantiated directly
  PragmaOnceUnitState () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after (JoinPoint *tjp) {
    ::PragmaOnceUnitState::aspectof()->__a0_after (tjp);
  }
} 



#endif /* __PragmaOnceUnitState__ */
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_UnitState_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_UnitState_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __UnitState__
#define __UnitState__

// The state of a unit: 
// 1. modified by manipulations and not updated at the class registry
// 2. modified by manipulations and updated at the class registry
// 3. unmodified by manipulations and not updated at the class registry
// 4. unmodified by manipulations and updated at the class registry

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class UnitState {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _modified;
  bool _updated;
  long _lastModified;
      
public:
  public: inline void __exec_old_C1();
UnitState ();
      
  bool isModified () const;
  bool isUpdated () const;
  long lastModified () const;

  // Is modified and has to be updated.
  void modified ();
  void lastModified (long);
  void unmodified ();
  void updated ();
   private:
 bool _once ;
public :

bool onlyOnce ( ) const { return _once ; }
void onlyOnce ( bool v ) { _once = v ; }
struct TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0 {
  typedef void Result;
  typedef ::Puma::UnitState That;
  typedef ::Puma::UnitState Target;
  static const int JPID = 5;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 1 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef const ::Puma::UnitState & Type;
    typedef const ::Puma::UnitState ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline UnitState (const Puma::UnitState & arg0) : _modified (arg0._modified), _updated (arg0._updated), _lastModified (arg0._lastModified), _once (arg0._once) {
  TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0 tjp;
  tjp._that =  (TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0::That*)this;
  AC::invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after<TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0> (&tjp);

}
};



struct TJP__ZN4Puma9UnitStateC1Ev_0 {
  typedef void Result;
  typedef ::Puma::UnitState That;
  typedef ::Puma::UnitState Target;
  static const int JPID = 5;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};

inline UnitState::UnitState ()
 {
  TJP__ZN4Puma9UnitStateC1Ev_0 tjp;
  tjp._that =  (TJP__ZN4Puma9UnitStateC1Ev_0::That*)this;
this->__exec_old_C1();
  AC::invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after<TJP__ZN4Puma9UnitStateC1Ev_0> (&tjp);

}
inline void Puma::UnitState::__exec_old_C1(){ _modified = false; _updated = false; _lastModified = 0; }

inline bool UnitState::isModified () const 
 { return _modified; }
inline bool UnitState::isUpdated () const 
 { return _updated; }
inline long UnitState::lastModified () const
 { return _lastModified; }

inline void UnitState::modified () 
 { _modified = true; _updated = false; _lastModified = 0; }
inline void UnitState::unmodified () 
 { _modified = false; }
inline void UnitState::updated () 
 { _updated = true; }
inline void UnitState::lastModified (long when) 
 { _lastModified = when; }


} // namespace Puma

#endif /* __UnitState__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_UnitState_h__
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Unit : public List, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_name;
  UnitState _state;

public:
  Unit () : List (), _name ((char*)0) {}
  Unit (const List &list) : List (list), _name ((char*)0) {}
  virtual ~Unit ();
  virtual void name (const char *);
  char *name () const { return _name; }
  virtual void print (ostream &os) const;
  virtual bool isFile () const { return false; }
  virtual bool isMacroExp () const { return false; }
  UnitState &state () { return _state; }
};


} // namespace Puma

#endif /* __unit_h__ */
using namespace Puma;


class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class CCExprResolve;
class CExprResolve;
class PragmaOnce {
public:
  static PragmaOnce *aspectof () {
    static PragmaOnce __instance;
    return &__instance;
  }
  static PragmaOnce *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /******************************************************/
  /* detect #pragma once in the token stream of cpp     */
  /******************************************************/

  // pointcut definitions
  
  
  
  // extend the preprocessor parser by the filter state
  

  // initialize the filter state
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    // TODO: it would be better to have construction advice -> but in lem file
    tjp->that ()->_pragma_token = 0;
  }
private:

  
  // filter #pragma once
  
public: template<class JoinPoint> void __a1_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    Token *tok = *tjp->result ();
    __JP_That &that = *tjp->that ();
    if (!tok || !tok->is_directive ()) {
      that._pragma_token = 0;
      return;
    }
    if (strcmp ("#pragma", tok->text ()) == 0) {
      that._pragma_token = tok;
    }
    else if (that._pragma_token && strcmp ("once", tok->text ()) == 0) {
      Unit *unit = (Unit*)tok->belonging_to ();
      assert (unit);
      unit->state ().onlyOnce (true);
    }
  }
private:

  
  /********************************************************/
  /* block the handling of pragma once files              */
  /********************************************************/

  // don't let file includer include files twice
  // to be precise: the file is included again, but the inclusion produces
  // no tokens
  
public: template<class JoinPoint> void __a2_around (JoinPoint *tjp, Unit *unit) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (! unit || ! unit->state ().onlyOnce ())
      tjp->proceed ();
  }
private:


  // includeFile shall return 0 if the file was not included
  
public: template<class JoinPoint> void __a3_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    Unit *&unit = *tjp->result ();
    if (unit && unit->state ().onlyOnce ())
      unit = 0;
  }
private:

    
protected:
  // this aspect should never be instantiated directly
  PragmaOnce () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp) {
    ::PragmaOnce::aspectof()->__a0_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp) {
    ::PragmaOnce::aspectof()->__a1_after (tjp);
  }
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::PragmaOnce::aspectof()->__a2_around (tjp, (Puma::Unit *)Arg0::val (tjp));
  }
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp) {
    ::PragmaOnce::aspectof()->__a3_after (tjp);
  }
} 



#endif /* __PragmaOnce__ */
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __preprocessor_parser__
#define __preprocessor_parser__

// Preprocessor parser class. !!! The preprocessor parser has to 
// be added last to the composite parser of a translation unit !!!


#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_recognizer_h__
#define __c_recognizer_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CScanBuffer_h__
#define __CScanBuffer_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __scan_buffer_h__
#define __scan_buffer_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ScanBuffer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef enum { STATE_END, STATE_ERROR, STATE_OK } State;
  
  virtual ~ScanBuffer () {}

  virtual char next () = 0;
  virtual char *token () = 0;
  virtual int len () const = 0;
  virtual void reset () = 0;
  virtual void retry () = 0; 
  virtual void accept (int len) = 0;
  virtual void more (int len) = 0;
  virtual State state () const = 0;
};


} // namespace Puma

#endif /* __scan_buffer_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanBuffer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ScanBuffer *next_buffer;
  bool on_new_line;
  int nl_pos;

  void check ();

public:
  void decorate (ScanBuffer *nb) { next_buffer = nb; }
  inline char next ();
  inline void reset ();
  inline void accept (int len);
  inline void retry ();
  bool new_line () const { return on_new_line; }
  char *token () { return next_buffer->token (); }
  int len () const { return next_buffer->len (); }
  void more (int len) { next_buffer->more (len); }
  ScanBuffer::State state () const { return next_buffer->state (); }
};


inline char CScanBuffer::next () {
  char character = next_buffer->next ();
  if (character == '\n' && nl_pos == -1)
    nl_pos = len () - 1;
  check ();
  return character;
}

inline void CScanBuffer::reset () { 
  next_buffer->reset (); 
  on_new_line = true;
  nl_pos = -1;
  check ();
}


inline void CScanBuffer::retry () {
  nl_pos = -1;
  next_buffer->retry ();
}


inline void CScanBuffer::accept (int len) {
  on_new_line = (nl_pos >= 0 && nl_pos < len);
  nl_pos = -1;
  next_buffer->accept (len);
}

} // namespace Puma

#endif // __CScanBuffer_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_comment_recognizer_h__
#define __c_comment_recognizer_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __mapped_orange_recognizer_h__
#define __mapped_orange_recognizer_h__

// The token recognizer class, which uses scanner tables generated by the
// orange tool. Returned expressions mapped according to an orange
// generated mapping table

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __recognizer_h__
#define __recognizer_h__

// The token recognizer class, which uses scanner tables generated by the
// orange tool.

namespace Puma {


#ifndef __TTGEN__
#  define __TTGEN__
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
typedef struct
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 unsigned char Type;
   unsigned char LookAhead;
   int           Expression;
   int           Start;
 } States;                                                                   
#endif


// class declaration

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <typename TScanBuffer>
class OrangeRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // local structures generated by Orange

  char *_map;
  int _start;
  States *_state;
  int *_next;
  int *_control;
  int _tab_size;

public:
  OrangeRecognizer (char *map, int start, States *state, int *next,
                    int *control, int tab_size) : 
    _map (map), _start (start), _state (state), _next (next),
    _control (control), _tab_size (tab_size)
   {}

  // try to recognize the current token in the character buffer
  // returns 1 on success, 0 on eof, -1 on unknown token
  int recognize (TScanBuffer *scan_buffer, int &token, int &len); 
};

template <typename TScanBuffer>
int OrangeRecognizer<TScanBuffer>::recognize (TScanBuffer *scan_buffer,
                                              int &token, int &len) {
  int  NextState;
  char Character;
  char CharClass;
  int  NextStatePos;
  int  State;
  int  LookAheadLen;
  int  AcceptLen;
  int  AcceptState;
  ScanBuffer::State buffer_state = ScanBuffer::STATE_OK;

  State = _start;
  AcceptState = -1;
  LookAheadLen = 0;
  AcceptLen = 0;

  do { 
    Character = scan_buffer->next ();

    CharClass = _map[(unsigned char)Character];
    if (CharClass == -1)
      break;

    NextStatePos = _state[State].Start + CharClass;
    if (NextStatePos < 0 || NextStatePos >= _tab_size ||
        _control[NextStatePos] != State)
      break;

    if ((NextState = _next[NextStatePos]) == -1)
      break;

    State = NextState;

    if (_state[State].Type > 0) {
      AcceptState = State; // remember this (terminal) state
      AcceptLen = scan_buffer->len ();
    }

    if (_state[State].LookAhead)
      LookAheadLen = scan_buffer->len ();

    buffer_state = scan_buffer->state ();
  } while (NextState != -1 && buffer_state == ScanBuffer::STATE_OK);

  if (buffer_state == ScanBuffer::STATE_ERROR)
    return -1;

  if (AcceptState == -1)
    return 0;

  len   = (_state[AcceptState].Type == 2) ? LookAheadLen : AcceptLen;
  token = _state[AcceptState].Expression;

  return 1;
}

} // namespace Puma

#endif /* __orange_recognizer_h__ */
namespace Puma {


// class declaration

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class ScanBuffer>
class MappedOrangeRecognizer : public OrangeRecognizer<ScanBuffer> {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int *_expr_map;

public:
  MappedOrangeRecognizer (char *map, int *expr_map, int start, 
                          States *state, int *next,
                          int *control, int tab_size) : 
    OrangeRecognizer<ScanBuffer> (map, start, state, next, control, tab_size),
    _expr_map (expr_map) 
   {}

  // try to recognize the current token in the character buffer
  // returns 1 on success, 0 on eof, -1 on unknown token
  int recognize (ScanBuffer *scan_buffer, int &token, int &len) {
    int result;

    if ((result = OrangeRecognizer<ScanBuffer>::recognize (scan_buffer, token, len)) == 1) {
      token = _expr_map[token];
    }
    return result;
  }
};


} // namespace Puma

#endif // __mapped_orange_recognizer_h__
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CCommentRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef enum { NO_COMMENT, SL_COMMENT, ML_COMMENT } Mode;

private:
  static MappedOrangeRecognizer<CScanBuffer> comment_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> sl_comment_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> ml_comment_recognizer;   
  Mode comment_mode;

public:
  CCommentRecognizer () : comment_mode (NO_COMMENT) {}
  int recognize (CScanBuffer *scan_buffer, int &expr, int &len);
  void mode (Mode mode) { comment_mode = mode; }
  Mode mode () { return comment_mode; }
};


} // namespace Puma

#endif /* __c_comment_recognizer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __keyword_recognizer_h__
#define __keyword_recognizer_h__
 
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class KeywordRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  virtual MappedOrangeRecognizer<CScanBuffer> &recognizer() = 0;

public:
  virtual ~KeywordRecognizer () {}
  virtual int recognize (CScanBuffer *scan_buffer, int &expr, int &len);
};
 

} // namespace Puma

#endif /* __keyword_recognizer_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CScanBuffer scan_buffer;
  CCommentRecognizer comment_recognizer;
  Array<KeywordRecognizer*> additional_keyword_recognizers;

public:
  typedef enum { NORMAL, IN_COMP_DIR, IN_PRE_DIR } Mode;
  typedef enum { COMMENT, PRE_DIR, COMP_DIR, WHITE, PRE, STRING, CORE, 
                 KEYWORD, ID, WILDCARD, UNKNOWN } Lang;

  CRecognizer () : wildcards (false), aspectc (false), macro_ops (false),
    std_c (true), std_cplusplus (true) {}
  CRecognizer (ScanBuffer& buffer) : wildcards (false), aspectc (false),
    macro_ops (false) { setup (buffer); }
  void allow_wildcards (bool flag = true)     { wildcards = flag; }
  void allow_aspectc (bool flag = true)       { aspectc   = flag; } 
  void allow_macro_ops (bool flag = true)     { macro_ops = flag; }
  void allow_std_c (bool flag = true)         { std_c = flag; }
  void allow_std_cplusplus (bool flag = true) { std_cplusplus = flag; }
  void setup (ScanBuffer &buffer);
  int recognize (Lang &lang, int &expr, int &len);
  Mode mode () { return scan_mode; }
  bool new_line () const { return scan_buffer.new_line (); }
  CScanBuffer& buffer () { return scan_buffer; }
  void addRecognizer(KeywordRecognizer &recognizer) 
   { additional_keyword_recognizers.append(&recognizer); }

private:
  static MappedOrangeRecognizer<CScanBuffer> string_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> pre_dir_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> pre_token_recognizer;
  static OrangeRecognizer<CScanBuffer> dir_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> whitespace_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> wildcard_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> core_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> identifier_recognizer;

  Mode scan_mode;
  bool check_directive;
  bool wildcards;
  bool aspectc;
  bool macro_ops;
  bool std_c;
  bool std_cplusplus;
};


} // namespace Puma

#endif /* __c_recognizer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Tokenizer_h__
#define __Tokenizer_h__

// Tokenizer interface. Tokenizer read input from a "Source" and
// form tokens, which used to fill a "Unit".

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __source_h__
#define __source_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Source {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  Source () {}
  virtual ~Source () {}
  virtual int read (char *dest, int n) = 0;
  virtual int size () { return -1; }
};


} // namespace Puma

#endif /* __source_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~Tokenizer () {}
  virtual void fill_unit (Source &in, Unit &unit) = 0;
};


} // namespace Puma

#endif /* __Tokenizer_h__ */
namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_unit_h__
#define __c_unit_h__


#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

#include "Puma/CRecognizer.h"
#include "Puma/Location.h"
#include "Puma/LanguageID.h"
#include "Puma/Tokenizer.h"
#include "Puma/Unit.h"
#include "Puma/ErrorSink.h"
#include "Puma/Config.h"
#include "Puma/Source.h"

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CUnit : public Unit, public std::ostringstream {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CScanner _scanner;

public:
  CUnit (ErrorSink &err) : _scanner (err) {}
  virtual ~CUnit () {}
  
  CScanner &scanner () const { return (CScanner&)_scanner; }
  void scan ();
};

inline std::ostream &endu (std::ostream &outs) {
  ((CUnit&)outs).scan ();
  return outs;
}


} // namespace Puma

#endif /* __c_unit_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Token_Source__
#define __Token_Source__

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PumaTokenSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  PumaTokenSource () {}

public:
  virtual ~PumaTokenSource () {}
  virtual Token *next () = 0;
};


} // namespace Puma

#endif /* __Token_Source__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_macro_expander__
#define __pre_macro_expander__

// The macro expander provides methods to expand a single macro or
// all macros of a given string or unit.

#include <set>
using std::set;

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_arg_desc__
#define __pre_arg_desc__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __MacroUnit__
#define __MacroUnit__

// Special unit for macro expansions

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class MacroUnit : public Unit {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Unit *_CallingUnit;
  Token *_StartToken;
  Token *_EndToken;

public:
  MacroUnit () : _CallingUnit (0) {}
  MacroUnit (const Unit &u) : 
    Unit (u), _CallingUnit (0), _StartToken (0), _EndToken (0) {}
  virtual ~MacroUnit () {}
  
  // unit is a macro expansion
  virtual bool isMacroExp () const { return true; }

  // unit wherein the macro was called
  void CallingUnit (Unit *u) { _CallingUnit = u; }
  Unit *CallingUnit () const { return (Unit*)_CallingUnit; }
  
  // begin and end token of the macro call
  void MacroBegin (Token *t) { _StartToken = t; }
  void MacroEnd (Token *t) { _EndToken = t; }
  Token *MacroBegin () const { return _StartToken; }
  Token *MacroEnd () const { return _EndToken; }
  
  // get the first/last token of the whole macro expansion 
  // if the given token is the first/last token of this 
  // (sub-)expansion
  Token *ExpansionBegin (Token *) const;
  Token *ExpansionEnd (Token *) const;
};


} // namespace Puma

#endif /* __MacroUnit__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreArgDesc {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // Collected arguments of a function-like macro.
  Array<MacroUnit> m_Args;
  // Begin token of the macro call.
  Token *m_Begin;
  // End token of the macro call.
  Token *m_End;

public:
  // Constructor.
  PreArgDesc () : m_Begin (0), m_End (0) {}
        
  Token *beginToken () const { return m_Begin; }
  Token *endToken () const { return m_End; }
  void beginToken (Token *t) { m_Begin = t; }
  void endToken (Token *t) { m_End = t; }
  
  int numArgs () const { return m_Args.length (); }
  void newArg () { m_Args[numArgs ()]; }
  MacroUnit &currArg () const { return (MacroUnit&)m_Args.lookup (numArgs ()-1); }
  MacroUnit &getArg (int i) const { return (MacroUnit&)m_Args.lookup (i); }
};


} // namespace Puma

#endif /* __pre_arg_desc__ */
namespace Puma {


class PreprocessorParser;
class PreMacroExpander;
class PreMacroManager;
class UnitManager;
class TokenStream;
class ErrorStream;
class PreMacro;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreMacroExpander {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  TokenStream        *_scanner;
  PreMacroManager    *_macroManager;
  UnitManager        *_unitManager;
  ErrorStream        *_err;
  Array<PreMacro*>   *_macroStack;
  
  PreprocessorParser *_parser;
        
  PreMacroExpander   *_preexpander;
  
  bool               _in_include; // true if an include directive is scanned

  set<Token*> *_prescanned; // Needed for macro expansion to avoid multiple
                            // processing steps with prescanned argument tokens

  // Check whether there is really a macro.
  bool checkForGoOn (bool mode = true) const;
        
  // Process the macro operator `##'.
  void processConcatOp (Unit *) const;
        
  // Process the macro operator `#'.
  void processStringOp (PreMacro *, Unit *, PreArgDesc &) const;
        
  // Stringify and replace an argument.
  void replaceStringifiedArg (int, Unit *, PreArgDesc &) const;
        
  // Replace an argument unchanged.
  void replaceUnchangedArg (int, Unit *, PreArgDesc &, Unit *, Token *, bool) const;

  // Test whether a string is an argument of a macro.
  int isArg (const char *, PreMacro *) const;
        
  // Compare two macro argument identifier.
  bool equal (const char *, const char *) const;

  // Build an unit from a string.
  Unit *buildUnit (const char *) const;
        
  // Collect the arguments of a function-like macro.
  void collectArgs (PreMacro *, PreArgDesc &) const;
        
  // Expand a function-like macro.
  void substituteMacro (PreMacro *, PreArgDesc &) const;
        
  // Process the special keyword `defined'.
  void processDefined (PreMacro *, PreArgDesc &) const;
        
  // Prescan an argument of a macro call.
  Unit& prescanArgument (Unit *) const;

  // Expand the given macro. 
  bool expandMacro (Token *, PreMacro *) const;

  // Reset the expander to a special initial state.
  void reset (PreprocessorParser *, Array<PreMacro*> *, set<Token*> *);
        
  // Expand all macros of the given unit.
  Unit *expandMacros (Unit *, set<PreMacro*> * = 0);
        
  // Push unit on token stream.
  void pushUnit (TokenStream &, Unit *) const;

public:
  // Special constructor. Call reset() before using the expander.
  PreMacroExpander ();
        
  PreMacroExpander (PreprocessorParser *);
  ~PreMacroExpander () { if (_preexpander) delete _preexpander; }

  // Reset the expander to the initial state.
  void reset (PreprocessorParser *);
        
  // Set a flag that is used to check whether a macro is expanded in a
  // #include directive
  void inInclude (bool ii) { _in_include = ii; }
  
  // Expand the given macro. 
  bool expandMacro (PreMacro *, Token *);
        
  // Expand all macros of the given string.
  char *expandMacros (const char *);
};


} // namespace Puma

#endif /* __pre_macro_expander__ */
using namespace std;

namespace Puma {


class PreTree;
class ErrorStream;
class UnitManager;
class PrePredicate;
class PreLevelState;
class PreParserState;
class PreMacroManager;
class PreFileIncluder;
class PrePredicateManager;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreprocessorParser : public PumaTokenSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  // The current mode for token preprocessing
  typedef enum { 
    INITIAL, 
    DEFINING, 
    MAYBEMACRO, 
    ASSERT,
    TOKENLIST, 
    DIRECTIVE, 
    MACRO 
  } PreMode;

private:
  // Do not print the result of the parse process.
  bool _silentMode;

  // If the preprocessor parser is the last in chain,
  // the result of the parse process will be putted on 
  // the given stream.
  ostream *_out;

  // Stack for the macro expansion.
  Array<PreMacro*>    *_macroStack;
  set<Token*>         *_prescanned;

  PreLevelState       *_levelState;
  PreParserState      *_parserState;
  PreMacroManager     *_macroManager;
  PreFileIncluder     *_fileIncluder;
  PrePredicateManager *_predicateManager;
  UnitManager         *_unitManager;
  UnitManager         *_locals;

  PreMacroExpander     _expander;
  PreMacroExpander     _macroExpander;        
        
  PreMode              _pre_mode;
  bool                       _support_gnu;

  CScanner             _scanner;
  TokenStream         *_stream;
                
  const char          *_importHandler;

private:
  // Parse a single token.
  Token* parseToken ();

  // Free the preprocessor syntax tree.
  void freeSyntaxTree (PreTree*);

public:
  // Get several preprocessor informations.
  Array<PreMacro*>    *macroStack () const       { return _macroStack; }
  set<Token*>         *prescanned () const       { return _prescanned; }
  PreLevelState       *levelState () const       { return _levelState; }
  PreParserState      *parserState () const      { return _parserState; }
  PreMacroManager     *macroManager () const     { return _macroManager; }
  PreFileIncluder     *fileIncluder () const     { return _fileIncluder; }
  PrePredicateManager *predicateManager () const { return _predicateManager; }
  UnitManager         *unitManager () const      { return _unitManager; }
  UnitManager         *locals () const           { return _locals; }
  PreMode              pre_mode () const         { return _pre_mode; } 
  bool                 supportGNU () const       { return _support_gnu; }
  CScanner            &cscanner () const         { return (CScanner&) _scanner; }

  // Return the preprocessor syntax tree.
  PreTree *syntaxTree () const;

public:
  PreprocessorParser (ErrorStream *, UnitManager *, UnitManager *, 
                        ostream &out = cout, int max_depth = 400);
                           
  ~PreprocessorParser ();
        
  // Reset the preprocessor parser.
  void reset (ErrorStream *, UnitManager *, UnitManager *, 
              ostream &out = cout, int max_depth = 400);

  // Free the preprocessor syntax tree.
  void freeSyntaxTree ();
        
  // Configure the preprocessor.
  public: inline void __exec_old_configure(const ::Puma::Config & ,bool );
void configure (const Config &, bool = true);
        
  // Get the next token to parse.
  public: inline ::Puma::Token * __exec_old_next();
Token *next ();
        
  TokenStream *scanner () const { return _stream; }
  void stream (TokenStream *s) { _stream = s; }

  // Map scanner token types to parser token types
  int map_token (Token *token, bool &parse);

  // Invoke the parse process.
  void parse ();
        
  // Switch to silent mode.
  void silentMode (bool mode = true) { _silentMode = mode; }

  // Define a new macro.
  void defMacro (const char *, const char * = (const char*)0, char = 0) const;
        
  // Undefine a macro.
  void undefMacro (const char *) const;
        
  // Define a new predicate.
  void defPredicate (const char *, const char *) const;
        
  // Undefine a predicate.
  void undefPredicate (const char *) const;
        
  // Add a new include path.
  void addInclPath (const char *) const;

  void supportGNU (bool);
   private:
  typedef PreprocessorParser WinIfExistsCpp;
 public :

Stack < unsigned > _depth ;

void skip_up_to ( int ) ;  private:
 public :
const char * importHandler ( ) const { return _importHandler ; }  private:
 Token * _pragma_token ;};


} // namespace Puma

#endif /* __preprocessor_parser__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_iterator__
#define __path_iterator__

// A path iterator is used to iterate the contents of the paths
// a project is managing. But only files matching a given pattern 
// are iterated. 

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __project_file__
#define __project_file__

#include <map>
using std::map;
using std::string;

namespace Puma {
 
// the project file abstraction is used to store all filenames relevant
// for a specific file that is managed by Puma.

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ProjectFile {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Filename _nick_name;
  Filename _dest_path;
public:  
  ProjectFile (const Filename &nn) : _nick_name (nn) {}
  ProjectFile (const Filename &nn, const Filename &dp) :
    _nick_name (nn), _dest_path (dp) {}
  void dest (const Filename &dp) { _dest_path = dp; }
  Filename name () const { return _nick_name; }
  Filename dest () const {
    assert (_dest_path.is_defined ());
    return _dest_path;
  }
};

typedef map<string, ProjectFile> PFMap;
typedef PFMap::value_type PFMPair;
typedef PFMap::const_iterator PFMConstIter;

} // namespace Puma

#endif // __project_file__
namespace Puma {

class PathManager;
class RegComp;
 
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PathIterator : public PFMConstIter {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  friend class PathManager;

  RegComp *_regexp;  // Search pattern.
  bool _in_use;

public:
  PathIterator (const char *);     // Expects a regular expression.
  ~PathIterator ();                // for the files to match.

  void pattern (const char *);     // Set the search pattern.
  void init (const PFMConstIter &begin);
  bool in_use () const { return _in_use; }
  void done () { _in_use = false; }

  // retrieve information about the currently referenced ProjectFile
  const char *file () const;
  const char *dest () const;
};

} // namespace Puma

#endif /* __path_iterator__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __string_source_h__
#define __string_source_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StringSource : public Source {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_string;
  int _delivered;
  int _len;

public:
  StringSource () : _string ((const char*)0) {}
  StringSource (const char *string) : _string (string) { 
    _delivered = 0; 
    _len = strlen (string);
  }

  virtual int read (char *dest, int n) {
    int to_copy;

    if (! _string || _delivered == _len)
      return 0;

    to_copy = (n < _len - _delivered) ? n : _len - _delivered;

    memcpy (dest, _string + _delivered, to_copy);
    _delivered += to_copy;

    return to_copy;
  }
  void string (const char *string) { 
    _string = string; 
    _delivered = 0;
    _len = strlen (_string); 
  }
  const char *string () { return _string; }
  int size () { return _len; }
};


} // namespace Puma

#endif /* __string_source_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __file_source_h__
#define __file_source_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __fd_source_h__
#define __fd_source_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SysCall_h__
#define __SysCall_h__

// Encapsulate some system calls. 

#include <time.h>
#include <stdio.h>
#include <stddef.h>
#include <sys/stat.h>
#ifdef _MSC_VER
#include <string.h>
#include <stdlib.h>
#else
#include <dirent.h>
#endif // _MSVC

namespace Puma {

class SysCall;
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FileInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  friend class SysCall;
#ifndef _MSC_VER
  struct stat _info;
#else
  struct _stat _info;
#endif
public:
  bool is_dir () const {
#ifdef _MSC_VER
          return _S_IFDIR & _info.st_mode; }
#else
          return S_ISDIR (_info.st_mode); }
#endif // _MSC_VER
  time_t modi_time () const { return _info.st_mtime; }
  int size () const { return _info.st_size; }
};

#ifdef _MSC_VER
struct DIR {
        long _handle;
        DIR (long h) : _handle (h) {}
};
#endif // _MSC_VER

typedef DIR *DirHandle;
typedef FILE *FileHandle;

class ErrorSink;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SysCall {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  static void printerror (ErrorSink *, const char *, 
                          const char * = (const char *)0);
  static void printerror (ErrorSink *, const char *, int);

public:
  SysCall () {}
        
  // create temporary file name, needs to be freed by caller
  static const char* mktemp (const char *prefix, ErrorSink * = (ErrorSink *)0);

  // open/close file
  static int open (const char *, int, ErrorSink * = (ErrorSink *)0);
  static bool close (int, ErrorSink * = (ErrorSink *)0);
        
  // read from file descriptor
  static long read (int, void *, size_t, ErrorSink * = (ErrorSink *)0);
        
  // get file status
  static bool stat (const char *, FileInfo &, ErrorSink * = (ErrorSink *)0);
  static bool fstat (int, FileInfo &, ErrorSink * = (ErrorSink *)0);
  static char* readlink (const char*, char*, size_t, ErrorSink * = (ErrorSink *)0);
        
  // open/close file stream
  static FileHandle fopen (const char *, const char *, ErrorSink * = (ErrorSink *)0);
  static bool fclose (FileHandle, ErrorSink * = (ErrorSink *)0);

  // open/close directory stream
  static DirHandle opendir (const char *, ErrorSink * = (ErrorSink *)0);
  static bool closedir (DirHandle, ErrorSink * = (ErrorSink *)0);

  // read from directory stream
  static const char *readdir (DirHandle, ErrorSink * = (ErrorSink *)0);
        
  // change directory 
  static bool chdir (const char *, ErrorSink * = (ErrorSink *)0);
        
  // create directory
  static bool mkdir (const char *, ErrorSink * = (ErrorSink *)0);
        
  // get current working directory
  static char *getcwd (char *, size_t, ErrorSink * = (ErrorSink *)0);
        
  // get current time
  static time_t time (time_t *, ErrorSink * = (ErrorSink *)0);

  // platform depended path handling
  static void MakeUnixPath (char*);
  static void MakeDosPath  (char*);
  
#ifdef WIN32
  // normalize an absolute Win32 filename of an exisiting file
  static bool normalize (Filename filename, Filename &norm, ErrorSink *err);
#endif // WIN32

  // return a canonical path name for an exisiting file
  static bool canonical (Filename filename, Filename &result, ErrorSink * = 0);
};


} // namespace Puma

#endif /* __SysCall_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FdSource : public Source {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _fd;

public:
  FdSource () : _fd (-1) {}
  FdSource (int fdesc) : _fd (fdesc) {}
  virtual ~FdSource () {}

  virtual int read (char *dest, int n)
   { return SysCall::read (_fd, dest, n); }

  void fd (int fdesc) { _fd = fdesc; }
  int fd () { return _fd; }

  int size () {
    FileInfo fileinfo;
    return (SysCall::fstat (_fd, fileinfo)) ? fileinfo.size () : -1;
  }
};


} // namespace Puma

#endif /* __fd_source_h__ */
#include <fcntl.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FileSource : public FdSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  FileSource (const char *name, ErrorSink *err = (ErrorSink*)0)
   { fd (SysCall::open (name, O_RDONLY, err)); }
  ~FileSource ()
   { SysCall::close (fd ()); }

  virtual int read (char *dest, int n)
   { return FdSource::read (dest, n); }
};


} // namespace Puma

#endif /* __file_source_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CProject_h__
#define __CProject_h__

// Special project derivation for C++ sources.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __project__
#define __project__

// The basic project is a set of source directories. It provides 
// methods for searching and writing files. 

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_manager__
#define __path_manager__

// Manages directories and methods to access the files in it.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_info__
#define __path_info__

// A path information object consists of a source and optionally
// a destination path.

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PathInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_src;        // Source path.
  const char *_dest;        // Destination path.
        
public:
  PathInfo () : _src ((const char*) 0), _dest ((const char*) 0) {}
  PathInfo (const PathInfo &);
  ~PathInfo ();
        
  // Needed for class Array.
  PathInfo &operator =(const PathInfo &);

  // Set or get the source path.
  void src (const char *);
  const char *src () const { return _src; }
        
  // Set or get the destination path.
  void dest (const char *);
  const char *dest () const { return _dest; }
};


} // namespace Puma

#endif /* __path_info__ */
namespace Puma {

class RegComp;
class Config;
class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PathManager {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  ErrorStream     *_err;
  Array<PathInfo>  _paths;     // List of directories path.
  Array<RegComp*>  _protected; // List of regular patterns specifying 
                               // protected paths.
  PFMap _files;                // Maps the canonical filename of a project
                               // to its related information

  // find all files of a directory tree and add them to _files
  void traverse (const char *path);

  // find the canonical filename representation for a file
  bool canonFilename (Filename name, Filename &abs_name) const;
  
  // Add a new file to the project file list
  PFMConstIter addFile (const ProjectFile &file);

protected:
  // Get the destination directory for a given source directory.
  const char *getDestination (Filename file, ostream * = 0) const;
        
  // Called for every matched file.
  virtual void action (PathIterator &) {}
        
  // Add the separator '/' to the copy of the given string.
  char *addSeparator (const char *) const;

public:
  PathManager (ErrorStream &e) : _err (&e) {} 
  // Copy-constructor.
  PathManager (PathManager &pm) { _err = pm._err; join (pm); }
  virtual ~PathManager ();

  // Start the globbing. Let call action for every match.
  void glob (char *pattern = (char*) 0);

  // Iterate the contents of the paths.
  const char *iterate (PathIterator &) const;
        
  // Add a source and destination directories pair.
  virtual void addPath (const char *, const char * = (const char*) 0);

  // Add a new file to the project file list
  PFMConstIter addFile (Filename name);

  // Add a new file to the project file list with destination path
  PFMConstIter addFile (Filename name, Filename dest);

  // search an absolute file name in the project tree
  bool lookupFile (Filename abs_name, PFMConstIter &iter) const;

  // Set the destination directory of the given source directory.
  void setDest (const char *, const char *);

  // Add a protected-path pattern.
  void protect (const char *);

  // Get path information.
  long numPaths () const { return _paths.length (); }
  long numProts () const { return _protected.length (); }
  const char *src (long pos) const { return _paths.lookup (pos).src (); }
  const char *dest (long pos) const { return _paths.lookup (pos).dest (); }
  RegComp *prot (long pos) const { return _protected.lookup (pos); }

  // Return true if the given file or path is protected.
  bool isProtected (const char *file) const;

  // checks if a give file (by name) is a registered file of this path manager
  // In case of success (found!) the an iterator is returned, which can be
  // used to access more information about the file.
  bool isBelow (const char *file, PFMConstIter &iter) const;

  // Returns true if the given file is registered with this path manager
  virtual bool isBelow (const char *file) const;

  // Configure the project from the command line or a file.
  virtual void configure (const Config &);

  // Join the paths of the given manager with the paths 
  // of this path manager.
  virtual void join (PathManager &);
        
  // Get the error stream object.
  ErrorStream &err () const { return *_err; }

  // Get the path of a file in the destination directory.
  bool getDestinationPath (const char *filename, ostream &out) const;
        
};

inline bool PathManager::isBelow (const char *file) const { 
  PFMConstIter iter;
  return isBelow (file, iter);
}


} // namespace Puma

#endif /* __path_manager__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __UnitManager__
#define __UnitManager__

// Class UnitManager helps you to have control of all units built.

#include <list>
using namespace std;
namespace Puma {


class Unit;
class Source;
class Tokenizer;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class UnitManager {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef map<string, Unit*> UMap;
private:
  ErrorStream *_err;        // For error messages.
  list<Unit*> _nonames;     // Noname units list.
  mutable UMap _umap;       // Named units, map supports fast lookup by name
  typedef UMap::value_type UMapPair;
  Tokenizer *_tokenizer;    // File scanner.

public:
  UnitManager (ErrorStream &err) : _err (&err), _tokenizer (0) {}
        
  // Destructor: Delete all units.
  virtual ~UnitManager ();
        
  // Get the unit hash table.
  UMap &getTable () const { return _umap; }
  typedef UMap::iterator UMapIter;
        
  // Get/Set the file scanner that is used by newUnit
  Tokenizer *tokenizer () const { return _tokenizer; }
  void tokenizer (Tokenizer *t) { _tokenizer = t; }
 
  // Add a unit to manager.
  void addUnit (Unit *unit);
        
  // Remove (and destroy) a unit from hash table. If the name
  // is NULL remove all (but not the nonames).
  void removeUnit (const char *name = (const char*) 0, bool = false, 
                   bool destroy = true) const;

  // Empty a unit. Don't remove from hash table.
  // Preserve the last save location information.
  void closeUnit (const char *name = (const char*) 0, bool = false) const;

  // Build and add a new unit. 
  Unit *newUnit (const char *, Source *in = (Source*) 0, bool = false);
        
  // Get a unit by name. 
  Unit *getUnit (const char *name, bool = false) const;
                        
  // Print given unit to the given outstream. If no
  // name is given, print all units.
  void print (const char *name = (const char*) 0, bool = false, 
              ostream &out = cout) const;

  // Destroy all noname units.
  void removeNonames ();
      
  // Initialize the unit manager and the managed 
  // units for the next parse process.
  void init ();
};


} // namespace Puma

#endif /* __UnitManager__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SaveMode__
#define __SaveMode__

namespace Puma {


// Project file save mode.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
struct SaveMode {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  enum Mode { 
    OVERWRITE = 1, 
    RENAME_OLD, 
    NEW_SUFFIX 
  };
};
    

} // namespace Puma

#endif /* __SaveMode__ */
#include <fstream>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Project : public PathManager, public SaveMode {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  UnitManager  _unitManager; 
  const char  *_suffix;           // Current file name suffix.
  Mode         _mode;      // Current save mode.

  // Change to the directory, or create it if necessary.
  bool makeDir (const char *) const;
        
  // Create the directory hierarchy need for file 'path'.
  bool makeDirHierarchy (Filename path) const;

protected:
  // Write a unit on a file. Called by save().
  virtual void write (Unit *unit, ofstream &) const; 

  // Check/update the state of the given unit.
  bool checkState (const char *, Unit *) const;
  void updateState (const char *, Unit *) const;
        
public:
  Project (ErrorStream &);
  virtual ~Project ();

  // Set the mode for saving an unit.
  // OVERWRITE  -> Save the unit under its name and overwrite existing
  //                   files.
  // RENAME_OLD -> An existing file will be renamed. A suffix will be
  //                   added to the name of the file, like `main.cc.old'
  //                   for the file `main.cc' and the suffix `.old'.
  // NEW_SUFFIX -> The unit will be saved with a new suffix, like 
  //                   `main.cpp' for the unit `main.cc' and the suffix 
  //               `cpp'.
  void saveMode (Mode = OVERWRITE, const char *suffix = (const char*)0);

  // Save a unit using the name of the unit to get the full 
  // name of the file and path to save to. The save location
  // must not be protected by a protect pattern and the original
  // file must be located in one of the source directories.
  virtual void save (Unit *, bool = false) const;
        
  // Save a FileUnit (or all) to a file (or files).
  virtual void save (const char *file = (const char*)0,
                     bool only_modified = false, bool is_reg_ex = false) const;

  // Print an unit, regular expression for more units.
  // If no name is given print all units.
  void print (const char *name = (const char*)0, ostream &out = cout,
              bool is_reg_ex = false) const;
        
  // Close an unit, regular expression for more units.
  // If no name is given close all units. If destroy is true,
  // the unit(s) will be deleted. 
  void close (const char *name = (const char*)0, bool destroy = false,
              bool is_reg_ex = false) const;

  // Add a new file to the project.
  Unit *addFile (Filename);
  Unit *addFile (Filename, Filename);

  // Configure the project from the command line or a file.
  virtual void configure (const Config &);
        
  // Member access.
  UnitManager &unitManager ();
        
  // Return true if the given file in the source directory
  // (or at the unit manager) is newer than the corresponding
  // file in the destination directory.
  bool isNewer (const char *) const;

  // Returns true if the given file is in or below the project dirs
  virtual bool isBelow (const char *) const;
  virtual bool isBelow (Unit *) const;
};

inline UnitManager &Project::unitManager () 
 {  return _unitManager; }

inline bool Project::isBelow (const char *file) const
 { return PathManager::isBelow (file); }
 
 
} // namespace Puma

#endif /* __project__ */

#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

#include "Puma/CRecognizer.h"
#include "Puma/Location.h"
#include "Puma/LanguageID.h"
#include "Puma/Tokenizer.h"
#include "Puma/Unit.h"
#include "Puma/ErrorSink.h"
#include "Puma/Config.h"
#include "Puma/Source.h"

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
namespace Puma {


class Source;
class CTypeInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CProject : public Project {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Config _config;
  CScanner _scanner;

public:
  CProject (ErrorStream &e);

  // Constructor: Add some source directories.
  CProject (ErrorStream &, const char *defs, 
               const char *decls = (const char*)0); 

  // Constructor: Setup preprocessor configuration according to
  // command line parameter and the global config file and
  // add some source directories.
  CProject (ErrorStream &, int &argc, char **&argv, 
            const char *defs = (const char*)0, 
            const char *decls = (const char*)0);

public: // Project configuration 
  // Get the preprocessor configuration.
  Config &config ();

  // Configure the project from the command line or a file.
  virtual void configure (Config &);

  // Add a new file to the project.
  Unit *addFile (Filename file);

public: // Scanner interface
  // Get the scanner.
  CScanner &scanner ();

  // Scan the file `file' or the source if given. When
  // scanning a source the resulting unit gets the name `file'.
  public: inline ::Puma::Unit * __exec_old_scanFile(const char * file,::Puma::Source * ,bool isFile);
virtual Unit *scanFile (const char *file, Source * = (Source*)0, 
                          bool isFile = true);
        
  // Scan a string. The resulting unit gets the name `name'.
  // (and will not be registered at the unit manager!)
  virtual Unit *scanString (const char *str, 
                            const char *name = (const char*)0);

public: // Miscellaneous Functions

  // Give the filename needed to include a particular header file
  Filename getInclString (Filename filename);

private:
  // Map the type string from --size-type and --ptrdiff-type
  // to real Puma type.
  CTypeInfo *mapType (const char *) const;
};

inline Config &CProject::config () 
 { return _config; }
inline CScanner &CProject::scanner () 
 { return _scanner; }


} // namespace Puma

#endif /* __CProject_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __unit_iterator__
#define __unit_iterator__

// Iterator for token units.

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class UnitIterator {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Unit  *_unit;           // Unit to iterate.
  Token *_current;        // The current token.
 
public:
  UnitIterator ();        // Nothing to iterate!

  // Unit to iterate is the unit the given token belongs to.
  UnitIterator (ListElement &);        
  UnitIterator (Unit &);
        
  // Same as UnitIterator(ListElement&) etc.
  UnitIterator &operator =(ListElement &); 
  UnitIterator &operator =(Unit &);
        
  UnitIterator &operator ++();      // Next token in unit.
  UnitIterator &operator --();      // Previous token in unit.

  Token *operator *() const;        // Get the current token itself.
  Token *operator ->() const;       // Call a member on the current token.
};


} // namespace Puma

#endif /* __unit_iterator__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeInfo_h__
#define __CTypeInfo_h__

namespace Puma {


class CClassDatabase;
class CRecord;
class CClassInfo;
class CUnionInfo;
class CEnumInfo;
class CFunctionInfo;
class CTypeList;
class CTypeQualified;
class CTypeFunction;
class CTypeBitField; 
class CTypePointer; 
class CTypeMemberPointer; 
class CTypeTemplateParam; 
class CTypeAddress; 
class CTypeArray; 
class CTypeVarArray;
class CTypeClass;
class CTypeUnion;
class CTypeEnum;
class CTypePrimitive;
class CTypeRecord;
class CT_ExprList;
class CObjectInfo;
class CScopeInfo;
//class ostream;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeInfo : public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // needed for type printing
  enum PrintState {
    PRINT_STD = 0,  // standard
    PRINT_PRE = 1,  // printing a declarator prefix like '*' or '&'
    PRINT_ABS = 2,  // printing absolute names
    PRINT_TPL = 4,  // printing template argument list
    PRINT_TDN = 8   // print typedef names instead of defined type
  };

public:
  enum TypeId {
    /* DO NOT CHANGE THIS ORDER */
    TYPE_BOOL,
    TYPE_SIGNED_CHAR,
    TYPE_UNSIGNED_CHAR,
    TYPE_CHAR,
    TYPE_UNSIGNED_SHORT,
    TYPE_SHORT,
    TYPE_UNSIGNED_INT,
    TYPE_WCHAR_T,
    TYPE_INT,
    TYPE_UNSIGNED_LONG,
    TYPE_LONG,
    TYPE_UNSIGNED_LONG_LONG,
    TYPE_LONG_LONG,
    TYPE_FLOAT,
    TYPE_DOUBLE,
    TYPE_LONG_DOUBLE,

    TYPE_VOID,
    TYPE_UNDEFINED,
    TYPE_UNKNOWN_T,
    TYPE_ELLIPSIS,
    
    TYPE_CLASS,
    TYPE_UNION,
    TYPE_ENUM,
    TYPE_POINTER,
    TYPE_ADDRESS,
    TYPE_MEMBER_POINTER,
    TYPE_FUNCTION,
    TYPE_ARRAY,
    TYPE_VAR_ARRAY,
    TYPE_QUALIFIED,
    TYPE_BIT_FIELD,
    
    TYPE_TEMPLATE_PARAM,
    TYPE_EMPTY
  };
  
  // internal representation of size_t and ptrdiff_t types
  static CTypeInfo *CTYPE_SIZE_T;
  static CTypeInfo *CTYPE_PTRDIFF_T;

private:
  CTypeInfo   *_Base;
  TypeId       _Id;
  CObjectInfo *_TypedefInfo;

public:
  CTypeInfo (CTypeInfo *, TypeId);
  ~CTypeInfo ();

  bool operator ==(const CTypeInfo &) const;
  bool operator !=(const CTypeInfo &) const;
  
  void print (ostream& os) const;
  void TypeText (ostream &, const char * = (const char*)0,
                 bool abs = false, bool tdef = false) const;
  long int Dimension () const;
  
  long int Size () const;
  long int Align () const;

  TypeId Id () const;

  CTypeInfo *BaseType () const;
  void BaseType (CTypeInfo *);

  bool isTypedef () const;
  CObjectInfo *TypedefInfo () const;
  CTypeInfo *TypedefInfo (CObjectInfo *);

  bool isComplete (unsigned long = 0) const;
  bool isConst () const;
  bool isVolatile () const;
  bool isRestrict () const;
  bool isDependent (bool = true) const;
  
  CRecord *Record () const;
  CClassInfo *ClassInfo () const;
  CUnionInfo *UnionInfo () const;
  CEnumInfo *EnumInfo () const;
  CFunctionInfo *FunctionInfo () const;

  CTypeInfo *PtrBaseType () const;
  CTypeList *ArgTypes () const;
  CTypeInfo *VirtualType () const;
  CTypeInfo *UnqualType () const;
    
  CTypeFunction *PtrToFct () const;
  CTypeArray *PtrToArray () const;
  
  CTypeQualified *TypeQualified () const;
  CTypeFunction *TypeFunction () const;
  CTypeBitField *TypeBitField () const; 
  CTypePointer *TypePointer () const; 
  CTypeMemberPointer *TypeMemberPointer () const; 
  CTypeAddress *TypeAddress () const; 
  CTypeArray *TypeArray () const; 
  CTypeVarArray *TypeVarArray () const;
  CTypeClass *TypeClass () const;
  CTypeUnion *TypeUnion () const;
  CTypeRecord *TypeRecord () const;
  CTypeEnum *TypeEnum () const;
  CTypePrimitive *TypePrimitive () const;
  CTypeInfo *TypeEmpty () const;
  CTypeTemplateParam *TypeTemplateParam () const;

  bool isQualified () const;
  bool isPointer () const;
  bool isPointerOrArray () const;
  bool isAddress () const;
  bool isRecord () const;
  bool isClass () const;
  bool isUnion () const;
  bool isArray () const;
  bool isFixedArray () const;
  bool isVarArray () const;
  bool isArithmetic () const;
  bool isScalar () const;
  bool isAggregate () const;
  bool isInteger () const;
  bool isVoid () const;
  bool isEnum () const;
  bool isReal () const;
  bool isMemberPointer () const;
  bool isUndefined () const;
  bool isFunction () const;
  bool isBitField () const;
  bool isMethod () const;
  bool isStdFunction () const;
  bool isTemplate () const;
  bool isTemplateInstance () const;
  bool isTemplateParam () const;
  bool isTypeParam () const;
  bool isNonTypeParam () const;
  bool isObject (unsigned long = 0) const;

  // Primitive types.
  bool is_bool () const;
  bool is_char () const;
  bool is_wchar_t () const;
  bool is_short () const;
  bool is_int () const;
  bool is_long () const;
  bool is_long_long () const;
  bool is_signed_char () const;
  bool is_unsigned_char () const;
  bool is_unsigned_short () const;
  bool is_unsigned_int () const;
  bool is_unsigned_long () const;
  bool is_unsigned_long_long () const;
  bool is_float () const;
  bool is_double () const;
  bool is_long_double () const;
  bool is_void () const;
  bool is_undefined () const;
  bool is_unknown_t () const;
  bool is_ellipsis () const;
  
  bool is_signed () const;
  bool is_unsigned () const;

  // arithmetic conversion rank (C only)
  unsigned conv_rank () const;
  // compare arithmetic types (C only)
  bool operator >(const CTypeInfo &) const;
  bool operator >=(const CTypeInfo &) const;
  bool operator <=(const CTypeInfo &) const;
  bool operator <(const CTypeInfo &) const;
  
  // rank C++ arithmetic types
  unsigned rank () const;
  
public:
  // Duplicate the given type structure.
#ifndef __puma // PUMA is confused by static and non-static declaration
  static
#endif
  CTypeInfo *Duplicate (const CTypeInfo *);
  // Duplicate this.
  CTypeInfo *Duplicate () const;

  // Destroy the given type structure.
  static void Destroy (CTypeInfo *);

  void Mangled (ostream &) const;

private:
  void TypeText (char, ostream &, const char * = (const char*)0) const;
  void printName (char, ostream &, CObjectInfo *) const;
  void printScope (char, ostream &, CObjectInfo *) const;
};

extern CTypeInfo CTYPE_EMPTY;

} // namespace Puma


// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypePrimitive_h__
#define __CTypePrimitive_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypePrimitive : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_Text;

public:
  CTypePrimitive (const char *, TypeId);
  ~CTypePrimitive ();
  
  const char *TypeName () const;
};

inline CTypePrimitive::CTypePrimitive (const char *t, CTypeInfo::TypeId id) :
  CTypeInfo (&CTYPE_EMPTY, id),
  _Text (t)
 {}
inline CTypePrimitive::~CTypePrimitive () 
 {}
 
inline const char *CTypePrimitive::TypeName () const
 { return _Text; }

// Basic types //////////////////////////////////////////////////

extern CTypePrimitive CTYPE_BOOL;
extern CTypePrimitive CTYPE_CHAR;
extern CTypePrimitive CTYPE_SIGNED_CHAR;
extern CTypePrimitive CTYPE_UNSIGNED_CHAR;
extern CTypePrimitive CTYPE_WCHAR_T;
extern CTypePrimitive CTYPE_SHORT;
extern CTypePrimitive CTYPE_UNSIGNED_SHORT;
extern CTypePrimitive CTYPE_INT;
extern CTypePrimitive CTYPE_UNSIGNED_INT;
extern CTypePrimitive CTYPE_LONG;
extern CTypePrimitive CTYPE_UNSIGNED_LONG;
extern CTypePrimitive CTYPE_LONG_LONG;
extern CTypePrimitive CTYPE_UNSIGNED_LONG_LONG;
extern CTypePrimitive CTYPE_FLOAT;
extern CTypePrimitive CTYPE_DOUBLE;
extern CTypePrimitive CTYPE_LONG_DOUBLE;
extern CTypePrimitive CTYPE_VOID;
extern CTypePrimitive CTYPE_UNKNOWN_T;
extern CTypePrimitive CTYPE_UNDEFINED;
extern CTypePrimitive CTYPE_ELLIPSIS;


} // namespace Puma

#endif /* __CTypePrimitive_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeQualified_h__
#define __CTypeQualified_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeQualified : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _Const;
  bool _Volatile;
  bool _Restrict;

protected:
  CTypeQualified (CTypeInfo *, bool, bool, bool, TypeId);
  
public:
  CTypeQualified (CTypeInfo *, bool, bool, bool);
  ~CTypeQualified ();

  bool isConst () const;
  bool isVolatile () const;
  bool isRestrict () const;

  void isConst (bool);
  void isVolatile (bool);
  void isRestrict (bool);
};

inline CTypeQualified::CTypeQualified (CTypeInfo *base, bool c, bool v, bool r, 
 CTypeInfo::TypeId id) :
  CTypeInfo (base, id),
  _Const (c),
  _Volatile (v),
  _Restrict (r)
 {}
inline CTypeQualified::CTypeQualified (CTypeInfo *base, bool c, bool v, bool r) :
  CTypeInfo (base, CTypeInfo::TYPE_QUALIFIED),
  _Const (c),
  _Volatile (v),
  _Restrict (r)
 {}
inline CTypeQualified::~CTypeQualified ()
 {}
 
inline bool CTypeQualified::isConst () const
 { return _Const; }
inline bool CTypeQualified::isVolatile () const
 { return _Volatile; }
inline bool CTypeQualified::isRestrict () const
 { return _Restrict; }

inline void CTypeQualified::isConst (bool v)
 { _Const = v; }
inline void CTypeQualified::isVolatile (bool v)
 { _Volatile = v; }
inline void CTypeQualified::isRestrict (bool v)
 { _Restrict = v; }


} // namespace Puma

#endif /* __CTypeQualified_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeAddress_h__
#define __CTypeAddress_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeAddress : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeAddress (CTypeInfo *);
  ~CTypeAddress ();
};

inline CTypeAddress::CTypeAddress (CTypeInfo *base) :
  CTypeInfo (base, CTypeInfo::TYPE_ADDRESS)
 {}
inline CTypeAddress::~CTypeAddress ()
 {}


} // namespace Puma

#endif /* __CTypeAddress_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeBitField_h__
#define __CTypeBitField_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeBitField : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  long int _Size;

public:
  CTypeBitField (CTypeInfo *);
  ~CTypeBitField ();

  void Dimension (long int);
  long int Dimension () const;
};

inline CTypeBitField::CTypeBitField (CTypeInfo *base) :
  CTypeInfo (base, CTypeInfo::TYPE_BIT_FIELD),
  _Size (0)
 {}
inline CTypeBitField::~CTypeBitField ()
 {}
 
inline void CTypeBitField::Dimension (long int v) 
 { _Size = v; }
inline long int CTypeBitField::Dimension () const
 { return _Size; }


} // namespace Puma

#endif /* __CTypeBitField_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeArray_h__
#define __CTypeArray_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeArray : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  long int _Size;
  bool _isFixed;
  CTypeQualified *_Quals;
  CTypeTemplateParam *_DepDim;

protected:
  CTypeArray (CTypeInfo *, CTypeQualified *, TypeId);
  
public:
  CTypeArray (CTypeInfo *, CTypeQualified * = 0);
  ~CTypeArray ();

  void Dimension (long int);
  long int Dimension () const;
  
  void isFixed (bool);
  bool isFixed () const;
  
  CTypeQualified *Qualifiers () const;
  
  void DepDim (CTypeTemplateParam *);
  CTypeTemplateParam *DepDim () const;
};

inline CTypeArray::CTypeArray (CTypeInfo *base, CTypeQualified *quals) :
  CTypeInfo (base, CTypeInfo::TYPE_ARRAY),
  _Size (0),
  _isFixed (false),
  _Quals (quals),
  _DepDim (0)
 {}
inline CTypeArray::CTypeArray (CTypeInfo *base, CTypeQualified *quals, CTypeInfo::TypeId id) :
  CTypeInfo (base, id),
  _Size (0),
  _isFixed (false),
  _Quals (quals),
  _DepDim (0)
 {}
inline CTypeArray::~CTypeArray ()
 { if (_Quals) CTypeInfo::Destroy (_Quals); }

inline void CTypeArray::Dimension (long int d)
 { _Size = d; }
inline long int CTypeArray::Dimension () const
 { return _Size; }

inline void CTypeArray::isFixed (bool v)
 { _isFixed = v; }
inline bool CTypeArray::isFixed () const
 { return _isFixed; }

inline CTypeQualified *CTypeArray::Qualifiers () const
 { return _Quals; }
 
inline void CTypeArray::DepDim (CTypeTemplateParam *tp) 
 { _DepDim = tp; }
inline CTypeTemplateParam *CTypeArray::DepDim () const
 { return _DepDim; }


} // namespace Puma

#endif /* __CTypeArray_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeVarArray_h__
#define __CTypeVarArray_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeVarArray : public CTypeArray {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeVarArray (CTypeInfo *, CTypeQualified * = 0);
  ~CTypeVarArray ();
};

inline CTypeVarArray::CTypeVarArray (CTypeInfo *base, CTypeQualified *quals) :
  CTypeArray (base, quals, CTypeInfo::TYPE_VAR_ARRAY)
 {}
inline CTypeVarArray::~CTypeVarArray ()
 {}


} // namespace Puma

#endif /* __CTypeVarArray_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypePointer_h__
#define __CTypePointer_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypePointer : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  CTypePointer (CTypeInfo *, CTypeInfo::TypeId);

public:
  CTypePointer (CTypeInfo *);
  ~CTypePointer ();
};

inline CTypePointer::CTypePointer (CTypeInfo *base) :
  CTypeInfo (base, CTypeInfo::TYPE_POINTER)
 {}
inline CTypePointer::CTypePointer (CTypeInfo *base, CTypeInfo::TypeId id) :
  CTypeInfo (base, id)
 {}
inline CTypePointer::~CTypePointer ()
 {}
 

} // namespace Puma

#endif /* __CTypePointer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeMemberPointer_h__
#define __CTypeMemberPointer_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CObjectInfo;
class CRecord;
class CTemplateParamInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeMemberPointer : public CTypePointer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CObjectInfo *_Class;

public:
  CTypeMemberPointer (CTypeInfo *, CObjectInfo *);
  ~CTypeMemberPointer ();

  CRecord *Record () const;
  CTemplateParamInfo *TemplateParam () const;
};

inline CTypeMemberPointer::CTypeMemberPointer (CTypeInfo *base, CObjectInfo *c) :
  CTypePointer (base, CTypeInfo::TYPE_MEMBER_POINTER),
  _Class (c)
 {}
inline CTypeMemberPointer::~CTypeMemberPointer ()
 {}


} // namespace Puma

#endif /* __CTypeMemberPointer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeFunction_h__
#define __CTypeFunction_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeList_h__
#define __CTypeList_h__

namespace Puma {


class CTypeInfo;
class CT_ArgDeclList;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeList {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CTypeInfo*> _List;
  CT_ArgDeclList *_ArgumentList;

public:
  CTypeList (int len = 3);
  ~CTypeList ();

  unsigned Entries () const;
  CTypeInfo *Entry (unsigned) const;
  void ReplaceEntry (unsigned, CTypeInfo *);
  
  CT_ArgDeclList *ArgumentList () const;
  void ArgumentList (CT_ArgDeclList *);
  
  void AddEntry (CTypeInfo *);
  
  bool isDependent () const;
};

inline CTypeList::CTypeList (int len) :
  _List (len),
  _ArgumentList ((CT_ArgDeclList*)0)
 {}
inline CTypeList::~CTypeList ()
 {}

inline CT_ArgDeclList *CTypeList::ArgumentList () const
 { return _ArgumentList; }
inline void CTypeList::ArgumentList (CT_ArgDeclList *al)
 { _ArgumentList = al; }

inline unsigned CTypeList::Entries () const
 { return _List.length (); }
inline CTypeInfo *CTypeList::Entry (unsigned i) const
 { return _List.lookup (i); }
 
inline void CTypeList::AddEntry (CTypeInfo *info) 
 { if (info) _List.append (info); }
inline void CTypeList::ReplaceEntry (unsigned i, CTypeInfo *info)
 { if (info && (i < Entries ())) _List[i] = info; }


} // namespace Puma

#endif /* __CTypeList_h__ */
namespace Puma {


class CFunctionInfo;
class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeFunction : public CTypeQualified {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTypeList *_ArgTypes;
  CFunctionInfo *_Function;
  bool _hasPrototype;

public:
  CTypeFunction (CTypeInfo *, CTypeList *, bool);
  ~CTypeFunction ();

  CTypeList *ArgTypes () const;
  CTypeInfo *ReturnType () const;  

  CFunctionInfo *FunctionInfo () const;
  CRecord *Record () const;

  bool hasPrototype () const;
  void FunctionInfo (CFunctionInfo *);
  
  bool isStatic () const;
};

inline CTypeFunction::CTypeFunction (CTypeInfo *base, CTypeList *l, 
  bool prototype) :
  CTypeQualified (base, false, false, false, CTypeInfo::TYPE_FUNCTION),
  _ArgTypes (l),
  _Function (0),
  _hasPrototype (prototype)
 {}
inline CTypeFunction::~CTypeFunction ()
 {}
 
inline bool CTypeFunction::hasPrototype () const
 { return _hasPrototype; }
inline CTypeList *CTypeFunction::ArgTypes () const 
 { return _ArgTypes; }
inline CTypeInfo *CTypeFunction::ReturnType () const 
 { return BaseType (); }
inline CFunctionInfo *CTypeFunction::FunctionInfo () const 
 { return _Function; }
inline void CTypeFunction::FunctionInfo (CFunctionInfo *info)
 { _Function = info; }


} // namespace Puma

#endif /* __CTypeFunction_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeEnum_h__
#define __CTypeEnum_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CEnumInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeEnum : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CEnumInfo *_Enum;

public:
  CTypeEnum (CEnumInfo *);
  ~CTypeEnum ();

  CEnumInfo *EnumInfo () const;
  bool isComplete (unsigned long = 0) const;
};

inline CTypeEnum::CTypeEnum (CEnumInfo *e) :
  CTypeInfo (&CTYPE_EMPTY, CTypeInfo::TYPE_ENUM),
  _Enum (e)
 {}
inline CTypeEnum::~CTypeEnum ()
 {}
 
inline CEnumInfo *CTypeEnum::EnumInfo () const 
 { return _Enum; }
 

} // namespace Puma

#endif /* __CTypeEnum_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeRecord_h__
#define __CTypeRecord_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeRecord : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _hasConstMember;

  long int _Size;
  long int _Align;

  CRecord *_Record;

protected:
  CTypeRecord (TypeId, CRecord *);

public:
  ~CTypeRecord ();

  long int Size ();
  long int Align ();

  void hasConstMember (bool);
  bool hasConstMember () const;

  bool isComplete (unsigned long = 0) const;

  CRecord *Record () const;
  void Record (CRecord *);
};

inline CTypeRecord::CTypeRecord (CTypeInfo::TypeId id, CRecord *r) :
  CTypeInfo (&CTYPE_EMPTY, id),
  _hasConstMember (false),
  _Size (0),
  _Align (0),
  _Record (r)
 {}
inline CTypeRecord::~CTypeRecord ()
 {}

inline CRecord *CTypeRecord::Record () const 
 { return _Record; }
inline void CTypeRecord::Record (CRecord *r)
 { _Record = r; }

inline long int CTypeRecord::Align () 
 { return (Size (), _Align); }

inline bool CTypeRecord::hasConstMember () const
 { return _hasConstMember; }
inline void CTypeRecord::hasConstMember (bool v)
 { _hasConstMember = v; }


} // namespace Puma

#endif /* __CTypeRecord_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeClass_h__
#define __CTypeClass_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CClassInfo;
class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeClass : public CTypeRecord {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeClass (CRecord *);
  ~CTypeClass ();

  CClassInfo *ClassInfo () const;
};

inline CTypeClass::CTypeClass (CRecord *c) :
  CTypeRecord (CTypeInfo::TYPE_CLASS, c)
 {}
inline CTypeClass::~CTypeClass ()
 {}
 

} // namespace Puma

#endif /* __CTypeClass_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeUnion_h__
#define __CTypeUnion_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CUnionInfo;
class CRecord;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeUnion : public CTypeRecord {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  CTypeUnion (CRecord *);
  ~CTypeUnion ();
  
  CUnionInfo *UnionInfo () const;
};

inline CTypeUnion::CTypeUnion (CRecord *u) :
  CTypeRecord (CTypeInfo::TYPE_UNION, u)
 {}
inline CTypeUnion::~CTypeUnion ()
 {}


} // namespace Puma

#endif /* __CTypeUnion_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeTemplateParam_h__
#define __CTypeTemplateParam_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CTemplateParamInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CTypeTemplateParam : public CTypeInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CTemplateParamInfo *_TemplateParam;

public:
  CTypeTemplateParam (CTemplateParamInfo *);
  ~CTypeTemplateParam ();

  CTemplateParamInfo *TemplateParamInfo () const;
  bool isType () const;
  bool isNonType () const;
};

inline CTypeTemplateParam::CTypeTemplateParam (CTemplateParamInfo *t) :
  CTypeInfo (&CTYPE_EMPTY, CTypeInfo::TYPE_TEMPLATE_PARAM),
  _TemplateParam (t)
 {}
inline CTypeTemplateParam::~CTypeTemplateParam ()
 {}
 
inline CTemplateParamInfo *CTypeTemplateParam::TemplateParamInfo () const 
 { return _TemplateParam; }
 
inline bool CTypeTemplateParam::isNonType () const
 { return (! isType ()); }


} // namespace Puma

#endif /* __CTypeTemplateParam_h__ */
namespace Puma {

inline CTypeInfo::CTypeInfo (CTypeInfo *info, CTypeInfo::TypeId id) :
  _Base (info ? info : this), 
  _Id (id),
  _TypedefInfo (0)
 {}
inline CTypeInfo::~CTypeInfo () 
 {}

inline CTypeInfo *CTypeInfo::Duplicate () const 
 { 
#ifndef __puma
return Duplicate (this);
#endif
 }

inline CTypeInfo::TypeId CTypeInfo::Id () const 
 { return _Id; }

inline bool CTypeInfo::operator !=(const CTypeInfo &type) const 
 { return ! (*this == type); }

inline void CTypeInfo::print (ostream& out) const 
 { TypeText ((char)PRINT_STD, out); }
inline void CTypeInfo::TypeText (ostream &out, const char *t, bool abs, bool tdef) const
 { char flags = (char)(abs ? PRINT_ABS : PRINT_STD);
   if (tdef) flags |= (char)PRINT_TDN; TypeText (flags, out, t); }

inline long int CTypeInfo::Dimension () const
 { return TypeArray () ? TypeArray ()->Dimension () : 
          TypeBitField () ? TypeBitField ()->Dimension () : -1; }
 
inline bool CTypeInfo::isTypedef () const
 { return (bool)_TypedefInfo; }
inline CObjectInfo *CTypeInfo::TypedefInfo () const
 { return _TypedefInfo; }

inline bool CTypeInfo::isConst () const
 { return TypeQualified () && TypeQualified ()->isConst (); }
inline bool CTypeInfo::isVolatile () const
 { return TypeQualified () && TypeQualified ()->isVolatile (); }
inline bool CTypeInfo::isRestrict () const
 { return TypeQualified () && TypeQualified ()->isRestrict (); }
  
inline CRecord *CTypeInfo::Record () const
 { return TypeRecord () ? TypeRecord ()->Record () :
          TypeFunction () ? TypeFunction ()->Record () :
          TypeMemberPointer () ? TypeMemberPointer ()->Record () : (CRecord*)0; }
inline CEnumInfo *CTypeInfo::EnumInfo () const
 { return TypeEnum () ? TypeEnum ()->EnumInfo () : (CEnumInfo*)0; }
inline CFunctionInfo *CTypeInfo::FunctionInfo () const
 { return TypeFunction () ? TypeFunction ()->FunctionInfo () : (CFunctionInfo*)0; }

inline CTypeInfo *CTypeInfo::BaseType () const
 { assert(_Base); return _Base; }
inline void CTypeInfo::BaseType (CTypeInfo *type)
 { _Base = type; }
inline CTypeInfo *CTypeInfo::PtrBaseType () const
 { return VirtualType ()->BaseType (); }

inline CTypeList *CTypeInfo::ArgTypes () const
 { return TypeFunction () ? TypeFunction ()->ArgTypes () :
          TypeQualified () ? TypeQualified ()->ArgTypes () : (CTypeList*)0; }

inline CTypePrimitive *CTypeInfo::TypePrimitive () const
 { return _Id < TYPE_CLASS ? (CTypePrimitive*)this : (CTypePrimitive*)0; }
inline CTypeQualified *CTypeInfo::TypeQualified () const
 { return _Id == TYPE_QUALIFIED ? (CTypeQualified*)this : (CTypeQualified*)0; }
inline CTypeFunction *CTypeInfo::TypeFunction () const
 { return _Id == TYPE_FUNCTION ? (CTypeFunction*)this : (CTypeFunction*)0; }
inline CTypeBitField *CTypeInfo::TypeBitField () const 
 { return _Id == TYPE_BIT_FIELD ? (CTypeBitField*)this : (CTypeBitField*)0; }
inline CTypePointer *CTypeInfo::TypePointer () const
 { return _Id == TYPE_POINTER || _Id == TYPE_MEMBER_POINTER ? (CTypePointer*)this : (CTypePointer*)0; }
inline CTypeMemberPointer* CTypeInfo::TypeMemberPointer () const
 { return _Id == TYPE_MEMBER_POINTER ? (CTypeMemberPointer*)this : (CTypeMemberPointer*)0; }
inline CTypeAddress *CTypeInfo::TypeAddress () const
 { return _Id == TYPE_ADDRESS ? (CTypeAddress*)this : (CTypeAddress*)0; }
inline CTypeArray *CTypeInfo::TypeArray () const
 { return _Id == TYPE_ARRAY || _Id == TYPE_VAR_ARRAY ? (CTypeArray*)this : (CTypeArray*)0; }
inline CTypeVarArray *CTypeInfo::TypeVarArray () const
 { return _Id == TYPE_VAR_ARRAY ? (CTypeVarArray*)this : (CTypeVarArray*)0; }
inline CTypeRecord *CTypeInfo::TypeRecord () const
 { return _Id == TYPE_CLASS || _Id == TYPE_UNION ? (CTypeRecord*)this : (CTypeRecord*)0; }
inline CTypeClass *CTypeInfo::TypeClass () const
 { return _Id == TYPE_CLASS ? (CTypeClass*)this : (CTypeClass*)0; }
inline CTypeUnion *CTypeInfo::TypeUnion () const
 { return _Id == TYPE_UNION ? (CTypeUnion*)this : (CTypeUnion*)0; }
inline CTypeEnum *CTypeInfo::TypeEnum () const
 { return _Id == TYPE_ENUM ? (CTypeEnum*)this : (CTypeEnum*)0; }
inline CTypeInfo *CTypeInfo::TypeEmpty () const
 { return _Id == TYPE_EMPTY ? (CTypeInfo*)this : (CTypeInfo*)0; }
inline CTypeTemplateParam *CTypeInfo::TypeTemplateParam () const
 { return _Id == TYPE_TEMPLATE_PARAM ? (CTypeTemplateParam*)this : (CTypeTemplateParam*)0; }

inline CTypeInfo *CTypeInfo::VirtualType () const 
 { return TypeQualified () || TypeBitField () || TypeAddress () ?
          BaseType ()->VirtualType () : (CTypeInfo*)this; }
inline CTypeInfo *CTypeInfo::UnqualType () const 
 { return TypeQualified () ? BaseType ()->UnqualType () : (CTypeInfo*)this; }

inline bool CTypeInfo::isQualified () const 
 { return TypeQualified (); }
inline bool CTypeInfo::isTemplateParam () const 
 { return VirtualType ()->TypeTemplateParam (); }
inline bool CTypeInfo::isPointer () const 
 { return VirtualType ()->TypePointer (); }
inline bool CTypeInfo::isMemberPointer () const
 { return VirtualType ()->TypeMemberPointer (); }
inline bool CTypeInfo::isClass () const
 { return VirtualType ()->TypeClass (); }
inline bool CTypeInfo::isUnion () const
 { return VirtualType ()->TypeUnion (); }
inline bool CTypeInfo::isArray () const
 { return VirtualType ()->TypeArray (); }
inline bool CTypeInfo::isFixedArray () const
 { return VirtualType ()->TypeArray () && 
          VirtualType ()->TypeArray ()->isFixed (); }
inline bool CTypeInfo::isVarArray () const
 { return VirtualType ()->TypeVarArray (); }
inline bool CTypeInfo::isEnum () const
 { return VirtualType ()->TypeEnum (); }
inline bool CTypeInfo::isFunction () const
 { return VirtualType ()->TypeFunction (); }
inline bool CTypeInfo::isBitField () const
 { return TypeBitField (); }
inline bool CTypeInfo::isUndefined () const
 { return VirtualType ()->is_undefined (); }
inline bool CTypeInfo::isInteger () const 
 { return VirtualType ()->_Id < TYPE_FLOAT || VirtualType ()->isEnum (); }
inline bool CTypeInfo::isReal () const 
 { CTypeInfo *base = VirtualType ();
   return base->is_float () || base->is_double () || base->is_long_double (); }
inline bool CTypeInfo::isMethod () const 
 { CTypeInfo *base = VirtualType ();
   return base->TypeFunction () && base->TypeFunction ()->Record (); }
inline bool CTypeInfo::isStdFunction () const
 { return VirtualType ()->TypeFunction () && ! isMethod (); }
inline bool CTypeInfo::isPointerOrArray () const 
 { CTypeInfo *base = VirtualType ();
   return base->TypePointer () || base->TypeArray (); }
inline bool CTypeInfo::isAddress () const 
 { return TypeAddress () || ((TypeQualified () || TypeBitField ()) && 
                             BaseType ()->isAddress ()); }
inline bool CTypeInfo::isRecord () const 
 { return VirtualType ()->TypeRecord (); }
inline bool CTypeInfo::isScalar () const 
 { return isArithmetic () || isPointer (); }
inline bool CTypeInfo::isAggregate () const 
 { return isArray () || isClass () || isUnion (); }
inline bool CTypeInfo::isVoid () const
 { return VirtualType ()->is_void (); }
inline bool CTypeInfo::isObject (unsigned long pos) const
 { return ! isFunction () && (pos ? isComplete (pos) : true); }
inline bool CTypeInfo::isTypeParam () const
 { return isTemplateParam () && 
          VirtualType ()->TypeTemplateParam ()->isType (); }
inline bool CTypeInfo::isNonTypeParam () const
 { return isTemplateParam () && 
          ! VirtualType ()->TypeTemplateParam ()->isType (); }

inline bool CTypeInfo::is_bool () const 
 { return _Id == TYPE_BOOL; }
inline bool CTypeInfo::is_char () const 
 { return _Id == TYPE_CHAR; }
inline bool CTypeInfo::is_wchar_t () const 
 { return _Id == TYPE_WCHAR_T; }
inline bool CTypeInfo::is_short () const 
 { return _Id == TYPE_SHORT; }
inline bool CTypeInfo::is_int () const 
 { return _Id == TYPE_INT; }
inline bool CTypeInfo::is_long () const 
 { return _Id == TYPE_LONG; }
inline bool CTypeInfo::is_long_long () const 
 { return _Id == TYPE_LONG_LONG; }
inline bool CTypeInfo::is_signed_char () const 
 { return _Id == TYPE_SIGNED_CHAR; }
inline bool CTypeInfo::is_unsigned_char () const 
 { return _Id == TYPE_UNSIGNED_CHAR; }
inline bool CTypeInfo::is_unsigned_short () const 
 { return _Id == TYPE_UNSIGNED_SHORT; }
inline bool CTypeInfo::is_unsigned_int () const 
 { return _Id == TYPE_UNSIGNED_INT; }
inline bool CTypeInfo::is_unsigned_long () const 
 { return _Id == TYPE_UNSIGNED_LONG; }
inline bool CTypeInfo::is_unsigned_long_long () const 
 { return _Id == TYPE_UNSIGNED_LONG_LONG; }
inline bool CTypeInfo::is_float () const 
 { return _Id == TYPE_FLOAT; }
inline bool CTypeInfo::is_double () const 
 { return _Id == TYPE_DOUBLE; }
inline bool CTypeInfo::is_long_double () const 
 { return _Id == TYPE_LONG_DOUBLE; }
inline bool CTypeInfo::is_void () const 
 { return _Id == TYPE_VOID; }
inline bool CTypeInfo::is_unknown_t () const 
 { return _Id == TYPE_UNKNOWN_T; }
inline bool CTypeInfo::is_undefined () const 
 { return _Id == TYPE_UNDEFINED; }
inline bool CTypeInfo::is_ellipsis () const 
 { return _Id == TYPE_ELLIPSIS; }

inline bool CTypeInfo::operator <=(const CTypeInfo &type) const
 { return ! (*this > type); }
inline bool CTypeInfo::operator >=(const CTypeInfo &type) const
 { return ! (*this < type); }


} // namespace Puma

#endif /* __CTypeInfo_h__ */
#include <stdio.h>

namespace Puma {


CProject::CProject (ErrorStream &e) : 
  Project (e), _config (e), _scanner (e) {
  unitManager ().tokenizer (&_scanner);
}

// Constructor: Add some source directories.
CProject::CProject (ErrorStream &e, const char *defs, const char *decls) : 
  Project (e), _config (e), _scanner (e) {
  unitManager ().tokenizer (&_scanner);
  if (defs)  addPath (defs);
  if (decls) addPath (decls);
}

// Constructor: Setup preprocessor configuration according to
// command line parameter and the global config file and
// add some source directories
CProject::CProject (ErrorStream &e, int &argc, char **&argv, 
                    const char *defs, const char *decls) : 
  Project (e), _config (e), _scanner (e) {
  config ().Read ();
  config ().Read (argc, argv);
  configure (config ());
  _scanner.configure (config ());
  unitManager ().tokenizer (&_scanner);
  if (defs)  addPath (defs);
  if (decls) addPath (decls);
}

// Configure the C++ project from the command line or a file.
void CProject::configure (Config &c) {
  // Configure the basic project.
  Project::configure (c); 

  // Configure the CScanner
  _scanner.configure (c);

  // Configure size_t and ptrdiff_t types
  for (unsigned i = 0; i < c.Options (); i++) {
    const ConfOption *o = c.Option (i);
    // Set the internal representation of size_t
    if (! strcmp (o->Name (), "--size-type")) {
      if (o->Arguments () < 1) continue;
      CTypeInfo *type = mapType (o->Argument (0));
      if (type) {
        CTypeInfo::CTYPE_SIZE_T = type;
      }
    // Set the internal representation of ptrdiff_t
    } else if (! strcmp (o->Name (), "--ptrdiff-type")) {
      if (o->Arguments () < 1) continue;
      CTypeInfo *type = mapType (o->Argument (0));
      if (type) {
        CTypeInfo::CTYPE_PTRDIFF_T = type;
      }
    }
  }
}

// Scan the file `file' or the source if given. When
// scanning a source the resulting unit gets the name `file'.


struct TJP__ZN4Puma8CProject8scanFileEPKcPN4PumaE6Sourceb_0 {
  typedef ::Puma::Unit * Result;
  typedef ::Puma::CProject That;
  typedef ::Puma::CProject Target;
  static const int JPID = 135;
  static const AC::JPType JPTYPE = (AC::JPType)8;
  struct Res {
    typedef ::Puma::Unit * Type;
    typedef ::Puma::Unit * ReferredType;
  };
  enum { ARGS = 3 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef const char * Type;
    typedef const char * ReferredType;
  };
  template <int DUMMY> struct Arg<1, DUMMY> {
    typedef ::Puma::Source * Type;
    typedef ::Puma::Source * ReferredType;
  };
  template <int DUMMY> struct Arg<2, DUMMY> {
    typedef bool Type;
    typedef bool ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};

Unit *CProject::scanFile (const char * arg0, Source * arg1, bool  arg2) {
  AC::ResultBuffer< ::Puma::Unit *  > result;
  TJP__ZN4Puma8CProject8scanFileEPKcPN4PumaE6Sourceb_0 tjp;
  tjp._that =  (TJP__ZN4Puma8CProject8scanFileEPKcPN4PumaE6Sourceb_0::That*)this;
  AC::invoke_ExtACKeywords_ExtACKeywords_a2_before<TJP__ZN4Puma8CProject8scanFileEPKcPN4PumaE6Sourceb_0> (&tjp);
{
      ::AC::CFlow<ExtACKeywords,0> trigger0;
  ::new (&result) ::Puma::Unit *  (this->__exec_old_scanFile(arg0, arg1, arg2));
}
  return (::Puma::Unit * &)result;

}
inline ::Puma::Unit * Puma::CProject::__exec_old_scanFile(const char * file,::Puma::Source * in,bool isFile){
  if (! file && ! in) 
    return (Unit*)0;
  Unit *unit = (Unit*)0;

  // this line must be removed from here
  _scanner.allow_wildcards (true);
  if (isFile) {
    // If unit has already been built, return that unit.
    if (! (unit = unitManager ().getUnit (file, true))) {
      if (! in) {
        in = new FileSource (file, &err ());
        if (((FdSource*)in)->fd () == -1) {
          delete in;
          return unit; // NULL
        }
      }
      unit = unitManager ().newUnit (file, in, true);
    }
  } else if (in) {
    unit = new Unit;
    unit->name (file);
    _scanner.fill_unit (*in, *unit);
    delete in;
  }
  return unit;
}

// Scan a string. The resulting unit gets the name `name'. 
// (and will not be registered at the unit manager!)
Unit *CProject::scanString (const char *str, const char *name) {
  if (! str) 
    return (Unit*)0;
  Source* in = new StringSource (str);
  return scanFile (name, in, false);
}        

// Add a new file to the project.
Unit* CProject::addFile (Filename file) {
  Unit* result = Project::addFile (file);
  return result;
}

// Give the string needed to include a particular header file
Filename CProject::getInclString (Filename filename) {
  Filename canon_file;
  if (!SysCall::canonical (filename, canon_file))
    return filename;
    
  for (unsigned i = config ().Options (); i > 0; i--) {
    const ConfOption *o = config ().Option (i-1);
    if (! strcmp (o->Name (), "-I")) {
      if (! o->Arguments ())
        continue;
      Filename canon_inc_dir;
      if (!SysCall::canonical (o->Argument (0), canon_inc_dir))
        continue;
      
      int len = strlen (canon_inc_dir.name ());
      if (strncmp (canon_inc_dir.name (), canon_file.name (), len) == 0)
        if (*(canon_file.name () + len) == '/')
          return canon_file.name () +len + 1;
    }
  }
  return filename;
}


// Map the type string from --size-type and --ptrdiff-type to real Puma type.
CTypeInfo *CProject::mapType (const char *ttxt) const {
  if (! ttxt) 
    return 0;
  
  // cut off surrounding quotes
  if (*ttxt == '"') 
    ttxt++;
  char *txt = StrCol::dup (ttxt);
  if (txt[strlen(txt)-1] == '"')
    txt[strlen(txt)-1] = '\0';

  // parse type string
  ErrorStream err;
  CUnit unit (err);
  unit << txt << endu;
  delete[] txt;

  int types[TOK_NO], type; 
  memset ((void*)types, 0, sizeof (types));
  
  UnitIterator iter (unit);
  for (; *iter; ++iter) {
    type = iter->type ();
    if (type < TOK_NO)
      types[type]++;
  }
  
  if (types[TOK_LONG] == 2) {
    if (types[TOK_UNSIGNED] == 1)
      return &CTYPE_UNSIGNED_LONG_LONG;
    else
      return &CTYPE_LONG_LONG;
  } else if (types[TOK_LONG] == 1) {
    if (types[TOK_UNSIGNED] == 1)
      return &CTYPE_UNSIGNED_LONG;
    else
      return &CTYPE_LONG;
  } else if (types[TOK_SHORT] == 1) {
    if (types[TOK_UNSIGNED] == 1)
      return &CTYPE_UNSIGNED_SHORT;
    else
      return &CTYPE_SHORT;
  } else if (types[TOK_INT] == 1) {
    if (types[TOK_UNSIGNED] == 1) 
      return &CTYPE_UNSIGNED_INT;
    else
      return &CTYPE_INT;
  } else if (types[TOK_CHAR] == 1) {
    if (types[TOK_UNSIGNED] == 1)
      return &CTYPE_UNSIGNED_CHAR;
    else if (types[TOK_SIGNED] == 1)
      return &CTYPE_SIGNED_CHAR;
    else
      return &CTYPE_CHAR;
  } else if (types[TOK_UNSIGNED] == 1) {
    return &CTYPE_UNSIGNED_INT;
  } else if (types[TOK_SIGNED] == 1) {
    return &CTYPE_INT;
  }
  
  return 0;
}


} // namespace Puma

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_CProject_cc__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinMacros__
#define __WinMacros__

/********************************************************/
/* Win predefined macros aspect                         */
/********************************************************/

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_macro__
#define __pre_macro__

// Preprocessor macro class. There are two types of macros. The first
// is called a simple macro or a symbolic constant macro. It consists
// only of a macro name and the macro body. The second type of macros
// is called a function-like macro. In addition it consists of a list 
// of arguments.

namespace Puma {


class PreTree;
class CScanner;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreMacro : public Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef Array<const char *> MacroArgs;

  enum {
    FUNCTION_MACRO = 1,                // Function-like macro.
    VAR_ARG_MACRO  = 2,                // Variable number of arguments.
    LOCK_MACRO     = 4,                // Macro cannot be redefined or undefined.
    INHIBIT_MACRO  = 8                 // Macro cannot be defined.
  };

private:
  const char*   _body;                 // Macro body.
  DString       _name;
  short         _numArgs;              // Number of arguments.
  char          _flags;                // Macro flags.
  Location      _location;             // Location of the #define directive.
  MacroArgs    *_arguments;            // The arguments array.
  Unit          _body_unit;            // The unit represeantation of the body

public:
  // Constructors for function-like macros.
  PreMacro (const DString &, PreTree *, const char *, char = 0);
  PreMacro (const DString &, MacroArgs *, const char *, char = 0);
        
  // Constructor for simple macros (constants).
  PreMacro (const DString &, const char *, char = 0);
        
  PreMacro (const PreMacro &);
  virtual ~PreMacro ();

  // Get macro attributes.
  const DString &getName () const { return _name; }
  const char *getBody () const { return _body; }
  const Unit &getBodyUnit (CScanner &scanner) {
    if (_body_unit.empty ())
      buildUnit (scanner);
    return _body_unit;
  }
  short numArgs () const { return _numArgs; }
  MacroArgs *getArgs () const { return _arguments; }
  // add an argument: the string is still owned by the caller and not copied!
  void addArg (const char *arg_name);

  // Set macro attributes
  void setBody (const char *);
   
  // Query macro flags.
  bool varArgs () const     { return _flags & VAR_ARG_MACRO; }
  bool isFunction () const  { return _flags & FUNCTION_MACRO; }
  bool isInhibited () const { return _flags & INHIBIT_MACRO; }
  bool isLocked () const    { return _flags & LOCK_MACRO; }

  // Set/get #define location.
  Location location () const { return _location; }
  void location (Location l) { _location = l; }
  
private:
  // create the unit representation
  void buildUnit (CScanner &scanner);
};


} // namespace Puma

#endif /* __pre_macro__ */
using namespace Puma;


class WinIfExists;
class WinImportHandler;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinMacros {
public:
  static WinMacros *aspectof () {
    static WinMacros __instance;
    return &__instance;
  }
  static WinMacros *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win specific predefined macros                       */
  /********************************************************/

  // predefine win specific macros
  
public: template<class JoinPoint> void __a0_before (JoinPoint *tjp, const Config &config) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (config.Option ("--vc")) {
      // constants
      thisJoinPoint->that ()->defMacro ("__w64", " ");
      thisJoinPoint->that ()->defMacro ("_inline", "inline");
      thisJoinPoint->that ()->defMacro ("__forceinline", "inline");
      thisJoinPoint->that ()->defMacro ("__interface", "class");
      thisJoinPoint->that ()->defMacro ("__try", "if(1)");
      thisJoinPoint->that ()->defMacro ("__except", "if");
      thisJoinPoint->that ()->defMacro ("__noop", " ");

      // function-like macros
      PreMacro::MacroArgs *args = new PreMacro::MacroArgs (1);
      args->append ("__arg0");
      thisJoinPoint->that ()->macroManager ()->addMacro (
        new PreMacro ("__declspec", args, " "));
    }
  }
private:


protected:
  WinMacros () {}
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinMacros_WinMacros_a0_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::WinMacros::aspectof()->__a0_before (tjp, (const Puma::Config &)Arg0::val (tjp));
  }
} 



#endif /* __WinMacros__ */
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ext_ac_keywords_ah__
#define __ext_ac_keywords_ah__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __FileUnit__
#define __FileUnit__

// Special Unit for files. Knows its last save location and the
// absolute path of the corresponding file.

namespace Puma {


class Project;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FileUnit : public Unit {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_lastLocation; 
  char *_absolutePath;
  
  Project *_project;
  bool _isBelow;

public:
  FileUnit ();
  FileUnit (Unit &);
  FileUnit (const List &);
  virtual ~FileUnit ();
            
  virtual void name (const char *);        
  void setLocation (const char *);    
        
  char *lastLocation () const;
  char *absolutePath () const;
  bool isFile () const;
  
  // Generates the absolute pathname to the file.
  static char *absolutePath (const char *);
  static char *resolvePath (const char *);
  
  // File belongs to given project?
  bool belongsTo (Project &);
};

inline FileUnit::FileUnit () : 
  Unit (), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)
 {}
inline FileUnit::FileUnit (Unit &unit) : 
  Unit (unit), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)
 {}
inline FileUnit::FileUnit (const List &list) : 
  Unit (list), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)  
 {}
inline FileUnit::~FileUnit () 
 { if (_lastLocation) delete[] _lastLocation; 
   if (_absolutePath) delete[] _absolutePath; }
            
inline char *FileUnit::lastLocation () const 
 { return _lastLocation; }
inline char *FileUnit::absolutePath () const 
 { return _absolutePath; }
inline bool FileUnit::isFile () const 
 { return true; }


} // namespace Puma

#endif /* __FileUnit__ */
using namespace Puma;

// *****************************************
// AspectC++ keyword handling in the scanner
// *****************************************
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class ExtACKeywords {
public:
  static ExtACKeywords *aspectof () {
    static ExtACKeywords __instance;
    return &__instance;
  }
  static ExtACKeywords *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  bool _prj_keywords;
  CProject *_project; // active project
  
protected:
  ExtACKeywords () : _prj_keywords (false) {}
public:
  // allow/forbid AspectC++ keywords in normal project files
  void prj_keywords (bool kw) { _prj_keywords = kw; }
  
  
public: void __a0_before (CProject &project) {
    _project = &project;
  }
  
  
public: template<class JoinPoint> void __a1_before (JoinPoint *tjp, Unit &unit) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (!unit.isFile ())
      return;
      
    bool ac_kw = _prj_keywords;
    // in external files the AspectC++ keywords are always identifiers
    if (!((FileUnit*)&unit)->belongsTo (*_project)) {
      ac_kw = false;
    }
    // in aspect headers keywords are keywords
    else if (unit.name () &&
      strcmp (unit.name () + strlen (unit.name ()) - 3, ".ah") == 0) {
      ac_kw = true;
    }
    // finally the right flag
    tjp->that ()->allow_aspectc (ac_kw);
  }
  
  
public: template<class JoinPoint> void __a2_before (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    _project = tjp->that ();
  }
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtACKeywords::aspectof()->__a0_before ((Puma::CProject &)Arg0::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtACKeywords::aspectof()->__a1_before (tjp, (Puma::Unit &)Arg0::val (tjp));
  }
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp) {
    ::ExtACKeywords::aspectof()->__a2_before (tjp);
  }
} 
  

#endif /* __ext_ac_keywords_ah__ */
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_CProject_cc__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_CProject_cc__
