// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Unit_Token_Src__
#define __Unit_Token_Src__

#include "Puma/TokenSource.h"
#include "Puma/Token.h"
#include "Puma/Unit.h"

namespace Puma {


class UnitTokenSrc : public PumaTokenSource {
  Unit &_unit;
  Token *_curr;
  bool _first;

public:
  UnitTokenSrc (Unit &);
  Token *next ();
  
  Token *current () const { return _curr; }
  Unit *unit () const { return &_unit; }
};


inline UnitTokenSrc::UnitTokenSrc (Unit &u) : _unit (u) {
  _curr = (Token*) 0;  
  _first = true;
}

inline Token *UnitTokenSrc::next () {
  if (_curr)
    _curr = (Token*) _unit.next (_curr);
  else if (_first) {
    _curr = (Token*) _unit.first ();    
    _first = false;
  }
  return _curr;
}


} // namespace Puma

#endif /* __Unit_Token_Src__ */
