// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ACIntroAnalyzer_h__
#define __ACIntroAnalyzer_h__

#include "Puma/ACTree.h"

namespace Puma {
  class ACAspectInfo;
  class CClassDatabase;
  class CScopeInfo;
  class CObjectInfo;
}

namespace Puma {

class ACIntroAnalyzer {
  CClassDatabase *_db;
  CScopeInfo *_current_scope;
  int _state;
  CT_Intro *_intro;
  bool _is_slice;

  int ttype(int pos);
  bool is_in (int tok, int *set);
  bool block (int &outer_pos, int open, int close);
  bool skip (int &outer_pos, int *term);
  bool constructor_args (int &outer_pos);
  bool nested_name (int &outer_pos, bool &is_declarator,
    bool is_decl_name = false);
  bool ptr_operator (int &outer_pos);
  bool declarator (int &outer_pos);
  bool init_declarator (int &outer_pos);
  
public:
  enum {
    IA_OK = 0, IA_UNDEFINED, IA_INVALID, IA_INV_SCOPE, IA_INV_SLICE,
    IA_INV_DESTR, IA_SLICE_IN_SLICE, IA_ASPECT_IN_SLICE, IA_ADVICE_IN_SLICE,
    IA_PCT_IN_SLICE
  };

  // a default constructor can be used if the analysis should take place later
  ACIntroAnalyzer (CClassDatabase *db, CScopeInfo *s) :
    _db (db), _current_scope (s), _state (IA_UNDEFINED) {}

  void analyze_intro (CT_Intro *);
  void analyze_intro_member (CT_Intro *);
  int error () const { return (_state != IA_OK); }
  const char *error_msg () const;
};

} // namespace Puma

#endif /* __ACIntroAnalyzer_h__ */
