// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2004  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                           


#include "CCompiler.h"
#include "ACCompiler.h"
#include "AGxxConfig.h"
#include "PumaConfigFile.h"

// PUMA includes 
#include "Puma/ErrorStream.h"
using namespace Puma;



int main (int argc, char **argv)
{
	ErrorStream err;
	bool optionsOk;
	
	// Setup Configuration
	AGxxConfig config(err,argc, argv);
	
	optionsOk=config.analyze();
	
	if (config.verbose() > 0){
		config.printOptions();
	}
	if (! optionsOk){
		return EXIT_FAILURE;
	}
	
		
		
	
	
	// Create a Puma configuration file if it does not exists
	if(config.gen_pumaconfig()){
		PumaConfigFile pumacfg(err,config);
		if(! pumacfg.searchFile()){
			if(! pumacfg.generateFile()){
				return EXIT_FAILURE;
			}
		}else{
			config.gen_pumaconfig(false);
		}
			
	}
	
	// Create an AspectC++ compiler object
	if(config.weave()){
		ACCompiler acc(err,config);
		if (! acc.execute()){
			return EXIT_FAILURE;
		}
	}
	

	// Create a C compiler object
	if(config.compile()){
		CCompiler cc(err,config);
		if(! cc.execute()){
			return EXIT_FAILURE;
		}
	}

	return EXIT_SUCCESS;
}	
	
	
	
