/*
 * XDialog.java
 *
 * Created on 2. April 2003, 15:10
 */
package com.sun.star.wizards.tutorial.executer.officeHelper;

import java.util.Hashtable;

/**
 * Tabs handling interface for StarOffice.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public interface XTabList {
    /**
     * Set tab.
     *
     * @param Accessibility object path
     * @param Tab index
     * @param Time to change tab in milliseconds
     */
    public void setTab(String[] path, int index, int sleep);

    /**
     * This class returns the methods of this interface. This class is very important for
     * the TutorialCreator class.
     *
     * @author $author$
     * @version $Revision: 1.3 $
     */
    public class XTabListMethods {
        private static final Hashtable m_xhash;

        static {
            m_xhash = getXTabList();
        }

        /**
         * Get methods
         *
         * @return hashtable
         */
        public static Hashtable getMethods() {
            return m_xhash;
        }

        /**
         * Creates the hashtable with all methods of this interface.
         *
         * @return hashtable
         */
        private static Hashtable getXTabList() {
            String[][] setTab = new String[][] { { "typ", "" }, {
                    "method", "setTab" }, {
                    "path", "" }, {
                    "index", "" }, {
                    "sleep", "" }
            };

            Hashtable xTabList = new Hashtable();
            xTabList.put("setTab", setTab);

            return xTabList;
        }
    }
}
