/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuconrec.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:55:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------------

// TOOLS
#define _BIGINT_HXX
#define _SFXMULTISEL_HXX
#define _STACK_HXX
#define _QUEUE_HXX
#define _DYNARR_HXX
#define _TREELIST_HXX
#define _CACHESTR_HXX
#define _NEW_HXX
//#define _SHL_HXX
//#define _LINK_HXX
//#define _ERRCODE_HXX
//#define _GEN_HXX
//#define _FRACT_HXX
//#define _STRING_HXX
//#define _MTF_HXX
//#define _CONTNR_HXX
//#define _LIST_HXX
//#define _TABLE_HXX
#define _DYNARY_HXX
//#define _UNQIDX_HXX
#define _SVMEMPOOL_HXX
//#define _UNQID_HXX
//#define _DEBUG_HXX
//#define _DATE_HXX
//#define _TIME_HXX
//#define _DATETIME_HXX
//#define _INTN_HXX
//#define _WLDCRD_HXX
//#define _FSYS_HXX
//#define _STREAM_HXX
#define _CACHESTR_HXX
#define _SV_MULTISEL_HXX

//SV
//#define _CLIP_HXX ***
#define _CONFIG_HXX
#define _CURSOR_HXX
#define _FONTDLG_HXX
#define _PRVWIN_HXX
//#define _COLOR_HXX
//#define _PAL_HXX
//#define _BITMAP_HXX
//#define _GDIOBJ_HXX
//#define _POINTR_HXX
//#define _ICON_HXX
//#define _IMAGE_HXX
//#define _KEYCOD_HXX
//#define _EVENT_HXX
#define _HELP_HXX
//#define _APP_HXX
//#define _MDIAPP_HXX
//#define _TIMER_HXX
//#define _METRIC_HXX
//#define _REGION_HXX
//#define _OUTDEV_HXX
//#define _SYSTEM_HXX
//#define _VIRDEV_HXX
//#define _JOBSET_HXX
//#define _PRINT_HXX
//#define _WINDOW_HXX
//#define _SYSWIN_HXX
//#define _WRKWIN_HXX
#define _MDIWIN_HXX
//#define _FLOATWIN_HXX
//#define _DOCKWIN_HXX
//#define _CTRL_HXX
//#define _SCRBAR_HXX
//#define _BUTTON_HXX
//#define _IMAGEBTN_HXX
//#define _FIXED_HXX
//#define _GROUP_HXX
//#define _EDIT_HXX
//#define _COMBOBOX_HXX
//#define _LSTBOX_HXX
//#define _SELENG_HXX ***
//#define _SPLIT_HXX
#define _SPIN_HXX
//#define _FIELD_HXX
//#define _MOREBTN_HXX ***
//#define _TOOLBOX_HXX
//#define _STATUS_HXX ***
//#define _DIALOG_HXX
//#define _MSGBOX_HXX
//#define _SYSDLG_HXX
//#define _FILDLG_HXX
//#define _PRNDLG_HXX
#define _COLDLG_HXX
//#define _TABDLG_HXX
//#define _MENU_HXX
//#define _GDIMTF_HXX
//#define _POLY_HXX
//#define _ACCEL_HXX
//#define _GRAPH_HXX
#define _SOUND_HXX

//svtools
#define _SCRWIN_HXX
#define _RULER_HXX
#define _TABBAR_HXX
#define _VALUESET_HXX
#define _STDMENU_HXX
#define _STDCTRL_HXX
#define _CTRLBOX_HXX
#define _CTRLTOOL_HXX
#define _EXTATTR_HXX
#define _FRM3D_HXX
//SVTOOLS
#define _SVTREELIST_HXX
#define _FILTER_HXX
#define _SVLBOXITM_HXX
#define _SVTREEBOX_HXX
#define _SVICNVW_HXX
#define _SVTABBX_HXX


#define _BASE_DLGS_HXX
#define _BIGINT_HXX
#define _CACHESTR_HXX
#define _CONFIG_HXX
#define _CURSOR_HXX
#define _CTRLBOX_HXX
#define _CTRLTOOL_HXX
#define _DLGCFG_HXX
#define _DYNARR_HXX
#define _EXTATTR_HXX
//#define _FILDLG_HXX ***
#define _FILTER_HXX
#define _FONTDLG_HXX

//xout.hxx
//#define _XENUM_HXX
//#define _XPOLY_HXX
//#define _XATTR_HXH
#define _XOUTX_HXX
//#define _XPOOL_HXX
#define _XTABLE_HXX


//#define _SVDLAYER_HXX
//#define _SVDATTR_HXX
#define _SVDIO_HXX
#define _SVBOXITM_HXX
#define _SVDEC_HXX
#define _SVDXOUT_HXX
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOOBJECTS
//#define _SDR_NOVIEWS ***

#define _SVDRAG_HXX
#define _SVINCVW_HXX
#define _SV_MULTISEL_HXX
#define _SVRTV_HXX
#define _SVTABBX_HXX

#define _SVX_DAILDLL_HXX
#define _SVX_HYPHEN_HXX
#define _SVX_IMPGRF_HXX
#define _SVX_OPTITEMS_HXX
#define _SVX_OPTGERL_HXX
#define _SVX_OPTSAVE_HXX
#define _SVX_OPTSPELL_HXX
#define _SVX_OPTPATH_HXX
#define _SVX_OPTLINGU_HXX
#define _SVX_RULER_HXX
#define _SVX_RULRITEM_HXX
#define _SVX_SPLWRAP_HXX
#define _SVX_SPLDLG_HXX
#define _SVX_THESDLG_HXX

//------------------------------------------------------------------------

#include <svx/svdview.hxx>
#include <svx/svdobj.hxx>
#include <svx/outlobj.hxx>

#include "fuconrec.hxx"
#include "tabvwsh.hxx"
#include "sc.hrc"

// #98185# Create default drawing objects via keyboard
#ifndef _SVDOPATH_HXX
#include <svx/svdopath.hxx>
#endif

#ifndef _SVDCAPT_HXX
#include <svx/svdocapt.hxx>
#endif

#include "scresid.hxx"

//------------------------------------------------------------------------


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

FuConstRectangle::FuConstRectangle(ScTabViewShell* pViewSh, Window* pWin, SdrView* pView,
				   SdrModel* pDoc, SfxRequest& rReq)
	: FuConstruct(pViewSh, pWin, pView, pDoc, rReq)
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

FuConstRectangle::~FuConstRectangle()
{
}

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

BOOL __EXPORT FuConstRectangle::MouseButtonDown(const MouseEvent& rMEvt)
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	BOOL bReturn = FuConstruct::MouseButtonDown(rMEvt);

	if ( rMEvt.IsLeft() && !pView->IsAction() )
	{
		Point aPos( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );

		pWindow->CaptureMouse();

		if ( pView->GetCurrentObjIdentifier() == OBJ_CAPTION )
		{
			Size aCaptionSize ( 2268, 1134 ); // 4x2cm

			bReturn = pView->BegCreateCaptionObj( aPos, aCaptionSize );

			// wie stellt man den Font ein, mit dem geschrieben wird
		}
		else
			bReturn = pView->BegCreateObj(aPos);
	}
	return bReturn;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

BOOL __EXPORT FuConstRectangle::MouseMove(const MouseEvent& rMEvt)
{
	return FuConstruct::MouseMove(rMEvt);
}

/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

BOOL __EXPORT FuConstRectangle::MouseButtonUp(const MouseEvent& rMEvt)
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	BOOL bReturn = FALSE;

	if ( pView->IsCreateObj() && rMEvt.IsLeft() )
	{
		Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
		pView->EndCreateObj(SDRCREATE_FORCEEND);

		if (aSfxRequest.GetSlot() == SID_DRAW_CAPTION_VERTICAL)
		{
			//	set vertical flag for caption object

			const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
			if (rMarkList.GetMark(0))
			{
				SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
				//	create OutlinerParaObject now so it can be set to vertical
				if ( pObj->ISA(SdrTextObj) )
					((SdrTextObj*)pObj)->ForceOutlinerParaObject();
				OutlinerParaObject* pOPO = pObj->GetOutlinerParaObject();
				if( pOPO && !pOPO->IsVertical() )
					pOPO->SetVertical( TRUE );
			}
		}

		bReturn = TRUE;
	}
	return (FuConstruct::MouseButtonUp(rMEvt) || bReturn);
}

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

BOOL __EXPORT FuConstRectangle::KeyInput(const KeyEvent& rKEvt)
{
	BOOL bReturn = FuConstruct::KeyInput(rKEvt);
	return(bReturn);
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void FuConstRectangle::Activate()
{
	SdrObjKind aObjKind;

	switch (aSfxRequest.GetSlot() )
	{
		case SID_DRAW_LINE:
			aNewPointer = Pointer( POINTER_DRAW_LINE );
			aObjKind = OBJ_LINE;
			break;

		case SID_DRAW_RECT:
			aNewPointer = Pointer( POINTER_DRAW_RECT );
			aObjKind = OBJ_RECT;
			break;

		case SID_DRAW_ELLIPSE:
			aNewPointer = Pointer( POINTER_DRAW_ELLIPSE );
			aObjKind = OBJ_CIRC;
			break;

		case SID_DRAW_CAPTION:
		case SID_DRAW_CAPTION_VERTICAL:
			aNewPointer = Pointer( POINTER_DRAW_CAPTION );
			aObjKind = OBJ_CAPTION;
			break;

		default:
			aNewPointer = Pointer( POINTER_CROSS );
			aObjKind = OBJ_RECT;
			break;
	}

	pView->SetCurrentObj(aObjKind);

	aOldPointer = pWindow->GetPointer();
	pViewShell->SetActivePointer( aNewPointer );

	FuConstruct::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void FuConstRectangle::Deactivate()
{
	FuConstruct::Deactivate();
	pViewShell->SetActivePointer( aOldPointer );
}

// #98185# Create default drawing objects via keyboard
SdrObject* FuConstRectangle::CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle)
{
	// case SID_DRAW_LINE:
	// case SID_DRAW_RECT:
	// case SID_DRAW_ELLIPSE:
	// case SID_DRAW_CAPTION:
	// case SID_DRAW_CAPTION_VERTICAL:

	SdrObject* pObj = SdrObjFactory::MakeNewObject(
		pView->GetCurrentObjInventor(), pView->GetCurrentObjIdentifier(),
		0L, pDrDoc);

	if(pObj)
	{
		Rectangle aRect(rRectangle);
		Point aStart = aRect.TopLeft();
		Point aEnd = aRect.BottomRight();

		switch(nID)
		{
			case SID_DRAW_LINE:
			{
				if(pObj->ISA(SdrPathObj))
				{
					XPolyPolygon aPoly;
					aPoly.Insert(XPolygon(2));
					
					sal_Int32 nYMiddle((aRect.Top() + aRect.Bottom()) / 2);
					aPoly[0][0] = Point(aStart.X(), nYMiddle);
					aPoly[0][1] = Point(aEnd.X(), nYMiddle);
					
					((SdrPathObj*)pObj)->SetPathPoly(aPoly);
				}
				else
				{
					DBG_ERROR("Object is NO line object");
				}

				break;
			}
			case SID_DRAW_CAPTION:
			case SID_DRAW_CAPTION_VERTICAL:
			{
				if(pObj->ISA(SdrCaptionObj))
				{
					sal_Bool bIsVertical(SID_DRAW_CAPTION_VERTICAL == nID);

					((SdrTextObj*)pObj)->SetVerticalWriting(bIsVertical);
						
					if(bIsVertical)
					{
						SfxItemSet aSet(pObj->GetMergedItemSet());
						aSet.Put(SdrTextVertAdjustItem(SDRTEXTVERTADJUST_CENTER));
						aSet.Put(SdrTextHorzAdjustItem(SDRTEXTHORZADJUST_RIGHT));
						pObj->SetMergedItemSet(aSet);
					}

					//  #105815# don't set default text, start edit mode instead
					//  (Edit mode is started in ScTabViewShell::ExecDraw, because
					//  it must be handled by FuText)
					// String aText(ScResId(STR_CAPTION_DEFAULT_TEXT));
					// ((SdrCaptionObj*)pObj)->SetText(aText);

					((SdrCaptionObj*)pObj)->SetLogicRect(aRect);
					((SdrCaptionObj*)pObj)->SetTailPos(
						aRect.TopLeft() - Point(aRect.GetWidth() / 2, aRect.GetHeight() / 2));
				}
				else
				{
					DBG_ERROR("Object is NO caption object");
				}

				break;
			}

			default:
			{
				pObj->SetLogicRect(aRect);

				break;
			}
		}

		SfxItemSet aAttr(pDrDoc->GetItemPool());
		pObj->SetMergedItemSet(aAttr);
	}

	return pObj;
}

