/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_taborder.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:49:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
#include <com/sun/star/awt/XFocusListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

// auto strip #ifndef _SVX_FMCTRLER_HXX
// auto strip #include "fmctrler.hxx"
// auto strip #endif

#ifndef _SVX_TABORDER_HXX
#include "taborder.hxx"
#endif

// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

// auto strip #ifndef _WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif

// auto strip #ifndef _SV_IMAGE_HXX //autogen
// auto strip #include <vcl/image.hxx>
// auto strip #endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif
#include "taborder.hrc"

// auto strip #ifndef _SVDPAGV_HXX
// auto strip #include "svdpagv.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMUNOPGE_HXX
// auto strip #include "fmpgeimp.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMPAGE_HXX
// auto strip #include "fmpage.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMSHELL_HXX
// auto strip #include "fmshell.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif

// auto strip #ifndef _SVX_FMPROP_HXX
// auto strip #include "fmprop.hxx"
// auto strip #endif

#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif

#ifndef _SVX_DIALMGR_HXX //autogen
#include "dialmgr.hxx"
#endif

// auto strip #ifndef _SVX_FMGLOB_HXX
// auto strip #include "fmglob.hxx"
// auto strip #endif

#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif
// auto strip #ifndef _SV_SCRBAR_HXX
// auto strip #include <vcl/scrbar.hxx>
// auto strip #endif // _SV_SCRBAR_HXX

// auto strip #ifndef _COMPHELPER_TYPES_HXX_
// auto strip #include <comphelper/types.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif
// auto strip #ifndef _CPPUHELPER_IMPLBASE1_HXX_
// auto strip #include <cppuhelper/implbase1.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::datatransfer;

//========================================================================
// Tabcontroller zum setzen der Autoorder
//STRIP001 class FmXTabModel :	public ::cppu::WeakImplHelper1< ::com::sun::star::awt::XTabControllerModel>
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > > m_aModels;
//STRIP001 
//STRIP001 public:
//STRIP001 	FmXTabModel(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > >& rModels)
//STRIP001 		:m_aModels(rModels){}
//STRIP001 
//STRIP001 	// ::com::sun::star::awt::XTabControllerModel
//STRIP001 	virtual void SAL_CALL setControlModels(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& rModels) throw( ::com::sun::star::uno::RuntimeException ) {m_aModels = rModels;}
//STRIP001 	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > SAL_CALL getControlModels(void) throw( ::com::sun::star::uno::RuntimeException ) {return m_aModels;}
//STRIP001 	virtual void SAL_CALL setGroup(const ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& Group, const ::rtl::OUString& GroupName) throw( ::com::sun::star::uno::RuntimeException ) {}
//STRIP001 	virtual sal_Int32 SAL_CALL getGroupCount(void) throw( ::com::sun::star::uno::RuntimeException ) {return 0;}
//STRIP001 	virtual void SAL_CALL getGroup(sal_Int32 nGroup, ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& Group, ::rtl::OUString& Name) throw( ::com::sun::star::uno::RuntimeException ) {}
//STRIP001 	virtual void SAL_CALL getGroupByName(const ::rtl::OUString& Name, ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  >& Group) throw( ::com::sun::star::uno::RuntimeException ) {}
//STRIP001 	virtual sal_Bool SAL_CALL getGroupControl(void) throw( ::com::sun::star::uno::RuntimeException ){return sal_False;} ;
//STRIP001 	virtual void SAL_CALL setGroupControl(sal_Bool GroupControl) throw( ::com::sun::star::uno::RuntimeException ){};
//STRIP001 };
//STRIP001 
//STRIP001 // class FmOrderTreeListBox
//STRIP001 //========================================================================
//STRIP001 DBG_NAME(FmOrderTreeListBox)
//STRIP001 //------------------------------------------------------------------------
/*N*/ FmOrderTreeListBox::FmOrderTreeListBox( Window* pParent )
/*N*/ 	:SvTreeListBox( pParent, WB_BORDER )
/*N*/ 	,m_aFieldExchange( this )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CTOR(FmOrderTreeListBox,NULL);
//STRIP001 	// damit das AcceptDrop der Basisklasse das Scrollen am Fensterrand erledigt :
//STRIP001 	SetDragDropMode(0xFFFF/*SV_DRAGDROP_CTRL_MOVE*/);
//STRIP001 		// das Flag allein reicht nicht aus, um in AcceptDrop ein Scrollen zu erreichen ...
//STRIP001 		// also auf Nummer sicher gehen ...
//STRIP001 
//STRIP001 	SetSelectionMode( MULTIPLE_SELECTION );
/*N*/ }
//------------------------------------------------------------------------
/*N*/ FmOrderTreeListBox::FmOrderTreeListBox( Window* pParent, const ResId& rResId  )
/*N*/ 	:SvTreeListBox( pParent, rResId  )
/*N*/ 	,m_aFieldExchange( this )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CTOR(FmOrderTreeListBox,NULL);
//STRIP001 	SetDragDropMode(0xFFFF/*SV_DRAGDROP_CTRL_MOVE*/);
//STRIP001 		// das Flag allein reicht nicht aus, um in AcceptDrop ein Scrollen zu erreichen ...
//STRIP001 		// also auf Nummer sicher gehen ...
//STRIP001 
//STRIP001 	SetSelectionMode( MULTIPLE_SELECTION );
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmOrderTreeListBox::~FmOrderTreeListBox()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_DTOR(FmOrderTreeListBox,NULL);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Int8 FmOrderTreeListBox::ExecuteDrop( const ExecuteDropEvent& rEvt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	// no drop if we're not the source ourself
//STRIP001 	if (!m_aFieldExchange.isDragSource())
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	SvLBoxEntry* pDragEntry = m_aFieldExchange->focused();
//STRIP001 
//STRIP001 	SvLBoxEntry* pDropEntry = GetEntry( rEvt.maPosPixel );
//STRIP001 	if( !pDropEntry )
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	// move selection
//STRIP001 	sal_uInt32 nDropPos = GetModel()->GetAbsPos( pDropEntry );
//STRIP001 	sal_uInt32 nDragPos = GetModel()->GetAbsPos( pDragEntry );
//STRIP001 
//STRIP001 	sal_uInt32 nDragDelta = nDropPos-nDragPos;
//STRIP001 	MoveSelection( nDragDelta );
//STRIP001 
//STRIP001 	return DND_ACTION_MOVE;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Int8 FmOrderTreeListBox::AcceptDrop( const AcceptDropEvent& rEvt )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	// no drop if we're not the source ourself
//STRIP001 	if (!m_aFieldExchange.isDragSource())
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	// no drop if we don't know the format
//STRIP001 	if (!OControlExchange::hasFieldExchangeFormat(GetDataFlavorExVector()))
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmOrderTreeListBox::AcceptDrop: invalid format!");
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// drop position
//STRIP001 	SvLBoxEntry* pDropEntry = GetEntry( rEvt.maPosPixel );
//STRIP001 	if( !pDropEntry )
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	ShowFocusRect( pDropEntry );
//STRIP001 
//STRIP001 	// the entries which were selected when the drag started
//STRIP001 	const ::std::vector< SvLBoxEntry* >& aSelected = m_aFieldExchange->selected();
//STRIP001 	DBG_ASSERT(aSelected.size(), "FmOrderTreeListBox::AcceptDrop: invalid drag data!");
//STRIP001 	if (!aSelected.size())
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	// Wenn Selektion durch Drag aus der Liste geschoben wird, return sal_False
//STRIP001 	long nFirstSelPos = GetModel()->GetAbsPos( aSelected[0] );
//STRIP001 	long nLastSelPos  = GetModel()->GetAbsPos( aSelected[aSelected.size() - 1] );
//STRIP001 	long nDropPos	  = GetModel()->GetAbsPos( pDropEntry );
//STRIP001 	long nDragPos     = GetModel()->GetAbsPos( m_aFieldExchange->focused() );
//STRIP001 
//STRIP001 	long nDragDelta = nDropPos-nDragPos;
//STRIP001 
//STRIP001 	if( (nFirstSelPos+nDragDelta) < 0 )
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( (nLastSelPos+nDragDelta) > (GetEntryCount()-1) )
//STRIP001 		return DND_ACTION_NONE;
//STRIP001 
//STRIP001 	long nVisibleSize = GetVScroll()->GetVisibleSize();
//STRIP001 	long nFirstEntryInView = GetModel()->GetAbsPos( GetFirstEntryInView() );
//STRIP001 
//STRIP001 	if((nVisibleSize+nFirstEntryInView) <= nDropPos)
//STRIP001 		GetVScroll()->DoScrollAction(SCROLL_LINEDOWN);
//STRIP001 	else if(nFirstEntryInView >= nDropPos)
//STRIP001 		GetVScroll()->DoScrollAction(SCROLL_LINEUP);
//STRIP001 
//STRIP001 	return DND_ACTION_MOVE;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmOrderTreeListBox::StartDrag( sal_Int8 _nAction, const Point& _rPosPixel )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SvLBoxEntry* pSelected = GetEntry( _rPosPixel );
//STRIP001 	if (!pSelected)
//STRIP001 		return;
//STRIP001 
//STRIP001 	m_aFieldExchange.prepareDrag();
//STRIP001 	m_aFieldExchange->setFocusEntry( pSelected );
//STRIP001 
//STRIP001 	pSelected = FirstSelected();
//STRIP001 	while (pSelected)
//STRIP001 	{
//STRIP001 		m_aFieldExchange->addSelectedEntry( pSelected );
//STRIP001 		pSelected = NextSelected( pSelected );
//STRIP001 	}
//STRIP001 
//STRIP001 	m_aFieldExchange.startDrag( DND_ACTION_MOVE );
/*N*/ }

//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmOrderTreeListBox::MoveSelection( long nRelPos )
//STRIP001 {
//STRIP001 	long loop = labs(nRelPos);
//STRIP001 	UniString aSelEntryPrevText,aSelEntryNextText;
//STRIP001 	Image  aImage;
//STRIP001 	for (long i=0; i<labs(nRelPos); i++)
//STRIP001 	{
//STRIP001 		// ObButton beim Parent einschalten
//STRIP001 		((FmTabOrderDlg*)Window::GetParent())->SetModified();
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Eintraege verschieben
//STRIP001 		if( nRelPos < 0 )
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pFirstSelected = FirstSelected();
//STRIP001 			if( !pFirstSelected ) return;
//STRIP001 			sal_uInt32 nFirstSelPos = GetModel()->GetAbsPos( pFirstSelected );
//STRIP001 			if( nFirstSelPos == 0 ) return;
//STRIP001 
//STRIP001 			SvLBoxEntry* pSelEntry = pFirstSelected;
//STRIP001 			while( pSelEntry )
//STRIP001 			{
//STRIP001 				sal_uInt32 nSelEntryPos = GetModel()->GetAbsPos( pSelEntry );
//STRIP001 				SvLBoxEntry* pSelEntryPrev = GetEntry( nSelEntryPos-1 );
//STRIP001 				aSelEntryPrevText = GetEntryText( pSelEntryPrev );
//STRIP001 				aImage = GetExpandedEntryBmp(pSelEntryPrev);
//STRIP001 				void*  pData = pSelEntryPrev->GetUserData();
//STRIP001 
//STRIP001 				GetModel()->Remove( pSelEntryPrev );
//STRIP001 				InsertEntry( aSelEntryPrevText, aImage, aImage, 0, sal_False, nSelEntryPos, pData );
//STRIP001 
//STRIP001 				pSelEntry = NextSelected( pSelEntry );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		else if( nRelPos > 0 )
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pLastSelected = LastSelected();
//STRIP001 			if( !pLastSelected ) return;
//STRIP001 			sal_uInt32 nLastSelPos = GetModel()->GetAbsPos( pLastSelected );
//STRIP001 
//STRIP001 			if( (nLastSelPos + nRelPos - i) > (GetEntryCount()-1) ) return;
//STRIP001 			sal_uInt32 nSelCount = GetSelectionCount();
//STRIP001 
//STRIP001 
//STRIP001 			SvLBoxEntry* pSelEntry = pLastSelected;
//STRIP001 			while( pSelEntry )
//STRIP001 			{
//STRIP001 				sal_uInt32 nSelEntryPos = GetModel()->GetAbsPos( pSelEntry );
//STRIP001 				SvLBoxEntry* pSelEntryNext = GetEntry( nSelEntryPos+1 );
//STRIP001 				void* pData = pSelEntryNext->GetUserData();
//STRIP001 
//STRIP001 				aSelEntryNextText = GetEntryText( pSelEntryNext );
//STRIP001 				aImage = GetExpandedEntryBmp(pSelEntryNext);
//STRIP001 
//STRIP001 				GetModel()->Remove( pSelEntryNext );
//STRIP001 				InsertEntry( aSelEntryNextText, aImage, aImage, 0, sal_False, nSelEntryPos, pData );
//STRIP001 
//STRIP001 				pSelEntry = PrevSelected( pSelEntry );
//STRIP001 			}
//STRIP001 			long nThumbPos		= GetVScroll()->GetThumbPos();
//STRIP001 			long nVisibleSize	= GetVScroll()->GetVisibleSize();
//STRIP001 			long nFirstVisible = GetModel()->GetAbsPos( FirstVisible());
//STRIP001 
//STRIP001 			if((nThumbPos+nVisibleSize+1) < (nLastSelPos+3))
//STRIP001 				GetVScroll()->DoScrollAction(SCROLL_LINEDOWN);
//STRIP001 			else if((nThumbPos+nVisibleSize+1) >= (nFirstVisible))
//STRIP001 				GetVScroll()->DoScrollAction(SCROLL_LINEUP);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // class FmTabOrderDlg
//STRIP001 //========================================================================
//STRIP001 DBG_NAME(FmTabOrderDlg)
//STRIP001 //------------------------------------------------------------------------
/*N*/ FmTabOrderDlg::FmTabOrderDlg(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >&	_xORB,
/*N*/ 							 Window * pParent, FmFormShell* pShell )
/*N*/ 			  :ModalDialog( pParent, SVX_RES(RID_SVXDLG_TAB_ORDER) )
/*N*/ 			  ,aPB_OK( this, ResId(PB_OK) )
/*N*/ 			  ,aPB_CANCEL( this, ResId(PB_CANCEL) )
/*N*/ 			  ,aPB_HELP( this, ResId(PB_HELP) )
/*N*/               ,aFT_Controls( this, SVX_RES(FT_CONTROLS) )
/*N*/ 			  ,aPB_MoveUp( this, SVX_RES(PB_MOVE_UP) )
/*N*/ 			  ,aPB_MoveDown( this, SVX_RES(PB_MOVE_DOWN) )
/*N*/ 			  ,aPB_AutoOrder( this, SVX_RES(PB_AUTO_ORDER) )
/*N*/ 			  ,aLB_Controls(this,SVX_RES(CTRL_TREE) )
/*N*/ 			  ,pDrawModel(NULL)
/*N*/ 			  ,pImageList(NULL)
/*N*/ 			  ,m_xORB(_xORB)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CTOR(FmTabOrderDlg,NULL);
//STRIP001 	aPB_MoveUp.SetClickHdl( LINK( this, FmTabOrderDlg, MoveUpClickHdl ) );
//STRIP001 	aPB_MoveDown.SetClickHdl( LINK( this, FmTabOrderDlg, MoveDownClickHdl ) );
//STRIP001 	aPB_AutoOrder.SetClickHdl( LINK( this, FmTabOrderDlg, AutoOrderClickHdl ) );
//STRIP001 	aPB_OK.SetClickHdl( LINK( this, FmTabOrderDlg, OKClickHdl ) );
//STRIP001 	aPB_OK.Disable();
//STRIP001 
//STRIP001 //	pLB_Controls = new FmOrderTreeListBox( this );
//STRIP001 //	pLB_Controls->SetPosSizePixel( LogicToPixel(Point(12, 18),MAP_APPFONT),
//STRIP001 //								  LogicToPixel(::com::sun::star::awt::Size(88, 132),MAP_APPFONT) );
//STRIP001 //	pLB_Controls->Show();
//STRIP001 //	pLB_Controls->SetHelpId(HID_TABORDER_CONTROLS);
//STRIP001 
//STRIP001 	sal_Bool bIsHighContrast = GetDisplayBackground().GetColor().IsDark();
//STRIP001 	pImageList = new ImageList( SVX_RES( bIsHighContrast ? RID_SVXIMGLIST_FMEXPL_HC : RID_SVXIMGLIST_FMEXPL ) );
//STRIP001 
//STRIP001 	if (pShell && pShell->GetCurPage() && pShell->GetFormView())
//STRIP001 	{
//STRIP001 		pDrawModel = pShell->GetCurPage()->GetModel();
//STRIP001 
//STRIP001 		xModel = ::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabControllerModel > (pShell->GetCurPage()->GetImpl()->getCurForm(), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 		if (xModel.is())
//STRIP001 			xTempModel = new FmXTabModel(xModel->getControlModels());
//STRIP001 
//STRIP001 		SdrPageView* pPageView = pShell->GetFormView()->GetPageViewPvNum(0);
//STRIP001 		xControlContainer	   = pPageView->GetWinList()[0].GetControlContainerRef();
//STRIP001 
//STRIP001 		if (xTempModel.is() && xControlContainer.is())
//STRIP001 			FillList();
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aLB_Controls.GetEntryCount() < 2)
//STRIP001 	{
//STRIP001 		aPB_MoveUp.Disable();
//STRIP001 		aPB_MoveDown.Disable();
//STRIP001 		aPB_AutoOrder.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	FreeResource();
/*N*/ }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmTabOrderDlg::SetModified()
//STRIP001 {
//STRIP001 	aPB_OK.Enable();
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
/*N*/ FmTabOrderDlg::~FmTabOrderDlg()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	aLB_Controls.Hide();
//STRIP001 	//	delete pLB_Controls;
//STRIP001 	delete pImageList;
//STRIP001 	DBG_DTOR(FmTabOrderDlg,NULL);
/*N*/ }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 Image FmTabOrderDlg::GetImage(const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > & xSet) const
//STRIP001 {
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// Default-Image
//STRIP001 	Image aImage = pImageList->GetImage( RID_SVXIMG_CONTROL );
//STRIP001 	if (xSet.is())
//STRIP001 	{
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_CLASSID, xSet))
//STRIP001 		{
//STRIP001 			switch( ::comphelper::getINT16(xSet->getPropertyValue(FM_PROP_CLASSID)))
//STRIP001 			{
//STRIP001 				case ::com::sun::star::form::FormComponentType::COMMANDBUTTON:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_BUTTON );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::FIXEDTEXT:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_FIXEDTEXT );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::TEXTFIELD:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_EDIT );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::RADIOBUTTON:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_RADIOBUTTON );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::CHECKBOX:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_CHECKBOX );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::LISTBOX:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_LISTBOX );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::COMBOBOX:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_COMBOBOX );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::GROUPBOX:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_GROUPBOX );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::IMAGEBUTTON:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_IMAGEBUTTON );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::FILECONTROL:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_FILECONTROL );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::HIDDENCONTROL:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_HIDDEN );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::DATEFIELD:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_DATEFIELD );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::TIMEFIELD:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_TIMEFIELD );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::NUMERICFIELD:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_NUMERICFIELD );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::CURRENCYFIELD:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_CURRENCYFIELD );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::PATTERNFIELD:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_PATTERNFIELD );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::IMAGECONTROL:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_IMAGECONTROL );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case ::com::sun::star::form::FormComponentType::GRIDCONTROL:
//STRIP001 					aImage = pImageList->GetImage( RID_SVXIMG_GRID );
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aImage;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 void FmTabOrderDlg::FillList()
//STRIP001 {
//STRIP001 	aLB_Controls.Clear();
//STRIP001 
//STRIP001 	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > aControlModelSeq(xTempModel->getControlModels());
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > * pControlModels = aControlModelSeq.getConstArray();
//STRIP001 
//STRIP001 	::rtl::OUString aName;
//STRIP001 	Image aImage;
//STRIP001 	for (sal_Int32 i=0; i < aControlModelSeq.getLength(); i++)
//STRIP001 	{
//STRIP001 		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >  xSet(pControlModels[i], ::com::sun::star::uno::UNO_QUERY);
//STRIP001 		if (xSet.is())
//STRIP001 		{
//STRIP001 			aName = ::comphelper::getString(xSet->getPropertyValue(FM_PROP_NAME));
//STRIP001 			aImage = GetImage(xSet);
//STRIP001 			aLB_Controls.InsertEntry( aName, aImage, aImage, 0, sal_False, LIST_APPEND, (::com::sun::star::beans::XPropertySet*)xSet.get() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// ohne PropertySet keine Taborder
//STRIP001 			aLB_Controls.Clear();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Ersten Eintrag auswaehlen
//STRIP001 	SvLBoxEntry* pFirstEntry = aLB_Controls.GetEntry(0);
//STRIP001 	if( pFirstEntry )
//STRIP001 		aLB_Controls.Select( pFirstEntry );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmTabOrderDlg, MoveUpClickHdl, Button*, pButton )
//STRIP001 {
//STRIP001 	aLB_Controls.MoveSelection( -1 );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmTabOrderDlg, MoveDownClickHdl, Button*, pButton )
//STRIP001 {
//STRIP001 	aLB_Controls.MoveSelection( 1 );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmTabOrderDlg, AutoOrderClickHdl, Button*, pButton )
//STRIP001 {
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// Am TabController werden alle Controls einer Seite gesetzt. Mit
//STRIP001 	// dem TabControllerModel werden nur die Controls der aktuellen
//STRIP001 	// ::com::sun::star::form ausgeblendet. Die WinRecs beschreiben jeweils ein Fenster,
//STRIP001 	// mit dem die PageView angezeigt wird. (Eine ::com::sun::star::sdbcx::View kann z.B. durch
//STRIP001 	// WinSplitting in mehreren Fenstern dargestellt werden.)
//STRIP001 	// An einem dieser Fenster kann man sich den ControlContainer abholen.
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XTabController >  xTabController = new FmXFormController(m_xORB);
//STRIP001 	xTabController->setModel( xTempModel );
//STRIP001 	xTabController->setContainer( xControlContainer );
//STRIP001 	xTabController->autoTabOrder();
//STRIP001 
//STRIP001 	SetModified();
//STRIP001 
//STRIP001 	FillList();
//STRIP001 
//STRIP001 	::comphelper::disposeComponent(xTabController);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 IMPL_LINK( FmTabOrderDlg, OKClickHdl, Button*, pButton )
//STRIP001 {
//STRIP001 	//////////////////////////////////////////////////////////////////////
//STRIP001 	// ListBoxEintraege in ::com::sun::star::uno::Sequence schreiben und am TabController setzen
//STRIP001 	sal_uInt16 nEntryCount = aLB_Controls.GetEntryCount();
//STRIP001 	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > aSortedControlModelSeq( nEntryCount );
//STRIP001 	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel >  > aControlModelSeq( xTempModel->getControlModels());
//STRIP001 	::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > * pSortedControlModels = aSortedControlModelSeq.getArray();
//STRIP001 	const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XControlModel > * pControlModels = aControlModelSeq.getConstArray();
//STRIP001 
//STRIP001 	for (sal_uInt16 i=0; i < nEntryCount; i++)
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = aLB_Controls.GetEntry(i);
//STRIP001 
//STRIP001 		// Aus der ControlModelSeq richtigen Namen holen
//STRIP001 		for( sal_Int32 j=0; j<aControlModelSeq.getLength(); j++ )
//STRIP001 		{
//STRIP001 			::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >  xSet(pControlModels[j], ::com::sun::star::uno::UNO_QUERY);
//STRIP001 			if ((::com::sun::star::beans::XPropertySet*)xSet.get() == ((::com::sun::star::beans::XPropertySet*)pEntry->GetUserData()))
//STRIP001 			{
//STRIP001 				pSortedControlModels[i] = pControlModels[j];
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// UndoKlammerung
//STRIP001 	pDrawModel->BegUndo(SVX_RES(RID_STR_UNDO_TABORDER));
//STRIP001 	xModel->setControlModels( aSortedControlModelSeq );
//STRIP001 	pDrawModel->EndUndo();
//STRIP001 
//STRIP001 	EndDialog( sal_True );
//STRIP001 	return 0;
//STRIP001 }

}
