/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_databrws.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:16:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif


#include "memchrt.hxx"
#include "chtmodel.hxx"
#include "schresid.hxx"
#include "schdll.hxx"
#include "float.h"
#include "databrws.hxx"
#include "glob.hrc"
#include "strings.hrc"
namespace binfilter {


/*  BROWSER_COLUMNSELECTION :  single cells may be selected rather than only
                               entire rows
    BROWSER_(H|V)LINES :       show horizontal or vertical grid-lines

    BROWSER_AUTO_(H|V)SCROLL : scroll automated horizontally or vertically when
                               cursor is moved beyond the edge of the dialog
    BROWSER_HIGHLIGHT_NONE :   Do not mark the current row with selection color
                               (usually blue)

 */
#define BROWSER_STANDARD_FLAGS  \
    BROWSER_COLUMNSELECTION | \
    BROWSER_HLINES | BROWSER_VLINES | \
    BROWSER_AUTO_HSCROLL | BROWSER_AUTO_VSCROLL | \
    BROWSER_HIGHLIGHT_NONE

// BROWSER_HIDECURSOR would prevent flickering in edit fields, but navigating
// with shift up/down, and entering non-editable cells would be problematic,
// e.g.  the first cell, or when being in read-only mode

using namespace ::svt;

//STRIP001 ChartDataBrowseBox::ChartDataBrowseBox(Window* pParent, const ResId& rId) :
//STRIP001 	::svt::EditBrowseBox( pParent, rId, EBBF_SMART_TAB_TRAVEL | EBBF_HANDLE_COLUMN_TEXT, BROWSER_STANDARD_FLAGS ),
//STRIP001 	m_pModel( NULL ),
//STRIP001 	m_pLogBook( NULL ),
//STRIP001 	m_nSeekRow( 0 ),
//STRIP001     m_bIsReadOnly( false ),
//STRIP001     m_bIsDirty( false ),
//STRIP001     m_aEditField( & EditBrowseBox::GetDataWindow(), WB_NOBORDER ),
//STRIP001     m_rEditController( new ::svt::EditCellController( & m_aEditField ))
//STRIP001 {
//STRIP001     RenewTable();
//STRIP001     SetClean();
//STRIP001 }
//STRIP001 
//STRIP001 ChartDataBrowseBox::~ChartDataBrowseBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MayInsertRow() const
//STRIP001 {
//STRIP001     return ! IsReadOnly();
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MayInsertColumn() const
//STRIP001 {
//STRIP001     return ! IsReadOnly();
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MayDeleteRow() const
//STRIP001 {
//STRIP001     return ! IsReadOnly()
//STRIP001         && ( GetCurRow() > 0 )
//STRIP001         && ( GetRowCount() > 2 );
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MayDeleteColumn() const
//STRIP001 {
//STRIP001     return ! IsReadOnly()
//STRIP001         && ( GetCurColumnId() > 1 )
//STRIP001         && ( ColCount() > 3 );
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MaySwapRows() const
//STRIP001 {
//STRIP001     return ! IsReadOnly()
//STRIP001         && ( GetCurRow() > 0 )
//STRIP001         && ( GetCurRow() < GetRowCount() - 1 );
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MaySwapColumns() const
//STRIP001 {
//STRIP001     return ! IsReadOnly()
//STRIP001         && ( GetCurColumnId() > 1 )
//STRIP001         && ( GetCurColumnId() < ColCount() - 1 );
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MaySortRow() const
//STRIP001 {
//STRIP001     return ! IsReadOnly() && ( GetCurRow() > 0 );
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::MaySortColumn() const
//STRIP001 {
//STRIP001     return ! IsReadOnly() && ( GetCurColumnId() > 1 );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void ChartDataBrowseBox::RenewTable()
//STRIP001 {
//STRIP001     long nOldRow     = GetCurRow();
//STRIP001     USHORT nOldColId = GetCurColumnId();
//STRIP001 
//STRIP001 	BOOL bLastUpdateMode = GetUpdateMode();
//STRIP001 	SetUpdateMode( FALSE );
//STRIP001 
//STRIP001     if( IsModified() )
//STRIP001         SaveModified();
//STRIP001 
//STRIP001     DeactivateCell();
//STRIP001 
//STRIP001     RemoveColumns();
//STRIP001     RowRemoved( 1, GetRowCount() );
//STRIP001 
//STRIP001     // for row numbers
//STRIP001 	InsertHandleColumn( static_cast< sal_uInt16 >(
//STRIP001                             GetDataWindow().LogicToPixel( Size( 42, 0 )).getWidth() ));
//STRIP001 
//STRIP001     if( m_apMemChart.get() )
//STRIP001     {
//STRIP001         const long nColWidth = GetDataWindow().LogicToPixel( Size( 72, 0 )).getWidth();
//STRIP001         const short nColCnt  = m_apMemChart->GetColCount() + 1;
//STRIP001 
//STRIP001 		for( short i = 1; i <= nColCnt; ++i )
//STRIP001 			InsertDataColumn( i, GetColString( i ), nColWidth );
//STRIP001 
//STRIP001 		short nRowCnt = m_apMemChart->GetRowCount() + 1;
//STRIP001 
//STRIP001  		RowInserted( 1, nRowCnt );
//STRIP001 
//STRIP001 		GoToRow( ::std::min< long >( nOldRow, GetRowCount() - 1 ));
//STRIP001         GoToColumnId( ::std::min< USHORT >( nOldColId, ColCount() - 1 ));
//STRIP001     }
//STRIP001 
//STRIP001     SetDirty();
//STRIP001 
//STRIP001 	SetUpdateMode( bLastUpdateMode );
//STRIP001     ActivateCell();
//STRIP001     Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 String ChartDataBrowseBox::GetColString(USHORT nColumnId) const
//STRIP001 {
//STRIP001 	if (nColumnId >= 1)
//STRIP001 	{
//STRIP001 		String aColString( (sal_Unicode)('A' + (nColumnId - 1) % 26));
//STRIP001 
//STRIP001 		ULONG nFact = 27;
//STRIP001 
//STRIP001 		for (;;)
//STRIP001 		{
//STRIP001 			ULONG nDiv = nColumnId / nFact;
//STRIP001 			if (nDiv == 0)
//STRIP001 				break;
//STRIP001 
//STRIP001 			aColString.Insert( (sal_Unicode)('A' + ((nDiv - 1) % 26)), 0 );
//STRIP001 
//STRIP001 			nFact *= 26;
//STRIP001 		}
//STRIP001 
//STRIP001 		return aColString;
//STRIP001 	}
//STRIP001 
//STRIP001 	return String();
//STRIP001 }
//STRIP001 
//STRIP001 String ChartDataBrowseBox::GetRowString(long _Row) const
//STRIP001 {
//STRIP001 	return String::CreateFromInt32( _Row + 1 );
//STRIP001 }
//STRIP001 
//STRIP001 String ChartDataBrowseBox::GetCellText( long _nRow, USHORT _nColumnId ) const
//STRIP001 {
//STRIP001 	String aResult;
//STRIP001 
//STRIP001 	if( _nColumnId == 0 )
//STRIP001 	{
//STRIP001 		aResult = GetRowString( _nRow );
//STRIP001 	}
//STRIP001 	else if( _nRow == 0 )
//STRIP001 	{
//STRIP001 		if( _nColumnId > 1 && m_apMemChart.get() )
//STRIP001 			aResult = m_apMemChart->GetColText(
//STRIP001                 static_cast< short >( _nColumnId - 2 ));
//STRIP001 	}
//STRIP001 	else if( _nRow > 0 )			// can be -1
//STRIP001 	{
//STRIP001         if( m_apMemChart.get())
//STRIP001         {
//STRIP001             if( _nColumnId == 1 )
//STRIP001             {
//STRIP001                 aResult = m_apMemChart->GetRowText(
//STRIP001                     static_cast< short >( _nRow - 1 ));
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 DBG_ASSERT( m_pModel, "No Model" );
//STRIP001                 double fData = m_apMemChart->GetData(
//STRIP001                     static_cast< short >( _nColumnId - 2 ),
//STRIP001                     static_cast< short >( _nRow - 1 ));
//STRIP001 
//STRIP001                 if( fData != DBL_MIN )
//STRIP001                 {
//STRIP001                     SvNumberFormatter* pFormatter = m_pModel->GetNumFormatter();
//STRIP001                     Color* pDummy = NULL;
//STRIP001                     pFormatter->GetOutputString( fData,
//STRIP001                                                  pFormatter->GetStandardFormat(
//STRIP001                                                      m_apMemChart->GetDataType(), LANGUAGE_SYSTEM ),
//STRIP001                                                  aResult, &pDummy );
//STRIP001                 }
//STRIP001                 // else string remains empty
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	return aResult;
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::SetReadOnly( bool bNewState )
//STRIP001 {
//STRIP001     bool bResult = m_bIsReadOnly;
//STRIP001 
//STRIP001     if( m_bIsReadOnly != bNewState )
//STRIP001     {
//STRIP001         m_bIsReadOnly = bNewState;
//STRIP001         Invalidate();
//STRIP001         DeactivateCell();
//STRIP001     }
//STRIP001 
//STRIP001     return bResult;
//STRIP001 }
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::IsReadOnly() const
//STRIP001 {
//STRIP001     return m_bIsReadOnly;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 bool ChartDataBrowseBox::IsDirty() const
//STRIP001 {
//STRIP001     return m_bIsDirty;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SetClean()
//STRIP001 {
//STRIP001     m_bIsDirty = false;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SetDirty()
//STRIP001 {
//STRIP001     m_bIsDirty = true;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::CursorMoved()
//STRIP001 {
//STRIP001 	EditBrowseBox::CursorMoved();
//STRIP001 
//STRIP001 	if( GetUpdateMode() )
//STRIP001 		m_aCursorMovedHdlLink.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SetCellModifiedHdl( const Link& rLink )
//STRIP001 {
//STRIP001     m_aCellModifiedLink = rLink;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::CellModified()
//STRIP001 {
//STRIP001     SetDirty();
//STRIP001     m_aCursorMovedHdlLink.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SetDataFromModel( const ChartModel* pDoc )
//STRIP001 {
//STRIP001 	if( pDoc != m_pModel )
//STRIP001 	{
//STRIP001 		m_pModel = pDoc;
//STRIP001         m_apMemChart.reset();
//STRIP001 
//STRIP001         if( m_pModel )
//STRIP001 		{
//STRIP001 			SchMemChart* pData = m_pModel->GetChartData();
//STRIP001             ChartModel * pMutableModel = const_cast< ChartModel * >( m_pModel );
//STRIP001 
//STRIP001 			if( ! pData )
//STRIP001 			{
//STRIP001                 pMutableModel->InitChartData();
//STRIP001 				pData = m_pModel->GetChartData();
//STRIP001 			}
//STRIP001             DBG_ASSERT( pData, "No MemChart" );
//STRIP001 
//STRIP001 			if( pData->GetColCount() && pData->GetRowCount() )
//STRIP001 			{
//STRIP001 				m_apMemChart.reset( new SchMemChart( *pData ));
//STRIP001 
//STRIP001                 RenewTable();
//STRIP001 				GoToRow( 1 );
//STRIP001 				GoToColumnId( 2 );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				RenewTable();
//STRIP001 			}
//STRIP001 
//STRIP001             // logbook to trace row/column swappings.  This enables a correct
//STRIP001             // setting of attributes later
//STRIP001             if( m_apMemChart.get() )
//STRIP001 				m_pLogBook = new SchDataLogBook( *m_apMemChart );
//STRIP001 
//STRIP001             // the log-book will be removed by the ChartModel
//STRIP001             pMutableModel->SetDataLogBook( m_pLogBook );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			RenewTable();
//STRIP001 		}
//STRIP001         SetClean();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 const SchMemChart* ChartDataBrowseBox::GetData() const
//STRIP001 {
//STRIP001     return m_apMemChart.get();
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::InsertColumn()
//STRIP001 {
//STRIP001 	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
//STRIP001 	DBG_ASSERT( m_pLogBook, "No LogBook" );
//STRIP001 
//STRIP001 	USHORT nCurId = GetCurColumnId();
//STRIP001 
//STRIP001 	if( nCurId > 0 )
//STRIP001 	{
//STRIP001 		m_apMemChart->InsertCols( nCurId - 1, 1 );
//STRIP001 		m_pLogBook->InsertCol( nCurId - 1 );
//STRIP001 
//STRIP001 		RenewTable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::RemoveColumn()
//STRIP001 {
//STRIP001 	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
//STRIP001 	DBG_ASSERT( m_pLogBook, "No LogBook" );
//STRIP001 
//STRIP001     USHORT nCurId = GetCurColumnId();
//STRIP001 
//STRIP001 	if( nCurId > 1 )
//STRIP001 	{
//STRIP001         m_apMemChart->RemoveCols( nCurId - 2, 1 );
//STRIP001         m_pLogBook->DeleteCol( nCurId - 2 );
//STRIP001 
//STRIP001 		RenewTable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::InsertRow()
//STRIP001 {
//STRIP001 	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
//STRIP001 
//STRIP001 	long nCurRow = GetCurRow();
//STRIP001 
//STRIP001 	if( nCurRow >= 0 )
//STRIP001 	{
//STRIP001 		m_apMemChart->InsertRows( static_cast< short >( nCurRow ), 1 );
//STRIP001 		m_pLogBook->InsertRow( nCurRow );
//STRIP001 
//STRIP001 		RenewTable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::RemoveRow()
//STRIP001 {
//STRIP001 	DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
//STRIP001 
//STRIP001 	long nCurRow = GetCurRow();
//STRIP001 
//STRIP001 	if( nCurRow > 0 )
//STRIP001 	{
//STRIP001         m_apMemChart->RemoveRows( static_cast< short >( nCurRow - 1 ), 1 );
//STRIP001         m_pLogBook->DeleteRow( nCurRow -1 );
//STRIP001 
//STRIP001 		RenewTable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SwapColumn()
//STRIP001 {
//STRIP001 	USHORT nCurId = GetCurColumnId();
//STRIP001 
//STRIP001 	if( nCurId > 1 )
//STRIP001 	{
//STRIP001 		m_apMemChart->SwapCols( nCurId - 2, nCurId - 1 );
//STRIP001 		m_pLogBook->SwapCols(   nCurId - 2, nCurId - 1 );
//STRIP001 
//STRIP001 		if( nCurId < ColCount() - 1 )
//STRIP001 		{
//STRIP001             Dispatch( BROWSER_CURSORRIGHT );
//STRIP001 		}
//STRIP001 		Invalidate();
//STRIP001         SetDirty();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SwapRow()
//STRIP001 {
//STRIP001 	long nCurRow = GetCurRow();
//STRIP001 
//STRIP001 	if( nCurRow > 0 )
//STRIP001 	{
//STRIP001 		m_apMemChart->SwapRows(
//STRIP001             static_cast< short >( nCurRow - 1 ),
//STRIP001             static_cast< short >( nCurRow ) );
//STRIP001 		m_pLogBook->SwapRows( nCurRow - 1, nCurRow );
//STRIP001 
//STRIP001 		if( nCurRow < GetRowCount() - 1 )
//STRIP001 		{
//STRIP001             Dispatch( BROWSER_CURSORDOWN );
//STRIP001 		}
//STRIP001 		Invalidate();
//STRIP001         SetDirty();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::SetCursorMovedHdl( const Link& rLink )
//STRIP001 {
//STRIP001     m_aCursorMovedHdlLink = rLink;
//STRIP001 }
//STRIP001 
//STRIP001 const Link& ChartDataBrowseBox::GetCursorMovedHdl() const
//STRIP001 {
//STRIP001     return m_aCursorMovedHdlLink;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::QuickSortCol()
//STRIP001 {
//STRIP001     DeactivateCell();
//STRIP001 	m_apMemChart->SortCols( GetCurRow () - 1 );
//STRIP001 	m_pLogBook->SetValid( FALSE );
//STRIP001 	Invalidate();
//STRIP001     ActivateCell();
//STRIP001     SetDirty();
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::QuickSortRow()
//STRIP001 {
//STRIP001     DeactivateCell();
//STRIP001 	m_apMemChart->SortRows( GetCurColumnId () - 2 );
//STRIP001 	m_pLogBook->SetValid( FALSE );
//STRIP001 	Invalidate();
//STRIP001     ActivateCell();
//STRIP001     SetDirty();
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::QuickSortTableCols ()
//STRIP001 {
//STRIP001     DeactivateCell();
//STRIP001 	m_apMemChart->SortTableRows( GetCurColumnId () - 2 );
//STRIP001 	m_pLogBook->SetValid( FALSE );
//STRIP001 	Invalidate();
//STRIP001     ActivateCell();
//STRIP001     SetDirty();
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::QuickSortTableRows ()
//STRIP001 {
//STRIP001 	m_apMemChart->SortTableCols( GetCurRow () - 1 );
//STRIP001 	m_pLogBook->SetValid( FALSE );
//STRIP001 	Invalidate();
//STRIP001     ActivateCell();
//STRIP001     SetDirty();
//STRIP001 }
//STRIP001 
//STRIP001 // implementations for ::svt::EditBrowseBox (pure virtual methods)
//STRIP001 void ChartDataBrowseBox::PaintCell(
//STRIP001     OutputDevice& _rDev, const Rectangle& _rRect, sal_uInt16 _nColumnId ) const
//STRIP001 {
//STRIP001     Point aPos( _rRect.TopLeft());
//STRIP001     aPos.X() += 1;
//STRIP001 
//STRIP001     String aText = GetCellText( m_nSeekRow, _nColumnId );
//STRIP001     Size TxtSize( GetDataWindow().GetTextWidth( aText ), GetDataWindow().GetTextHeight());
//STRIP001 
//STRIP001     // clipping
//STRIP001     if( aPos.X() < _rRect.Right() || aPos.X() + TxtSize.Width() > _rRect.Right() ||
//STRIP001         aPos.Y() < _rRect.Top() || aPos.Y() + TxtSize.Height() > _rRect.Bottom())
//STRIP001         _rDev.SetClipRegion( _rRect );
//STRIP001 
//STRIP001     // allow for a disabled control ...
//STRIP001     sal_Bool bEnabled = IsEnabled();
//STRIP001     Color aOriginalColor = _rDev.GetTextColor();
//STRIP001     if( ! bEnabled )
//STRIP001         _rDev.SetTextColor( GetSettings().GetStyleSettings().GetDisableColor() );
//STRIP001 
//STRIP001     // draw the text
//STRIP001     _rDev.DrawText( aPos, aText );
//STRIP001 
//STRIP001     // reset the color (if necessary)
//STRIP001     if( ! bEnabled )
//STRIP001         _rDev.SetTextColor( aOriginalColor );
//STRIP001 
//STRIP001     if( _rDev.IsClipRegion())
//STRIP001         _rDev.SetClipRegion();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool ChartDataBrowseBox::SeekRow( long nRow )
//STRIP001 {
//STRIP001     if( ! EditBrowseBox::SeekRow( nRow ))
//STRIP001         return sal_False;
//STRIP001 
//STRIP001     if( nRow < 0 )
//STRIP001         m_nSeekRow = - 1;
//STRIP001     else
//STRIP001         m_nSeekRow = nRow;
//STRIP001 
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool ChartDataBrowseBox::IsTabAllowed( sal_Bool bForward ) const
//STRIP001 {
//STRIP001     long nRow = GetCurRow();
//STRIP001     long nCol = GetCurColumnId();
//STRIP001 
//STRIP001     // column 0 is header-column
//STRIP001     long nBadCol = bForward
//STRIP001         ? GetColumnCount() - 1
//STRIP001         : 1;
//STRIP001     long nBadRow = bForward
//STRIP001         ? GetRowCount() - 1
//STRIP001         : 0;
//STRIP001 
//STRIP001     return ( nRow != nBadRow ||
//STRIP001              nCol != nBadCol );
//STRIP001 }
//STRIP001 
//STRIP001 ::svt::CellController* ChartDataBrowseBox::GetController( long nRow, sal_uInt16 nCol )
//STRIP001 {
//STRIP001     // column 0 is header-column
//STRIP001     return ( m_bIsReadOnly || ( nRow == 0 && nCol == 1 ) )
//STRIP001         ? 0
//STRIP001         : & m_rEditController;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::InitController(
//STRIP001     ::svt::CellControllerRef& rController, long nRow, sal_uInt16 nCol )
//STRIP001 {
//STRIP001     String aText( GetCellText( nRow, nCol ) );
//STRIP001     m_aEditField.SetText( aText );
//STRIP001     m_aEditField.SetSelection( Selection( 0, aText.Len() ));
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool ChartDataBrowseBox::SaveModified()
//STRIP001 {
//STRIP001     if( ! IsModified() )
//STRIP001         return sal_True;
//STRIP001 
//STRIP001     DBG_ASSERT( m_apMemChart.get(), "No MemChart" );
//STRIP001 
//STRIP001     sal_Bool bChangeValid = sal_True;
//STRIP001 
//STRIP001     const short nRow = static_cast< short >( GetCurRow() );
//STRIP001     const short nCol = static_cast< short >( GetCurColumnId() );
//STRIP001     const String aText( m_aEditField.GetText() );
//STRIP001 
//STRIP001     DBG_ASSERT( nRow > 0 || nCol > 1, "This cell should not be modified!" );
//STRIP001 
//STRIP001     if( nRow == 0 )
//STRIP001     {
//STRIP001         m_apMemChart->SetColText( nCol - 2, aText );
//STRIP001     }
//STRIP001     else if( nCol == 1 )
//STRIP001     {
//STRIP001         m_apMemChart->SetRowText( nRow - 1, aText );
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // convert text to number
//STRIP001         double fData = DBL_MIN;
//STRIP001 
//STRIP001         if( aText.Len() > 0 )
//STRIP001         {
//STRIP001 			SvNumberFormatter* pFormatter = m_pModel->GetNumFormatter();
//STRIP001 			ULONG nFormat =
//STRIP001 				pFormatter->GetStandardFormat( m_apMemChart->GetDataType(),
//STRIP001                                                LANGUAGE_SYSTEM );
//STRIP001 			if( ! pFormatter->IsNumberFormat( aText, nFormat, fData ))
//STRIP001 			{
//STRIP001 				( WarningBox( this, WinBits( WB_OK ),
//STRIP001                               String( SchResId( STR_INVALID_NUMBER )))).Execute();
//STRIP001 				bChangeValid = false;
//STRIP001 			}
//STRIP001         }
//STRIP001 
//STRIP001         if( bChangeValid )
//STRIP001             m_apMemChart->SetData( nCol - 2, nRow - 1, fData );
//STRIP001     }
//STRIP001 
//STRIP001     // the first valid change changes this to true
//STRIP001     m_bIsDirty = m_bIsDirty || bChangeValid;
//STRIP001 
//STRIP001     if( m_bIsDirty )
//STRIP001     {
//STRIP001         RowModified( nRow, nCol );
//STRIP001         ::svt::CellController* pCtrl = GetController( nRow, nCol );
//STRIP001         if( pCtrl )
//STRIP001             pCtrl->ClearModified();
//STRIP001     }
//STRIP001 
//STRIP001     return bChangeValid;
//STRIP001 }
//STRIP001 
//STRIP001 void ChartDataBrowseBox::EndEditing()
//STRIP001 {
//STRIP001     if( IsModified())
//STRIP001         SaveModified();
//STRIP001 }
}
