/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: excupn.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:43:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _EXCUPN_HXX
#define _EXCUPN_HXX

#ifndef _XL_COMP_HXX
#include "xl_comp.hxx"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif
namespace binfilter {

class ScAddress;
class ExcUPN;
class ExcUPNList;
class ScRangeList;
class ExcArrays;




extern ExcUPN* CreateExcUpnFromScRangeList( RootData&, ScRangeList& );


class ExcUPNList : protected List
{
private:
protected:
public:
	virtual					~ExcUPNList();

	inline ExcUPN*			First( void );
	inline ExcUPN*			Last( void );
	inline ExcUPN*			Next( void );
	inline ExcUPN*			Prev( void );

	inline void				Append( ExcUPN* p );

	List::Count;
};


inline ExcUPN* ExcUPNList::First( void )
{
	return ( ExcUPN* ) List::First();
}


inline ExcUPN* ExcUPNList::Last( void )
{
	return ( ExcUPN* ) List::Last();
}


inline ExcUPN* ExcUPNList::Next( void )
{
	return ( ExcUPN* ) List::Next();
}


inline ExcUPN* ExcUPNList::Prev( void )
{
	return ( ExcUPN* ) List::Prev();
}


inline void ExcUPNList::Append( ExcUPN* p )
{
	List::Insert( p, LIST_APPEND );
}




class ExcUPN : public CExcelCompiler
{
public:
	inline					ExcUPN( RootData*, const ScTokenArray&, EC_Codetype& rCodeType,
									const ScAddress* pAddr = NULL, BOOL bConditionlFormat = FALSE,
									ExcArrays* pShrdFmlas = NULL );
	inline					ExcUPN( const ScTokenArray&, EC_Codetype& rCodeType );
	inline					ExcUPN( BOOL bDummy, RootData*, const ScTokenArray&, EC_Codetype& rCodeType,
									const ScAddress& rAddr  );
	inline					~ExcUPN();

	inline const sal_Char*	GetData( void ) const;
	inline UINT16			GetLen( void ) const;
};


inline ExcUPN::ExcUPN(	RootData* pRD, const ScTokenArray& rTA, EC_Codetype& rCodeType,
						const ScAddress* pAddr, BOOL bCF, ExcArrays* pShrdFmlas ) :
	CExcelCompiler( pRD, rTA, pAddr, bCF )
{
	rCodeType = CreateCode( pShrdFmlas );
}


inline ExcUPN::ExcUPN( const ScTokenArray& rTA, EC_Codetype& rCodeType ) :
	CExcelCompiler( NULL, rTA )
{
	rCodeType = CreateArrayCode();
}


inline ExcUPN::ExcUPN(	BOOL, RootData* pRD, const ScTokenArray& rTA, EC_Codetype& rCodeType,
						const ScAddress& rAddr ) :
	CExcelCompiler( pRD, rTA, &rAddr )
{
	rCodeType = CreateArrayCode( TRUE );
}


inline ExcUPN::~ExcUPN()
{
}

static const sal_Char pDef[] = { 0x1C, 0x2A };


inline const sal_Char* ExcUPN::GetData( void ) const
{
	return GetError() ? pDef : ( const sal_Char* ) ( GetCode()->nCode );
}


static const UINT16 nDefLen = 2;


inline UINT16 ExcUPN::GetLen( void ) const
{
	return GetError() ? nDefLen : GetCode()->nCce;
}


} //namespace binfilter
#endif

