/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class GridLayout
extends Layout {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    Vector grid = new Vector();
    int[] pixelColumnWidths;
    int[] pixelRowHeights;
    int[] expandableColumns;
    int[] expandableRows;

    public GridLayout() {
    }

    public GridLayout(int n, boolean bl) {
        this.numColumns = n;
        this.makeColumnsEqualWidth = bl;
    }

    void adjustGridDimensions(Composite composite, boolean bl) {
        int n = 0;
        while (n < this.grid.size()) {
            int n2 = 0;
            while (n2 < this.numColumns) {
                GridData gridData = ((GridData[])this.grid.elementAt(n))[n2];
                if (gridData.isItemData()) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    Point point;
                    Control control;
                    if (gridData.hSpan > 1) {
                        control = composite.getChildren()[gridData.childIndex];
                        point = control.computeSize(gridData.widthHint, gridData.heightHint, bl);
                        n11 = n2 + gridData.hSpan;
                        n10 = 0;
                        n9 = n2;
                        while (n9 < n11) {
                            n10 = n10 + this.pixelColumnWidths[n9] + this.horizontalSpacing;
                            ++n9;
                        }
                        if (point.x + gridData.horizontalIndent > (n10 -= this.horizontalSpacing)) {
                            n9 = point.x + gridData.horizontalIndent - n10;
                            n8 = n2 + gridData.hSpan - 1;
                            if (this.makeColumnsEqualWidth) {
                                int n12 = n9 / this.numColumns;
                                n7 = n9 % this.numColumns;
                                n6 = 0;
                                while (n6 < this.pixelColumnWidths.length) {
                                    this.pixelColumnWidths[n6] = n5 = this.pixelColumnWidths[n6] + n12;
                                    ++n6;
                                }
                                this.pixelColumnWidths[n8] = n5 = this.pixelColumnWidths[n8] + n7;
                            } else {
                                Vector<Integer> vector = new Vector<Integer>();
                                n7 = n2;
                                while (n7 <= n8) {
                                    n6 = 0;
                                    while (n6 < this.expandableColumns.length) {
                                        if (this.expandableColumns[n6] == n7) {
                                            vector.addElement(new Integer(n7));
                                        }
                                        ++n6;
                                    }
                                    ++n7;
                                }
                                if (vector.size() > 0) {
                                    n7 = n9 / vector.size();
                                    n6 = n9 % vector.size();
                                    n4 = 0;
                                    while (n4 < vector.size()) {
                                        n3 = (Integer)vector.elementAt(n4);
                                        this.pixelColumnWidths[n3] = n5 = this.pixelColumnWidths[n3] + n7;
                                        ++n4;
                                    }
                                    this.pixelColumnWidths[n8] = n5 = this.pixelColumnWidths[n8] + n6;
                                } else {
                                    this.pixelColumnWidths[n8] = n5 = this.pixelColumnWidths[n8] + n9;
                                }
                            }
                        }
                    }
                    if (gridData.verticalSpan > 1) {
                        control = composite.getChildren()[gridData.childIndex];
                        point = control.computeSize(gridData.widthHint, gridData.heightHint, bl);
                        n11 = n + gridData.verticalSpan;
                        n10 = 0;
                        n9 = n;
                        while (n9 < n11) {
                            n10 = n10 + this.pixelRowHeights[n9] + this.verticalSpacing;
                            ++n9;
                        }
                        if (point.y > (n10 -= this.verticalSpacing)) {
                            n9 = point.y - n10;
                            n8 = n + gridData.verticalSpan - 1;
                            Vector<Integer> vector = new Vector<Integer>();
                            n7 = n;
                            while (n7 <= n8) {
                                n6 = 0;
                                while (n6 < this.expandableRows.length) {
                                    if (this.expandableRows[n6] == n7) {
                                        vector.addElement(new Integer(n7));
                                    }
                                    ++n6;
                                }
                                ++n7;
                            }
                            if (vector.size() > 0) {
                                n7 = n9 / vector.size();
                                n6 = n9 % vector.size();
                                n4 = 0;
                                while (n4 < vector.size()) {
                                    n3 = (Integer)vector.elementAt(n4);
                                    this.pixelRowHeights[n3] = n5 = this.pixelRowHeights[n3] + n7;
                                    ++n4;
                                }
                                this.pixelRowHeights[n8] = n5 = this.pixelRowHeights[n8] + n6;
                            } else {
                                this.pixelRowHeights[n8] = n5 = this.pixelRowHeights[n8] + n9;
                            }
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    void calculateGridDimensions(Composite composite, boolean bl) {
        GridData gridData;
        int n;
        int n2;
        Control[] controlArray = composite.getChildren();
        Point[] pointArray = new Point[controlArray.length];
        this.pixelColumnWidths = new int[this.numColumns];
        this.pixelRowHeights = new int[this.grid.size()];
        int n3 = 0;
        while (n3 < this.numColumns) {
            n2 = 0;
            n = 0;
            while (n < this.grid.size()) {
                gridData = ((GridData[])this.grid.elementAt(n))[n3];
                if (gridData.isItemData()) {
                    Control control = controlArray[gridData.childIndex];
                    pointArray[gridData.childIndex] = control.computeSize(gridData.widthHint, gridData.heightHint, bl);
                    int n4 = pointArray[gridData.childIndex].x + gridData.horizontalIndent;
                    if (gridData.hSpan == 1) {
                        n2 = Math.max(n2, n4);
                    }
                }
                ++n;
            }
            this.pixelColumnWidths[n3] = n2;
            ++n3;
        }
        if (this.makeColumnsEqualWidth) {
            n2 = 0;
            n3 = 0;
            while (n3 < this.numColumns) {
                n2 = Math.max(n2, this.pixelColumnWidths[n3]);
                ++n3;
            }
            n2 += this.horizontalSpacing;
            n3 = 0;
            while (n3 < this.numColumns) {
                this.pixelColumnWidths[n3] = n2;
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < this.grid.size()) {
            int n5 = 0;
            n = 0;
            while (n < this.numColumns) {
                gridData = ((GridData[])this.grid.elementAt(n3))[n];
                if (gridData.isItemData()) {
                    int n6 = pointArray[gridData.childIndex].y;
                    if (gridData.verticalSpan == 1) {
                        n5 = Math.max(n5, n6);
                    }
                }
                ++n;
            }
            this.pixelRowHeights[n3] = n5;
            ++n3;
        }
    }

    void computeExpandableCells() {
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>();
        int n = 0;
        while (n < this.numColumns) {
            int n2 = 0;
            while (n2 < this.grid.size()) {
                GridData gridData = ((GridData[])this.grid.elementAt(n2))[n];
                if (gridData.grabExcessHorizontalSpace) {
                    hashtable.put(new Integer(n + gridData.hSpan - 1), new Object());
                }
                if (gridData.grabExcessVerticalSpace) {
                    hashtable2.put(new Integer(n2 + gridData.verticalSpan - 1), new Object());
                }
                ++n2;
            }
            ++n;
        }
        n = 0;
        Enumeration enumeration = hashtable.keys();
        this.expandableColumns = new int[hashtable.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableColumns[n] = (Integer)enumeration.nextElement();
            ++n;
        }
        n = 0;
        enumeration = hashtable2.keys();
        this.expandableRows = new int[hashtable2.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableRows[n] = (Integer)enumeration.nextElement();
            ++n;
        }
    }

    Point computeLayoutSize(Composite composite, int n, int n2, boolean bl) {
        if (this.grid.size() == 0) {
            this.createGrid(composite);
            this.calculateGridDimensions(composite, bl);
            this.computeExpandableCells();
            this.adjustGridDimensions(composite, bl);
        }
        int n3 = this.numColumns;
        int n4 = this.grid.size();
        int n5 = this.marginHeight;
        int n6 = this.marginWidth;
        int n7 = n6 * 2 + (n3 - 1) * this.horizontalSpacing;
        int n8 = 0;
        while (n8 < this.pixelColumnWidths.length) {
            n7 += this.pixelColumnWidths[n8];
            ++n8;
        }
        int n9 = n5 * 2 + (n4 - 1) * this.verticalSpacing;
        n8 = 0;
        while (n8 < this.pixelRowHeights.length) {
            n9 += this.pixelRowHeights[n8];
            ++n8;
        }
        if (n != -1) {
            n7 = n;
        }
        if (n2 != -1) {
            n9 = n2;
        }
        return new Point(n7, n9);
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Control[] controlArray = composite.getChildren();
        int n3 = controlArray.length;
        if (n3 == 0) {
            return new Point(0, 0);
        }
        if (bl) {
            this.grid.removeAllElements();
        }
        return this.computeLayoutSize(composite, n, n2, bl);
    }

    Point getFirstEmptyCell(int n, int n2) {
        GridData[] gridDataArray = (GridData[])this.grid.elementAt(n);
        while (n2 < this.numColumns && gridDataArray[n2] != null) {
            ++n2;
        }
        if (n2 == this.numColumns) {
            n2 = 0;
            if (++n == this.grid.size()) {
                this.grid.addElement(this.emptyRow());
            }
            return this.getFirstEmptyCell(n, n2);
        }
        return new Point(n, n2);
    }

    Point getLastEmptyCell(int n, int n2) {
        GridData[] gridDataArray = (GridData[])this.grid.elementAt(n);
        while (n2 < this.numColumns && gridDataArray[n2] == null) {
            ++n2;
        }
        return new Point(n, n2 - 1);
    }

    Point getCell(int n, int n2, int n3, int n4) {
        Point point = this.getFirstEmptyCell(n, n2);
        Point point2 = this.getLastEmptyCell(point.x, point.y);
        if (point2.y + 1 - point.y >= n3) {
            return point;
        }
        GridData[] gridDataArray = (GridData[])this.grid.elementAt(point.x);
        int n5 = point.y;
        while (n5 < point2.y + 1) {
            GridData gridData = new GridData();
            gridData.isItemData = false;
            gridDataArray[n5] = gridData;
            ++n5;
        }
        return this.getCell(point2.x, point2.y, n3, n4);
    }

    void createGrid(Composite composite) {
        GridData gridData;
        GridData[] gridDataArray;
        Control[] controlArray = composite.getChildren();
        this.grid.addElement(this.emptyRow());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < controlArray.length) {
            int n4;
            gridDataArray = controlArray[n3];
            GridData gridData2 = (GridData)gridDataArray.getLayoutData();
            if (gridData2 == null) {
                gridData2 = new GridData();
                gridDataArray.setLayoutData(gridData2);
            }
            gridData2.hSpan = Math.min(gridData2.horizontalSpan, this.numColumns);
            Point point = this.getCell(n, n2, gridData2.hSpan, gridData2.verticalSpan);
            n = point.x;
            n2 = point.y;
            int n5 = 2;
            while (n5 <= gridData2.verticalSpan) {
                if (n + n5 > this.grid.size()) {
                    this.grid.addElement(this.emptyRow());
                }
                ++n5;
            }
            ((GridData[])this.grid.elementAt((int)n))[n2] = gridData2;
            gridData2.childIndex = n3;
            int n6 = gridData2.verticalSpan - 1;
            int n7 = gridData2.hSpan - 1;
            n5 = 1;
            while (n5 <= n6) {
                n4 = 0;
                while (n4 < gridData2.hSpan) {
                    gridData = new GridData();
                    gridData.isItemData = false;
                    ((GridData[])this.grid.elementAt((int)(n + n5)))[n2 + n4] = gridData;
                    ++n4;
                }
                ++n5;
            }
            n5 = 1;
            while (n5 <= n7) {
                n4 = 0;
                while (n4 < gridData2.verticalSpan) {
                    gridData = new GridData();
                    gridData.isItemData = false;
                    ((GridData[])this.grid.elementAt((int)(n + n4)))[n2 + n5] = gridData;
                    ++n4;
                }
                ++n5;
            }
            n2 = n2 + gridData2.hSpan - 1;
            ++n3;
        }
        n3 = n;
        while (n3 < this.grid.size()) {
            gridDataArray = (GridData[])this.grid.elementAt(n3);
            int n8 = 0;
            while (n8 < this.numColumns) {
                if (gridDataArray[n8] == null) {
                    gridData = new GridData();
                    gridData.isItemData = false;
                    gridDataArray[n8] = gridData;
                }
                ++n8;
            }
            ++n3;
        }
    }

    GridData[] emptyRow() {
        GridData[] gridDataArray = new GridData[this.numColumns];
        int n = 0;
        while (n < this.numColumns) {
            gridDataArray[n] = null;
            ++n;
        }
        return gridDataArray;
    }

    protected void layout(Composite composite, boolean bl) {
        GridData gridData;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Control[] controlArray;
        if (bl) {
            this.grid.removeAllElements();
        }
        if ((controlArray = composite.getChildren()).length == 0) {
            return;
        }
        Point point = this.computeSize(composite, -1, -1, bl);
        int[] nArray = new int[this.numColumns];
        int n7 = 0;
        while (n7 < this.pixelColumnWidths.length) {
            nArray[n7] = this.pixelColumnWidths[n7];
            ++n7;
        }
        int[] nArray2 = new int[this.grid.size()];
        n7 = 0;
        while (n7 < this.pixelRowHeights.length) {
            nArray2[n7] = this.pixelRowHeights[n7];
            ++n7;
        }
        n7 = 0;
        int n8 = Math.max(1, this.grid.size());
        int n9 = point.x;
        int n10 = point.y;
        int n11 = composite.getClientArea().width - n9;
        int n12 = composite.getClientArea().height - n10;
        if (this.expandableColumns.length != 0) {
            n6 = n11 / this.expandableColumns.length;
            n5 = n11 % this.expandableColumns.length;
            n4 = 0;
            n3 = 0;
            while (n3 < this.expandableColumns.length) {
                n2 = this.expandableColumns[n3];
                n = nArray[n2];
                nArray[n2] = n += n6;
                n4 = Math.max(n4, n2);
                ++n3;
            }
            n = nArray[n4];
            nArray[n4] = n += n5;
        }
        n6 = 0;
        while (n6 < this.expandableColumns.length) {
            n5 = this.expandableColumns[n6];
            n4 = nArray[n5];
            n = 0;
            n3 = 0;
            while (n3 < this.grid.size()) {
                GridData[] gridDataArray = (GridData[])this.grid.elementAt(n3);
                gridData = gridDataArray[n5];
                if (gridData.hSpan == 1) {
                    n = Math.max(n, gridData.widthHint);
                }
                ++n3;
            }
            nArray[n5] = Math.max(n4, n);
            ++n6;
        }
        if (this.expandableRows.length != 0) {
            n6 = n12 / this.expandableRows.length;
            n5 = n12 % this.expandableRows.length;
            n4 = 0;
            n3 = 0;
            while (n3 < this.expandableRows.length) {
                n2 = this.expandableRows[n3];
                n = nArray2[n2];
                nArray2[n2] = n += n6;
                n4 = Math.max(n4, n2);
                ++n3;
            }
            n = nArray2[n4];
            nArray2[n4] = n += n5;
        }
        n6 = 0;
        while (n6 < this.expandableRows.length) {
            n5 = this.expandableRows[n6];
            n4 = nArray2[n5];
            n = 0;
            GridData[] gridDataArray = (GridData[])this.grid.elementAt(n5);
            n2 = 0;
            while (n2 < this.numColumns) {
                gridData = gridDataArray[n2];
                if (gridData.verticalSpan == 1) {
                    n = Math.max(n, gridData.heightHint);
                }
                ++n2;
            }
            nArray2[n5] = Math.max(n4, n);
            ++n6;
        }
        int n13 = this.marginWidth + composite.getClientArea().x;
        int n14 = this.marginHeight + composite.getClientArea().y;
        n6 = 0;
        while (n6 < n8) {
            n5 = nArray2[n6];
            GridData[] gridDataArray = (GridData[])this.grid.elementAt(n6);
            n = 0;
            while (n < gridDataArray.length) {
                int n15;
                int n16 = 0;
                n2 = 0;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = 0;
                int n22 = 0;
                GridData gridData2 = gridDataArray[n];
                if (this.makeColumnsEqualWidth) {
                    n7 = composite.getClientArea().width - 2 * this.marginWidth - (this.numColumns - 1) * this.horizontalSpacing;
                    n7 /= this.numColumns;
                    n15 = 0;
                    while (n15 < nArray.length) {
                        nArray[n15] = n7;
                        ++n15;
                    }
                } else {
                    n7 = nArray[n];
                }
                n16 = n7;
                n15 = 1;
                while (n15 < gridData2.hSpan) {
                    if (n + n15 <= this.numColumns) {
                        if (!this.makeColumnsEqualWidth) {
                            n7 = nArray[n + n15];
                        }
                        n16 = n16 + n7 + this.horizontalSpacing;
                    }
                    ++n15;
                }
                n2 = n5;
                n15 = 1;
                while (n15 < gridData2.verticalSpan) {
                    if (n6 + n15 <= this.grid.size()) {
                        n2 = n2 + nArray2[n6 + n15] + this.verticalSpacing;
                    }
                    ++n15;
                }
                if (gridData2.isItemData()) {
                    Control control = controlArray[gridData2.childIndex];
                    Point point2 = control.computeSize(gridData2.widthHint, gridData2.heightHint, bl);
                    n17 = gridData2.horizontalAlignment;
                    n19 = n13;
                    n19 = n17 == 2 || n17 == 0x1000000 ? n19 + n16 / 2 - point2.x / 2 : (n17 == 3 || n17 == 0x1000008 || n17 == 131072 ? n19 + n16 - point2.x - gridData2.horizontalIndent : (n19 += gridData2.horizontalIndent));
                    if (n17 == 4) {
                        n21 = n16 - gridData2.horizontalIndent;
                        n19 = n13 + gridData2.horizontalIndent;
                    } else {
                        n21 = point2.x;
                    }
                    n18 = gridData2.verticalAlignment;
                    n20 = n14;
                    if (n18 == 2 || n18 == 0x1000000) {
                        n20 = n20 + n2 / 2 - point2.y / 2;
                    } else if (n18 == 3 || n18 == 0x1000008 || n18 == 1024) {
                        n20 = n20 + n2 - point2.y;
                    }
                    if (n18 == 4) {
                        n22 = n2;
                        n20 = n14;
                    } else {
                        n22 = point2.y;
                    }
                    control.setBounds(n19, n20, n21, n22);
                }
                n13 = n13 + nArray[n] + this.horizontalSpacing;
                ++n;
            }
            n14 = n14 + nArray2[n6] + this.verticalSpacing;
            n13 = this.marginWidth + composite.getClientArea().x;
            ++n6;
        }
    }
}

