/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    private Control control;
    private Listener controlListener;
    private Transfer[] transferAgents = new Transfer[0];
    private static final String DRAGSOURCEID = "DragSource";
    static /* synthetic */ Class class$0;

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29) {
                    DragSource.this.isDisposed();
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    public Control getControl() {
        return this.control;
    }

    public Display getDisplay() {
        if (this.control == null) {
            DND.error(24);
        }
        return this.control.getDisplay();
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }
}

