###################################################################################################
# _blobfields.py
#
# $Id: _blobfields.py,v 1.6 2004/02/02 21:14:30 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.6 $
#
# Implementation of classes MyFile, MyImage, etc. (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from OFS.Image import Image, File
from cStringIO import StringIO
import copy
# Product Imports.
import _fileutil
import _globals
import _mimetypes


# ----------------------------------------------------------------------------------------------
#  _blobfields.hex2bin:
# ----------------------------------------------------------------------------------------------
def hex2bin(m):
  return ''.join(map(lambda x: chr(16*int('0x%s'%m[x*2],0)+int('0x%s'%m[x*2+1],0)),range(len(m)/2)))


# ----------------------------------------------------------------------------------------------
#  _blobfields.bin2hex:
# ----------------------------------------------------------------------------------------------
def bin2hex(m):
  return ''.join(map(lambda x: hex(ord(x)/16)[-1]+hex(ord(x)%16)[-1],m))


# ----------------------------------------------------------------------------------------------
#  _blobfields.recurse_downloadRessources:
#
#  Download from ZODB to file-system during Export.
# ----------------------------------------------------------------------------------------------
def recurse_downloadRessources(self, folder='.'):
  message = ''
  obj_attrs = self.getObjAttrs()
  # Attributes.
  for key in obj_attrs.keys():
    obj_attr = self.getObjAttr(key)
    datatype = obj_attr['datatype_key']
    if datatype in _globals.DT_BLOBS:
      for lang in self.getLangIds():
        try:
          if obj_attr['multilang']==1 or lang==self.getPrimaryLanguage():
            req = {'lang':lang,'preview':'preview'}
            obj_vers = self.getObjVersion(req)
            blob = self._getObjAttrValue(obj_attr,obj_vers,lang)
            if blob is not None: 
              filepath = self.absolute_url()[len(self.getDocumentElement().absolute_url()):]
              filename = blob.getFilename()
              filename = getLangFilename(self,filename,lang)
              filename = '%s/%s/%s'%(folder,filepath,filename)
              filename = _fileutil.getOSPath(filename)
              _fileutil.exportObj(blob,filename)
        except:
          _globals.writeException(self,"[recurse_downloadRessources]")
  # Process children.
  for child in self.getChildNodes():
    message += recurse_downloadRessources(child,folder)
  # Return message.
  return message


# ----------------------------------------------------------------------------------------------
#  _blobfields.recurse_uploadRessources:
#
#  Upload from file-system to ZODB during Import.
# ----------------------------------------------------------------------------------------------
def recurse_uploadRessources(self, folder='.'):
  message = ''
  obj_attrs = self.getObjAttrs()
  # Attributes.
  for key in obj_attrs.keys():
    obj_attr = self.getObjAttr(key)
    datatype = obj_attr['datatype_key']
    if datatype in _globals.DT_BLOBS:
      for lang in self.getLangIds():
        try:
          if obj_attr['multilang']==1 or lang==self.getPrimaryLanguage():
            req = {'lang':lang,'preview':'preview'}
            obj_vers = self.getObjVersion(req)
            blob = self._getObjAttrValue(obj_attr,obj_vers,lang)
            if blob is not None:
              filename = _fileutil.getOSPath('%s/%s'%(folder,blob.getFilename()))
              # Backup properties (otherwise manage_upload sets it).
              bk = {}
              for __xml_attr__ in blob.__xml_attrs__:
                bk[__xml_attr__] = getattr(blob,__xml_attr__,'')
              # Read file to ZODB.
              f = open(filename,'rb')
              uploadBlobField(self,blob,f.read(),blob.filename)
              f.close()
              # Restore properties.
              for __xml_attr__ in blob.__xml_attrs__:
                if bk.get(__xml_attr__,'') not in ['','text/x-unknown-content-type']:
                  setattr(blob,__xml_attr__,bk[__xml_attr__])
              blob.filename = _fileutil.extractFileName(filename)
              self.setObjProperty(key,blob,lang)
              self.onChangeObj(req,forced=1)
        except:
          _globals.writeException(self,"[recurse_uploadRessources]")
  # Synchronize.
  synchronizeBlobFields(self)
  # Process children.
  for child in self.getChildNodes():
    message = message + recurse_uploadRessources(child,folder)
  # Return message.
  return message


# --------------------------------------------------------------------------------------------------
#  _blobfields.createBlobField:
#
#  Create blob-field of desired object-type and initialize it with given file.
#
#  IN:	objtype	[DT_IMAGE|DT_FILE|'{{MyImage}}'|'{{MyFile}}'
#	file	[ZPublisher.HTTPRequest.FileUpload|dictionary]
#  OUT:	blob	[MyImage|MyFile]
# --------------------------------------------------------------------------------------------------
def createBlobField(self, objtype, file=''):
  blob = None
  i = MyImage(id='',title='',file='')
  f = MyFile(id='',title='',file='')
  if objtype == _globals.DT_IMAGE or objtype == str(i):
    blob = i
  elif objtype == _globals.DT_FILE or objtype == str(f):
    blob = f
  if blob is not None:
    blob.mediadbfile = None
    if type(file) is type({}):
      uploadBlobField(self,blob,StringIO(file.get('data','')),file.get('filename',''))
      if file.has_key('content_type'): blob.content_type = file.get('content_type')
    elif file:
      uploadBlobField(self,blob,file,file.filename)
  return blob


# --------------------------------------------------------------------------------------------------
#  _blobfields.uploadBlobField
# --------------------------------------------------------------------------------------------------
def uploadBlobField(self, blob, data, filename):
  if data:
    filename = _fileutil.extractFileName(filename)
    blob.filename = filename
    blob.uploadData(data)
    if self is not None:
      mediadb = self.getMediaDb()
      if mediadb is not None:
        blob.aq_parent = self
        blob.mediadbfile = mediadb.storeFile(blob)
        blob.data = ''


# --------------------------------------------------------------------------------------------------
#  _blobfields.getLangFilename:
#  
#  Returns filename concatenated with language suffix.
# --------------------------------------------------------------------------------------------------
def getLangFilename(self, filename, lang):
  i = filename.rfind('.')
  name = filename[:i]
  name = name.replace(' ','_')
  ext = filename[i+1:]
  if len(self.getLangIds()) > 1 and lang is not None:
    suffix = '_' + lang
    if len(name) > len(suffix) and name[-len(suffix):] != suffix:
      name += suffix
  name += '.' + ext
  return name


# --------------------------------------------------------------------------------------------------
#  _blobfields.synchronizeBlobFields:
#
#  Deletes and (Re-)creates DTML Methods as aliases for blob-fields.
# --------------------------------------------------------------------------------------------------
def synchronizeBlobFields(self):
  #++ if _globals.debug: print "[%s.synchronizeBlobFields]:"%(self.meta_type)

  # Delete DTML Methods.
  title = 'blob_html'
  ids = map(lambda ob: ob.id(),filter(lambda ob: ob.title==title,self.objectValues(['DTML Method'])))
  if len(ids)>0:
    try:
      self.manage_delObjects(ids)
    except:
      pass

  # Create DTML Methods.
  for key in self.getObjAttrs().keys():
    obj_attr = self.getObjAttr(key)
    datatype = obj_attr['datatype_key']
    if datatype in _globals.DT_BLOBS:
      for lang in self.getLangIds():
        if obj_attr['multilang']==1 or lang==self.getPrimaryLanguage():
          for obj_vers in self.getObjVersions():
            v = self._getObjAttrValue(obj_attr,obj_vers,lang)
            if v is not None:
              
              # DTML call returns blob_html.
              raw = ''
              raw += '<dtml-call \"REQUEST.set(\'lang\',\'%s\')\">\n'%lang
              raw += '<dtml-return "blob_html(\'%s\',REQUEST,RESPONSE)">\n'%key
              
              # Add DTML Method with language suffix.
              filename = _globals.filename_quote(v.filename)
              try:
                self.manage_addDTMLMethod(filename,title,raw)
              except:
                pass
              
              # Add DTML Method with language suffix.
              filename = getLangFilename(self,filename,lang)
              try:
                self.manage_addDTMLMethod(filename,title,raw)
              except:
                pass


"""
###################################################################################################
###
###   T H U M B N A I L S
###
###################################################################################################
"""

# --------------------------------------------------------------------------------------------------
#  _blobfields.thumbnailImageFields:
#
#  Process image-fields and shrink superres to hires and hires to lores. 
# --------------------------------------------------------------------------------------------------
def thumbnailImageFields(self, lang, manage_lang,REQUEST):
  message = ""
  if self.getConfProperty('InstalledProducts.pil',0) and \
     self.getConfProperty('InstalledProducts.pil.thumbnail',0):
    obj_attrs = self.getObjAttrs()
    for key in obj_attrs.keys():
      obj_attr = self.getObjAttr(key)
      datatype = obj_attr['datatype_key']
      if datatype == _globals.DT_IMAGE:
        message += thumbnailImage(self,'%ssuperres'%key,'%shires'%key,self.getConfProperty('InstalledProducts.pil.hires.thumbnail.max',600),lang,manage_lang,REQUEST)
        message += thumbnailImage(self,'%shires'%key,'%s'%key,self.getConfProperty('InstalledProducts.pil.thumbnail.max',100),lang,manage_lang,REQUEST)
  return message

# --------------------------------------------------------------------------------------------------
#  _blobfields.thumbnailImage:
#
#  Process image-field and shrink attribute given by hiresKey to attribute given by loresKey. 
# --------------------------------------------------------------------------------------------------
def thumbnailImage(self, hiresKey, loresKey, maxdim, lang, manage_lang, REQUEST):
  message = ""
  try:
    if hiresKey in self.getObjAttrs().keys():
      hiresImg = self.getObjProperty(hiresKey,REQUEST)
      if hiresImg is not None and REQUEST.get('generate_preview_%s_%s'%(hiresKey,lang),0):
        if _globals.debug: print "[%s.manage_changeProperties]: Create >%s< from >%s<..."%(self.meta_type,loresKey,hiresKey)
        loresImg = _fileutil.createThumbnail(hiresImg,maxdim)
        self.setObjProperty(loresKey,loresImg,lang)
  except:
    pass
  return message


###################################################################################################
###################################################################################################

class MyBlob:

    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getObjAttrs:
    # ---------------------------------------------------------------------------------------------
    getObjAttrs__roles__ = None
    def getObjAttrs(self, meta_type=None):
      return {}

    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getData:
    # ---------------------------------------------------------------------------------------------
    getData__roles__ = None
    def getData(self):
      data = ''
      mediadbfile = self.getMediadbfile()
      if mediadbfile is not None:
        parent = self.aq_parent
        mediadb = parent.getMediaDb()
        if mediadb is not None:
          try:
            data = mediadb.retrieveFile(mediadbfile)
          except:
            pass
      else:
        data = str(getattr(self,'data',''))
      return data
    
    # ---------------------------------------------------------------------------------------------
    #  MyBlob.blob_html: 
    # ---------------------------------------------------------------------------------------------
    blob_html__roles__ = None
    def blob_html(self, REQUEST, RESPONSE):
      filename = self.getFilename()
      content_type = getattr(self,'content_type','application/octet-stream')
      RESPONSE.setHeader('Content-Type',content_type)
      RESPONSE.setHeader('Content-Disposition','inline;filename=%s'%filename)
      return self.getData()
    
    # ---------------------------------------------------------------------------------------------
    #  MyBlob.src: 
    # 
    #  DEPRECATED!
    # ---------------------------------------------------------------------------------------------
    src__roles__ = None
    def src(self, parent, key, REQUEST):
      qs = ''
      filename = self.getFilename()
      orig = filename
      for i in range(2):
        ids = parent.objectIds(['DTML Method'])
        try:
          lang = self.lang
          while lang:
            langfilename = getLangFilename(parent,filename,lang)
            if langfilename in ids:
              filename = langfilename
              break
            lang = parent.getParentLanguage(lang)
        except:
          pass
        if i == 0 and orig == filename:
          synchronizeBlobFields(parent)
	else:
	  break
      if filename not in ids:
        filename = 'blob_html'
        qs = _globals.qs_append(qs,'key',key)
        qs = _globals.qs_append(qs,'lang',REQUEST['lang'])
      if REQUEST.get('ZMS_VERSION',None) is not None:
        qs = _globals.qs_append(qs,'ZMS_VERSION',REQUEST['ZMS_VERSION'])
      elif _globals.isPreviewRequest(REQUEST):
        qs = _globals.qs_append(qs,'preview','preview')
      try:
        filename=parent.absolute_url()+'/'+filename
      except:
        filename=parent.id+'/'+filename
      return filename+qs

    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getHref:
    # ---------------------------------------------------------------------------------------------
    getHref__roles__ = None
    def getHref(self, REQUEST):
      parent = self.aq_parent
      key = self.key
      return self.src(parent,key,REQUEST)

    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getMediadbfile: 
    #
    #  Returns mediadb-filename.
    # ---------------------------------------------------------------------------------------------
    getMediadbfile__roles__ = None
    def getMediadbfile(self):
      return getattr(self,'mediadbfile',None)

    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getFilename: 
    #
    #  Returns filename.
    # ---------------------------------------------------------------------------------------------
    getFilename__roles__ = None
    def getFilename(self):
      filename = self.filename
      filename = _globals.filename_quote(filename)
      if filename != self.filename: self.filename = filename
      return filename
    
    # ---------------------------------------------------------------------------------------------
    #  MyBlob.get_size: 
    #
    #  Returns file-size.
    # ---------------------------------------------------------------------------------------------
    get_size__roles__ = None
    def get_size(self):
      size = 0
      data = self.getData()
      if data is not None:
        size = len(data)
      return size
    
    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.getDataSizeStr: 
    #
    #	Returns display string of file-size (KB).
    # ---------------------------------------------------------------------------------------------
    getDataSizeStr__roles__ = None
    def getDataSizeStr(self):
      return _fileutil.getDataSizeStr(self.get_size())

    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.getContentType:
    #
    #	MIME-type.
    # ---------------------------------------------------------------------------------------------
    getContentType__roles__ = None
    def getContentType(self):
      return self.content_type

    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.getMimeTypeIconSrc:
    #
    #	Image source for MIME-type.
    # ---------------------------------------------------------------------------------------------
    getMimeTypeIconSrc__roles__ = None
    def getMimeTypeIconSrc(self):
      content_type = self.getContentType()
      if not _mimetypes.dctMimeType.has_key(content_type):
        content_type = 'content/unknown'
      return 'misc_/zms/%s'%_mimetypes.dctMimeType[content_type]

    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.xmlGetTagName: 
    #
    #	Returns <XML> Tag-Name.
    # ---------------------------------------------------------------------------------------------
    def xmlGetTagName(self):
      return 'data'


###################################################################################################
###################################################################################################

class MyImage(MyBlob,Image):

    __obj_attrs__ = ['content_type','size','data','filename','mediadbfile','width','height']
    __xml_attrs__ = ['content_type','width','height']
    
    def __str__(self):
      return '{{MyImage}}'

    # ---------------------------------------------------------------------------------------------
    # 	MyImage.uploadData:
    # ---------------------------------------------------------------------------------------------
    def uploadData(self, data):
      ob = Image(id='',title='',file='')
      ob.manage_upload(data)
      for key in ['size','width','height','content_type','data']:
        if hasattr(ob,key):
          setattr(self,key,getattr(ob,key))
    
    # ---------------------------------------------------------------------------------------------
    # 	MyImage._getCopy:
    # ---------------------------------------------------------------------------------------------
    def _getCopy(self):
      self.getFilename() # Normalize filename
      ob = self
      clone = MyImage(id='',title='',file='')
      attrs = self.__obj_attrs__
      for attr in attrs:
        if hasattr(ob,attr):
          setattr(clone,attr,getattr(ob,attr))
      return clone

    # ---------------------------------------------------------------------------------------------
    # 	MyImage.toXml:
    # ---------------------------------------------------------------------------------------------
    def toXml(self, sender=None):
      data = ''
      objtype = ''
      filename = _fileutil.getOSPath(_fileutil.extractFileName(getattr(self,'filename','')))
      if sender is None:
        if getattr(self,'content_type','').find('text/') == 0:
          data = '<![CDATA[%s]]>'%str(self.getData())
        else:
          data = bin2hex(self.getData())
        objtype = ' type="image"'
      else:
        filepath = sender.absolute_url()[len(sender.getDocumentElement().absolute_url())+1:]
        filename = self.getFilename()
        filename = getLangFilename(sender,filename,self.lang)
        filename = '%s/%s'%(filepath,filename)
      xml = '\n<%s'%self.xmlGetTagName()
      xml += ' width="%s"'%str(getattr(self,'width',''))
      xml += ' height="%s"'%str(getattr(self,'height',''))
      xml += ' content_type="%s"'%str(getattr(self,'content_type',''))
      xml += ' filename="%s"'%filename
      xml += objtype + '>' + data
      xml += '</%s>'%self.xmlGetTagName()
      return xml

    # ---------------------------------------------------------------------------------------------
    # 	MyImage.getWidth:
    # ---------------------------------------------------------------------------------------------
    getWidth__roles__ = None
    def getWidth(self):
      return self.width

    # ---------------------------------------------------------------------------------------------
    # 	MyImage.getHeight:
    # ---------------------------------------------------------------------------------------------
    getHeight__roles__ = None
    def getHeight(self):
      return self.height


###################################################################################################
###################################################################################################

class MyFile(MyBlob,File):

    __obj_attrs__ = ['content_type','size','data','filename','mediadbfile']
    __xml_attrs__ = ['content_type']

    def __str__(self):
      return '{{MyFile}}'

    # ---------------------------------------------------------------------------------------------
    # 	MyFile.uploadData:
    # ---------------------------------------------------------------------------------------------
    def uploadData(self, data):
      ob = File(id='',title='',file=data)
      for key in ['size','content_type','data']:
        if hasattr(ob,key):
          setattr(self,key,getattr(ob,key))
    
    # ---------------------------------------------------------------------------------------------
    # 	MyFile._getCopy:
    # ---------------------------------------------------------------------------------------------
    def _getCopy(self):
      self.getFilename() # Normalize filename
      ob = self
      clone = MyFile(id='',title='',file='')
      attrs = self.__obj_attrs__
      for attr in attrs:
        if hasattr(ob,attr):
          setattr(clone,attr,getattr(ob,attr))
      return clone

    # ---------------------------------------------------------------------------------------------
    # 	MyFile.toXml:
    # ---------------------------------------------------------------------------------------------
    def toXml(self, sender=None):
      data = ''
      objtype = ''
      filename = _fileutil.getOSPath(_fileutil.extractFileName(getattr(self,'filename','')))
      if sender is None:
        if getattr(self,'content_type','').find('text/') == 0:
          data = '<![CDATA[%s]]>'%str(self.getData())
        else:
          data = bin2hex(self.getData())
        objtype = ' type="file"'
      else:
        filepath = sender.absolute_url()[len(sender.getDocumentElement().absolute_url())+1:]
        filename = self.getFilename()
        filename = getLangFilename(sender,filename,self.lang)
        filename = '%s/%s'%(filepath,filename)
      xml = '\n<%s'%self.xmlGetTagName()
      xml += ' content_type="%s"'%str(getattr(self,'content_type',''))
      xml += ' filename="%s"'%filename
      xml += objtype + '>' + data
      xml += '</%s>'%self.xmlGetTagName()
      return xml

###################################################################################################
