## ITrack CSV export script

qty_transcripts = 0

## replace enter by a space and double quotes by single quotes
def escape_str(str):
    return "\"" + " ".join(str.replace("\"","'").split("\r\n")) + "\""

def header(schema):
    global qty_transcripts
    f = [escape_str(f.__name__) for f in schema.fields()]
    t = ["Transcript%d" % i for i in range(qty_transcripts)]
    f.extend(t)
    return ",".join(f) + "\r\n"

def transcripts(issue):
    global qty_transcripts
    transcript = issue._transcript
    r = ""
    cont = 0
    for t in transcript._items.items():
        if t[1].getValue('type') == 'comment':
            transcript_text = t[1].getValue('comment')
            r += "%s," % escape_str(transcript_text)
            cont += 1
    qty_transcripts = max(qty_transcripts, cont)
    return r

def export_csv(self):
    schema = self.schema_getWholeSchema()
    r = ""
    for o in self.objectValues(['PloneIssueNG']):
        l = ""
        for f in schema.fields():
            content = str(f.get(o))
            l += "%s," % escape_str(content)
        l += transcripts(o)
        r += l[:-1] + "\r\n"
    return header(schema) + r
