from validator import RegexValidator, RangeValidator

_validators = [
    RangeValidator('inNumericRange'),
    RegexValidator('isDecimal',
                   r'^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$'),
    RegexValidator('isInt', r'^([+-])?\d+$'),
    RegexValidator('isPrintable', r'[a-zA-Z0-9\s]+$'),
    RegexValidator('isSSN', r'^\d{9}$'),
    RegexValidator('isUSPhoneNumber', r'^\d{10}$', ignore='[\(\)\-\s]'),
    RegexValidator('isInternationalPhoneNumber', r'^\d+$', ignore='[\(\)\-\s\+]'),
    RegexValidator('isZipCode', r'^(\d{5}|\d{9})$'),
    RegexValidator('isURL', r'(ht|f)tps?://[^\s\r\n]+'),
    RegexValidator('isEmail', "^([0-9a-zA-Z_&.+-]+!)*[0-9a-zA-Z_&.+-]+@(([0-9a-z]([0-9a-z-]*[0-9a-z])?\.)+[a-z]{2,6}|([0-9]{1,3}\.){3}[0-9]{1,3})$"),
    ]


def initialize(service):
    for v in _validators:
        service.register(v)
