/*____________________________________________________________________________
        
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1998-1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
        
        $Id: pmo.cpp,v 1.12 2003/09/16 17:35:05 kgk Exp $
____________________________________________________________________________*/

/* system headers */
#include <stdlib.h>
#include <iostream>
#include <fcntl.h>
//#include <sys/soundcard.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <assert.h>
#include <stdarg.h>

/* project headers */
using namespace std;
#include "config.h"
#include "pipeline.h"
#include "pullbuffer.h"
#include "preferences.h"
#include "eventbuffer.h"
#include "eventdata.h"
#include "facontext.h"
#include "log.h"
#include "debug.h"

#define DB printf("%s:%d\n", __FILE__, __LINE__);  

PhysicalMediaOutput::PhysicalMediaOutput(FAContext *context) :
                     PipelineUnit(context)
{
    m_pPmi = NULL;
    m_pLmc = NULL;
    m_iBufferUpdate = -1;

    if (context->prefs->GetPrefInt32(kPreBufferPref, &m_iPreBuffer) == 
        kError_NoPrefValue)
         m_iPreBuffer = 0;
}

PhysicalMediaOutput::~PhysicalMediaOutput()
{
    m_bExit = true;

    if (m_pLmc)
        m_pLmc->Pause();

    m_pPauseSem->Signal();
    m_pSleepSem->Signal();

   //Debug_v("Clear PMO");
   Clear();

   delete m_pLmc;
}

Error PhysicalMediaOutput::SetUrl(const std::string& url)
{
#ifdef IPV6
//    printf("Zinf-IPv6: url %s\n", url);
#endif	

    m_pMutex->Acquire();

    assert(m_pLmc != NULL);

    Error eRet = m_pLmc->SetUrl( url );

    m_pMutex->Release();

    // now we have to get a new output buffer
    if (!IsError(eRet))
      {
        eRet = m_pLmc->GetOutputBuffer( &m_pInputBuffer );
      }

    return eRet;
}

void PhysicalMediaOutput::SetLMC(LogicalMediaConverter *pLMC)
{
    m_pMutex->Acquire();

    m_pLmc = pLMC;

    m_pMutex->Release();
}

void PhysicalMediaOutput::SetPMI(PhysicalMediaInput *pPMI)
{
    m_pMutex->Acquire();

    m_pPmi = pPMI;

    m_pMutex->Release();
}

// why does this not also pause Lmc and Pmi?
void PhysicalMediaOutput::Pause(void)
{
    PipelineUnit::Pause();
    // debug! m_pPmi->PauseLoop(true);
    Reset(true);
}

void PhysicalMediaOutput::Resume(void)
{
    if (m_pPmi->PauseLoop(false))
    {
        m_pLmc->Pause();
        m_pLmc->Clear();
        m_pLmc->Resume();
    }

    PipelineUnit::Resume();
}

void PhysicalMediaOutput::PreBuffer(void)
{
    m_pLmc->Wake();
    CheckForBufferUp();
    usleep(m_iPreBuffer * 1000);
}

bool PhysicalMediaOutput::WasteTime()
{
    usleep(1000);

    return m_bExit || m_bPause;
}       

Error PhysicalMediaOutput::ChangePosition(int32_t position)
{
   Error     error = kError_NoErr;
   bool      bWasPaused = m_bPause;

   if (m_pPmi->IsStreaming())
      return kError_FileSeekNotSupported;

   m_pMutex->Acquire();

   //Debug_v("Pause PMO");
   Pause();
   //Debug_v("Pause LMC");
   m_pLmc->Pause();

   //Debug_v("Change pos");
   error = m_pLmc->ChangePosition(position);
   if( !IsError( error ) )
     {
       //Debug_v("Clear PMO");
       Clear();
       //Debug_v("Clear LMC");
       m_pLmc->Clear();
     }

   //Debug_v("Resume LMC");
   m_pLmc->Resume();

   if (!bWasPaused)
   {
      //Debug_v("Resume PMO");
      Resume();
   }   

   m_pMutex->Release();

   return error;
}  

void PhysicalMediaOutput::UpdateBufferStatus(void)
{
   if (m_pLmc->GetInputBuffer() == NULL ||
       m_pInputBuffer == NULL)
      return;

   time_t iNow;

   time(&iNow);
   if (iNow != m_iBufferUpdate)
   {
       m_pTarget->AcceptEvent(new StreamBufferEvent(false, 
                         m_pLmc->GetInputBuffer()->GetBufferPercentage(), 
                         m_pInputBuffer->GetBufferPercentage()));
       m_iBufferUpdate = iNow;
   }
}

void PhysicalMediaOutput::CheckForBufferUp(bool bForceBufferUp)
{
   int iInPercent, iOutPercent;

   if (!m_pPmi->IsStreaming() || 
       m_pLmc->GetInputBuffer() == NULL ||
       m_pLmc->GetInputBuffer()->IsEndOfStream() || 
       m_pInputBuffer == NULL)
      return;

   iInPercent  = m_pLmc->GetInputBuffer()->GetBufferPercentage(); 
   iOutPercent = m_pInputBuffer->GetBufferPercentage();

   if (bForceBufferUp || (iOutPercent <= 5 && iInPercent <= 5))
   {
       for(; !m_bExit && iInPercent < 75;)
       {
           usleep(500000);
           iInPercent  = m_pLmc->GetInputBuffer()->GetBufferPercentage(); 
           iOutPercent = m_pInputBuffer->GetBufferPercentage(); 
           m_pTarget->AcceptEvent(new StreamBufferEvent(true, 
                                  iInPercent, iOutPercent)); 
           if (m_pLmc->GetInputBuffer()->IsEndOfStream())
              break;
       }
   }
}

void PhysicalMediaOutput::ReportError(const char * format, ...)
{
    assert(m_pTarget);

    char szBuffer[4096];
    va_list argptr;

    va_start(argptr, format);
    vsprintf(szBuffer, format, argptr);
    va_end(argptr);

    m_pTarget->AcceptEvent(new ErrorMessageEvent(szBuffer));
    m_pTarget->AcceptEvent(new Event(INFO_DoneOutputtingDueToOutputError));
}

/* arch-tag: b67e0f0d-18f2-467f-9326-f2b3ca89e231
   (do not change this comment) */
